/** \file SplashSampleObj.cpp
 * C++ object storing the wavetables for initial impact and final droplets 
 * events occurring in splashing.
 *
 * \author Carlo Drioli (carlo.drioli@univr.it) 
 *
 * This file is part of the 'Sound Design Toolkit' (SDT)
 * Developed with the contribution of the following EU-projects:
 * 2001-2003 'SOb' http://www.soundobject.org/
 * 2006-2009 'CLOSED' http://closed.ircam.fr
 * 2008-2011 'NIW' http://www.niwproject.eu/
 *
 * Contacts: 
 * 	stefano.papetti@zhdk.ch
 * 	stefano.dellemonache@gmail.com
 *
 * Complete list of authors (either programmers or designers):
 * 	Federico Avanzini (avanzini@dei.unipd.it)
 *	Nicola Bernardini (nicb@sme-ccppd.org)
 *	Gianpaolo Borin (gianpaolo.borin@tin.it)
 *	Carlo Drioli (carlo.drioli@univr.it)
 *	Stefano Delle Monache (stefano.dellemonache@gmail.com)
 *	Delphine Devallez
 *	Federico Fontana (federico.fontana@uniud.it)
 *	Laura Ottaviani
 *	Stefano Papetti (stefano.papetti@zhdk.ch)
 *	Pietro Polotti (pietro.polotti@univr.it)
 *	Matthias Rath
 *	Davide Rocchesso (roc@iuav.it)
 *	Stefania Serafin (sts@media.aau.dk)
 *
 * The SDT is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * The SDT is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the SDT; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *****************************************************************************/

//#include <flext.h>

#include "SplashSampleObj.h"
#include <stdio.h>

#include <cstring>

const int samplesFS = 44100;
const double headsample[]={1.3366699e-002,1.3214111e-002,1.3458252e-002,1.3580322e-002,1.3000488e-002,1.3763428e-002,1.3092041e-002,1.3275146e-002,1.3183594e-002,1.2420654e-002,-2.1362305e-003,-2.0751953e-003,-2.1972656e-003,-2.3498535e-003,-2.4719238e-003,-2.5024414e-003,-1.9531250e-003,-2.1667480e-003,-2.2888184e-003,-2.3498535e-003,-2.6550293e-003,-2.5024414e-003,-2.5634766e-003,-2.6550293e-003,-2.4108887e-003,-2.4414063e-003,-2.4108887e-003,-2.1362305e-003,-2.1972656e-003,-1.8920898e-003,-2.4414063e-003,-2.6245117e-003,-2.1972656e-003,-2.4414063e-003,-2.1057129e-003,-1.6174316e-003,-1.8310547e-003,-1.6784668e-003,-1.6174316e-003,-1.7700195e-003,-1.6174316e-003,-1.8005371e-003,-2.0446777e-003,-2.0751953e-003,-2.0751953e-003,-2.0141602e-003,-2.2888184e-003,-1.9836426e-003,-1.9836426e-003,-2.0446777e-003,-1.7700195e-003,-2.1667480e-003,-2.2583008e-003,-2.2277832e-003,-2.0446777e-003,-2.0446777e-003,-1.6479492e-003,-1.9531250e-003,-2.1667480e-003,-2.2888184e-003,-2.1362305e-003,-1.5869141e-003,-1.7700195e-003,-1.6784668e-003,-2.0446777e-003,-1.9531250e-003,-1.9226074e-003,-1.8005371e-003,-1.5869141e-003,-2.0141602e-003,-1.3427734e-003,-9.7656250e-004,-1.1291504e-003,-1.4038086e-003,-9.4604492e-004,-1.0681152e-003,-8.5449219e-004,-6.1035156e-004,-9.1552734e-004,-3.6621094e-004,-3.0517578e-005,-1.2207031e-004,-1.8310547e-004,-5.4931641e-004,-1.0681152e-003,-1.1901855e-003,-9.7656250e-004,-5.1879883e-004,-1.0070801e-003,-1.5258789e-003,-1.6479492e-003,-2.0141602e-003,-1.1901855e-003,-9.7656250e-004,-1.0375977e-003,-7.0190430e-004,-8.5449219e-004,-1.0681152e-003,-4.2724609e-004,-3.3569336e-004,1.2207031e-004,7.6293945e-004,1.5258789e-004,-1.5258789e-004,-8.5449219e-004,-1.1901855e-003,-1.2207031e-003,-1.3427734e-003,-9.7656250e-004,-4.5776367e-004,9.1552734e-005,6.1035156e-004,5.4931641e-004,1.2207031e-004,-3.3569336e-004,-1.1291504e-003,-7.0190430e-004,-9.1552734e-005,6.1035156e-004,9.1552734e-004,-9.1552734e-005,-6.4086914e-004,-8.8500977e-004,-8.5449219e-004,-2.4414063e-004,3.3569336e-004,3.0517578e-005,1.8310547e-004,9.7656250e-004,1.4038086e-003,1.6479492e-003,1.9836426e-003,2.1972656e-003,2.2277832e-003,1.9531250e-003,1.7089844e-003,1.4038086e-003,9.1552734e-004,2.1362305e-004,-4.5776367e-004,-7.0190430e-004,-1.0375977e-003,-2.1362305e-004,3.9672852e-004,7.3242188e-004,8.2397461e-004,3.0517578e-005,-3.0517578e-004,-4.2724609e-004,-3.6621094e-004,6.1035156e-005,1.2207031e-004,-2.1362305e-004,9.1552734e-005,-9.1552734e-005,-2.7465820e-004,1.5258789e-004,3.6621094e-004,6.4086914e-004,4.8828125e-004,5.1879883e-004,2.4414063e-004,6.1035156e-004,7.6293945e-004,4.2724609e-004,4.5776367e-004,2.7465820e-004,3.0517578e-005,4.8828125e-004,1.4648438e-003,1.6174316e-003,2.3498535e-003,2.0446777e-003,1.7395020e-003,2.8076172e-003,3.2043457e-003,3.5400391e-003,2.8686523e-003,1.4648438e-003,0.0000000e+000,-2.1362305e-004,-6.1035156e-005,-4.8828125e-004,1.1291504e-003,1.4343262e-003,1.2512207e-003,1.8615723e-003,2.3498535e-003,3.1127930e-003,3.4179688e-003,2.5329590e-003,1.8005371e-003,1.5869141e-003,1.3122559e-003,1.8920898e-003,3.0822754e-003,2.6855469e-003,2.7465820e-003,2.5329590e-003,1.8310547e-003,2.4108887e-003,2.7465820e-003,3.0517578e-003,2.9907227e-003,2.8381348e-003,2.8076172e-003,3.4790039e-003,3.8452148e-003,3.5095215e-003,3.0822754e-003,2.5329590e-003,2.2888184e-003,2.5024414e-003,3.5400391e-003,3.5705566e-003,3.6315918e-003,2.5024414e-003,6.1035156e-005,-5.4931641e-004,-1.3732910e-003,-7.9345703e-004,1.1291504e-003,1.5258789e-003,1.6784668e-003,1.0070801e-003,-8.8500977e-004,-9.4604492e-004,-1.0375977e-003,-1.0375977e-003,-1.1901855e-003,-3.0212402e-003,-4.4250488e-003,-5.1269531e-003,-5.2185059e-003,-4.6691895e-003,-4.2724609e-003,-4.2114258e-003,-3.6315918e-003,-1.9836426e-003,3.6621094e-004,1.5869141e-003,3.4484863e-003,2.8991699e-003,3.0517578e-004,-5.1879883e-004,-1.3732910e-003,-1.3732910e-003,2.7465820e-004,-2.4414063e-004,-3.9672852e-004,2.7465820e-004,5.7983398e-004,3.1433105e-003,5.0964355e-003,4.7607422e-003,3.3264160e-003,7.6293945e-004,-1.2817383e-003,-2.1362305e-004,1.8310547e-003,2.4719238e-003,2.6245117e-003,4.5776367e-004,-1.3427734e-003,-2.1362305e-004,1.1596680e-003,3.5705566e-003,4.9438477e-003,3.4790039e-003,9.1552734e-004,-1.0070801e-003,-2.4414063e-003,-3.1738281e-003,-3.0517578e-003,-4.2419434e-003,-4.4250488e-003,-3.9978027e-003,-2.8991699e-003,-3.9672852e-004,1.5258789e-003,1.2512207e-003,-1.2207031e-004,-2.2583008e-003,-5.1574707e-003,-5.5236816e-003,-5.3100586e-003,-6.6223145e-003,-7.6904297e-003,-1.0192871e-002,-1.1779785e-002,-1.0681152e-002,-9.3994141e-003,-7.6599121e-003,-6.5002441e-003,-7.6293945e-003,-9.3078613e-003,-1.0192871e-002,-9.5214844e-003,-7.6599121e-003,-6.1950684e-003,-7.3242188e-003,-9.0942383e-003,-1.0498047e-002,-1.2115479e-002,-1.0833740e-002,-9.6740723e-003,-1.0406494e-002,-1.1230469e-002,-1.3427734e-002,-1.5808105e-002,-1.5350342e-002,-1.4434814e-002,-1.4373779e-002,-1.3488770e-002,-1.4709473e-002,-1.5441895e-002,-1.3427734e-002,-1.1077881e-002,-8.6669922e-003,-6.6528320e-003,-7.5378418e-003,-9.4909668e-003,-1.0711670e-002,-1.3092041e-002,-1.3763428e-002,-1.3793945e-002,-1.5655518e-002,-1.6235352e-002,-1.5472412e-002,-1.3763428e-002,-9.8876953e-003,-6.2255859e-003,-6.1340332e-003,-7.2021484e-003,-8.9111328e-003,-1.1352539e-002,-9.7656250e-003,-7.4768066e-003,-7.9040527e-003,-7.5988770e-003,-1.0681152e-002,-1.3580322e-002,-1.1901855e-002,-9.3078613e-003,-5.4321289e-003,-1.2817383e-003,-1.2512207e-003,-3.1433105e-003,-3.2043457e-003,-5.4931641e-003,-5.8288574e-003,-5.6152344e-003,-7.7819824e-003,-8.3312988e-003,-9.3383789e-003,-6.9885254e-003,-4.0283203e-003,-7.9345703e-004,-3.0517578e-004,-1.8005371e-003,-3.7536621e-003,-7.5378418e-003,-8.2092285e-003,-8.3007813e-003,-8.7280273e-003,-8.4838867e-003,-1.0101318e-002,-1.2481689e-002,-1.3793945e-002,-1.4587402e-002,-1.4801025e-002,-1.4709473e-002,-1.4892578e-002,-1.4862061e-002,-1.3610840e-002,-1.1749268e-002,-1.0101318e-002,-9.0026855e-003,-1.0803223e-002,-1.3305664e-002,-1.5258789e-002,-1.6998291e-002,-1.5991211e-002,-1.3732910e-002,-1.1901855e-002,-9.7351074e-003,-9.9487305e-003,-1.0894775e-002,-1.1260986e-002,-1.2420654e-002,-1.1077881e-002,-1.0070801e-002,-1.0101318e-002,-9.4299316e-003,-9.8876953e-003,-9.3078613e-003,-9.0637207e-003,-9.0637207e-003,-9.5825195e-003,-1.0498047e-002,-1.0498047e-002,-9.5825195e-003,-7.7819824e-003,-5.5847168e-003,-5.5541992e-003,-6.3476563e-003,-6.1035156e-003,-7.2326660e-003,-4.9133301e-003,-3.7536621e-003,-3.4484863e-003,-1.9836426e-003,-3.6315918e-003,-4.8217773e-003,-5.0048828e-003,-5.8898926e-003,-9.0332031e-003,-1.1871338e-002,-1.5289307e-002,-1.7028809e-002,-1.4373779e-002,-9.2163086e-003,-4.3334961e-003,2.7465820e-004,1.4648438e-003,-9.1552734e-005,1.0375977e-003,8.5449219e-004,1.7089844e-003,2.8686523e-003,-5.1879883e-004,-3.7841797e-003,-6.8054199e-003,-9.9182129e-003,-1.0955811e-002,-1.0314941e-002,-1.0223389e-002,-8.3923340e-003,-6.3781738e-003,-4.9438477e-003,-2.8686523e-003,-2.6245117e-003,-2.1667480e-003,-2.5939941e-003,-2.2277832e-003,-9.1552734e-004,-1.1291504e-003,-1.0681152e-003,-2.5024414e-003,-4.5471191e-003,-6.0119629e-003,-7.9345703e-003,-8.1481934e-003,-7.7514648e-003,-6.4697266e-003,-5.7678223e-003,-7.4768066e-003,-1.0314941e-002,-1.4007568e-002,-1.7700195e-002,-1.7089844e-002,-1.3854980e-002,-1.1016846e-002,-6.3171387e-003,-6.0119629e-003,-7.2631836e-003,-5.6762695e-003,-7.0190430e-003,-5.0964355e-003,-3.8452148e-003,-6.4086914e-003,-7.2631836e-003,-6.8969727e-003,-6.5002441e-003,-7.0190430e-003,-8.9416504e-003,-1.4801025e-002,-1.9561768e-002,-1.7059326e-002,-1.1566162e-002,-5.1269531e-003,1.4038086e-003,-3.3264160e-003,-1.0589600e-002,-1.0559082e-002,-1.1047363e-002,-5.0659180e-003,1.0070801e-003,-6.5612793e-003,-1.4587402e-002,-1.9836426e-002,-2.5756836e-002,-2.2552490e-002,-2.1301270e-002,-3.4881592e-002,-5.1849365e-002,-6.9213867e-002,-8.5815430e-002,-8.4869385e-002,-7.8216553e-002,-7.9528809e-002,-7.8125000e-002,-8.5632324e-002,-9.5245361e-002,-9.1186523e-002,-8.7860107e-002,-8.3190918e-002,-7.6629639e-002,-7.9101563e-002,-8.3129883e-002,-8.4838867e-002,-8.8989258e-002,-9.2102051e-002,-9.2895508e-002,-9.2681885e-002,-8.8928223e-002,-8.1542969e-002,-7.5042725e-002,-7.4829102e-002,-7.8155518e-002,-8.0749512e-002,-8.6029053e-002,-8.4899902e-002,-8.1756592e-002,-8.6791992e-002,-8.9721680e-002,-9.4757080e-002,-9.7717285e-002,-9.2468262e-002,-8.5693359e-002,-8.2763672e-002,-8.0291748e-002,-8.0627441e-002,-8.3740234e-002,-8.0322266e-002,-7.9772949e-002,-8.2275391e-002,-8.3465576e-002,-8.7524414e-002,-8.9630127e-002,-8.7982178e-002,-8.5174561e-002,-8.5662842e-002,-8.5784912e-002,-8.7066650e-002,-8.8256836e-002,-8.3862305e-002,-7.9986572e-002,-7.7758789e-002,-7.6202393e-002,-7.7423096e-002,-8.0047607e-002,-8.1085205e-002,-8.3526611e-002,-8.6456299e-002,-8.6944580e-002,-8.4991455e-002,-7.9711914e-002,-7.3730469e-002,-6.9549561e-002,-7.1777344e-002,-7.7423096e-002,-8.0535889e-002,-8.3465576e-002,-7.8735352e-002,-7.0709229e-002,-6.7413330e-002,-6.2957764e-002,-6.2988281e-002,-6.4941406e-002,-6.4147949e-002,-6.6711426e-002,-6.8176270e-002,-6.9122314e-002,-7.0831299e-002,-7.1655273e-002,-7.2235107e-002,-7.3059082e-002,-7.2357178e-002,-7.0922852e-002,-6.6986084e-002,-6.1248779e-002,-5.9509277e-002,-5.9814453e-002,-5.9967041e-002,-6.0699463e-002,-5.7342529e-002,-5.3863525e-002,-5.8776855e-002,-6.6375732e-002,-7.6202393e-002,-8.4808350e-002,-7.9895020e-002,-7.0709229e-002,-6.6497803e-002,-6.2561035e-002,-6.8756104e-002,-7.6782227e-002,-6.8237305e-002,-5.7312012e-002,-4.3029785e-002,-2.9449463e-002,-3.6529541e-002,-4.8889160e-002,-5.6182861e-002,-6.3720703e-002,-5.8197021e-002,-4.7210693e-002,-4.8217773e-002,-4.7943115e-002,-5.2368164e-002,-6.0638428e-002,-5.9112549e-002,-5.9661865e-002,-5.9295654e-002,-5.7250977e-002,-5.6121826e-002,-5.3802490e-002,-5.1391602e-002,-5.1025391e-002,-5.5480957e-002,-6.1187744e-002,-6.5124512e-002,-6.5887451e-002,-6.2011719e-002,-5.3161621e-002,-4.4952393e-002,-3.6285400e-002,-3.1372070e-002,-3.1677246e-002,-3.3569336e-002,-3.9276123e-002,-4.0252686e-002,-3.9886475e-002,-3.6804199e-002,-3.2623291e-002,-3.5278320e-002,-3.9062500e-002,-4.3884277e-002,-4.8522949e-002,-4.5501709e-002,-4.1534424e-002,-4.1687012e-002,-4.1442871e-002,-4.2633057e-002,-4.3395996e-002,-3.7536621e-002,-3.1829834e-002,-3.2135010e-002,-3.3386230e-002,-3.6224365e-002,-4.0069580e-002,-3.4912109e-002,-2.9266357e-002,-3.1982422e-002,-3.5430908e-002,-4.3029785e-002,-5.1391602e-002,-4.6752930e-002,-4.0161133e-002,-3.6773682e-002,-3.1585693e-002,-3.4637451e-002,-3.9367676e-002,-3.5888672e-002,-3.4729004e-002,-3.4820557e-002,-3.4027100e-002,-3.8879395e-002,-4.2327881e-002,-4.1015625e-002,-4.0466309e-002,-4.3426514e-002,-4.6051025e-002,-5.0231934e-002,-5.2581787e-002,-4.4769287e-002,-3.6163330e-002,-3.0578613e-002,-2.6367188e-002,-3.0822754e-002,-3.9825439e-002,-4.4494629e-002,-4.9743652e-002,-5.0292969e-002,-4.5013428e-002,-4.1717529e-002,-3.6804199e-002,-4.0039063e-002,-4.9591064e-002,-6.0974121e-002,-7.2235107e-002,-6.4849854e-002,-5.0384521e-002,-3.3782959e-002,-1.5747070e-002,-1.9744873e-002,-2.9937744e-002,-3.1677246e-002,-3.6712646e-002,-2.9052734e-002,-2.0172119e-002,-2.8472900e-002,-3.2897949e-002,-3.3203125e-002,-2.9510498e-002,-1.5533447e-002,-5.1574707e-003,-1.6418457e-002,-3.2470703e-002,-3.9794922e-002,-4.3792725e-002,-2.4749756e-002,-2.1057129e-003,-5.1879883e-003,-1.0833740e-002,-2.2430420e-002,-3.5308838e-002,-2.0812988e-002,-6.2561035e-003,-9.4604492e-003,-1.3671875e-002,-3.1311035e-002,-4.7821045e-002,-3.8848877e-002,-2.9144287e-002,-2.9602051e-002,-3.2287598e-002,-4.9255371e-002,-6.6253662e-002,-5.7586670e-002,-4.4036865e-002,-3.2409668e-002,-1.7425537e-002,-2.0568848e-002,-2.6062012e-002,-1.8066406e-002,-1.5930176e-002,-1.4831543e-002,-1.5380859e-002,-2.6794434e-002,-3.2348633e-002,-2.3742676e-002,-1.1047363e-002,-2.0141602e-003,3.7841797e-003,-3.9367676e-003,-1.4923096e-002,-1.2329102e-002,-1.3061523e-002,-1.1810303e-002,-1.3458252e-002,-2.7679443e-002,-3.8238525e-002,-3.6560059e-002,-2.8564453e-002,-1.9744873e-002,-1.3458252e-002,-2.5817871e-002,-4.4799805e-002,-5.4382324e-002,-6.1859131e-002,-4.9835205e-002,-2.8442383e-002,-1.7486572e-002,-5.3405762e-003,-8.4838867e-003,-1.9531250e-002,-1.8890381e-002,-1.7608643e-002,1.8310547e-004,2.6763916e-002,4.1229248e-002,5.3588867e-002,4.5257568e-002,2.3681641e-002,1.1810303e-002,-3.9062500e-003,-8.3618164e-003,-6.4697266e-003,-1.9744873e-002,-3.0883789e-002,-4.3090820e-002,-5.3497314e-002,-4.7180176e-002,-3.5858154e-002,-2.5695801e-002,-1.4190674e-002,-4.3334961e-003,4.3334961e-003,1.9744873e-002,3.2348633e-002,3.2745361e-002,2.6275635e-002,1.2969971e-002,3.0517578e-005,3.5400391e-003,1.6876221e-002,2.5390625e-002,3.0853271e-002,1.2512207e-002,-2.1301270e-002,-4.3701172e-002,-6.6619873e-002,-6.4025879e-002,-4.9438477e-002,-4.9530029e-002,-4.6142578e-002,-5.4351807e-002,-6.1492920e-002,-3.8055420e-002,-3.1127930e-003,4.4036865e-002,9.6527100e-002,1.1788940e-001,1.2582397e-001,1.2622070e-001,1.0943604e-001,1.0778809e-001,1.0317993e-001,9.0362549e-002,8.7036133e-002,7.2418213e-002,5.7647705e-002,3.8360596e-002,6.4697266e-003,-2.8198242e-002,-6.3995361e-002,-7.5805664e-002,-7.2723389e-002,-5.9570313e-002,-3.9978027e-002,-4.8736572e-002,-6.0180664e-002,-5.5541992e-002,-4.5501709e-002,-6.4697266e-003,3.5095215e-002,3.9276123e-002,3.7139893e-002,3.0578613e-002,2.3956299e-002,5.5236816e-002,8.3496094e-002,7.0373535e-002,4.3243408e-002,9.4604492e-004,-3.2867432e-002,9.8571777e-003,7.9193115e-002,1.2731934e-001,1.6851807e-001,1.3366699e-001,6.7840576e-002,5.6823730e-002,4.5013428e-002,7.4218750e-002,1.2271118e-001,9.6405029e-002,6.6467285e-002,2.5451660e-002,-2.9815674e-002,-3.5064697e-002,-3.3691406e-002,-4.0588379e-002,-3.3050537e-002,-3.3111572e-002,-2.9998779e-002,-7.8125000e-003,8.8500977e-003,2.2399902e-002,3.7231445e-002,5.5328369e-002,7.6660156e-002,9.7229004e-002,1.1245728e-001,1.0000610e-001,7.9589844e-002,6.4208984e-002,5.0659180e-002,5.4992676e-002,6.4544678e-002,5.6579590e-002,4.6417236e-002,3.5430908e-002,1.8310547e-002,2.0812988e-002,2.2125244e-002,1.9012451e-002,2.2186279e-002,2.5909424e-002,3.7933350e-002,5.5908203e-002,7.5317383e-002,8.0474854e-002,7.8796387e-002,7.5653076e-002,6.7443848e-002,6.6711426e-002,6.2042236e-002,4.4403076e-002,2.6519775e-002,1.3458252e-002,7.9956055e-003,2.4261475e-002,5.0476074e-002,6.8115234e-002,8.1909180e-002,8.1329346e-002,6.6070557e-002,5.6304932e-002,3.9611816e-002,2.7099609e-002,2.5573730e-002,2.4322510e-002,3.6956787e-002,4.2358398e-002,4.6173096e-002,4.1046143e-002,2.7801514e-002,3.1707764e-002,3.5430908e-002,5.1727295e-002,6.8023682e-002,6.1340332e-002,5.1544189e-002,4.1351318e-002,3.4271240e-002,5.0628662e-002,7.3211670e-002,7.7392578e-002,8.0535889e-002,6.4971924e-002,4.6203613e-002,5.6274414e-002,6.8725586e-002,8.7463379e-002,1.0388184e-001,8.4930420e-002,5.5786133e-002,3.7994385e-002,2.3925781e-002,4.7637939e-002,8.5540771e-002,9.9731445e-002,1.0879517e-001,8.1237793e-002,3.5095215e-002,1.8524170e-002,6.0729980e-003,1.9866943e-002,5.0476074e-002,4.6752930e-002,4.1961670e-002,2.6672363e-002,3.2348633e-003,1.5838623e-002,3.3874512e-002,5.1330566e-002,7.3181152e-002,7.3272705e-002,6.8603516e-002,7.7850342e-002,8.3129883e-002,8.7005615e-002,8.6273193e-002,6.3964844e-002,4.1687012e-002,3.7902832e-002,4.5104980e-002,6.4514160e-002,8.9324951e-002,8.2275391e-002,6.3262939e-002,4.6752930e-002,2.3986816e-002,3.6743164e-002,5.7586670e-002,6.4025879e-002,7.3333740e-002,5.8746338e-002,3.7841797e-002,3.7353516e-002,3.8421631e-002,4.8065186e-002,6.3629150e-002,5.8288574e-002,4.9865723e-002,4.4158936e-002,3.4423828e-002,4.1778564e-002,5.3192139e-002,5.8837891e-002,6.7871094e-002,6.6131592e-002,5.9631348e-002,5.8227539e-002,5.3802490e-002,5.3649902e-002,5.5694580e-002,5.1055908e-002,4.8248291e-002,4.5684814e-002,4.5318604e-002,5.0872803e-002,5.6213379e-002,5.5755615e-002,5.0018311e-002,4.2297363e-002,3.4423828e-002,4.0466309e-002,5.3161621e-002,6.4849854e-002,7.7484131e-002,7.3699951e-002,6.3415527e-002,5.7891846e-002,5.0354004e-002,5.3771973e-002,6.2622070e-002,6.3812256e-002,6.7199707e-002,6.2561035e-002,5.1361084e-002,4.3121338e-002,3.2440186e-002,3.1036377e-002,4.0740967e-002,6.0119629e-002,8.5296631e-002,9.5214844e-002,9.2864990e-002,7.3822021e-002,4.3365479e-002,3.3508301e-002,2.9541016e-002,3.5766602e-002,5.4595947e-002,4.9560547e-002,4.5867920e-002,4.2999268e-002,3.2989502e-002,4.1137695e-002,4.5745850e-002,4.5104980e-002,4.7698975e-002,4.7668457e-002,4.9407959e-002,5.5023193e-002,5.7434082e-002,5.0933838e-002,4.4921875e-002,4.1870117e-002,4.2449951e-002,5.0201416e-002,5.6488037e-002,5.1147461e-002,4.2572021e-002,3.5888672e-002,3.0548096e-002,3.9062500e-002,5.0384521e-002,5.2886963e-002,5.6030273e-002,5.5908203e-002,5.5358887e-002,6.6955566e-002,7.6080322e-002,7.2021484e-002,6.1614990e-002,4.0740967e-002,1.9287109e-002,1.8524170e-002,2.7008057e-002,3.7200928e-002,5.2124023e-002,4.5318604e-002,3.1799316e-002,2.9418945e-002,2.3193359e-002,3.3538818e-002,4.4677734e-002,3.6560059e-002,2.6489258e-002,1.1077881e-002,-2.9907227e-003,5.8593750e-003,2.1606445e-002,2.5665283e-002,3.0731201e-002,1.7639160e-002,-2.5329590e-003,-1.2512207e-003,-3.6621094e-004,3.2958984e-003,1.2023926e-002,1.2176514e-002,2.3895264e-002,6.1157227e-002,9.9395752e-002,1.1401367e-001,1.0171509e-001,4.2816162e-002,-2.7893066e-002,-3.1921387e-002,-5.4931641e-004,6.2957764e-002,1.3781738e-001,9.7167969e-002,1.3061523e-002,-6.8359375e-002,-1.5963745e-001,-1.1398315e-001,-1.8341064e-002,3.9703369e-002,1.1361694e-001,8.0291748e-002,5.6457520e-003,-7.2937012e-003,-4.0466309e-002,-2.1331787e-002,2.3468018e-002,1.4190674e-002,2.5909424e-002,3.0456543e-002,2.6641846e-002,3.8909912e-002,3.5614014e-002,1.9836426e-002,2.2583008e-003,5.5236816e-003,1.4404297e-002,2.4078369e-002,3.3386230e-002,1.0955811e-002,-1.2603760e-002,-1.2481689e-002,-6.3476563e-003,1.7761230e-002,4.7119141e-002,4.1259766e-002,2.9022217e-002,1.7974854e-002,-4.2419434e-003,-5.9509277e-003,-5.3710938e-003,-1.6357422e-002,-1.2329102e-002,-7.6293945e-004,1.8371582e-002,4.7271729e-002,6.8511963e-002,6.8572998e-002,5.2673340e-002,3.2012939e-002,8.8500977e-004,-1.5594482e-002,-2.1820068e-002,-2.2125244e-002,3.2348633e-003,2.9449463e-002,6.1218262e-002,7.3883057e-002,5.9051514e-002,2.8717041e-002,-2.5512695e-002,-5.1513672e-002,-6.4971924e-002,-5.8410645e-002,-2.1881104e-002,-2.2277832e-003,2.9022217e-002,4.9102783e-002,4.8400879e-002,4.0893555e-002,4.9743652e-003,-2.7282715e-002,-5.6884766e-002,-5.7983398e-002,-2.7679443e-002,-1.5258789e-004,4.2846680e-002,5.2612305e-002,4.5989990e-002,4.6081543e-002,2.4993896e-002,2.4230957e-002,1.8310547e-002,2.7160645e-003,-3.7231445e-003,-1.3183594e-002,-9.7656250e-003,1.5258789e-004,1.5655518e-002,2.0812988e-002,1.6174316e-002,8.6364746e-003,-1.0986328e-002,-1.8463135e-002,-2.3468018e-002,-2.6916504e-002,-2.0629883e-002,-2.0172119e-002,-1.4129639e-002,-1.0375977e-002,-6.9580078e-003,1.2207031e-003,8.4228516e-003,1.6967773e-002,2.0355225e-002,1.4495850e-002,1.0375977e-003,-1.5411377e-002,-3.1372070e-002,-3.2897949e-002,-2.1911621e-002,-4.7912598e-003,2.0355225e-002,2.9602051e-002,2.7435303e-002,1.3671875e-002,-1.6967773e-002,-3.2348633e-002,-4.2938232e-002,-3.5064697e-002,-8.0871582e-003,5.4016113e-003,2.2247314e-002,1.9683838e-002,3.9062500e-003,-5.1879883e-004,-1.4129639e-002,-1.6632080e-002,-1.6265869e-002,-2.2888184e-002,-2.0111084e-002,-1.6204834e-002,-7.2631836e-003,-8.2397461e-004,-1.7395020e-003,-1.3122559e-002,-3.1341553e-002,-3.4515381e-002,-3.1555176e-002,-1.8829346e-002,1.4648438e-003,7.0190430e-004,-3.7841797e-003,-1.0620117e-002,-2.4597168e-002,-2.0690918e-002,-1.4892578e-002,-1.3488770e-002,-5.8898926e-003,-4.3029785e-003,-9.4604492e-004,6.3476563e-003,8.2397461e-003,3.3264160e-003,-6.6528320e-003,-1.5930176e-002,-2.2888184e-002,-1.9561768e-002,-8.8500977e-003,-5.2490234e-003,-2.1362305e-004,-3.2043457e-003,-1.2451172e-002,-1.3488770e-002,-1.7517090e-002,-1.5838623e-002,-1.1169434e-002,-1.2176514e-002,-1.1199951e-002,-1.3580322e-002,-1.5045166e-002,-7.0495605e-003,3.5400391e-003,1.4251709e-002,2.1331787e-002,9.0026855e-003,-1.1840820e-002,-2.6611328e-002,-3.7200928e-002,-2.1606445e-002,5.1574707e-003,1.3000488e-002,1.8188477e-002,-6.4086914e-004,-2.9998779e-002,-2.6794434e-002,-2.1667480e-002,-5.6457520e-003,1.7761230e-002,7.0800781e-003,-6.4697266e-003,-1.2329102e-002,-2.1636963e-002,-8.8806152e-003,7.4462891e-003,3.2043457e-003,-4.8828125e-004,-8.3007813e-003,-1.7944336e-002,-8.0566406e-003,2.9602051e-003,2.0751953e-003,1.0070801e-003,-9.0637207e-003,-2.2125244e-002,-2.0050049e-002,-1.5594482e-002,-1.1199951e-002,-1.4953613e-003,1.6784668e-003,3.4484863e-003,8.5449219e-003,6.2866211e-003,-1.9531250e-003,-1.5106201e-002,-2.6702881e-002,-3.2806396e-002,-2.5604248e-002,-7.7514648e-003,2.7465820e-003,1.2207031e-002,8.1176758e-003,-8.7280273e-003,-1.6815186e-002,-2.8472900e-002,-3.0853271e-002,-2.4536133e-002,-2.3284912e-002,-1.5869141e-002,-1.1901855e-002,-1.0101318e-002,-9.1247559e-003,-1.2817383e-002,-1.4495850e-002,-1.6479492e-002,-1.1810303e-002,-4.9743652e-003,-3.5400391e-003,-3.0212402e-003,-9.8876953e-003,-1.7181396e-002,-1.4129639e-002,-6.6833496e-003,3.5705566e-003,1.4739990e-002,1.3397217e-002,6.0424805e-003,-4.2724609e-004,-1.1993408e-002,-1.8768311e-002,-2.4078369e-002,-3.1372070e-002,-2.9632568e-002,-1.7364502e-002,2.0751953e-003,1.7272949e-002,2.2674561e-002,5.7983398e-003,-2.4658203e-002,-3.6285400e-002,-4.0954590e-002,-2.3681641e-002,4.8828125e-003,1.0375977e-003,-4.2419434e-003,-1.2512207e-002,-2.2277832e-002,-5.1879883e-004,1.7974854e-002,1.1627197e-002,-5.0354004e-003,-3.3691406e-002,-5.7830811e-002,-3.6224365e-002,9.7656250e-004,2.0416260e-002,3.6499023e-002,1.0864258e-002,-2.9846191e-002,-3.1555176e-002,-3.3325195e-002,-1.8707275e-002,7.2021484e-003,-3.9672852e-003,-1.1566162e-002,-9.4604492e-003,-1.2176514e-002,6.1035156e-005,7.7819824e-003,-2.4108887e-003,-1.1749268e-002,-1.1596680e-002,-9.7656250e-003,-2.7465820e-003,3.3874512e-003,-6.8969727e-003,-1.5747070e-002,-1.0925293e-002,-5.0659180e-003,2.4414063e-003,6.0119629e-003,-9.2163086e-003,-2.5604248e-002,-2.3284912e-002,-1.6174316e-002,-4.1198730e-003,9.3078613e-003,-1.3732910e-003,-1.4373779e-002,-1.3427734e-002,-1.3458252e-002,-4.1809082e-003,4.6081543e-003,-5.7678223e-003,-1.4221191e-002,-1.0833740e-002,-5.4016113e-003,5.8288574e-003,1.4343262e-002,1.2512207e-003,-1.5930176e-002,-1.9439697e-002,-2.2552490e-002,-1.2634277e-002,1.9836426e-003,-3.9367676e-003,-7.5378418e-003,-4.8217773e-003,-4.0283203e-003,5.0659180e-003,9.2773438e-003,-2.8686523e-003,-1.7486572e-002,-2.3742676e-002,-2.5726318e-002,-1.5655518e-002,-9.1552734e-005,7.9345703e-004,1.2817383e-003,1.8005371e-003,-3.3264160e-003,-2.7160645e-003,-5.9204102e-003,-1.3854980e-002,-1.8737793e-002,-1.6082764e-002,-7.6904297e-003,-1.5563965e-003,4.6081543e-003,3.0517578e-005,-8.2397461e-003,-5.6152344e-003,-4.7912598e-003,-3.5095215e-003,-2.1972656e-003,-1.1474609e-002,-2.0111084e-002,-1.6693115e-002,-1.0559082e-002,-3.7536621e-003,4.8522949e-003,1.7700195e-003,-4.1503906e-003,-2.5024414e-003,-6.7443848e-003,-1.1169434e-002,-1.4923096e-002,-2.1087646e-002,-1.9134521e-002,-4.3334961e-003,1.3854980e-002,1.8798828e-002,1.5625000e-002,-3.0517578e-004,-2.2033691e-002,-1.7486572e-002,-8.1787109e-003,-1.6479492e-003,9.6435547e-003,-3.2653809e-003,-1.8280029e-002,-1.1749268e-002,-6.0424805e-003,4.6997070e-003,1.5563965e-002,1.7700195e-003,-1.4556885e-002,-1.6204834e-002,-1.7120361e-002,-5.5541992e-003,9.7656250e-003,3.3874512e-003,-2.7770996e-003,-3.3264160e-003,-6.9274902e-003,9.7656250e-004,7.5683594e-003,6.1035156e-005,-6.7443848e-003,-8.8806152e-003,-1.0284424e-002,-2.3498535e-003,7.3547363e-003,3.4179688e-003,-4.5776367e-004,-3.3874512e-003,-9.0942383e-003,-4.7302246e-003,1.0986328e-003,2.7465820e-004,3.2348633e-003,6.5307617e-003,9.5214844e-003,1.5686035e-002,1.7913818e-002,1.2847900e-002,5.0964355e-003,-6.1035156e-004,-6.1340332e-003,-4.9438477e-003,1.5563965e-003,5.7678223e-003,1.3214111e-002,1.5960693e-002,1.2390137e-002,4.8217773e-003,-8.7280273e-003,-1.4953613e-002,-1.4892578e-002,-4.7912598e-003,1.1260986e-002,1.2451172e-002,9.8266602e-003,1.4648438e-003,-9.9487305e-003,-2.7465820e-003,6.5307617e-003,9.6130371e-003,1.2268066e-002,4.3334961e-003,-2.6855469e-003,8.4533691e-003,2.0202637e-002,2.4383545e-002,2.4505615e-002,6.6223145e-003,-1.2176514e-002,-5.9204102e-003,6.2866211e-003,1.8798828e-002,3.1372070e-002,1.1901855e-002,-1.3183594e-002,-1.5777588e-002,-1.5136719e-002,7.9345703e-003,3.6499023e-002,2.8198242e-002,1.2847900e-002,-1.9226074e-003,-2.0721436e-002,-4.5776367e-003,1.8890381e-002,2.0355225e-002,2.3162842e-002,8.8195801e-003,-9.8876953e-003,1.9836426e-003,1.5533447e-002,2.2491455e-002,2.9510498e-002,1.1566162e-002,-1.0711670e-002,-7.4768066e-003,-2.1362305e-004,1.6235352e-002,3.7719727e-002,2.8015137e-002,1.1871338e-002,3.6926270e-003,-7.9650879e-003,5.7373047e-003,2.7496338e-002,2.9479980e-002,3.1341553e-002,1.9897461e-002,2.4108887e-003,7.0495605e-003,1.4038086e-002,1.9226074e-002,2.7160645e-002,1.8402100e-002,6.3781738e-003,7.6904297e-003,9.0942383e-003,1.9531250e-002,3.3142090e-002,2.8869629e-002,2.0446777e-002,1.4953613e-002,8.0871582e-003,1.5991211e-002,2.9144287e-002,2.9113770e-002,2.7648926e-002,1.7944336e-002,5.3100586e-003,1.2237549e-002,2.4353027e-002,3.2806396e-002,3.9550781e-002,2.3681641e-002,9.7656250e-004,-3.1433105e-003,-6.7138672e-004,2.0050049e-002,4.7973633e-002,4.5471191e-002,3.3142090e-002,1.4953613e-002,-8.3007813e-003,4.2114258e-003,2.5970459e-002,3.5644531e-002,4.5898438e-002,2.7099609e-002,3.0212402e-003,7.5378418e-003,1.6876221e-002,3.5369873e-002,5.4656982e-002,3.8360596e-002,1.4648438e-002,6.1950684e-003,2.0751953e-003,2.5848389e-002,5.6182861e-002,5.1452637e-002,3.8970947e-002,2.0294189e-002,-1.3122559e-003,1.6510010e-002,4.1809082e-002,4.7546387e-002,5.1055908e-002,2.7252197e-002,-1.5869141e-003,5.7678223e-003,1.9927979e-002,3.6895752e-002,5.5938721e-002,3.9459229e-002,1.6387939e-002,1.4862061e-002,1.4251709e-002,3.2958984e-002,5.2490234e-002,3.7048340e-002,1.8127441e-002,9.3688965e-003,6.0119629e-003,3.4027100e-002,6.6497803e-002,6.1309814e-002,4.4830322e-002,1.7364502e-002,-1.3061523e-002,6.8969727e-003,4.1046143e-002,5.8654785e-002,7.5866699e-002,4.8919678e-002,8.6364746e-003,5.6152344e-003,4.8217773e-003,2.5756836e-002,5.5999756e-002,4.2419434e-002,2.5390625e-002,1.6693115e-002,4.9438477e-003,2.6062012e-002,4.9713135e-002,4.5104980e-002,3.7597656e-002,2.1240234e-002,3.8757324e-003,1.7395020e-002,3.5247803e-002,3.6651611e-002,3.7567139e-002,2.1636963e-002,4.3029785e-003,1.6571045e-002,3.2073975e-002,4.0527344e-002,4.6081543e-002,2.6885986e-002,3.4790039e-003,8.7585449e-003,2.1087646e-002,4.1595459e-002,6.4514160e-002,4.9560547e-002,2.4932861e-002,1.3946533e-002,2.8686523e-003,2.3590088e-002,5.2581787e-002,5.1391602e-002,4.7180176e-002,2.8930664e-002,6.5917969e-003,2.1270752e-002,4.2846680e-002,5.5816650e-002,6.8298340e-002,4.9957275e-002,2.2125244e-002,1.7486572e-002,1.4953613e-002,2.8442383e-002,4.9896240e-002,4.4738770e-002,3.7567139e-002,3.3081055e-002,2.5115967e-002,3.6590576e-002,4.9011230e-002,4.5928955e-002,4.1137695e-002,3.0639648e-002,2.0599365e-002,2.9937744e-002,4.3914795e-002,4.7332764e-002,4.8950195e-002,3.6651611e-002,2.1148682e-002,2.6092529e-002,3.4362793e-002,4.3304443e-002,5.1940918e-002,4.1137695e-002,2.7038574e-002,2.8625488e-002,3.5064697e-002,5.2246094e-002,7.0709229e-002,6.0974121e-002,4.2327881e-002,2.5115967e-002,6.5002441e-003,1.8280029e-002,4.0954590e-002,4.7882080e-002,5.5023193e-002,4.2602539e-002,2.2064209e-002,2.6794434e-002,3.2592773e-002,4.4250488e-002,5.8593750e-002,4.8126221e-002,3.6590576e-002,3.3355713e-002,2.9296875e-002,3.7200928e-002,4.6691895e-002,3.8269043e-002,3.0548096e-002,2.7160645e-002,2.6763916e-002,4.3212891e-002,6.0363770e-002,5.9326172e-002,5.2093506e-002,3.9001465e-002,2.4169922e-002,3.3508301e-002,5.0201416e-002,5.9020996e-002,6.9274902e-002,5.8532715e-002,4.0161133e-002,3.7750244e-002,3.3569336e-002,3.7048340e-002,4.4891357e-002,3.8299561e-002,3.4423828e-002,3.9123535e-002,4.5349121e-002,5.9326172e-002,7.0526123e-002,6.2927246e-002,4.9835205e-002,3.8391113e-002,2.6733398e-002,3.1738281e-002,4.4403076e-002,4.6936035e-002,5.3436279e-002,5.0750732e-002,4.3151855e-002,4.6203613e-002,4.3518066e-002,4.0191650e-002,3.7261963e-002,3.1311035e-002,2.9418945e-002,3.5430908e-002,4.5867920e-002,5.0506592e-002,5.3192139e-002,4.6417236e-002,3.3782959e-002,3.1463623e-002,2.9602051e-002,3.4759521e-002,4.5684814e-002,4.7821045e-002,5.2764893e-002,5.5450439e-002,5.2032471e-002,5.2520752e-002,4.9377441e-002,4.6081543e-002,4.5928955e-002,4.7119141e-002,5.1635742e-002,5.3344727e-002,5.3283691e-002,4.7668457e-002,4.0588379e-002,4.0588379e-002,4.3060303e-002,4.9346924e-002,5.6274414e-002,5.3741455e-002,4.7729492e-002,4.2266846e-002,3.4973145e-002,3.7841797e-002,4.3640137e-002,4.5959473e-002,5.0781250e-002,5.0170898e-002,4.7241211e-002,4.8004150e-002,4.5349121e-002,4.1717529e-002,3.8330078e-002,3.5003662e-002,3.5308838e-002,3.9733887e-002,4.6875000e-002,4.8278809e-002,4.7180176e-002,4.2419434e-002,3.3691406e-002,3.3355713e-002,3.3874512e-002,3.3142090e-002,3.4729004e-002,3.1555176e-002,3.1066895e-002,3.9947510e-002,5.0567627e-002,6.0241699e-002,6.5185547e-002,5.3009033e-002,3.1860352e-002,1.6998291e-002,6.6223145e-003,1.6601563e-002,4.3151855e-002,5.8654785e-002,7.4371338e-002,7.0037842e-002,5.0231934e-002,3.9794922e-002,2.3406982e-002,2.3986816e-002,3.4698486e-002,3.9581299e-002,5.2764893e-002,5.6854248e-002,5.7708740e-002,6.0577393e-002,5.5267334e-002,5.1940918e-002,4.3853760e-002,3.6590576e-002,3.2897949e-002,3.2165527e-002,4.0283203e-002,4.8095703e-002,5.8441162e-002,6.3507080e-002,6.1889648e-002,5.9051514e-002,4.9621582e-002,4.2907715e-002,3.7414551e-002,3.5461426e-002,4.1046143e-002,4.8522949e-002,6.0516357e-002,6.7260742e-002,6.8206787e-002,6.3018799e-002,4.9682617e-002,4.3640137e-002,4.0313721e-002,4.6295166e-002,5.9692383e-002,6.1492920e-002,6.1706543e-002,5.2337646e-002,3.7963867e-002,3.7811279e-002,4.1137695e-002,5.0781250e-002,6.4971924e-002,6.3476563e-002,5.6732178e-002,4.8858643e-002,3.6743164e-002,3.7750244e-002,4.2419434e-002,4.3426514e-002,4.9011230e-002,4.7027588e-002,4.6569824e-002,5.1177979e-002,5.2673340e-002,5.2581787e-002,4.8858643e-002,3.9581299e-002,2.9449463e-002,3.0181885e-002,3.6132813e-002,4.5471191e-002,5.7891846e-002,5.8044434e-002,5.3131104e-002,4.6630859e-002,3.4912109e-002,3.2745361e-002,3.2989502e-002,3.3020020e-002,3.8757324e-002,4.1564941e-002,4.6600342e-002,5.2093506e-002,5.4290771e-002,5.2551270e-002,4.5959473e-002,4.0405273e-002,3.4179688e-002,3.3660889e-002,3.8299561e-002,3.9733887e-002,4.4952393e-002,4.5654297e-002,4.4952393e-002,4.8217773e-002,4.7393799e-002,4.6691895e-002,4.4403076e-002,4.1168213e-002,4.0405273e-002,4.5104980e-002,5.2337646e-002,5.5297852e-002,5.6427002e-002,4.9133301e-002,3.7933350e-002,3.4667969e-002,3.4942627e-002,4.3457031e-002,5.7342529e-002,6.0119629e-002,5.9753418e-002,5.4504395e-002,4.3548584e-002,4.4281006e-002,4.5471191e-002,4.9438477e-002,5.8685303e-002,5.7647705e-002,5.5755615e-002,5.3375244e-002,4.6966553e-002,4.5196533e-002,4.3853760e-002,4.3365479e-002,4.6752930e-002,4.9346924e-002,5.3710938e-002,5.6793213e-002,5.7006836e-002,5.6091309e-002,5.2246094e-002,5.0598145e-002,4.8919678e-002,4.7058105e-002,4.6661377e-002,4.3243408e-002,4.0924072e-002,4.2358398e-002,4.5806885e-002,5.1025391e-002,5.5358887e-002,5.2368164e-002,4.5379639e-002,3.9550781e-002,3.3081055e-002,3.7597656e-002,4.8034668e-002,5.3741455e-002,6.0546875e-002,5.4840088e-002,4.3426514e-002,3.7628174e-002,3.0456543e-002,3.4027100e-002,4.2999268e-002,4.6783447e-002,5.3710938e-002,5.4351807e-002,5.0964355e-002,5.2429199e-002,4.8828125e-002,4.6356201e-002,4.4006348e-002,4.0100098e-002,4.0740967e-002,4.4036865e-002,5.0292969e-002,5.4260254e-002,5.6182861e-002,5.3771973e-002,4.7729492e-002,4.6722412e-002,4.6203613e-002,4.9102783e-002,5.5511475e-002,5.4656982e-002,5.3405762e-002,5.1788330e-002,4.8706055e-002,5.2093506e-002,5.5664063e-002,5.4595947e-002,5.2703857e-002,4.6539307e-002,3.9978027e-002,4.1290283e-002,4.5837402e-002,5.1788330e-002,5.9692383e-002,5.8166504e-002,5.2886963e-002,4.9072266e-002,4.2663574e-002,4.3243408e-002,4.6997070e-002,4.8797607e-002,5.2612305e-002,5.2764893e-002,5.1055908e-002,5.1605225e-002,5.0689697e-002,5.0537109e-002,5.0659180e-002,5.1147461e-002,5.1605225e-002,5.2337646e-002,5.3009033e-002,4.9743652e-002,4.6203613e-002,4.2266846e-002,3.9337158e-002,4.2877197e-002,4.8339844e-002,5.1879883e-002,5.4656982e-002,5.1177979e-002,4.4952393e-002,4.4067383e-002,4.3365479e-002,4.7302246e-002,5.2642822e-002,4.9896240e-002,4.5654297e-002,3.9581299e-002,3.1982422e-002,3.3508301e-002,3.8360596e-002,4.2297363e-002,4.6630859e-002,4.5227051e-002,4.1290283e-002,4.0069580e-002,3.8909912e-002,4.1900635e-002,4.6966553e-002,4.7210693e-002,4.6997070e-002,4.3884277e-002,3.9337158e-002,3.8604736e-002,3.8391113e-002,3.8208008e-002,3.9855957e-002,3.9794922e-002,3.9337158e-002,4.0039063e-002,4.0130615e-002,4.0771484e-002,4.2663574e-002,4.3395996e-002,4.5104980e-002,4.5318604e-002,4.4219971e-002,4.2297363e-002,3.8726807e-002,3.5278320e-002,3.2562256e-002,3.2684326e-002,3.5156250e-002,3.6865234e-002,3.8574219e-002,3.8482666e-002,3.6834717e-002,3.7261963e-002,3.6682129e-002,3.6499023e-002,3.6254883e-002,3.2745361e-002,3.0303955e-002,2.8564453e-002,2.8900146e-002,3.1555176e-002,3.5369873e-002,3.6010742e-002,3.5247803e-002,3.3203125e-002,2.9632568e-002,3.0303955e-002,3.0822754e-002,3.1860352e-002,3.3843994e-002,3.2897949e-002,3.1707764e-002,3.1097412e-002,3.0639648e-002,3.0944824e-002,3.0944824e-002,2.7648926e-002,2.5146484e-002,2.3284912e-002,2.2064209e-002,2.2949219e-002,2.5787354e-002,2.6458740e-002,2.7160645e-002,2.6794434e-002,2.3742676e-002,2.2644043e-002,2.0477295e-002,1.8890381e-002,1.9287109e-002,2.0141602e-002,2.3559570e-002,2.7313232e-002,2.9632568e-002,2.8778076e-002,2.4963379e-002,2.2094727e-002,1.9042969e-002,2.0477295e-002,2.4963379e-002,2.6275635e-002,2.7587891e-002,2.3315430e-002,1.6510010e-002,1.5228271e-002,1.5502930e-002,2.0446777e-002,2.8259277e-002,3.0059814e-002,2.9937744e-002,2.9449463e-002,2.5787354e-002,2.8686523e-002,3.2318115e-002,3.2745361e-002,3.4088135e-002,2.9998779e-002,2.4780273e-002,2.4566650e-002,2.5299072e-002,2.9418945e-002,3.5522461e-002,3.6376953e-002,3.6102295e-002,3.4362793e-002,3.0120850e-002,3.0548096e-002,3.2226563e-002,3.3569336e-002,3.7322998e-002,3.7963867e-002,3.8909912e-002,4.0435791e-002,3.8421631e-002,3.6346436e-002,3.1890869e-002,2.9754639e-002,2.9693604e-002,3.2104492e-002,3.8024902e-002,4.0832520e-002,4.2358398e-002,4.1046143e-002,3.6071777e-002,3.5400391e-002,3.4515381e-002,3.4942627e-002,3.7994385e-002,3.6468506e-002,3.5552979e-002,3.4973145e-002,3.4179688e-002,3.7261963e-002,4.0161133e-002,4.1290283e-002,4.1412354e-002,3.8909912e-002,3.6041260e-002,3.6621094e-002,3.7719727e-002,3.8604736e-002,4.0008545e-002,3.7872314e-002,3.5003662e-002,3.2592773e-002,3.0426025e-002,3.0487061e-002,3.2226563e-002,3.3111572e-002,3.4484863e-002,3.5858154e-002,3.5980225e-002,3.5919189e-002,3.4790039e-002,3.2989502e-002,3.1494141e-002,3.1463623e-002,3.2775879e-002,3.5125732e-002,3.8085938e-002,3.7658691e-002,3.6071777e-002,3.4149170e-002,3.1768799e-002,3.3142090e-002,3.6254883e-002,3.7689209e-002,3.9764404e-002,3.8940430e-002,3.8665771e-002,4.1107178e-002,4.2663574e-002,4.5043945e-002,4.6813965e-002,4.5318604e-002,4.2388916e-002,4.1198730e-002,4.0924072e-002,4.2968750e-002,4.6539307e-002,4.6875000e-002,4.6813965e-002,4.5166016e-002,4.1992188e-002,4.2388916e-002,4.2999268e-002,4.2877197e-002,4.4342041e-002,4.2785645e-002,4.1259766e-002,4.2510986e-002,4.3670654e-002,4.6051025e-002,4.8309326e-002,4.7882080e-002,4.7119141e-002,4.6752930e-002,4.5928955e-002,4.6752930e-002,4.8095703e-002,4.8309326e-002,4.8675537e-002,4.8370361e-002,4.8492432e-002,4.9804688e-002,5.0689697e-002,5.1513672e-002,5.1635742e-002,5.2215576e-002,5.2429199e-002,5.3222656e-002,5.4931641e-002,5.4626465e-002,5.3985596e-002,5.3039551e-002,5.1116943e-002,5.2154541e-002,5.4504395e-002,5.5572510e-002,5.6518555e-002,5.4443359e-002,5.1757813e-002,5.1666260e-002,5.0964355e-002,5.3863525e-002,5.7067871e-002,5.6793213e-002,5.5999756e-002,5.4626465e-002,5.3283691e-002,5.4687500e-002,5.7342529e-002,5.8471680e-002,5.8929443e-002,5.8410645e-002,5.7098389e-002,5.7556152e-002,5.8929443e-002,6.0729980e-002,6.2652588e-002,6.2500000e-002,6.1126709e-002,6.1248779e-002,6.1553955e-002,6.3079834e-002,6.5002441e-002,6.4178467e-002,6.3049316e-002,6.2744141e-002,6.2286377e-002,6.4575195e-002,6.7413330e-002,6.8176270e-002,6.8695068e-002,6.7718506e-002,6.5704346e-002,6.7047119e-002,6.8878174e-002,7.1350098e-002,7.4066162e-002,7.3638916e-002,7.2570801e-002,7.2265625e-002,7.2723389e-002,7.5805664e-002,7.9956055e-002,8.1329346e-002,8.2031250e-002,8.1329346e-002,7.9528809e-002,8.0505371e-002,8.2214355e-002,8.3374023e-002,8.5113525e-002,8.4808350e-002,8.3801270e-002,8.4686279e-002,8.4960938e-002,8.6151123e-002,8.8195801e-002,8.7280273e-002,8.6578369e-002,8.6364746e-002,8.4533691e-002,8.5571289e-002,8.7005615e-002,8.6700439e-002,8.7036133e-002,8.5876465e-002,8.4381104e-002,8.4564209e-002,8.4472656e-002,8.5174561e-002,8.5632324e-002,8.5540771e-002,8.5968018e-002,8.6975098e-002,8.8653564e-002,8.9935303e-002,9.1064453e-002,9.0484619e-002,8.8867188e-002,8.8745117e-002,8.8684082e-002,8.9874268e-002,9.2498779e-002,9.3566895e-002,9.4757080e-002,9.5092773e-002,9.3963623e-002,9.4970703e-002,9.6191406e-002,9.7381592e-002,9.9182129e-002,9.8876953e-002,9.8449707e-002,9.8693848e-002,9.8022461e-002,9.9426270e-002,1.0122681e-001,1.0183716e-001,1.0327148e-001,1.0388184e-001,1.0424805e-001,1.0507202e-001,1.0534668e-001,1.0607910e-001,1.0650635e-001,1.0644531e-001,1.0693359e-001,1.0778809e-001,1.0882568e-001,1.0977173e-001,1.1022949e-001,1.1035156e-001,1.1016846e-001,1.0903931e-001,1.1007690e-001,1.1209106e-001,1.1346436e-001,1.1416626e-001,1.1407471e-001,1.1465454e-001,1.1480713e-001,1.1566162e-001,1.1651611e-001,1.1663818e-001,1.1660767e-001,1.1535645e-001,1.1386108e-001,1.1456299e-001,1.1489868e-001,1.1517334e-001,1.1590576e-001,1.1483765e-001,1.1358643e-001,1.1331177e-001,1.1270142e-001,1.1343384e-001,1.1431885e-001,1.1367798e-001,1.1300659e-001,1.1178589e-001,1.1047363e-001,1.1071777e-001,1.1141968e-001,1.1120605e-001,1.1108398e-001,1.0980225e-001,1.0861206e-001,1.0910034e-001,1.0992432e-001,1.1044312e-001,1.1129761e-001,1.1016846e-001,1.0766602e-001,1.0647583e-001,1.0525513e-001,1.0647583e-001,1.0821533e-001,1.0861206e-001,1.0946655e-001,1.0919189e-001,1.0842896e-001,1.0919189e-001,1.0983276e-001,1.1041260e-001,1.1120605e-001,1.1080933e-001,1.1105347e-001,1.1181641e-001,1.1361694e-001,1.1547852e-001,1.1639404e-001,1.1569214e-001,1.1318970e-001,1.1199951e-001,1.1022949e-001,1.0974121e-001,1.1026001e-001,1.1117554e-001,1.1145020e-001,1.1035156e-001,1.0882568e-001,1.0833740e-001,1.0812378e-001,1.0812378e-001,1.0876465e-001,1.0824585e-001,1.0733032e-001,1.0626221e-001,1.0525513e-001,1.0562134e-001,1.0629272e-001,1.0589600e-001,1.0623169e-001,1.0586548e-001,1.0491943e-001,1.0546875e-001,1.0522461e-001,1.0540771e-001,1.0571289e-001,1.0546875e-001,1.0522461e-001,1.0494995e-001,1.0437012e-001,1.0449219e-001,1.0498047e-001,1.0494995e-001,1.0482788e-001,1.0461426e-001,1.0455322e-001,1.0430908e-001,1.0345459e-001,1.0235596e-001,1.0034180e-001,9.9121094e-002,9.7473145e-002,9.6801758e-002,9.7259521e-002,9.6923828e-002,9.7198486e-002,9.7259521e-002,9.5977783e-002,9.5367432e-002,9.4329834e-002,9.3292236e-002,9.3566895e-002,9.2468262e-002,9.2285156e-002,9.0423584e-002,8.9172363e-002,8.8867188e-002,8.7890625e-002,8.7463379e-002,8.6669922e-002,8.5815430e-002,8.4960938e-002,8.4655762e-002,8.3740234e-002,8.3282471e-002,8.2458496e-002,8.2427979e-002,8.2244873e-002,8.2458496e-002,8.2855225e-002,8.3435059e-002,8.3862305e-002,8.3984375e-002,8.3709717e-002,8.3343506e-002,8.2550049e-002,8.1268311e-002,8.0780029e-002,7.9925537e-002,7.8826904e-002,7.8247070e-002,7.7239990e-002,7.7270508e-002,7.7178955e-002,7.6721191e-002,7.5744629e-002,7.3638916e-002,7.1075439e-002,6.9580078e-002,6.8267822e-002,6.8084717e-002,6.8725586e-002,6.8054199e-002,6.8145752e-002,6.6497803e-002,6.4422607e-002,6.3049316e-002,6.0943604e-002,5.9997559e-002,5.9875488e-002,5.9448242e-002,5.9722900e-002,5.8715820e-002,5.7495117e-002,5.6915283e-002,5.5572510e-002,5.5236816e-002,5.4870605e-002,5.4534912e-002,5.4260254e-002,5.3131104e-002,5.2368164e-002,5.0567627e-002,4.8828125e-002,4.9621582e-002,4.9987793e-002,5.0659180e-002,5.1391602e-002,5.0994873e-002,5.0506592e-002,4.9621582e-002,4.7576904e-002,4.5745850e-002,4.3670654e-002,4.2083740e-002,4.1809082e-002,4.1076660e-002,4.1412354e-002,4.0588379e-002,3.9337158e-002,3.9306641e-002,3.7994385e-002,3.7994385e-002,3.7597656e-002,3.6376953e-002,3.5705566e-002,3.3843994e-002,3.2348633e-002,3.0883789e-002,3.0273438e-002,3.0670166e-002,3.1219482e-002,3.1036377e-002,3.0273438e-002,2.9541016e-002,2.8045654e-002,2.8167725e-002,2.8076172e-002,2.7923584e-002,2.7679443e-002,2.5909424e-002,2.4200439e-002,2.2216797e-002,2.0050049e-002,1.8920898e-002,1.7669678e-002,1.6052246e-002,1.5106201e-002,1.4129639e-002,1.3214111e-002,1.2145996e-002,1.1077881e-002,9.7045898e-003,7.7514648e-003,6.2255859e-003,4.1809082e-003,3.5705566e-003,1.8920898e-003,6.7138672e-004,3.0517578e-005,-2.4719238e-003,-4.4860840e-003,-5.4931641e-003,-6.4392090e-003,-7.1411133e-003,-6.8359375e-003,-7.0190430e-003,-7.6293945e-003,-8.5144043e-003,-9.5520020e-003,-1.0040283e-002,-1.0650635e-002,-1.2207031e-002,-1.3519287e-002,-1.5625000e-002,-1.7150879e-002,-1.9500732e-002,-2.1423340e-002,-2.2552490e-002,-2.4047852e-002,-2.5543213e-002,-2.7832031e-002,-2.9449463e-002,-3.0761719e-002,-3.1860352e-002,-3.2531738e-002,-3.3233643e-002,-3.3416748e-002,-3.4851074e-002,-3.7445068e-002,-3.9215088e-002,-4.0863037e-002,-4.1503906e-002,-4.1229248e-002,-4.1748047e-002,-4.2602539e-002,-4.4281006e-002,-4.7027588e-002,-4.8065186e-002,-4.9468994e-002,-4.9560547e-002,-4.8767090e-002,-4.9530029e-002,-5.0384521e-002,-5.1147461e-002,-5.2978516e-002,-5.4290771e-002,-5.5572510e-002,-5.7403564e-002,-5.8959961e-002,-6.0607910e-002,-6.1767578e-002,-6.2286377e-002,-6.2896729e-002,-6.3262939e-002,-6.5002441e-002,-6.6101074e-002,-6.7687988e-002,-6.9274902e-002,-7.0098877e-002,-7.1044922e-002,-7.2052002e-002,-7.3333740e-002,-7.5317383e-002,-7.6812744e-002,-7.7606201e-002,-7.8582764e-002,-7.8582764e-002,-7.9254150e-002,-8.0841064e-002,-8.1695557e-002,-8.2794189e-002,-8.3862305e-002,-8.4014893e-002,-8.5205078e-002,-8.6700439e-002,-8.8409424e-002,-9.0484619e-002,-9.0637207e-002,-9.1003418e-002,-9.0881348e-002,-9.0698242e-002,-9.1125488e-002,-9.2163086e-002,-9.3170166e-002,-9.3872070e-002,-9.4238281e-002,-9.4543457e-002,-9.5397949e-002,-9.6099854e-002,-9.7259521e-002,-9.7839355e-002,-9.8724365e-002,-9.9090576e-002,-9.9517822e-002,-9.9914551e-002,-9.9700928e-002,-1.0003662e-001,-1.0018921e-001,-1.0125732e-001,-1.0287476e-001,-1.0470581e-001,-1.0617065e-001,-1.0729980e-001,-1.0726929e-001,-1.0678101e-001,-1.0714722e-001,-1.0717773e-001,-1.0772705e-001,-1.0839844e-001,-1.0974121e-001,-1.0919189e-001,-1.0903931e-001,-1.0916138e-001,-1.0943604e-001,-1.1083984e-001,-1.1267090e-001,-1.1471558e-001,-1.1682129e-001,-1.1944580e-001,-1.2100220e-001,-1.2179565e-001,-1.2228394e-001,-1.2219238e-001,-1.2265015e-001,-1.2374878e-001,-1.2554932e-001,-1.2741089e-001,-1.2805176e-001,-1.2854004e-001,-1.2893677e-001,-1.2887573e-001,-1.3000488e-001,-1.3156128e-001,-1.3314819e-001,-1.3391113e-001,-1.3388062e-001,-1.3369751e-001,-1.3348389e-001,-1.3317871e-001,-1.3333130e-001,-1.3418579e-001,-1.3552856e-001,-1.3745117e-001,-1.3858032e-001,-1.4062500e-001,-1.4089966e-001,-1.4080811e-001,-1.4105225e-001,-1.4059448e-001,-1.4178467e-001,-1.4343262e-001,-1.4508057e-001,-1.4672852e-001,-1.4697266e-001,-1.4706421e-001,-1.4797974e-001,-1.4923096e-001,-1.5161133e-001,-1.5374756e-001,-1.5469360e-001,-1.5502930e-001,-1.5478516e-001,-1.5530396e-001,-1.5658569e-001,-1.5820313e-001,-1.5875244e-001,-1.5942383e-001,-1.5963745e-001,-1.5814209e-001,-1.5826416e-001,-1.5872192e-001,-1.6003418e-001,-1.6162109e-001,-1.6253662e-001,-1.6333008e-001,-1.6406250e-001,-1.6400146e-001,-1.6418457e-001,-1.6461182e-001,-1.6513062e-001,-1.6647339e-001,-1.6775513e-001,-1.6986084e-001,-1.7160034e-001,-1.7266846e-001,-1.7318726e-001,-1.7315674e-001,-1.7388916e-001,-1.7437744e-001,-1.7568970e-001,-1.7739868e-001,-1.7861938e-001,-1.7962646e-001,-1.8081665e-001,-1.8200684e-001,-1.8322754e-001,-1.8475342e-001,-1.8624878e-001,-1.8823242e-001,-1.8975830e-001,-1.9039917e-001,-1.9073486e-001,-1.9113159e-001,-1.9140625e-001,-1.9137573e-001,-1.9122314e-001,-1.9210815e-001,-1.9320679e-001,-1.9445801e-001,-1.9644165e-001,-1.9808960e-001,-1.9876099e-001,-1.9946289e-001,-2.0037842e-001,-2.0086670e-001,-2.0169067e-001,-2.0300293e-001,-2.0391846e-001,-2.0474243e-001,-2.0541382e-001,-2.0541382e-001,-2.0559692e-001,-2.0700073e-001,-2.0626831e-001,-2.0678711e-001,-2.0834351e-001,-2.0925903e-001,-2.1041870e-001,-2.1160889e-001,-2.1234131e-001,-2.1310425e-001,-2.1411133e-001,-2.1459961e-001,-2.1582031e-001,-2.1664429e-001,-2.1762085e-001,-2.1908569e-001,-2.2055054e-001,-2.2283936e-001,-2.2476196e-001,-2.2653198e-001,-2.2747803e-001,-2.2702026e-001,-2.2717285e-001,-2.2723389e-001,-2.2836304e-001,-2.3056030e-001,-2.3178101e-001,-2.3342896e-001,-2.3419189e-001,-2.3425293e-001,-2.3568726e-001,-2.3626709e-001,-2.3657227e-001,-2.3706055e-001,-2.3736572e-001,-2.3818970e-001,-2.3910522e-001,-2.3959351e-001,-2.4020386e-001,-2.4069214e-001,-2.4029541e-001,-2.4053955e-001,-2.4142456e-001,-2.4285889e-001,-2.4359131e-001,-2.4407959e-001,-2.4462891e-001,-2.4447632e-001,-2.4514771e-001,-2.4578857e-001,-2.4597168e-001,-2.4719238e-001,-2.4731445e-001,-2.4752808e-001,-2.4880981e-001,-2.4984741e-001,-2.5207520e-001,-2.5497437e-001,-2.5625610e-001,-2.5769043e-001,-2.5866699e-001,-2.5772095e-001,-2.5851440e-001,-2.5830078e-001,-2.5793457e-001,-2.5869751e-001,-2.5891113e-001,-2.5949097e-001,-2.6004028e-001,-2.6132202e-001,-2.6287842e-001,-2.6382446e-001,-2.6535034e-001,-2.6599121e-001,-2.6657104e-001,-2.6705933e-001,-2.6824951e-001,-2.7032471e-001,-2.7227783e-001,-2.7365112e-001,-2.7407837e-001,-2.7371216e-001,-2.7304077e-001,-2.7288818e-001,-2.7368164e-001,-2.7539063e-001,-2.7645874e-001,-2.7743530e-001,-2.7789307e-001,-2.7734375e-001,-2.7737427e-001,-2.7719116e-001,-2.7795410e-001,-2.7920532e-001,-2.7911377e-001,-2.7938843e-001,-2.7993774e-001,-2.7972412e-001,-2.8002930e-001,-2.8076172e-001,-2.8143311e-001,-2.8237915e-001,-2.8161621e-001,-2.8128052e-001,-2.8082275e-001,-2.7944946e-001,-2.7975464e-001,-2.8054810e-001,-2.8134155e-001,-2.8317261e-001,-2.8317261e-001,-2.8320313e-001,-2.8347778e-001,-2.8341675e-001,-2.8460693e-001,-2.8634644e-001,-2.8475952e-001,-2.8244019e-001,-2.8121948e-001,-2.8051758e-001,-2.8189087e-001,-2.8353882e-001,-2.8411865e-001,-2.8384399e-001,-2.8213501e-001,-2.7984619e-001,-2.8039551e-001,-2.8244019e-001,-2.8414917e-001,-2.8573608e-001,-2.8445435e-001,-2.8256226e-001,-2.8219604e-001,-2.8182983e-001,-2.8286743e-001,-2.8466797e-001,-2.8381348e-001,-2.8182983e-001,-2.8155518e-001,-2.8103638e-001,-2.8277588e-001,-2.8497314e-001,-2.8451538e-001,-2.8359985e-001,-2.8155518e-001,-2.7990723e-001,-2.8103638e-001,-2.8234863e-001,-2.8265381e-001,-2.8302002e-001,-2.8189087e-001,-2.8015137e-001,-2.7963257e-001,-2.7984619e-001,-2.8054810e-001,-2.8051758e-001,-2.7905273e-001,-2.7749634e-001,-2.7713013e-001,-2.7676392e-001,-2.7694702e-001,-2.7801514e-001,-2.7746582e-001,-2.7593994e-001,-2.7514648e-001,-2.7432251e-001,-2.7505493e-001,-2.7627563e-001,-2.7627563e-001,-2.7709961e-001,-2.7651978e-001,-2.7499390e-001,-2.7502441e-001,-2.7478027e-001,-2.7365112e-001,-2.7337646e-001,-2.7267456e-001,-2.7258301e-001,-2.7307129e-001,-2.7273560e-001,-2.7310181e-001,-2.7313232e-001,-2.7236938e-001,-2.7117920e-001,-2.7075195e-001,-2.7087402e-001,-2.7084351e-001,-2.7148438e-001,-2.7124023e-001,-2.7096558e-001,-2.6998901e-001,-2.6895142e-001,-2.6882935e-001,-2.6876831e-001,-2.6788330e-001,-2.6675415e-001,-2.6571655e-001,-2.6431274e-001,-2.6419067e-001,-2.6400757e-001,-2.6367188e-001,-2.6321411e-001,-2.6220703e-001,-2.6171875e-001,-2.6217651e-001,-2.6217651e-001,-2.6144409e-001,-2.6062012e-001,-2.5976563e-001,-2.5897217e-001,-2.5869751e-001,-2.5924683e-001,-2.5891113e-001,-2.5726318e-001,-2.5497437e-001,-2.5231934e-001,-2.5225830e-001,-2.5204468e-001,-2.5146484e-001,-2.5155640e-001,-2.4942017e-001,-2.4600220e-001,-2.4468994e-001,-2.4316406e-001,-2.4349976e-001,-2.4435425e-001,-2.4298096e-001,-2.4166870e-001,-2.4047852e-001,-2.3773193e-001,-2.3626709e-001,-2.3623657e-001,-2.3516846e-001,-2.3477173e-001,-2.3370361e-001,-2.3303223e-001,-2.3260498e-001,-2.3202515e-001,-2.3211670e-001,-2.3175049e-001,-2.3107910e-001,-2.2961426e-001,-2.2900391e-001,-2.2903442e-001,-2.2827148e-001,-2.2924805e-001,-2.2921753e-001,-2.2842407e-001,-2.2662354e-001,-2.2375488e-001,-2.2247314e-001,-2.2177124e-001,-2.2161865e-001,-2.2250366e-001,-2.2152710e-001,-2.1987915e-001,-2.1896362e-001,-2.1774292e-001,-2.1917725e-001,-2.2061157e-001,-2.1951294e-001,-2.1868896e-001,-2.1582031e-001,-2.1179199e-001,-2.1160889e-001,-2.1234131e-001,-2.1328735e-001,-2.1463013e-001,-2.1197510e-001,-2.0867920e-001,-2.0693970e-001,-2.0449829e-001,-2.0480347e-001,-2.0635986e-001,-2.0486450e-001,-2.0370483e-001,-2.0202637e-001,-1.9973755e-001,-1.9897461e-001,-1.9711304e-001,-1.9546509e-001,-1.9384766e-001,-1.9308472e-001,-1.9281006e-001,-1.9290161e-001,-1.9296265e-001,-1.9161987e-001,-1.8920898e-001,-1.8768311e-001,-1.8646240e-001,-1.8634033e-001,-1.8676758e-001,-1.8548584e-001,-1.8463135e-001,-1.8267822e-001,-1.8130493e-001,-1.8200684e-001,-1.8225098e-001,-1.8167114e-001,-1.8041992e-001,-1.7935181e-001,-1.7745972e-001,-1.7745972e-001,-1.7791748e-001,-1.7773438e-001,-1.7758179e-001,-1.7636108e-001,-1.7504883e-001,-1.7492676e-001,-1.7431641e-001,-1.7269897e-001,-1.7153931e-001,-1.6940308e-001,-1.6824341e-001,-1.6879272e-001,-1.6946411e-001,-1.6967773e-001,-1.6912842e-001,-1.6693115e-001,-1.6406250e-001,-1.6162109e-001,-1.5963745e-001,-1.5908813e-001,-1.5969849e-001,-1.5963745e-001,-1.5917969e-001,-1.5802002e-001,-1.5631104e-001,-1.5563965e-001,-1.5481567e-001,-1.5438843e-001,-1.5472412e-001,-1.5362549e-001,-1.5151978e-001,-1.4959717e-001,-1.4819336e-001,-1.4761353e-001,-1.4834595e-001,-1.4855957e-001,-1.4840698e-001,-1.4807129e-001,-1.4584351e-001,-1.4291382e-001,-1.4099121e-001,-1.3964844e-001,-1.3973999e-001,-1.3943481e-001,-1.3964844e-001,-1.4001465e-001,-1.4056396e-001,-1.4068604e-001,-1.3958740e-001,-1.3757324e-001,-1.3552856e-001,-1.3442993e-001,-1.3461304e-001,-1.3516235e-001,-1.3702393e-001,-1.3732910e-001,-1.3626099e-001,-1.3525391e-001,-1.3381958e-001,-1.3412476e-001,-1.3400269e-001,-1.3327026e-001,-1.3204956e-001,-1.3122559e-001,-1.3003540e-001,-1.3006592e-001,-1.3113403e-001,-1.3134766e-001,-1.3168335e-001,-1.3018799e-001,-1.2780762e-001,-1.2567139e-001,-1.2329102e-001,-1.2231445e-001,-1.2240601e-001,-1.2185669e-001,-1.2249756e-001,-1.2280273e-001,-1.2316895e-001,-1.2322998e-001,-1.2161255e-001,-1.2039185e-001,-1.1816406e-001,-1.1651611e-001,-1.1575317e-001,-1.1520386e-001,-1.1532593e-001,-1.1447144e-001,-1.1282349e-001,-1.1126709e-001,-1.0922241e-001,-1.0809326e-001,-1.0775757e-001,-1.0821533e-001,-1.0897827e-001,-1.0891724e-001,-1.0739136e-001,-1.0516357e-001,-1.0375977e-001,-1.0342407e-001,-1.0385132e-001,-1.0302734e-001,-1.0220337e-001,-1.0031128e-001,-9.7900391e-002,-9.7808838e-002,-9.7564697e-002,-9.7656250e-002,-9.8449707e-002,-9.7106934e-002,-9.5794678e-002,-9.4818115e-002,-9.3078613e-002,-9.2132568e-002,-9.1033936e-002,-8.9050293e-002,-8.8165283e-002,-8.7707520e-002,-8.7646484e-002,-8.7646484e-002,-8.7677002e-002,-8.6914063e-002,-8.5571289e-002,-8.5784912e-002,-8.5998535e-002,-8.6181641e-002,-8.6944580e-002,-8.5327148e-002,-8.3160400e-002,-8.2183838e-002,-8.0963135e-002,-8.0993652e-002,-8.1176758e-002,-7.9162598e-002,-7.7697754e-002,-7.6599121e-002,-7.6141357e-002,-7.7850342e-002,-7.9284668e-002,-7.9345703e-002,-7.8125000e-002,-7.6293945e-002,-7.3699951e-002,-7.3699951e-002,-7.4127197e-002,-7.2784424e-002,-7.1777344e-002,-6.9976807e-002,-6.8023682e-002,-6.8450928e-002,-7.0098877e-002,-7.1563721e-002,-7.2235107e-002,-7.1075439e-002,-6.8664551e-002,-6.7962646e-002,-6.6680908e-002,-6.6192627e-002,-6.7260742e-002,-6.6131592e-002,-6.5155029e-002,-6.4025879e-002,-6.2469482e-002,-6.2042236e-002,-6.1767578e-002,-6.2164307e-002,-6.3049316e-002,-6.3476563e-002,-6.3598633e-002,-6.2744141e-002,-6.1340332e-002,-5.9692383e-002,-5.7891846e-002,-5.7800293e-002,-5.8074951e-002,-5.7159424e-002,-5.7647705e-002,-5.6518555e-002,-5.6365967e-002,-5.6060791e-002,-5.4840088e-002,-5.3985596e-002,-5.2551270e-002,-5.1483154e-002,-5.0659180e-002,-5.1269531e-002,-5.2764893e-002,-5.3894043e-002,-5.4443359e-002,-5.3405762e-002,-5.0415039e-002,-4.7576904e-002,-4.4311523e-002,-4.2633057e-002,-4.3243408e-002,-4.4219971e-002,-4.6875000e-002,-4.9194336e-002,-4.9957275e-002,-4.9560547e-002,-4.6569824e-002,-4.3670654e-002,-3.9978027e-002,-3.7811279e-002,-3.7567139e-002,-3.7567139e-002,-3.9306641e-002,-4.0405273e-002,-4.2419434e-002,-4.4342041e-002,-4.3365479e-002,-4.1778564e-002,-3.7994385e-002,-3.4118652e-002,-3.0914307e-002,-3.1280518e-002,-3.5614014e-002,-4.0008545e-002,-4.5440674e-002,-4.6020508e-002,-4.3457031e-002,-4.0374756e-002,-3.3630371e-002,-3.1097412e-002,-2.9968262e-002,-2.9113770e-002,-3.2043457e-002,-3.2928467e-002,-3.4057617e-002,-3.5736084e-002,-3.4637451e-002,-3.4210205e-002,-3.1433105e-002,-2.8808594e-002,-2.6275635e-002,-2.4078369e-002,-2.6275635e-002,-2.7343750e-002,-3.0700684e-002,-3.1585693e-002,-3.0700684e-002,-2.9541016e-002,-2.5177002e-002,-2.2430420e-002,-1.9744873e-002,-1.8859863e-002,-2.0965576e-002,-2.3712158e-002,-2.6855469e-002,-2.8472900e-002,-2.8625488e-002,-2.6672363e-002,-2.3010254e-002,-2.0843506e-002,-1.8554688e-002,-1.7608643e-002,-1.9012451e-002,-1.8859863e-002,-2.0660400e-002,-2.2247314e-002,-2.1911621e-002,-2.2125244e-002,-2.0935059e-002,-1.9958496e-002,-1.8463135e-002,-1.8585205e-002,-1.7700195e-002,-1.8981934e-002,-2.1392822e-002,-2.0538330e-002,-1.8737793e-002,-1.5411377e-002,-1.0498047e-002,-8.9111328e-003,-8.9721680e-003,-1.0162354e-002,-1.4099121e-002,-1.5289307e-002,-1.6510010e-002,-1.7150879e-002,-1.4739990e-002,-1.4221191e-002,-1.2145996e-002,-1.0101318e-002,-8.9111328e-003,-7.3242188e-003,-7.0190430e-003,-6.7749023e-003,-7.4768066e-003,-8.4228516e-003,-8.4838867e-003,-8.5449219e-003,-7.0495605e-003,-5.7067871e-003,-4.9133301e-003,-4.0588379e-003,-4.4250488e-003,-4.6386719e-003,-5.0659180e-003,-4.3334961e-003,-2.0446777e-003,1.1596680e-003,5.0354004e-003,6.7443848e-003,7.0800781e-003,5.3710938e-003,2.4414063e-003,7.3242188e-004,-2.7465820e-004,-7.9345703e-004,1.0681152e-003,1.8310547e-003,3.0822754e-003,4.8217773e-003,5.7678223e-003,7.0800781e-003,7.1411133e-003,7.7819824e-003,7.4768066e-003,7.5988770e-003,7.3852539e-003,8.0261230e-003,8.4228516e-003,7.6293945e-003,8.5144043e-003,7.9345703e-003,7.5988770e-003,7.5073242e-003,7.3852539e-003,7.5988770e-003,8.7585449e-003,9.7045898e-003,1.1871338e-002,1.2664795e-002,1.2176514e-002,1.1047363e-002,8.4838867e-003,7.8430176e-003,7.6293945e-003,7.9040527e-003,9.4909668e-003,1.0131836e-002,1.0986328e-002,1.2451172e-002,1.3488770e-002,1.5594482e-002,1.6265869e-002,1.5686035e-002,1.5197754e-002,1.4709473e-002,1.4678955e-002,1.5197754e-002,1.6021729e-002,1.6113281e-002,1.5716553e-002,1.4770508e-002,1.3488770e-002,1.3275146e-002,1.3458252e-002,1.4190674e-002,1.5472412e-002,1.6174316e-002,1.6906738e-002,1.7913818e-002,1.8920898e-002,1.8249512e-002,1.7639160e-002,1.6937256e-002,1.6540527e-002,1.6540527e-002,1.6479492e-002,1.6143799e-002,1.6143799e-002,1.5899658e-002,1.6235352e-002,1.7333984e-002,1.9012451e-002,1.8859863e-002,1.8249512e-002,1.8432617e-002,1.7608643e-002,1.8676758e-002,2.0172119e-002,2.1087646e-002,2.2430420e-002,2.2399902e-002,2.2308350e-002,2.3864746e-002,2.4810791e-002,2.6336670e-002,2.8228760e-002,2.8686523e-002,2.9083252e-002,2.9876709e-002,3.0487061e-002,3.1951904e-002,3.2989502e-002,3.3416748e-002,3.3508301e-002,3.3142090e-002,3.2012939e-002,3.1616211e-002,3.1188965e-002,3.0548096e-002,3.0426025e-002,3.0700684e-002,3.2043457e-002,3.3660889e-002,3.4606934e-002,3.4393311e-002,3.3874512e-002,3.4179688e-002,3.4240723e-002,3.4515381e-002,3.5369873e-002,3.4851074e-002,3.5095215e-002,3.5186768e-002,3.5034180e-002,3.6254883e-002,3.6743164e-002,3.7017822e-002,3.6895752e-002,3.7017822e-002,3.7384033e-002,3.8208008e-002,3.9093018e-002,3.9672852e-002,4.0130615e-002,4.0618896e-002,4.0649414e-002,4.1168213e-002,4.1900635e-002,4.1778564e-002,4.2083740e-002,4.1961670e-002,4.1046143e-002,4.2816162e-002,4.3914795e-002,4.4830322e-002,4.6142578e-002,4.6447754e-002,4.6600342e-002,4.7088623e-002,4.7180176e-002,4.6325684e-002,4.5715332e-002,4.5593262e-002,4.5867920e-002,4.6600342e-002,4.8614502e-002,4.9682617e-002,5.0689697e-002,5.0689697e-002,4.9224854e-002,4.9133301e-002,4.7760010e-002,4.6936035e-002,4.7363281e-002,4.7149658e-002,4.7698975e-002,4.8431396e-002,4.8645020e-002,4.9072266e-002,4.8614502e-002,4.8400879e-002,4.8065186e-002,4.8065186e-002,4.8400879e-002,4.8980713e-002,5.0323486e-002,5.1239014e-002,5.2520752e-002,5.3466797e-002,5.4199219e-002,5.3405762e-002,5.1574707e-002,4.9652100e-002,4.7485352e-002,4.7607422e-002,4.8767090e-002,4.9774170e-002,5.1300049e-002,5.0811768e-002,4.9865723e-002,4.9591064e-002,4.9194336e-002,5.0384521e-002,5.1483154e-002,5.2276611e-002,5.2673340e-002,5.3192139e-002,5.4870605e-002,5.5023193e-002,5.4840088e-002,5.4656982e-002,5.4870605e-002,5.4718018e-002,5.4595947e-002,5.4718018e-002,5.5175781e-002,5.5419922e-002,5.5755615e-002,5.6457520e-002,5.6304932e-002,5.6579590e-002,5.6091309e-002,5.4748535e-002,5.3771973e-002,5.3497314e-002,5.4168701e-002,5.5206299e-002,5.6610107e-002,5.6732178e-002,5.6121826e-002,5.4779053e-002,5.3985596e-002,5.4809570e-002,5.6152344e-002,5.7098389e-002,5.8105469e-002,5.8624268e-002,5.7769775e-002,5.7495117e-002,5.6762695e-002,5.5603027e-002,5.4840088e-002,5.4199219e-002,5.4321289e-002,5.4901123e-002,5.5725098e-002,5.6457520e-002,5.6854248e-002,5.6549072e-002,5.6243896e-002,5.5633545e-002,5.5236816e-002,5.4962158e-002,5.4565430e-002,5.4351807e-002,5.4779053e-002,5.5297852e-002,5.5877686e-002,5.5786133e-002,5.5023193e-002,5.3924561e-002,5.2215576e-002,5.1940918e-002,5.3436279e-002,5.5572510e-002,5.7861328e-002,5.8380127e-002,5.8258057e-002,5.7830811e-002,5.5938721e-002,5.5084229e-002,5.4138184e-002,5.2703857e-002,5.2917480e-002,5.2795410e-002,5.3833008e-002,5.5389404e-002,5.6579590e-002,5.7189941e-002,5.6976318e-002,5.6304932e-002,5.4046631e-002,5.2947998e-002,5.2856445e-002,5.2978516e-002,5.4260254e-002,5.4748535e-002,5.4931641e-002,5.4382324e-002,5.3344727e-002,5.2947998e-002,5.2520752e-002,5.2612305e-002,5.3863525e-002,5.5358887e-002,5.6579590e-002,5.7281494e-002,5.7281494e-002,5.6854248e-002,5.5999756e-002,5.5755615e-002,5.4992676e-002,5.4351807e-002,5.3680420e-002,5.3253174e-002,5.3527832e-002,5.4290771e-002,5.5175781e-002,5.6121826e-002,5.6457520e-002,5.6213379e-002,5.5480957e-002,5.5175781e-002,5.4718018e-002,5.4382324e-002,5.5358887e-002,5.5267334e-002,5.5938721e-002,5.5511475e-002,5.4016113e-002,5.5511475e-002,5.5114746e-002,5.5694580e-002,5.6457520e-002,5.6671143e-002,5.7281494e-002,5.7434082e-002,5.6945801e-002,5.6854248e-002,5.5999756e-002,5.5450439e-002,5.5786133e-002,5.6365967e-002,5.7922363e-002,5.8624268e-002,5.9448242e-002,6.0180664e-002,5.9570313e-002,5.9356689e-002,5.8929443e-002,5.8898926e-002,5.9570313e-002,5.9387207e-002,5.9448242e-002,5.9020996e-002,5.7373047e-002,5.6610107e-002,5.6030273e-002,5.6030273e-002,5.6213379e-002,5.5206299e-002,5.4443359e-002,5.3680420e-002,5.3192139e-002,5.4290771e-002,5.6030273e-002,5.7159424e-002,5.8624268e-002,5.8654785e-002,5.8532715e-002,5.8990479e-002,5.8868408e-002,6.0150146e-002,6.1553955e-002,6.2072754e-002,6.2469482e-002,6.2072754e-002,6.1523438e-002,6.1920166e-002,6.2164307e-002,6.2866211e-002,6.3262939e-002,6.3079834e-002,6.3232422e-002,6.3018799e-002,6.3507080e-002,6.2988281e-002,6.2774658e-002,6.3629150e-002,6.3262939e-002,6.2988281e-002,6.2133789e-002,6.1523438e-002,6.1096191e-002,6.1279297e-002,6.2377930e-002,6.4086914e-002,6.5307617e-002,6.6375732e-002,6.6528320e-002,6.5979004e-002,6.5002441e-002,6.4025879e-002,6.4300537e-002,6.4361572e-002,6.4941406e-002,6.5368652e-002,6.6009521e-002,6.6253662e-002,6.6284180e-002,6.6894531e-002,6.6619873e-002,6.6284180e-002,6.5795898e-002,6.6406250e-002,6.7016602e-002,6.7749023e-002,6.8908691e-002,6.8664551e-002,6.8664551e-002,6.8786621e-002,6.8115234e-002,6.8634033e-002,6.9000244e-002,6.9122314e-002,6.9641113e-002,6.9641113e-002,7.0495605e-002,7.1380615e-002,7.2143555e-002,7.2753906e-002,7.2814941e-002,7.3089600e-002,7.3272705e-002,7.3822021e-002,7.4493408e-002,7.4523926e-002,7.4951172e-002,7.4615479e-002,7.4523926e-002,7.5256348e-002,7.6385498e-002,7.6843262e-002,7.7423096e-002,7.7880859e-002,7.7178955e-002,7.7728271e-002,7.7606201e-002,7.7911377e-002,7.8308105e-002,7.7270508e-002,7.6416016e-002,7.5836182e-002,7.5286865e-002,7.6019287e-002,7.7301025e-002,7.8033447e-002,7.8582764e-002,7.8582764e-002,7.7362061e-002,7.6721191e-002,7.6446533e-002,7.6354980e-002,7.7117920e-002,7.7392578e-002,7.7331543e-002,7.7087402e-002,7.6507568e-002,7.5866699e-002,7.5744629e-002,7.4920654e-002,7.4981689e-002,7.5561523e-002,7.6141357e-002,7.6690674e-002,7.6019287e-002,7.5958252e-002,7.5622559e-002,7.6080322e-002,7.6507568e-002,7.6904297e-002,7.6629639e-002,7.6049805e-002,7.5500488e-002,7.5775146e-002,7.6782227e-002,7.6965332e-002,7.8216553e-002,7.8033447e-002,7.7392578e-002,7.7941895e-002,7.8033447e-002,7.8552246e-002,7.9345703e-002,7.9345703e-002,7.9864502e-002,7.9071045e-002,7.7423096e-002,7.6477051e-002,7.5714111e-002,7.4645996e-002,7.4493408e-002,7.5103760e-002,7.5622559e-002,7.6721191e-002,7.7514648e-002,7.8796387e-002,7.9071045e-002,7.9833984e-002,8.0017090e-002,8.0047607e-002,8.0169678e-002,7.9101563e-002,7.8765869e-002,7.8735352e-002,7.8948975e-002,7.9925537e-002,8.0932617e-002,8.1756592e-002,8.2672119e-002,8.2458496e-002,8.1817627e-002,8.1665039e-002,8.0383301e-002,7.9559326e-002,7.9254150e-002,7.8704834e-002,7.8887939e-002,7.7789307e-002,7.7056885e-002,7.6721191e-002,7.6660156e-002,7.6965332e-002,7.7636719e-002,7.8338623e-002,7.7850342e-002,7.7484131e-002,7.6507568e-002,7.6202393e-002,7.5988770e-002,7.6110840e-002,7.6232910e-002,7.6538086e-002,7.7636719e-002,7.8063965e-002,7.8979492e-002,7.9528809e-002,7.8826904e-002,7.8033447e-002,7.6629639e-002,7.6171875e-002,7.6507568e-002,7.6538086e-002,7.7667236e-002,7.7941895e-002,7.7056885e-002,7.8674316e-002,7.8826904e-002,7.8887939e-002,7.8613281e-002,7.7941895e-002,7.8399658e-002,7.8704834e-002,7.9010010e-002,7.9010010e-002,7.8460693e-002,7.8521729e-002,7.8796387e-002,7.9284668e-002,8.0322266e-002,8.0566406e-002,8.0047607e-002,7.9528809e-002,7.8613281e-002,7.8887939e-002,7.9010010e-002,7.8735352e-002,7.9284668e-002,7.8918457e-002,7.8857422e-002,7.9711914e-002,8.0718994e-002,8.2550049e-002,8.3740234e-002,8.4777832e-002,8.5357666e-002,8.4960938e-002,8.4747314e-002,8.3709717e-002,8.2763672e-002,8.2214355e-002,8.1634521e-002,8.1634521e-002,8.1726074e-002,8.1481934e-002,8.1268311e-002,8.1176758e-002,8.0627441e-002,8.1054688e-002,8.0871582e-002,8.0749512e-002,8.0505371e-002,8.0047607e-002,8.0291748e-002,8.0535889e-002,8.1695557e-002,8.2336426e-002,8.2427979e-002,8.2336426e-002,8.2336426e-002,8.2397461e-002,8.2855225e-002,8.2092285e-002,8.1207275e-002,8.1237793e-002,8.0627441e-002,8.0810547e-002,8.0718994e-002,8.0780029e-002,8.1390381e-002,8.1634521e-002,8.1787109e-002,8.2366943e-002,8.2519531e-002,8.2824707e-002,8.2702637e-002,8.2611084e-002,8.2946777e-002,8.2763672e-002,8.3435059e-002,8.3404541e-002,8.3587646e-002,8.3953857e-002,8.3709717e-002,8.3984375e-002,8.4106445e-002,8.3801270e-002,8.3282471e-002,8.2427979e-002,8.1420898e-002,8.1359863e-002,8.1237793e-002,8.1787109e-002,8.2611084e-002,8.3282471e-002,8.4686279e-002,8.6181641e-002,8.7463379e-002,8.7890625e-002,8.7707520e-002,8.7066650e-002,8.5754395e-002,8.4838867e-002,8.4442139e-002,8.3679199e-002,8.3923340e-002,8.3343506e-002,8.2397461e-002,8.2244873e-002,8.1115723e-002,8.1268311e-002,8.1878662e-002,8.2489014e-002,8.3831787e-002,8.4442139e-002,8.4899902e-002,8.4625244e-002,8.3862305e-002,8.3129883e-002,8.3404541e-002,8.3831787e-002,8.4106445e-002,8.4716797e-002,8.5479736e-002,8.6273193e-002,8.6700439e-002,8.8043213e-002,8.8500977e-002,8.8867188e-002,8.9111328e-002,8.8287354e-002,8.7432861e-002,8.6639404e-002,8.5662842e-002,8.5052490e-002,8.4777832e-002,8.4167480e-002,8.4503174e-002,8.4838867e-002,8.5906982e-002,8.6975098e-002,8.7493896e-002,8.8012695e-002,8.8287354e-002,8.8836670e-002,8.9172363e-002,8.9324951e-002,8.9874268e-002,8.9569092e-002,8.9202881e-002,8.9630127e-002,8.9385986e-002,9.0057373e-002,9.1217041e-002,9.1705322e-002,9.1796875e-002,9.1644287e-002,9.0606689e-002,9.0545654e-002,9.0454102e-002,9.0026855e-002,9.0911865e-002,9.0698242e-002,9.1552734e-002,9.1552734e-002,9.0728760e-002,9.0637207e-002,8.9935303e-002,9.0362549e-002,9.1278076e-002,9.1705322e-002,9.1888428e-002,9.0972900e-002,8.9385986e-002,8.9111328e-002,8.7554932e-002,8.7829590e-002,8.8439941e-002,8.7097168e-002,8.7310791e-002,8.7371826e-002,8.8043213e-002,8.8928223e-002,8.8562012e-002,8.7677002e-002,8.6334229e-002,8.5632324e-002,8.6059570e-002,8.7127686e-002,8.9569092e-002,9.0240479e-002,9.0545654e-002,9.0637207e-002,8.9660645e-002,9.0606689e-002,9.1033936e-002,9.0881348e-002,9.1400146e-002,9.0850830e-002,8.9752197e-002,8.9080811e-002,8.8226318e-002,8.7829590e-002,8.8226318e-002,8.8684082e-002,9.0545654e-002,9.1705322e-002,9.2376709e-002,9.2285156e-002,9.0332031e-002,9.0026855e-002,8.9813232e-002,8.9508057e-002,8.9721680e-002,8.7951660e-002,8.6425781e-002,8.6517334e-002,8.6700439e-002,8.8287354e-002,9.0515137e-002,9.1369629e-002,9.2041016e-002,9.3353271e-002,9.4238281e-002,9.5428467e-002,9.5794678e-002,9.4757080e-002,9.3353271e-002,9.2315674e-002,9.2254639e-002,9.2864990e-002,9.3688965e-002,9.3994141e-002,9.5214844e-002,9.5886230e-002,9.5703125e-002,9.7198486e-002,9.8937988e-002,1.0028076e-001,1.0223389e-001,1.0305786e-001,1.0375977e-001,1.0345459e-001,1.0171509e-001,9.9975586e-002,9.8571777e-002,9.7808838e-002,9.9060059e-002,9.8632813e-002,9.7961426e-002,9.7106934e-002,9.5153809e-002,9.6496582e-002,9.8693848e-002,1.0125732e-001,1.0412598e-001,1.0351563e-001,1.0098267e-001,9.8724365e-002,9.5214844e-002,9.2864990e-002,9.1918945e-002,9.0545654e-002,9.1644287e-002,9.3505859e-002,9.6527100e-002,9.9243164e-002,1.0012817e-001,1.0101318e-001,9.9639893e-002,9.8388672e-002,9.6496582e-002,9.4085693e-002,9.2956543e-002,9.1827393e-002,9.2285156e-002,9.4146729e-002,9.6801758e-002,9.8144531e-002,9.8876953e-002,1.0095215e-001,1.0287476e-001,1.0629272e-001,1.0861206e-001,1.0671997e-001,1.0205078e-001,9.6374512e-002,9.0942383e-002,9.1186523e-002,9.5550537e-002,9.8236084e-002,1.0296631e-001,1.0305786e-001,9.9761963e-002,1.0256958e-001,1.0491943e-001,1.0928345e-001,1.1560059e-001,1.1691284e-001,1.1752319e-001,1.1755371e-001,1.1383057e-001,1.0897827e-001,1.0305786e-001,9.6710205e-002,9.3750000e-002,9.5550537e-002,1.0217285e-001,1.0845947e-001,1.1425781e-001,1.1721802e-001,1.1575317e-001,1.1730957e-001,1.1651611e-001,1.1566162e-001,1.1648560e-001,1.1328125e-001,1.1160278e-001,1.0806274e-001,1.0308838e-001,9.6801758e-002,9.0118408e-002,8.8012695e-002,9.0270996e-002,1.0006714e-001,1.1346436e-001,1.2173462e-001,1.2533569e-001,1.2246704e-001,1.1233521e-001,1.0842896e-001,1.0577393e-001,1.0128784e-001,1.0107422e-001,9.2498779e-002,8.5021973e-002,8.3679199e-002,8.4564209e-002,9.3933105e-002,1.0589600e-001,1.1322021e-001,1.1709595e-001,1.2005615e-001,1.1602783e-001,1.1450195e-001,1.1041260e-001,1.0351563e-001,1.0195923e-001,9.7381592e-002,9.8449707e-002,1.0079956e-001,1.0580444e-001,1.1068726e-001,1.1340332e-001,1.1621094e-001,1.1331177e-001,1.1230469e-001,1.0916138e-001,1.0729980e-001,1.0748291e-001,1.0644531e-001,1.0739136e-001,1.0540771e-001,1.0415649e-001,1.0516357e-001,1.0855103e-001,1.1499023e-001,1.2240601e-001,1.2466431e-001,1.2118530e-001,1.1444092e-001,1.0278320e-001,9.5397949e-002,9.2010498e-002,8.9813232e-002,9.4329834e-002,9.7015381e-002,1.0171509e-001,1.0800171e-001,1.1141968e-001,1.1553955e-001,1.1492920e-001,1.1212158e-001,1.0638428e-001,9.9822998e-002,9.4055176e-002,8.6700439e-002,8.2763672e-002,7.7270508e-002,7.4462891e-002,7.2875977e-002,7.3089600e-002,7.8979492e-002,8.5968018e-002,9.7747803e-002,1.0925293e-001,1.1547852e-001,1.1605835e-001,1.0971069e-001,9.8785400e-002,9.1674805e-002,8.5815430e-002,7.8765869e-002,7.3913574e-002,6.2500000e-002,5.4107666e-002,5.7098389e-002,6.9061279e-002,9.5428467e-002,1.2750244e-001,1.4779663e-001,1.5487671e-001,1.4883423e-001,1.2332153e-001,1.0183716e-001,8.0749512e-002,6.1431885e-002,6.0485840e-002,5.7861328e-002,7.0312500e-002,8.6181641e-002,1.0098267e-001,1.1825562e-001,1.2365723e-001,1.3403320e-001,1.3464355e-001,1.3848877e-001,1.4019775e-001,1.2963867e-001,1.2039185e-001,1.0162354e-001,8.9141846e-002,8.5144043e-002,9.2620850e-002,1.0693359e-001,1.2615967e-001,1.4096069e-001,1.4422607e-001,1.4324951e-001,1.2426758e-001,1.0800171e-001,9.1186523e-002,8.3007813e-002,9.2041016e-002,9.8602295e-002,1.1456299e-001,1.1584473e-001,1.0873413e-001,1.0589600e-001,9.6527100e-002,1.0455322e-001,1.1669922e-001,1.2023926e-001,1.2152100e-001,1.0787964e-001,8.6151123e-002,7.5317383e-002,6.9274902e-002,7.2418213e-002,8.9538574e-002,9.7198486e-002,1.0461426e-001,1.0873413e-001,1.0098267e-001,9.6496582e-002,8.3801270e-002,7.2052002e-002,6.5826416e-002,6.6894531e-002,8.1787109e-002,9.6923828e-002,1.1441040e-001,1.1663818e-001,1.0354614e-001,8.8867188e-002,6.4392090e-002,5.7189941e-002,6.1431885e-002,6.6497803e-002,8.4655762e-002,9.0637207e-002,9.3780518e-002,1.0208130e-001,1.0372925e-001,1.1578369e-001,1.2728882e-001,1.3095093e-001,1.3211060e-001,1.2207031e-001,1.0586548e-001,9.1491699e-002,7.9681396e-002,7.5469971e-002,8.3679199e-002,9.6710205e-002,1.1712646e-001,1.3531494e-001,1.4443970e-001,1.4721680e-001,1.3442993e-001,1.2124634e-001,1.0217285e-001,8.5815430e-002,8.0718994e-002,7.7239990e-002,9.1369629e-002,1.0632324e-001,1.2615967e-001,1.4288330e-001,1.4532471e-001,1.4630127e-001,1.3449097e-001,1.3180542e-001,1.3009644e-001,1.2530518e-001,1.2368774e-001,1.0256958e-001,8.0596924e-002,6.4056396e-002,5.6091309e-002,7.0831299e-002,9.9243164e-002,1.1740112e-001,1.2719727e-001,1.2084961e-001,9.2529297e-002,8.0108643e-002,6.5856934e-002,5.8685303e-002,6.9152832e-002,6.7199707e-002,7.8948975e-002,9.2834473e-002,1.0443115e-001,1.1614990e-001,1.1215210e-001,9.6160889e-002,6.6619873e-002,4.9560547e-002,4.1809082e-002,4.8583984e-002,7.4615479e-002,8.2183838e-002,8.9447021e-002,8.9752197e-002,7.9406738e-002,9.2895508e-002,1.0675049e-001,1.1807251e-001,1.2924194e-001,1.1459351e-001,8.7921143e-002,6.4880371e-002,4.1748047e-002,4.0130615e-002,6.1187744e-002,8.3618164e-002,1.2094116e-001,1.4553833e-001,1.5228271e-001,1.5380859e-001,1.2924194e-001,1.1132813e-001,9.1888428e-002,7.8887939e-002,8.5418701e-002,8.4594727e-002,9.9609375e-002,1.1276245e-001,1.2973022e-001,1.6024780e-001,1.7977905e-001,1.9616699e-001,1.9012451e-001,1.6253662e-001,1.1795044e-001,7.5805664e-002,4.3518066e-002,2.3040771e-002,3.0181885e-002,3.6956787e-002,6.6131592e-002,1.0787964e-001,1.5127563e-001,2.0007324e-001,2.2027588e-001,2.1096802e-001,1.6235352e-001,1.0974121e-001,5.7525635e-002,3.2318115e-002,4.8187256e-002,4.6569824e-002,6.7382813e-002,6.6162109e-002,5.1391602e-002,7.4737549e-002,8.5540771e-002,1.1227417e-001,1.3238525e-001,1.1621094e-001,8.8104248e-002,6.1981201e-002,4.0313721e-002,4.0222168e-002,6.1553955e-002,5.6457520e-002,5.3894043e-002,3.9337158e-002,1.2664795e-002,1.9134521e-002,2.7770996e-002,4.3884277e-002,6.5551758e-002,7.0739746e-002,6.6711426e-002,6.4483643e-002,5.4107666e-002,4.5593262e-002,4.3884277e-002,3.4027100e-002,3.4179688e-002,3.6468506e-002,4.1625977e-002,5.0964355e-002,6.0180664e-002,7.0007324e-002,7.4310303e-002,7.6751709e-002,6.9732666e-002,6.1309814e-002,5.2307129e-002,5.2764893e-002,6.7871094e-002,8.3251953e-002,9.9639893e-002,8.9477539e-002,5.8258057e-002,2.7587891e-002,-5.0354004e-003,-1.3427734e-003,2.8259277e-002,4.7882080e-002,7.4096680e-002,6.9549561e-002,4.6936035e-002,5.4473877e-002,5.9143066e-002,8.2061768e-002,1.1132813e-001,1.0128784e-001,8.4411621e-002,7.0434570e-002,5.8837891e-002,7.9254150e-002,1.1105347e-001,1.0888672e-001,9.4543457e-002,5.9997559e-002,9.7656250e-003,5.8593750e-003,1.7639160e-002,2.8686523e-002,5.4229736e-002,4.6569824e-002,3.3416748e-002,5.4748535e-002,7.7819824e-002,1.1367798e-001,1.4404297e-001,1.1355591e-001,5.3039551e-002,-5.3100586e-003,-6.3995361e-002,-6.4086914e-002,-1.6845703e-002,1.1840820e-002,5.7678223e-002,6.4208984e-002,3.2806396e-002,3.7078857e-002,2.4230957e-002,4.6447754e-002,9.4390869e-002,1.1920166e-001,1.5560913e-001,1.5850830e-001,1.3397217e-001,9.9700928e-002,4.4464111e-002,-1.0986328e-003,-3.2318115e-002,-4.9133301e-002,-3.9367676e-002,-2.9632568e-002,-1.1077881e-002,1.1932373e-002,2.5482178e-002,5.5145264e-002,6.9519043e-002,7.7484131e-002,7.8216553e-002,7.0495605e-002,7.4218750e-002,8.2733154e-002,1.0079956e-001,8.9080811e-002,5.7312012e-002,5.1879883e-004,-7.1258545e-002,-9.1247559e-002,-7.8247070e-002,-2.7374268e-002,5.9417725e-002,1.1264038e-001,1.5054321e-001,1.8807983e-001,1.8911743e-001,2.0733643e-001,1.9927979e-001,1.2829590e-001,3.2409668e-002,-1.0034180e-001,-2.1609497e-001,-2.5518799e-001,-2.0645142e-001,-1.0830688e-001,5.5023193e-002,1.8835449e-001,2.7218628e-001,3.4634399e-001,3.0871582e-001,2.6376343e-001,1.5646362e-001,1.0803223e-002,-9.5092773e-002,-1.8759155e-001,-1.6360474e-001,-9.1217041e-002,6.5948486e-002,2.0019531e-001,2.8326416e-001,3.2882690e-001,2.4661255e-001,2.1255493e-001,1.3937378e-001,1.1157227e-001,1.5502930e-001,1.3641357e-001,1.6442871e-001,1.2365723e-001,6.5582275e-002,5.4504395e-002,4.6997070e-002,1.0696411e-001,1.8469238e-001,2.1566772e-001,2.0019531e-001,1.3088989e-001,6.7749023e-003,-4.9255371e-002,-5.8563232e-002,-1.6571045e-002,1.0940552e-001,1.6732788e-001,2.1847534e-001,2.3461914e-001,1.8273926e-001,1.7453003e-001,1.3259888e-001,8.4136963e-002,4.6112061e-002,-1.7303467e-002,-5.0720215e-002,-6.1553955e-002,-4.6356201e-002,-3.3966064e-002,-2.2888184e-002,-7.6599121e-003,6.1035156e-003,8.7768555e-002,1.8331909e-001,2.5531006e-001,2.9040527e-001,2.0806885e-001,5.1208496e-002,-7.9742432e-002,-1.8545532e-001,-1.8692017e-001,-7.4035645e-002,-1.0162354e-002,7.9284668e-002,1.0791016e-001,5.8380127e-002,1.0052490e-001,1.0845947e-001,1.7236328e-001,2.6708984e-001,2.8771973e-001,3.1582642e-001,2.9489136e-001,2.5097656e-001,2.2332764e-001,2.0611572e-001,2.0834351e-001,2.5259399e-001,3.1509399e-001,3.9648438e-001,4.7265625e-001,5.0955200e-001,5.2072144e-001,4.6862793e-001,4.1809082e-001,3.3880615e-001,2.5653076e-001,2.0468140e-001,1.3549805e-001,1.2603760e-001,1.3552856e-001,1.7590332e-001,2.1408081e-001,2.1151733e-001,1.7623901e-001,8.4960938e-002,4.7821045e-002,3.3843994e-002,7.7972412e-002,1.7962646e-001,2.0358276e-001,2.1520996e-001,1.8313599e-001,1.0617065e-001,8.9080811e-002,5.5572510e-002,-3.1341553e-002,-1.5142822e-001,-3.6337280e-001,-6.0034180e-001,-7.3510742e-001,-7.8518677e-001,-7.2448730e-001,-5.5047607e-001,-4.4070435e-001,-3.5775757e-001,-3.1506348e-001,-4.0936279e-001,-4.8410034e-001,-6.5393066e-001,-8.0212402e-001,-8.9245605e-001,-9.1131592e-001,-9.1094971e-001,-9.1058350e-001,-9.1027832e-001,-9.0991211e-001,-8.6395264e-001,-8.3926392e-001,-8.9773560e-001,-8.7973022e-001,-9.0036011e-001,-8.6105347e-001,-7.1307373e-001,-7.1646118e-001,-7.2155762e-001,-7.8738403e-001,-8.5458374e-001,-8.4817505e-001,-7.9574585e-001,-6.9406128e-001,-5.6878662e-001,-4.9896240e-001,-4.9087524e-001,-4.4479370e-001,-4.4924927e-001,-3.8815308e-001,-2.9977417e-001,-2.3715210e-001,-1.4926147e-001,-1.2298584e-001,-1.1953735e-001,-1.3092041e-001,-1.5072632e-001,-1.2286377e-001,-4.2083740e-002,8.8684082e-002,2.7587891e-001,4.4100952e-001,5.8343506e-001,6.7724609e-001,6.8542480e-001,7.1008301e-001,7.1020508e-001,7.1365356e-001,7.2625732e-001,7.0932007e-001,7.1163940e-001,7.1783447e-001,7.3849487e-001,7.6492310e-001,7.9028320e-001,7.9614258e-001,7.8390503e-001,7.9177856e-001,7.9830933e-001,8.2028198e-001,8.2751465e-001,8.0645752e-001,7.8067017e-001,7.5735474e-001,7.2360229e-001,7.0278931e-001,7.2830200e-001,7.5454712e-001,7.9525757e-001,7.6037598e-001,6.6949463e-001,5.7028198e-001,4.2340088e-001,3.4420776e-001,3.0392456e-001,2.7148438e-001,2.9965210e-001,3.0252075e-001,3.2009888e-001,3.6187744e-001,3.7390137e-001,3.7255859e-001,3.1027222e-001,1.8237305e-001,1.4526367e-002,-1.2033081e-001,-1.9284058e-001,-1.9042969e-001,-8.8867188e-002,-4.0679932e-002,-6.6528320e-003,-2.0446777e-002,-1.1920166e-001,-1.2283325e-001,-1.3900757e-001,-1.2692261e-001,-8.6334229e-002,-1.4962769e-001,-2.1450806e-001,-2.6641846e-001,-2.9013062e-001,-2.2311401e-001,-1.0238647e-001,-3.9916992e-002,-7.9345703e-003,-3.1921387e-002,-1.2237549e-001,-1.1221313e-001,-7.6110840e-002,-8.2397461e-004,1.3684082e-001,1.8731689e-001,2.2351074e-001,2.3983765e-001,1.9415283e-001,1.6262817e-001,9.5489502e-002,-1.2207031e-004,-7.0312500e-002,-9.5581055e-002,-3.8177490e-002,7.2082520e-002,2.2189331e-001,2.9736328e-001,2.9498291e-001,2.6846313e-001,1.6494751e-001,1.5484619e-001,1.7834473e-001,1.7648315e-001,2.2003174e-001,1.5930176e-001,8.2092285e-002,3.9459229e-002,-1.0864258e-002,-1.2207031e-003,2.6885986e-002,2.0080566e-002,4.3334961e-003,-5.7678223e-003,-3.1555176e-002,-1.9805908e-002,-6.0424805e-003,-3.3813477e-002,-6.9915771e-002,-1.3555908e-001,-2.1368408e-001,-2.7102661e-001,-3.1842041e-001,-3.7747192e-001,-4.1506958e-001,-4.4430542e-001,-4.5382690e-001,-4.2175293e-001,-3.9556885e-001,-4.0429688e-001,-4.5825195e-001,-5.3683472e-001,-6.3671875e-001,-6.6897583e-001,-6.5255737e-001,-6.4343262e-001,-5.9674072e-001,-6.1849976e-001,-6.5219116e-001,-6.2976074e-001,-6.0693359e-001,-5.3298950e-001,-4.5703125e-001,-4.6609497e-001,-5.1690674e-001,-5.7009888e-001,-6.3211060e-001,-6.0888672e-001,-5.3836060e-001,-5.2685547e-001,-5.1376343e-001,-5.6402588e-001,-6.4346313e-001,-6.0757446e-001,-5.3070068e-001,-4.1494751e-001,-2.6507568e-001,-2.2756958e-001,-2.4176025e-001,-2.4383545e-001,-2.7880859e-001,-2.2579956e-001,-1.3113403e-001,-9.4024658e-002,-3.4606934e-002,-2.3651123e-002,-2.9296875e-002,3.3874512e-002,9.2987061e-002,1.4129639e-001,1.6952515e-001,1.3626099e-001,7.7148438e-002,8.1787109e-002,1.2609863e-001,2.1853638e-001,3.5940552e-001,4.1204834e-001,4.2279053e-001,4.0347290e-001,3.2382202e-001,3.1463623e-001,3.2434082e-001,3.3001709e-001,3.7973022e-001,3.8470459e-001,3.9874268e-001,4.4631958e-001,4.8822021e-001,5.5432129e-001,6.0278320e-001,6.0430908e-001,5.6158447e-001,4.9749756e-001,4.1149902e-001,3.4890747e-001,3.2183838e-001,2.9931641e-001,3.2925415e-001,3.5290527e-001,3.8742065e-001,4.2800903e-001,4.3646240e-001,4.5834351e-001,4.4989014e-001,4.5913696e-001,4.7213745e-001,4.6643066e-001,4.6011353e-001,3.9236450e-001,2.9922485e-001,2.0223999e-001,1.1230469e-001,8.5906982e-002,1.1807251e-001,1.6036987e-001,2.2778320e-001,2.6571655e-001,2.6171875e-001,2.8308105e-001,2.6422119e-001,2.5869751e-001,2.4606323e-001,1.8276978e-001,1.3024902e-001,7.5286865e-002,5.9173584e-002,8.4777832e-002,1.5087891e-001,1.9494629e-001,2.1917725e-001,2.2238159e-001,1.6970825e-001,1.6220093e-001,1.3781738e-001,1.1898804e-001,1.2133789e-001,8.6853027e-002,7.8033447e-002,8.4808350e-002,1.1276245e-001,1.4816284e-001,1.7501831e-001,1.6223145e-001,1.1425781e-001,8.7005615e-002,5.6335449e-002,7.2540283e-002,1.1709595e-001,1.2106323e-001,1.2384033e-001,1.0006714e-001,6.1950684e-002,7.9711914e-002,1.1111450e-001,1.4035034e-001,1.7025757e-001,1.3735962e-001,7.2021484e-002,2.0355225e-002,-4.0435791e-002,-7.1044922e-002,-7.8857422e-002,-1.1529541e-001,-1.3092041e-001,-1.2341309e-001,-8.6639404e-002,1.2451172e-002,1.2615967e-001,1.9570923e-001,2.0889282e-001,1.5216064e-001,1.9256592e-002,-8.3801270e-002,-1.7868042e-001,-2.5833130e-001,-2.7346802e-001,-3.3474731e-001,-3.6038208e-001,-3.5601807e-001,-3.4008789e-001,-2.5173950e-001,-1.6790771e-001,-1.0238647e-001,-8.0078125e-002,-9.5001221e-002,-1.5243530e-001,-1.8972778e-001,-2.1002197e-001,-2.4722290e-001,-2.4752808e-001,-3.0480957e-001,-3.5931396e-001,-3.9956665e-001,-4.4244385e-001,-4.1885376e-001,-3.7222290e-001,-3.0291748e-001,-2.2692871e-001,-1.7355347e-001,-1.6079712e-001,-1.7163086e-001,-2.2625732e-001,-2.8256226e-001,-3.2388306e-001,-3.6087036e-001,-3.4405518e-001,-3.4686279e-001,-3.2763672e-001,-3.2257080e-001,-3.3639526e-001,-3.1036377e-001,-3.0133057e-001,-2.6446533e-001,-2.3895264e-001,-2.4081421e-001,-2.5762939e-001,-2.7481079e-001,-2.7566528e-001,-2.4719238e-001,-1.8469238e-001,-1.6317749e-001,-1.5637207e-001,-2.0169067e-001,-2.9147339e-001,-3.3245850e-001,-3.5858154e-001,-3.3499146e-001,-2.6181030e-001,-2.2402954e-001,-1.8530273e-001,-1.5399170e-001,-1.5270996e-001,-1.0852051e-001,-7.8674316e-002,-7.5988770e-002,-8.7310791e-002,-1.4993286e-001,-2.1957397e-001,-2.5979614e-001,-2.6660156e-001,-2.5140381e-001,-2.0089722e-001,-1.8365479e-001,-1.7831421e-001,-1.4895630e-001,-1.3656616e-001,-6.7108154e-002,7.6599121e-003,5.2551270e-002,8.4991455e-002,6.4666748e-002,1.6174316e-002,-1.8707275e-002,-4.7271729e-002,-6.5246582e-002,-4.7973633e-002,-4.4952393e-002,-2.1636963e-002,2.0019531e-002,5.6304932e-002,1.1495972e-001,1.5460205e-001,1.8890381e-001,2.0730591e-001,2.2747803e-001,2.4768066e-001,2.6425171e-001,2.9022217e-001,2.8543091e-001,2.8408813e-001,2.7676392e-001,2.7151489e-001,2.8219604e-001,2.9119873e-001,2.9135132e-001,2.8146362e-001,2.8091431e-001,2.8741455e-001,3.4136963e-001,4.1976929e-001,4.8959351e-001,5.4672241e-001,5.3930664e-001,4.8092651e-001,4.2422485e-001,3.6129761e-001,3.4344482e-001,3.7686157e-001,3.8656616e-001,4.1961670e-001,4.1455078e-001,3.8037109e-001,3.8626099e-001,3.7683105e-001,4.0698242e-001,4.4595337e-001,4.5190430e-001,4.4989014e-001,4.1674805e-001,3.6361694e-001,3.2208252e-001,2.8784180e-001,2.5317383e-001,2.3968506e-001,2.1298218e-001,1.9323730e-001,1.8405151e-001,1.7422485e-001,1.9165039e-001,2.1652222e-001,2.5405884e-001,2.8851318e-001,3.0218506e-001,2.8289795e-001,2.2842407e-001,1.4431763e-001,6.6802979e-002,1.0864258e-002};
const int headsamplelen = 5316;

const double tailsample[]={3.9672852e-004,-4.7607422e-003,-7.9040527e-003,-5.3100586e-003,6.0424805e-003,1.0314941e-002,1.2420654e-002,1.0711670e-002,1.1596680e-003,-1.0375977e-003,-2.4414063e-004,4.2724609e-003,1.5991211e-002,2.2644043e-002,2.6672363e-002,2.6550293e-002,1.8615723e-002,1.3122559e-002,6.0119629e-003,1.4038086e-003,2.8991699e-003,3.6926270e-003,8.9111328e-003,1.2268066e-002,1.3153076e-002,1.3366699e-002,8.4533691e-003,6.1340332e-003,2.5024414e-003,-3.0517578e-005,1.2207031e-003,2.8381348e-003,8.8195801e-003,1.2908936e-002,1.5838623e-002,1.6448975e-002,1.3885498e-002,1.2603760e-002,1.0925293e-002,1.1718750e-002,1.6448975e-002,1.9195557e-002,2.1759033e-002,2.1392822e-002,1.6998291e-002,1.5777588e-002,1.4770508e-002,1.7333984e-002,2.2827148e-002,2.3315430e-002,2.1087646e-002,1.5747070e-002,7.3852539e-003,6.5307617e-003,1.1749268e-002,1.8798828e-002,2.8930664e-002,2.9785156e-002,2.1728516e-002,1.2298584e-002,-1.5563965e-003,-5.6152344e-003,1.1596680e-003,8.3618164e-003,2.2186279e-002,2.5756836e-002,1.8951416e-002,1.4251709e-002,3.7231445e-003,2.6550293e-003,1.0284424e-002,1.4648438e-002,2.2583008e-002,2.1057129e-002,1.0711670e-002,3.9978027e-003,-4.2419434e-003,-3.4484863e-003,7.5073242e-003,1.5411377e-002,2.4810791e-002,2.4993896e-002,1.2847900e-002,2.2583008e-003,-1.0833740e-002,-1.4373779e-002,-3.5095215e-003,5.4931641e-003,1.9531250e-002,2.1728516e-002,9.2773438e-003,-2.1972656e-003,-1.8341064e-002,-1.7669678e-002,2.1362305e-004,1.5991211e-002,3.6193848e-002,3.5980225e-002,1.3092041e-002,-4.7302246e-003,-2.6611328e-002,-2.3071289e-002,8.1481934e-003,2.9815674e-002,5.3955078e-002,4.7729492e-002,7.5378418e-003,-1.9836426e-002,-4.9102783e-002,-4.7180176e-002,-5.8898926e-003,2.0050049e-002,4.9835205e-002,5.1910400e-002,1.6143799e-002,6.1035156e-004,-1.9622803e-002,-1.9470215e-002,9.3078613e-003,1.4068604e-002,1.9805908e-002,1.2390137e-002,-1.3183594e-002,-1.5289307e-002,-1.0650635e-002,-1.0681152e-003,1.8524170e-002,1.7486572e-002,5.7067871e-003,-1.8005371e-003,-1.3000488e-002,-9.4909668e-003,6.9885254e-003,1.3671875e-002,2.1514893e-002,2.3345947e-002,1.6906738e-002,2.2125244e-002,2.6458740e-002,2.4597168e-002,1.8676758e-002,1.8310547e-003,-1.7852783e-002,-2.2369385e-002,-1.2420654e-002,1.1291504e-003,2.0050049e-002,1.6296387e-002,-7.6599121e-003,-2.3223877e-002,-3.7445068e-002,-2.1057129e-002,2.3315430e-002,4.6661377e-002,6.0150146e-002,3.8696289e-002,-2.1301270e-002,-5.1818848e-002,-6.6497803e-002,-4.9957275e-002,1.2329102e-002,4.1625977e-002,5.5908203e-002,5.3222656e-002,8.4838867e-003,1.9226074e-003,6.6223145e-003,1.2420654e-002,4.2327881e-002,2.9266357e-002,-3.9672852e-004,-2.1514893e-002,-4.7698975e-002,-3.5736084e-002,4.9438477e-003,2.9510498e-002,4.8431396e-002,4.1656494e-002,-5.4931641e-004,-1.8096924e-002,-3.0456543e-002,-2.8625488e-002,5.0354004e-003,1.0803223e-002,1.3427734e-002,9.8876953e-003,-1.3854980e-002,-1.3641357e-002,-7.8735352e-003,-1.4648438e-003,1.7425537e-002,2.3315430e-002,2.4719238e-002,2.8961182e-002,2.4139404e-002,2.0690918e-002,1.5655518e-002,6.1645508e-003,2.1667480e-003,3.2043457e-003,9.4299316e-003,1.0803223e-002,3.4790039e-003,-1.4465332e-002,-4.1381836e-002,-4.6264648e-002,-3.1982422e-002,-1.4953613e-003,4.4494629e-002,5.9265137e-002,4.2572021e-002,1.1810303e-002,-4.1900635e-002,-5.9204102e-002,-4.0557861e-002,-2.1118164e-002,2.1728516e-002,2.5238037e-002,-2.8686523e-003,-1.1718750e-002,-2.8778076e-002,-4.5166016e-003,4.7241211e-002,6.2744141e-002,6.0760498e-002,2.5177002e-002,-4.1503906e-002,-6.0638428e-002,-4.0832520e-002,-8.1787109e-003,5.6121826e-002,6.1309814e-002,1.5411377e-002,-2.1636963e-002,-8.2824707e-002,-7.8430176e-002,-1.7181396e-002,1.7089844e-002,6.1401367e-002,4.8248291e-002,-1.9622803e-002,-4.0893555e-002,-5.1940918e-002,-2.3101807e-002,5.4779053e-002,6.9946289e-002,5.5114746e-002,2.0629883e-002,-5.2734375e-002,-5.8593750e-002,-2.0843506e-002,1.0528564e-002,6.4514160e-002,5.5145264e-002,-4.5471191e-003,-3.0792236e-002,-5.9204102e-002,-3.5095215e-002,3.9489746e-002,5.9997559e-002,6.1889648e-002,3.0059814e-002,-4.4494629e-002,-5.3039551e-002,-2.5451660e-002,6.8664551e-003,6.6497803e-002,5.5328369e-002,-8.2397461e-003,-4.8919678e-002,-9.7900391e-002,-7.6599121e-002,1.0620117e-002,5.7800293e-002,9.8510742e-002,8.3862305e-002,8.5449219e-004,-2.9815674e-002,-4.5501709e-002,-2.9541016e-002,4.2053223e-002,4.9926758e-002,3.2470703e-002,4.3945313e-003,-5.9387207e-002,-5.7983398e-002,-1.9775391e-002,1.3946533e-002,6.5551758e-002,6.4910889e-002,2.1331787e-002,3.3569336e-004,-2.5665283e-002,-1.5930176e-002,3.4545898e-002,4.6752930e-002,5.2124023e-002,3.3264160e-002,-1.7822266e-002,-2.9510498e-002,-2.5177002e-002,-1.1627197e-002,2.4261475e-002,3.0090332e-002,1.7395020e-002,1.3610840e-002,-7.0190430e-004,6.4697266e-003,2.7679443e-002,2.7008057e-002,2.1484375e-002,3.6926270e-003,-2.1423340e-002,-1.9531250e-002,3.8757324e-003,2.8320313e-002,5.8776855e-002,6.1004639e-002,3.3325195e-002,1.4343262e-002,-1.2573242e-002,-1.6265869e-002,7.3852539e-003,1.0498047e-002,1.3580322e-002,-2.4719238e-003,-4.0222168e-002,-4.6539307e-002,-3.5064697e-002,-1.4038086e-003,5.9661865e-002,8.8409424e-002,8.7677002e-002,6.4178467e-002,1.1596680e-003,-3.3721924e-002,-4.0832520e-002,-3.0975342e-002,2.4047852e-002,4.5013428e-002,4.1259766e-002,1.7547607e-002,-5.5084229e-002,-8.8928223e-002,-1.0244751e-001,-8.5479736e-002,-1.4587402e-002,2.5726318e-002,5.4931641e-002,5.8258057e-002,1.5808105e-002,7.5683594e-003,1.1383057e-002,3.3294678e-002,8.9599609e-002,9.8968506e-002,8.4686279e-002,5.1452637e-002,-1.2817383e-002,-2.8045654e-002,-1.1169434e-002,1.4495850e-002,6.2225342e-002,5.9326172e-002,1.1627197e-002,-2.8717041e-002,-8.4747314e-002,-8.7188721e-002,-3.6071777e-002,-5.7067871e-003,3.6926270e-002,3.0548096e-002,-2.4505615e-002,-4.4860840e-002,-6.3385010e-002,-4.1229248e-002,2.5054932e-002,4.3151855e-002,4.0924072e-002,1.2878418e-002,-5.4351807e-002,-5.9783936e-002,-2.4475098e-002,2.8503418e-002,1.2042236e-001,1.4807129e-001,1.2088013e-001,8.5083008e-002,6.1035156e-003,-1.8768311e-002,6.0424805e-003,1.7974854e-002,6.2957764e-002,5.5603027e-002,5.9204102e-003,-2.1301270e-002,-6.8084717e-002,-7.1136475e-002,-4.0039063e-002,-2.9998779e-002,-1.2359619e-002,-1.6052246e-002,-4.2785645e-002,-4.2694092e-002,-3.3935547e-002,-1.7272949e-002,1.8280029e-002,2.9418945e-002,3.0273438e-002,3.2318115e-002,2.2735596e-002,2.8411865e-002,4.3273926e-002,4.9652100e-002,5.8258057e-002,5.8105469e-002,4.6844482e-002,4.2419434e-002,3.3447266e-002,2.3712158e-002,1.6998291e-002,2.5939941e-003,-9.9487305e-003,-1.8890381e-002,-2.4414063e-002,-2.5115967e-002,-2.2155762e-002,-2.1179199e-002,-2.2949219e-002,-2.3956299e-002,-2.8717041e-002,-2.9571533e-002,-3.0120850e-002,-3.2684326e-002,-3.2165527e-002,-2.8625488e-002,-1.7059326e-002,6.4086914e-004,2.4322510e-002,4.4799805e-002,5.7128906e-002,6.3476563e-002,5.7189941e-002,5.2520752e-002,4.9041748e-002,4.2144775e-002,4.0710449e-002,2.8076172e-002,1.1840820e-002,-2.0751953e-003,-1.7456055e-002,-2.3223877e-002,-2.4475098e-002,-2.9571533e-002,-3.7811279e-002,-4.3212891e-002,-4.6081543e-002,-3.2745361e-002,-4.2419434e-003,1.7974854e-002,3.6407471e-002,3.5369873e-002,1.3153076e-002,2.4414063e-004,-7.5988770e-003,-2.7465820e-003,2.3742676e-002,3.2714844e-002,3.2928467e-002,2.5665283e-002,-2.2888184e-003,-9.2163086e-003,-8.3618164e-003,-5.1879883e-003,9.8571777e-003,6.9885254e-003,-4.6691895e-003,-1.2451172e-002,-2.0477295e-002,-1.4099121e-002,6.5002441e-003,1.9470215e-002,3.0639648e-002,3.0120850e-002,1.2329102e-002,4.8828125e-004,-1.3366699e-002,-2.0965576e-002,-1.7150879e-002,-1.7730713e-002,-1.6418457e-002,-1.7639160e-002,-2.3468018e-002,-2.0629883e-002,-1.4862061e-002,-6.2255859e-003,5.8288574e-003,1.1352539e-002,1.3702393e-002,1.3641357e-002,1.2237549e-002,1.3824463e-002,1.8737793e-002,2.2369385e-002,2.7313232e-002,3.0456543e-002,3.0090332e-002,2.9998779e-002,2.4963379e-002,2.0721436e-002,1.3885498e-002,8.9416504e-003,6.2866211e-003,1.8310547e-003,-7.3242188e-004,-1.0467529e-002,-2.3406982e-002,-3.4271240e-002,-4.4036865e-002,-4.4677734e-002,-3.5095215e-002,-2.7679443e-002,-1.7852783e-002,-8.5449219e-003,-3.7231445e-003,1.2512207e-002,2.9541016e-002,4.4677734e-002,5.8319092e-002,5.7617188e-002,4.8400879e-002,4.1351318e-002,3.5156250e-002,3.3050537e-002,3.7628174e-002,2.9174805e-002,1.4282227e-002,-1.7700195e-003,-2.3376465e-002,-2.9388428e-002,-2.5054932e-002,-2.0660400e-002,-1.3549805e-002,-1.7700195e-002,-3.5308838e-002,-4.4647217e-002,-5.0323486e-002,-4.2572021e-002,-1.4007568e-002,9.9487305e-003,3.6987305e-002,5.3009033e-002,5.1696777e-002,5.6060791e-002,5.3588867e-002,5.7159424e-002,6.9976807e-002,7.0007324e-002,6.8786621e-002,5.7128906e-002,3.5308838e-002,2.3620605e-002,1.5258789e-002,1.2573242e-002,1.6998291e-002,1.0314941e-002,-5.1269531e-003,-2.1270752e-002,-4.4708252e-002,-5.5999756e-002,-5.5725098e-002,-5.5541992e-002,-4.4189453e-002,-3.8604736e-002,-3.6071777e-002,-2.7740479e-002,-2.2308350e-002,-8.4838867e-003,1.0009766e-002,2.6367188e-002,4.4342041e-002,5.6549072e-002,6.1614990e-002,6.2805176e-002,5.7556152e-002,5.1666260e-002,4.8278809e-002,4.4372559e-002,4.4281006e-002,3.7322998e-002,2.3681641e-002,6.7443848e-003,-1.8371582e-002,-3.4362793e-002,-4.4219971e-002,-4.9316406e-002,-4.4799805e-002,-4.6783447e-002,-5.1025391e-002,-5.4168701e-002,-6.0913086e-002,-5.8074951e-002,-4.8980713e-002,-3.6712646e-002,-1.6784668e-002,-1.1596680e-003,1.2237549e-002,2.6977539e-002,3.7322998e-002,5.2062988e-002,6.6925049e-002,7.7911377e-002,8.5113525e-002,7.9437256e-002,6.2957764e-002,4.2480469e-002,1.8402100e-002,2.4719238e-003,-1.4038086e-003,-4.3334961e-003,-1.0070801e-003,-5.6152344e-003,-2.1514893e-002,-3.3905029e-002,-5.3009033e-002,-6.2896729e-002,-6.3415527e-002,-6.6802979e-002,-6.1309814e-002,-5.8105469e-002,-5.2642822e-002,-3.9154053e-002,-2.3284912e-002,-4.4555664e-003,1.3671875e-002,2.9693604e-002,3.9947510e-002,4.9285889e-002,5.5511475e-002,5.7800293e-002,5.9570313e-002,5.6427002e-002,5.3222656e-002,5.0537109e-002,4.7729492e-002,4.2175293e-002,3.2775879e-002,1.7211914e-002,-5.0964355e-003,-2.4871826e-002,-4.3365479e-002,-5.2612305e-002,-5.0720215e-002,-4.6203613e-002,-3.6529541e-002,-2.9083252e-002,-2.8656006e-002,-2.7557373e-002,-3.0548096e-002,-3.0273438e-002,-2.2888184e-002,-1.3702393e-002,5.5541992e-003,1.9439697e-002,3.2165527e-002,4.2327881e-002,4.4311523e-002,5.0415039e-002,5.3894043e-002,5.6610107e-002,5.9509277e-002,5.6457520e-002,5.1422119e-002,4.6142578e-002,4.0130615e-002,3.3752441e-002,2.6367188e-002,1.5197754e-002,1.1901855e-003,-1.2390137e-002,-2.6397705e-002,-3.7231445e-002,-4.3334961e-002,-5.0079346e-002,-5.3710938e-002,-5.3161621e-002,-4.9743652e-002,-4.0100098e-002,-2.6245117e-002,-1.1199951e-002,4.7302246e-003,2.1057129e-002,3.5095215e-002,4.4738770e-002,4.7729492e-002,4.1625977e-002,3.0395508e-002,2.0538330e-002,1.7578125e-002,1.9836426e-002,3.1158447e-002,3.6010742e-002,3.2257080e-002,2.5207520e-002,5.3100586e-003,-4.6081543e-003,-9.1552734e-003,-1.4587402e-002,-9.1552734e-003,-1.2451172e-002,-1.7822266e-002,-2.1545410e-002,-2.9174805e-002,-3.0548096e-002,-2.9907227e-002,-2.8747559e-002,-2.4536133e-002,-2.0507813e-002,-1.6113281e-002,-7.6293945e-003,3.2348633e-003,1.5716553e-002,2.8533936e-002,3.9215088e-002,4.7515869e-002,5.1544189e-002,5.1818848e-002,5.0292969e-002,4.7973633e-002,4.3457031e-002,3.8970947e-002,2.9357910e-002,1.6601563e-002,3.9367676e-003,-8.9416504e-003,-1.4617920e-002,-1.6265869e-002,-1.6815186e-002,-1.6876221e-002,-1.9348145e-002,-2.4383545e-002,-2.5573730e-002,-2.4810791e-002,-2.2460938e-002,-1.4831543e-002,-9.2163086e-003,-1.1901855e-003,7.3852539e-003,1.5136719e-002,2.1392822e-002,2.3406982e-002,2.3620605e-002,2.1667480e-002,2.5909424e-002,3.5186768e-002,4.5471191e-002,5.8044434e-002,6.2164307e-002,5.7006836e-002,5.0659180e-002,3.7506104e-002,2.6550293e-002,1.9775391e-002,8.0261230e-003,1.2207031e-003,-6.8664551e-003,-1.3732910e-002,-1.6448975e-002,-1.9866943e-002,-2.2613525e-002,-2.7587891e-002,-2.3986816e-002,-1.7211914e-002,-4.3640137e-003,1.3763428e-002,2.4353027e-002,2.9083252e-002,2.8961182e-002,2.2064209e-002,2.2521973e-002,3.0273438e-002,3.6193848e-002,4.8553467e-002,5.1849365e-002,4.6630859e-002,4.2541504e-002,2.9724121e-002,2.1820068e-002,1.7425537e-002,1.1505127e-002,1.1444092e-002,9.1857910e-003,6.0729980e-003,4.6081543e-003,1.8005371e-003,1.3427734e-003,2.5329590e-003,4.1198730e-003,6.5002441e-003,5.8898926e-003,4.2114258e-003,4.2724609e-003,6.6833496e-003,1.3702393e-002,2.4291992e-002,2.9266357e-002,2.8961182e-002,2.3315430e-002,1.0864258e-002,3.7841797e-003,1.8310547e-003,2.8686523e-003,1.1779785e-002,1.7456055e-002,2.1942139e-002,2.7374268e-002,2.6947021e-002,2.7008057e-002,2.4627686e-002,2.1606445e-002,2.0904541e-002,2.1148682e-002,2.3437500e-002,1.8341064e-002,8.1176758e-003,-6.2561035e-003,-2.5146484e-002,-3.1768799e-002,-2.5604248e-002,-1.4465332e-002,3.6621094e-003,8.3923340e-003,3.3569336e-004,-5.9814453e-003,-1.6448975e-002,-8.5449219e-003,1.7181396e-002,3.7902832e-002,6.2896729e-002,6.9183350e-002,5.6091309e-002,4.6691895e-002,3.0181885e-002,2.3803711e-002,3.0151367e-002,2.8106689e-002,2.8106689e-002,2.0202637e-002,2.8991699e-003,-4.0283203e-003,-8.6364746e-003,-6.1645508e-003,4.2724609e-003,6.8054199e-003,4.1198730e-003,-2.7770996e-003,-1.6296387e-002,-2.3498535e-002,-2.4291992e-002,-2.3864746e-002,-1.6082764e-002,-1.4190674e-002,-1.6510010e-002,-1.6693115e-002,-2.2064209e-002,-1.9744873e-002,-1.3275146e-002,-5.3710938e-003,7.6293945e-003,1.7517090e-002,2.4322510e-002,2.7587891e-002,2.5482178e-002,2.3468018e-002,2.3834229e-002,2.8228760e-002,4.0863037e-002,5.0262451e-002,5.6854248e-002,5.4870605e-002,3.8787842e-002,2.6397705e-002,1.2512207e-002,6.3781738e-003,1.5594482e-002,1.8402100e-002,2.3193359e-002,2.2521973e-002,1.1291504e-002,6.3476563e-003,-7.0190430e-004,-5.3100586e-003,-2.9602051e-003,-5.7067871e-003,-5.3405762e-003,-4.9133301e-003,-6.3171387e-003,-5.6152344e-003,-5.8593750e-003,-5.8593750e-003,-5.3710938e-003,-1.5258789e-003,3.8452148e-003,9.1552734e-003,1.4251709e-002,1.6204834e-002,1.5930176e-002,1.7974854e-002,2.1331787e-002,2.3681641e-002,2.6184082e-002,2.1240234e-002,1.2054443e-002,5.9509277e-003,1.8920898e-003,5.2490234e-003,1.5777588e-002,2.1881104e-002,2.5054932e-002,2.5451660e-002,1.7028809e-002,1.5441895e-002,1.5808105e-002,1.6754150e-002,2.4261475e-002,2.5329590e-002,2.5421143e-002,2.4505615e-002,1.9775391e-002,1.7333984e-002,1.5014648e-002,1.2969971e-002,1.2359619e-002,1.0498047e-002,7.8125000e-003,3.7231445e-003,-3.1127930e-003,-8.2702637e-003,-1.3336182e-002,-1.4099121e-002,-1.0925293e-002,-9.6740723e-003,-7.3852539e-003,-9.1247559e-003,-1.4221191e-002,-1.4099121e-002,-1.0528564e-002,-2.8076172e-003,1.0986328e-002,1.9226074e-002,2.5024414e-002,2.8076172e-002,2.5054932e-002,2.5634766e-002,2.6519775e-002,2.6336670e-002,2.7465820e-002,2.3803711e-002,1.8310547e-002,1.3732910e-002,8.5754395e-003,6.3476563e-003,5.6152344e-003,4.4250488e-003,2.7465820e-003,6.4086914e-004,-2.1667480e-003,-4.7912598e-003,-6.6223145e-003,-8.8806152e-003,-1.0345459e-002,-1.1352539e-002,-1.1474609e-002,-1.0375977e-002,-8.1787109e-003,-5.1574707e-003,-1.3732910e-003,3.6926270e-003,8.0871582e-003,1.3977051e-002,1.9195557e-002,2.2857666e-002,2.4597168e-002,2.2796631e-002,1.8981934e-002,1.5380859e-002,1.4099121e-002,1.6113281e-002,2.2827148e-002,2.8045654e-002,3.1402588e-002,3.0822754e-002,2.3254395e-002,1.7730713e-002,1.1260986e-002,7.1105957e-003,8.2092285e-003,4.7912598e-003,4.1198730e-003,1.6784668e-003,-4.3334961e-003,-6.5612793e-003,-8.3007813e-003,-7.6599121e-003,-5.3405762e-003,-4.4860840e-003,-4.6997070e-003,-5.2185059e-003,-6.8359375e-003,-7.9956055e-003,-7.5683594e-003,-6.4392090e-003,-2.6855469e-003,2.0751953e-003,8.0566406e-003,1.4129639e-002,1.9042969e-002,2.3132324e-002,2.5054932e-002,2.6336670e-002,2.5329590e-002,2.1850586e-002,1.6937256e-002,1.2023926e-002,9.7351074e-003,1.1413574e-002,1.8035889e-002,2.4017334e-002,2.8778076e-002,2.9235840e-002,2.0782471e-002,1.2451172e-002,8.2397461e-004,-8.7890625e-003,-1.1322021e-002,-1.5777588e-002,-1.3061523e-002,-9.8876953e-003,-6.2866211e-003,-3.0517578e-004,1.0681152e-003,2.1057129e-003,-1.2817383e-003,-4.3334961e-003,-6.4392090e-003,-6.7749023e-003,-1.6784668e-003,1.4953613e-003,6.1645508e-003,9.0637207e-003,8.7585449e-003,1.0955811e-002,1.1749268e-002,1.2878418e-002,1.4099121e-002,1.2268066e-002,1.0406494e-002,7.7514648e-003,6.1340332e-003,6.6223145e-003,1.0162354e-002,1.3397217e-002,1.5838623e-002,1.7608643e-002,1.5380859e-002,1.4312744e-002,1.2176514e-002,9.9182129e-003,9.5825195e-003,7.7819824e-003,6.9885254e-003,6.2561035e-003,5.2795410e-003,5.2185059e-003,3.6621094e-003,1.2512207e-003,-1.9226074e-003,-4.3640137e-003,-4.9743652e-003,-4.8828125e-003,-3.0517578e-003,-1.4038086e-003,0.0000000e+000,1.0375977e-003,1.4038086e-003,3.7231445e-003,7.1411133e-003,1.0345459e-002,1.2420654e-002,1.1474609e-002,7.9956055e-003,5.4626465e-003,3.9672852e-003,4.2114258e-003,7.9956055e-003,8.8500977e-003,8.1481934e-003,7.2631836e-003,3.4179688e-003,2.1057129e-003,1.2512207e-003,4.5776367e-004,2.7160645e-003,4.2114258e-003,6.6833496e-003,1.0101318e-002,1.2023926e-002,1.2145996e-002,9.7961426e-003,4.7912598e-003,-1.8615723e-003,-5.4931641e-003,-6.4697266e-003,-5.2490234e-003,-1.3732910e-003,2.2583008e-003,5.1269531e-003,7.8735352e-003,6.9885254e-003,5.8593750e-003,2.6550293e-003,-2.7770996e-003,-7.0800781e-003,-1.0406494e-002,-9.3078613e-003,-6.3476563e-003,2.1362305e-004,5.7067871e-003,8.0566406e-003,9.6740723e-003,5.7067871e-003,2.5634766e-003,-2.0446777e-003,-8.4838867e-003,-1.1718750e-002,-1.5930176e-002,-1.5319824e-002,-1.2054443e-002,-6.1340332e-003,3.6621094e-004,3.4790039e-003,5.0354004e-003,4.8828125e-004,-1.8920898e-003,-3.0822754e-003,-3.2653809e-003,1.9226074e-003,4.7302246e-003,8.0261230e-003,1.1352539e-002,1.2207031e-002,1.4984131e-002,1.6876221e-002,1.5625000e-002,1.3122559e-002,8.4838867e-003,2.5939941e-003,-1.3427734e-003,-2.6550293e-003,-3.2348633e-003,-6.7138672e-004,-3.9672852e-004,-1.7395020e-003,-1.6174316e-003,-3.8452148e-003,-4.6386719e-003,-5.2490234e-003,-8.8195801e-003,-1.1718750e-002,-1.3977051e-002,-1.5838623e-002,-1.4068604e-002,-8.6669922e-003,-3.0822754e-003,2.3498535e-003,6.3171387e-003,6.5612793e-003,6.7443848e-003,5.6762695e-003,4.2724609e-003,4.5166016e-003,4.1198730e-003,6.1035156e-003,8.1481934e-003,1.0040283e-002,1.1108398e-002,9.4909668e-003,8.3007813e-003,5.6457520e-003,4.3334961e-003,3.9062500e-003,3.4179688e-003,3.3874512e-003,1.8920898e-003,-6.1035156e-004,-2.1972656e-003,-3.7841797e-003,-5.2185059e-003,-5.7983398e-003,-7.2326660e-003,-9.3078613e-003,-9.7045898e-003,-7.9956055e-003,-4.1503906e-003,1.2207031e-003,5.2490234e-003,6.7138672e-003,7.1411133e-003,4.5166016e-003,3.2043457e-003,3.8452148e-003,3.5095215e-003,5.7067871e-003,6.0424805e-003,5.4321289e-003,5.3405762e-003,2.7770996e-003,1.2817383e-003,-1.6479492e-003,-3.9672852e-003,-5.3405762e-003,-6.4697266e-003,-6.7443848e-003,-6.7749023e-003,-4.1503906e-003,-3.8146973e-003,-4.7912598e-003,-5.7067871e-003,-7.6293945e-003,-8.5449219e-003,-8.1176758e-003,-6.9885254e-003,-4.1198730e-003,-3.9672852e-004,3.4790039e-003,6.2866211e-003,7.2326660e-003,6.9580078e-003,5.7983398e-003,5.3405762e-003,6.7138672e-003,7.9040527e-003,1.0253906e-002,9.9487305e-003,7.5683594e-003,5.8898926e-003,4.0283203e-003,4.4555664e-003,6.5612793e-003,6.7749023e-003,4.8828125e-003,2.1972656e-003,-2.8991699e-003,-5.5236816e-003,-6.0729980e-003,-6.3781738e-003,-4.7607422e-003,-5.1879883e-003,-6.9885254e-003,-6.9885254e-003,-7.1105957e-003,-6.5002441e-003,-4.4555664e-003,-5.0048828e-003,-6.4697266e-003,-5.8288574e-003,-4.1503906e-003,1.0070801e-003,9.6130371e-003,1.5197754e-002,1.7913818e-002,1.6845703e-002,9.0637207e-003,4.3334961e-003,7.6293945e-004,-7.9345703e-004,4.6691895e-003,8.4838867e-003,1.4282227e-002,1.9897461e-002,2.1545410e-002,2.4230957e-002,2.1057129e-002,1.5960693e-002,8.8806152e-003,5.4931641e-004,-3.5400391e-003,-6.6833496e-003,-3.9978027e-003,-1.5258789e-004,4.5166016e-003,1.0925293e-002,1.3183594e-002,1.5777588e-002,1.3488770e-002,8.7585449e-003,2.6245117e-003,-4.4250488e-003,-7.2937012e-003,-8.6975098e-003,-3.9672852e-003,1.1291504e-003,7.2631836e-003,1.3153076e-002,1.4129639e-002,1.5136719e-002,1.1047363e-002,6.4697266e-003,1.6784668e-003,-4.0283203e-003,-5.9814453e-003,-6.4392090e-003,-1.3427734e-003,5.0659180e-003,1.2573242e-002,1.9500732e-002,2.0416260e-002,2.0935059e-002,1.6326904e-002,1.1383057e-002,7.7819824e-003,3.0212402e-003,3.8757324e-003,4.7302246e-003,9.0026855e-003,1.4831543e-002,1.9042969e-002,2.3742676e-002,2.2888184e-002,2.0751953e-002,1.4526367e-002,6.6833496e-003,3.0517578e-004,-5.4016113e-003,-6.2255859e-003,-5.7373047e-003,-1.0681152e-003,6.5917969e-003,1.3671875e-002,2.0385742e-002,2.1087646e-002,2.0263672e-002,1.4465332e-002,8.3007813e-003,5.6152344e-003,2.8686523e-003,7.7209473e-003,1.1383057e-002,1.6906738e-002,2.2308350e-002,2.2644043e-002,2.4078369e-002,1.9927979e-002,1.6204834e-002,1.2145996e-002,6.8664551e-003,5.8593750e-003,4.8828125e-003,7.1105957e-003,1.0284424e-002,1.3854980e-002,1.7730713e-002,1.9531250e-002,2.1850586e-002,2.2796631e-002,2.3864746e-002,2.3742676e-002,2.1453857e-002,1.8615723e-002,1.4739990e-002,1.2939453e-002,1.3793945e-002,1.7639160e-002,2.1911621e-002,2.4444580e-002,2.4353027e-002,1.8554688e-002,1.3519287e-002,7.3547363e-003,4.3029785e-003,7.7514648e-003,9.5214844e-003,1.5167236e-002,1.9470215e-002,2.0935059e-002,2.4810791e-002,2.6367188e-002,2.7221680e-002,2.7893066e-002,2.5573730e-002,2.2369385e-002,2.0233154e-002,1.9226074e-002,1.7913818e-002,1.7456055e-002,1.6113281e-002,1.3092041e-002,1.2115479e-002,1.0528564e-002,1.0589600e-002,1.1535645e-002,9.8571777e-003,6.5612793e-003,3.6315918e-003,1.0375977e-003,1.9836426e-003,7.4157715e-003,1.1505127e-002,1.5930176e-002,1.8646240e-002,1.7333984e-002,1.8127441e-002,1.8371582e-002,1.8768311e-002,2.0477295e-002,1.9744873e-002,1.8524170e-002,1.8676758e-002,1.9134521e-002,2.0446777e-002,2.1850586e-002,1.9927979e-002,1.6204834e-002,1.3061523e-002,1.0070801e-002,8.8195801e-003,1.0009766e-002,9.5214844e-003,8.8806152e-003,7.8430176e-003,6.8054199e-003,9.1552734e-003,1.2847900e-002,1.5777588e-002,1.6906738e-002,1.5502930e-002,1.0833740e-002,7.6293945e-003,5.9814453e-003,4.3640137e-003,5.7373047e-003,5.1574707e-003,4.0893555e-003,5.5236816e-003,7.1411133e-003,1.0589600e-002,1.5319824e-002,1.7852783e-002,1.9348145e-002,2.0690918e-002,1.9958496e-002,2.2125244e-002,2.3803711e-002,2.4108887e-002,2.5299072e-002,2.5604248e-002,2.5787354e-002,2.5238037e-002,2.2613525e-002,1.7822266e-002,9.3383789e-003,2.6855469e-003,-2.0446777e-003,-3.5400391e-003,1.0681152e-003,3.5400391e-003,5.7067871e-003,6.7443848e-003,3.7841797e-003,5.2795410e-003,8.0871582e-003,1.0528564e-002,1.4801025e-002,1.3885498e-002,1.0498047e-002,8.9416504e-003,7.2937012e-003,8.6364746e-003,1.1932373e-002,1.2481689e-002,1.2542725e-002,1.3244629e-002,1.2969971e-002,1.5258789e-002,1.8127441e-002,1.8463135e-002,1.7425537e-002,1.4862061e-002,1.2512207e-002,1.3702393e-002,1.8646240e-002,2.2094727e-002,2.4536133e-002,2.2735596e-002,1.4923096e-002,9.9792480e-003,5.4931641e-003,5.0354004e-003,1.1352539e-002,1.4678955e-002,1.8707275e-002,2.0782471e-002,1.7669678e-002,1.6937256e-002,1.5319824e-002,1.4160156e-002,1.8096924e-002,1.9256592e-002,2.1820068e-002,2.3895264e-002,2.1667480e-002,1.9592285e-002,1.4923096e-002,1.1535645e-002,9.6740723e-003,8.5449219e-003,9.4604492e-003,9.3383789e-003,7.9345703e-003,7.5378418e-003,6.1340332e-003,6.2255859e-003,8.3923340e-003,9.5520020e-003,1.1749268e-002,1.3610840e-002,1.5075684e-002,1.7364502e-002,2.0507813e-002,2.2705078e-002,2.4475098e-002,2.4169922e-002,2.1331787e-002,1.9256592e-002,1.5808105e-002,1.2573242e-002,1.0223389e-002,7.8430176e-003,6.1950684e-003,5.9814453e-003,6.2866211e-003,8.0566406e-003,1.1108398e-002,1.5380859e-002,1.9927979e-002,2.3834229e-002,2.6184082e-002,2.4719238e-002,2.0538330e-002,1.3397217e-002,5.9204102e-003,7.9345703e-004,-3.0517578e-005,1.6174316e-003,6.8359375e-003,1.0955811e-002,1.1993408e-002,1.3793945e-002,1.1047363e-002,1.1169434e-002,1.2207031e-002,1.3031006e-002,1.5716553e-002,1.7395020e-002,2.0751953e-002,2.1820068e-002,2.2033691e-002,2.0324707e-002,1.5045166e-002,9.6130371e-003,4.2419434e-003,1.6174316e-003,3.7841797e-003,6.8054199e-003,1.1505127e-002,1.3885498e-002,1.0650635e-002,9.2468262e-003,5.6762695e-003,5.4016113e-003,1.0223389e-002,1.1047363e-002,1.3031006e-002,1.1108398e-002,3.7841797e-003,-2.4414063e-004,-3.7231445e-003,-2.5634766e-003,4.6997070e-003,1.0986328e-002,1.7700195e-002,2.2308350e-002,2.0263672e-002,1.8493652e-002,1.3031006e-002,8.9721680e-003,9.3688965e-003,9.7351074e-003,1.6387939e-002,2.0874023e-002,2.3773193e-002,2.4566650e-002,1.7120361e-002,1.1474609e-002,3.9367676e-003,-7.6293945e-004,1.0375977e-003,1.5258789e-003,5.3710938e-003,6.3476563e-003,3.4179688e-003,3.2348633e-003,1.6479492e-003,3.3569336e-003,8.7585449e-003,1.1138916e-002,1.3824463e-002,1.3671875e-002,1.0375977e-002,9.6435547e-003,8.3007813e-003,9.7045898e-003,1.3458252e-002,1.3610840e-002,1.2115479e-002,1.0253906e-002,6.5612793e-003,7.5378418e-003,1.1688232e-002,1.5472412e-002,2.0721436e-002,2.0416260e-002,1.5441895e-002,1.0864258e-002,5.1879883e-003,4.5776367e-003,1.0498047e-002,1.5899658e-002,2.3010254e-002,2.5817871e-002,2.2308350e-002,2.0233154e-002,1.4892578e-002,1.2939453e-002,1.3580322e-002,1.2359619e-002,1.3397217e-002,1.2298584e-002,1.1230469e-002,1.1260986e-002,1.0314941e-002,9.0332031e-003,6.6528320e-003,5.1879883e-003,6.2561035e-003,9.2773438e-003,1.5594482e-002,1.8768311e-002,1.8493652e-002,1.4221191e-002,3.8757324e-003,-3.5400391e-003,-7.7209473e-003,-7.9040527e-003,-1.0681152e-003,2.6245117e-003,4.3029785e-003,2.3193359e-003,-7.0800781e-003,-1.0345459e-002,-9.7045898e-003,2.1362305e-004,2.4261475e-002,4.4372559e-002,6.2744141e-002,6.4727783e-002,4.4860840e-002,2.3773193e-002,-4.8217773e-003,-1.7700195e-002,-6.0119629e-003,5.3710938e-003,2.7893066e-002,3.4301758e-002,1.7089844e-002,6.8359375e-003,-1.5747070e-002,-1.9744873e-002,-4.0893555e-003,3.1738281e-003,2.0446777e-002,2.1514893e-002,8.9111328e-003,2.8076172e-003,-9.1247559e-003,-1.5472412e-002,-1.4312744e-002,-1.8798828e-002,-1.8371582e-002,-1.3885498e-002,-7.6599121e-003,2.9296875e-003,9.2773438e-003,9.0026855e-003,-6.4086914e-004,-5.8898926e-003,-4.8217773e-003,5.5236816e-003,3.0395508e-002,4.1229248e-002,4.2663574e-002,3.2440186e-002,4.3029785e-003,-8.4838867e-003,-9.4299316e-003,-2.0446777e-003,2.5299072e-002,3.7597656e-002,3.6926270e-002,3.0731201e-002,2.4414063e-003,-1.3519287e-002,-2.1453857e-002,-2.4444580e-002,-5.6152344e-003,5.1879883e-003,1.5563965e-002,1.9866943e-002,5.8593750e-003,-3.2043457e-003,-1.6967773e-002,-2.1545410e-002,-1.0894775e-002,-2.3498535e-003,1.4709473e-002,2.0751953e-002,1.3488770e-002,7.3852539e-003,-8.2397461e-003,-1.4984131e-002,-1.1566162e-002,-8.2092285e-003,6.0729980e-003,1.5167236e-002,1.8859863e-002,2.2918701e-002,1.7028809e-002,1.3366699e-002,9.4909668e-003,6.2561035e-003,1.1169434e-002,1.5075684e-002,2.2552490e-002,2.5146484e-002,2.0690918e-002,1.4587402e-002,1.7700195e-003,-4.3029785e-003,-3.1127930e-003,1.3122559e-003,1.3793945e-002,1.9134521e-002,1.6571045e-002,1.1352539e-002,-2.5939941e-003,-8.5754395e-003,-6.5307617e-003,-1.3427734e-003,1.5502930e-002,2.5390625e-002,2.8076172e-002,2.6153564e-002,1.1535645e-002,1.3732910e-003,-6.0119629e-003,-1.0406494e-002,-3.7841797e-003,-1.5258789e-003,2.0751953e-003,5.3405762e-003,3.4484863e-003,8.1176758e-003,1.2939453e-002,1.9348145e-002,2.8167725e-002,3.3538818e-002,3.7048340e-002,3.8665771e-002,3.5247803e-002,2.7770996e-002,1.8951416e-002,6.1645508e-003,-5.0048828e-003,-1.1047363e-002,-1.0192871e-002,-6.1035156e-003,-1.2207031e-004,2.8381348e-003,-1.5563965e-003,-3.3569336e-003,-6.0729980e-003,-3.8757324e-003,5.2795410e-003,5.3405762e-003,1.8005371e-003,-1.2481689e-002,-3.7017822e-002,-5.6549072e-002,-7.1563721e-002,-7.7850342e-002,-7.0220947e-002,-6.1492920e-002,-5.0537109e-002,-3.6193848e-002,-2.9602051e-002,-1.7547607e-002,-8.0871582e-003,-1.2512207e-003,7.1716309e-003,8.5449219e-003,1.1169434e-002,1.0040283e-002,1.0009766e-002,8.9721680e-003,7.9956055e-003,8.3923340e-003,7.5378418e-003,1.0498047e-002,1.2054443e-002,1.7059326e-002,2.0568848e-002,2.4597168e-002,2.7801514e-002,2.7435303e-002,2.7404785e-002,2.4383545e-002,2.2399902e-002,1.8951416e-002,1.6082764e-002,1.0009766e-002,1.8615723e-003,-8.5144043e-003,-2.1270752e-002,-2.8320313e-002,-3.2043457e-002,-2.8991699e-002,-2.0477295e-002,-1.2969971e-002,-9.3688965e-003,-1.0437012e-002,-1.8402100e-002,-2.1972656e-002,-1.9104004e-002,-1.3366699e-002,3.2348633e-003,1.3427734e-002,2.0507813e-002,2.3834229e-002,1.7578125e-002,1.5502930e-002,1.3488770e-002,1.3824463e-002,1.9348145e-002,2.1820068e-002,2.4047852e-002,2.6397705e-002,2.5817871e-002,2.8930664e-002,3.2592773e-002,3.4942627e-002,3.7628174e-002,3.6956787e-002,3.4576416e-002,3.2318115e-002,3.0914307e-002,3.0822754e-002,3.2714844e-002,3.1188965e-002,2.9388428e-002,2.5878906e-002,1.7944336e-002,1.1962891e-002,4.6997070e-003,-3.6315918e-003,-1.0742188e-002,-2.1240234e-002,-3.0364990e-002,-3.5919189e-002,-3.7719727e-002,-3.4057617e-002,-2.6336670e-002,-2.0385742e-002,-1.7242432e-002,-1.6326904e-002,-1.9409180e-002,-1.8981934e-002,-1.4312744e-002,-7.5073242e-003,4.1198730e-003,1.1444092e-002,1.5594482e-002,1.8798828e-002,1.7486572e-002,2.1270752e-002,3.0273438e-002,4.0374756e-002,5.4138184e-002,6.3018799e-002,6.7291260e-002,6.8908691e-002,6.4483643e-002,6.1920166e-002,6.0119629e-002,5.5511475e-002,5.2459717e-002,4.4799805e-002,3.4545898e-002,2.5238037e-002,1.5136719e-002,8.0566406e-003,2.3193359e-003,-5.2795410e-003,-1.4556885e-002,-2.5634766e-002,-3.8818359e-002,-4.9072266e-002,-5.5236816e-002,-6.0333252e-002,-6.0729980e-002,-6.1828613e-002,-6.2835693e-002,-5.9967041e-002,-5.6732178e-002,-5.0018311e-002,-4.2449951e-002,-3.7170410e-002,-3.4240723e-002,-3.2684326e-002,-3.2684326e-002,-3.0914307e-002,-2.6428223e-002,-2.2735596e-002,-1.7272949e-002,-1.4923096e-002,-1.5289307e-002,-1.3488770e-002,-1.2207031e-002,-7.3852539e-003,3.6621094e-004,7.0800781e-003,1.3671875e-002,1.7517090e-002,1.8371582e-002,1.9927979e-002,2.0660400e-002,2.2674561e-002,2.6550293e-002,2.8839111e-002,3.1066895e-002,3.0578613e-002,2.5451660e-002,2.0050049e-002,1.3061523e-002,6.5612793e-003,1.8615723e-003,-3.5400391e-003,-7.2937012e-003,-1.2420654e-002,-1.6998291e-002,-1.9622803e-002,-2.0935059e-002,-1.9439697e-002,-1.7059326e-002,-1.5350342e-002,-1.3854980e-002,-1.4495850e-002,-1.6937256e-002,-1.8524170e-002,-1.9287109e-002,-1.8737793e-002,-1.4343262e-002,-8.7280273e-003,-6.1035156e-004,1.0284424e-002,2.2399902e-002,3.6804199e-002,5.0048828e-002,6.1096191e-002,6.7687988e-002,7.0526123e-002,7.0434570e-002,6.9244385e-002,6.9458008e-002,6.6925049e-002,6.6040039e-002,6.1737061e-002,5.4199219e-002,4.8217773e-002,3.9154053e-002,3.3386230e-002,2.8839111e-002,2.1240234e-002,1.2634277e-002,8.8500977e-004,-1.3549805e-002,-2.4566650e-002,-3.1860352e-002,-3.6163330e-002,-3.2989502e-002,-3.1341553e-002,-2.9235840e-002,-2.6458740e-002,-2.7435303e-002,-2.3895264e-002,-2.0446777e-002,-1.7669678e-002,-1.1718750e-002,-9.7045898e-003,-9.5214844e-003,-9.9487305e-003,-1.0040283e-002,-7.5988770e-003,-2.8686523e-003,2.8686523e-003,9.4909668e-003,1.6235352e-002,2.2644043e-002,2.9876709e-002,3.5308838e-002,3.8116455e-002,3.6743164e-002,3.1158447e-002,2.2430420e-002,1.4862061e-002,1.1535645e-002,1.1505127e-002,1.8035889e-002,2.4871826e-002,3.1524658e-002,3.9123535e-002,4.0618896e-002,4.3792725e-002,4.3884277e-002,3.9947510e-002,3.5400391e-002,2.4536133e-002,1.3824463e-002,2.1667480e-003,-7.4462891e-003,-1.5472412e-002,-2.1606445e-002,-2.6977539e-002,-3.3538818e-002,-3.7445068e-002,-4.4097900e-002,-4.8339844e-002,-5.2215576e-002,-5.5603027e-002,-5.6427002e-002,-5.5664063e-002,-4.9285889e-002,-4.1778564e-002,-3.1036377e-002,-2.1484375e-002,-1.4221191e-002,-5.8898926e-003,-6.4086914e-004,6.1645508e-003,1.3092041e-002,1.5594482e-002,1.5899658e-002,1.2329102e-002,4.6081543e-003,-3.9672852e-004,-1.0681152e-003,2.4414063e-004,6.6833496e-003,1.3153076e-002,2.1148682e-002,3.2012939e-002,4.1198730e-002,4.8461914e-002,4.9377441e-002,4.0222168e-002,2.1148682e-002,-3.3264160e-003,-2.8594971e-002,-5.1574707e-002,-6.2957764e-002,-7.1533203e-002,-7.1624756e-002,-6.4361572e-002,-5.6335449e-002,-3.5858154e-002,-1.5197754e-002,9.0637207e-003,3.0426025e-002,4.4342041e-002,5.2124023e-002,5.2825928e-002,5.2429199e-002,4.4677734e-002,3.9459229e-002,2.6641846e-002,1.3000488e-002,2.1057129e-003,-1.0009766e-002,-1.2237549e-002,-1.2176514e-002,-5.8288574e-003,1.4343262e-003,1.1169434e-002,2.0660400e-002,3.2012939e-002,4.4586182e-002,5.3039551e-002,6.1828613e-002,6.1370850e-002,5.8624268e-002,5.2612305e-002,4.6081543e-002,3.9581299e-002,3.3264160e-002,2.6367188e-002,1.4739990e-002,5.5541992e-003,-7.7819824e-003,-1.4831543e-002,-2.0294189e-002,-2.1453857e-002,-1.5991211e-002,-1.1779785e-002,-4.3334961e-003,2.2277832e-003,8.7280273e-003,1.2786865e-002,1.4526367e-002,9.8876953e-003,7.0190430e-004,-1.2084961e-002,-2.7160645e-002,-3.9398193e-002,-4.7882080e-002,-5.2154541e-002,-5.2185059e-002,-4.9285889e-002,-4.6691895e-002,-3.7170410e-002,-2.6092529e-002,-9.8266602e-003,1.1352539e-002,2.8320313e-002,4.4830322e-002,5.3649902e-002,5.8227539e-002,5.9112549e-002,5.7769775e-002,5.2795410e-002,4.5959473e-002,3.3935547e-002,1.5991211e-002,-7.0190430e-004,-2.0050049e-002,-3.4210205e-002,-4.5989990e-002,-5.4016113e-002,-5.7250977e-002,-5.6365967e-002,-4.9713135e-002,-4.0557861e-002,-2.6641846e-002,-1.4862061e-002,-3.0212402e-003,5.5541992e-003,1.1169434e-002,1.3244629e-002,1.1352539e-002,4.0893555e-003,-7.4462891e-003,-1.9073486e-002,-3.0761719e-002,-3.7628174e-002,-4.0710449e-002,-4.0954590e-002,-3.9062500e-002,-3.4393311e-002,-2.7984619e-002,-1.6723633e-002,-3.0822754e-003,7.9956055e-003,1.7639160e-002,1.9989014e-002,1.8371582e-002,1.5930176e-002,1.5533447e-002,1.3214111e-002,1.1657715e-002,5.1574707e-003,-8.6669922e-003,-1.6998291e-002,-2.7313232e-002,-2.6947021e-002,-1.9195557e-002,-1.1993408e-002,-3.1738281e-003,1.3732910e-003,2.5939941e-003,7.6599121e-003,1.5472412e-002,2.2155762e-002,3.4576416e-002,3.7963867e-002,3.7780762e-002,3.3874512e-002,2.3162842e-002,1.4617920e-002,3.4790039e-003,-8.8195801e-003,-2.2705078e-002,-3.5461426e-002,-4.6966553e-002,-5.1208496e-002,-4.8461914e-002,-3.9794922e-002,-2.4902344e-002,-8.9721680e-003,6.6223145e-003,2.0080566e-002,3.0944824e-002,3.7933350e-002,4.3884277e-002,4.4586182e-002,4.3457031e-002,3.8238525e-002,3.0303955e-002,2.3040771e-002,1.5167236e-002,1.2390137e-002,1.0467529e-002,1.1657715e-002,9.7961426e-003,7.9956055e-003,4.4250488e-003,3.0517578e-005,-2.3803711e-003,-5.7373047e-003,-3.4179688e-003,-5.4016113e-003,-5.7678223e-003,-8.6669922e-003,-1.3549805e-002,-1.5472412e-002,-1.7547607e-002,-1.6754150e-002,-1.5930176e-002,-1.5289307e-002,-1.7211914e-002,-1.8066406e-002,-2.2338867e-002,-2.5085449e-002,-2.5878906e-002,-2.7343750e-002,-2.3681641e-002,-2.0050049e-002,-1.3549805e-002,-7.0190430e-003,-1.2207031e-003,3.7231445e-003,6.1035156e-003,7.2021484e-003,4.8522949e-003,8.8500977e-004,-4.1809082e-003,-1.0070801e-002,-1.5319824e-002,-1.9439697e-002,-2.2613525e-002,-2.2888184e-002,-2.0996094e-002,-1.7028809e-002,-1.1260986e-002,-4.6386719e-003,1.1291504e-003,7.1411133e-003,1.0833740e-002,1.1932373e-002,1.2573242e-002,9.2773438e-003,6.6528320e-003,3.5705566e-003,1.6479492e-003,1.2207031e-003,1.2512207e-003,2.1667480e-003,1.2817383e-003,6.1035156e-005,-4.6081543e-003,-1.0131836e-002,-1.6998291e-002,-2.5146484e-002,-3.0578613e-002,-3.6865234e-002,-4.0344238e-002,-4.3121338e-002,-4.2449951e-002,-3.8421631e-002,-3.2714844e-002,-2.3895264e-002,-1.6326904e-002,-8.6059570e-003,-4.2419434e-003,-1.9226074e-003,-2.4719238e-003,-5.1269531e-003,-7.3547363e-003,-1.0833740e-002,-1.2084961e-002,-1.3793945e-002,-1.4739990e-002,-1.5991211e-002,-1.9226074e-002,-2.0202637e-002,-2.1209717e-002,-1.8493652e-002,-1.3610840e-002,-9.3078613e-003,-5.5847168e-003,-4.6691895e-003,-6.5917969e-003,-8.2702637e-003,-7.9040527e-003,-7.6293945e-003,-4.8217773e-003,-5.4321289e-003,-8.2702637e-003,-9.6740723e-003,-1.1505127e-002,-8.9111328e-003,-3.3569336e-003,2.1362305e-004,2.0446777e-003,1.5258789e-003,-2.8381348e-003,-2.3803711e-003,1.8615723e-003,7.1716309e-003,1.7059326e-002,2.0263672e-002,1.8829346e-002,1.6998291e-002,1.0284424e-002,7.8735352e-003,8.9721680e-003,6.5917969e-003,5.9509277e-003,-3.0517578e-005,-8.9721680e-003,-1.1657715e-002,-1.3549805e-002,-9.9487305e-003,-1.5869141e-003,4.3029785e-003,8.0566406e-003,1.0070801e-002,7.4768066e-003,7.9956055e-003,1.0742188e-002,1.2481689e-002,1.6662598e-002,1.5258789e-002,1.0131836e-002,5.3100586e-003,-9.4604492e-004,-3.6926270e-003,-3.3264160e-003,-4.3640137e-003,-6.1035156e-003,-9.8571777e-003,-1.6662598e-002,-2.0019531e-002,-2.0996094e-002,-2.0660400e-002,-1.7211914e-002,-1.6906738e-002,-1.9134521e-002,-2.0751953e-002,-2.4505615e-002,-2.4475098e-002,-2.0629883e-002,-1.7913818e-002,-1.4038086e-002,-1.4282227e-002,-1.8615723e-002,-2.1209717e-002,-2.5085449e-002,-2.6763916e-002,-2.4993896e-002,-2.5878906e-002,-2.4993896e-002,-2.5665283e-002,-2.9235840e-002,-3.0273438e-002,-3.1616211e-002,-3.0517578e-002,-2.5756836e-002,-2.1179199e-002,-1.5502930e-002,-1.1962891e-002,-1.2451172e-002,-1.3031006e-002,-1.5075684e-002,-1.5319824e-002,-1.2603760e-002,-1.3549805e-002,-1.4007568e-002,-1.7089844e-002,-2.3284912e-002,-2.4444580e-002,-2.2827148e-002,-1.8310547e-002,-1.0864258e-002,-7.6904297e-003,-8.6059570e-003,-8.3923340e-003,-9.2773438e-003,-5.3710938e-003,1.5563965e-003,3.0822754e-003,1.1596680e-003,-5.2795410e-003,-1.6143799e-002,-2.1026611e-002,-2.0996094e-002,-2.0874023e-002,-1.7974854e-002,-2.0111084e-002,-2.6947021e-002,-2.8015137e-002,-2.7587891e-002,-2.3071289e-002,-1.2603760e-002,-8.0871582e-003,-6.5612793e-003,-5.6762695e-003,-9.3688965e-003,-8.8195801e-003,-4.3029785e-003,-3.2958984e-003,-1.1901855e-003,-3.0517578e-003,-9.1552734e-003,-1.2084961e-002,-1.5014648e-002,-1.7456055e-002,-1.7669678e-002,-1.9134521e-002,-1.9958496e-002,-1.9226074e-002,-1.7547607e-002,-1.3946533e-002,-8.9111328e-003,-5.1269531e-003,-2.1667480e-003,9.1552734e-005,6.7138672e-004,6.1035156e-005,-7.6293945e-004,-2.5329590e-003,-5.4626465e-003,-6.9580078e-003,-9.9182129e-003,-1.3977051e-002,-1.8371582e-002,-2.1392822e-002,-2.2796631e-002,-2.1820068e-002,-1.9012451e-002,-1.6479492e-002,-1.4831543e-002,-1.4617920e-002,-1.5319824e-002,-1.4678955e-002,-1.2268066e-002,-1.1352539e-002,-1.0375977e-002,-1.2451172e-002,-1.7486572e-002,-2.0904541e-002,-2.4810791e-002,-2.6611328e-002,-2.5970459e-002,-2.6245117e-002,-2.7099609e-002,-2.6397705e-002,-2.6550293e-002,-2.4536133e-002,-2.0874023e-002,-1.8463135e-002,-1.4221191e-002,-1.1718750e-002,-1.0192871e-002,-9.1552734e-003,-9.7656250e-003,-1.0986328e-002,-1.3000488e-002,-1.6601563e-002,-2.1484375e-002,-2.7069092e-002,-3.3172607e-002,-3.7109375e-002,-3.9428711e-002,-3.8452148e-002,-3.4484863e-002,-2.9754639e-002,-2.4963379e-002,-2.0629883e-002,-1.7486572e-002,-1.3275146e-002,-7.9040527e-003,-4.3029785e-003,-1.0986328e-003,-3.6926270e-003,-9.7351074e-003,-1.6998291e-002,-2.4291992e-002,-2.6947021e-002,-2.5177002e-002,-2.2277832e-002,-2.0599365e-002,-1.9805908e-002,-2.3712158e-002,-2.2918701e-002,-2.1270752e-002,-1.9256592e-002,-1.3641357e-002,-1.3397217e-002,-1.5289307e-002,-1.8066406e-002,-2.1453857e-002,-2.2338867e-002,-1.9256592e-002,-1.8402100e-002,-1.8188477e-002,-1.8737793e-002,-2.4261475e-002,-2.5634766e-002,-2.6367188e-002,-2.5115967e-002,-2.0782471e-002,-1.9195557e-002,-1.8157959e-002,-1.7486572e-002,-1.8249512e-002,-1.7913818e-002,-1.6723633e-002,-1.7303467e-002,-1.6876221e-002,-1.8341064e-002,-2.0782471e-002,-2.3223877e-002,-2.6000977e-002,-2.6306152e-002,-2.5848389e-002,-2.5756836e-002,-2.6458740e-002,-2.8442383e-002,-3.1402588e-002,-3.1341553e-002,-2.9266357e-002,-2.3773193e-002,-1.4373779e-002,-8.1176758e-003,-4.4555664e-003,-3.9672852e-003,-8.4533691e-003,-1.1566162e-002,-1.3549805e-002,-1.5991211e-002,-1.4495850e-002,-1.6540527e-002,-1.9531250e-002,-2.1972656e-002,-2.3712158e-002,-2.1636963e-002,-1.8920898e-002,-1.6387939e-002,-1.5106201e-002,-1.4739990e-002,-1.5594482e-002,-1.5045166e-002,-1.1932373e-002,-9.8876953e-003,-6.2561035e-003,-4.8217773e-003,-6.3171387e-003,-7.5988770e-003,-1.0894775e-002,-1.3916016e-002,-1.5625000e-002,-1.7181396e-002,-1.7364502e-002,-1.5655518e-002,-1.3336182e-002,-9.1552734e-003,-4.6386719e-003,-5.1879883e-004,2.0751953e-003,2.6245117e-003,2.1362305e-004,-4.0283203e-003,-8.9721680e-003,-1.4892578e-002,-1.9256592e-002,-2.3498535e-002,-2.6458740e-002,-2.8717041e-002,-3.0944824e-002,-3.0853271e-002,-3.0853271e-002,-2.6733398e-002,-2.1240234e-002,-1.5167236e-002,-8.7890625e-003,-5.8288574e-003,-4.7607422e-003,-5.6457520e-003,-7.9650879e-003,-1.0986328e-002,-1.3244629e-002,-1.7791748e-002,-2.1820068e-002,-2.5878906e-002,-3.0487061e-002,-3.2470703e-002,-3.3905029e-002,-3.3691406e-002,-3.4088135e-002,-3.3782959e-002,-3.4393311e-002,-3.4484863e-002,-3.2958984e-002,-3.3477783e-002,-3.2562256e-002,-3.3020020e-002,-3.3508301e-002,-3.3508301e-002,-3.2318115e-002,-3.1188965e-002,-3.0090332e-002,-2.9479980e-002,-3.0670166e-002,-3.1066895e-002,-3.3416748e-002,-3.3935547e-002,-3.4088135e-002,-3.2928467e-002,-2.8503418e-002,-2.4658203e-002,-2.0141602e-002,-1.7730713e-002,-1.7425537e-002,-1.6326904e-002,-1.5716553e-002,-1.5075684e-002,-1.3488770e-002,-1.6815186e-002,-2.2857666e-002,-3.0670166e-002,-4.0557861e-002,-4.5471191e-002,-4.6661377e-002,-4.4769287e-002,-3.9276123e-002,-3.3264160e-002,-2.8503418e-002,-2.1087646e-002,-1.4099121e-002,-7.3547363e-003,-1.0375977e-003,9.1552734e-005,-1.5869141e-003,-5.6762695e-003,-9.1552734e-003,-1.2969971e-002,-1.4251709e-002,-1.6937256e-002,-2.0629883e-002,-2.1728516e-002,-2.4200439e-002,-2.2064209e-002,-1.8035889e-002,-1.4221191e-002,-9.7656250e-003,-7.8125000e-003,-7.7514648e-003,-6.7749023e-003,-7.3852539e-003,-9.5214844e-003,-1.0131836e-002,-1.3031006e-002,-1.4648438e-002,-1.5838623e-002,-1.7059326e-002,-1.6052246e-002,-1.5747070e-002,-1.3000488e-002,-1.1047363e-002,-7.3242188e-003,-3.7841797e-003,-2.1057129e-003,-2.3498535e-003,-5.0048828e-003,-8.5144043e-003,-1.1901855e-002,-1.2329102e-002,-1.3427734e-002,-1.2420654e-002,-1.3305664e-002,-1.6418457e-002,-1.8707275e-002,-2.3223877e-002,-2.4505615e-002,-2.5238037e-002,-2.5512695e-002,-2.4261475e-002,-2.3895264e-002,-2.2857666e-002,-2.0874023e-002,-1.8768311e-002,-1.6265869e-002,-1.4099121e-002,-1.3946533e-002,-1.5197754e-002,-1.7303467e-002,-1.9714355e-002,-2.1606445e-002,-2.3529053e-002,-2.4810791e-002,-2.6031494e-002,-2.6336670e-002,-2.6489258e-002,-2.6123047e-002,-2.5054932e-002,-2.3590088e-002,-2.1667480e-002,-2.0111084e-002,-1.8890381e-002,-1.8951416e-002,-2.0233154e-002,-2.2247314e-002,-2.3284912e-002,-2.4414063e-002,-2.4932861e-002,-2.3864746e-002,-2.4810791e-002,-2.4902344e-002,-2.5207520e-002,-2.3956299e-002,-2.1026611e-002,-1.8066406e-002,-1.4129639e-002,-1.1871338e-002,-1.1169434e-002,-1.1566162e-002,-1.2878418e-002,-1.4770508e-002,-1.5472412e-002,-1.8432617e-002,-2.1728516e-002,-2.5787354e-002,-3.0120850e-002,-3.3111572e-002,-3.5247803e-002,-3.5766602e-002,-3.5583496e-002,-3.4057617e-002,-3.2043457e-002,-2.8167725e-002,-2.4230957e-002,-2.0660400e-002,-1.8218994e-002,-1.7059326e-002,-1.5838623e-002,-1.5319824e-002,-1.3305664e-002,-1.3214111e-002,-1.3824463e-002,-1.5136719e-002,-1.7944336e-002,-1.9195557e-002,-2.0294189e-002,-1.9378662e-002,-1.7181396e-002,-1.5563965e-002,-1.5167236e-002,-1.4251709e-002,-1.4862061e-002,-1.4556885e-002,-1.3427734e-002,-1.4770508e-002,-1.5502930e-002,-1.7913818e-002,-1.9592285e-002,-1.9866943e-002,-1.9256592e-002,-1.7822266e-002,-1.7425537e-002,-1.7517090e-002,-2.0538330e-002,-2.1514893e-002,-2.1423340e-002,-2.1942139e-002,-2.0324707e-002,-1.9470215e-002,-1.7517090e-002,-1.5716553e-002,-1.4099121e-002,-1.2573242e-002,-1.0955811e-002,-9.9182129e-003,-9.7961426e-003,-9.6130371e-003,-1.0681152e-002,-1.1718750e-002,-1.3031006e-002,-1.5625000e-002,-1.7852783e-002,-1.9653320e-002,-2.1209717e-002,-2.1301270e-002,-2.0416260e-002,-1.9500732e-002,-1.8249512e-002,-1.6296387e-002,-1.3580322e-002,-1.0437012e-002,-6.6528320e-003,-4.5166016e-003,-3.9978027e-003,-4.3334961e-003,-6.5002441e-003,-8.5449219e-003,-1.0375977e-002,-1.4007568e-002,-1.7211914e-002,-2.0446777e-002,-2.3681641e-002,-2.4017334e-002,-2.2827148e-002,-2.0111084e-002,-1.6113281e-002,-1.3153076e-002,-1.1932373e-002,-1.0467529e-002,-1.0375977e-002,-1.0742188e-002,-1.0559082e-002,-1.2634277e-002,-1.3702393e-002,-1.5228271e-002,-1.5991211e-002,-1.5747070e-002,-1.5014648e-002,-1.3977051e-002,-1.5319824e-002,-1.4190674e-002,-1.3824463e-002,-1.1016846e-002,-6.1645508e-003,-4.9133301e-003,-4.7302246e-003,-6.3781738e-003,-1.0070801e-002,-1.3214111e-002,-1.5014648e-002,-1.7395020e-002,-1.8218994e-002,-2.0019531e-002,-2.2766113e-002,-2.2216797e-002,-2.1759033e-002,-1.9622803e-002,-1.6723633e-002,-1.5045166e-002,-1.4312744e-002,-1.3702393e-002,-1.2725830e-002,-1.2664795e-002,-1.1962891e-002,-1.4068604e-002,-1.7517090e-002,-2.0782471e-002,-2.3254395e-002,-2.4078369e-002,-2.2644043e-002,-2.2308350e-002,-2.3681641e-002,-2.3590088e-002,-2.5909424e-002,-2.5787354e-002,-2.5024414e-002,-2.5390625e-002,-2.4963379e-002,-2.5817871e-002,-2.6397705e-002,-2.6611328e-002,-2.5787354e-002,-2.6031494e-002,-2.6519775e-002,-2.7526855e-002,-2.8411865e-002,-2.7954102e-002,-2.5848389e-002,-2.4078369e-002,-2.3132324e-002,-2.2583008e-002,-2.3986816e-002,-2.3101807e-002,-2.0172119e-002,-1.7059326e-002,-1.2603760e-002,-1.1505127e-002,-1.1260986e-002,-1.1047363e-002,-1.1505127e-002,-1.1352539e-002,-9.6130371e-003,-1.0406494e-002,-1.1596680e-002,-1.3244629e-002,-1.6174316e-002,-1.7272949e-002,-1.7456055e-002,-1.7669678e-002,-1.6815186e-002,-1.5258789e-002,-1.3031006e-002,-8.6364746e-003,-3.6315918e-003,7.6293945e-004,3.4179688e-003,4.2419434e-003,2.4719238e-003,-3.0517578e-005,-2.0446777e-003,-3.9062500e-003,-3.8146973e-003,-3.8757324e-003,-3.2043457e-003,-2.3193359e-003,-1.7395020e-003,-1.2207031e-004,8.5449219e-004,1.6784668e-003,1.8920898e-003,2.0446777e-003,1.6784668e-003,8.8500977e-004,4.5776367e-004,-8.8500977e-004,-1.0070801e-003,-1.5869141e-003,-1.8920898e-003,-1.6784668e-003,-3.4790039e-003,-4.6386719e-003,-7.2326660e-003,-9.5825195e-003,-1.1413574e-002,-1.3854980e-002,-1.4587402e-002,-1.5350342e-002,-1.5411377e-002,-1.4770508e-002,-1.3946533e-002,-1.2908936e-002,-1.2268066e-002,-1.1962891e-002,-1.3305664e-002,-1.4923096e-002,-1.6174316e-002,-1.7486572e-002,-1.8402100e-002,-1.9500732e-002,-2.1240234e-002,-2.3071289e-002,-2.4719238e-002,-2.4200439e-002,-2.1942139e-002,-1.8371582e-002,-1.4129639e-002,-1.1596680e-002,-1.0498047e-002,-1.0437012e-002,-1.1138916e-002,-1.1444092e-002,-1.0986328e-002,-1.1871338e-002,-1.2786865e-002,-1.4404297e-002,-1.7181396e-002,-1.8920898e-002,-2.0416260e-002,-2.1514893e-002,-2.1942139e-002,-2.1514893e-002,-2.0965576e-002,-1.9317627e-002,-1.7852783e-002,-1.7822266e-002,-1.8341064e-002,-2.0538330e-002,-2.1972656e-002,-2.2674561e-002,-2.2003174e-002,-2.1362305e-002,-2.0660400e-002,-1.9317627e-002,-1.8005371e-002,-1.5167236e-002,-1.2695313e-002,-9.9487305e-003,-9.1247559e-003,-8.4838867e-003,-8.7585449e-003,-7.5378418e-003,-4.6691895e-003,-3.3264160e-003,-1.1596680e-003,-1.9531250e-003,-4.8828125e-003,-6.1645508e-003,-7.9040527e-003,-8.9721680e-003,-9.4909668e-003,-1.0528564e-002,-1.2481689e-002,-1.3671875e-002,-1.4709473e-002,-1.2969971e-002,-9.1552734e-003,-6.2255859e-003,-3.9672852e-003,-3.2043457e-003,-3.7841797e-003,-4.0283203e-003,-3.5705566e-003,-4.4250488e-003,-4.4555664e-003,-4.9133301e-003,-5.0354004e-003,-4.3945313e-003,-3.4179688e-003,-2.6550293e-003,-2.5634766e-003,-2.1972656e-003,-3.1433105e-003,-3.7231445e-003,-4.9438477e-003,-6.9274902e-003,-7.9345703e-003,-9.2468262e-003,-9.4604492e-003,-9.1857910e-003,-9.3994141e-003,-9.4299316e-003,-1.1138916e-002,-1.2359619e-002,-1.4129639e-002,-1.5106201e-002,-1.3885498e-002,-1.2939453e-002,-1.1718750e-002,-1.1383057e-002,-1.1962891e-002,-1.1016846e-002,-1.0009766e-002,-8.4533691e-003,-6.5612793e-003,-6.3171387e-003,-6.2561035e-003,-4.8217773e-003,-3.8757324e-003,-1.4343262e-003,9.1552734e-004,1.0070801e-003,-1.1291504e-003,-3.8452148e-003,-7.5073242e-003,-1.0650635e-002,-1.1352539e-002,-1.3458252e-002,-1.2847900e-002,-1.3031006e-002,-1.3122559e-002,-1.1993408e-002,-1.0894775e-002,-9.4604492e-003,-8.6669922e-003,-7.9956055e-003,-8.4228516e-003,-9.3078613e-003,-9.7656250e-003,-1.1230469e-002,-1.2481689e-002,-1.3305664e-002,-1.4343262e-002,-1.4038086e-002,-1.3580322e-002,-1.2695313e-002,-1.1718750e-002,-1.0253906e-002,-7.9956055e-003,-6.1340332e-003,-3.9672852e-003,-3.6010742e-003,-4.5471191e-003,-6.2255859e-003,-7.4462891e-003,-8.2702637e-003,-7.8430176e-003,-8.2092285e-003,-8.9111328e-003,-9.0026855e-003,-9.5825195e-003,-8.9416504e-003,-9.0332031e-003,-9.1552734e-003,-9.3078613e-003,-9.7045898e-003,-9.4604492e-003,-8.9111328e-003,-7.5683594e-003,-6.5002441e-003,-5.8593750e-003,-5.0659180e-003,-4.1198730e-003,-2.8686523e-003,-9.1552734e-004,-1.1901855e-003,-2.5024414e-003,-3.3264160e-003,-5.0048828e-003,-5.8593750e-003,-6.0119629e-003,-7.4462891e-003,-9.7351074e-003,-1.1627197e-002,-1.2969971e-002,-1.2756348e-002,-1.0986328e-002,-8.6975098e-003,-5.4626465e-003,-3.8146973e-003,-3.2958984e-003,-2.8991699e-003,-4.2114258e-003,-5.6152344e-003,-7.4157715e-003,-9.1552734e-003,-9.0332031e-003,-8.7890625e-003,-7.4462891e-003,-6.4392090e-003,-7.0190430e-003,-6.6223145e-003,-7.3547363e-003,-7.1716309e-003,-6.7138672e-003,-6.8359375e-003,-5.5541992e-003,-5.0048828e-003,-3.3264160e-003,-1.7700195e-003,-1.7700195e-003,-2.0446777e-003,-3.6926270e-003,-5.2185059e-003,-6.1950684e-003,-7.7209473e-003,-8.6059570e-003,-1.0223389e-002,-1.2023926e-002,-1.2268066e-002,-1.2268066e-002,-1.0192871e-002,-6.6223145e-003,-4.0588379e-003,-2.2277832e-003,-5.1879883e-004,8.2397461e-004,3.1738281e-003,6.7443848e-003,8.1787109e-003,9.1247559e-003,8.6059570e-003,7.5988770e-003,7.6293945e-003,8.2092285e-003,7.9345703e-003,6.7443848e-003,5.1574707e-003,2.2888184e-003,1.4038086e-003,2.5634766e-003,2.7770996e-003,5.0964355e-003,6.2561035e-003,5.6457520e-003,5.0659180e-003,3.0212402e-003,1.0681152e-003,1.2207031e-004,-1.2817383e-003,-1.4648438e-003,-1.9531250e-003,-2.9907227e-003,-3.0517578e-003,-3.7231445e-003,-2.9602051e-003,-1.3427734e-003,3.9672852e-004,2.9296875e-003,4.0893555e-003,3.9978027e-003,5.1269531e-003,5.4931641e-003,6.4086914e-003,7.9956055e-003,7.0495605e-003,4.5471191e-003,2.1667480e-003,-1.4038086e-003,-3.0822754e-003,-2.9602051e-003,-3.8452148e-003,-5.4321289e-003,-7.4768066e-003,-1.0498047e-002,-1.2359619e-002,-1.2786865e-002,-1.3427734e-002,-1.2390137e-002,-1.1535645e-002,-1.0314941e-002,-9.0026855e-003,-8.3923340e-003,-8.5754395e-003,-9.7351074e-003,-1.0192871e-002,-1.0955811e-002,-1.1352539e-002,-1.0833740e-002,-1.1901855e-002,-1.3061523e-002,-1.3519287e-002,-1.3702393e-002,-1.2268066e-002,-9.8876953e-003,-8.6975098e-003,-7.4157715e-003,-8.5449219e-003,-9.0332031e-003,-8.7585449e-003,-8.5754395e-003,-8.8500977e-003,-9.4299316e-003,-1.0162354e-002,-1.2817383e-002,-1.2969971e-002,-1.1596680e-002,-8.7585449e-003,-4.0588379e-003,4.8828125e-004,3.7536621e-003,7.3852539e-003,8.6059570e-003,8.9721680e-003,9.3994141e-003,8.0871582e-003,8.3923340e-003,6.8664551e-003,6.2255859e-003,4.7302246e-003,2.6550293e-003,1.8005371e-003,3.9672852e-004,-9.1552734e-005,-1.4648438e-003,-3.0822754e-003,-4.7912598e-003,-4.8828125e-003,-4.1198730e-003,-2.5939941e-003,-3.9672852e-004,6.4086914e-004,1.4038086e-003,2.1057129e-003,3.1127930e-003,4.8217773e-003,6.9580078e-003,8.2397461e-003,9.1247559e-003,9.4909668e-003,9.3688965e-003,9.3078613e-003,9.0637207e-003,8.2092285e-003,6.8359375e-003,6.2866211e-003,5.6457520e-003,5.6762695e-003,6.2255859e-003,5.4931641e-003,3.7841797e-003,2.2277832e-003,3.9672852e-004,-2.4414063e-004,-5.1879883e-004,-2.2583008e-003,-3.2043457e-003,-4.9438477e-003,-6.2866211e-003,-6.5612793e-003,-6.1645508e-003,-6.2866211e-003,-7.2326660e-003,-6.6833496e-003,-5.5847168e-003,-2.9907227e-003,4.8828125e-004,2.5024414e-003,3.5095215e-003,4.1503906e-003,3.6621094e-003,4.1503906e-003,5.3405762e-003,4.9133301e-003,4.4860840e-003,2.6550293e-003,3.3569336e-004,-1.3122559e-003,-2.6550293e-003,-4.3334961e-003,-6.3171387e-003,-8.5449219e-003,-1.0589600e-002,-1.0681152e-002,-9.5520020e-003,-8.4228516e-003,-6.9885254e-003,-5.8593750e-003,-6.6223145e-003,-6.1340332e-003,-4.4555664e-003,-2.8686523e-003,-2.7465820e-004,4.8828125e-004,3.3569336e-004,6.7138672e-004,-2.7465820e-004,-9.7656250e-004,-1.9531250e-003,-3.9367676e-003,-4.4250488e-003,-5.4321289e-003,-5.7983398e-003,-5.5541992e-003,-5.7067871e-003,-5.8593750e-003,-6.4697266e-003,-6.8969727e-003,-5.8593750e-003,-5.7983398e-003,-5.4931641e-003,-3.9978027e-003,-4.7607422e-003,-4.4250488e-003,-4.9743652e-003,-5.1574707e-003,-4.1809082e-003,-4.0588379e-003,-3.2348633e-003,-1.7700195e-003,-9.1552734e-004,1.0986328e-003,2.5024414e-003,3.1127930e-003,3.4179688e-003,3.1738281e-003,3.7231445e-003,4.4860840e-003,5.3710938e-003,5.2795410e-003,4.3334961e-003,3.4790039e-003,2.5634766e-003,1.7395020e-003,3.9672852e-004,-1.1596680e-003,-2.8381348e-003,-3.8757324e-003,-4.4860840e-003,-3.6010742e-003,-2.0446777e-003,-1.2512207e-003,6.1035156e-004,2.1057129e-003,3.2348633e-003,4.9743652e-003,6.5307617e-003,7.9040527e-003,9.1857910e-003,9.4299316e-003,8.8500977e-003,8.2702637e-003,7.4462891e-003,7.4462891e-003,7.5988770e-003,7.7209473e-003,7.3852539e-003,6.5307617e-003,5.0659180e-003,3.0822754e-003,8.5449219e-004,-1.2207031e-003,-2.2583008e-003,-3.6010742e-003,-4.0893555e-003,-4.3029785e-003,-3.3569336e-003,-2.1057129e-003,6.1035156e-004,3.6621094e-003,4.3029785e-003,5.1269531e-003,2.8076172e-003,1.9226074e-003,2.9907227e-003,4.0588379e-003,6.3171387e-003,4.8828125e-003,1.5258789e-004,-2.7770996e-003,-5.5541992e-003,-4.6997070e-003,3.3569336e-004,3.7536621e-003,7.0495605e-003,8.6059570e-003,6.3171387e-003,5.9204102e-003,5.1574707e-003,3.3874512e-003,1.7700195e-003,-2.5024414e-003,-6.8969727e-003,-9.5520020e-003,-1.0437012e-002,-8.7585449e-003,-5.6152344e-003,-2.9602051e-003,-2.6245117e-003,-1.3732910e-003,-5.1879883e-004,1.3427734e-003,5.5847168e-003,7.6904297e-003,1.0162354e-002,1.1566162e-002,1.0894775e-002,9.0026855e-003,5.4321289e-003,1.2512207e-003,-1.9836426e-003,-3.5095215e-003,-2.7770996e-003,-1.1596680e-003,4.8828125e-004,1.3122559e-003,-1.5258789e-004,3.0517578e-004,2.1972656e-003,4.4860840e-003,8.7890625e-003,1.0314941e-002,9.7351074e-003,7.5988770e-003,6.1340332e-003,4.0893555e-003,3.9062500e-003,2.1057129e-003,-5.4931641e-004,-2.7770996e-003,-6.1950684e-003,-4.9743652e-003,-1.7700195e-003,2.0141602e-003,6.3476563e-003,8.6364746e-003,8.5449219e-003,9.3078613e-003,1.0070801e-002,1.0498047e-002,1.2420654e-002,1.1352539e-002,9.6435547e-003,6.5307617e-003,2.4719238e-003,-2.4414063e-004,-2.7770996e-003,-4.0893555e-003,-4.6997070e-003,-4.2419434e-003,-3.2958984e-003,-1.5563965e-003,4.2724609e-004,2.1972656e-003,3.6315918e-003,4.2419434e-003,4.3334961e-003,3.7841797e-003,4.3029785e-003,3.9978027e-003,4.5776367e-003,4.3334961e-003,3.7841797e-003,4.3029785e-003,3.3874512e-003,3.0212402e-003,2.2583008e-003,1.3122559e-003,7.0190430e-004,6.4086914e-004,1.2207031e-003,2.9296875e-003,5.2795410e-003,7.7819824e-003,1.0742188e-002,1.2390137e-002,1.3183594e-002,1.3488770e-002,1.4129639e-002,1.4495850e-002,1.4953613e-002,1.5563965e-002,1.4221191e-002,1.2237549e-002,9.3994141e-003,7.2021484e-003,6.0424805e-003,5.0048828e-003,5.3405762e-003,6.7443848e-003,7.9956055e-003,1.0162354e-002,1.2023926e-002,1.3183594e-002,1.4160156e-002,1.3885498e-002,1.2451172e-002,1.1535645e-002,1.0894775e-002,1.0345459e-002,1.0528564e-002,1.0070801e-002,8.9111328e-003,8.5754395e-003,7.6293945e-003,7.6293945e-003,7.9345703e-003,8.5449219e-003,9.8876953e-003,1.0772705e-002,1.2542725e-002,1.3885498e-002,1.4343262e-002,1.3824463e-002,1.1138916e-002,9.3078613e-003,7.3242188e-003,5.5847168e-003,4.8522949e-003,3.2348633e-003,8.8500977e-004,-4.2724609e-004,-1.9226074e-003,-2.2583008e-003,-1.2512207e-003,-7.0190430e-004,8.8500977e-004,1.5563965e-003,2.6245117e-003,3.9672852e-003,5.4321289e-003,6.3171387e-003,6.5307617e-003,5.7067871e-003,3.6621094e-003,4.5776367e-004,-8.2397461e-004,-1.5258789e-003,-2.2888184e-003,-1.7395020e-003,-2.2888184e-003,-1.5258789e-003,-1.2817383e-003,-1.4648438e-003,-1.6784668e-003,-2.7465820e-003,-3.9978027e-003,-5.1879883e-003,-5.8593750e-003,-7.0800781e-003,-8.4228516e-003,-1.0162354e-002,-1.1352539e-002,-1.0833740e-002,-9.4604492e-003,-7.6599121e-003,-5.6457520e-003,-3.5705566e-003,-3.6315918e-003,-3.3264160e-003,-2.2888184e-003,-1.9531250e-003,-3.6621094e-004,7.3242188e-004,1.1291504e-003,1.4648438e-003,1.3122559e-003,1.9836426e-003,3.6010742e-003,5.4626465e-003,7.3547363e-003,8.7585449e-003,8.5754395e-003,8.9111328e-003,7.8735352e-003,6.5612793e-003,5.1879883e-003,3.8146973e-003,3.5400391e-003,3.0822754e-003,3.2653809e-003,3.7536621e-003,2.7465820e-003,2.6855469e-003,3.2043457e-003,3.9062500e-003,6.4392090e-003,8.0261230e-003,9.1552734e-003,9.6435547e-003,8.6975098e-003,8.9721680e-003,1.0284424e-002,1.0833740e-002,1.1993408e-002,1.2664795e-002,1.1108398e-002,9.9792480e-003,8.2397461e-003,8.1787109e-003,9.2163086e-003,9.4909668e-003,9.7961426e-003,8.9416504e-003,7.5683594e-003,7.4462891e-003,7.9040527e-003,8.1176758e-003,8.5754395e-003,8.3923340e-003,8.1787109e-003,7.9956055e-003,7.9345703e-003,7.7819824e-003,6.5612793e-003,5.6457520e-003,3.4790039e-003,2.3803711e-003,2.3803711e-003,1.8005371e-003,1.6784668e-003,1.0375977e-003,-1.2207031e-004,-3.3569336e-004,-3.3569336e-004,0.0000000e+000,1.6479492e-003,2.2583008e-003,2.4719238e-003,2.3193359e-003,1.7089844e-003,1.0681152e-003,-2.1362305e-004,-1.9226074e-003,-4.6081543e-003,-6.7749023e-003,-7.2021484e-003,-6.5917969e-003,-5.0048828e-003,-3.8146973e-003,-3.1433105e-003,-1.1901855e-003,4.8828125e-004,3.1738281e-003,6.6833496e-003,8.2092285e-003,8.5144043e-003,7.5683594e-003,5.3405762e-003,4.4555664e-003,3.6010742e-003,4.1198730e-003,5.1269531e-003,3.9062500e-003,1.9836426e-003,7.0190430e-004,-1.8005371e-003,-2.1057129e-003,-7.9345703e-004,4.8828125e-004,3.2653809e-003,5.0354004e-003,6.7749023e-003,8.6975098e-003,9.5520020e-003,9.3688965e-003,8.5754395e-003,6.9885254e-003,5.8898926e-003,4.8828125e-003,5.0048828e-003,4.5776367e-003,4.3029785e-003,3.7536621e-003,1.4343262e-003,1.4038086e-003,1.5563965e-003,3.1127930e-003,6.7749023e-003,9.0332031e-003,1.0498047e-002,1.1230469e-002,9.3078613e-003,7.4462891e-003,6.2866211e-003,3.3264160e-003,1.6784668e-003,-1.6784668e-003,-4.8828125e-003,-6.2866211e-003,-7.2326660e-003,-6.7749023e-003,-6.0119629e-003,-5.1269531e-003,-4.9133301e-003,-4.4250488e-003,-3.4179688e-003,-2.1057129e-003,2.4414063e-004,2.7770996e-003,5.2795410e-003,6.6528320e-003,6.8664551e-003,5.5236816e-003,3.5400391e-003,2.1667480e-003,1.4953613e-003,1.4038086e-003,1.1901855e-003,1.4648438e-003,5.1879883e-004,1.2207031e-004,2.4414063e-004,1.8005371e-003,4.7302246e-003,6.5612793e-003,7.5378418e-003,7.2631836e-003,4.7912598e-003,3.2653809e-003,2.6855469e-003,8.8500977e-004,-1.8310547e-004,-1.3732910e-003,-3.3569336e-003,-2.5939941e-003,-1.2512207e-003,2.4414063e-004,1.6479492e-003,1.9531250e-003,1.1596680e-003,9.1552734e-004,1.9531250e-003,2.5634766e-003,4.3640137e-003,3.9672852e-003,2.7160645e-003,2.1362305e-003,1.6174316e-003,2.1362305e-003,2.9602051e-003,3.8452148e-003,3.2958984e-003,2.8991699e-003,1.0070801e-003,-3.0517578e-005,4.2724609e-004,6.7138672e-004,2.1972656e-003,3.0822754e-003,2.5329590e-003,1.6479492e-003,2.4414063e-004,-5.1879883e-004,6.1035156e-004,2.0751953e-003,5.3100586e-003,7.0800781e-003,7.1105957e-003,6.7749023e-003,3.3874512e-003,1.4648438e-003,-1.5258789e-004,-1.6174316e-003,4.8828125e-004,1.5258789e-004,-1.2512207e-003,-1.4953613e-003,-2.2583008e-003,-2.1972656e-003,-4.2724609e-004,3.3569336e-004,1.1901855e-003,1.6479492e-003,8.2397461e-004,-1.5258789e-004,-1.0681152e-003,-1.6479492e-003,-1.7089844e-003,-1.9531250e-003,-2.4719238e-003,-2.6550293e-003,-3.7231445e-003,-3.2653809e-003,-2.5634766e-003,-1.6479492e-003,-1.0986328e-003,-1.4953613e-003,-1.9226074e-003,-2.9907227e-003,-2.4719238e-003,-1.9531250e-003,-1.0070801e-003,-3.3569336e-004,-6.4086914e-004,-1.2817383e-003,-2.4719238e-003,-3.2348633e-003,-3.9978027e-003,-4.3945313e-003,-4.6386719e-003,-5.2185059e-003,-6.6223145e-003,-7.1411133e-003,-6.6223145e-003,-5.6457520e-003,-4.0588379e-003,-3.2958984e-003,-3.7536621e-003,-4.1198730e-003,-5.7373047e-003,-6.3171387e-003,-4.5471191e-003,-3.9367676e-003,-1.3122559e-003,1.5258789e-004,-3.9672852e-004,-2.7465820e-004,-1.8310547e-003,-2.0141602e-003,-1.9836426e-003,-1.9531250e-003,-1.1596680e-003,-2.3498535e-003,-4.4860840e-003,-5.8898926e-003,-7.5378418e-003,-8.5754395e-003,-8.0261230e-003,-7.5988770e-003,-5.7067871e-003,-3.9367676e-003,-2.0141602e-003,3.0517578e-005,1.1291504e-003,2.3193359e-003,3.5095215e-003,3.9367676e-003,4.6386719e-003,4.3640137e-003,4.4555664e-003,5.0659180e-003,5.2795410e-003,5.9204102e-003,6.2561035e-003,6.6833496e-003,7.3242188e-003,8.1787109e-003,9.1857910e-003,9.6130371e-003,9.4604492e-003,8.1176758e-003,6.4086914e-003,5.4626465e-003,5.8288574e-003,6.0119629e-003,7.4157715e-003,7.5073242e-003,5.4016113e-003,3.9672852e-003,1.5258789e-003,9.7656250e-004,1.9226074e-003,1.8920898e-003,2.6550293e-003,2.4414063e-003,1.2817383e-003,2.5329590e-003,3.7841797e-003,4.3640137e-003,5.1574707e-003,3.7231445e-003,1.7089844e-003,2.7465820e-004,-3.0517578e-005,-3.9672852e-004,-2.4414063e-004,3.9672852e-004,-7.0190430e-004,-1.8005371e-003,-4.4860840e-003,-5.7067871e-003,-6.0424805e-003,-5.6152344e-003,-3.6621094e-003,-2.3803711e-003,-2.5024414e-003,-3.6010742e-003,-6.0729980e-003,-7.8430176e-003,-8.1176758e-003,-7.4768066e-003,-5.2185059e-003,-4.3640137e-003,-5.0354004e-003,-6.0729980e-003,-8.5144043e-003,-9.3688965e-003,-7.9956055e-003,-6.6833496e-003,-3.5400391e-003,-9.7656250e-004,7.9345703e-004,3.8452148e-003,5.8593750e-003,6.4697266e-003,5.7678223e-003,2.1057129e-003,-3.0212402e-003,-7.1716309e-003,-9.2163086e-003,-9.1552734e-003,-6.1950684e-003,-3.6315918e-003,-2.3498535e-003,-1.9226074e-003,-5.0659180e-003,-7.7819824e-003,-1.1108398e-002,-1.3366699e-002,-1.1444092e-002,-9.9182129e-003,-5.2490234e-003,-9.7656250e-004,1.3122559e-003,4.4250488e-003,4.3334961e-003,5.0964355e-003,4.7302246e-003,3.0822754e-003,2.0751953e-003,5.4931641e-004,6.1035156e-005,-1.8310547e-004,8.8500977e-004,1.3427734e-003,6.7138672e-004,2.1362305e-004,-1.2207031e-004,3.9672852e-004,2.7770996e-003,5.3100586e-003,7.7819824e-003,9.2468262e-003,8.0261230e-003,6.4086914e-003,3.3264160e-003,-6.1035156e-005,-2.0751953e-003,-3.2043457e-003,-1.5869141e-003,1.6479492e-003,5.2490234e-003,7.9650879e-003,7.2326660e-003,6.0424805e-003,3.8757324e-003,1.9836426e-003,2.1667480e-003,8.5449219e-004,1.2207031e-004,-1.0986328e-003,-2.9907227e-003,-3.3264160e-003,-2.9602051e-003,-1.6479492e-003,-4.5776367e-004,1.4038086e-003,2.5329590e-003,3.9978027e-003,4.6081543e-003,3.1433105e-003,6.7138672e-004,-2.8686523e-003,-6.3781738e-003,-8.8195801e-003,-8.0566406e-003,-7.2631836e-003,-5.9204102e-003,-4.7607422e-003,-5.4931641e-003,-4.3029785e-003,-3.0517578e-003,-1.1596680e-003,7.0190430e-004,1.0375977e-003,3.9672852e-004,2.4414063e-004,6.1035156e-004,-5.7983398e-004,6.1035156e-004,-3.6621094e-004,-3.1433105e-003,-4.9743652e-003,-7.5378418e-003,-8.5754395e-003,-7.8430176e-003,-7.4462891e-003,-5.4626465e-003,-4.3334961e-003,-3.9978027e-003,-3.4484863e-003,-5.0354004e-003,-6.0119629e-003,-5.9204102e-003,-6.8664551e-003,-6.9580078e-003,-7.5073242e-003,-8.0566406e-003,-7.0800781e-003,-5.6152344e-003,-2.2888184e-003,4.8828125e-004,1.7700195e-003,1.3732910e-003,3.0517578e-005,-1.4648438e-003,-1.8310547e-003,2.1362305e-004,1.4648438e-003,3.2958984e-003,4.0588379e-003,2.9907227e-003,2.5939941e-003,2.2277832e-003,2.4108887e-003,3.3569336e-003,3.4484863e-003,1.6174316e-003,-4.5776367e-004,-3.4179688e-003,-6.0424805e-003,-7.1105957e-003,-5.9814453e-003,-2.0141602e-003,1.9531250e-003,4.5776367e-003,4.9133301e-003,9.4604492e-004,-2.1667480e-003,-4.5471191e-003,-5.0964355e-003,-1.0375977e-003,3.3569336e-004,5.1879883e-004,2.4414063e-004,-4.2114258e-003,-5.3100586e-003,-4.2114258e-003,-4.0588379e-003,-2.5939941e-003,-3.0517578e-003,-5.1879883e-003,-5.1879883e-003,-4.8217773e-003,-4.3945313e-003,-1.2817383e-003,-8.8500977e-004,-6.1035156e-004,-1.5258789e-004,-3.9672852e-004,-3.0517578e-005,4.8828125e-004,-1.0070801e-003,-3.2653809e-003,-4.6081543e-003,-5.2490234e-003,-3.9062500e-003,-1.9531250e-003,-1.0681152e-003,-1.8615723e-003,-1.6784668e-003,-1.8920898e-003,-4.2724609e-004,3.4179688e-003,5.1269531e-003,6.3476563e-003,6.2255859e-003,3.8452148e-003,2.9296875e-003,2.7770996e-003,1.4953613e-003,2.0141602e-003,7.0190430e-004,-1.2207031e-003,-2.2277832e-003,-3.2043457e-003,-1.9226074e-003,3.9672852e-004,2.5024414e-003,4.1809082e-003,5.1574707e-003,4.3640137e-003,3.4179688e-003,1.6479492e-003,3.0517578e-005,-1.0070801e-003,-1.8615723e-003,-1.3427734e-003,-1.7395020e-003,-1.6479492e-003,-9.1552734e-004,-1.2817383e-003,-3.9672852e-004,2.2277832e-003,4.6386719e-003,7.1411133e-003,6.8969727e-003,5.3710938e-003,3.8146973e-003,1.9226074e-003,1.5869141e-003,3.0212402e-003,4.0893555e-003,5.1574707e-003,4.9438477e-003,1.7700195e-003,9.1552734e-005,-1.5563965e-003,-2.0446777e-003,-1.8310547e-004,6.1035156e-004,1.3122559e-003,1.9836426e-003,1.8615723e-003,2.5939941e-003,4.0588379e-003,5.4321289e-003,6.6528320e-003,7.9040527e-003,8.8806152e-003,9.5214844e-003,1.0009766e-002,8.4228516e-003,4.3945313e-003,6.7138672e-004,-3.2958984e-003,-4.1198730e-003,-1.6784668e-003,-2.1362305e-004,2.2583008e-003,2.6855469e-003,-2.4414063e-004,-1.2207031e-003,-1.3427734e-003,-4.8828125e-004,3.1127930e-003,2.6245117e-003,1.0070801e-003,-9.7656250e-004,-3.7536621e-003,-4.3640137e-003,-3.6010742e-003,-2.3193359e-003,-1.3427734e-003,8.5449219e-004,1.1901855e-003,1.6174316e-003,1.4343262e-003,1.2207031e-004,-2.1057129e-003,-4.0283203e-003,-2.1972656e-003,-1.3732910e-003,1.8005371e-003,2.3803711e-003,8.5449219e-004,-6.1035156e-005,-1.7395020e-003,-4.5776367e-004,3.1433105e-003,6.0729980e-003,7.3852539e-003,6.0729980e-003,2.1972656e-003,-2.4414063e-004,-1.0070801e-003,-1.2817383e-003,1.4648438e-003,3.2348633e-003,4.0283203e-003,5.4931641e-003,5.5236816e-003,5.4016113e-003,4.9743652e-003,3.2043457e-003,1.8310547e-003,1.2207031e-003,1.7089844e-003,2.2277832e-003,2.8686523e-003,2.3498535e-003,7.0190430e-004,1.4648438e-003,2.4414063e-003,5.2795410e-003,8.6975098e-003,1.0772705e-002,1.1779785e-002,1.1566162e-002,9.5214844e-003,6.9885254e-003,4.2724609e-003,5.7983398e-004,-1.8920898e-003,-3.9367676e-003,-3.7841797e-003,-1.8920898e-003,1.9226074e-003,6.0729980e-003,9.5214844e-003,1.2359619e-002,1.2603760e-002,1.2207031e-002,1.0925293e-002,6.5612793e-003,4.5776367e-003,1.6784668e-003,-8.8500977e-004,-2.6550293e-003,-4.2419434e-003,-4.0588379e-003,-4.4555664e-003,-3.0212402e-003,-1.6174316e-003,4.8828125e-004,2.2888184e-003,3.4484863e-003,3.8146973e-003,3.1433105e-003,1.9836426e-003,-7.6293945e-004,-2.5939941e-003,-4.7302246e-003,-4.6997070e-003,-3.3264160e-003,-6.4086914e-004,2.5939941e-003,3.5705566e-003,5.0048828e-003,3.8757324e-003,3.0517578e-003,2.6855469e-003,1.4038086e-003,1.5563965e-003,5.7983398e-004,-3.0517578e-005,-9.4604492e-004,-1.0986328e-003,-2.7465820e-004,1.8005371e-003,4.2114258e-003,5.9814453e-003,6.1645508e-003,2.9907227e-003,5.1879883e-004,-2.1057129e-003,-2.5329590e-003,1.2207031e-003,3.6315918e-003,6.5917969e-003,8.0261230e-003,5.4016113e-003,5.6152344e-003,5.5541992e-003,6.1950684e-003,9.9792480e-003,1.0192871e-002,9.9182129e-003,9.4299316e-003,7.7819824e-003,7.9956055e-003,9.4909668e-003,8.8806152e-003,7.9650879e-003,5.8593750e-003,1.9226074e-003,4.5776367e-004,3.9672852e-004,1.8310547e-004,1.5869141e-003,2.6245117e-003,4.3334961e-003,8.2397461e-003,1.2573242e-002,1.4617920e-002,1.4617920e-002,1.2878418e-002,8.6364746e-003,4.7912598e-003,2.9602051e-003,7.0190430e-004,1.2817383e-003,1.7395020e-003,1.6479492e-003,3.8452148e-003,4.2724609e-003,6.1645508e-003,7.2631836e-003,7.7209473e-003,7.9956055e-003,6.2866211e-003,4.4555664e-003,4.8828125e-004,-2.7465820e-003,-3.6926270e-003,-1.2207031e-003,4.1809082e-003,1.2054443e-002,1.6815186e-002,1.5289307e-002,1.1352539e-002,1.9226074e-003,-3.2958984e-003,-3.3874512e-003,-2.6245117e-003,4.7607422e-003,8.0566406e-003,8.3312988e-003,9.5214844e-003,3.8146973e-003,1.1291504e-003,-3.9672852e-004,-2.3498535e-003,-6.7138672e-004,-1.2207031e-004,1.0681152e-003,2.5634766e-003,1.7395020e-003,2.4414063e-003,3.4179688e-003,3.2348633e-003,2.8686523e-003,1.2817383e-003,-6.1035156e-005,-1.4343262e-003,-1.0070801e-003,-4.5776367e-004,-1.8310547e-004,-7.0190430e-004,-3.2653809e-003,-5.2795410e-003,-6.7443848e-003,-5.9204102e-003,-2.1667480e-003,1.7395020e-003,5.6457520e-003,7.9956055e-003,6.9580078e-003,5.4016113e-003,3.1127930e-003,1.5258789e-004,-1.0375977e-003,-2.9296875e-003,-2.5634766e-003,-2.5024414e-003,-2.1972656e-003,-1.2207031e-003,-2.2888184e-003,-1.9836426e-003,-2.2888184e-003,-1.4648438e-003,-1.8310547e-004,5.7983398e-004,3.0517578e-004,-2.4414063e-004,-4.5776367e-004,-7.3242188e-004,7.6293945e-004,1.8005371e-003,3.0822754e-003,5.2795410e-003,6.8969727e-003,8.1787109e-003,8.4533691e-003,7.7514648e-003,6.2255859e-003,4.5166016e-003,3.6621094e-003,2.5634766e-003,1.9836426e-003,1.1901855e-003,9.1552734e-005,2.1362305e-004,1.5563965e-003,2.2277832e-003,2.6550293e-003,2.5024414e-003,-4.5776367e-004,-1.6174316e-003,-2.0141602e-003,-1.7395020e-003,1.7089844e-003,3.3874512e-003,4.3334961e-003,6.6223145e-003,7.2937012e-003,9.4909668e-003,1.0803223e-002,9.8571777e-003,6.2866211e-003,3.3874512e-003,2.1667480e-003,1.8920898e-003,3.9672852e-003,3.2043457e-003,3.9672852e-004,-8.5449219e-004,-2.7465820e-003,-2.1362305e-003,2.5634766e-003,4.6081543e-003,4.9133301e-003,5.0048828e-003,2.9602051e-003,3.7841797e-003,7.0800781e-003,7.6904297e-003,7.7514648e-003,5.8898926e-003,1.5869141e-003,-2.4414063e-004,-5.7983398e-004,-1.3732910e-003,-1.2817383e-003,-1.9836426e-003,-3.4484863e-003,-2.8686523e-003,-4.8828125e-004,2.4108887e-003,6.3171387e-003,8.9721680e-003,9.7045898e-003,9.4299316e-003,8.4838867e-003,6.4086914e-003,5.8288574e-003,6.5612793e-003,1.0681152e-002,1.5228271e-002,1.9012451e-002,1.8463135e-002,1.0528564e-002,4.6997070e-003,-3.0822754e-003,-7.5683594e-003,-5.7373047e-003,-6.3476563e-003,-5.8898926e-003,-4.4860840e-003,-4.2114258e-003,1.1291504e-003,9.0026855e-003,1.3488770e-002,1.5258789e-002,1.2786865e-002,4.9133301e-003,-2.1362305e-004,-2.2277832e-003,-5.9204102e-003,-5.7983398e-003,-7.8125000e-003,-1.2054443e-002,-1.0650635e-002,-9.1247559e-003,-4.9743652e-003,-6.1035156e-005,2.2583008e-003,2.4719238e-003,3.5705566e-003,5.2490234e-003,5.0659180e-003,5.7067871e-003,1.7395020e-003,-4.1809082e-003,-8.1481934e-003,-9.4604492e-003,-7.9650879e-003,-2.8686523e-003,-3.0517578e-005,-1.4953613e-003,-5.1879883e-004,-2.5634766e-003,-1.6479492e-003,2.9907227e-003,4.2419434e-003,6.8664551e-003,5.8288574e-003,1.8310547e-003,-1.2207031e-004,-7.0190430e-004,-2.7465820e-004,2.2888184e-003,2.6855469e-003,7.9345703e-004,-6.1035156e-005,-1.2817383e-003,5.7983398e-004,5.4016113e-003,8.1176758e-003,8.4228516e-003,5.8898926e-003,-1.0375977e-003,-4.8828125e-003,-5.4016113e-003,-4.4555664e-003,2.1362305e-004,2.0446777e-003,9.1552734e-004,1.6784668e-003,5.7983398e-004,1.4648438e-003,5.0048828e-003,5.1269531e-003,3.7231445e-003,2.5634766e-003,1.0070801e-003,1.0681152e-003,2.7465820e-003,6.1035156e-004,-2.7160645e-003,-4.7302246e-003,-5.2185059e-003,-1.2207031e-003,5.6152344e-003,9.0026855e-003,8.1787109e-003,7.0800781e-003,4.2114258e-003,6.1340332e-003,1.2268066e-002,1.2847900e-002,1.0650635e-002,4.9133301e-003,-4.1503906e-003,-5.6457520e-003,-1.5258789e-004,3.9062500e-003,1.0040283e-002,1.1047363e-002,3.9978027e-003,2.4108887e-003,1.2512207e-003,2.3498535e-003,9.2163086e-003,9.5520020e-003,7.2937012e-003,4.6386719e-003,-1.4648438e-003,-3.6926270e-003,-2.6550293e-003,-1.2207031e-003,3.5400391e-003,6.4392090e-003,6.8054199e-003,5.4321289e-003,-9.4604492e-004,-3.0212402e-003,-3.7536621e-003,-3.6621094e-003,9.1552734e-004,-1.2207031e-004,-4.3640137e-003,-8.0566406e-003,-1.3000488e-002,-9.8571777e-003,-8.2397461e-004,4.2419434e-003,6.7749023e-003,4.3334961e-003,-4.1809082e-003,-5.9204102e-003,-3.1433105e-003,-1.6174316e-003,2.7465820e-003,1.3122559e-003,-5.2185059e-003,-6.6223145e-003,-5.0048828e-003,-8.2397461e-004,6.4392090e-003,7.7209473e-003,2.8381348e-003,-3.3569336e-004,-4.5471191e-003,-4.2114258e-003,2.0446777e-003,2.8991699e-003,2.3803711e-003,6.4086914e-004,-5.2795410e-003,-5.7067871e-003,-2.5634766e-003,-1.8310547e-004,3.8757324e-003,5.0048828e-003,2.9907227e-003,2.6245117e-003,2.1057129e-003,2.6855469e-003,5.7983398e-003,6.8054199e-003,7.9956055e-003,7.0190430e-003,3.5095215e-003,1.6174316e-003,-2.1362305e-004,-1.5258789e-004,1.4038086e-003,2.3803711e-003,3.0822754e-003,4.1198730e-003,4.7302246e-003,5.9204102e-003,7.5073242e-003,8.1176758e-003,6.8664551e-003,5.8288574e-003,5.4321289e-003,5.7678223e-003,7.6904297e-003,6.7138672e-003,3.4179688e-003,1.6174316e-003,-8.2397461e-004,4.2724609e-004,4.5776367e-003,5.4626465e-003,5.0659180e-003,3.8146973e-003,8.2397461e-004,2.3498535e-003,7.1411133e-003,9.4909668e-003,1.1322021e-002,1.0101318e-002,5.6762695e-003,5.0048828e-003,7.1105957e-003,7.5683594e-003,8.9416504e-003,7.4768066e-003,2.7770996e-003,2.3193359e-003,4.1503906e-003,5.2490234e-003,7.1105957e-003,4.7912598e-003,-1.0986328e-003,-2.2583008e-003,-1.4343262e-003,4.5776367e-004,4.8828125e-003,4.1198730e-003,-1.2207031e-004,-2.3498535e-003,-4.8217773e-003,-4.5776367e-003,-8.8500977e-004,2.1362305e-004,3.0517578e-004,1.0681152e-003,9.1552734e-005,1.0375977e-003,3.0212402e-003,3.2043457e-003,2.2888184e-003,1.5563965e-003,5.7983398e-004,-3.6621094e-004,1.7700195e-003,1.2817383e-003,-5.4931641e-004,-1.8310547e-003,-4.6691895e-003,-5.7678223e-003,-5.2185059e-003,-4.3029785e-003,-2.5634766e-003,-3.0517578e-004,2.2277832e-003,4.1198730e-003,3.9672852e-003,2.1667480e-003,-2.1057129e-003,-5.2185059e-003,-4.8522949e-003,-4.0893555e-003,-2.1362305e-004,1.2817383e-003,-8.2397461e-004,-8.5449219e-004,-4.1503906e-003,-4.2419434e-003,-1.4038086e-003,-3.6621094e-004,2.6245117e-003,4.0588379e-003,4.2724609e-003,5.6457520e-003,7.1105957e-003,6.5917969e-003,4.8217773e-003,8.5449219e-004,-4.5166016e-003,-7.1716309e-003,-6.0424805e-003,-2.7465820e-003,3.8146973e-003,7.9650879e-003,6.6833496e-003,7.0495605e-003,5.0354004e-003,5.7373047e-003,1.0101318e-002,9.5825195e-003,7.6599121e-003,3.1738281e-003,-3.7536621e-003,-5.7678223e-003,-2.0751953e-003,1.8920898e-003,8.9111328e-003,1.2359619e-002,9.5520020e-003,9.8876953e-003,8.0566406e-003,7.3242188e-003,1.1016846e-002,8.3923340e-003,4.6997070e-003,2.7465820e-004,-4.6386719e-003,-6.2561035e-003,-4.8828125e-003,-2.3498535e-003,1.0070801e-003,4.4250488e-003,7.2631836e-003,1.0101318e-002,1.0589600e-002,8.7890625e-003,5.0964355e-003,1.4343262e-003,1.4648438e-003,7.3242188e-004,3.1433105e-003,3.9672852e-003,2.0751953e-003,2.8076172e-003,2.0751953e-003,4.3334961e-003,7.8125000e-003,8.4533691e-003,7.5073242e-003,6.2561035e-003,5.4931641e-003,6.9885254e-003,1.1718750e-002,1.4404297e-002,1.5441895e-002,1.4434814e-002,8.6364746e-003,3.2043457e-003,-1.0375977e-003,-4.6997070e-003,-4.4555664e-003,-3.9062500e-003,-2.1057129e-003,1.0375977e-003,3.5095215e-003,5.7373047e-003,5.5847168e-003,6.1340332e-003,7.5988770e-003,9.1552734e-003,1.2329102e-002,1.2390137e-002,1.0498047e-002,7.9345703e-003,5.1269531e-003,3.1127930e-003,4.8522949e-003,7.2021484e-003,7.9040527e-003,7.7209473e-003,3.8452148e-003,7.9345703e-004,-2.6245117e-003,-7.2937012e-003,-1.0040283e-002,-1.2817383e-002,-1.3275146e-002,-1.1444092e-002,-6.5307617e-003,7.9345703e-004,9.3383789e-003,1.7364502e-002,2.1087646e-002,2.2003174e-002,1.7272949e-002,1.0345459e-002,3.2348633e-003,-4.8828125e-003,-8.5754395e-003,-1.2176514e-002,-1.3854980e-002,-1.3214111e-002,-1.3549805e-002,-8.1481934e-003,-2.9907227e-003,3.9978027e-003,1.0833740e-002,1.4801025e-002,1.6815186e-002,1.6723633e-002,1.5899658e-002,1.3305664e-002,1.1444092e-002,7.0495605e-003,2.0141602e-003,-2.4108887e-003,-5.4931641e-003,-6.0424805e-003,-5.4931641e-003,-4.9743652e-003,-6.7138672e-003,-6.9274902e-003,-8.5754395e-003,-8.3312988e-003,-4.2114258e-003,-1.9226074e-003,4.0893555e-003,8.0261230e-003,9.8266602e-003,1.2115479e-002,1.1444092e-002,1.0498047e-002,9.6740723e-003,6.9274902e-003,5.1269531e-003,2.7160645e-003,-1.2512207e-003,-3.5705566e-003,-5.0048828e-003,-4.3945313e-003,-1.7089844e-003,6.4086914e-004,3.3874512e-003,5.4016113e-003,6.2561035e-003,7.7819824e-003,9.8876953e-003,1.0772705e-002,1.2268066e-002,1.1047363e-002,8.3312988e-003,6.8969727e-003,4.9133301e-003,3.9367676e-003,2.3193359e-003,-3.6621094e-004,-3.6926270e-003,-4.1198730e-003,-7.0190430e-004,5.7983398e-003,1.5472412e-002,2.1148682e-002,2.1728516e-002,1.9439697e-002,1.2847900e-002,8.5449219e-003,7.6599121e-003,4.6691895e-003,5.5236816e-003,3.7536621e-003,-1.3122559e-003,-2.5024414e-003,-5.5236816e-003,-6.3781738e-003,-5.3100586e-003,-4.6997070e-003,-2.5329590e-003,4.2724609e-004,4.1809082e-003,6.8664551e-003,8.9111328e-003,7.7514648e-003,4.9133301e-003,2.2888184e-003,1.2817383e-003,1.2207031e-004,-1.5258789e-004,-9.1552734e-005,-3.4484863e-003,-3.9367676e-003,-4.3640137e-003,-3.8146973e-003,-1.3427734e-003,6.1035156e-004,3.4484863e-003,6.8054199e-003,1.0772705e-002,1.4343262e-002,1.7608643e-002,1.8127441e-002,1.7425537e-002,1.4251709e-002,8.2702637e-003,3.9672852e-004,-8.7280273e-003,-1.6296387e-002,-2.0324707e-002,-1.9317627e-002,-1.3031006e-002,-6.0729980e-003,-1.6174316e-003,2.4108887e-003,1.5563965e-003,4.1503906e-003,8.8500977e-003,1.1047363e-002,1.6510010e-002,1.4465332e-002,8.6975098e-003,2.7160645e-003,-4.8217773e-003,-8.2397461e-003,-7.2326660e-003,-5.3405762e-003,-2.3498535e-003,1.0070801e-003,6.1035156e-004,1.0070801e-003,-1.1291504e-003,-2.4108887e-003,-4.8828125e-004,1.9531250e-003,8.6059570e-003,1.0223389e-002,8.2702637e-003,4.1198730e-003,-3.2653809e-003,-5.2185059e-003,-2.5939941e-003,-2.7465820e-004,2.4719238e-003,8.5449219e-004,-6.5307617e-003,-8.7280273e-003,-7.3242188e-003,-3.1433105e-003,7.1411133e-003,1.0681152e-002,1.1138916e-002,1.1932373e-002,9.9487305e-003,1.1230469e-002,1.6296387e-002,1.5960693e-002,1.2878418e-002,6.3171387e-003,-5.2795410e-003,-1.1352539e-002,-1.2847900e-002,-1.1627197e-002,-4.7912598e-003,-3.0517578e-004,6.1035156e-004,1.9836426e-003,-1.7700195e-003,-3.9978027e-003,-3.2653809e-003,-3.9978027e-003,-2.7465820e-004,-4.5776367e-004,-2.8991699e-003,-4.5166016e-003,-8.6975098e-003,-7.2937012e-003,-2.1972656e-003,2.3193359e-003,6.7443848e-003,8.3312988e-003,4.2114258e-003,2.2583008e-003,1.1291504e-003,1.2207031e-004,3.1127930e-003,1.8920898e-003,-2.7465820e-004,-1.9226074e-003,-4.6081543e-003,-4.9133301e-003,-3.4790039e-003,-2.1362305e-003,-1.0986328e-003,2.7465820e-004,1.5258789e-004,-3.3569336e-004,-1.4953613e-003,-2.4719238e-003,-4.2419434e-003,-5.4626465e-003,-5.8898926e-003,-6.8664551e-003,-7.7514648e-003,-8.3618164e-003,-8.8500977e-003,-6.6528320e-003,-1.1596680e-003,2.7160645e-003,6.1950684e-003,8.1176758e-003,7.6293945e-003,6.8969727e-003,6.4392090e-003,3.5400391e-003,3.0517578e-005,-4.1503906e-003,-9.3078613e-003,-1.1230469e-002,-1.0498047e-002,-1.0162354e-002,-9.0026855e-003,-7.7819824e-003,-7.9956055e-003,-4.4555664e-003,-4.5776367e-004,1.1596680e-003,1.4343262e-003,-2.5329590e-003,-7.9650879e-003,-1.1749268e-002,-1.2237549e-002,-1.3122559e-002,-1.2207031e-002,-1.1810303e-002,-1.3519287e-002,-1.0070801e-002,-5.5541992e-003,2.1362305e-004,6.4392090e-003,1.0467529e-002,1.2054443e-002,1.3305664e-002,1.2573242e-002,8.2092285e-003,3.4179688e-003,-3.3874512e-003,-8.3007813e-003,-9.9487305e-003,-7.3547363e-003,-4.3029785e-003,-2.5329590e-003,-3.9672852e-004,-2.8381348e-003,-5.7983398e-004,3.2043457e-003,4.1503906e-003,4.5471191e-003,-2.4414063e-004,-7.4157715e-003,-1.0528564e-002,-8.8195801e-003,-6.8054199e-003,-1.6479492e-003,-1.7089844e-003,-6.6528320e-003,-6.0119629e-003,-5.5847168e-003,-1.5869141e-003,6.5307617e-003,8.2397461e-003,6.5612793e-003,3.8757324e-003,-8.5449219e-004,-1.7700195e-003,1.3122559e-003,2.1667480e-003,3.2043457e-003,3.6010742e-003,3.3569336e-004,5.1879883e-004,2.0751953e-003,3.9062500e-003,6.2255859e-003,6.9580078e-003,5.5847168e-003,3.5705566e-003,8.5449219e-004,-2.4719238e-003,-4.4250488e-003,-7.3547363e-003,-9.1552734e-003,-1.0253906e-002,-1.1016846e-002,-9.2163086e-003,-6.9580078e-003,-4.6386719e-003,-2.6550293e-003,-1.4343262e-003,-1.2817383e-003,4.2724609e-004,3.6010742e-003,6.7749023e-003,1.0955811e-002,1.1322021e-002,7.5378418e-003,2.6855469e-003,-4.0588379e-003,-8.1787109e-003,-8.1787109e-003,-9.1857910e-003,-8.6364746e-003,-9.0637207e-003,-1.0803223e-002,-9.2773438e-003,-6.3171387e-003,-2.3803711e-003,2.7770996e-003,4.4555664e-003,1.3427734e-003,-1.1901855e-003,-6.4392090e-003,-1.0498047e-002,-1.0253906e-002,-9.3688965e-003,-5.1574707e-003,-1.4648438e-003,-1.6174316e-003,-9.7656250e-004,-3.4790039e-003,-4.0893555e-003,-1.9226074e-003,-1.7700195e-003,1.2207031e-004,3.0517578e-004,-1.4648438e-003,-1.1291504e-003,3.3569336e-004,1.8310547e-003,4.4250488e-003,4.1198730e-003,-6.7138672e-004,-3.7841797e-003,-8.3923340e-003,-1.0559082e-002,-9.7656250e-003,-1.0833740e-002,-1.1413574e-002,-1.1688232e-002,-1.2268066e-002,-1.0009766e-002,-5.6762695e-003,-1.2817383e-003,3.4484863e-003,6.4392090e-003,7.5988770e-003,7.6293945e-003,5.6762695e-003,2.2583008e-003,-1.8310547e-003,-5.0354004e-003,-6.0729980e-003,-5.4016113e-003,-2.9296875e-003,6.1035156e-005,5.1879883e-004,2.1057129e-003,1.6174316e-003,2.4414063e-003,5.9204102e-003,7.7819824e-003,1.0803223e-002,9.9182129e-003,6.8664551e-003,1.6479492e-003,-4.8828125e-003,-9.5520020e-003,-1.0711670e-002,-7.7209473e-003,-3.0212402e-003,1.3427734e-003,3.4790039e-003,5.0354004e-003,2.0141602e-003,7.6293945e-004,3.0517578e-005,-1.4953613e-003,9.7656250e-004,4.5776367e-004,5.7983398e-004,1.2207031e-004,-1.3427734e-003,-7.3242188e-004,0.0000000e+000,2.8991699e-003,6.1035156e-003,9.9792480e-003,1.3244629e-002,1.4068604e-002,1.2176514e-002,9.1247559e-003,4.4250488e-003,7.9345703e-004,-2.4414063e-004,-2.7160645e-003,-2.6245117e-003,-3.4179688e-003,-4.8217773e-003,-2.7770996e-003,-6.4086914e-004,2.1972656e-003,4.7607422e-003,2.5634766e-003,-3.1433105e-003,-8.1481934e-003,-1.0955811e-002,-9.8876953e-003,-2.3498535e-003,4.0893555e-003,7.9040527e-003,8.9111328e-003,1.2207031e-004,-5.0659180e-003,-9.3688965e-003,-1.2207031e-002,-7.5073242e-003,-8.4228516e-003,-1.1016846e-002,-1.2847900e-002,-1.7059326e-002,-1.4556885e-002,-6.7749023e-003,-1.4953613e-003,5.5541992e-003,8.8195801e-003,7.3547363e-003,9.6435547e-003,1.3610840e-002,1.1901855e-002,7.4462891e-003,-4.7607422e-003,-2.4078369e-002,-3.3233643e-002,-3.1433105e-002,-2.0355225e-002,2.9907227e-003,1.8920898e-002,2.0202637e-002,1.7578125e-002,1.2207031e-004,-1.0955811e-002,-9.3994141e-003,-1.0162354e-002,4.3334961e-003,1.2481689e-002,1.4068604e-002,1.5289307e-002,4.0893555e-003,-2.6245117e-003,-9.2163086e-003,-1.1810303e-002,-4.4250488e-003,2.5329590e-003,1.2756348e-002,1.9744873e-002,1.7974854e-002,1.6021729e-002,8.7280273e-003,2.3498535e-003,8.2397461e-004,-9.7656250e-004,4.5471191e-003,1.0070801e-002,1.5411377e-002,1.9287109e-002,1.5106201e-002,1.1322021e-002,3.1738281e-003,-1.2207031e-003,6.1035156e-004,2.0446777e-003,8.7890625e-003,1.2451172e-002,1.2054443e-002,1.4007568e-002,1.2878418e-002,1.2176514e-002,1.1444092e-002,7.2631836e-003,2.3193359e-003,1.0986328e-003,3.7841797e-003,8.0871582e-003,1.4739990e-002,1.7211914e-002,1.1596680e-002,6.2561035e-003,-1.8920898e-003,-4.8522949e-003,2.1362305e-003,7.6904297e-003,1.6784668e-002,1.9897461e-002,1.2023926e-002,3.3264160e-003,-1.1291504e-002,-2.0050049e-002,-1.6754150e-002,-1.0772705e-002,4.9133301e-003,1.6662598e-002,1.8463135e-002,1.9989014e-002,1.0101318e-002,4.4555664e-003,4.7912598e-003,1.0681152e-003,4.9743652e-003,3.8146973e-003,1.0375977e-003,2.8381348e-003,2.6245117e-003,5.2490234e-003,8.5754395e-003,1.1199951e-002,1.2542725e-002,1.4556885e-002,1.4770508e-002,1.3183594e-002,1.0925293e-002,6.5002441e-003,4.2114258e-003,4.7912598e-003,9.4299316e-003,1.2481689e-002,1.2817383e-002,1.1230469e-002,4.7912598e-003,2.2888184e-003,4.5166016e-003,5.7678223e-003,8.8500977e-003,7.2326660e-003,0.0000000e+000,-2.8991699e-003,-4.8217773e-003,-1.6479492e-003,8.5144043e-003,1.4434814e-002,1.7517090e-002,1.7944336e-002,1.1016846e-002,6.3781738e-003,3.8757324e-003,2.4719238e-003,8.6364746e-003,1.2084961e-002,1.5197754e-002,1.5167236e-002,8.3923340e-003,6.2866211e-003,5.3100586e-003,7.5988770e-003,1.4434814e-002,1.4404297e-002,1.0894775e-002,7.2326660e-003,1.9531250e-003,4.3029785e-003,1.3214111e-002,1.8646240e-002,2.1636963e-002,1.9348145e-002,9.7351074e-003,4.7302246e-003,4.1198730e-003,2.6550293e-003,5.0048828e-003,3.6621094e-003,-9.1552734e-004,-1.6479492e-003,-1.8310547e-003,-6.7138672e-004,1.7700195e-003,3.0212402e-003,3.1738281e-003,7.0495605e-003,1.2969971e-002,1.6723633e-002,1.8920898e-002,1.8920898e-002,1.7272949e-002,2.0233154e-002,2.4627686e-002,2.2644043e-002,1.4556885e-002,1.7089844e-003,-1.3305664e-002,-1.3580322e-002,3.9672852e-003,2.2064209e-002,4.0679932e-002,4.1198730e-002,1.3977051e-002,-3.0822754e-003,-1.6387939e-002,-1.4709473e-002,1.6784668e-002,2.9632568e-002,3.1372070e-002,2.3315430e-002,-1.0131836e-002,-2.0233154e-002,-1.1993408e-002,-1.5258789e-003,2.6336670e-002,3.2684326e-002,1.5625000e-002,3.4484863e-003,-1.8432617e-002,-2.3681641e-002,-3.6315918e-003,1.0955811e-002,3.4210205e-002,4.6966553e-002,3.8146973e-002,3.3081055e-002,1.8035889e-002,7.2326660e-003,9.3688965e-003,6.6223145e-003,1.1138916e-002,1.0620117e-002,2.8686523e-003,8.5449219e-004,-1.9836426e-003,4.6997070e-003,1.7211914e-002,2.4078369e-002,2.5634766e-002,1.7333984e-002,-5.4931641e-004,-1.1291504e-002,-1.0650635e-002,-6.1645508e-003,9.8571777e-003,1.5899658e-002,7.8125000e-003,4.7302246e-003,-4.5166016e-003,-6.4086914e-004,1.7120361e-002,2.7496338e-002,3.6987305e-002,3.6499023e-002,2.0965576e-002,1.0650635e-002,3.4179688e-003,-2.1972656e-003,4.4555664e-003,8.5144043e-003,1.3000488e-002,1.6876221e-002,1.1962891e-002,9.0942383e-003,1.8310547e-003,-2.4414063e-003,7.9345703e-004,5.0048828e-003,1.4892578e-002,1.8402100e-002,1.4526367e-002,1.1627197e-002,4.6691895e-003,3.8146973e-003,1.0223389e-002,1.0101318e-002,8.2092285e-003,3.9062500e-003,-4.1503906e-003,-2.7465820e-003,7.5683594e-003,1.5655518e-002,2.5024414e-002,2.8198242e-002,2.3712158e-002,2.7008057e-002,3.4637451e-002,4.2510986e-002,5.3253174e-002,5.0781250e-002,3.4606934e-002,1.2817383e-002,-1.8585205e-002,-4.6112061e-002,-6.2835693e-002,-7.1105957e-002,-6.0333252e-002,-4.1229248e-002,-1.9042969e-002,3.0822754e-003,9.8266602e-003,1.9531250e-002,2.5207520e-002,3.3996582e-002,5.4962158e-002,5.8837891e-002,5.7434082e-002,4.0252686e-002,7.3852539e-003,-1.4587402e-002,-2.7008057e-002,-3.0548096e-002,-2.0843506e-002,-1.1871338e-002,-9.6740723e-003,4.6691895e-003,1.5777588e-002,3.4362793e-002,5.6518555e-002,6.3049316e-002,6.1218262e-002,4.8278809e-002,3.0273438e-002,9.8266602e-003,-2.1667480e-003,-1.7791748e-002,-2.9479980e-002,-3.6865234e-002,-4.9346924e-002,-4.9926758e-002,-5.3619385e-002,-4.7821045e-002,-3.5705566e-002,-1.7730713e-002,9.3994141e-003,3.2806396e-002,5.4962158e-002,6.6619873e-002,6.7626953e-002,6.3629150e-002,5.9173584e-002,4.9133301e-002,4.2724609e-002,2.9083252e-002,8.9111328e-003,-5.7983398e-003,-2.4993896e-002,-3.1524658e-002,-3.0975342e-002,-2.5421143e-002,-1.4709473e-002,-2.6245117e-003,9.3994141e-003,2.1514893e-002,3.3142090e-002,3.6193848e-002,3.6895752e-002,2.7893066e-002,1.6540527e-002,3.7841797e-003,-7.1105957e-003,-1.5563965e-002,-2.3010254e-002,-2.4993896e-002,-2.9449463e-002,-2.5878906e-002,-2.2796631e-002,-1.2481689e-002,2.7465820e-003,1.7730713e-002,3.5247803e-002,4.5288086e-002,5.2978516e-002,5.2673340e-002,5.0964355e-002,4.5196533e-002,4.0527344e-002,2.9968262e-002,1.4007568e-002,-1.8005371e-003,-2.2857666e-002,-3.2836914e-002,-3.6621094e-002,-3.4149170e-002,-2.5817871e-002,-1.8920898e-002,-1.7333984e-002,-1.3000488e-002,-7.0190430e-003,9.7656250e-004,1.8981934e-002,2.7099609e-002,3.3691406e-002,3.3447266e-002,2.4963379e-002,2.1087646e-002,1.7486572e-002,1.4556885e-002,1.1230469e-002,4.8217773e-003,-6.5612793e-003,-1.0681152e-002,-1.0742188e-002,-3.3874512e-003,1.2390137e-002,2.3010254e-002,2.9205322e-002,2.8289795e-002,1.9256592e-002,9.6740723e-003,5.9509277e-003,1.1596680e-003,4.9438477e-003,6.4697266e-003,3.8146973e-003,3.0212402e-003,-6.5917969e-003,-1.1199951e-002,-1.6479492e-002,-1.6845703e-002,-1.0345459e-002,-4.0893555e-003,4.7607422e-003,9.4604492e-003,1.1260986e-002,1.2268066e-002,1.5533447e-002,1.9256592e-002,2.9174805e-002,3.4149170e-002,3.6773682e-002,3.7994385e-002,3.1433105e-002,2.7282715e-002,2.0874023e-002,1.3427734e-002,5.2490234e-003,-3.6621094e-003,-1.3061523e-002,-1.9226074e-002,-2.1453857e-002,-2.2918701e-002,-2.0904541e-002,-1.9165039e-002,-1.7700195e-002,-1.4892578e-002,-1.0894775e-002,-6.5002441e-003,-4.8828125e-004,4.4250488e-003,9.2163086e-003,1.2817383e-002,1.3427734e-002,1.2542725e-002,6.9580078e-003,2.8381348e-003,-2.1362305e-004,-3.0517578e-004,4.7302246e-003,8.7280273e-003,1.1291504e-002,1.1810303e-002,7.7514648e-003,6.2866211e-003,8.3007813e-003,1.0284424e-002,1.7547607e-002,2.0935059e-002,2.1057129e-002,1.8737793e-002,1.0375977e-002,3.2958984e-003,-3.8452148e-003,-9.7351074e-003,-1.2695313e-002,-1.6937256e-002,-2.2827148e-002,-2.7984619e-002,-3.4271240e-002,-3.3203125e-002,-2.4353027e-002,-1.3885498e-002,-2.4414063e-004,6.7443848e-003,5.1269531e-003,5.6457520e-003,5.1574707e-003,8.6975098e-003,2.0751953e-002,2.5390625e-002,2.4749756e-002,1.9348145e-002,3.4179688e-003,-4.0283203e-003,-4.3640137e-003,-2.8076172e-003,5.1879883e-003,6.5917969e-003,-1.5869141e-003,-7.1105957e-003,-1.5319824e-002,-1.8493652e-002,-1.0894775e-002,-7.6293945e-003,-1.9226074e-003,7.0190430e-004,-3.9367676e-003,-5.8593750e-003,-8.5449219e-003,-1.0467529e-002,-8.1176758e-003,-8.0261230e-003,-8.9721680e-003,-9.3383789e-003,-1.2237549e-002,-1.1566162e-002,-8.8500977e-003,-5.5541992e-003,3.3569336e-004,3.6621094e-003,4.3945313e-003,4.3945313e-003,2.5024414e-003,2.1057129e-003,5.6152344e-003,7.6904297e-003,1.1535645e-002,1.2939453e-002,9.8876953e-003,7.7819824e-003,2.5024414e-003,-1.5258789e-003,-3.2348633e-003,-8.1481934e-003,-1.3519287e-002,-1.9958496e-002,-2.6885986e-002,-2.9449463e-002,-2.7648926e-002,-2.2521973e-002,-1.4129639e-002,-6.3171387e-003,1.2207031e-004,5.4626465e-003,6.5917969e-003,6.6528320e-003,5.8593750e-003,2.6245117e-003,1.2817383e-003,-6.1035156e-005,3.0517578e-004,1.4343262e-003,2.3803711e-003,3.6315918e-003,1.7700195e-003,1.2817383e-003,-1.2817383e-003,-3.3874512e-003,-4.1198730e-003,-7.4157715e-003,-8.9111328e-003,-1.0803223e-002,-9.7045898e-003,-6.6223145e-003,-2.0751953e-003,2.6245117e-003,4.5166016e-003,4.6386719e-003,1.1291504e-003,-3.0822754e-003,-8.0566406e-003,-1.3244629e-002,-1.5625000e-002,-1.7333984e-002,-1.5838623e-002,-1.2603760e-002,-9.1857910e-003,-4.6691895e-003,-2.0446777e-003,2.8076172e-003,8.0871582e-003,1.2695313e-002,1.6693115e-002,1.6845703e-002,1.4007568e-002,9.3078613e-003,4.2724609e-003,-1.0681152e-003,-4.5776367e-003,-8.3618164e-003,-1.2725830e-002,-1.4770508e-002,-1.6113281e-002,-1.5655518e-002,-1.4648438e-002,-1.5228271e-002,-1.7913818e-002,-1.9378662e-002,-1.6998291e-002,-1.2084961e-002,-3.2043457e-003,1.2207031e-003,1.3122559e-003,-9.4604492e-004,-8.7890625e-003,-1.1627197e-002,-9.0637207e-003,-6.0119629e-003,2.4414063e-004,3.1738281e-003,1.2512207e-003,1.9531250e-003,1.3122559e-003,2.6245117e-003,7.1411133e-003,8.8806152e-003,1.0650635e-002,1.0009766e-002,7.2631836e-003,4.6081543e-003,1.7395020e-003,-1.4953613e-003,-4.7912598e-003,-8.2702637e-003,-1.2359619e-002,-1.5289307e-002,-1.8188477e-002,-1.9073486e-002,-1.8341064e-002,-1.6571045e-002,-1.3671875e-002,-1.1322021e-002,-1.0650635e-002,-9.1247559e-003,-6.1340332e-003,-2.0141602e-003,6.4697266e-003,1.1596680e-002,1.3732910e-002,1.2298584e-002,3.7841797e-003,-1.0681152e-003,-2.4719238e-003,-1.6479492e-003,5.1269531e-003,9.0026855e-003,9.1552734e-003,9.8266602e-003,5.4321289e-003,3.3569336e-003,2.7770996e-003,-1.7089844e-003,-4.6997070e-003,-1.1718750e-002,-1.8280029e-002,-2.1820068e-002,-2.1759033e-002,-1.6876221e-002,-1.0498047e-002,-4.8522949e-003,-4.4250488e-003,-4.7302246e-003,-9.3688965e-003,-1.2023926e-002,-1.1291504e-002,-1.1077881e-002,-6.4392090e-003,-4.6081543e-003,-3.3874512e-003,-4.8828125e-004,5.1879883e-004,4.4555664e-003,9.6435547e-003,1.2420654e-002,1.2268066e-002,8.6364746e-003,1.0375977e-003,-4.5166016e-003,-6.5307617e-003,-7.9040527e-003,-5.4321289e-003,-4.4250488e-003,-6.5307617e-003,-5.9509277e-003,-7.2021484e-003,-6.8969727e-003,-4.5776367e-003,-6.8359375e-003,-1.0345459e-002,-1.4160156e-002,-1.7547607e-002,-1.8341064e-002,-1.5014648e-002,-1.3793945e-002,-1.2878418e-002,-1.1260986e-002,-1.2481689e-002,-9.0942383e-003,-3.8452148e-003,-3.0517578e-004,3.5095215e-003,4.8217773e-003,3.2653809e-003,3.9978027e-003,6.3781738e-003,6.5307617e-003,6.3781738e-003,3.2043457e-003,-5.1574707e-003,-1.1535645e-002,-1.6754150e-002,-2.1301270e-002,-1.8615723e-002,-1.5319824e-002,-1.1352539e-002,-4.3640137e-003,-1.5258789e-004,3.4790039e-003,4.9438477e-003,4.5471191e-003,3.5400391e-003,3.0517578e-004,-3.8452148e-003,-1.0925293e-002,-1.8218994e-002,-2.2644043e-002,-2.2064209e-002,-1.6326904e-002,-7.2326660e-003,-5.4931641e-004,-4.8828125e-004,6.1035156e-005,-3.2348633e-003,-2.1667480e-003,6.9580078e-003,1.1932373e-002,1.8646240e-002,1.7944336e-002,8.9416504e-003,3.4179688e-003,-2.5024414e-003,-5.4931641e-003,-2.9907227e-003,-2.7465820e-003,-4.0588379e-003,-3.6315918e-003,-6.8664551e-003,-7.8430176e-003,-7.8125000e-003,-7.6599121e-003,-4.4860840e-003,-5.1879883e-004,6.0729980e-003,9.5825195e-003,1.0040283e-002,7.0495605e-003,-5.4931641e-004,-6.0119629e-003,-8.4533691e-003,-9.1552734e-003,-5.5847168e-003,-2.8076172e-003,-1.1596680e-003,2.9907227e-003,4.9438477e-003,8.7280273e-003,1.1566162e-002,1.1749268e-002,1.0803223e-002,6.8054199e-003,3.3264160e-003,-9.7656250e-004,-3.6926270e-003,-5.6152344e-003,-5.3405762e-003,-2.5634766e-003,6.4086914e-004,5.4626465e-003,7.4768066e-003,8.5449219e-003,6.6528320e-003,4.8522949e-003,3.8757324e-003,2.5024414e-003,3.8146973e-003,2.7465820e-003,1.2817383e-003,-3.0517578e-004,-2.6550293e-003,-2.8381348e-003,-1.7089844e-003,1.1291504e-003,4.5776367e-003,7.4157715e-003,8.8806152e-003,1.0406494e-002,1.1444092e-002,1.3397217e-002,1.6479492e-002,1.5777588e-002,1.1322021e-002,4.6081543e-003,-5.8288574e-003,-1.2390137e-002,-1.2329102e-002,-1.0040283e-002,-2.7770996e-003,3.4484863e-003,3.9367676e-003,7.5073242e-003,7.7209473e-003,8.5144043e-003,1.1657715e-002,8.7280273e-003,5.9814453e-003,1.6479492e-003,-2.2277832e-003,-2.9296875e-003,6.1035156e-005,4.1809082e-003,9.0026855e-003,1.4282227e-002,1.4526367e-002,1.4831543e-002,9.6130371e-003,4.8217773e-003,2.9907227e-003,1.7089844e-003,8.2702637e-003,1.2390137e-002,1.5899658e-002,1.6448975e-002,9.0942383e-003,7.1411133e-003,5.0964355e-003,1.3427734e-003,4.2724609e-004,-6.7138672e-003,-1.5533447e-002,-1.7608643e-002,-1.1840820e-002,-2.1362305e-004,1.5594482e-002,2.0385742e-002,8.8195801e-003,-3.6926270e-003,-2.0385742e-002,-2.4230957e-002,-6.3171387e-003,6.7443848e-003,2.2583008e-002,2.8778076e-002,1.3183594e-002,4.5471191e-003,-6.8054199e-003,-1.3153076e-002,-3.5705566e-003,3.9672852e-004,7.1105957e-003,1.1535645e-002,6.1035156e-003,3.3874512e-003,-1.9531250e-003,-5.9814453e-003,-3.8146973e-003,-2.4108887e-003,2.1362305e-003,5.3405762e-003,4.5776367e-003,3.4790039e-003,-1.4953613e-003,-5.1879883e-003,-5.7678223e-003,-5.4321289e-003,-1.4343262e-003,2.1972656e-003,5.0659180e-003,7.2021484e-003,6.6223145e-003,5.1574707e-003,2.1972656e-003,3.0517578e-005,-1.6174316e-003,-1.6784668e-003,5.7983398e-004,1.7089844e-003,2.9907227e-003,4.3029785e-003,3.9978027e-003,4.9438477e-003,4.7607422e-003,5.2795410e-003,5.5847168e-003,6.7138672e-003,8.6364746e-003,8.5449219e-003,6.5917969e-003,9.7656250e-004,-7.2937012e-003,-1.4312744e-002,-1.8585205e-002,-1.8859863e-002,-1.2878418e-002,-4.4860840e-003,5.4931641e-003,1.5472412e-002,1.8981934e-002,1.8493652e-002,9.9487305e-003,-1.3427734e-003,-1.1657715e-002,-1.9073486e-002,-1.4556885e-002,-9.2468262e-003,6.1035156e-004,7.9345703e-003,4.3640137e-003,3.7841797e-003,-3.4179688e-003,-6.0424805e-003,-2.4414063e-004,2.6245117e-003,1.2512207e-002,1.8737793e-002,1.9042969e-002,2.0233154e-002,1.5594482e-002,1.0742188e-002,6.5917969e-003,1.9836426e-003,2.1057129e-003,4.6691895e-003,9.2773438e-003,1.5472412e-002,1.6967773e-002,1.5991211e-002,7.3242188e-003,-2.6550293e-003,-9.7656250e-003,-1.5991211e-002,-1.1688232e-002,-7.7514648e-003,-3.0517578e-005,6.2866211e-003,3.2958984e-003,1.2817383e-003,-6.6223145e-003,-1.2481689e-002,-1.1291504e-002,-9.5214844e-003,-5.1879883e-004,7.6293945e-003,1.2298584e-002,1.5502930e-002,1.0498047e-002,6.4392090e-003,2.9602051e-003,8.5449219e-004,5.7678223e-003,7.3547363e-003,1.0040283e-002,1.2115479e-002,9.4909668e-003,1.0406494e-002,1.1840820e-002,1.3458252e-002,1.5441895e-002,1.4648438e-002,9.2773438e-003,5.6152344e-003,3.1433105e-003,1.4038086e-003,3.1127930e-003,2.1362305e-004,-6.1645508e-003,-1.0253906e-002,-1.4984131e-002,-1.3031006e-002,-3.9978027e-003,7.0190430e-004,2.7160645e-003,-9.1552734e-005,-1.0437012e-002,-1.5533447e-002,-1.5411377e-002,-1.4190674e-002,-6.4697266e-003,-1.9226074e-003,-5.1879883e-004,3.0212402e-003,3.3264160e-003,6.4697266e-003,9.7351074e-003,1.0375977e-002,9.6740723e-003,8.7585449e-003,8.7585449e-003,7.3852539e-003,6.5307617e-003,2.8381348e-003,-2.5939941e-003,-4.8217773e-003,-4.6081543e-003,-1.0375977e-003,6.7749023e-003,1.0406494e-002,9.6130371e-003,8.2397461e-003,3.8146973e-003,3.7231445e-003,8.5754395e-003,7.9650879e-003,4.5166016e-003,-3.4179688e-003,-1.7608643e-002,-2.3864746e-002,-2.1331787e-002,-1.4404297e-002,5.4931641e-004,1.0498047e-002,1.0314941e-002,1.1627197e-002,6.5307617e-003,4.3945313e-003,9.7351074e-003,6.8969727e-003,5.2185059e-003,9.1552734e-005,-9.3078613e-003,-9.9792480e-003,-3.9367676e-003,5.4931641e-003,1.7944336e-002,2.5207520e-002,2.1118164e-002,1.8127441e-002,1.0711670e-002,6.1340332e-003,1.1169434e-002,9.8876953e-003,1.2176514e-002,1.1169434e-002,3.9062500e-003,2.1667480e-003,5.4931641e-004,1.7700195e-003,7.2021484e-003,9.0026855e-003,8.7280273e-003,9.0332031e-003,6.2255859e-003,8.0871582e-003,1.1566162e-002,1.1413574e-002,1.0650635e-002,5.4931641e-003,-2.9296875e-003,-9.6130371e-003,-1.3916016e-002,-1.4312744e-002,-9.2163086e-003,-2.6855469e-003,3.1433105e-003,8.3007813e-003,7.6904297e-003,6.9274902e-003,5.9814453e-003,5.9814453e-003,1.1230469e-002,1.2725830e-002,1.3885498e-002,1.1596680e-002,4.2419434e-003,1.7395020e-003,1.8920898e-003,5.2490234e-003,1.1718750e-002,1.3519287e-002,9.0026855e-003,5.3100586e-003,2.4414063e-004,1.5258789e-004,8.9111328e-003,1.2786865e-002,1.4648438e-002,1.2115479e-002,9.7656250e-004,-4.4555664e-003,-4.5166016e-003,-3.6621094e-003,3.8757324e-003,6.5612793e-003,1.3427734e-003,-2.5329590e-003,-1.1505127e-002,-1.5563965e-002,-1.1901855e-002,-9.7961426e-003,-2.6550293e-003,3.2043457e-003,4.6081543e-003,8.6364746e-003,9.8571777e-003,1.0650635e-002,1.0040283e-002,3.9367676e-003,-4.2114258e-003,-1.2878418e-002,-1.7364502e-002,-1.5411377e-002,-4.3945313e-003,6.9885254e-003,1.4068604e-002,1.7669678e-002,1.0131836e-002,4.4860840e-003,4.2724609e-004,-3.9978027e-003,2.7465820e-004,-1.2512207e-003,-3.1738281e-003,-3.9672852e-003,-8.2702637e-003,-7.4768066e-003,-4.7912598e-003,-4.3640137e-003,-4.7302246e-003,-6.2255859e-003,-1.0223389e-002,-1.1505127e-002,-9.2468262e-003,-8.6059570e-003,-5.5847168e-003,-4.6691895e-003,-5.8288574e-003,-6.4697266e-003,-9.7351074e-003,-1.2268066e-002,-1.3763428e-002,-1.4465332e-002,-1.1291504e-002,-7.6599121e-003,-3.2348633e-003,8.2397461e-004,1.1596680e-003,1.8310547e-003,2.4414063e-004,-1.6784668e-003,-2.2277832e-003,-4.2114258e-003,-3.5400391e-003,-2.7465820e-004,5.9814453e-003,1.3000488e-002,1.7333984e-002,1.8493652e-002,1.2023926e-002,4.7302246e-003,-3.8452148e-003,-1.2084961e-002,-1.4373779e-002,-1.5441895e-002,-1.2145996e-002,-5.0354004e-003,2.3498535e-003,1.0253906e-002,1.5625000e-002,1.6876221e-002,1.2603760e-002,5.5541992e-003,-1.2817383e-003,-1.0253906e-002,-1.5014648e-002,-1.9897461e-002,-2.1179199e-002,-1.8035889e-002,-1.3366699e-002,-5.7678223e-003,-2.5329590e-003,1.6174316e-003,8.5449219e-004,1.2207031e-003,5.2490234e-003,6.2866211e-003,1.0620117e-002,1.0528564e-002,7.8125000e-003,5.9814453e-003,2.7770996e-003,-6.4086914e-004,-4.2114258e-003,-8.2397461e-003,-1.3732910e-002,-1.4617920e-002,-1.2847900e-002,-9.0942383e-003,-2.8686523e-003,2.7465820e-003,6.3781738e-003,8.6059570e-003,8.2397461e-003,3.8452148e-003,-1.5869141e-003,-7.2631836e-003,-1.0009766e-002,-1.1322021e-002,-9.5214844e-003,-9.7045898e-003,-1.3427734e-002,-1.2847900e-002,-1.3092041e-002,-6.5002441e-003,4.7607422e-003,9.7961426e-003,9.7961426e-003,3.4179688e-003,-9.8571777e-003,-1.7883301e-002,-1.6662598e-002,-1.5014648e-002,-5.6762695e-003,1.4648438e-003,3.6621094e-004,2.5329590e-003,-6.7138672e-004,-3.3569336e-003,-3.4790039e-003,-4.1503906e-003,-8.5449219e-004,9.4604492e-004,1.8920898e-003,-1.7700195e-003,-9.0332031e-003,-1.3031006e-002,-1.2390137e-002,-6.0424805e-003,5.7983398e-003,1.0894775e-002,5.9509277e-003,1.3732910e-003,-8.3007813e-003,-1.0528564e-002,-2.3498535e-003,-5.7983398e-004,1.8005371e-003,1.4038086e-003,-6.3171387e-003,-6.9580078e-003,-5.0354004e-003,-7.5683594e-003,-8.6364746e-003,-1.2207031e-002,-1.7486572e-002,-1.5350342e-002,-8.3618164e-003,-3.8757324e-003,-4.2724609e-004,1.5258789e-004,-4.4250488e-003,-4.9743652e-003,-4.8828125e-003,-8.7890625e-003,-1.3000488e-002,-1.7181396e-002,-1.9348145e-002,-1.5197754e-002,-5.4321289e-003,-1.0681152e-003,-3.3874512e-003,-4.9743652e-003,-9.1552734e-003,-6.3476563e-003,3.6010742e-003,3.0212402e-003,-2.9907227e-003,-1.2176514e-002,-2.3986816e-002,-2.4993896e-002,-1.1749268e-002,-3.0517578e-003,3.0517578e-003,5.5541992e-003,-3.2653809e-003,-1.9226074e-003,4.2724609e-003,4.4555664e-003,6.0729980e-003,8.2397461e-004,-9.0026855e-003,-1.1199951e-002,-8.0566406e-003,-7.4768066e-003,-6.7749023e-003,-7.5683594e-003,-1.1627197e-002,-8.8500977e-003,-2.5939941e-003,6.7138672e-004,4.0283203e-003,6.7443848e-003,8.2702637e-003,1.2847900e-002,1.8066406e-002,1.1840820e-002,-4.1809082e-003,-1.6845703e-002,-2.4475098e-002,-1.9805908e-002,1.2512207e-003,9.5825195e-003,4.6081543e-003,5.7983398e-004,-1.3641357e-002,-1.0528564e-002,9.7656250e-003,1.3122559e-002,1.0528564e-002,-1.3427734e-003,-2.3895264e-002,-2.5299072e-002,-7.9345703e-003,-2.3498535e-003,-3.2043457e-003,-1.4892578e-002,-4.3182373e-002,-4.0924072e-002,-1.1627197e-002,1.3916016e-002,4.2999268e-002,4.3792725e-002,5.2490234e-003,-1.7486572e-002,-3.2287598e-002,-3.9855957e-002,-1.4953613e-002,-1.2084961e-002,-1.7639160e-002,-1.0711670e-002,-1.3275146e-002,-6.1035156e-004,1.8096924e-002,2.0812988e-002,1.2298584e-002,2.3193359e-003,-9.1552734e-003,-1.5502930e-002,-9.5825195e-003,-1.3305664e-002,-1.8341064e-002,-1.6784668e-002,-1.5167236e-002,-4.8828125e-003,6.9580078e-003,9.2773438e-003,4.5776367e-004,-5.4321289e-003,-9.5825195e-003,-8.6975098e-003,3.6926270e-003,5.4321289e-003,2.0141602e-003,1.8005371e-003,-1.5563965e-003,2.1362305e-003,8.4838867e-003,2.7160645e-003,-1.3732910e-002,-2.9785156e-002,-4.3670654e-002,-4.2419434e-002,-1.9165039e-002,1.1291504e-003,1.9561768e-002,3.1036377e-002,1.9317627e-002,9.4909668e-003,-4.4250488e-003,-2.3345947e-002,-2.9937744e-002,-3.9428711e-002,-3.8146973e-002,-2.7496338e-002,-1.2451172e-002,7.9956055e-003,1.9653320e-002,3.0120850e-002,2.6000977e-002,1.7883301e-002,4.7607422e-003,-1.5960693e-002,-3.1890869e-002,-4.9102783e-002,-5.1635742e-002,-4.5166016e-002,-2.6611328e-002,-1.8310547e-004,2.0843506e-002,4.0466309e-002,3.9916992e-002,3.2348633e-002,1.4038086e-002,-1.2115479e-002,-2.7709961e-002,-4.4677734e-002,-4.2816162e-002,-3.4545898e-002,-1.9836426e-002,3.7231445e-003,1.7425537e-002,3.2684326e-002,3.1250000e-002,2.1820068e-002,4.4860840e-003,-1.9226074e-002,-3.1402588e-002,-4.0374756e-002,-2.7038574e-002,-1.0467529e-002,8.7585449e-003,2.6397705e-002,2.1575928e-002,1.8737793e-002,1.9836426e-003,-1.2878418e-002,-1.6723633e-002,-2.6763916e-002,-2.3773193e-002,-2.1331787e-002,-1.6082764e-002,-2.1362305e-003,9.8266602e-003,2.1942139e-002,2.3406982e-002,1.7089844e-002,1.4343262e-003,-1.4587402e-002,-2.0935059e-002,-2.5848389e-002,-1.6479492e-002,-9.0637207e-003,-4.9743652e-003,2.8686523e-003,1.8615723e-003,7.5073242e-003,1.3519287e-002,1.5777588e-002,1.8157959e-002,1.1749268e-002,1.9531250e-003,-8.5144043e-003,-1.6387939e-002,-2.0477295e-002,-1.4984131e-002,-6.8969727e-003,2.3498535e-003,1.1566162e-002,9.7351074e-003,6.6528320e-003,-4.4250488e-003,-1.5625000e-002,-1.9165039e-002,-2.2827148e-002,-1.3916016e-002,-6.0119629e-003,1.2817383e-003,1.0406494e-002,1.0467529e-002,1.0620117e-002,4.3945313e-003,-5.1879883e-003,-1.5167236e-002,-2.6367188e-002,-3.1280518e-002,-3.2379150e-002,-2.4627686e-002,-1.4038086e-002,-3.7231445e-003,6.7138672e-003,7.8735352e-003,8.3312988e-003,4.2419434e-003,-1.9836426e-003,-4.3640137e-003,-1.1993408e-002,-1.6082764e-002,-2.1331787e-002,-2.5115967e-002,-2.2277832e-002,-1.6510010e-002,-6.5307617e-003,1.3122559e-003,6.7749023e-003,3.8452148e-003,-5.1879883e-004,-5.4016113e-003,-1.0864258e-002,-7.4462891e-003,-7.5988770e-003,-4.7302246e-003,-3.7536621e-003,-8.1176758e-003,-1.0253906e-002,-1.4404297e-002,-1.6815186e-002,-1.5808105e-002,-1.2695313e-002,-9.3383789e-003,-5.4931641e-003,-4.3640137e-003,-4.8522949e-003,-7.9345703e-003,-1.0986328e-002,-1.1260986e-002,-1.2390137e-002,-1.1474609e-002,-1.3885498e-002,-1.8341064e-002,-1.9866943e-002,-1.9622803e-002,-1.5136719e-002,-7.1105957e-003,-3.5400391e-003,-5.1269531e-003,-6.1950684e-003,-9.2163086e-003,-7.4768066e-003,1.4953613e-003,4.9743652e-003,5.2490234e-003,9.7656250e-004,-1.3061523e-002,-2.1240234e-002,-2.4719238e-002,-2.6092529e-002,-1.8676758e-002,-1.3519287e-002,-9.8571777e-003,-2.7160645e-003,5.1879883e-004,4.5776367e-003,5.4626465e-003,-2.1362305e-004,-9.2468262e-003,-1.9897461e-002,-2.6367188e-002,-2.9357910e-002,-2.3010254e-002,-1.2115479e-002,1.1291504e-003,1.7303467e-002,2.5054932e-002,2.8472900e-002,1.9287109e-002,3.4179688e-003,-1.3153076e-002,-3.0517578e-002,-3.4179688e-002,-3.6468506e-002,-3.1066895e-002,-2.3895264e-002,-2.1881104e-002,-1.3946533e-002,-1.0009766e-002,-2.5329590e-003,4.0588379e-003,5.2490234e-003,4.0893555e-003,-2.3803711e-003,-1.0009766e-002,-1.9195557e-002,-2.4597168e-002,-2.9357910e-002,-3.0151367e-002,-2.7038574e-002,-2.5146484e-002,-1.9500732e-002,-1.7761230e-002,-1.4282227e-002,-1.0955811e-002,-6.8664551e-003,3.0517578e-004,3.9978027e-003,7.1411133e-003,4.4860840e-003,-1.2817383e-003,-7.5683594e-003,-1.2054443e-002,-1.5319824e-002,-1.7272949e-002,-1.9866943e-002,-2.5756836e-002,-2.6672363e-002,-2.5299072e-002,-1.6357422e-002,-1.8310547e-004,1.3610840e-002,2.3040771e-002,2.2491455e-002,9.4909668e-003,-5.7983398e-003,-1.9775391e-002,-3.1768799e-002,-2.9632568e-002,-2.8961182e-002,-2.4505615e-002,-1.6235352e-002,-1.5747070e-002,-4.9438477e-003,2.9296875e-003,9.0637207e-003,1.3610840e-002,8.6059570e-003,5.7983398e-004,-8.8195801e-003,-1.4617920e-002,-2.0660400e-002,-2.0568848e-002,-2.3284912e-002,-2.8228760e-002,-2.5634766e-002,-2.4108887e-002,-1.5136719e-002,-3.0517578e-003,5.2185059e-003,6.6223145e-003,3.2958984e-003,-5.9204102e-003,-1.3397217e-002,-1.3000488e-002,-1.5563965e-002,-1.3000488e-002,-1.4007568e-002,-2.0935059e-002,-1.9927979e-002,-1.6998291e-002,-7.3242188e-003,6.7138672e-003,1.4739990e-002,1.5014648e-002,1.2451172e-002,4.3029785e-003,-2.1667480e-003,-2.4108887e-003,-1.0040283e-002,-1.7761230e-002,-2.7343750e-002,-3.7353516e-002,-3.4240723e-002,-2.0690918e-002,-3.6010742e-003,1.1535645e-002,1.8920898e-002,9.7656250e-003,1.4648438e-003,-7.5988770e-003,-1.8646240e-002,-1.8615723e-002,-2.7648926e-002,-3.6621094e-002,-3.8726807e-002,-3.7902832e-002,-2.6489258e-002,-1.0864258e-002,1.3732910e-003,5.4321289e-003,9.1247559e-003,8.5754395e-003,9.5825195e-003,1.5930176e-002,1.0986328e-002,4.1503906e-003,-6.9274902e-003,-2.0019531e-002,-2.5146484e-002,-2.3651123e-002,-2.0660400e-002,-1.6387939e-002,-9.2773438e-003,-6.2255859e-003,2.5329590e-003,1.1566162e-002,1.4739990e-002,1.2451172e-002,1.0681152e-003,-1.5350342e-002,-3.1738281e-002,-3.9764404e-002,-4.3609619e-002,-3.5644531e-002,-2.2949219e-002,-1.0498047e-002,5.5236816e-003,9.1552734e-003,1.0223389e-002,1.1596680e-003,-9.3994141e-003,-1.2390137e-002,-1.7364502e-002,-1.1077881e-002,-1.0620117e-002,-1.3732910e-002,-1.3336182e-002,-1.7272949e-002,-1.3732910e-002,-6.4392090e-003,-2.4108887e-003,-1.5563965e-003,-2.9296875e-003,-8.9721680e-003,-1.3061523e-002,-1.3214111e-002,-1.7211914e-002,-1.8981934e-002,-1.9866943e-002,-1.9958496e-002,-1.3824463e-002,-5.1269531e-003,9.4604492e-004,1.9226074e-003,-9.1552734e-004,-1.1016846e-002,-1.9165039e-002,-2.1270752e-002,-2.0446777e-002,-8.6975098e-003,3.7231445e-003,1.5045166e-002,2.1972656e-002,1.4526367e-002,2.9296875e-003,-1.5594482e-002,-2.9174805e-002,-2.5146484e-002,-2.0141602e-002,-3.8452148e-003,8.0871582e-003,7.2937012e-003,1.0864258e-002,6.0119629e-003,3.3569336e-003,5.3100586e-003,-1.7700195e-003,-9.1247559e-003,-1.7181396e-002,-2.3040771e-002,-2.3559570e-002,-1.7608643e-002,-1.3488770e-002,-1.2695313e-002,-8.0566406e-003,-6.8359375e-003,-7.3242188e-004,8.0871582e-003,9.7351074e-003,8.2397461e-003,1.6174316e-003,-8.4228516e-003,-1.7272949e-002,-2.1301270e-002,-2.6092529e-002,-2.7099609e-002,-2.3193359e-002,-1.6113281e-002,-4.1198730e-003,6.8054199e-003,1.2084961e-002,6.2255859e-003,-3.1127930e-003,-1.5075684e-002,-2.5390625e-002,-2.3010254e-002,-2.2857666e-002,-1.7059326e-002,-9.7656250e-003,-8.5144043e-003,-1.8920898e-003,-8.8500977e-004,-1.0375977e-003,-4.3640137e-003,-1.0833740e-002,-1.4373779e-002,-1.7456055e-002,-1.3763428e-002,-1.0375977e-002,-5.7983398e-003,-3.9672852e-004,3.6621094e-004,1.6784668e-003,-2.1667480e-003,-8.4228516e-003,-1.3061523e-002,-1.6876221e-002,-1.3793945e-002,-9.6130371e-003,-4.3640137e-003,-1.7089844e-003,-6.0119629e-003,-7.6904297e-003,-1.1291504e-002,-1.3580322e-002,-1.1352539e-002,-1.2390137e-002,-1.2603760e-002,-1.2451172e-002,-1.2878418e-002,-1.2542725e-002,-1.2390137e-002,-1.3305664e-002,-1.4343262e-002,-1.3092041e-002,-8.7890625e-003,-3.7536621e-003,2.7465820e-004,-3.0517578e-004,-7.2326660e-003,-1.2176514e-002,-1.5380859e-002,-1.6296387e-002,-1.1444092e-002,-9.2163086e-003,-8.5144043e-003,-5.4016113e-003,-3.3569336e-003,2.0141602e-003,7.6293945e-003,7.9956055e-003,2.9907227e-003,-4.4250488e-003,-1.1749268e-002,-1.6021729e-002,-1.1535645e-002,-7.3547363e-003,-2.3498535e-003,1.2817383e-003,-3.8452148e-003,-8.2397461e-003,-1.7944336e-002,-2.6550293e-002,-2.7648926e-002,-2.7191162e-002,-1.6906738e-002,-6.8969727e-003,1.5563965e-003,7.0190430e-003,3.2958984e-003,-1.2207031e-003,-9.2773438e-003,-1.7913818e-002,-2.0355225e-002,-2.3406982e-002,-2.1331787e-002,-1.6571045e-002,-1.2237549e-002,-4.4860840e-003,-8.5449219e-004,2.2888184e-003,1.6174316e-003,-1.0375977e-003,-2.8991699e-003,-5.0964355e-003,-3.6315918e-003,-4.4860840e-003,-5.5541992e-003,-9.1857910e-003,-1.6784668e-002,-2.0935059e-002,-2.4200439e-002,-2.1911621e-002,-1.4465332e-002,-7.5683594e-003,-2.4719238e-003,-6.7138672e-004,-5.4931641e-003,-9.2468262e-003,-1.1627197e-002,-1.5167236e-002,-1.3092041e-002,-1.3580322e-002,-1.3214111e-002,-9.2468262e-003,-5.6762695e-003,-1.9836426e-003,-2.3193359e-003,-7.2937012e-003,-1.8615723e-002,-2.5848389e-002,-2.5360107e-002,-2.0568848e-002,-3.7231445e-003,7.5988770e-003,1.1596680e-002,1.4099121e-002,4.4250488e-003,-2.5024414e-003,-6.2866211e-003,-1.1718750e-002,-8.3618164e-003,-5.8288574e-003,-1.9531250e-003,3.3569336e-003,2.4108887e-003,1.9531250e-003,-2.1972656e-003,-3.0822754e-003,1.1596680e-003,4.7912598e-003,1.2908936e-002,1.4007568e-002,7.0800781e-003,-6.4086914e-004,-1.2084961e-002,-1.9683838e-002,-1.8585205e-002,-1.7333984e-002,-1.0742188e-002,-2.5634766e-003,2.1057129e-003,9.0942383e-003,1.0223389e-002,9.2163086e-003,4.8522949e-003,-1.0986328e-003,-3.6926270e-003,-9.0026855e-003,-1.1535645e-002,-1.4099121e-002,-1.5258789e-002,-8.3618164e-003,2.8686523e-003,1.1840820e-002,1.3488770e-002,7.6599121e-003,-7.8735352e-003,-1.4587402e-002,-7.6599121e-003,-1.2207031e-003,1.0559082e-002,2.6855469e-003,-2.8564453e-002,-4.9865723e-002,-6.1584473e-002,-4.6478271e-002,6.9580078e-003,4.9011230e-002,7.1990967e-002,7.4829102e-002,3.0120850e-002,-4.6386719e-003,-2.5024414e-002,-4.4647217e-002,-2.5970459e-002,-2.2064209e-002,-2.3437500e-002,-1.3275146e-002,-1.9836426e-002,-9.8266602e-003,-4.5776367e-004,2.8991699e-003,5.7067871e-003,3.0517578e-005,-4.7607422e-003,-6.8359375e-003,1.8310547e-003,6.9885254e-003,1.2115479e-002,1.0559082e-002,-6.0729980e-003,-2.1392822e-002,-4.1107178e-002,-5.1055908e-002,-4.2602539e-002,-2.6672363e-002,2.1667480e-003,2.7099609e-002,3.6132813e-002,4.0222168e-002,2.5970459e-002,1.0894775e-002,2.5634766e-003,-1.5258789e-002,-2.2430420e-002,-3.4301758e-002,-4.3670654e-002,-3.5888672e-002,-2.0233154e-002,5.5236816e-003,2.5939941e-002,3.5400391e-002,2.1545410e-002,5.5236816e-003,-1.0101318e-002,-2.4200439e-002,-1.5167236e-002,-1.7120361e-002,-1.4831543e-002,-6.8969727e-003,-4.3640137e-003,1.3702393e-002,3.1555176e-002,3.8543701e-002,2.9449463e-002,1.0070801e-002,-1.8371582e-002,-3.6315918e-002,-3.1524658e-002,-2.7252197e-002,-9.6435547e-003,3.7536621e-003,3.0517578e-003,1.3610840e-002,1.5838623e-002,1.7211914e-002,1.8066406e-002,5.7067871e-003,-7.2021484e-003,-1.7578125e-002,-1.6265869e-002,-1.1779785e-002,-2.0751953e-003,5.3405762e-003,2.8686523e-003,8.5754395e-003,1.0589600e-002,1.2969971e-002,1.4648438e-002,5.2490234e-003,-8.8806152e-003,-1.7913818e-002,-1.6326904e-002,-9.1552734e-003,9.3383789e-003,2.0324707e-002,2.0233154e-002,2.3651123e-002,1.7639160e-002,1.4038086e-002,1.3977051e-002,3.5095215e-003,-6.8359375e-003,-1.4831543e-002,-1.6540527e-002,-8.4838867e-003,8.5144043e-003,2.2796631e-002,2.8137207e-002,3.3447266e-002,2.7526855e-002,2.1179199e-002,1.4739990e-002,-3.9978027e-003,-2.1209717e-002,-3.5858154e-002,-3.9306641e-002,-2.7801514e-002,-1.7089844e-003,2.1972656e-002,3.1341553e-002,3.6163330e-002,2.0080566e-002,7.9040527e-003,3.4179688e-003,-8.7585449e-003,-8.4533691e-003,-1.3427734e-002,-1.6174316e-002,-8.4533691e-003,-9.1552734e-005,1.1749268e-002,1.5686035e-002,1.6845703e-002,6.5307617e-003,-3.3569336e-004,1.4648438e-003,-7.3242188e-004,6.8664551e-003,7.4157715e-003,4.3334961e-003,6.7138672e-003,6.9885254e-003,1.1138916e-002,1.6143799e-002,1.5014648e-002,7.6293945e-003,5.4931641e-004,-6.8664551e-003,-9.0942383e-003,-1.4648438e-003,4.2114258e-003,8.9111328e-003,1.0437012e-002,3.5705566e-003,-1.1901855e-003,-5.3405762e-003,-8.0871582e-003,-2.6855469e-003,2.6855469e-003,9.2163086e-003,1.4495850e-002,1.4068604e-002,1.2725830e-002,8.3923340e-003,5.0048828e-003,4.3945313e-003,3.2958984e-003,3.1127930e-003,6.7138672e-004,-2.9602051e-003,-3.2958984e-003,-1.2207031e-003,4.5471191e-003,1.2451172e-002,1.7425537e-002,1.7242432e-002,1.4465332e-002,7.5988770e-003,1.5258789e-003,8.8500977e-004,-3.3569336e-004,3.6621094e-003,8.5144043e-003,1.1627197e-002,1.7028809e-002,1.6662598e-002,1.4190674e-002,7.3242188e-003,-6.1035156e-005,-3.2958984e-003,-3.6926270e-003,4.4860840e-003,1.0467529e-002,1.6601563e-002,2.1545410e-002,1.8829346e-002,1.7333984e-002,1.3793945e-002,6.1340332e-003,-3.3569336e-004,-7.8430176e-003,-9.4604492e-003,-4.0588379e-003,7.8735352e-003,1.9500732e-002,2.4871826e-002,2.6641846e-002,1.6326904e-002,8.5754395e-003,3.5400391e-003,-4.2724609e-003,-1.7395020e-003,-2.5329590e-003,-1.5258789e-003,5.0354004e-003,9.0026855e-003,1.3336182e-002,1.0620117e-002,5.2185059e-003,-2.7465820e-003,-4.6386719e-003,6.3476563e-003,1.5625000e-002,2.8411865e-002,3.2745361e-002,2.1820068e-002,1.5411377e-002,8.0871582e-003,4.5776367e-003,1.1718750e-002,1.1840820e-002,1.0559082e-002,1.2817383e-002,1.1657715e-002,1.6357422e-002,2.1301270e-002,1.9653320e-002,1.2664795e-002,5.7983398e-003,1.0986328e-003,-4.8828125e-004,5.9509277e-003,6.8054199e-003,3.9978027e-003,3.1738281e-003,0.0000000e+000,3.2043457e-003,1.3580322e-002,2.1759033e-002,2.6275635e-002,2.8259277e-002,2.2613525e-002,1.8341064e-002,1.5441895e-002,7.5378418e-003,2.2583008e-003,-1.4343262e-003,-1.3122559e-003,6.5002441e-003,1.8646240e-002,2.8228760e-002,3.0181885e-002,2.9205322e-002,2.2064209e-002,1.8127441e-002,2.1514893e-002,2.0141602e-002,2.1697998e-002,1.9622803e-002,1.3275146e-002,1.2847900e-002,1.4312744e-002,1.6845703e-002,2.0294189e-002,2.2033691e-002,1.9500732e-002,1.9958496e-002,2.2186279e-002,2.3162842e-002,2.7465820e-002,2.7282715e-002,2.4871826e-002,2.3651123e-002,2.1545410e-002,1.8646240e-002,1.5258789e-002,9.8876953e-003,3.6315918e-003,1.7395020e-003,4.5471191e-003,1.0894775e-002,2.0355225e-002,2.7404785e-002,2.7923584e-002,2.6214600e-002,1.9866943e-002,1.3214111e-002,1.1230469e-002,9.4909668e-003,1.5136719e-002,2.2644043e-002,2.9968262e-002,3.6468506e-002,3.4851074e-002,3.0792236e-002,2.1850586e-002,1.2786865e-002,5.8288574e-003,-2.4108887e-003,-5.4016113e-003,-5.3710938e-003,-1.5258789e-003,8.3312988e-003,1.9470215e-002,2.9602051e-002,3.1951904e-002,3.1372070e-002,2.4841309e-002,1.7456055e-002,1.6052246e-002,9.4909668e-003,7.1105957e-003,1.8920898e-003,-5.3100586e-003,-3.4484863e-003,3.5705566e-003,1.6082764e-002,3.0487061e-002,3.9031982e-002,3.4210205e-002,2.5482178e-002,1.1199951e-002,-3.2348633e-003,-6.9274902e-003,-1.1718750e-002,-6.9274902e-003,4.9133301e-003,1.8676758e-002,3.6895752e-002,4.5288086e-002,4.5288086e-002,2.8778076e-002,1.1779785e-002,1.4648438e-003,-1.5563965e-003,1.9836426e-002,3.4057617e-002,4.3365479e-002,4.4677734e-002,2.0660400e-002,5.9509277e-003,-4.8522949e-003,-9.0942383e-003,8.3618164e-003,1.9409180e-002,2.7740479e-002,3.2196045e-002,1.8280029e-002,8.3618164e-003,-1.8005371e-003,-8.0566406e-003,3.9367676e-003,1.1688232e-002,2.1423340e-002,2.3345947e-002,1.0498047e-002,5.2795410e-003,2.8076172e-003,9.4909668e-003,2.9479980e-002,3.5797119e-002,2.8625488e-002,1.8981934e-002,2.5024414e-003,3.7231445e-003,2.6458740e-002,4.0374756e-002,4.7088623e-002,3.9093018e-002,6.6528320e-003,-5.8288574e-003,2.1667480e-003,1.4038086e-002,4.3792725e-002,5.1208496e-002,2.9235840e-002,1.6174316e-002,-2.4108887e-003,-7.1411133e-003,1.4495850e-002,1.9256592e-002,1.9287109e-002,2.0629883e-002,1.1505127e-002,1.9256592e-002,3.7017822e-002,4.1015625e-002,3.6437988e-002,2.4353027e-002,4.0588379e-003,-1.8310547e-003,1.0681152e-002,1.6662598e-002,2.2674561e-002,2.2644043e-002,9.2773438e-003,1.2603760e-002,2.6245117e-002,3.5217285e-002,4.3792725e-002,3.7017822e-002,1.4678955e-002,3.6926270e-003,4.7302246e-003,9.3994141e-003,2.8259277e-002,3.4393311e-002,2.3956299e-002,2.2918701e-002,1.4709473e-002,1.2237549e-002,1.8859863e-002,1.2115479e-002,1.8310547e-003,-5.4626465e-003,-9.9487305e-003,-5.6762695e-003,9.0637207e-003,1.6693115e-002,1.6479492e-002,1.7547607e-002,1.3183594e-002,1.6815186e-002,2.9266357e-002,3.2684326e-002,3.3294678e-002,3.1005859e-002,2.2796631e-002,2.2857666e-002,3.0090332e-002,3.3386230e-002,3.5552979e-002,3.5705566e-002,2.8442383e-002,2.6794434e-002,2.6580811e-002,2.1240234e-002,1.8035889e-002,1.1749268e-002,7.2021484e-003,9.1247559e-003,1.5716553e-002,1.7608643e-002,1.2237549e-002,4.2419434e-003,-8.5754395e-003,-1.1993408e-002,-4.0283203e-003,5.7983398e-004,5.6457520e-003,5.0964355e-003,-5.6152344e-003,-4.9438477e-003,3.6926270e-003,1.2908936e-002,2.8076172e-002,3.2592773e-002,2.5512695e-002,2.5054932e-002,2.5573730e-002,2.9357910e-002,4.0924072e-002,4.2724609e-002,3.5491943e-002,3.2653809e-002,2.6977539e-002,2.6611328e-002,3.3843994e-002,3.3905029e-002,2.9083252e-002,2.3864746e-002,1.3946533e-002,7.9345703e-003,7.9956055e-003,4.1503906e-003,2.4108887e-003,1.7700195e-003,7.9345703e-004,3.6926270e-003,8.2702637e-003,8.3007813e-003,3.6010742e-003,-1.8005371e-003,-8.6669922e-003,-1.1199951e-002,-7.5378418e-003,-5.5847168e-003,-2.0141602e-003,4.0588379e-003,9.4909668e-003,2.0172119e-002,3.2073975e-002,4.0466309e-002,4.4464111e-002,4.5227051e-002,4.3334961e-002,4.1107178e-002,4.2755127e-002,3.9550781e-002,3.5369873e-002,3.0426025e-002,2.2705078e-002,2.0507813e-002,2.1545410e-002,2.2613525e-002,2.3620605e-002,2.3834229e-002,2.0080566e-002,1.7639160e-002,1.5594482e-002,1.2756348e-002,1.1779785e-002,9.5214844e-003,9.0942383e-003,8.5754395e-003,8.1481934e-003,6.9885254e-003,2.9602051e-003,1.1596680e-003,-6.1035156e-005,1.5869141e-003,7.1105957e-003,1.1230469e-002,1.2695313e-002,1.3580322e-002,1.1444092e-002,1.3061523e-002,1.9409180e-002,2.4749756e-002,3.3050537e-002,3.8391113e-002,3.9581299e-002,4.1412354e-002,3.9367676e-002,3.7414551e-002,3.5064697e-002,3.2104492e-002,3.1951904e-002,3.1097412e-002,3.0609131e-002,2.8839111e-002,2.4291992e-002,2.0629883e-002,1.6326904e-002,1.1749268e-002,7.9345703e-003,5.1879883e-004,-7.5988770e-003,-1.2634277e-002,-1.2878418e-002,-7.6599121e-003,2.5329590e-003,1.0009766e-002,1.0375977e-002,1.0070801e-002,4.5471191e-003,5.3405762e-003,1.5167236e-002,2.2430420e-002,3.2562256e-002,3.5949707e-002,2.9052734e-002,2.5115967e-002,2.0690918e-002,1.7974854e-002,2.2521973e-002,2.3101807e-002,2.2735596e-002,2.5115967e-002,2.5115967e-002,2.8045654e-002,3.0944824e-002,2.9907227e-002,2.7008057e-002,2.4047852e-002,2.2277832e-002,2.2644043e-002,2.4536133e-002,2.4108887e-002,1.9348145e-002,1.3366699e-002,5.1574707e-003,3.0517578e-004,3.6621094e-004,-8.2397461e-004,-9.4604492e-004,-6.1035156e-004,-1.8615723e-003,4.8828125e-004,4.8217773e-003,7.5378418e-003,9.9182129e-003,1.1291504e-002,1.2939453e-002,1.8371582e-002,2.8656006e-002,3.6163330e-002,4.1351318e-002,4.2144775e-002,3.5552979e-002,3.1219482e-002,2.7648926e-002,2.3651123e-002,2.3956299e-002,2.2766113e-002,2.2460938e-002,2.6062012e-002,2.9876709e-002,3.4088135e-002,3.5064697e-002,3.2501221e-002,2.5970459e-002,2.0385742e-002,1.7700195e-002,1.4129639e-002,1.3824463e-002,1.1505127e-002,7.6293945e-003,7.8735352e-003,8.0261230e-003,9.7351074e-003,1.1596680e-002,1.0925293e-002,8.2397461e-003,7.8735352e-003,1.1352539e-002,1.4465332e-002,1.9683838e-002,2.1545410e-002,1.9500732e-002,1.9744873e-002,2.1392822e-002,2.2949219e-002,2.5360107e-002,2.4444580e-002,1.9073486e-002,2.0538330e-002,2.4566650e-002,3.0487061e-002,3.9855957e-002,4.2175293e-002,3.6407471e-002,3.0853271e-002,2.4078369e-002,1.9409180e-002,2.1453857e-002,1.8310547e-002,1.4190674e-002,1.1993408e-002,9.2163086e-003,1.2390137e-002,1.8218994e-002,2.1636963e-002,2.0599365e-002,1.8615723e-002,1.3397217e-002,1.0314941e-002,1.2207031e-002,9.8266602e-003,8.1787109e-003,7.3242188e-003,6.3476563e-003,1.0406494e-002,1.8859863e-002,2.3803711e-002,2.4993896e-002,2.4719238e-002,1.9927979e-002,1.7120361e-002,1.7211914e-002,1.3031006e-002,1.0375977e-002,9.4909668e-003,1.1749268e-002,2.1270752e-002,3.5186768e-002,4.4158936e-002,4.2541504e-002,3.6895752e-002,2.3559570e-002,1.5411377e-002,1.9958496e-002,2.0477295e-002,2.7069092e-002,2.9602051e-002,2.2949219e-002,2.3956299e-002,2.3040771e-002,2.3193359e-002,2.4871826e-002,2.1667480e-002,1.7364502e-002,1.5655518e-002,1.8371582e-002,2.0935059e-002,2.3773193e-002,2.0843506e-002,1.0681152e-002,6.1340332e-003,6.3781738e-003,1.0070801e-002,2.1697998e-002,2.7404785e-002,2.5665283e-002,2.6794434e-002,2.4414063e-002,2.3468018e-002,2.6550293e-002,2.0294189e-002,1.0467529e-002,3.4790039e-003,-4.2724609e-004,4.7302246e-003,2.0355225e-002,3.2867432e-002,3.9154053e-002,4.4616699e-002,4.0130615e-002,4.1168213e-002,4.8034668e-002,4.8400879e-002,5.0628662e-002,4.3090820e-002,2.6947021e-002,1.4007568e-002,3.9672852e-003,-9.7656250e-004,3.7231445e-003,1.0162354e-002,1.5502930e-002,2.3895264e-002,2.5726318e-002,2.6977539e-002,2.6000977e-002,2.2369385e-002,2.2247314e-002,2.1575928e-002,2.6123047e-002,2.8564453e-002,2.9693604e-002,3.1097412e-002,2.8991699e-002,3.1402588e-002,3.3477783e-002,3.5064697e-002,3.4759521e-002,3.2073975e-002,2.6824951e-002,2.3651123e-002,2.3803711e-002,2.2552490e-002,2.3132324e-002,2.2827148e-002,2.1881104e-002,2.3315430e-002,2.4749756e-002,2.4414063e-002,2.0690918e-002,1.6876221e-002,1.4434814e-002,1.6906738e-002,2.5482178e-002,3.1097412e-002,3.2073975e-002,3.0273438e-002,2.1820068e-002,2.0263672e-002,2.9174805e-002,3.6895752e-002,4.6966553e-002,4.7790527e-002,3.5217285e-002,2.6214600e-002,1.8829346e-002,1.4892578e-002,2.1484375e-002,2.0935059e-002,1.5594482e-002,1.5502930e-002,1.3458252e-002,2.1362305e-002,3.7628174e-002,4.6325684e-002,4.8522949e-002,4.5867920e-002,3.5552979e-002,3.1005859e-002,3.4515381e-002,3.2501221e-002,3.3050537e-002,2.9998779e-002,2.0782471e-002,1.9317627e-002,2.0446777e-002,2.1453857e-002,2.1301270e-002,1.8096924e-002,1.0803223e-002,9.7351074e-003,1.7791748e-002,2.5299072e-002,3.6743164e-002,4.0832520e-002,3.4759521e-002,3.3447266e-002,3.1677246e-002,3.1738281e-002,3.8757324e-002,3.9398193e-002,3.5705566e-002,3.3630371e-002,2.7648926e-002,2.5451660e-002,2.4902344e-002,2.0843506e-002,1.6510010e-002,1.4678955e-002,1.6082764e-002,2.2216797e-002,3.3630371e-002,4.1381836e-002,4.3518066e-002,4.3334961e-002,3.7445068e-002,3.4118652e-002,3.6651611e-002,3.5919189e-002,3.7567139e-002,3.6865234e-002,3.1372070e-002,2.9479980e-002,2.7099609e-002,2.4841309e-002,2.3956299e-002,2.2094727e-002,2.1209717e-002,2.2918701e-002,2.6855469e-002,3.0487061e-002,3.3660889e-002,3.4637451e-002,3.3905029e-002,3.4545898e-002,3.6956787e-002,3.9215088e-002,4.1900635e-002,4.3945313e-002,4.4555664e-002,4.7393799e-002,5.0659180e-002,5.2764893e-002,5.3619385e-002,5.0903320e-002,4.4250488e-002,3.7963867e-002,3.2806396e-002,2.7618408e-002,2.6062012e-002,2.3895264e-002,2.2308350e-002,2.5054932e-002,2.9693604e-002,3.6346436e-002,4.2053223e-002,4.4860840e-002,4.2846680e-002,3.9703369e-002,3.7506104e-002,3.4851074e-002,3.5583496e-002,3.3081055e-002,2.7404785e-002,2.3956299e-002,2.0385742e-002,2.0904541e-002,2.5360107e-002,2.7496338e-002,2.6580811e-002,2.3986816e-002,1.7791748e-002,1.7486572e-002,2.4597168e-002,3.0639648e-002,4.0405273e-002,4.5166016e-002,4.1595459e-002,4.0649414e-002,3.7567139e-002,3.7292480e-002,4.2633057e-002,4.3823242e-002,4.4128418e-002,4.3060303e-002,3.7475586e-002,3.4027100e-002,3.0700684e-002,2.5909424e-002,2.2949219e-002,1.9805908e-002,1.8310547e-002,1.8859863e-002,2.2033691e-002,2.6031494e-002,3.0059814e-002,3.5919189e-002,4.1595459e-002,4.8095703e-002,5.2520752e-002,5.0964355e-002,4.4281006e-002,3.5675049e-002,2.7496338e-002,2.3101807e-002,2.6550293e-002,3.0059814e-002,3.3477783e-002,3.4729004e-002,3.0364990e-002,2.9907227e-002,3.0761719e-002,3.3294678e-002,4.2083740e-002,4.7088623e-002,5.0354004e-002,5.2215576e-002,4.9835205e-002,4.6600342e-002,4.2266846e-002,3.5644531e-002,2.8808594e-002,2.3071289e-002,1.9042969e-002,1.7822266e-002,1.7883301e-002,1.8249512e-002,1.7578125e-002,1.9531250e-002,2.1484375e-002,2.4597168e-002,2.9846191e-002,3.1921387e-002,3.3172607e-002,3.3050537e-002,3.3569336e-002,3.5797119e-002,4.0832520e-002,4.4616699e-002,4.4830322e-002,4.4494629e-002,3.9367676e-002,3.6163330e-002,3.5766602e-002,3.3905029e-002,3.4027100e-002,3.2928467e-002,2.9449463e-002,2.8930664e-002,3.0151367e-002,3.1616211e-002,3.6132813e-002,3.8543701e-002,4.0679932e-002,4.5654297e-002,5.1055908e-002,5.4840088e-002,5.4077148e-002,4.6478271e-002,3.1433105e-002,1.8218994e-002,9.8571777e-003,6.1035156e-003,1.3763428e-002,2.0385742e-002,2.3773193e-002,2.7832031e-002,2.4749756e-002,2.4444580e-002,2.7191162e-002,2.7374268e-002,3.2104492e-002,3.2318115e-002,3.0548096e-002,2.8472900e-002,2.4261475e-002,2.1575928e-002,2.0172119e-002,2.2094727e-002,2.6428223e-002,3.3355713e-002,3.9398193e-002,4.4494629e-002,4.5196533e-002,4.5837402e-002,4.8278809e-002,4.8950195e-002,5.2490234e-002,4.8675537e-002,3.9428711e-002,3.0242920e-002,2.0751953e-002,1.7608643e-002,2.2399902e-002,2.6184082e-002,2.7221680e-002,2.8381348e-002,2.1636963e-002,2.2369385e-002,2.8717041e-002,3.2653809e-002,4.0802002e-002,4.0618896e-002,3.2684326e-002,2.5695801e-002,1.9683838e-002,1.6815186e-002,1.9805908e-002,1.8859863e-002,1.4648438e-002,1.2451172e-002,8.0566406e-003,1.0528564e-002,1.7639160e-002,2.4932861e-002,3.1921387e-002,3.6407471e-002,3.5644531e-002,3.3355713e-002,3.0426025e-002,2.5299072e-002,2.3345947e-002,2.1240234e-002,2.4566650e-002,2.9022217e-002,3.2623291e-002,3.6041260e-002,3.3966064e-002,3.3477783e-002,3.1768799e-002,3.1005859e-002,3.4179688e-002,3.3294678e-002,3.1402588e-002,2.7008057e-002,2.0080566e-002,1.6571045e-002,1.5441895e-002,1.4617920e-002,1.5930176e-002,1.7486572e-002,1.6967773e-002,1.9714355e-002,2.3712158e-002,2.7252197e-002,3.0548096e-002,2.8564453e-002,2.1362305e-002,1.4129639e-002,8.5144043e-003,5.5847168e-003,1.0131836e-002,1.3916016e-002,1.7578125e-002,2.2338867e-002,2.1209717e-002,2.3040771e-002,2.2857666e-002,2.0416260e-002,1.8310547e-002,1.2908936e-002,9.2468262e-003,6.7443848e-003,7.6599121e-003,1.1627197e-002,1.7150879e-002,2.5115967e-002,3.2806396e-002,4.2144775e-002,4.9987793e-002,5.2703857e-002,4.7943115e-002,3.6682129e-002,2.0416260e-002,6.1645508e-003,1.3122559e-003,-1.0986328e-003,4.6386719e-003,1.1077881e-002,1.1474609e-002,1.7517090e-002,1.9866943e-002,2.3864746e-002,2.8747559e-002,2.5451660e-002,2.0874023e-002,1.2847900e-002,7.4462891e-003,4.6691895e-003,8.3923340e-003,1.1779785e-002,1.2786865e-002,1.6845703e-002,1.5808105e-002,1.9226074e-002,2.3834229e-002,2.4200439e-002,2.2369385e-002,1.5777588e-002,6.1035156e-003,1.5258789e-004,3.1738281e-003,6.6223145e-003,1.5014648e-002,1.9775391e-002,1.5594482e-002,1.5350342e-002,1.1077881e-002,1.0070801e-002,1.5411377e-002,1.5838623e-002,1.5655518e-002,1.3214111e-002,6.8664551e-003,2.6245117e-003,6.1035156e-004,-9.7656250e-004,2.7465820e-004,1.0986328e-003,8.5449219e-004,2.2583008e-003,2.7465820e-003,4.6081543e-003,6.6528320e-003,7.3547363e-003,8.3618164e-003,1.0559082e-002,1.5960693e-002,2.0141602e-002,2.3193359e-002,2.2094727e-002,1.3671875e-002,7.0800781e-003,8.8500977e-004,-2.4414063e-003,1.0375977e-003,5.4321289e-003,1.0131836e-002,1.4801025e-002,1.3732910e-002,1.4739990e-002,1.3977051e-002,1.0162354e-002,7.8735352e-003,1.9226074e-003,-2.4719238e-003,-5.6457520e-003,-6.6528320e-003,-6.1950684e-003,-6.9885254e-003,-6.5002441e-003,-9.0637207e-003,-9.1247559e-003,-7.9956055e-003,-8.0871582e-003,-6.9885254e-003,-7.5683594e-003,-8.3007813e-003,-5.7983398e-003,9.1552734e-004,6.9274902e-003,1.1993408e-002,1.3214111e-002,7.4768066e-003,3.3264160e-003,-1.8310547e-004,-1.2207031e-003,3.6010742e-003,5.0354004e-003,4.9438477e-003,4.6997070e-003,-2.4414063e-004,-1.8005371e-003,-7.9345703e-004,-9.7656250e-004,7.3242188e-004,3.3569336e-004,-1.9226074e-003,-3.4179688e-003,-3.6315918e-003,-3.1127930e-003,-8.8500977e-004,1.0070801e-003,1.2207031e-004,-8.8500977e-004,-4.8217773e-003,-8.2702637e-003,-1.0528564e-002,-1.2115479e-002,-1.0559082e-002,-8.9416504e-003,-7.5073242e-003,-6.7443848e-003,-8.8500977e-003,-9.3994141e-003,-9.6740723e-003,-1.0192871e-002,-8.7280273e-003,-8.3007813e-003,-7.9040527e-003,-6.7443848e-003,-5.6152344e-003,-3.8146973e-003,-2.6855469e-003,-2.8381348e-003,-4.5471191e-003,-5.9509277e-003,-7.2937012e-003,-8.2702637e-003,-8.3007813e-003,-9.1552734e-003,-1.0375977e-002,-1.1657715e-002,-1.3000488e-002,-1.3153076e-002,-1.2207031e-002,-1.0894775e-002,-9.6740723e-003,-8.6364746e-003,-9.0942383e-003,-9.8876953e-003,-1.0681152e-002,-9.9792480e-003,-6.5307617e-003,-2.6855469e-003,8.2397461e-004,1.6479492e-003,-2.9296875e-003,-8.0566406e-003,-1.3580322e-002,-1.7333984e-002,-1.4770508e-002,-1.4587402e-002,-1.5258789e-002,-1.7211914e-002,-2.4719238e-002,-2.7496338e-002,-2.6275635e-002,-2.4627686e-002,-1.9317627e-002,-1.6265869e-002,-1.7486572e-002,-1.5289307e-002,-1.3275146e-002,-1.1901855e-002,-9.6130371e-003,-1.2817383e-002,-2.0538330e-002,-2.5634766e-002,-2.7008057e-002,-2.5634766e-002,-1.8005371e-002,-1.4282227e-002,-1.4404297e-002,-1.4526367e-002,-1.8981934e-002,-1.9470215e-002,-1.4831543e-002,-1.2542725e-002,-9.2468262e-003,-7.7514648e-003,-9.2773438e-003,-7.9650879e-003,-6.0119629e-003,-5.5847168e-003,-7.0190430e-003,-1.1322021e-002,-1.8280029e-002,-2.3132324e-002,-2.5268555e-002,-2.8289795e-002,-2.8778076e-002,-2.9754639e-002,-3.0975342e-002,-2.7679443e-002,-2.2125244e-002,-1.7425537e-002,-1.4923096e-002,-1.7028809e-002,-2.4444580e-002,-3.0273438e-002,-3.1921387e-002,-3.2562256e-002,-2.7954102e-002,-2.6214600e-002,-2.9541016e-002,-3.0426025e-002,-3.3721924e-002,-3.3660889e-002,-2.8839111e-002,-2.6855469e-002,-2.5024414e-002,-2.3925781e-002,-2.5421143e-002,-2.6153564e-002,-2.4536133e-002,-2.5878906e-002,-2.7557373e-002,-2.8778076e-002,-2.9968262e-002,-2.6794434e-002,-2.0812988e-002,-1.5502930e-002,-1.3244629e-002,-1.3031006e-002,-1.9165039e-002,-2.3864746e-002,-2.7801514e-002,-3.5095215e-002,-3.9489746e-002,-4.3670654e-002,-4.3762207e-002,-3.8726807e-002,-2.9113770e-002,-1.9500732e-002,-1.4739990e-002,-1.2908936e-002,-1.9012451e-002,-2.4017334e-002,-2.5299072e-002,-2.9052734e-002,-2.7587891e-002,-2.9876709e-002,-3.4118652e-002,-3.2531738e-002,-3.1066895e-002,-2.6794434e-002,-2.4108887e-002,-2.6672363e-002,-3.6224365e-002,-4.4555664e-002,-4.7973633e-002,-4.8248291e-002,-3.8696289e-002,-3.3538818e-002,-3.2318115e-002,-2.9815674e-002,-3.1494141e-002,-2.6702881e-002,-1.7456055e-002,-1.2878418e-002,-1.1749268e-002,-1.5106201e-002,-2.5390625e-002,-3.1402588e-002,-3.1524658e-002,-3.2775879e-002,-3.0487061e-002,-3.0639648e-002,-3.6682129e-002,-3.8269043e-002,-4.0283203e-002,-3.9978027e-002,-3.5003662e-002,-3.2104492e-002,-2.8472900e-002,-2.6153564e-002,-2.6550293e-002,-3.0334473e-002,-3.7170410e-002,-4.5257568e-002,-5.0445557e-002,-4.7241211e-002,-3.6285400e-002,-2.5451660e-002,-1.9470215e-002,-1.8829346e-002,-3.2867432e-002,-4.3884277e-002,-5.1208496e-002,-5.6915283e-002,-4.8583984e-002,-4.4128418e-002,-3.9306641e-002,-3.2501221e-002,-3.2928467e-002,-3.1066895e-002,-3.3020020e-002,-3.8940430e-002,-4.4677734e-002,-4.9011230e-002,-4.6020508e-002,-4.0496826e-002,-3.1311035e-002,-2.4444580e-002,-2.6855469e-002,-2.7984619e-002,-3.4240723e-002,-3.8604736e-002,-3.6621094e-002,-3.9459229e-002,-4.0985107e-002,-4.3609619e-002,-4.8431396e-002,-4.8675537e-002,-4.6478271e-002,-4.4433594e-002,-4.1534424e-002,-3.9337158e-002,-3.9001465e-002,-3.7384033e-002,-3.6804199e-002,-3.9001465e-002,-4.2327881e-002,-4.5410156e-002,-4.5196533e-002,-4.1992188e-002,-3.5522461e-002,-3.2562256e-002,-3.8299561e-002,-4.5562744e-002,-5.6793213e-002,-6.1920166e-002,-5.4779053e-002,-4.7729492e-002,-3.5736084e-002,-2.8808594e-002,-3.4057617e-002,-3.7261963e-002,-4.5898438e-002,-5.2154541e-002,-4.9072266e-002,-4.9652100e-002,-4.6081543e-002,-4.2846680e-002,-4.3304443e-002,-4.1290283e-002,-4.2083740e-002,-4.2266846e-002,-4.2816162e-002,-4.4647217e-002,-4.5562744e-002,-4.7088623e-002,-4.5440674e-002,-4.2846680e-002,-3.8726807e-002,-3.5430908e-002,-3.5797119e-002,-3.8604736e-002,-4.5501709e-002,-4.9896240e-002,-4.9316406e-002,-4.6264648e-002,-3.7994385e-002,-3.4118652e-002,-3.7231445e-002,-4.0832520e-002,-4.8278809e-002,-5.1025391e-002,-4.5654297e-002,-4.1503906e-002,-3.4729004e-002,-3.0090332e-002,-3.2745361e-002,-3.3142090e-002,-3.5491943e-002,-3.8360596e-002,-3.8940430e-002,-4.2633057e-002,-4.6295166e-002,-4.8492432e-002,-5.0201416e-002,-5.0445557e-002,-4.9163818e-002,-4.7058105e-002,-4.5471191e-002,-4.2449951e-002,-4.0191650e-002,-3.9947510e-002,-4.1625977e-002,-4.5440674e-002,-4.9652100e-002,-5.2368164e-002,-4.9896240e-002,-4.8095703e-002,-4.5440674e-002,-4.1290283e-002,-4.2266846e-002,-4.0649414e-002,-4.0466309e-002,-4.2327881e-002,-4.4281006e-002,-4.9468994e-002,-5.4107666e-002,-5.5358887e-002,-5.1452637e-002,-4.6356201e-002,-4.1290283e-002,-3.9550781e-002,-4.5806885e-002,-5.0079346e-002,-5.3497314e-002,-5.4199219e-002,-4.8126221e-002,-4.4586182e-002,-4.1900635e-002,-3.9794922e-002,-4.2388916e-002,-4.4403076e-002,-4.6295166e-002,-5.0201416e-002,-5.2703857e-002,-5.4382324e-002,-5.2856445e-002,-4.8583984e-002,-4.2572021e-002,-3.9123535e-002,-4.0710449e-002,-4.3304443e-002,-4.8797607e-002,-5.0628662e-002,-4.6997070e-002,-4.5806885e-002,-4.4097900e-002,-4.6417236e-002,-5.3649902e-002,-5.7403564e-002,-5.8471680e-002,-5.7312012e-002,-5.2886963e-002,-5.1208496e-002,-5.2215576e-002,-5.1635742e-002,-5.1208496e-002,-5.0750732e-002,-4.9011230e-002,-5.0628662e-002,-5.4260254e-002,-5.6610107e-002,-5.7159424e-002,-5.4840088e-002,-4.9591064e-002,-4.6661377e-002,-4.8919678e-002,-4.8583984e-002,-4.8278809e-002,-4.4555664e-002,-3.5766602e-002,-3.2775879e-002,-3.3569336e-002,-3.8055420e-002,-4.6691895e-002,-5.1269531e-002,-4.9652100e-002,-4.9804688e-002,-4.8217773e-002,-4.8278809e-002,-5.2185059e-002,-5.0323486e-002,-4.6813965e-002,-4.4403076e-002,-4.3579102e-002,-4.6234131e-002,-5.2154541e-002,-5.4626465e-002,-5.1910400e-002,-5.0262451e-002,-4.5745850e-002,-4.5654297e-002,-5.1818848e-002,-5.2490234e-002,-5.1086426e-002,-4.7668457e-002,-4.0435791e-002,-3.8787842e-002,-4.2877197e-002,-4.5227051e-002,-4.8614502e-002,-4.9102783e-002,-4.4769287e-002,-4.4830322e-002,-4.6661377e-002,-4.7973633e-002,-5.0994873e-002,-5.1361084e-002,-4.9163818e-002,-4.9499512e-002,-5.0720215e-002,-5.0659180e-002,-5.0506592e-002,-4.9194336e-002,-4.7149658e-002,-4.8797607e-002,-5.3009033e-002,-5.5175781e-002,-5.5175781e-002,-5.1635742e-002,-4.4128418e-002,-4.1168213e-002,-4.0557861e-002,-4.0100098e-002,-4.2724609e-002,-4.2327881e-002,-3.8543701e-002,-3.9093018e-002,-4.2358398e-002,-4.7485352e-002,-5.5450439e-002,-5.9570313e-002,-5.7922363e-002,-5.6457520e-002,-5.3833008e-002,-5.2185059e-002,-5.5572510e-002,-5.5328369e-002,-5.4656982e-002,-5.2825928e-002,-4.6081543e-002,-4.1839600e-002,-3.8452148e-002,-3.6865234e-002,-4.0161133e-002,-4.3731689e-002,-4.7851563e-002,-5.1269531e-002,-5.0415039e-002,-4.9468994e-002,-4.7729492e-002,-4.5043945e-002,-4.5379639e-002,-4.3975830e-002,-4.3823242e-002,-4.4982910e-002,-4.6600342e-002,-5.0994873e-002,-5.4504395e-002,-5.7098389e-002,-5.6091309e-002,-5.4534912e-002,-5.4046631e-002,-5.3710938e-002,-5.6762695e-002,-5.5725098e-002,-5.2276611e-002,-4.7668457e-002,-4.1351318e-002,-3.8635254e-002,-4.0222168e-002,-4.1595459e-002,-4.4097900e-002,-4.6905518e-002,-4.6081543e-002,-4.8431396e-002,-5.1116943e-002,-5.1849365e-002,-5.2978516e-002,-5.1849365e-002,-4.8797607e-002,-4.7546387e-002,-4.7851563e-002,-4.6569824e-002,-4.4555664e-002,-4.2755127e-002,-4.1412354e-002,-4.4982910e-002,-5.2429199e-002,-5.8013916e-002,-5.9844971e-002,-5.7739258e-002,-4.8522949e-002,-4.1503906e-002,-3.9764404e-002,-3.8024902e-002,-4.2846680e-002,-4.5349121e-002,-4.3823242e-002,-4.6844482e-002,-4.7119141e-002,-5.0201416e-002,-5.5541992e-002,-5.6610107e-002,-5.5877686e-002,-5.2429199e-002,-4.6264648e-002,-4.2053223e-002,-4.1900635e-002,-4.2388916e-002,-4.6417236e-002,-4.9285889e-002,-4.8583984e-002,-4.8645020e-002,-4.4616699e-002,-4.2968750e-002,-4.4097900e-002,-4.4647217e-002,-4.8126221e-002,-4.8736572e-002,-4.5593262e-002,-4.2358398e-002,-3.8146973e-002,-3.6865234e-002,-4.0435791e-002,-4.3853760e-002,-4.7210693e-002,-4.7943115e-002,-4.2846680e-002,-3.9764404e-002,-3.8757324e-002,-3.9916992e-002,-4.5288086e-002,-4.8736572e-002,-4.6966553e-002,-4.3365479e-002,-3.7078857e-002,-3.4057617e-002,-3.7261963e-002,-4.1564941e-002,-4.9346924e-002,-5.3710938e-002,-5.1452637e-002,-5.0689697e-002,-4.7943115e-002,-4.7332764e-002,-5.2337646e-002,-5.2215576e-002,-4.9652100e-002,-4.5684814e-002,-3.8665771e-002,-3.6590576e-002,-4.0008545e-002,-4.2114258e-002,-4.4281006e-002,-4.4219971e-002,-3.9093018e-002,-4.0039063e-002,-4.3823242e-002,-4.6478271e-002,-5.0903320e-002,-4.9438477e-002,-4.2572021e-002,-3.8726807e-002,-3.7811279e-002,-4.0527344e-002,-4.9743652e-002,-5.4931641e-002,-5.4168701e-002,-5.4077148e-002,-4.8797607e-002,-4.5684814e-002,-4.6539307e-002,-4.4006348e-002,-4.2633057e-002,-4.0985107e-002,-3.7841797e-002,-3.7628174e-002,-3.9703369e-002,-4.0100098e-002,-4.1259766e-002,-4.2114258e-002,-4.0466309e-002,-4.0283203e-002,-3.9672852e-002,-3.8543701e-002,-4.0313721e-002,-4.3121338e-002,-4.8950195e-002,-5.3588867e-002,-5.3955078e-002,-5.2062988e-002,-4.3975830e-002,-3.8421631e-002,-3.8269043e-002,-3.8879395e-002,-4.5532227e-002,-4.7760010e-002,-4.3670654e-002,-4.1198730e-002,-3.4820557e-002,-3.3325195e-002,-3.8238525e-002,-4.0863037e-002,-4.5135498e-002,-4.6661377e-002,-4.3701172e-002,-4.4250488e-002,-4.5349121e-002,-4.5654297e-002,-4.7515869e-002,-4.5989990e-002,-4.2205811e-002,-3.9855957e-002,-3.9306641e-002,-3.9794922e-002,-4.1839600e-002,-4.2877197e-002,-4.0679932e-002,-3.9947510e-002,-3.7506104e-002,-3.5644531e-002,-3.6346436e-002,-3.5644531e-002,-3.5980225e-002,-3.6712646e-002,-3.6346436e-002,-3.8055420e-002,-3.9733887e-002,-4.0100098e-002,-4.0405273e-002,-4.0313721e-002,-4.0100098e-002,-4.1198730e-002,-4.3182373e-002,-4.3518066e-002,-4.2510986e-002,-4.0039063e-002,-3.6224365e-002,-3.5278320e-002,-3.7780762e-002,-4.0100098e-002,-4.1900635e-002,-4.0496826e-002,-3.4454346e-002,-3.0517578e-002,-3.1799316e-002,-3.4637451e-002,-4.0557861e-002,-4.5074463e-002,-4.4189453e-002,-4.4128418e-002,-4.0435791e-002,-3.7994385e-002,-3.9611816e-002,-3.7445068e-002,-3.5339355e-002,-3.4179688e-002,-3.2348633e-002,-3.3996582e-002,-3.7109375e-002,-3.8513184e-002,-3.7658691e-002,-3.7231445e-002,-3.6285400e-002,-3.7170410e-002,-4.1625977e-002,-4.2602539e-002,-4.1412354e-002,-3.9825439e-002,-3.6865234e-002,-3.6956787e-002,-4.1259766e-002,-4.2785645e-002,-4.2114258e-002,-4.1107178e-002,-3.6956787e-002,-3.5675049e-002,-3.7689209e-002,-3.7109375e-002,-3.5614014e-002,-3.4027100e-002,-3.1250000e-002,-3.2989502e-002,-3.8787842e-002,-4.2022705e-002,-4.2358398e-002,-3.9550781e-002,-3.2104492e-002,-2.7618408e-002,-2.8228760e-002,-2.8442383e-002,-3.2684326e-002,-3.5522461e-002,-3.5125732e-002,-3.7170410e-002,-3.8177490e-002,-3.8482666e-002,-3.8421631e-002,-3.5552979e-002,-3.1463623e-002,-2.8747559e-002,-2.8839111e-002,-3.0273438e-002,-3.3386230e-002,-3.7475586e-002,-3.8818359e-002,-4.1717529e-002,-4.3914795e-002,-4.3823242e-002,-4.1046143e-002,-3.6560059e-002,-3.2409668e-002,-2.9449463e-002,-3.2501221e-002,-3.4149170e-002,-3.4484863e-002,-3.4515381e-002,-2.8961182e-002,-2.7770996e-002,-2.9632568e-002,-3.0761719e-002,-3.4729004e-002,-3.5217285e-002,-3.1463623e-002,-3.0853271e-002,-3.1372070e-002,-3.4393311e-002,-4.1412354e-002,-4.4860840e-002,-4.3548584e-002,-3.9520264e-002,-3.1738281e-002,-2.6458740e-002,-2.7587891e-002,-2.8778076e-002,-3.3142090e-002,-3.4759521e-002,-3.0426025e-002,-2.6306152e-002,-2.0141602e-002,-1.7242432e-002,-1.9470215e-002,-2.0843506e-002,-2.3986816e-002,-2.7008057e-002,-2.7252197e-002,-3.0853271e-002,-3.5308838e-002,-3.9031982e-002,-4.1809082e-002,-4.0008545e-002,-3.2928467e-002,-2.6885986e-002,-2.4505615e-002,-2.4719238e-002,-3.3386230e-002,-3.9703369e-002,-4.0802002e-002,-4.1107178e-002,-3.1188965e-002,-2.5177002e-002,-2.2918701e-002,-1.9531250e-002,-2.7770996e-002,-3.3233643e-002,-3.6376953e-002,-3.9520264e-002,-3.3630371e-002,-3.0059814e-002,-2.7862549e-002,-2.6641846e-002,-3.2684326e-002,-3.5614014e-002,-3.6865234e-002,-3.7200928e-002,-3.2165527e-002,-2.9815674e-002,-2.8961182e-002,-2.6275635e-002,-2.5329590e-002,-2.2888184e-002,-1.9897461e-002,-1.9866943e-002,-2.2094727e-002,-2.3956299e-002,-2.4597168e-002,-2.4139404e-002,-2.1667480e-002,-2.2521973e-002,-2.7557373e-002,-3.1982422e-002,-3.6987305e-002,-3.7750244e-002,-3.1738281e-002,-2.8259277e-002,-2.6367188e-002,-2.4810791e-002,-2.8320313e-002,-2.8564453e-002,-2.5146484e-002,-2.4536133e-002,-2.3498535e-002,-2.5817871e-002,-3.2470703e-002,-3.5644531e-002,-3.6010742e-002,-3.5980225e-002,-3.2745361e-002,-3.1066895e-002,-3.1646729e-002,-2.9510498e-002,-2.7648926e-002,-2.6062012e-002,-2.5146484e-002,-2.6794434e-002,-3.0273438e-002,-3.3691406e-002,-3.4454346e-002,-3.5217285e-002,-3.1280518e-002,-2.5878906e-002,-2.2979736e-002,-2.0324707e-002,-2.1942139e-002,-2.5115967e-002,-2.8686523e-002,-3.2257080e-002,-3.1524658e-002,-2.9724121e-002,-2.4505615e-002,-2.1087646e-002,-2.1301270e-002,-2.0477295e-002,-2.2003174e-002,-2.1575928e-002,-1.8188477e-002,-1.7700195e-002,-1.8249512e-002,-1.9256592e-002,-2.3284912e-002,-2.4719238e-002,-2.3620605e-002,-2.4505615e-002,-2.5756836e-002,-2.7618408e-002,-3.1005859e-002,-2.9418945e-002,-2.2583008e-002,-1.7425537e-002,-1.2573242e-002,-1.2420654e-002,-1.9500732e-002,-2.4108887e-002,-2.5634766e-002,-2.6428223e-002,-2.1423340e-002,-2.0751953e-002,-2.5909424e-002,-2.7618408e-002,-3.0517578e-002,-2.8839111e-002,-2.0996094e-002,-1.7242432e-002,-1.8096924e-002,-2.1179199e-002,-2.8930664e-002,-3.2287598e-002,-2.6184082e-002,-2.2277832e-002,-1.5930176e-002,-1.5014648e-002,-2.4566650e-002,-3.0426025e-002,-3.6163330e-002,-3.6163330e-002,-2.9022217e-002,-2.4078369e-002,-2.0446777e-002,-1.6632080e-002,-1.9165039e-002,-2.0874023e-002,-2.2979736e-002,-2.6763916e-002,-2.7130127e-002,-2.7404785e-002,-2.2857666e-002,-1.7883301e-002,-1.4678955e-002,-1.2908936e-002,-1.8066406e-002,-2.1728516e-002,-2.4658203e-002,-2.5573730e-002,-1.9165039e-002,-1.5045166e-002,-1.2756348e-002,-1.3153076e-002,-2.1209717e-002,-2.6611328e-002,-2.8381348e-002,-2.4475098e-002,-1.0528564e-002,-1.9531250e-003,-3.3569336e-003,-1.7425537e-002,-5.2062988e-002,-7.6873779e-002,-8.0902100e-002,-6.5093994e-002,-1.1688232e-002,2.7893066e-002,3.6224365e-002,2.7801514e-002,-2.6916504e-002,-6.0455322e-002,-5.3131104e-002,-4.0649414e-002,1.3153076e-002,3.6804199e-002,1.1657715e-002,-7.3852539e-003,-5.2337646e-002,-6.7871094e-002,-3.3935547e-002,-1.3305664e-002,1.3092041e-002,1.7761230e-002,-2.3681641e-002,-4.9591064e-002,-6.6040039e-002,-6.8756104e-002,-2.7069092e-002,4.5166016e-003,2.4475098e-002,3.4423828e-002,3.6010742e-003,-2.1087646e-002,-3.9733887e-002,-5.0262451e-002,-2.3956299e-002,-6.9885254e-003,1.7395020e-003,1.6479492e-003,-3.1158447e-002,-4.5532227e-002,-4.3609619e-002,-3.3569336e-002,3.2653809e-003,1.8768311e-002,7.3852539e-003,-4.8522949e-003,-3.1677246e-002,-4.3731689e-002,-2.6794434e-002,-2.0690918e-002,-1.2725830e-002,-9.3078613e-003,-2.5329590e-002,-2.6275635e-002,-2.1331787e-002,-1.8585205e-002,-1.0101318e-002,-7.4157715e-003,-1.0345459e-002,-7.0495605e-003,-8.8500977e-004,-1.1596680e-003,-5.6457520e-003,-1.6021729e-002,-2.9663086e-002,-3.3660889e-002,-2.4414063e-002,-1.6113281e-002,-8.6059570e-003,-3.8757324e-003,-1.2451172e-002,-1.3671875e-002,-9.8571777e-003,-1.0589600e-002,-7.3852539e-003,-1.1047363e-002,-1.9866943e-002,-2.1301270e-002,-1.7120361e-002,-1.4465332e-002,-1.1505127e-002,-1.2817383e-002,-1.8554688e-002,-1.7364502e-002,-1.1718750e-002,-9.4604492e-003,-8.3007813e-003,-1.2786865e-002,-2.2979736e-002,-2.5299072e-002,-1.8188477e-002,-1.0498047e-002,1.8310547e-004,5.5236816e-003,-1.8310547e-003,-6.0424805e-003,-1.1718750e-002,-1.8188477e-002,-1.6754150e-002,-1.8218994e-002,-1.8066406e-002,-1.4526367e-002,-1.3275146e-002,-1.3275146e-002,-1.8249512e-002,-2.2521973e-002,-2.4658203e-002,-2.2155762e-002,-1.0528564e-002,-5.1269531e-003,-7.2326660e-003,-1.2603760e-002,-2.5482178e-002,-2.8900146e-002,-1.9165039e-002,-1.1962891e-002,-1.3427734e-003,2.2583008e-003,-8.9721680e-003,-1.2756348e-002,-1.4526367e-002,-1.4739990e-002,-5.7678223e-003,-5.5847168e-003,-1.1901855e-002,-1.6326904e-002,-2.2583008e-002,-2.3345947e-002,-1.7211914e-002,-1.2207031e-002,-7.8430176e-003,-3.9367676e-003,-5.3405762e-003,-4.5776367e-003,-2.0446777e-003,3.6621094e-004,5.5236816e-003,8.0871582e-003,5.1879883e-003,2.1057129e-003,-4.4250488e-003,-8.2702637e-003,-7.4768066e-003,-6.8664551e-003,-5.4016113e-003,-8.3312988e-003,-1.7242432e-002,-2.1759033e-002,-2.1606445e-002,-1.7700195e-002,-5.7678223e-003,6.1035156e-005,-9.1552734e-004,-8.2397461e-004,-2.9602051e-003,-3.0517578e-005,9.3383789e-003,1.0589600e-002,3.7841797e-003,-6.6528320e-003,-2.2766113e-002,-3.0303955e-002,-2.5207520e-002,-1.9378662e-002,-1.0040283e-002,-2.9602051e-003,-5.8593750e-003,-4.3334961e-003,-1.8615723e-003,3.0517578e-005,8.7585449e-003,1.1352539e-002,1.0955811e-002,7.9956055e-003,-4.2724609e-004,-9.5825195e-003,-1.7395020e-002,-2.1057129e-002,-1.8310547e-002,-1.3427734e-002,-1.0040283e-002,-7.3547363e-003,-1.2573242e-002,-1.3397217e-002,-9.7045898e-003,-5.0964355e-003,7.8735352e-003,1.3488770e-002,1.3305664e-002,1.3275146e-002,9.3078613e-003,7.2326660e-003,8.3923340e-003,4.2114258e-003,-4.3945313e-003,-9.0637207e-003,-1.3458252e-002,-1.2908936e-002,-7.2631836e-003,-6.1950684e-003,-9.8266602e-003,-1.2268066e-002,-1.3977051e-002,-9.7961426e-003,3.1738281e-003,9.8266602e-003,1.1322021e-002,9.2468262e-003,5.1879883e-004,-3.2043457e-003,-4.2724609e-004,-1.5563965e-003,-1.3122559e-003,-2.5634766e-003,-1.1383057e-002,-1.4221191e-002,-1.4984131e-002,-1.5808105e-002,-1.2420654e-002,-9.9792480e-003,-6.5612793e-003,-1.5869141e-003,3.9367676e-003,7.1716309e-003,9.2773438e-003,1.0498047e-002,1.1871338e-002,1.2512207e-002,1.3427734e-002,1.0803223e-002,3.0822754e-003,-3.0822754e-003,-9.0637207e-003,-1.1993408e-002,-1.0589600e-002,-9.8876953e-003,-8.7280273e-003,-3.0212402e-003,4.5166016e-003,1.3153076e-002,1.9500732e-002,1.6876221e-002,5.1879883e-003,-6.3171387e-003,-1.1230469e-002,-1.0253906e-002,4.0893555e-003,1.4953613e-002,1.7089844e-002,2.0477295e-002,1.1749268e-002,7.5378418e-003,7.7819824e-003,2.8991699e-003,1.3732910e-003,-1.7089844e-003,-2.6245117e-003,7.6293945e-004,7.1716309e-003,9.4909668e-003,4.6386719e-003,-9.4604492e-004,-1.0467529e-002,-1.3427734e-002,-5.5847168e-003,-4.2724609e-004,5.2185059e-003,8.1787109e-003,3.1127930e-003,3.9367676e-003,7.2937012e-003,6.3171387e-003,5.6762695e-003,-9.4604492e-004,-1.2176514e-002,-1.8310547e-002,-1.6326904e-002,-1.2451172e-002,-3.1738281e-003,4.0588379e-003,2.9602051e-003,6.1340332e-003,7.7209473e-003,9.4604492e-003,1.5869141e-002,1.5991211e-002,1.3519287e-002,1.1474609e-002,8.5144043e-003,8.0871582e-003,1.1322021e-002,1.2207031e-002,9.7961426e-003,6.8969727e-003,-1.8310547e-004,-5.0354004e-003,-5.6152344e-003,-5.4321289e-003,-4.2724609e-004,4.8828125e-003,7.9040527e-003,1.1566162e-002,1.2329102e-002,1.4160156e-002,1.6082764e-002,1.6387939e-002,1.6235352e-002,1.1688232e-002,1.3122559e-003,-5.5847168e-003,-9.3994141e-003,-6.8054199e-003,6.2255859e-003,1.6540527e-002,1.9897461e-002,1.5991211e-002,-2.7160645e-003,-1.4099121e-002,-1.0498047e-002,-1.4648438e-003,2.5970459e-002,4.0313721e-002,3.2592773e-002,2.2613525e-002,-4.1809082e-003,-1.5533447e-002,-3.3569336e-004,9.3994141e-003,2.5054932e-002,2.4566650e-002,-7.3852539e-003,-2.6062012e-002,-3.6529541e-002,-3.1829834e-002,7.3242188e-003,3.1219482e-002,3.8146973e-002,3.7078857e-002,6.7138672e-003,-9.1857910e-003,-1.8615723e-003,2.8076172e-003,2.6641846e-002,3.5461426e-002,1.8524170e-002,7.8430176e-003,-1.3549805e-002,-2.1820068e-002,-7.6293945e-003,1.7089844e-003,1.3366699e-002,1.6052246e-002,-1.0070801e-003,-1.1505127e-002,-1.7028809e-002,-1.7364502e-002,1.5258789e-003,1.2084961e-002,1.5136719e-002,1.5167236e-002,7.3242188e-004,-3.2958984e-003,3.5705566e-003,1.0070801e-002,2.2491455e-002,2.4505615e-002,9.8876953e-003,1.1901855e-003,-8.4228516e-003,-1.2390137e-002,-1.2512207e-003,2.2277832e-003,1.4648438e-003,8.8500977e-004,-6.2561035e-003,-3.4790039e-003,9.1552734e-003,1.6998291e-002,2.3895264e-002,2.2125244e-002,7.5683594e-003,-3.2653809e-003,-9.7656250e-003,-1.4404297e-002,-8.3312988e-003,-3.6315918e-003,-2.5634766e-003,2.6550293e-003,2.3193359e-003,5.5541992e-003,9.2773438e-003,9.6435547e-003,1.2329102e-002,1.2207031e-002,1.4801025e-002,1.6052246e-002,1.7700195e-002,1.8127441e-002,1.4038086e-002,1.0437012e-002,4.0893555e-003,-3.9672852e-004,-1.4648438e-003,-4.2724609e-004,3.8757324e-003,8.9416504e-003,1.2298584e-002,1.6326904e-002,1.8981934e-002,2.2613525e-002,2.8442383e-002,2.9388428e-002,2.6733398e-002,1.8096924e-002,5.0659180e-003,-3.8146973e-003,-4.7912598e-003,1.2207031e-004,1.0772705e-002,1.8798828e-002,1.3885498e-002,7.5073242e-003,-4.3334961e-003,-1.2969971e-002,-9.3994141e-003,-9.5520020e-003,-3.9978027e-003,-2.1362305e-003,-5.3100586e-003,-2.4414063e-003,1.0070801e-003,7.8430176e-003,1.7730713e-002,2.3681641e-002,2.3956299e-002,2.3406982e-002,2.0111084e-002,1.6998291e-002,1.7852783e-002,1.4678955e-002,1.0894775e-002,7.5073242e-003,3.1738281e-003,4.2419434e-003,1.1932373e-002,1.8707275e-002,2.4017334e-002,2.4566650e-002,1.4984131e-002,7.5073242e-003,3.5705566e-003,1.2512207e-003,8.7280273e-003,1.0345459e-002,5.4016113e-003,7.9345703e-004,-1.0742188e-002,-1.4862061e-002,-8.8806152e-003,-2.2888184e-003,8.7890625e-003,1.5350342e-002,1.2786865e-002,1.1810303e-002,1.0437012e-002,1.0467529e-002,1.7822266e-002,1.9378662e-002,1.7547607e-002,1.3336182e-002,2.3193359e-003,-3.1127930e-003,-2.6550293e-003,1.0681152e-003,9.4604492e-003,1.5411377e-002,1.3732910e-002,1.1688232e-002,5.6762695e-003,3.3569336e-003,1.0833740e-002,1.4709473e-002,2.0477295e-002,2.0202637e-002,1.0131836e-002,3.2348633e-003,-1.9836426e-003,-2.8381348e-003,5.6457520e-003,1.1169434e-002,1.1444092e-002,1.1840820e-002,4.8522949e-003,1.3427734e-003,2.9602051e-003,2.5024414e-003,7.9345703e-003,1.1962891e-002,1.5167236e-002,1.9195557e-002,1.9592285e-002,1.7608643e-002,1.3244629e-002,8.6059570e-003,6.8359375e-003,6.6223145e-003,9.4909668e-003,1.0131836e-002,4.9133301e-003,6.7138672e-004,-6.7138672e-003,-1.0711670e-002,-8.6059570e-003,-7.8430176e-003,-5.0659180e-003,-2.8686523e-003,-2.1057129e-003,3.4790039e-003,1.1810303e-002,1.8981934e-002,2.5665283e-002,2.7404785e-002,2.3468018e-002,1.8127441e-002,1.2176514e-002,7.2021484e-003,6.4697266e-003,6.2255859e-003,7.9040527e-003,1.0559082e-002,1.0437012e-002,1.2298584e-002,1.2023926e-002,1.3427734e-002,1.6693115e-002,1.7730713e-002,1.7059326e-002,1.2023926e-002,5.2795410e-003,1.8615723e-003,4.6386719e-003,9.6740723e-003,1.6540527e-002,2.0568848e-002,1.5563965e-002,1.1383057e-002,4.6081543e-003,4.5776367e-004,4.5471191e-003,8.0871582e-003,1.4282227e-002,1.9500732e-002,2.0843506e-002,2.2766113e-002,2.2888184e-002,2.4169922e-002,2.8808594e-002,3.1707764e-002,3.3538818e-002,2.9937744e-002,1.7303467e-002,4.7302246e-003,-5.0964355e-003,-8.8806152e-003,1.8310547e-004,7.3852539e-003,1.0131836e-002,1.2145996e-002,3.1127930e-003,1.8005371e-003,9.8266602e-003,1.3702393e-002,2.1759033e-002,2.2613525e-002,1.6601563e-002,1.8859863e-002,2.5451660e-002,2.9357910e-002,3.0151367e-002,2.0965576e-002,-1.4343262e-003,-1.5136719e-002,-1.6998291e-002,-1.3824463e-002,1.0986328e-003,8.8806152e-003,2.7770996e-003,1.1901855e-003,-4.7912598e-003,-8.7585449e-003,-4.5471191e-003,-7.5378418e-003,-7.7209473e-003,-2.0141602e-003,1.0162354e-002,2.5177002e-002,3.8055420e-002,4.4219971e-002,3.6041260e-002,3.5644531e-002,4.3029785e-002,4.8187256e-002,5.6884766e-002,4.6325684e-002,1.4190674e-002,-1.1413574e-002,-2.8839111e-002,-3.5217285e-002,-1.9409180e-002,-1.4129639e-002,-2.5238037e-002,-2.7038574e-002,-3.3386230e-002,-2.5146484e-002,4.4250488e-003,2.0233154e-002,2.6702881e-002,3.0120850e-002,2.2552490e-002,2.3681641e-002,3.7750244e-002,3.6071777e-002,2.5573730e-002,9.7045898e-003,-1.7944336e-002,-2.9937744e-002,-2.4780273e-002,-2.0263672e-002,-1.2359619e-002,-4.3029785e-003,-5.5236816e-003,5.0354004e-003,2.3010254e-002,3.5003662e-002,4.6234131e-002,4.7271729e-002,4.0893555e-002,3.7933350e-002,4.0954590e-002,3.8269043e-002,3.2409668e-002,2.3254395e-002,5.0659180e-003,-1.9531250e-003,-1.1291504e-003,1.0070801e-003,6.5002441e-003,8.7890625e-003,8.6059570e-003,1.3397217e-002,2.3895264e-002,2.9998779e-002,3.6163330e-002,3.6224365e-002,3.1860352e-002,3.0609131e-002,3.3325195e-002,3.1829834e-002,2.4414063e-002,1.4617920e-002,-4.5471191e-003,-1.4831543e-002,-1.6418457e-002,-1.6326904e-002,-9.4604492e-003,-4.3945313e-003,-4.4555664e-003,7.9345703e-004,7.6904297e-003,1.1840820e-002,1.7974854e-002,1.5747070e-002,9.5214844e-003,4.6081543e-003,3.2653809e-003,5.0354004e-003,1.0589600e-002,1.6815186e-002,1.6571045e-002,1.8859863e-002,1.6479492e-002,1.4892578e-002,1.5289307e-002,1.3183594e-002,1.5197754e-002,1.5777588e-002,1.7822266e-002,1.8859863e-002,2.0263672e-002,2.4139404e-002,3.0853271e-002,3.7841797e-002,4.0740967e-002,3.8543701e-002,2.5024414e-002,1.2664795e-002,3.8146973e-003,-1.1291504e-003,6.4086914e-003,1.1566162e-002,1.1383057e-002,1.3763428e-002,9.3994141e-003,1.0253906e-002,1.8310547e-002,1.9012451e-002,2.1331787e-002,1.7883301e-002,7.7209473e-003,1.5869141e-003,1.0681152e-003,6.7138672e-004,3.6926270e-003,6.3171387e-003,3.1433105e-003,3.9672852e-003,1.2817383e-003,-2.6550293e-003,-7.4157715e-003,-1.3885498e-002,-1.5838623e-002,-1.3702393e-002,-2.0446777e-003,1.0009766e-002,2.0568848e-002,2.8961182e-002,2.9052734e-002,3.1677246e-002,3.6529541e-002,3.8604736e-002,4.2236328e-002,3.8177490e-002,2.7160645e-002,1.8554688e-002,1.0101318e-002,6.1950684e-003,6.8969727e-003,6.1340332e-003,2.5024414e-003,-2.4414063e-004,-5.1574707e-003,-5.8898926e-003,4.2724609e-004,7.1716309e-003,1.8035889e-002,2.7221680e-002,3.2623291e-002,3.7078857e-002,3.8482666e-002,3.8269043e-002,3.7109375e-002,3.5125732e-002,3.3355713e-002,3.1311035e-002,2.7984619e-002,2.4322510e-002,1.8035889e-002,1.3244629e-002,1.0162354e-002,9.0332031e-003,1.2145996e-002,1.2207031e-002,1.2023926e-002,9.9792480e-003,5.6762695e-003,3.2043457e-003,5.1269531e-003,5.5236816e-003,5.7678223e-003,5.6457520e-003,2.3498535e-003,3.5400391e-003,7.8735352e-003,1.3427734e-002,1.7547607e-002,1.7883301e-002,1.2268066e-002,9.9792480e-003,1.1993408e-002,1.6876221e-002,2.9052734e-002,3.4637451e-002,3.2623291e-002,2.8930664e-002,2.0019531e-002,1.5197754e-002,1.8554688e-002,2.0294189e-002,2.2613525e-002,2.3284912e-002,1.8066406e-002,1.6387939e-002,1.6845703e-002,1.8859863e-002,2.3254395e-002,2.5695801e-002,2.6184082e-002,2.6947021e-002,2.7709961e-002,2.6641846e-002,2.4902344e-002,1.9836426e-002,1.0986328e-002,4.0893555e-003,6.1035156e-004,-3.9672852e-004,4.9438477e-003,1.1016846e-002,1.3641357e-002,1.7059326e-002,1.5594482e-002,1.6326904e-002,2.0599365e-002,2.2583008e-002,2.9174805e-002,2.9846191e-002,2.5238037e-002,1.9683838e-002,1.2451172e-002,7.6599121e-003,9.5520020e-003,9.8571777e-003,9.0026855e-003,8.5754395e-003,2.7770996e-003,1.6174316e-003,5.1269531e-003,8.9721680e-003,1.7120361e-002,2.1331787e-002,1.9989014e-002,1.6998291e-002,1.0925293e-002,5.1269531e-003,5.4016113e-003,6.7138672e-003,1.1688232e-002,1.7303467e-002,1.6815186e-002,1.7456055e-002,1.4007568e-002,1.4038086e-002,2.0629883e-002,2.5604248e-002,3.0700684e-002,2.8961182e-002,1.8341064e-002,1.1352539e-002,1.1444092e-002,1.4709473e-002,2.5909424e-002,2.8442383e-002,1.8615723e-002,1.3610840e-002,8.0871582e-003,1.1901855e-002,3.0120850e-002,3.7109375e-002,3.3386230e-002,2.7770996e-002,1.3885498e-002,1.3092041e-002,2.9724121e-002,3.5339355e-002,3.4942627e-002,2.4871826e-002,-1.1901855e-003,-1.1199951e-002,-2.0751953e-003,4.4250488e-003,1.5289307e-002,1.6510010e-002,-8.5449219e-004,-1.7700195e-003,9.0332031e-003,2.1850586e-002,4.2236328e-002,4.5867920e-002,2.9327393e-002,2.1179199e-002,1.9256592e-002,1.8585205e-002,2.9754639e-002,2.6336670e-002,8.0261230e-003,3.3569336e-004,-4.4555664e-003,-1.3732910e-003,1.3397217e-002,1.7486572e-002,1.0650635e-002,1.2786865e-002,1.9531250e-002,3.0548096e-002,5.0537109e-002,5.4412842e-002,4.0496826e-002,3.1860352e-002,2.6245117e-002,2.5390625e-002,3.7384033e-002,3.5369873e-002,1.6876221e-002,5.8898926e-003,-5.1574707e-003,-2.8991699e-003,1.7913818e-002,2.5665283e-002,2.1423340e-002,2.0660400e-002,1.6143799e-002,2.1881104e-002,4.3182373e-002,4.7515869e-002,3.8787842e-002,2.7801514e-002,1.0559082e-002,5.6457520e-003,1.8310547e-002,2.1362305e-002,1.5899658e-002,1.5808105e-002,9.4604492e-003,1.8798828e-002,4.3243408e-002,5.0170898e-002,4.2053223e-002,2.5238037e-002,-9.4604492e-004,-1.0101318e-002,1.0498047e-002,1.9897461e-002,2.4322510e-002,2.1118164e-002,-9.3688965e-003,-1.8066406e-002,-7.9650879e-003,3.2958984e-003,2.8259277e-002,3.8970947e-002,2.6733398e-002,2.1240234e-002,1.3641357e-002,5.9509277e-003,1.1688232e-002,9.6435547e-003,7.8430176e-003,1.4282227e-002,2.2369385e-002,3.0761719e-002,3.2073975e-002,2.7404785e-002,1.4495850e-002,1.0467529e-002,2.1728516e-002,3.1341553e-002,4.4281006e-002,4.4830322e-002,2.5268555e-002,1.2664795e-002,4.6081543e-003,2.3803711e-003,1.4099121e-002,1.7028809e-002,1.1657715e-002,1.2603760e-002,1.2084961e-002,2.0233154e-002,3.9489746e-002,4.7393799e-002,4.1778564e-002,2.7160645e-002,-7.6293945e-004,-2.2521973e-002,-2.4353027e-002,-2.0660400e-002,1.0986328e-003,2.2094727e-002,2.5634766e-002,3.0853271e-002,1.8981934e-002,1.6143799e-002,3.1616211e-002,4.5776367e-002,7.1533203e-002,7.4859619e-002,4.4677734e-002,7.1105957e-003,-3.9794922e-002,-6.4453125e-002,-4.1778564e-002,-1.1993408e-002,2.9907227e-002,5.8227539e-002,3.4698486e-002,2.1667480e-002,5.1879883e-003,-6.1035156e-005,4.2724609e-002,6.3629150e-002,7.6934814e-002,7.3181152e-002,2.6336670e-002,-6.3781738e-003,-2.6184082e-002,-3.4790039e-002,-9.0026855e-003,1.2115479e-002,1.8798828e-002,2.6153564e-002,6.0729980e-003,-2.6855469e-003,5.2185059e-003,1.3275146e-002,4.5654297e-002,6.1248779e-002,5.8441162e-002,4.8034668e-002,1.7883301e-002,1.8310547e-004,4.3640137e-003,1.2512207e-002,3.3599854e-002,4.6417236e-002,3.2745361e-002,2.7526855e-002,1.5930176e-002,1.1352539e-002,2.6885986e-002,2.6672363e-002,2.0385742e-002,1.0131836e-002,-6.2561035e-003,-9.5520020e-003,6.9274902e-003,2.1636963e-002,3.3447266e-002,3.6102295e-002,1.4404297e-002,2.3803711e-003,-2.2583008e-003,-2.8076172e-003,1.4617920e-002,2.2674561e-002,1.7761230e-002,1.5625000e-002,4.8217773e-003,6.4086914e-004,1.0925293e-002,1.8096924e-002,2.9144287e-002,3.4759521e-002,2.9998779e-002,2.5787354e-002,1.8951416e-002,1.4801025e-002,1.9500732e-002,2.5238037e-002,3.4057617e-002,3.7780762e-002,2.9205322e-002,1.9836426e-002,4.7912598e-003,-5.0354004e-003,-2.7160645e-003,-2.1667480e-003,3.2043457e-003,7.0495605e-003,5.0048828e-003,1.1474609e-002,2.1545410e-002,3.0975342e-002,4.0832520e-002,4.1992188e-002,3.4667969e-002,2.8869629e-002,2.6580811e-002,2.4993896e-002,2.9510498e-002,2.9235840e-002,1.8920898e-002,1.3549805e-002,7.1105957e-003,5.9204102e-003,1.4221191e-002,1.7944336e-002,1.7150879e-002,1.7517090e-002,1.4923096e-002,1.4617920e-002,1.9958496e-002,1.8463135e-002,1.3458252e-002,7.8125000e-003,3.0517578e-005,-3.2958984e-003,-1.1291504e-003,-1.5563965e-003,-5.5541992e-003,-7.6904297e-003,-1.1291504e-002,-5.1269531e-003,1.0681152e-002,2.2308350e-002,2.9632568e-002,3.0151367e-002,1.9226074e-002,1.1108398e-002,1.2603760e-002,1.3702393e-002,2.3925781e-002,2.8839111e-002,2.2491455e-002,1.8920898e-002,1.0009766e-002,7.6599121e-003,1.4526367e-002,1.8402100e-002,2.2796631e-002,2.1667480e-002,1.2329102e-002,4.8522949e-003,0.0000000e+000,-3.3874512e-003,1.4343262e-003,3.3874512e-003,3.6315918e-003,5.2490234e-003,2.8076172e-003,6.4697266e-003,1.3488770e-002,1.9714355e-002,2.6916504e-002,3.0059814e-002,2.8289795e-002,2.7526855e-002,2.7557373e-002,2.6672363e-002,2.8015137e-002,2.4902344e-002,1.7883301e-002,1.3275146e-002,8.6059570e-003,8.7890625e-003,1.5502930e-002,2.0416260e-002,2.2155762e-002,1.9561768e-002,6.5307617e-003,-4.4250488e-003,-1.0223389e-002,-1.1474609e-002,2.1667480e-003,1.4068604e-002,2.1697998e-002,2.6397705e-002,1.6937256e-002,1.1749268e-002,1.2695313e-002,1.5106201e-002,2.6458740e-002,3.0364990e-002,2.6519775e-002,2.4291992e-002,1.8249512e-002,1.5777588e-002,1.8157959e-002,1.6174316e-002,1.2573242e-002,1.1138916e-002,1.0803223e-002,1.4526367e-002,2.0080566e-002,1.7517090e-002,4.7912598e-003,-5.7373047e-003,-1.1505127e-002,-9.3688965e-003,8.2092285e-003,1.7028809e-002,1.2695313e-002,8.9111328e-003,-3.1433105e-003,-2.7770996e-003,1.6967773e-002,2.7404785e-002,3.3264160e-002,3.2836914e-002,1.7578125e-002,1.9134521e-002,3.8574219e-002,5.1635742e-002,6.2744141e-002,5.9204102e-002,3.2623291e-002,1.8554688e-002,1.8768311e-002,1.7517090e-002,2.5939941e-002,1.7578125e-002,-1.4709473e-002,-3.4301758e-002,-4.3975830e-002,-4.1900635e-002,-1.6296387e-002,-2.5329590e-003,-6.0729980e-003,-4.8217773e-003,-1.1291504e-002,-8.7890625e-003,1.2878418e-002,2.3254395e-002,2.9724121e-002,3.4179688e-002,2.7313232e-002,2.8747559e-002,3.5247803e-002,3.6682129e-002,3.6621094e-002,3.6132813e-002,3.1494141e-002,2.9144287e-002,2.7587891e-002,1.9866943e-002,8.9721680e-003,2.1057129e-003,1.8920898e-003,6.1035156e-003,1.6601563e-002,1.9683838e-002,9.8571777e-003,5.4931641e-004,-1.4312744e-002,-2.8503418e-002,-3.4851074e-002,-4.7698975e-002,-5.8441162e-002,-5.8410645e-002,-4.7790527e-002,-2.3803711e-002,7.5988770e-003,3.2196045e-002,3.8238525e-002,4.2449951e-002,4.3365479e-002,4.7546387e-002,7.2052002e-002,8.2885742e-002,8.6730957e-002,8.4045410e-002,6.2957764e-002,5.1879883e-002,4.8675537e-002,4.3884277e-002,4.1381836e-002,3.3294678e-002,1.3000488e-002,-1.3732910e-003,-1.2145996e-002,-2.0233154e-002,-1.6845703e-002,-1.6937256e-002,-1.8402100e-002,-2.0935059e-002,-3.0151367e-002,-3.8146973e-002,-4.2877197e-002,-4.2877197e-002,-3.2592773e-002,-2.2491455e-002,-1.5808105e-002,-1.1352539e-002,-1.7547607e-002,-1.0528564e-002,9.9487305e-003,3.2592773e-002,5.9020996e-002,5.9631348e-002,2.2094727e-002,-2.4322510e-002,-7.5439453e-002,-1.0424805e-001,-7.4188232e-002,-3.3508301e-002,2.5054932e-002,8.2183838e-002,9.1247559e-002,1.1199951e-001,1.1843872e-001,1.2408447e-001,1.5789795e-001,1.6110229e-001,1.5402222e-001,1.1941528e-001,4.7668457e-002,-2.0446777e-002,-8.2794189e-002,-1.2667847e-001,-1.3525391e-001,-1.3204956e-001,-1.2814331e-001,-1.1352539e-001,-1.1880493e-001,-1.0678101e-001,-7.5317383e-002,-4.0466309e-002,2.5695801e-002,7.3547363e-002,1.0864258e-001,1.3070679e-001,1.2698364e-001,1.2200928e-001,1.1737061e-001,1.0653687e-001,9.5336914e-002,7.9742432e-002,4.6417236e-002,2.0507813e-002,-1.1108398e-002,-3.5034180e-002,-4.5227051e-002,-5.4840088e-002,-5.3527832e-002,-5.5969238e-002,-6.0485840e-002,-6.7901611e-002,-7.1868896e-002,-7.1228027e-002,-5.1177979e-002,-2.4139404e-002,7.8735352e-003,3.9703369e-002,4.9926758e-002,6.3049316e-002,6.2011719e-002,6.3049316e-002,7.2174072e-002,6.7199707e-002,5.7464600e-002,3.4240723e-002,-1.9531250e-003,-3.3599854e-002,-5.3039551e-002,-6.4147949e-002,-5.6121826e-002,-4.5654297e-002,-3.8421631e-002,-2.5177002e-002,-2.0935059e-002,-9.1247559e-003,9.7961426e-003,2.7984619e-002,5.3314209e-002,6.7199707e-002,6.6497803e-002,5.7861328e-002,3.6010742e-002,2.0324707e-002,1.9683838e-002,2.2979736e-002,3.5949707e-002,3.9184570e-002,1.8096924e-002,-2.4719238e-003,-3.1677246e-002,-5.1635742e-002,-4.4097900e-002,-4.3792725e-002,-3.7170410e-002,-3.4973145e-002,-4.9102783e-002,-4.7241211e-002,-3.6132813e-002,-1.8585205e-002,1.2207031e-002,3.8452148e-002,5.5786133e-002,7.8948975e-002,9.7442627e-002,1.1123657e-001,1.2017822e-001,1.1074829e-001,8.8195801e-002,6.3171387e-002,4.2846680e-002,1.9287109e-002,4.5776367e-004,-2.7130127e-002,-6.8572998e-002,-9.2864990e-002,-1.0458374e-001,-9.7351074e-002,-6.6986084e-002,-4.3792725e-002,-3.6163330e-002,-2.5878906e-002,-2.2613525e-002,-1.0040283e-002,2.7191162e-002,4.7760010e-002,6.1096191e-002,6.5246582e-002,4.8889160e-002,4.7363281e-002,5.9661865e-002,6.7138672e-002,7.2113037e-002,6.2530518e-002,2.2766113e-002,-1.0711670e-002,-3.7628174e-002,-6.1279297e-002,-5.7220459e-002,-5.6060791e-002,-5.2276611e-002,-3.5247803e-002,-2.1057129e-002,6.7138672e-004,2.2857666e-002,3.7384033e-002,4.5227051e-002,4.8217773e-002,5.0445557e-002,4.8614502e-002,5.0079346e-002,4.6752930e-002,3.5125732e-002,2.3223877e-002,2.7770996e-003,-1.7517090e-002,-3.7414551e-002,-5.4534912e-002,-6.3049316e-002,-6.6864014e-002,-6.4575195e-002,-6.5551758e-002,-7.1014404e-002,-7.2753906e-002,-6.8664551e-002,-5.2581787e-002,-1.8920898e-002,1.1077881e-002,3.0761719e-002,4.4219971e-002,3.8787842e-002,4.2816162e-002,5.9173584e-002,6.9824219e-002,8.4014893e-002,8.1390381e-002,5.4412842e-002,3.2745361e-002,1.0589600e-002,-9.2773438e-003,-1.4251709e-002,-3.0334473e-002,-5.3253174e-002,-6.9000244e-002,-8.3038330e-002,-8.2733154e-002,-6.5185547e-002,-4.5379639e-002,-2.3345947e-002,2.9602051e-003,2.4627686e-002,4.7515869e-002,6.9732666e-002,8.4503174e-002,9.7564697e-002,1.0858154e-001,1.2020874e-001,1.2579346e-001,1.2445068e-001,1.1019897e-001,7.7423096e-002,4.5776367e-002,1.3732910e-002,-1.4648438e-002,-3.0883789e-002,-5.0231934e-002,-6.9824219e-002,-7.8796387e-002,-8.2672119e-002,-7.3791504e-002,-5.3100586e-002,-3.5095215e-002,-1.9927979e-002,-6.5002441e-003,3.6010742e-003,1.3671875e-002,2.8625488e-002,3.5858154e-002,3.9794922e-002,4.1137695e-002,3.3752441e-002,2.4353027e-002,6.5612793e-003,-1.7486572e-002,-4.7027588e-002,-7.0495605e-002,-8.2672119e-002,-8.7860107e-002,-8.1359863e-002,-7.5927734e-002,-7.5622559e-002,-6.6284180e-002,-5.1544189e-002,-2.7557373e-002,1.2329102e-002,4.5257568e-002,7.0373535e-002,8.9477539e-002,9.1369629e-002,9.0789795e-002,8.8134766e-002,7.3638916e-002,5.6518555e-002,3.5308838e-002,8.9416504e-003,-1.1779785e-002,-3.0822754e-002,-4.8309326e-002,-6.3934326e-002,-7.5073242e-002,-8.0596924e-002,-7.7301025e-002,-6.1676025e-002,-4.4097900e-002,-2.1026611e-002,1.6174316e-003,2.2491455e-002,4.3518066e-002,6.2042236e-002,7.7636719e-002,8.9965820e-002,1.0043335e-001,1.0733032e-001,1.0910034e-001,1.0058594e-001,8.5021973e-002,5.9600830e-002,3.5736084e-002,1.9348145e-002,5.1574707e-003,-5.7983398e-004,-9.8571777e-003,-2.4749756e-002,-3.5919189e-002,-4.5471191e-002,-4.7637939e-002,-3.7994385e-002,-2.9541016e-002,-2.2918701e-002,-1.7822266e-002,-1.7150879e-002,-1.2390137e-002,-9.7656250e-004,1.1444092e-002,2.5756836e-002,3.4149170e-002,3.0059814e-002,2.2979736e-002,1.1077881e-002,2.8991699e-003,7.4768066e-003,9.1857910e-003,1.2115479e-002,4.7607422e-003,-2.1423340e-002,-4.1107178e-002,-5.3466797e-002,-5.2642822e-002,-2.5238037e-002,-8.3618164e-003,-8.0261230e-003,-1.1810303e-002,-3.9245605e-002,-4.6813965e-002,-2.3773193e-002,-3.6010742e-003,3.2165527e-002,5.2337646e-002,4.0222168e-002,4.0130615e-002,3.7109375e-002,3.4637451e-002,4.7180176e-002,3.5675049e-002,5.1574707e-003,-2.2399902e-002,-5.2062988e-002,-6.6131592e-002,-5.4382324e-002,-4.5776367e-002,-4.0252686e-002,-2.6245117e-002,-2.0172119e-002,1.5869141e-003,3.9978027e-002,6.9458008e-002,9.6710205e-002,1.0913086e-001,1.0052490e-001,8.5998535e-002,6.8695068e-002,4.6051025e-002,3.3569336e-002,2.4414063e-002,1.7120361e-002,1.5533447e-002,2.0446777e-003,-9.4604492e-003,-2.6885986e-002,-3.5888672e-002,-2.7374268e-002,-2.3986816e-002,-1.5106201e-002,-1.9439697e-002,-3.7017822e-002,-4.1992188e-002,-3.1005859e-002,-1.3336182e-002,1.5380859e-002,2.8015137e-002,9.8571777e-003,1.0681152e-003,-1.0009766e-002,-8.2397461e-003,1.7089844e-002,2.0996094e-002,5.2185059e-003,-9.6130371e-003,-3.0242920e-002,-3.0944824e-002,3.3569336e-004,1.4617920e-002,1.4007568e-002,5.3405762e-003,-2.6672363e-002,-3.8208008e-002,-2.0660400e-002,-1.2145996e-002,-7.0190430e-004,1.4648438e-003,-2.1606445e-002,-2.4658203e-002,-1.4801025e-002,-9.7961426e-003,4.2724609e-004,1.2207031e-004,-1.1840820e-002,-5.3100586e-003,1.9470215e-002,3.7658691e-002,5.2917480e-002,5.0415039e-002,2.2857666e-002,1.2329102e-002,2.4566650e-002,3.5766602e-002,5.7495117e-002,5.8654785e-002,2.2705078e-002,3.8757324e-003,-6.8664551e-003,-7.0190430e-003,2.2918701e-002,3.6376953e-002,3.4332275e-002,3.9550781e-002,3.4118652e-002,3.4820557e-002,4.7515869e-002,4.1229248e-002,2.7404785e-002,1.5960693e-002,5.8288574e-003,1.6784668e-003,2.3498535e-003,-9.4299316e-003,-3.8116455e-002,-5.5023193e-002,-6.2011719e-002,-5.7800293e-002,-3.6621094e-002,-2.9205322e-002,-4.2175293e-002,-4.5806885e-002,-4.3579102e-002,-2.8350830e-002,1.5167236e-002,3.9245605e-002,4.2419434e-002,4.7210693e-002,3.7719727e-002,4.1168213e-002,6.4239502e-002,6.5429688e-002,5.0689697e-002,3.1616211e-002,-1.4038086e-003,-1.4038086e-002,-2.7465820e-004,8.5449219e-004,-5.7373047e-003,-1.7639160e-002,-4.5623779e-002,-5.1025391e-002,-2.7038574e-002,-1.2329102e-002,2.0751953e-003,2.5329590e-003,-2.3773193e-002,-3.2287598e-002,-2.2491455e-002,-1.6967773e-002,-1.5869141e-003,1.8920898e-003,-1.3824463e-002,-8.7280273e-003,1.0406494e-002,3.2470703e-002,6.0699463e-002,6.9519043e-002,5.1269531e-002,3.8238525e-002,3.2897949e-002,2.9541016e-002,4.5593262e-002,4.8034668e-002,3.5156250e-002,2.9602051e-002,1.5930176e-002,7.6293945e-003,6.4392090e-003,-2.3803711e-003,-1.4648438e-002,-1.9439697e-002,-1.7913818e-002,-1.4129639e-002,-8.4533691e-003,-1.4831543e-002,-3.5400391e-002,-4.9774170e-002,-5.2368164e-002,-4.9621582e-002,-3.3233643e-002,-2.5909424e-002,-3.5766602e-002,-3.6010742e-002,-3.4332275e-002,-2.1667480e-002,8.3312988e-003,2.6275635e-002,3.0364990e-002,3.3935547e-002,3.0487061e-002,3.1097412e-002,4.4128418e-002,4.1931152e-002,2.8930664e-002,1.5594482e-002,-3.2653809e-003,-8.1481934e-003,6.4086914e-003,1.7547607e-002,2.5115967e-002,3.1005859e-002,1.9165039e-002,1.2512207e-002,9.9182129e-003,-4.4860840e-003,-1.7181396e-002,-3.5644531e-002,-5.0903320e-002,-5.1818848e-002,-3.6193848e-002,-1.6815186e-002,-3.2958984e-003,8.4838867e-003,1.7395020e-003,4.1198730e-003,1.8493652e-002,2.7557373e-002,4.6264648e-002,5.0170898e-002,3.7384033e-002,2.7160645e-002,1.6326904e-002,1.2207031e-002,2.2796631e-002,3.0761719e-002,3.1494141e-002,3.1311035e-002,1.5441895e-002,1.5563965e-003,-8.0871582e-003,-1.8341064e-002,-1.4068604e-002,-1.1932373e-002,-7.9345703e-003,-6.0424805e-003,-1.6082764e-002,-2.4749756e-002,-3.4851074e-002,-4.0466309e-002,-3.3721924e-002,-2.8747559e-002,-2.5451660e-002,-2.3925781e-002,-3.2623291e-002,-3.1280518e-002,-1.9622803e-002,-3.2958984e-003,2.3345947e-002,3.8757324e-002,3.6041260e-002,3.0151367e-002,1.6693115e-002,1.1688232e-002,2.8137207e-002,3.8391113e-002,4.9530029e-002,5.3741455e-002,3.6102295e-002,2.8015137e-002,2.5421143e-002,2.2705078e-002,2.9968262e-002,2.2644043e-002,-2.1362305e-003,-2.2064209e-002,-3.9764404e-002,-4.4586182e-002,-2.2857666e-002,-8.6975098e-003,-3.6010742e-003,1.5258789e-004,-1.5228271e-002,-1.4282227e-002,6.9274902e-003,2.1087646e-002,4.1687012e-002,4.3487549e-002,1.4648438e-002,-7.6599121e-003,-2.7160645e-002,-3.7475586e-002,-1.8829346e-002,-6.9274902e-003,-3.5095215e-003,4.8828125e-003,-3.9672852e-003,3.9672852e-004,1.8890381e-002,3.1555176e-002,5.1147461e-002,5.8105469e-002,5.1452637e-002,4.4158936e-002,3.6224365e-002,2.8839111e-002,2.7191162e-002,2.0202637e-002,5.1574707e-003,-7.2631836e-003,-2.2796631e-002,-2.8076172e-002,-2.3254395e-002,-1.8859863e-002,-1.5808105e-002,-2.1331787e-002,-3.9550781e-002,-5.7373047e-002,-6.7565918e-002,-7.1411133e-002,-5.2581787e-002,-3.1646729e-002,-1.1138916e-002,1.2023926e-002,1.7700195e-002,2.9357910e-002,4.0344238e-002,4.7973633e-002,6.4727783e-002,7.3272705e-002,7.9498291e-002,8.3160400e-002,7.9528809e-002,7.3913574e-002,6.6406250e-002,5.4473877e-002,4.0130615e-002,2.3956299e-002,7.9345703e-003,-7.0800781e-003,-2.0263672e-002,-3.1280518e-002,-4.1351318e-002,-4.8797607e-002,-5.6671143e-002,-6.4086914e-002,-6.7810059e-002,-6.7230225e-002,-5.7617188e-002,-4.1259766e-002,-1.8676758e-002,4.0588379e-003,2.1209717e-002,3.4393311e-002,3.7658691e-002,4.0588379e-002,4.5898438e-002,4.8950195e-002,5.7373047e-002,5.8746338e-002,5.0598145e-002,4.2144775e-002,2.7832031e-002,2.0446777e-002,2.4505615e-002,2.9785156e-002,3.9031982e-002,4.3212891e-002,3.4179688e-002,2.3986816e-002,1.0650635e-002,-5.6762695e-003,-1.4892578e-002,-3.1158447e-002,-4.9804688e-002,-6.4392090e-002,-7.5592041e-002,-7.1044922e-002,-5.2032471e-002,-2.8320313e-002,-1.1413574e-002,1.9531250e-003,-6.7138672e-004,-1.9836426e-003,7.5683594e-003,1.2481689e-002,3.0120850e-002,3.8696289e-002,3.7292480e-002,4.0893555e-002,4.0832520e-002,4.7485352e-002,5.7800293e-002,6.2286377e-002,5.5847168e-002,4.7637939e-002,3.2958984e-002,1.7974854e-002,9.4604492e-003,-5.1879883e-003,-1.8188477e-002,-3.0120850e-002,-4.0130615e-002,-4.3762207e-002,-4.3334961e-002,-4.2633057e-002,-4.6264648e-002,-4.7241211e-002,-4.6844482e-002,-4.1961670e-002,-2.7496338e-002,-1.6448975e-002,-6.2255859e-003,7.7819824e-003,2.2644043e-002,4.4128418e-002,7.0068359e-002,8.8806152e-002,9.5794678e-002,9.5458984e-002,8.4777832e-002,7.0556641e-002,5.8197021e-002,3.4820557e-002,6.8969727e-003,-1.8066406e-002,-3.7109375e-002,-3.8970947e-002,-2.3925781e-002,-1.2023926e-002,-1.5014648e-002,-2.4383545e-002,-5.1422119e-002,-6.7657471e-002,-5.5267334e-002,-4.4921875e-002,-1.6693115e-002,1.3122559e-003,-5.0354004e-003,9.4604492e-004,4.0588379e-003,1.4617920e-002,3.8909912e-002,4.7454834e-002,4.0405273e-002,3.0120850e-002,1.2023926e-002,3.2043457e-003,1.4678955e-002,1.9073486e-002,2.1331787e-002,1.9622803e-002,-5.7983398e-004,-9.9792480e-003,-7.5683594e-003,-4.1198730e-003,1.0345459e-002,1.2298584e-002,-6.5307617e-003,-2.5177002e-002,-4.8767090e-002,-5.7952881e-002,-3.5705566e-002,-1.1444092e-002,1.7944336e-002,4.0466309e-002,2.9479980e-002,2.2613525e-002,1.2390137e-002,2.7160645e-003,1.8554688e-002,2.0202637e-002,1.9348145e-002,1.9531250e-002,6.9274902e-003,1.0742188e-002,2.4993896e-002,3.6956787e-002,4.6295166e-002,4.4403076e-002,2.4169922e-002,7.1716309e-003,-2.6855469e-003,-1.1474609e-002,-4.4250488e-003,-3.4790039e-003,-8.1481934e-003,-7.3242188e-003,-1.2603760e-002,-1.0711670e-002,-3.0822754e-003,3.7231445e-003,1.5197754e-002,2.7191162e-002,3.9154053e-002,4.6783447e-002,4.5928955e-002,3.8146973e-002,2.3284912e-002,1.0192871e-002,6.2866211e-003,2.1972656e-003,5.4931641e-004,-3.5400391e-003,-1.8493652e-002,-2.3803711e-002,-2.3345947e-002,-1.8920898e-002,-6.0119629e-003,-1.9531250e-003,-8.3007813e-003,-1.3061523e-002,-1.6448975e-002,-1.5258789e-002,9.7656250e-004,7.5378418e-003,4.8522949e-003,2.7465820e-003,-9.8876953e-003,-1.0070801e-002,3.9978027e-003,1.3427734e-002,2.1972656e-002,2.2338867e-002,6.2866211e-003,-1.3732910e-003,3.0517578e-004,3.5095215e-003,2.0935059e-002,2.9357910e-002,2.6428223e-002,2.5451660e-002,1.5838623e-002,9.1552734e-003,8.0566406e-003,-1.0681152e-003,-1.1566162e-002,-2.2125244e-002,-3.4057617e-002,-3.9031982e-002,-3.7536621e-002,-3.4729004e-002,-3.2073975e-002,-2.4108887e-002,-1.3214111e-002,4.0893555e-003,2.7740479e-002,4.1900635e-002,4.2968750e-002,3.4210205e-002,1.7364502e-002,7.1411133e-003,1.6876221e-002,2.4536133e-002,3.2897949e-002,3.4393311e-002,1.0620117e-002,9.1552734e-005,-3.7231445e-003,-2.9907227e-003,1.4190674e-002,1.5106201e-002,-2.0751953e-003,-1.6723633e-002,-3.4515381e-002,-4.0557861e-002,-2.2277832e-002,-1.6662598e-002,-2.1697998e-002,-2.9022217e-002,-5.2337646e-002,-5.8166504e-002,-4.0740967e-002,-2.4230957e-002,2.4414063e-004,1.7303467e-002,1.3153076e-002,1.7364502e-002,2.2857666e-002,2.5451660e-002,3.9459229e-002,4.2724609e-002,4.1351318e-002,4.3670654e-002,4.0924072e-002,3.7536621e-002,2.9510498e-002,1.6448975e-002,-4.8828125e-004,-1.1962891e-002,-1.5319824e-002,-1.9531250e-002,-2.3956299e-002,-3.2318115e-002,-4.6569824e-002,-5.1879883e-002,-4.4982910e-002,-3.6315918e-002,-2.0843506e-002,-9.9792480e-003,-9.3383789e-003,-2.2888184e-003,6.6833496e-003,1.6967773e-002,3.3569336e-002,4.2510986e-002,4.4281006e-002,4.6661377e-002,4.4555664e-002,4.3609619e-002,4.4891357e-002,4.5318604e-002,4.9774170e-002,5.5389404e-002,5.9173584e-002,5.3955078e-002,3.1890869e-002,5.5541992e-003,-2.1331787e-002,-4.0954590e-002,-3.8116455e-002,-4.1015625e-002,-4.9774170e-002,-5.2246094e-002,-6.0455322e-002,-4.1656494e-002,2.6550293e-003,3.5064697e-002,4.7668457e-002,3.3813477e-002,-1.5014648e-002,-4.2419434e-002,-2.0721436e-002,7.1411133e-003,6.4086914e-002,9.2987061e-002,5.7556152e-002,3.7841797e-002,8.6975098e-003,-3.2043457e-003,3.4027100e-002,3.9947510e-002,2.6550293e-002,1.2878418e-002,-2.1148682e-002,-3.0181885e-002,-9.1247559e-003,-4.6081543e-003,-1.0345459e-002,-2.2491455e-002,-5.3039551e-002,-6.1126709e-002,-3.7536621e-002,-1.7242432e-002,8.5754395e-003,2.7923584e-002,2.1026611e-002,2.0233154e-002,1.8371582e-002,1.0559082e-002,1.9378662e-002,3.4942627e-002,6.5307617e-002,9.1033936e-002,8.6303711e-002,4.5410156e-002,-5.0354004e-002,-1.2771606e-001,-1.4733887e-001,-1.2033081e-001,-5.1574707e-003,8.2519531e-002,8.8317871e-002,8.0505371e-002,-3.8757324e-003,-4.5745850e-002,1.0131836e-002,3.1341553e-002,7.7972412e-002,6.9885254e-002,-3.6193848e-002,-9.1613770e-002,-1.1264038e-001,-1.0388184e-001,-2.8991699e-002,3.1433105e-003,-3.6529541e-002,-5.5450439e-002,-8.6364746e-002,-7.5164795e-002,2.7008057e-002,9.2498779e-002,1.3430786e-001,1.4566040e-001,7.4798584e-002,2.1606445e-002,2.4414063e-003,-1.4678955e-002,2.7435303e-002,5.8746338e-002,5.2246094e-002,4.7821045e-002,-1.6479492e-002,-6.8084717e-002,-9.1857910e-002,-1.0095215e-001,-4.2266846e-002,4.9743652e-003,3.1646729e-002,4.1137695e-002,-8.1787109e-003,-3.6224365e-002,-2.3559570e-002,-2.7465820e-003,6.6711426e-002,1.0644531e-001,8.7097168e-002,7.2326660e-002,2.3010254e-002,-4.3945313e-003,1.5319824e-002,1.2969971e-002,8.7585449e-003,-7.6599121e-003,-5.6518555e-002,-7.7972412e-002,-6.8054199e-002,-4.8614502e-002,7.0190430e-004,3.8055420e-002,4.5532227e-002,4.8339844e-002,2.5451660e-002,-6.1035156e-005,-7.8125000e-003,-1.6479492e-002,-2.7465820e-004,1.2115479e-002,6.4392090e-003,-5.4931641e-004,-3.6773682e-002,-5.3649902e-002,-4.3731689e-002,-2.4871826e-002,2.2247314e-002,4.5288086e-002,3.1219482e-002,1.3061523e-002,-1.9165039e-002,-3.6010742e-002,-7.4462891e-003,7.4768066e-003,2.0080566e-002,2.5939941e-002,-8.4838867e-003,-1.9897461e-002,-1.7486572e-002,-1.3977051e-002,9.2773438e-003,1.9226074e-002,1.2481689e-002,1.2176514e-002,9.4604492e-003,5.9814453e-003,1.1901855e-002,4.0893555e-003,-9.5825195e-003,-2.1636963e-002,-3.4637451e-002,-4.0496826e-002,-4.0466309e-002,-3.7109375e-002,-3.3142090e-002,-2.0599365e-002,-5.9814453e-003,1.0345459e-002,2.3956299e-002,3.1219482e-002,3.2836914e-002,3.1677246e-002,3.5919189e-002,3.2714844e-002,3.1768799e-002,2.5299072e-002,1.3000488e-002,1.1383057e-002,1.4129639e-002,2.1820068e-002,2.7313232e-002,2.4078369e-002,4.5776367e-003,-1.0070801e-002,-1.6540527e-002,-1.8127441e-002,-2.8076172e-003,1.0986328e-003,-1.0681152e-002,-2.5054932e-002,-4.7180176e-002,-5.3070068e-002,-3.0364990e-002,-6.0119629e-003,2.3132324e-002,4.3212891e-002,3.2897949e-002,2.8442383e-002,2.4200439e-002,2.0904541e-002,3.7872314e-002,3.8238525e-002,2.6184082e-002,1.4068604e-002,-8.4838867e-003,-1.7822266e-002,-1.1474609e-002,-1.1749268e-002,-1.6876221e-002,-2.2583008e-002,-3.5125732e-002,-2.8320313e-002,5.1269531e-003,3.0578613e-002,4.7973633e-002,4.0771484e-002,-8.0566406e-003,-4.5593262e-002,-5.8166504e-002,-5.9600830e-002,-1.9561768e-002,5.7678223e-003,-4.5166016e-003,-5.0659180e-003,-3.2226563e-002,-4.0924072e-002,-1.5625000e-002,-9.8571777e-003,-2.3498535e-003,-3.7536621e-003,-1.9256592e-002,-1.0833740e-002,2.5848389e-002,5.6945801e-002,8.1481934e-002,8.3923340e-002,4.0557861e-002,9.0942383e-003,-2.8381348e-003,-8.9111328e-003,2.1942139e-002,3.1829834e-002,5.5236816e-003,-1.6510010e-002,-6.0028076e-002,-7.9986572e-002,-5.4534912e-002,-2.9083252e-002,1.2420654e-002,4.1778564e-002,3.0090332e-002,1.6174316e-002,-1.1993408e-002,-3.9306641e-002,-3.3843994e-002,-2.9663086e-002,-7.0495605e-003,1.7486572e-002,2.0294189e-002,3.3752441e-002,3.2043457e-002,3.8513184e-002,5.8288574e-002,6.4727783e-002,6.9152832e-002,5.5419922e-002,2.7130127e-002,6.1645508e-003,5.4016113e-003,1.2481689e-002,3.2104492e-002,3.5949707e-002,-1.5869141e-003,-3.7475586e-002,-7.9833984e-002,-9.8358154e-002,-6.0302734e-002,-2.6123047e-002,6.2255859e-003,2.3590088e-002,-1.2207031e-002,-3.2928467e-002,-3.4515381e-002,-2.7954102e-002,2.6855469e-002,6.0577393e-002,6.3507080e-002,6.3690186e-002,2.7984619e-002,6.7749023e-003,1.1444092e-002,5.7067871e-003,9.7351074e-003,3.5400391e-003,-2.3132324e-002,-3.1768799e-002,-2.5299072e-002,-1.1627197e-002,1.4465332e-002,2.3101807e-002,4.6081543e-003,-1.2969971e-002,-3.1250000e-002,-3.7292480e-002,-6.8054199e-003,1.7639160e-002,3.5644531e-002,4.7607422e-002,2.2583008e-002,4.2419434e-003,-1.0345459e-002,-2.6489258e-002,-1.9256592e-002,-1.7608643e-002,-1.6815186e-002,-9.7351074e-003,-1.0620117e-002,-7.4768066e-003,-3.8757324e-003,-3.0822754e-003,8.2397461e-004,5.9204102e-003,1.6540527e-002,2.6763916e-002,3.7750244e-002,4.4372559e-002,4.2358398e-002,4.1992188e-002,3.7963867e-002,3.2073975e-002,2.4414063e-002,1.0070801e-002,-7.7514648e-003,-2.3132324e-002,-3.2379150e-002,-3.7750244e-002,-3.6651611e-002,-3.7475586e-002,-4.5288086e-002,-4.7271729e-002,-4.3792725e-002,-2.9418945e-002,4.5776367e-003,3.6071777e-002,6.0394287e-002,7.3791504e-002,5.8898926e-002,3.8940430e-002,1.7639160e-002,-3.2958984e-003,-2.4414063e-004,4.2419434e-003,1.2268066e-002,2.2003174e-002,1.1291504e-002,4.9743652e-003,-8.9721680e-003,-2.2094727e-002,-1.7944336e-002,-2.0782471e-002,-1.5930176e-002,-1.3977051e-002,-1.7517090e-002,-1.4282227e-002,-1.1322021e-002,-8.8195801e-003,-8.9721680e-003,-1.2481689e-002,-2.2552490e-002,-2.5421143e-002,-2.0111084e-002,-1.2481689e-002,1.3427734e-003,1.0192871e-002,9.0637207e-003,1.1474609e-002,1.5106201e-002,1.8554688e-002,3.1372070e-002,3.4454346e-002,2.9388428e-002,2.3345947e-002,1.0192871e-002,-4.5776367e-004,-6.5612793e-003,-1.6052246e-002,-2.6916504e-002,-3.1799316e-002,-3.5491943e-002,-3.0517578e-002,-1.8035889e-002,-8.2702637e-003,-2.3193359e-003,2.1057129e-003,4.9743652e-003,8.8195801e-003,1.8890381e-002,2.1148682e-002,1.7395020e-002,8.2702637e-003,-8.3007813e-003,-2.0080566e-002,-2.3620605e-002,-2.0751953e-002,-1.0406494e-002,3.6926270e-003,9.4299316e-003,1.0406494e-002,-3.2348633e-003,-2.3376465e-002,-3.7017822e-002,-4.1351318e-002,-1.5899658e-002,1.2908936e-002,4.2633057e-002,5.9112549e-002,3.4851074e-002,1.1657715e-002,-1.4129639e-002,-3.0303955e-002,-7.8125000e-003,3.0517578e-003,4.3945313e-003,7.9345703e-004,-3.5034180e-002,-5.0292969e-002,-4.2419434e-002,-3.0944824e-002,3.1738281e-003,2.0507813e-002,9.9487305e-003,5.2795410e-003,-1.4953613e-003,3.6010742e-003,4.0039063e-002,5.9509277e-002,5.9387207e-002,4.7302246e-002,2.9907227e-003,-2.1240234e-002,-1.2542725e-002,2.9602051e-003,4.1412354e-002,5.9417725e-002,3.1524658e-002,9.0026855e-003,-2.1484375e-002,-3.2684326e-002,7.6599121e-003,2.8747559e-002,3.8879395e-002,3.3050537e-002,-1.7150879e-002,-4.2968750e-002,-3.7689209e-002,-2.7374268e-002,1.2969971e-002,3.5156250e-002,1.7272949e-002,9.3688965e-003,-1.0253906e-002,-2.2521973e-002,-4.8828125e-003,-4.7302246e-003,-9.3994141e-003,-1.2176514e-002,-2.4505615e-002,-2.4627686e-002,-8.7280273e-003,1.3122559e-003,4.9438477e-003,8.0871582e-003,-3.6621094e-004,-4.5166016e-003,-7.0190430e-004,-4.2419434e-003,-4.4555664e-003,-2.7465820e-004,5.4626465e-003,1.7547607e-002,2.9663086e-002,2.9022217e-002,1.0467529e-002,-6.0119629e-003,-1.7669678e-002,-1.9897461e-002,1.1596680e-003,8.6669922e-003,-2.4414063e-003,-1.5411377e-002,-4.6325684e-002,-5.9448242e-002,-4.1473389e-002,-2.6611328e-002,-3.9367676e-003,1.1383057e-002,-2.0141602e-003,-6.5917969e-003,-9.2773438e-003,-1.5899658e-002,-6.1645508e-003,-5.7678223e-003,-9.7351074e-003,-9.6740723e-003,-1.3977051e-002,-1.7578125e-002,-2.4078369e-002,-3.2104492e-002,-4.2144775e-002,-4.4952393e-002,-3.4454346e-002,-2.3986816e-002,-1.0864258e-002,1.5258789e-004,-1.8920898e-003,-2.7465820e-004,3.2348633e-003,-5.4931641e-004,-1.0986328e-003,-8.5754395e-003,-2.0782471e-002,-2.0751953e-002,-1.0192871e-002,6.3171387e-003,2.6550293e-002,3.8330078e-002,2.9632568e-002,2.4810791e-002,2.2186279e-002,2.0141602e-002,3.6010742e-002,3.8391113e-002,2.7984619e-002,1.5319824e-002,-1.0314941e-002,-2.7984619e-002,-2.9144287e-002,-2.8747559e-002,-2.1484375e-002,-1.1932373e-002,-1.3061523e-002,-8.4228516e-003,-4.4860840e-003,-3.6315918e-003,1.0681152e-003,-8.5449219e-004,-2.6855469e-003,-6.7443848e-003,-1.0314941e-002,-1.4068604e-002,-1.8829346e-002,-1.9256592e-002,-1.6754150e-002,-6.9580078e-003,9.3078613e-003,2.5756836e-002,3.3721924e-002,3.8085938e-002,3.2623291e-002,2.3284912e-002,2.1636963e-002,1.3153076e-002,9.9182129e-003,4.1503906e-003,-8.1176758e-003,-1.3824463e-002,-1.9439697e-002,-2.0507813e-002,-1.8371582e-002,-1.4068604e-002,-1.0803223e-002,-4.3945313e-003,2.9602051e-003,5.0354004e-003,3.2043457e-003,-3.2958984e-003,-1.1108398e-002,-1.4221191e-002,-4.4555664e-003,3.9062500e-003,8.1787109e-003,9.2773438e-003,-6.0119629e-003,-1.2481689e-002,-7.1716309e-003,-6.7138672e-004,1.7547607e-002,2.3132324e-002,7.9650879e-003,-5.0659180e-003,-2.0935059e-002,-3.3050537e-002,-2.8137207e-002,-3.1890869e-002,-4.1259766e-002,-4.3060303e-002,-4.6569824e-002,-3.5064697e-002,-9.3078613e-003,9.6740723e-003,1.6479492e-002,1.5930176e-002,2.2888184e-003,-8.0261230e-003,-1.9531250e-003,-3.5095215e-003,-2.1972656e-003,-2.9296875e-003,-1.4373779e-002,-1.3885498e-002,-7.2326660e-003,-7.6293945e-004,6.0424805e-003,9.4299316e-003,5.6762695e-003,6.6528320e-003,1.6052246e-002,1.6937256e-002,1.3580322e-002,2.5024414e-003,-1.7639160e-002,-2.5695801e-002,-1.4587402e-002,-6.4086914e-004,1.7669678e-002,2.7526855e-002,9.6740723e-003,-3.0517578e-003,-1.4099121e-002,-2.3010254e-002,-7.9040527e-003,-2.5634766e-003,-3.3569336e-003,-6.4086914e-004,-8.8195801e-003,-9.5825195e-003,-1.4648438e-003,-3.0517578e-004,-1.4038086e-003,-4.9438477e-003,-1.3244629e-002,-1.3977051e-002,-3.2653809e-003,8.1481934e-003,2.1606445e-002,3.0151367e-002,2.4536133e-002,1.9042969e-002,1.1047363e-002,1.6784668e-003,-9.1552734e-005,-5.0354004e-003,-8.2397461e-003,-8.9416504e-003,-1.0925293e-002,-7.2631836e-003,-3.0517578e-003,1.8310547e-003,4.1809082e-003,5.8288574e-003,8.1787109e-003,1.0040283e-002,1.7150879e-002,2.0751953e-002,2.2064209e-002,1.9073486e-002,7.2937012e-003,-3.2348633e-003,-1.1932373e-002,-1.7517090e-002,-1.4099121e-002,-9.7961426e-003,-5.9509277e-003,1.5258789e-004,-1.3427734e-003,-3.4790039e-003,-8.0261230e-003,-1.7059326e-002,-2.1331787e-002,-2.5299072e-002,-2.1484375e-002,-1.4343262e-002,-5.1574707e-003,4.2419434e-003,3.5095215e-003,2.0141602e-003,-6.5307617e-003,-1.5533447e-002,-1.8524170e-002,-2.4475098e-002,-2.5573730e-002,-2.7435303e-002,-3.2928467e-002,-3.2897949e-002,-3.1005859e-002,-2.6458740e-002,-1.8524170e-002,-1.3854980e-002,-1.3183594e-002,-1.3153076e-002,-1.3488770e-002,-1.1749268e-002,-1.6784668e-003,6.7749023e-003,1.5380859e-002,2.1453857e-002,1.6693115e-002,1.1871338e-002,4.0893555e-003,-4.5166016e-003,-7.4462891e-003,-1.1840820e-002,-1.3122559e-002,-1.1962891e-002,-1.2451172e-002,-9.4909668e-003,-7.8125000e-003,-3.7536621e-003,3.4179688e-003,9.6435547e-003,1.6418457e-002,1.5686035e-002,5.1269531e-003,-8.2397461e-003,-2.2216797e-002,-3.0029297e-002,-2.2033691e-002,-1.2207031e-002,-2.5329590e-003,6.4392090e-003,6.1035156e-005,-1.1596680e-003,1.1901855e-003,-1.2207031e-004,7.4462891e-003,8.0871582e-003,6.2255859e-003,1.0131836e-002,1.6052246e-002,2.1148682e-002,2.2094727e-002,1.3275146e-002,-9.8266602e-003,-2.5085449e-002,-2.7008057e-002,-2.1606445e-002,7.0190430e-004,1.3916016e-002,5.6762695e-003,1.8005371e-003,-1.1657715e-002,-1.8249512e-002,-2.8381348e-003,1.5258789e-003,5.7373047e-003,7.5683594e-003,-2.3803711e-003,-4.5776367e-004,8.1787109e-003,1.1840820e-002,1.1047363e-002,3.8757324e-003,-1.2420654e-002,-1.9042969e-002,-9.7656250e-003,-1.2207031e-004,1.6357422e-002,2.5604248e-002,1.4984131e-002,5.2185059e-003,-8.8806152e-003,-2.3345947e-002,-2.1423340e-002,-2.2399902e-002,-1.8035889e-002,-1.1230469e-002,-1.5686035e-002,-1.6845703e-002,-2.4047852e-002,-2.8076172e-002,-2.2705078e-002,-1.7150879e-002,-5.5541992e-003,1.1291504e-003,-1.7395020e-003,-4.1809082e-003,-8.2702637e-003,-9.4604492e-003,-1.1901855e-003,3.6010742e-003,5.7067871e-003,7.2631836e-003,1.7700195e-003,-1.0070801e-003,-2.2888184e-003,-7.9040527e-003,-1.4160156e-002,-2.1728516e-002,-2.9724121e-002,-3.3935547e-002,-3.5125732e-002,-3.6529541e-002,-3.8665771e-002,-3.7322998e-002,-3.3142090e-002,-2.4078369e-002,-1.0925293e-002,-4.2724609e-004,6.1645508e-003,1.0467529e-002,1.1596680e-002,7.8430176e-003,1.0986328e-003,-1.4678955e-002,-3.5522461e-002,-4.9835205e-002,-5.0781250e-002,-4.0679932e-002,-2.0111084e-002,-3.2348633e-003,-4.9743652e-003,-3.5705566e-003,-5.4931641e-003,-3.6621094e-004,2.6947021e-002,4.0710449e-002,4.6783447e-002,4.3426514e-002,2.1209717e-002,6.7749023e-003,4.1503906e-003,-1.5258789e-003,-4.3029785e-003,-1.2939453e-002,-3.9398193e-002,-5.6274414e-002,-6.6986084e-002,-6.9763184e-002,-5.2093506e-002,-3.4851074e-002,-1.7211914e-002,1.6479492e-003,1.0070801e-002,1.5594482e-002,1.9378662e-002,1.8463135e-002,2.4597168e-002,2.7130127e-002,2.8228760e-002,2.4658203e-002,6.4086914e-003,-4.8522949e-003,-1.2969971e-002,-1.1138916e-002,5.7067871e-003,1.5136719e-002,1.0711670e-002,-1.2817383e-003,-2.6336670e-002,-4.1961670e-002,-2.9602051e-002,-1.4099121e-002,1.5655518e-002,3.6346436e-002,2.5299072e-002,1.2420654e-002,-1.5838623e-002,-3.6895752e-002,-3.1372070e-002,-2.7313232e-002,-1.2451172e-002,-2.1972656e-003,-1.4007568e-002,-1.9287109e-002,-2.9510498e-002,-3.3721924e-002,-1.6967773e-002,-7.3242188e-003,3.4179688e-003,6.3171387e-003,-7.6293945e-003,-1.7913818e-002,-2.2796631e-002,-2.4261475e-002,-1.2939453e-002,-4.4250488e-003,-6.0729980e-003,-5.1574707e-003,-1.6204834e-002,-2.5512695e-002,-2.9388428e-002,-3.6895752e-002,-3.7017822e-002,-3.4912109e-002,-2.7557373e-002,-1.5747070e-002,-2.3803711e-003,8.9721680e-003,1.3458252e-002,1.5655518e-002,1.2908936e-002,5.1879883e-003,-3.2653809e-003,-1.5838623e-002,-2.7130127e-002,-3.0120850e-002,-2.3162842e-002,-8.8195801e-003,6.4392090e-003,1.5808105e-002,4.5166016e-003,-9.8571777e-003,-2.5573730e-002,-3.8269043e-002,-2.4780273e-002,-1.6510010e-002,-6.4086914e-003,1.7089844e-003,-9.6740723e-003,-1.2756348e-002,-1.4312744e-002,-1.5319824e-002,-6.3476563e-003,-4.8522949e-003,-1.0589600e-002,-1.3153076e-002,-1.6510010e-002,-1.5930176e-002,-7.9956055e-003,-5.1574707e-003,-7.0800781e-003,-8.9111328e-003,-1.3122559e-002,-1.2054443e-002,-2.7465820e-004,1.0131836e-002,1.9104004e-002,2.3925781e-002,1.6387939e-002,9.3078613e-003,2.8991699e-003,-5.4016113e-003,-8.5754395e-003,-1.3153076e-002,-1.8432617e-002,-1.6967773e-002,-1.2542725e-002,-5.9509277e-003,-1.3732910e-003,-2.2277832e-003,-1.2725830e-002,-2.1728516e-002,-2.1514893e-002,-1.8432617e-002,-3.3569336e-004,1.2908936e-002,1.5808105e-002,1.9226074e-002,9.3688965e-003,1.0070801e-003,-3.4484863e-003,-1.3763428e-002,-2.0507813e-002,-2.3498535e-002,-2.1362305e-002,-1.2268066e-002,-6.1035156e-005,4.9743652e-003,-7.3852539e-003,-2.2033691e-002,-3.9337158e-002,-4.7241211e-002,-2.6489258e-002,-9.2468262e-003,9.2468262e-003,1.9744873e-002,2.1362305e-003,-8.7585449e-003,-1.9042969e-002,-2.9205322e-002,-2.0202637e-002,-1.7761230e-002,-1.9561768e-002,-1.7517090e-002,-2.5054932e-002,-2.7038574e-002,-2.5085449e-002,-2.2308350e-002,-1.1383057e-002,-2.7465820e-004,1.0375977e-002,1.5075684e-002,8.2092285e-003,-3.2653809e-003,-1.9165039e-002,-3.2928467e-002,-3.4881592e-002,-3.6926270e-002,-3.5766602e-002,-3.1402588e-002,-3.3966064e-002,-2.5787354e-002,-1.2634277e-002,-1.6784668e-003,7.2021484e-003,6.0729980e-003,-5.1269531e-003,-1.6632080e-002,-1.9195557e-002,-2.2674561e-002,-1.7730713e-002,-1.6632080e-002,-2.6824951e-002,-2.8930664e-002,-3.0944824e-002,-2.5146484e-002,-9.4909668e-003,1.8310547e-003,6.5612793e-003,8.7585449e-003,4.0588379e-003,-3.6621094e-003,-5.8288574e-003,-1.1871338e-002,-1.1932373e-002,-6.8969727e-003,6.1035156e-004,1.0803223e-002,1.1230469e-002,6.5002441e-003,-1.1840820e-002,-2.7130127e-002,-2.7221680e-002,-2.3529053e-002,-9.1552734e-005,1.6204834e-002,1.4129639e-002,1.0681152e-002,-7.2326660e-003,-1.9378662e-002,-1.2878418e-002,-1.2023926e-002,-4.6386719e-003,-4.5776367e-004,-9.9182129e-003,-1.0406494e-002,-9.7961426e-003,-8.2702637e-003,-2.1667480e-003,-1.3732910e-003,-4.5776367e-003,-4.7912598e-003,-3.2348633e-003,-1.1291504e-003,4.6081543e-003,7.3547363e-003,7.6904297e-003,1.0192871e-002,1.3671875e-002,1.6540527e-002,1.6387939e-002,1.1627197e-002,7.9345703e-004,-8.4228516e-003,-1.3519287e-002,-1.7669678e-002,-1.6693115e-002,-1.5106201e-002,-1.5899658e-002,-1.0955811e-002,-5.3100586e-003,-1.2512207e-003,-1.1596680e-003,-1.0620117e-002,-2.7191162e-002,-4.0985107e-002,-4.0954590e-002,-3.4698486e-002,-1.4831543e-002,4.2419434e-003,7.8735352e-003,1.2420654e-002,4.6997070e-003,-3.5705566e-003,-4.4250488e-003,-1.1688232e-002,-1.2817383e-002,-1.2084961e-002,-1.0894775e-002,-5.8593750e-003,-3.5400391e-003,-6.5002441e-003,-1.9439697e-002,-2.8747559e-002,-3.0059814e-002,-2.5695801e-002,-7.2021484e-003,4.9743652e-003,5.9204102e-003,4.8522949e-003,-5.8288574e-003,-1.3244629e-002,-1.0101318e-002,-1.4587402e-002,-1.9744873e-002,-2.4658203e-002,-3.2806396e-002,-2.9663086e-002,-1.7211914e-002,-7.3852539e-003,-4.9133301e-003,-6.4086914e-003,-1.8646240e-002,-2.3651123e-002,-1.2939453e-002,-6.8054199e-003,5.8898926e-003,1.2237549e-002,4.3334961e-003,3.4179688e-003,3.6621094e-003,3.2043457e-003,6.9274902e-003,3.9978027e-003,-4.1503906e-003,-7.3242188e-003,-7.4768066e-003,-8.5754395e-003,-1.0284424e-002,-1.7395020e-002,-3.1738281e-002,-3.8940430e-002,-3.5186768e-002,-2.8564453e-002,-1.4801025e-002,-6.9580078e-003,-1.2786865e-002,-1.3732910e-002,-1.3000488e-002,-9.3994141e-003,5.9814453e-003,1.4282227e-002,1.5197754e-002,1.6082764e-002,9.7351074e-003,3.0517578e-003,-1.2512207e-003,-9.5520020e-003,-1.8280029e-002,-2.1972656e-002,-1.8707275e-002,-1.0711670e-002,-1.3122559e-003,3.6621094e-003,-3.5095215e-003,-6.1035156e-003,-1.3732910e-003,6.0729980e-003,2.6153564e-002,3.5034180e-002,2.6824951e-002,1.7395020e-002,8.5449219e-004,-7.6599121e-003,2.8686523e-003,7.5683594e-003,8.0261230e-003,5.7373047e-003,-1.3122559e-002,-2.1942139e-002,-1.8707275e-002,-1.6632080e-002,-5.6152344e-003,-2.1057129e-003,-9.2773438e-003,-1.2573242e-002,-1.4892578e-002,-1.6174316e-002,-1.2176514e-002,-1.3549805e-002,-2.1759033e-002,-2.6367188e-002,-2.8228760e-002,-2.5665283e-002,-1.5930176e-002,-9.0942383e-003,-1.0803223e-002,-1.0650635e-002,-1.2481689e-002,-9.2773438e-003,6.3781738e-003,1.7395020e-002,2.7252197e-002,3.2257080e-002,2.4200439e-002,1.6845703e-002,9.5214844e-003,-8.5449219e-004,-6.4086914e-003,-1.5808105e-002,-2.7343750e-002,-3.1921387e-002,-3.3020020e-002,-2.3803711e-002,-9.9792480e-003,5.1879883e-004,1.9531250e-003,-2.5329590e-003,-1.3336182e-002,-2.5207520e-002,-2.4505615e-002,-2.4627686e-002,-1.7395020e-002,-8.7585449e-003,-9.0942383e-003,-2.6855469e-003,-5.1879883e-004,2.3498535e-003,6.7138672e-003,3.3874512e-003,-6.8359375e-003,-2.0080566e-002,-3.2989502e-002,-4.1381836e-002,-3.3477783e-002,-2.2949219e-002,-8.1787109e-003,7.2937012e-003,7.1716309e-003,7.7209473e-003,1.9836426e-003,-6.3476563e-003,-4.5471191e-003,-4.7302246e-003,3.5705566e-003,1.5777588e-002,2.5787354e-002,3.7261963e-002,3.6712646e-002,3.0517578e-002,1.4495850e-002,-4.6386719e-003,-1.5472412e-002,-2.5238037e-002,-2.0446777e-002,-1.5411377e-002,-1.4953613e-002,-1.0345459e-002,-1.4251709e-002,-1.1444092e-002,-2.1362305e-003,2.5329590e-003,7.5988770e-003,6.1035156e-003,-1.8005371e-003,-4.1809082e-003,1.8310547e-003,1.0803223e-002,2.5085449e-002,3.3325195e-002,2.7191162e-002,2.1392822e-002,9.1247559e-003,-3.3874512e-003,-7.4157715e-003,-1.6296387e-002,-2.2216797e-002,-2.3071289e-002,-1.9165039e-002,-6.2866211e-003,1.0070801e-002,2.3498535e-002,2.4017334e-002,2.0751953e-002,1.2786865e-002,5.8898926e-003,1.3763428e-002,1.6387939e-002,1.8524170e-002,1.8646240e-002,5.8898926e-003,1.0070801e-003,-2.1362305e-004,-1.0070801e-003,3.7536621e-003,4.6691895e-003,8.8500977e-004,-2.4414063e-004,9.1552734e-004,6.4086914e-004,1.5258789e-003,-3.3569336e-003,-1.2542725e-002,-1.8341064e-002,-1.9287109e-002,-1.6784668e-002,-1.0528564e-002,-3.8757324e-003,-2.3803711e-003,3.5705566e-003,1.0345459e-002,1.4526367e-002,1.6540527e-002,7.9956055e-003,-1.0559082e-002,-2.8442383e-002,-3.7017822e-002,-3.8726807e-002,-2.4108887e-002,-1.0437012e-002,-8.9721680e-003,-5.4931641e-003,-1.4373779e-002,-1.7669678e-002,-8.3312988e-003,-4.3640137e-003,4.3945313e-003,8.6669922e-003,2.7770996e-003,1.1596680e-003,1.1291504e-003,2.0446777e-003,5.5236816e-003,4.9133301e-003,-3.7536621e-003,-1.1444092e-002,-1.9378662e-002,-2.6000977e-002,-2.3620605e-002,-2.0874023e-002,-1.6235352e-002,-8.9111328e-003,-4.3334961e-003,2.1362305e-004,3.1127930e-003,2.9907227e-003,2.1362305e-003,1.6479492e-003,5.9204102e-003,1.1688232e-002,1.8066406e-002,2.0507813e-002,1.3427734e-002,4.9133301e-003,-5.7983398e-003,-1.2969971e-002,-9.0026855e-003,-4.4250488e-003,2.5329590e-003,8.7585449e-003,7.5378418e-003,8.6975098e-003,9.4299316e-003,7.9345703e-003,9.5214844e-003,7.0190430e-003,3.1738281e-003,5.7983398e-004,-1.2207031e-003,-4.8828125e-004,1.2207031e-003,4.3029785e-003,5.7067871e-003,1.0040283e-002,1.6998291e-002,2.3834229e-002,3.1646729e-002,3.3630371e-002,2.9174805e-002,2.0935059e-002,1.0833740e-002,-2.0446777e-003,-1.1627197e-002,-2.2705078e-002,-3.2562256e-002,-3.3813477e-002,-3.0181885e-002,-1.7974854e-002,-3.8146973e-003,8.4228516e-003,1.0070801e-002,9.7961426e-003,9.0637207e-003,8.5449219e-003,2.1789551e-002,2.9418945e-002,3.6987305e-002,4.1595459e-002,3.3813477e-002,2.9113770e-002,2.1423340e-002,1.2542725e-002,6.1340332e-003,-2.0751953e-003,-9.1247559e-003,-1.3549805e-002,-1.6937256e-002,-1.8737793e-002,-2.0355225e-002,-2.0263672e-002,-1.6387939e-002,-9.9487305e-003,1.6174316e-003,1.0925293e-002,1.5594482e-002,1.8615723e-002,1.7395020e-002,1.5991211e-002,1.8035889e-002,1.6510010e-002,1.3916016e-002,1.1657715e-002,8.0261230e-003,1.0009766e-002,1.4099121e-002,1.7059326e-002,1.6235352e-002,1.2786865e-002,6.3781738e-003,-1.5258789e-004,-1.3122559e-003,-6.3476563e-003,-1.1718750e-002,-1.6510010e-002,-2.1118164e-002,-1.8646240e-002,-9.7656250e-003,-1.6174316e-003,1.5869141e-003,1.9836426e-003,-2.7770996e-003,-3.8757324e-003,3.1433105e-003,5.7067871e-003,8.2397461e-003,3.6621094e-003,-1.0772705e-002,-1.8249512e-002,-1.6601563e-002,-8.3312988e-003,9.3688965e-003,2.1942139e-002,2.0568848e-002,1.7547607e-002,6.5002441e-003,-2.7160645e-003,1.1901855e-003,1.8615723e-003,6.9580078e-003,1.0864258e-002,5.1574707e-003,2.8686523e-003,-2.1362305e-004,-1.9226074e-003,3.2958984e-003,7.0190430e-003,1.0375977e-002,1.4526367e-002,1.5563965e-002,1.8188477e-002,2.2277832e-002,2.1484375e-002,1.6113281e-002,6.6223145e-003,-6.7443848e-003,-1.4343262e-002,-9.4604492e-003,-9.4604492e-004,1.0955811e-002,1.8035889e-002,8.0261230e-003,-6.1035156e-004,-9.2163086e-003,-1.4984131e-002,-2.6855469e-003,5.6457520e-003,1.3641357e-002,2.2918701e-002,2.1484375e-002,2.2827148e-002,2.2735596e-002,1.8432617e-002,1.4801025e-002,1.2725830e-002,1.7944336e-002,2.6123047e-002,3.3905029e-002,3.2928467e-002,1.5136719e-002,-3.1433105e-003,-1.8493652e-002,-2.3590088e-002,-1.8005371e-003,1.7150879e-002,2.9937744e-002,3.8879395e-002,2.3529053e-002,1.2298584e-002,9.3688965e-003,2.6550293e-003,1.0986328e-002,1.5136719e-002,1.3519287e-002,1.6387939e-002,1.1169434e-002,7.2326660e-003,3.0517578e-004,-7.1716309e-003,-1.0009766e-002,-1.0864258e-002,-4.4860840e-003,-2.1972656e-003,-7.3852539e-003,-1.5167236e-002,-2.8808594e-002,-3.6437988e-002,-2.9907227e-002,-2.2155762e-002,-9.2468262e-003,3.9978027e-003,7.1105957e-003,1.5747070e-002,2.3071289e-002,2.6336670e-002,2.9754639e-002,2.5604248e-002,1.8035889e-002,1.2847900e-002,1.6296387e-002,2.1026611e-002,2.7160645e-002,3.1311035e-002,2.3437500e-002,1.9439697e-002,1.8432617e-002,1.7822266e-002,2.6428223e-002,2.8564453e-002,2.5024414e-002,2.0141602e-002,1.0467529e-002,2.3193359e-003,-6.7138672e-004,-5.5847168e-003,-1.2725830e-002,-1.9927979e-002,-2.9571533e-002,-3.4088135e-002,-3.2684326e-002,-2.8930664e-002,-2.2674561e-002,-1.8280029e-002,-1.8737793e-002,-1.7913818e-002,-1.3610840e-002,-6.8664551e-003,8.0871582e-003,1.9439697e-002,2.4200439e-002,2.4688721e-002,1.3916016e-002,5.3405762e-003,1.9531250e-003,6.4086914e-004,8.7585449e-003,1.8493652e-002,2.4993896e-002,3.5522461e-002,3.9794922e-002,4.2633057e-002,4.4189453e-002,3.9459229e-002,3.6651611e-002,3.2745361e-002,3.2928467e-002,3.3386230e-002,3.2806396e-002,3.1433105e-002,2.4261475e-002,2.0477295e-002,1.6693115e-002,1.1230469e-002,5.0659180e-003,-4.8828125e-003,-1.6601563e-002,-2.4444580e-002,-2.3681641e-002,-2.0935059e-002,-1.5502930e-002,-1.3732910e-002,-2.0538330e-002,-2.4047852e-002,-2.3712158e-002,-2.1423340e-002,-9.6130371e-003,-3.2348633e-003,-1.8005371e-003,3.8757324e-003,8.1787109e-003,1.9439697e-002,4.0313721e-002,5.6396484e-002,6.4636230e-002,6.6101074e-002,5.3588867e-002,4.0313721e-002,3.3386230e-002,2.7801514e-002,3.5736084e-002,4.4586182e-002,4.7607422e-002,4.9835205e-002,3.5705566e-002,2.0690918e-002,7.3242188e-003,-6.5002441e-003,-5.3710938e-003,-5.8288574e-003,-6.2561035e-003,-6.3781738e-003,-1.4556885e-002,-1.7211914e-002,-1.6052246e-002,-1.3916016e-002,-7.7514648e-003,-3.5095215e-003,-1.8920898e-003,1.2512207e-003,4.9438477e-003,3.9672852e-003,-2.3803711e-003,-1.2420654e-002,-2.5573730e-002,-3.2165527e-002,-2.4963379e-002,-1.4587402e-002,-2.1362305e-003,7.9040527e-003,5.1574707e-003,7.4462891e-003,1.5350342e-002,2.2552490e-002,3.7475586e-002,4.2297363e-002,3.4240723e-002,2.5421143e-002,1.4251709e-002,8.5754395e-003,1.6815186e-002,2.7343750e-002,3.8055420e-002,5.2124023e-002,5.5267334e-002,5.7006836e-002,5.2001953e-002,3.9154053e-002,2.9510498e-002,1.6143799e-002,1.2237549e-002,8.3923340e-003,4.3029785e-003,-6.7138672e-004,-1.7089844e-002,-2.7923584e-002,-3.6193848e-002,-3.9489746e-002,-3.3508301e-002,-2.8900146e-002,-2.9663086e-002,-2.9205322e-002,-2.8778076e-002,-2.7343750e-002,-1.9226074e-002,-1.7089844e-002,-1.9348145e-002,-2.1362305e-002,-2.4688721e-002,-2.2277832e-002,-9.8266602e-003,3.5705566e-003,1.6143799e-002,3.0426025e-002,3.6926270e-002,4.6447754e-002,5.8258057e-002,6.4544678e-002,6.9488525e-002,6.7626953e-002,6.0089111e-002,5.3222656e-002,5.0567627e-002,4.9163818e-002,4.8583984e-002,4.5501709e-002,3.1982422e-002,2.1697998e-002,1.3366699e-002,8.3923340e-003,1.3214111e-002,1.1535645e-002,1.9226074e-003,-1.0589600e-002,-2.8991699e-002,-4.1534424e-002,-3.8909912e-002,-3.5461426e-002,-2.8137207e-002,-2.0935059e-002,-2.6397705e-002,-2.2857666e-002,-1.3824463e-002,-2.4414063e-003,1.7364502e-002,2.7435303e-002,2.6885986e-002,2.4475098e-002,1.7791748e-002,1.3061523e-002,1.9073486e-002,1.9897461e-002,1.7730713e-002,1.6479492e-002,1.0040283e-002,1.1596680e-002,1.9165039e-002,2.6123047e-002,3.1494141e-002,3.4790039e-002,3.2989502e-002,3.3935547e-002,4.0893555e-002,4.5562744e-002,5.1666260e-002,5.3039551e-002,4.5288086e-002,3.7078857e-002,2.7160645e-002,1.5502930e-002,7.3547363e-003,-2.6245117e-003,-1.3061523e-002,-1.9195557e-002,-2.2949219e-002,-2.0507813e-002,-1.3153076e-002,-5.0964355e-003,3.0517578e-004,4.0283203e-003,4.5776367e-003,5.0354004e-003,9.7656250e-003,1.0742188e-002,1.0559082e-002,6.9274902e-003,-1.9531250e-003,-5.2795410e-003,-2.0751953e-003,6.4697266e-003,1.9592285e-002,2.8839111e-002,2.2430420e-002,1.3641357e-002,1.6784668e-003,-8.1176758e-003,7.6293945e-004,5.7678223e-003,1.1169434e-002,1.7059326e-002,1.0253906e-002,1.0223389e-002,1.3702393e-002,1.0284424e-002,4.6997070e-003,-6.0729980e-003,-1.7883301e-002,-1.6479492e-002,5.7983398e-003,3.3142090e-002,5.8746338e-002,6.9427490e-002,4.5593262e-002,1.9256592e-002,-1.2512207e-003,-1.5930176e-002,6.2255859e-003,2.1514893e-002,2.3315430e-002,2.1423340e-002,-1.3732910e-002,-3.5308838e-002,-3.6926270e-002,-3.4484863e-002,-8.5754395e-003,5.9204102e-003,-3.0517578e-003,-8.2702637e-003,-1.9561768e-002,-1.8463135e-002,1.2847900e-002,3.4576416e-002,4.6600342e-002,4.8706055e-002,2.0721436e-002,2.2888184e-003,2.7160645e-003,2.3803711e-003,2.0172119e-002,2.9357910e-002,1.4526367e-002,9.2468262e-003,-6.7138672e-004,-5.2795410e-003,9.2468262e-003,1.5258789e-002,1.9866943e-002,2.7770996e-002,3.0792236e-002,3.2958984e-002,3.2348633e-002,2.3193359e-002,9.5520020e-003,2.6550293e-003,8.8195801e-003,1.4831543e-002,1.9073486e-002,1.6326904e-002,-3.6926270e-003,-8.3923340e-003,7.2937012e-003,2.3071289e-002,4.3701172e-002,4.3701172e-002,1.2329102e-002,-5.1269531e-003,-1.3427734e-003,6.7749023e-003,3.3966064e-002,3.3691406e-002,-1.0986328e-002,-3.5064697e-002,-3.9520264e-002,-1.8127441e-002,4.9255371e-002,8.2672119e-002,5.3436279e-002,2.1789551e-002,-3.0487061e-002,-5.5541992e-002,-2.7160645e-003,2.2521973e-002,2.8472900e-002,3.0609131e-002,-1.6510010e-002,-2.4566650e-002,1.5045166e-002,3.4545898e-002,5.0323486e-002,4.2633057e-002,-8.3618164e-003,-2.8320313e-002,-3.1433105e-003,1.3854980e-002,3.9245605e-002,4.1046143e-002,-1.1962891e-002,-3.8879395e-002,-3.8055420e-002,-3.4820557e-002,5.1879883e-004,1.8096924e-002,8.5449219e-004,3.0517578e-003,8.3923340e-003,1.1962891e-002,2.9449463e-002,2.3345947e-002,-5.7678223e-003,-2.0843506e-002,-1.8646240e-002,-8.3923340e-003,2.1209717e-002,3.9123535e-002,2.6367188e-002,2.5634766e-002,1.9195557e-002,1.0803223e-002,1.6113281e-002,2.9907227e-003,-1.8585205e-002,-3.1951904e-002,-3.5430908e-002,-3.1677246e-002,-2.0233154e-002,-1.0955811e-002,-1.5106201e-002,-5.9204102e-003,1.3519287e-002,3.0456543e-002,4.8034668e-002,4.7241211e-002,2.4597168e-002,6.1645508e-003,5.7983398e-004,-5.7373047e-003,5.1879883e-004,-1.4953613e-003,-2.2247314e-002,-2.6580811e-002,-2.3071289e-002,-1.1016846e-002,1.3854980e-002,2.6245117e-002,1.7303467e-002,9.9792480e-003,4.3029785e-003,-6.4086914e-004,1.4892578e-002,2.0507813e-002,1.7181396e-002,1.9134521e-002,1.2512207e-002,1.3214111e-002,1.9165039e-002,1.8768311e-002,1.3000488e-002,5.9814453e-003,-1.5258789e-003,-5.9204102e-003,-7.6293945e-004,3.7841797e-003,9.3078613e-003,1.5960693e-002,1.8951416e-002,2.0629883e-002,1.8493652e-002,1.4129639e-002,1.1138916e-002,9.9182129e-003,1.5136719e-002,1.8035889e-002,1.5563965e-002,1.1108398e-002,-5.1574707e-003,-2.1606445e-002,-3.7231445e-002,-5.4718018e-002,-6.3354492e-002,-6.6223145e-002,-5.7250977e-002,-3.6987305e-002,-1.1199951e-002,1.6235352e-002,3.1158447e-002,4.3182373e-002,4.8278809e-002,4.9316406e-002,5.9875488e-002,6.2194824e-002,6.5826416e-002,6.5521240e-002,5.0598145e-002,3.2958984e-002,2.3498535e-003,-2.8137207e-002,-5.2001953e-002,-6.4971924e-002,-5.4534912e-002,-3.7597656e-002,-1.8554688e-002,-1.8310547e-004,1.8310547e-003,9.4604492e-003,2.4414063e-002,3.0517578e-002,4.2175293e-002,3.8604736e-002,2.1636963e-002,1.2847900e-002,7.6599121e-003,2.9602051e-003,-7.7819824e-003,-2.7832031e-002,-6.3964844e-002,-7.8552246e-002,-5.9844971e-002,-2.9602051e-002,1.9073486e-002,4.8400879e-002,3.4271240e-002,2.2888184e-002,1.5411377e-002,7.9650879e-003,3.5583496e-002,3.9855957e-002,2.0172119e-002,1.0589600e-002,-8.9416504e-003,-1.0375977e-002,2.2583008e-003,-9.7656250e-004,-2.7130127e-002,-4.4158936e-002,-5.0170898e-002,-3.9031982e-002,7.5378418e-003,2.7587891e-002,1.0528564e-002,-1.2115479e-002,-4.8461914e-002,-6.2469482e-002,-1.9439697e-002,1.3885498e-002,3.7261963e-002,5.5999756e-002,2.5115967e-002,1.1383057e-002,1.5106201e-002,9.8266602e-003,2.4414063e-002,2.7648926e-002,1.5045166e-002,9.0942383e-003,-3.0517578e-004,-1.0467529e-002,-1.1291504e-002,-9.7045898e-003,-4.5776367e-004,8.6975098e-003,7.6904297e-003,-4.4250488e-003,-3.2958984e-002,-4.9804688e-002,-3.9428711e-002,-2.1667480e-002,8.4533691e-003,1.9866943e-002,-1.3885498e-002,-3.5247803e-002,-4.5318604e-002,-4.1717529e-002,5.4016113e-003,2.6550293e-002,1.1810303e-002,2.5329590e-003,-1.9500732e-002,-1.8859863e-002,2.6580811e-002,4.6661377e-002,3.9428711e-002,2.3071289e-002,-2.3651123e-002,-4.6447754e-002,-2.5024414e-002,-1.3336182e-002,-3.6315918e-003,1.8310547e-004,-3.0273438e-002,-3.7628174e-002,-1.8463135e-002,-4.6386719e-003,2.1606445e-002,3.5552979e-002,2.4902344e-002,2.0172119e-002,1.8371582e-002,8.6364746e-003,6.5307617e-003,3.1738281e-003,9.7656250e-004,9.4604492e-003,1.6540527e-002,1.5228271e-002,-5.0354004e-003,-2.1728516e-002,-2.7587891e-002,-2.2644043e-002,7.9956055e-003,2.1392822e-002,6.9580078e-003,-6.1950684e-003,-2.6031494e-002,-2.8564453e-002,6.6833496e-003,2.3376465e-002,1.8005371e-002,9.5825195e-003,-2.2399902e-002,-3.0120850e-002,7.3242188e-004,1.7913818e-002,2.6092529e-002,2.0935059e-002,-1.8463135e-002,-3.7933350e-002,-2.4719238e-002,-1.6326904e-002,3.9978027e-003,1.2268066e-002,-1.1718750e-002,-2.0294189e-002,-1.7364502e-002,-1.6143799e-002,-3.8757324e-003,-3.4179688e-003,-2.0446777e-002,-2.6397705e-002,-2.2979736e-002,-1.5319824e-002,3.3264160e-003,1.7303467e-002,1.8188477e-002,2.2460938e-002,2.4963379e-002,2.3254395e-002,2.5634766e-002,1.9287109e-002,9.5825195e-003,2.1057129e-003,-3.3569336e-003,-7.4768066e-003,-1.0650635e-002,-8.1481934e-003,-4.6691895e-003,1.9531250e-003,5.7983398e-003,-1.0070801e-003,-2.1514893e-002,-4.3212891e-002,-5.5297852e-002,-6.0058594e-002,-4.1870117e-002,-2.4719238e-002,-1.6540527e-002,-1.4343262e-003,3.5095215e-003,1.3671875e-002,2.9205322e-002,2.8930664e-002,1.7547607e-002,3.1433105e-003,-8.6059570e-003,-1.1383057e-002,4.2419434e-003,1.3763428e-002,6.5917969e-003,1.6479492e-003,-1.7883301e-002,-2.8900146e-002,-2.1270752e-002,-2.1453857e-002,-1.7181396e-002,-1.3854980e-002,-1.5350342e-002,-1.0650635e-002,-3.2348633e-003,-1.9226074e-003,-7.7209473e-003,-1.0192871e-002,-6.1340332e-003,3.4484863e-003,2.1942139e-002,2.9357910e-002,1.4099121e-002,2.1667480e-003,-1.0833740e-002,-1.5777588e-002,1.1596680e-003,9.1857910e-003,7.1105957e-003,7.4462891e-003,-1.8920898e-003,-5.1879883e-003,6.1035156e-004,-1.0192871e-002,-3.1707764e-002,-4.8461914e-002,-5.4656982e-002,-4.3823242e-002,-7.6904297e-003,1.8096924e-002,1.6052246e-002,1.6418457e-002,3.9062500e-003,4.6997070e-003,3.8238525e-002,4.8339844e-002,4.1351318e-002,2.2094727e-002,-2.3620605e-002,-4.9804688e-002,-4.2022705e-002,-3.4820557e-002,-1.7852783e-002,-9.1552734e-004,-7.8125000e-003,2.4719238e-003,1.8249512e-002,2.1972656e-002,2.3834229e-002,8.8806152e-003,-1.3641357e-002,-2.5970459e-002,-1.5838623e-002,-7.0495605e-003,-2.9296875e-003,-2.8686523e-003,-2.9205322e-002,-3.9031982e-002,-3.2012939e-002,-2.2705078e-002,3.6621094e-003,2.1118164e-002,2.3529053e-002,2.9815674e-002,3.2470703e-002,2.7801514e-002,2.4780273e-002,9.0637207e-003,-1.1718750e-002,-2.2552490e-002,-2.1057129e-002,-1.2420654e-002,-5.4016113e-003,-2.3498535e-003,-2.3712158e-002,-4.2480469e-002,-5.6945801e-002,-6.8023682e-002,-5.2032471e-002,-3.7933350e-002,-1.8859863e-002,5.9509277e-003,2.0263672e-002,3.7109375e-002,4.8797607e-002,5.3924561e-002,6.0455322e-002,6.0668945e-002,5.8837891e-002,4.8431396e-002,2.4353027e-002,-4.5471191e-003,-3.9184570e-002,-6.5826416e-002,-7.6538086e-002,-7.5958252e-002,-6.3751221e-002,-4.4982910e-002,-3.3264160e-002,-2.1301270e-002,-1.6387939e-002,-1.8554688e-002,-1.4984131e-002,-1.8280029e-002,-1.0864258e-002,-1.4648438e-003,1.2695313e-002,3.6132813e-002,5.4443359e-002,7.5683594e-002,8.0261230e-002,7.3303223e-002,4.7729492e-002,1.4404297e-002,-7.9956055e-003,-2.5512695e-002,-1.4770508e-002,-5.0964355e-003,-5.0964355e-003,-6.0729980e-003,-3.1311035e-002,-4.3762207e-002,-3.5491943e-002,-2.7648926e-002,-5.1269531e-003,3.0212402e-003,-1.5228271e-002,-2.7374268e-002,-3.7109375e-002,-3.8543701e-002,-1.8371582e-002,-6.2866211e-003,-7.1411133e-003,-3.2958984e-003,-5.2490234e-003,3.9367676e-003,3.1463623e-002,4.7668457e-002,5.2124023e-002,4.7637939e-002,2.7770996e-002,1.3061523e-002,1.7761230e-002,2.0141602e-002,2.8625488e-002,3.2745361e-002,1.5106201e-002,-6.1035156e-005,-2.2125244e-002,-4.1656494e-002,-4.5318604e-002,-4.4830322e-002,-2.8900146e-002,-7.1716309e-003,1.2329102e-002,3.3081055e-002,4.0771484e-002,4.6020508e-002,5.0964355e-002,4.3334961e-002,3.5797119e-002,1.4953613e-002,-1.4495850e-002,-3.5858154e-002,-4.5227051e-002,-3.9276123e-002,-1.9287109e-002,2.5939941e-003,4.4555664e-003,4.7607422e-003,-8.0261230e-003,-2.2705078e-002,-1.5930176e-002,-1.9104004e-002,-1.0284424e-002,-3.1738281e-003,-4.7302246e-003,1.2817383e-003,1.8310547e-003,4.5471191e-003,5.4321289e-003,7.1716309e-003,9.7656250e-003,1.4923096e-002,2.5634766e-002,3.3599854e-002,4.0069580e-002,4.1137695e-002,3.1219482e-002,1.5075684e-002,-3.6621094e-003,-2.1575928e-002,-2.6306152e-002,-2.4139404e-002,-1.2176514e-002,2.6245117e-003,4.5471191e-003,9.4299316e-003,5.0048828e-003,3.3874512e-003,1.2054443e-002,9.7656250e-003,4.8828125e-003,-8.2397461e-003,-2.9266357e-002,-4.0344238e-002,-3.3691406e-002,-2.1118164e-002,-4.2419434e-003,1.0345459e-002,6.0424805e-003,8.6975098e-003,1.6082764e-002,2.0507813e-002,3.3325195e-002,3.1524658e-002,1.4587402e-002,6.7138672e-004,-8.3312988e-003,-9.8266602e-003,3.7536621e-003,1.3214111e-002,7.2021484e-003,4.0588379e-003,-9.3078613e-003,-1.8890381e-002,-1.5502930e-002,-1.8920898e-002,-1.5869141e-002,-9.4604492e-003,9.1552734e-005,1.6082764e-002,3.0090332e-002,3.6895752e-002,2.7923584e-002,1.4160156e-002,2.1362305e-004,-1.1352539e-002,-6.7138672e-003,-2.1057129e-003,-6.1035156e-005,6.6223145e-003,4.1198730e-003,4.3640137e-003,8.3312988e-003,8.0261230e-003,9.5214844e-003,8.7890625e-003,9.6130371e-003,7.4462891e-003,3.2043457e-003,-3.6621094e-003,-1.2359619e-002,-1.2023926e-002,9.1552734e-004,1.8585205e-002,3.4545898e-002,4.2816162e-002,2.6916504e-002,1.2176514e-002,4.1809082e-003,-1.4648438e-003,1.6021729e-002,2.4444580e-002,1.9470215e-002,1.7883301e-002,5.5541992e-003,2.6855469e-003,1.6357422e-002,2.3529053e-002,2.8381348e-002,2.8625488e-002,1.6693115e-002,1.0009766e-002,1.0467529e-002,7.9650879e-003,6.5612793e-003,2.5939941e-003,-6.5917969e-003,-9.1247559e-003,-5.8288574e-003,-2.1362305e-003,1.0986328e-003,2.5634766e-003,-1.8920898e-003,-3.2653809e-003,3.0212402e-003,8.1481934e-003,1.8554688e-002,2.7282715e-002,3.0670166e-002,3.3630371e-002,2.9907227e-002,2.0324707e-002,6.5002441e-003,-6.1645508e-003,-9.6740723e-003,-6.0119629e-003,5.5847168e-003,1.4221191e-002,8.6975098e-003,2.8686523e-003,-6.0729980e-003,-7.0190430e-003,1.4984131e-002,2.9815674e-002,3.9459229e-002,4.2480469e-002,2.6245117e-002,1.7883301e-002,2.4414063e-002,2.7648926e-002,3.5278320e-002,3.2318115e-002,5.4016113e-003,-1.3336182e-002,-2.4261475e-002,-2.8564453e-002,-1.2664795e-002,-2.5634766e-003,-6.4697266e-003,-5.4016113e-003,-8.6364746e-003,-7.1716309e-003,8.4838867e-003,1.2420654e-002,7.1105957e-003,-5.4931641e-004,-1.2207031e-002,-1.5075684e-002,-9.1552734e-005,1.4099121e-002,2.2003174e-002,3.0151367e-002,2.3437500e-002,2.1209717e-002,2.6550293e-002,2.3223877e-002,2.1545410e-002,1.2878418e-002,-8.8500977e-004,-7.4157715e-003,-3.8757324e-003,8.8500977e-004,5.9509277e-003,9.3688965e-003,1.2512207e-003,7.3242188e-004,8.5449219e-003,1.6571045e-002,3.0670166e-002,3.8757324e-002,3.7322998e-002,3.9733887e-002,4.5532227e-002,5.1055908e-002,5.8105469e-002,5.4229736e-002,3.0670166e-002,2.5939941e-003,-2.8625488e-002,-5.5297852e-002,-6.2316895e-002,-6.4361572e-002,-5.8990479e-002,-4.1748047e-002,-2.6733398e-002,-9.1552734e-005,2.9998779e-002,5.6091309e-002,7.9193115e-002,8.5937500e-002,7.7972412e-002,5.3131104e-002,1.8585205e-002,-2.1240234e-002,-5.2795410e-002,-7.4310303e-002,-8.1085205e-002,-6.8176270e-002,-5.1025391e-002,-1.5136719e-002,1.7944336e-002,5.5450439e-002,9.1979980e-002,1.1178589e-001,1.2747192e-001,1.1993408e-001,1.0739136e-001,8.0596924e-002,5.2154541e-002,1.9775391e-002,-1.8951416e-002,-4.4494629e-002,-6.9610596e-002,-7.1899414e-002,-6.2316895e-002,-4.1625977e-002,-2.1179199e-002,1.8310547e-004,1.8920898e-002,3.2043457e-002,5.4595947e-002,5.5297852e-002,4.9468994e-002,2.7160645e-002,-5.9204102e-003,-2.9235840e-002,-3.7719727e-002,-3.2836914e-002,-2.4139404e-002,-4.5166016e-003,-2.5329590e-003,1.5411377e-002,3.5797119e-002,4.9194336e-002,6.8817139e-002,6.7565918e-002,6.0394287e-002,4.8278809e-002,4.5593262e-002,3.6499023e-002,2.4719238e-002,4.6997070e-003,-3.8238525e-002,-6.2072754e-002,-7.1136475e-002,-6.0180664e-002,-2.4383545e-002,7.3547363e-003,1.5930176e-002,2.6306152e-002,2.9083252e-002,3.1463623e-002,5.9234619e-002,6.3537598e-002,5.9906006e-002,4.7485352e-002,1.9592285e-002,2.9602051e-003,-2.5634766e-003,-1.0009766e-002,-2.5238037e-002,-3.3569336e-002,-4.7454834e-002,-3.8238525e-002,-2.2277832e-003,3.0273438e-002,5.6945801e-002,6.5063477e-002,4.2175293e-002,1.8463135e-002,1.4251709e-002,6.1950684e-003,2.3773193e-002,3.2897949e-002,1.8035889e-002,1.4556885e-002,-4.3334961e-003,-1.0711670e-002,-2.5939941e-003,1.0681152e-003,7.3242188e-003,1.6082764e-002,2.6550293e-002,4.2266846e-002,6.6406250e-002,7.7697754e-002,7.2998047e-002,5.4473877e-002,2.0935059e-002,-9.7045898e-003,-2.1453857e-002,-2.9846191e-002,-2.7282715e-002,-2.0141602e-002,-3.2104492e-002,-2.9876709e-002,-2.8869629e-002,-2.1209717e-002,5.9204102e-003,2.5115967e-002,4.4616699e-002,5.8502197e-002,6.2408447e-002,6.2805176e-002,6.1584473e-002,4.7851563e-002,2.5543213e-002,-3.0517578e-005,-2.6458740e-002,-3.7353516e-002,-3.0090332e-002,-1.2084961e-002,5.4931641e-003,2.2766113e-002,2.0263672e-002,1.6479492e-002,1.8249512e-002,1.1718750e-002,2.2613525e-002,2.3315430e-002,2.0843506e-002,2.0507813e-002,1.2451172e-002,9.2163086e-003,2.6550293e-003,-3.4179688e-003,-1.3427734e-002,-1.6723633e-002,-1.3549805e-002,-4.8217773e-003,1.1596680e-002,2.2766113e-002,2.4475098e-002,2.1240234e-002,1.5106201e-002,5.9509277e-003,5.0964355e-003,-3.0517578e-003,-1.2817383e-002,-1.8432617e-002,-2.3437500e-002,-1.5625000e-002,-1.4038086e-003,1.2542725e-002,1.2786865e-002,1.1383057e-002,1.0986328e-003,-5.0048828e-003,9.9487305e-003,2.0782471e-002,3.6834717e-002,4.3945313e-002,2.9785156e-002,1.8646240e-002,8.1481934e-003,9.4604492e-004,8.9721680e-003,1.1413574e-002,4.7607422e-003,2.0446777e-003,-4.7912598e-003,-1.2512207e-003,1.7089844e-002,3.0944824e-002,3.7170410e-002,3.3721924e-002,1.2847900e-002,-6.1340332e-003,-1.0223389e-002,-1.2969971e-002,9.1552734e-004,1.3458252e-002,1.0620117e-002,1.3031006e-002,5.1269531e-003,4.8828125e-004,7.0190430e-003,6.8969727e-003,8.6059570e-003,6.9580078e-003,-1.3122559e-003,-5.7678223e-003,-5.5236816e-003,-2.8991699e-003,4.6386719e-003,1.3397217e-002,1.8066406e-002,2.4475098e-002,2.6062012e-002,2.3986816e-002,1.9653320e-002,1.1199951e-002,4.9438477e-003,-1.0986328e-003,-4.9133301e-003,-8.6975098e-003,-1.4556885e-002,-1.8615723e-002,-2.2583008e-002,-2.1575928e-002,-1.4221191e-002,-6.1035156e-003,1.8920898e-003,9.0637207e-003,1.1291504e-002,1.4556885e-002,2.1270752e-002,2.5360107e-002,3.0059814e-002,2.8778076e-002,1.8157959e-002,8.9111328e-003,-9.1552734e-004,-4.9133301e-003,1.9836426e-003,1.0192871e-002,1.6815186e-002,2.3834229e-002,2.1728516e-002,2.1087646e-002,2.2674561e-002,1.7150879e-002,1.3397217e-002,2.0141602e-003,-1.2939453e-002,-2.1514893e-002,-2.1362305e-002,-1.3061523e-002,3.6621094e-004,1.1138916e-002,3.6926270e-003,-2.7160645e-003,-1.0955811e-002,-1.5411377e-002,1.9531250e-003,1.1840820e-002,1.7608643e-002,1.8737793e-002,2.9602051e-003,-5.1574707e-003,-7.9345703e-004,2.4414063e-003,1.3671875e-002,2.1423340e-002,1.5533447e-002,1.9989014e-002,2.9754639e-002,3.9886475e-002,5.4718018e-002,5.7006836e-002,4.2510986e-002,2.6611328e-002,1.1505127e-002,-3.7536621e-003,-6.5002441e-003,-1.4587402e-002,-2.8991699e-002,-3.4820557e-002,-3.6285400e-002,-2.7648926e-002,-1.0375977e-002,-3.0517578e-004,-5.4931641e-003,-1.2176514e-002,-2.0233154e-002,-2.2918701e-002,-2.1057129e-003,1.2847900e-002,2.2491455e-002,3.1433105e-002,2.0507813e-002,1.6906738e-002,1.8676758e-002,1.5869141e-002,1.8432617e-002,1.7181396e-002,1.1322021e-002,9.0942383e-003,7.1716309e-003,1.1291504e-003,-9.4299316e-003,-2.1789551e-002,-3.2257080e-002,-3.5949707e-002,-2.4963379e-002,-1.4648438e-002,-1.0223389e-002,-6.7443848e-003,-1.7456055e-002,-2.0721436e-002,-1.0589600e-002,-1.1901855e-003,1.7517090e-002,2.7832031e-002,1.9073486e-002,1.0437012e-002,-2.6245117e-003,-1.3946533e-002,-8.8500977e-003,-6.4392090e-003,-5.5847168e-003,-2.9296875e-003,-1.1657715e-002,-1.4984131e-002,-1.2451172e-002,-9.3078613e-003,2.3498535e-003,1.1535645e-002,1.4312744e-002,1.5045166e-002,8.5449219e-003,1.4648438e-003,-1.1596680e-003,-5.5847168e-003,-5.6152344e-003,-4.6997070e-003,-3.7841797e-003,1.6479492e-003,7.2021484e-003,1.2359619e-002,1.3458252e-002,8.5754395e-003,-7.6293945e-004,-1.1016846e-002,-1.4129639e-002,-1.5869141e-002,-1.1077881e-002,-5.9204102e-003,-6.6833496e-003,-2.5634766e-003,-4.5776367e-004,2.0141602e-003,3.7536621e-003,-1.5258789e-003,-1.2451172e-002,-2.1911621e-002,-2.2277832e-002,-1.7517090e-002,-2.6855469e-003,1.0131836e-002,9.6435547e-003,1.0375977e-002,5.1879883e-003,1.9531250e-003,1.0375977e-002,1.0711670e-002,7.2326660e-003,2.1972656e-003,-7.7819824e-003,-1.1138916e-002,-7.0495605e-003,-5.0964355e-003,-8.6364746e-003,-1.2359619e-002,-1.9470215e-002,-1.7211914e-002,1.0070801e-003,1.5441895e-002,2.4078369e-002,2.1789551e-002,-1.6784668e-003,-2.1881104e-002,-2.7099609e-002,-2.7343750e-002,-7.4462891e-003,1.0711670e-002,1.2634277e-002,1.7272949e-002,5.4321289e-003,-6.1950684e-003,-9.5825195e-003,-1.8066406e-002,-1.8524170e-002,-1.7639160e-002,-1.3244629e-002,-4.0588379e-003,1.6479492e-003,5.9509277e-003,-8.2397461e-004,-9.3383789e-003,-1.5289307e-002,-1.9531250e-002,-9.7656250e-003,-7.6293945e-004,5.8593750e-003,1.2237549e-002,4.5166016e-003,-3.6621094e-003,-1.2664795e-002,-2.3406982e-002,-2.3834229e-002,-2.2705078e-002,-1.6052246e-002,-5.6762695e-003,-1.7089844e-003,1.3732910e-003,-4.0283203e-003,-1.1474609e-002,-1.5350342e-002,-2.0782471e-002,-1.7242432e-002,-1.3793945e-002,-1.0986328e-002,-4.2419434e-003,4.2724609e-004,6.4086914e-003,9.0026855e-003,5.6457520e-003,-4.8522949e-003,-1.6540527e-002,-2.2247314e-002,-2.3590088e-002,-1.4953613e-002,-1.0131836e-002,-1.7639160e-002,-2.5512695e-002,-4.1442871e-002,-4.8858643e-002,-3.6193848e-002,-2.4078369e-002,-8.1787109e-003,3.2958984e-003,-2.6855469e-003,-3.4179688e-003,5.1879883e-004,2.1362305e-003,1.2512207e-002,1.2359619e-002,1.2817383e-003,-4.8217773e-003,-8.3007813e-003,-3.9062500e-003,1.1383057e-002,2.1728516e-002,1.7303467e-002,1.2115479e-002,-1.4038086e-003,-1.2207031e-002,-7.6599121e-003,-9.6435547e-003,-1.0162354e-002,-1.1993408e-002,-2.2796631e-002,-2.6885986e-002,-2.6245117e-002,-2.5695801e-002,-2.0996094e-002,-1.7364502e-002,-1.7425537e-002,-1.4129639e-002,-1.0955811e-002,-9.6740723e-003,-6.8969727e-003,-5.1574707e-003,-1.0070801e-003,4.1503906e-003,7.4768066e-003,6.4697266e-003,-2.4719238e-003,-1.0009766e-002,-1.3183594e-002,-1.1016846e-002,1.4343262e-003,1.0375977e-002,7.8735352e-003,2.5939941e-003,-1.1413574e-002,-2.1209717e-002,-1.7211914e-002,-1.5075684e-002,-9.4299316e-003,-5.1574707e-003,-1.1566162e-002,-1.3244629e-002,-1.4404297e-002,-1.7120361e-002,-1.8218994e-002,-2.2583008e-002,-2.8625488e-002,-3.1005859e-002,-2.9663086e-002,-2.9083252e-002,-3.0975342e-002,-3.4240723e-002,-3.6071777e-002,-3.2226563e-002,-1.6967773e-002,-2.7770996e-003,8.1176758e-003,1.2908936e-002,2.7465820e-003,-6.3171387e-003,-9.5825195e-003,-1.4617920e-002,-1.0833740e-002,-9.4299316e-003,-1.4434814e-002,-1.3946533e-002,-1.7211914e-002,-1.8249512e-002,-1.7456055e-002,-1.9317627e-002,-1.9195557e-002,-1.7547607e-002,-1.1322021e-002,-6.8359375e-003,-4.1503906e-003,-5.2185059e-003,-1.1474609e-002,-1.4282227e-002,-1.1077881e-002,-7.3547363e-003,-2.2583008e-003,4.5776367e-004,-5.7678223e-003,-8.9721680e-003,-8.8806152e-003,-7.3852539e-003,-4.2724609e-004,8.8500977e-004,-4.7607422e-003,-1.1199951e-002,-2.0568848e-002,-2.8564453e-002,-2.8808594e-002,-3.0181885e-002,-3.0242920e-002,-2.5970459e-002,-2.3620605e-002,-1.6723633e-002,-9.0026855e-003,-3.4179688e-003,8.8500977e-004,1.8920898e-003,1.1901855e-003,-2.4414063e-003,-6.8969727e-003,-1.3916016e-002,-2.0416260e-002,-2.4902344e-002,-2.4932861e-002,-2.0019531e-002,-1.2603760e-002,-3.5705566e-003,-1.9226074e-003,-3.4484863e-003,-9.2163086e-003,-1.5441895e-002,-1.2145996e-002,-7.1105957e-003,5.8593750e-003,1.6418457e-002,1.4526367e-002,7.9650879e-003,-1.3305664e-002,-3.3203125e-002,-4.3273926e-002,-4.9316406e-002,-4.1412354e-002,-3.2501221e-002,-3.1433105e-002,-2.7008057e-002,-3.1646729e-002,-3.6376953e-002,-3.5919189e-002,-4.2236328e-002,-4.3670654e-002,-4.5410156e-002,-4.1351318e-002,-3.0975342e-002,-1.7303467e-002,-3.2348633e-003,-5.1879883e-004,2.7465820e-003,2.1667480e-003,3.2958984e-003,1.4862061e-002,1.8035889e-002,1.2573242e-002,1.0375977e-003,-2.2888184e-002,-4.0252686e-002,-3.9550781e-002,-3.6254883e-002,-2.4688721e-002,-1.5167236e-002,-2.5329590e-002,-2.9907227e-002,-3.3630371e-002,-3.5827637e-002,-1.9256592e-002,-9.5214844e-003,-4.3640137e-003,0.0000000e+000,-6.5002441e-003,-1.0040283e-002,-7.6599121e-003,-7.8125000e-003,-4.0588379e-003,1.8310547e-003,2.9907227e-003,7.2326660e-003,9.6740723e-003,1.0650635e-002,1.0192871e-002,6.4697266e-003,2.2583008e-003,-4.9438477e-003,-1.0650635e-002,-1.7486572e-002,-2.4230957e-002,-2.7069092e-002,-2.7313232e-002,-2.3193359e-002,-1.7883301e-002,-1.1657715e-002,-1.0314941e-002,-7.2021484e-003,-1.8005371e-003,3.2043457e-003,1.4373779e-002,1.9531250e-002,1.6815186e-002,1.1108398e-002,-2.4414063e-004,-8.6364746e-003,-7.2631836e-003,-6.4697266e-003,-5.4931641e-003,-5.7067871e-003,-1.7517090e-002,-2.5970459e-002,-3.1707764e-002,-3.8604736e-002,-3.8635254e-002,-4.1534424e-002,-4.5776367e-002,-4.5654297e-002,-4.1900635e-002,-3.5461426e-002,-2.7587891e-002,-2.3315430e-002,-2.8503418e-002,-3.1768799e-002,-3.0181885e-002,-2.3834229e-002,-4.4250488e-003,1.1108398e-002,1.6418457e-002,1.7456055e-002,3.3874512e-003,-1.2329102e-002,-2.0507813e-002,-3.2379150e-002,-3.5034180e-002,-3.5461426e-002,-3.5797119e-002,-2.6000977e-002,-1.7211914e-002,-8.8806152e-003,-6.9274902e-003,-1.1230469e-002,-2.0538330e-002,-2.9846191e-002,-2.8411865e-002,-2.8381348e-002,-2.1606445e-002,-1.4892578e-002,-1.6693115e-002,-1.2115479e-002,-9.9182129e-003,-6.4392090e-003,-4.8828125e-004,-9.1552734e-004,-5.8593750e-003,-1.4129639e-002,-2.3254395e-002,-3.3386230e-002,-3.8208008e-002,-4.0893555e-002,-4.0130615e-002,-3.3996582e-002,-2.8106689e-002,-1.9836426e-002,-1.7486572e-002,-1.7608643e-002,-2.0446777e-002,-2.3498535e-002,-1.8066406e-002,-1.1077881e-002,2.8381348e-003,1.5625000e-002,1.9958496e-002,2.1148682e-002,1.0375977e-002,-3.6315918e-003,-1.5075684e-002,-2.5756836e-002,-2.3284912e-002,-1.7639160e-002,-1.1779785e-002,-3.6926270e-003,-7.9345703e-003,-1.0070801e-002,-1.1657715e-002,-1.5380859e-002,-1.1474609e-002,-1.5411377e-002,-2.4566650e-002,-3.3203125e-002,-4.1503906e-002,-3.9855957e-002,-2.7343750e-002,-1.3153076e-002,-5.4321289e-003,2.0141602e-003,-2.0141602e-003,-5.8898926e-003,-3.1433105e-003,-4.5166016e-003,1.8920898e-003,7.2937012e-003,1.0681152e-002,1.4526367e-002,9.3688965e-003,-2.1667480e-003,-2.2125244e-002,-3.7475586e-002,-3.5125732e-002,-2.1575928e-002,8.8195801e-003,3.2806396e-002,2.5878906e-002,1.0681152e-002,-2.4353027e-002,-5.6213379e-002,-5.2124023e-002,-5.1696777e-002,-3.8177490e-002,-2.2430420e-002,-2.9876709e-002,-1.9958496e-002,-7.8430176e-003,3.9672852e-004,9.0332031e-003,-7.0190430e-004,-2.5360107e-002,-4.5806885e-002,-4.6020508e-002,-3.7963867e-002,-9.7656250e-003,1.8585205e-002,2.3345947e-002,3.4545898e-002,3.4362793e-002,2.8106689e-002,2.8778076e-002,1.0009766e-002,-1.5228271e-002,-3.8635254e-002,-5.3527832e-002,-5.7647705e-002,-5.0109863e-002,-4.1595459e-002,-5.0323486e-002,-4.8095703e-002,-4.2633057e-002,-2.7862549e-002,1.0589600e-002,3.4027100e-002,3.7658691e-002,2.5054932e-002,-1.4007568e-002,-5.3588867e-002,-6.7413330e-002,-7.7606201e-002,-6.4086914e-002,-3.6773682e-002,-2.1362305e-002,1.0375977e-002,2.8930664e-002,4.4128418e-002,5.6884766e-002,5.2551270e-002,4.9407959e-002,3.2012939e-002,1.7639160e-002,-4.0283203e-003,-2.8381348e-002,-4.5806885e-002,-6.2988281e-002,-6.4605713e-002,-6.0577393e-002,-4.7515869e-002,-3.5949707e-002,-1.8554688e-002,6.7138672e-004,1.7547607e-002,3.8848877e-002,4.2236328e-002,3.1890869e-002,7.0800781e-003,-2.5054932e-002,-5.3039551e-002,-6.2103271e-002,-6.2225342e-002,-5.7952881e-002,-4.2144775e-002,-4.0344238e-002,-2.0446777e-002,8.7585449e-003,3.8299561e-002,7.5836182e-002,8.9599609e-002,7.8613281e-002,4.8400879e-002,9.6435547e-003,-3.2165527e-002,-5.0476074e-002,-6.4270020e-002,-7.2845459e-002,-6.4483643e-002,-6.8969727e-002,-5.4443359e-002,-3.6163330e-002,-1.5167236e-002,1.1413574e-002,2.6794434e-002,4.1473389e-002,4.2144775e-002,3.9764404e-002,2.1942139e-002,-5.7373047e-003,-3.7902832e-002,-6.9976807e-002,-8.4289551e-002,-7.7056885e-002,-5.0415039e-002,-2.0782471e-002,1.6448975e-002,3.1311035e-002,4.3151855e-002,5.1330566e-002,4.0130615e-002,3.6804199e-002,1.0528564e-002,-1.9805908e-002,-4.8522949e-002,-6.9732666e-002,-7.3059082e-002,-6.5673828e-002,-4.5562744e-002,-3.7109375e-002,-1.8493652e-002,-6.7443848e-003,5.1879883e-003,2.5238037e-002,2.7404785e-002,2.6428223e-002,1.1566162e-002,-6.8664551e-003,-2.7191162e-002,-4.1107178e-002,-5.1086426e-002,-6.1950684e-002,-5.5389404e-002,-4.2755127e-002,-1.3671875e-002,2.2186279e-002,5.1971436e-002,6.2164307e-002,5.8959961e-002,4.6844482e-002,2.4230957e-002,2.1301270e-002,5.0659180e-003,-1.3092041e-002,-2.7618408e-002,-5.3649902e-002,-5.7708740e-002,-4.7058105e-002,-2.8289795e-002,-7.1105957e-003,1.1383057e-002,1.2969971e-002,1.2603760e-002,1.7852783e-002,8.3312988e-003,4.3945313e-003,-1.1779785e-002,-3.4057617e-002,-4.5837402e-002,-4.6813965e-002,-3.7689209e-002,-2.7832031e-002,-1.6113281e-002,-2.1972656e-002,-1.8096924e-002,-2.7770996e-003,1.2664795e-002,4.2083740e-002,5.3680420e-002,4.0313721e-002,1.7456055e-002,-1.4312744e-002,-4.3640137e-002,-4.6875000e-002,-4.5471191e-002,-3.7384033e-002,-1.4221191e-002,-2.8991699e-003,1.9317627e-002,3.5339355e-002,3.8543701e-002,3.1951904e-002,1.2023926e-002,-1.2207031e-004,-1.2359619e-002,-1.4343262e-003,6.6223145e-003,9.4604492e-004,-5.2490234e-003,-3.6376953e-002,-5.3802490e-002,-4.9041748e-002,-3.6651611e-002,-3.8146973e-003,2.3406982e-002,2.7099609e-002,2.8778076e-002,1.8493652e-002,2.7160645e-003,7.6293945e-004,-1.3732910e-002,-2.9235840e-002,-4.1931152e-002,-5.5786133e-002,-5.2276611e-002,-3.4637451e-002,-9.2773438e-003,1.3366699e-002,3.4576416e-002,4.0344238e-002,3.8146973e-002,3.4484863e-002,1.8707275e-002,1.2115479e-002,7.3242188e-004,-5.6762695e-003,-1.0192871e-002,-2.3284912e-002,-3.0059814e-002,-4.3914795e-002,-4.1992188e-002,-2.0538330e-002,7.9040527e-003,4.4372559e-002,6.6741943e-002,5.8746338e-002,3.8391113e-002,1.1779785e-002,-1.7425537e-002,-1.6448975e-002,-1.8310547e-002,-1.8096924e-002,-8.3312988e-003,-1.6845703e-002,-9.9487305e-003,-1.9226074e-003,4.3640137e-003,1.1749268e-002,1.1138916e-002,8.7280273e-003,1.8005371e-003,-1.5258789e-004,-1.1718750e-002,-2.7587891e-002,-4.2144775e-002,-5.4443359e-002,-5.2490234e-002,-3.5552979e-002,-1.3488770e-002,4.8828125e-004,1.4984131e-002,1.5960693e-002,1.6571045e-002,2.3284912e-002,1.4892578e-002,2.4414063e-003,-1.9775391e-002,-4.5440674e-002,-5.9997559e-002,-5.5358887e-002,-4.1503906e-002,-2.6184082e-002,-7.3242188e-003,-4.4555664e-003,5.0659180e-003,2.0843506e-002,3.0578613e-002,4.7515869e-002,4.8004150e-002,3.3386230e-002,1.2207031e-002,-1.4038086e-002,-3.6468506e-002,-4.5501709e-002,-4.2785645e-002,-2.9846191e-002,-5.6152344e-003,1.0101318e-002,2.4200439e-002,1.9836426e-002,7.4462891e-003,-9.7656250e-004,-1.7761230e-002,-1.5411377e-002,-1.9378662e-002,-2.4841309e-002,-2.2399902e-002,-2.5146484e-002,-1.4526367e-002,1.3732910e-003,1.7578125e-002,2.5970459e-002,3.2562256e-002,3.3935547e-002,3.1738281e-002,3.6926270e-002,2.9113770e-002,1.6143799e-002,2.8686523e-003,-8.5449219e-003,-9.9182129e-003,3.0517578e-004,7.1105957e-003,-2.7770996e-003,-1.1871338e-002,-2.7465820e-002,-3.1524658e-002,-6.4392090e-003,1.3153076e-002,2.8320313e-002,3.4454346e-002,1.2603760e-002,-4.0283203e-003,-5.7678223e-003,-9.5825195e-003,1.4648438e-003,7.4157715e-003,-7.5683594e-003,-1.2786865e-002,-1.8371582e-002,-1.8249512e-002,-5.7983398e-004,1.3275146e-002,2.1362305e-002,2.3284912e-002,8.4228516e-003,-1.3916016e-002,-3.3355713e-002,-4.8767090e-002,-3.8208008e-002,-1.8218994e-002,6.3781738e-003,2.6123047e-002,7.8735352e-003,-1.1444092e-002,-3.4576416e-002,-4.5654297e-002,-7.4462891e-003,2.4627686e-002,4.9133301e-002,6.0699463e-002,2.0538330e-002,-1.2359619e-002,-2.6611328e-002,-4.0100098e-002,-1.4953613e-002,1.7700195e-003,-4.6997070e-003,-7.3242188e-004,-1.3031006e-002,-1.6387939e-002,-2.1362305e-004,4.9438477e-003,9.1247559e-003,8.9721680e-003,-9.1552734e-005,-5.6762695e-003,-2.7160645e-003,-9.4604492e-004,3.4484863e-003,1.4923096e-002,2.5817871e-002,4.1076660e-002,5.1483154e-002,4.8187256e-002,2.4810791e-002,-5.9204102e-003,-3.1829834e-002,-5.1086426e-002,-4.0527344e-002,-2.8900146e-002,-2.4230957e-002,-1.3916016e-002,-2.2644043e-002,-1.8493652e-002,5.7678223e-003,2.5268555e-002,5.3497314e-002,6.6741943e-002,5.1757813e-002,3.4057617e-002,1.5350342e-002,-1.8920898e-003,1.3427734e-003,3.4484863e-003,-1.7089844e-003,-2.6550293e-003,-2.2430420e-002,-3.6163330e-002,-4.0740967e-002,-3.8391113e-002,-1.0040283e-002,2.0172119e-002,4.6752930e-002,5.6976318e-002,3.1982422e-002,-2.1362305e-004,-2.5878906e-002,-3.8848877e-002,-7.1105957e-003,2.0111084e-002,2.2369385e-002,1.8829346e-002,-3.0731201e-002,-5.5938721e-002,-3.3264160e-002,-6.9885254e-003,4.8950195e-002,8.0932617e-002,5.4260254e-002,3.2562256e-002,1.0528564e-002,-1.2390137e-002,3.0517578e-003,-9.0942383e-003,-4.9987793e-002,-6.8572998e-002,-7.8186035e-002,-5.1757813e-002,1.3885498e-002,5.8227539e-002,4.5745850e-002,2.5329590e-002,-1.3244629e-002,-3.5644531e-002,1.7700195e-002,4.3670654e-002,5.0964355e-002,5.2032471e-002,6.1340332e-003,-6.3171387e-003,2.2277832e-002,2.6184082e-002,4.6081543e-003,-3.2806396e-002,-9.5916748e-002,-1.0122681e-001,-7.2631836e-003,8.3129883e-002,1.4938354e-001,1.6223145e-001,3.9337158e-002,-6.1706543e-002,-8.0230713e-002,-8.7707520e-002,1.4862061e-002,8.2336426e-002,3.7231445e-002,2.4200439e-002,-2.9418945e-002,-5.1300049e-002,1.8341064e-002,3.8146973e-002,2.3132324e-002,3.3264160e-003,-4.8675537e-002,-6.1645508e-002,-1.2207031e-004,3.8574219e-002,4.8248291e-002,4.2449951e-002,-2.6458740e-002,-7.0007324e-002,-5.7373047e-002,-5.9844971e-002,-4.6386719e-002,-3.9855957e-002,-7.2448730e-002,-6.5490723e-002,-2.2186279e-002,1.4373779e-002,4.7607422e-002,4.6691895e-002,-1.0955811e-002,-5.4901123e-002,-5.1544189e-002,-4.1473389e-002,1.2481689e-002,4.9865723e-002,1.7944336e-002,1.5869141e-003,-2.9846191e-002,-4.9621582e-002,-1.2817383e-002,2.9296875e-003,4.3640137e-003,7.0495605e-003,-1.4434814e-002,-1.7272949e-002,1.5228271e-002,4.3029785e-002,7.1929932e-002,8.9782715e-002,7.2235107e-002,5.3131104e-002,3.6346436e-002,1.3732910e-002,8.7890625e-003,4.1809082e-003,-2.2583008e-003,2.4719238e-003,1.2512207e-003,5.5236816e-003,7.3242188e-003,1.2115479e-002,2.6916504e-002,4.2144775e-002,6.6986084e-002,7.7270508e-002,6.5521240e-002,4.1259766e-002,3.1127930e-003,-2.7313232e-002,-2.5726318e-002,-1.4007568e-002,8.8195801e-003,3.4057617e-002,2.2674561e-002,1.5502930e-002,6.1035156e-004,-1.8615723e-002,-1.1291504e-002,-1.5838623e-002,-1.6204834e-002,-1.0986328e-002,-6.5917969e-003,9.7351074e-003,2.9327393e-002,4.1473389e-002,3.2745361e-002,1.6937256e-002,-3.0212402e-003,-1.2207031e-002,1.3397217e-002,4.2388916e-002,7.0709229e-002,8.9172363e-002,6.1981201e-002,2.6275635e-002,-1.6174316e-002,-6.5246582e-002,-7.9376221e-002,-8.9538574e-002,-8.1665039e-002,-5.6640625e-002,-4.1778564e-002,-2.0538330e-002,-2.3254395e-002,-3.6041260e-002,-5.1696777e-002,-7.1990967e-002,-6.2500000e-002,-5.0750732e-002,-2.4017334e-002,5.4016113e-003,1.2451172e-002,2.5482178e-002,2.4963379e-002,2.3101807e-002,2.8961182e-002,2.3712158e-002,1.8951416e-002,9.7961426e-003,-1.9226074e-003,-1.0406494e-002,-1.4617920e-002,-1.5380859e-002,-1.3336182e-002,-5.8898926e-003,2.0141602e-003,1.0162354e-002,1.1566162e-002,5.7983398e-003,-5.4626465e-003,-1.8951416e-002,-2.1453857e-002,-1.9805908e-002,-7.6293945e-003,9.3078613e-003,1.9287109e-002,3.5003662e-002,4.4403076e-002,4.9743652e-002,5.1025391e-002,4.0954590e-002,2.7282715e-002,1.5869141e-002,2.0751953e-002,3.4423828e-002,5.9020996e-002,8.0749512e-002,7.6080322e-002,6.5704346e-002,3.7841797e-002,8.0566406e-003,1.8310547e-004,-1.0620117e-002,-6.8359375e-003,-1.0375977e-003,-8.2092285e-003,-9.6435547e-003,-2.2583008e-002,-3.3111572e-002,-3.6224365e-002,-3.6651611e-002,-1.9714355e-002,3.3569336e-004,2.1850586e-002,3.9550781e-002,3.6499023e-002,2.8015137e-002,1.3519287e-002,-2.3803711e-003,-1.5258789e-003,-3.2653809e-003,-3.7536621e-003,-2.3498535e-003,-1.3244629e-002,-1.7669678e-002,-2.0233154e-002,-2.1179199e-002,-1.5228271e-002,-1.3275146e-002,-1.1779785e-002,-1.3488770e-002,-1.6754150e-002,-2.2186279e-002,-2.8717041e-002,-3.5552979e-002,-4.3151855e-002,-4.8095703e-002,-5.1116943e-002,-5.0292969e-002,-4.9774170e-002,-4.6600342e-002,-4.5013428e-002,-4.4860840e-002,-4.4342041e-002,-4.2785645e-002,-3.3416748e-002,-1.9775391e-002,1.8310547e-003,1.8463135e-002,2.3223877e-002,1.9866943e-002,3.6621094e-003,-7.2937012e-003,-3.0517578e-005,1.1413574e-002,3.1280518e-002,4.3884277e-002,2.6519775e-002,1.0711670e-002,-9.2468262e-003,-2.2277832e-002,-2.6245117e-003,1.4038086e-002,2.8930664e-002,4.5227051e-002,3.8177490e-002,3.4606934e-002,3.8238525e-002,3.5400391e-002,4.2388916e-002,4.4433594e-002,3.8482666e-002,3.6560059e-002,3.2592773e-002,3.0792236e-002,3.1585693e-002,3.3691406e-002,3.3142090e-002,3.3020020e-002,3.2104492e-002,2.6733398e-002,2.1575928e-002,1.7333984e-002,2.0935059e-002,3.0303955e-002,4.7088623e-002,5.7891846e-002,5.2246094e-002,4.1351318e-002,2.0050049e-002,5.9204102e-003,1.5167236e-002,2.5878906e-002,3.8299561e-002,4.3121338e-002,1.3824463e-002,-1.4709473e-002,-3.9855957e-002,-5.9631348e-002,-4.2510986e-002,-2.5512695e-002,-1.1688232e-002,3.0517578e-003,-9.4604492e-003,-1.9622803e-002,-2.4902344e-002,-3.5644531e-002,-3.0700684e-002,-3.0731201e-002,-3.4820557e-002,-3.2043457e-002,-3.1768799e-002,-2.3468018e-002,-1.2054443e-002,-2.8686523e-003,1.2207031e-004,-1.2207031e-004,-3.3569336e-003,-9.6130371e-003,-1.0772705e-002,-2.0080566e-002,-3.5186768e-002,-4.7302246e-002,-5.7586670e-002,-5.6518555e-002,-3.9733887e-002,-2.2003174e-002,-1.6082764e-002,-1.7761230e-002,-4.2205811e-002,-6.5917969e-002,-7.0678711e-002,-7.2082520e-002,-4.6997070e-002,-2.2460938e-002,-1.4923096e-002,-2.7465820e-003,-8.3618164e-003,-9.8876953e-003,1.4953613e-003,7.0495605e-003,2.0111084e-002,2.6397705e-002,2.0629883e-002,1.6571045e-002,1.0986328e-002,9.1552734e-003,1.6784668e-002,2.4169922e-002,2.8930664e-002,3.4271240e-002,3.3935547e-002,3.7414551e-002,4.8553467e-002,5.6610107e-002,6.2652588e-002,5.7373047e-002,3.4088135e-002,1.0406494e-002,-4.9743652e-003,-1.1016846e-002,7.2937012e-003,2.9785156e-002,4.1229248e-002,5.4534912e-002,4.6264648e-002,3.6346436e-002,3.5125732e-002,2.2247314e-002,1.6906738e-002,6.9580078e-003,-5.1574707e-003,-8.7585449e-003,-6.8664551e-003,-2.7770996e-003,-5.5236816e-003,-6.3171387e-003,-1.6326904e-002,-1.8524170e-002,-6.1035156e-003,-1.6174316e-003,1.0375977e-003,-6.5612793e-003,-3.2623291e-002,-5.2185059e-002,-5.5664063e-002,-5.5358887e-002,-4.0466309e-002,-2.9846191e-002,-4.1442871e-002,-4.5440674e-002,-5.0323486e-002,-4.9316406e-002,-2.6062012e-002,-1.1688232e-002,-9.1857910e-003,-1.1260986e-002,-2.8045654e-002,-3.9276123e-002,-2.9052734e-002,-1.6235352e-002,6.0119629e-003,2.5787354e-002,2.2277832e-002,1.8463135e-002,6.8359375e-003,-5.9509277e-003,-1.3732910e-003,-3.2958984e-003,-4.8522949e-003,-7.9650879e-003,-2.1575928e-002,-2.5329590e-002,-1.7974854e-002,-7.0800781e-003,8.1176758e-003,1.3885498e-002,-1.2512207e-003,-1.7608643e-002,-3.2043457e-002,-4.0222168e-002,-2.2338867e-002,-5.0964355e-003,6.2866211e-003,2.0233154e-002,1.4587402e-002,1.1596680e-002,1.2695313e-002,4.4555664e-003,1.8005371e-003,-3.5705566e-003,-5.7678223e-003,1.2817383e-003,1.4770508e-002,2.8472900e-002,3.2989502e-002,3.8238525e-002,3.6621094e-002,3.8238525e-002,4.9804688e-002,5.0537109e-002,4.1320801e-002,2.2613525e-002,-5.8898926e-003,-2.3834229e-002,-1.8096924e-002,-2.8991699e-003,2.1850586e-002,4.7515869e-002,5.0872803e-002,5.5175781e-002,5.3314209e-002,4.0100098e-002,3.2135010e-002,9.6435547e-003,-1.4831543e-002,-3.5675049e-002,-4.7576904e-002,-4.7790527e-002,-4.1992188e-002,-2.8533936e-002,-2.7679443e-002,-2.1728516e-002,-1.8035889e-002,-1.7395020e-002,-6.1340332e-003,-5.3710938e-003,-3.6010742e-003,-7.6293945e-003,-1.7059326e-002,-2.6367188e-002,-3.6560059e-002,-4.3121338e-002,-4.6051025e-002,-4.3792725e-002,-4.0710449e-002,-3.3660889e-002,-3.0578613e-002,-2.5665283e-002,-1.9744873e-002,-1.7639160e-002,-1.2939453e-002,-1.5686035e-002,-2.2705078e-002,-2.9937744e-002,-3.3752441e-002,-3.4973145e-002,-3.2623291e-002,-3.4240723e-002,-4.9194336e-002,-5.9600830e-002,-6.5399170e-002,-5.9570313e-002,-3.1524658e-002,-7.1716309e-003,5.2185059e-003,1.1047363e-002,-5.1269531e-003,-1.8157959e-002,-9.7351074e-003,-3.1738281e-003,2.0721436e-002,4.2510986e-002,4.3182373e-002,4.9896240e-002,4.5074463e-002,3.7872314e-002,3.5766602e-002,2.5115967e-002,1.4495850e-002,5.5236816e-003,1.2512207e-003,1.1901855e-003,6.0729980e-003,1.2939453e-002,1.4862061e-002,1.9775391e-002,2.4993896e-002,2.5787354e-002,2.8228760e-002,2.5360107e-002,2.1942139e-002,2.5878906e-002,4.0222168e-002,5.7952881e-002,7.2906494e-002,7.8979492e-002,5.9509277e-002,3.5308838e-002,8.3618164e-003,-2.0538330e-002,-2.7740479e-002,-3.6132813e-002,-4.1931152e-002,-3.6499023e-002,-3.5491943e-002,-2.3651123e-002,-7.2326660e-003,1.9836426e-003,2.8381348e-003,-6.0119629e-003,-2.2491455e-002,-4.1107178e-002,-4.5166016e-002,-4.8522949e-002,-4.4036865e-002,-3.0914307e-002,-2.7160645e-002,-1.5411377e-002,-8.8500977e-003,-6.4086914e-003,-4.6691895e-003,-8.5449219e-003,-5.8593750e-003,-4.1198730e-003,5.0354004e-003,8.1176758e-003,3.0517578e-005,-9.7351074e-003,-2.6855469e-002,-3.6193848e-002,-3.1646729e-002,-2.6031494e-002,-2.0843506e-002,-1.8127441e-002,-3.2928467e-002,-4.6844482e-002,-5.7983398e-002,-7.3242188e-002,-7.6507568e-002,-7.7850342e-002,-7.1014404e-002,-5.0964355e-002,-2.4169922e-002,1.2512207e-003,9.8571777e-003,7.8430176e-003,-9.8571777e-003,-2.5360107e-002,-1.4709473e-002,-4.0893555e-003,1.7028809e-002,3.3935547e-002,1.9714355e-002,1.3946533e-002,1.0040283e-002,7.9345703e-003,2.6824951e-002,3.3935547e-002,2.3834229e-002,1.2573242e-002,-6.1035156e-003,-1.8981934e-002,-8.3618164e-003,6.4086914e-004,9.6740723e-003,2.1667480e-002,1.9195557e-002,2.0111084e-002,2.2155762e-002,1.7730713e-002,1.4465332e-002,1.0314941e-002,8.5449219e-003,1.0467529e-002,1.3153076e-002,1.3061523e-002,4.0588379e-003,3.2348633e-003,1.2237549e-002,2.9693604e-002,6.1157227e-002,8.2031250e-002,7.8186035e-002,6.5093994e-002,3.8085938e-002,1.3031006e-002,1.7944336e-002,2.3071289e-002,3.6407471e-002,5.3680420e-002,4.5776367e-002,4.2602539e-002,2.8808594e-002,5.8593750e-003,-1.1566162e-002,-3.6743164e-002,-5.2185059e-002,-6.0974121e-002,-5.8013916e-002,-5.0567627e-002,-5.1635742e-002,-4.9468994e-002,-5.4382324e-002,-5.1452637e-002,-2.9571533e-002,-7.6293945e-003,1.6967773e-002,3.2073975e-002,2.2460938e-002,8.3007813e-003,-8.6059570e-003,-2.7770996e-002,-3.0426025e-002,-3.6437988e-002,-4.6356201e-002,-4.9407959e-002,-6.1706543e-002,-6.6497803e-002,-6.9488525e-002,-7.9101563e-002,-8.8439941e-002,-9.8052979e-002,-9.6801758e-002,-8.5174561e-002,-5.4504395e-002,-2.5238037e-002,-1.0314941e-002,-5.7983398e-004,-9.3688965e-003,-1.1474609e-002,1.0772705e-002,3.1738281e-002,5.8929443e-002,7.4371338e-002,5.2612305e-002,3.3935547e-002,1.4404297e-002,-3.7841797e-003,7.7819824e-003,1.2664795e-002,1.0040283e-002,1.6174316e-002,1.1749268e-002,1.2725830e-002,2.0111084e-002,1.3244629e-002,-2.1362305e-003,-1.7028809e-002,-2.3071289e-002,-1.7608643e-002,9.4604492e-003,3.3172607e-002,3.6163330e-002,4.1473389e-002,3.0029297e-002,2.3620605e-002,3.7994385e-002,3.7719727e-002,3.3966064e-002,2.7923584e-002,1.2847900e-002,1.2420654e-002,3.1219482e-002,4.5989990e-002,5.0872803e-002,4.8492432e-002,2.2491455e-002,-1.0375977e-003,-8.8500977e-003,-2.3956299e-002,-2.9602051e-002,-3.5705566e-002,-5.0445557e-002,-4.6844482e-002,-2.9876709e-002,-6.9885254e-003,1.9653320e-002,3.8024902e-002,3.3599854e-002,2.1148682e-002,4.5166016e-003,-2.1026611e-002,-2.8839111e-002,-3.3660889e-002,-2.7770996e-002,-1.0955811e-002,-1.4343262e-003,7.5378418e-003,-6.7443848e-003,-2.6763916e-002,-4.6844482e-002,-6.8756104e-002,-6.6986084e-002,-6.4453125e-002,-5.1666260e-002,-3.0578613e-002,-1.7120361e-002,7.9345703e-004,6.0119629e-003,5.0659180e-003,3.0517578e-004,-6.8664551e-003,2.8381348e-003,1.1230469e-002,2.2888184e-002,3.2379150e-002,2.0996094e-002,1.6143799e-002,1.5319824e-002,1.2145996e-002,1.5808105e-002,8.3007813e-003,-1.4190674e-002,-3.5644531e-002,-5.2124023e-002,-6.7932129e-002,-7.2113037e-002,-7.5469971e-002,-8.3007813e-002,-7.0159912e-002,-4.2724609e-002,-6.4392090e-003,3.5736084e-002,6.7108154e-002,7.2540283e-002,7.1746826e-002,6.8878174e-002,5.0262451e-002,3.9428711e-002,2.4230957e-002,1.5716553e-002,3.3813477e-002,6.7901611e-002,9.5825195e-002,8.2672119e-002,4.9743652e-002,-1.3977051e-002,-5.4016113e-002,-1.0589600e-002,3.1097412e-002,8.5632324e-002,1.1926270e-001,6.7535400e-002,4.7088623e-002,6.4331055e-002,7.3211670e-002,1.1035156e-001,9.1552734e-002,-1.7211914e-002,-9.3994141e-002,-1.1801147e-001,-1.0281372e-001,-3.2043457e-003,5.6976318e-002,-4.3945313e-003,-5.4809570e-002,-1.2313843e-001,-1.5563965e-001,-4.5776367e-002,1.9439697e-002,3.1829834e-002,3.4698486e-002,-5.2490234e-002,-9.8114014e-002,-5.4229736e-002,-2.8656006e-002,1.1413574e-002,4.0344238e-002,-3.6926270e-003,-2.2583008e-002,-2.0843506e-002,-3.7078857e-002,-3.3325195e-002,-3.6437988e-002,-4.1046143e-002,-2.3376465e-002,1.0314941e-002,2.5573730e-002,1.5563965e-003,-2.5024414e-002,-5.0720215e-002,-5.3222656e-002,-3.9672852e-004,2.3468018e-002,-1.0192871e-002,-4.8156738e-002,-1.1175537e-001,-1.2817383e-001,-3.9642334e-002,3.6010742e-002,8.1329346e-002,9.9487305e-002,1.9866943e-002,-3.5186768e-002,-1.0375977e-002,3.0822754e-003,6.4056396e-002,9.4757080e-002,3.2623291e-002,-3.9367676e-003,-3.5461426e-002,-4.9133301e-002,-1.9531250e-003,2.5115967e-002,1.0345459e-002,-2.9296875e-003,-4.3365479e-002,-6.9976807e-002,-4.2205811e-002,-1.2512207e-002,3.9276123e-002,8.6791992e-002,9.0240479e-002,8.6090088e-002,5.7189941e-002,2.8350830e-002,3.8452148e-002,4.5654297e-002,6.5490723e-002,7.5744629e-002,3.6346436e-002,1.0223389e-002,-1.1077881e-002,-1.9012451e-002,1.8280029e-002,4.1809082e-002,4.1717529e-002,4.1564941e-002,2.1728516e-002,6.5612793e-003,1.9683838e-002,1.4495850e-002,1.9531250e-003,-7.5073242e-003,-2.3223877e-002,-2.2033691e-002,-4.7912598e-003,3.7231445e-003,-1.1779785e-002,-2.5726318e-002,-4.2755127e-002,-4.9346924e-002,-2.4047852e-002,-1.5686035e-002,-2.7099609e-002,-3.8024902e-002,-5.5419922e-002,-5.4473877e-002,-1.5930176e-002,1.1199951e-002,1.5625000e-002,1.2542725e-002,-2.3559570e-002,-5.3070068e-002,-5.4138184e-002,-6.2286377e-002,-5.6518555e-002,-4.4036865e-002,-3.9550781e-002,-2.0141602e-002,-4.6997070e-003,1.1596680e-003,-6.2866211e-003,-1.3916016e-002,-2.9602051e-003,7.5988770e-003,2.8869629e-002,2.8625488e-002,-1.3854980e-002,-4.3212891e-002,-5.0567627e-002,-3.2684326e-002,3.0548096e-002,7.0465088e-002,4.1412354e-002,6.6528320e-003,-4.7119141e-002,-7.6019287e-002,-1.0314941e-002,3.9337158e-002,6.9000244e-002,8.8897705e-002,3.7139893e-002,1.4373779e-002,4.5593262e-002,6.2866211e-002,9.5214844e-002,9.3139648e-002,1.5899658e-002,-4.5684814e-002,-8.1146240e-002,-9.6069336e-002,-4.2968750e-002,9.0942383e-003,2.7069092e-002,5.4443359e-002,4.1442871e-002,2.8778076e-002,4.2510986e-002,3.4790039e-002,4.5959473e-002,4.3975830e-002,2.2735596e-002,6.5002441e-003,-2.0263672e-002,-3.1463623e-002,-2.3620605e-002,-5.7678223e-003,1.0559082e-002,1.8157959e-002,-1.0162354e-002,-4.3762207e-002,-6.5460205e-002,-8.0810547e-002,-4.6264648e-002,-1.3763428e-002,7.0190430e-003,3.0731201e-002,2.2216797e-002,1.9805908e-002,2.9571533e-002,2.4780273e-002,1.6510010e-002,-5.1879883e-003,-4.2968750e-002,-6.7749023e-002,-6.7016602e-002,-5.2917480e-002,-2.7313232e-002,-3.3569336e-004,-7.9345703e-004,-2.9602051e-003,-1.0314941e-002,-3.2165527e-002,-4.1656494e-002,-6.5155029e-002,-8.3343506e-002,-8.8226318e-002,-7.6354980e-002,-4.4677734e-002,-1.2878418e-002,2.0080566e-002,1.9622803e-002,1.3488770e-002,2.7770996e-003,-1.3610840e-002,-2.4414063e-004,3.2043457e-003,7.1105957e-003,1.2084961e-002,1.2512207e-003,7.7819824e-003,2.8869629e-002,5.5206299e-002,8.6944580e-002,1.0137939e-001,8.0383301e-002,4.3640137e-002,-5.2795410e-003,-5.2337646e-002,-5.7312012e-002,-4.9072266e-002,-1.5716553e-002,3.2226563e-002,4.8034668e-002,6.4880371e-002,5.0292969e-002,2.3071289e-002,1.4862061e-002,-3.9978027e-003,9.3383789e-003,2.3254395e-002,2.6763916e-002,3.4484863e-002,1.2664795e-002,-2.4414063e-003,-1.3122559e-002,-2.2491455e-002,-1.1474609e-002,-2.5329590e-003,3.5705566e-003,1.1352539e-002,9.4909668e-003,6.4086914e-003,5.2795410e-003,-3.3569336e-004,8.5449219e-004,5.1269531e-003,1.5655518e-002,2.4963379e-002,2.0629883e-002,7.8430176e-003,-2.4749756e-002,-5.3833008e-002,-6.3385010e-002,-6.6162109e-002,-4.6844482e-002,-3.0609131e-002,-4.0252686e-002,-4.8370361e-002,-6.7871094e-002,-8.3343506e-002,-6.8847656e-002,-6.1889648e-002,-5.2581787e-002,-4.1900635e-002,-4.7210693e-002,-4.0954590e-002,-2.5848389e-002,-1.2237549e-002,2.9907227e-003,1.2664795e-002,9.4604492e-003,7.8125000e-003,1.0589600e-002,9.6740723e-003,1.4007568e-002,1.4862061e-002,1.0375977e-002,1.0467529e-002,1.1413574e-002,8.8500977e-003,1.4648438e-003,-1.2878418e-002,-3.2989502e-002,-4.7973633e-002,-4.4708252e-002,-3.0578613e-002,-4.1809082e-003,2.4902344e-002,3.3813477e-002,4.0863037e-002,3.2745361e-002,1.7333984e-002,1.4465332e-002,2.2583008e-003,-1.7089844e-003,-2.6855469e-003,-8.4838867e-003,-2.5329590e-003,4.4250488e-003,1.3092041e-002,1.5747070e-002,9.1552734e-003,-1.0406494e-002,-3.1555176e-002,-3.7200928e-002,-3.7902832e-002,-1.6387939e-002,7.6293945e-003,1.7822266e-002,3.4942627e-002,4.0191650e-002,5.0231934e-002,7.5866699e-002,8.9233398e-002,9.2468262e-002,8.0261230e-002,4.4311523e-002,7.7209473e-003,-1.3214111e-002,-2.7465820e-002,-2.2644043e-002,-9.5520020e-003,-1.0162354e-002,-4.0283203e-003,-9.3994141e-003,-1.8585205e-002,-2.2644043e-002,-3.5827637e-002,-4.0466309e-002,-4.4555664e-002,-3.9154053e-002,-2.9937744e-002,-2.6153564e-002,-2.3284912e-002,-3.8360596e-002,-5.2520752e-002,-6.2500000e-002,-6.7321777e-002,-5.1727295e-002,-3.2928467e-002,-1.6906738e-002,-2.4719238e-003,-4.8217773e-003,-1.0406494e-002,-1.2664795e-002,-1.9042969e-002,-9.9792480e-003,-3.0517578e-003,3.4484863e-003,1.9073486e-002,3.1066895e-002,4.8767090e-002,6.1706543e-002,5.7769775e-002,2.8442383e-002,-1.1505127e-002,-4.8645020e-002,-7.0861816e-002,-4.3823242e-002,-9.8571777e-003,1.9409180e-002,4.2755127e-002,1.1871338e-002,-1.3427734e-002,-2.0263672e-002,-2.7191162e-002,1.3671875e-002,4.4128418e-002,4.9224854e-002,5.6518555e-002,2.8778076e-002,-9.7656250e-004,-1.9439697e-002,-4.0008545e-002,-3.5583496e-002,-1.2451172e-002,2.6428223e-002,6.4697266e-002,6.7047119e-002,4.3518066e-002,-2.3254395e-002,-8.4075928e-002,-8.0200195e-002,-6.0028076e-002,1.6693115e-002,8.5510254e-002,7.3547363e-002,6.7993164e-002,2.3101807e-002,-1.9866943e-002,-2.1362305e-003,-2.3223877e-002,-6.3140869e-002,-1.0815430e-001,-1.7800903e-001,-1.8969727e-001,-1.1083984e-001,-4.6691895e-003,1.0931396e-001,1.8960571e-001,1.4340210e-001,7.2143555e-002,1.1779785e-002,-4.5043945e-002,3.5736084e-002,1.1007690e-001,1.5228271e-001,1.7974854e-001,5.5755615e-002,-5.4046631e-002,-1.3021851e-001,-1.8457031e-001,-1.0430908e-001,-4.0496826e-002,-3.4454346e-002,-4.3243408e-002,-1.5951538e-001,-2.4948120e-001,-2.3678589e-001,-2.0886230e-001,-7.4340820e-002,5.7708740e-002,1.0357666e-001,1.6192627e-001,1.4578247e-001,1.0916138e-001,1.0067749e-001,4.5806885e-002,5.0659180e-003,-2.5695801e-002,-4.0802002e-002,-1.3977051e-002,2.7374268e-002,7.5164795e-002,7.3181152e-002,5.8349609e-002,1.8341064e-002,-4.0008545e-002,-4.5257568e-002,-6.1889648e-002,-3.9611816e-002,3.4484863e-003,3.5675049e-002,8.1054688e-002,7.8643799e-002,6.0760498e-002,1.2298584e-002,-3.2623291e-002,-2.4322510e-002,-8.7890625e-003,3.9306641e-002,7.4584961e-002,4.6142578e-002,2.5878906e-002,1.0986328e-003,-1.0070801e-002,4.7088623e-002,8.8104248e-002,1.1138916e-001,1.2866211e-001,9.6618652e-002,6.3568115e-002,3.8269043e-002,-8.1176758e-003,-5.1940918e-002,-9.3688965e-002,-1.2966919e-001,-1.3726807e-001,-1.2069702e-001,-9.6649170e-002,-9.2681885e-002,-9.1522217e-002,-1.0870361e-001,-1.2911987e-001,-1.1566162e-001,-1.1315918e-001,-9.1339111e-002,-6.4941406e-002,-4.7241211e-002,-1.7181396e-002,-1.5869141e-003,2.8991699e-003,-2.2857666e-002,-5.8349609e-002,-8.9202881e-002,-1.0388184e-001,-6.2530518e-002,-5.4931641e-004,7.1289063e-002,1.4797974e-001,1.7343140e-001,1.8078613e-001,1.6690063e-001,1.2951660e-001,1.3015747e-001,1.2960815e-001,1.6171265e-001,1.9964600e-001,1.9613647e-001,1.8646240e-001,1.1358643e-001,3.9154053e-002,-1.2420654e-002,-6.1431885e-002,-5.3222656e-002,-4.3487549e-002,-4.7119141e-002,-3.7963867e-002,-5.2703857e-002,-5.9875488e-002,-4.6356201e-002,-4.7973633e-002,-4.2541504e-002,-4.9743652e-002,-7.3242188e-002,-9.4482422e-002,-1.1206055e-001,-1.2289429e-001,-1.2493896e-001,-1.1471558e-001,-1.0653687e-001,-8.7493896e-002,-7.0251465e-002,-5.1239014e-002,-2.6824951e-002,-5.4626465e-003,2.6855469e-002,4.6966553e-002,6.2225342e-002,6.6589355e-002,6.0363770e-002,6.5063477e-002,8.8134766e-002,1.2191772e-001,1.5792847e-001,1.8161011e-001,1.5332031e-001,1.1291504e-001,5.7037354e-002,3.6926270e-003,4.7302246e-003,8.8195801e-003,3.3843994e-002,6.5856934e-002,6.1950684e-002,6.3598633e-002,5.0659180e-002,2.1820068e-002,1.7395020e-003,-3.9306641e-002,-7.9467773e-002,-1.1434937e-001,-1.3815308e-001,-1.4410400e-001,-1.4501953e-001,-1.3613892e-001,-1.4694214e-001,-1.4898682e-001,-1.4834595e-001,-1.4315796e-001,-1.0668945e-001,-8.0383301e-002,-5.3222656e-002,-3.0548096e-002,-2.0294189e-002,-1.8005371e-003,3.0944824e-002,6.2103271e-002,9.0423584e-002,1.1102295e-001,1.0415649e-001,9.6527100e-002,8.3404541e-002,6.5032959e-002,5.6488037e-002,4.8797607e-002,4.8278809e-002,6.1798096e-002,8.5449219e-002,1.0742188e-001,1.1462402e-001,1.0919189e-001,8.6425781e-002,6.0974121e-002,5.7189941e-002,4.4433594e-002,3.6437988e-002,2.5115967e-002,-9.8266602e-003,-2.4078369e-002,-2.7374268e-002,-2.6123047e-002,-2.0385742e-002,-2.8594971e-002,-5.9844971e-002,-8.0993652e-002,-7.3974609e-002,-5.8898926e-002,-1.3488770e-002,2.0904541e-002,2.0996094e-002,2.3559570e-002,1.3916016e-002,4.3640137e-003,1.8066406e-002,1.8371582e-002,8.3923340e-003,6.8054199e-003,-5.4931641e-004,2.0446777e-003,9.3688965e-003,4.1198730e-003,-2.0111084e-002,-4.2388916e-002,-5.1513672e-002,-5.2185059e-002,-2.3132324e-002,-2.5024414e-003,-3.9367676e-003,-1.0986328e-003,-7.9345703e-003,-8.1787109e-003,1.3641357e-002,1.9348145e-002,6.7443848e-003,-6.6528320e-003,-3.5156250e-002,-5.0903320e-002,-4.1229248e-002,-3.0242920e-002,-1.6174316e-002,4.2419434e-003,1.3336182e-002,2.4810791e-002,3.3813477e-002,2.5848389e-002,1.2756348e-002,-2.2583008e-003,3.7841797e-003,2.0141602e-002,5.0659180e-002,7.7484131e-002,6.7047119e-002,6.2194824e-002,5.2307129e-002,4.6691895e-002,6.7138672e-002,6.4361572e-002,3.2348633e-002,-3.8452148e-003,-4.5562744e-002,-6.5460205e-002,-3.0914307e-002,4.9133301e-003,2.8015137e-002,4.8004150e-002,1.8829346e-002,-7.5378418e-003,-1.1230469e-002,-2.6733398e-002,-1.4892578e-002,-3.7231445e-003,-1.7395020e-003,1.6357422e-002,2.7252197e-002,3.5186768e-002,3.0456543e-002,1.7547607e-002,2.9296875e-003,-1.2634277e-002,-9.5825195e-003,-1.3977051e-002,-2.0812988e-002,-1.7242432e-002,-1.0223389e-002,1.4739990e-002,5.3894043e-002,7.9040527e-002,7.4157715e-002,5.9173584e-002,3.4973145e-002,1.4434814e-002,2.5695801e-002,1.9927979e-002,-1.0742188e-002,-3.7719727e-002,-7.4188232e-002,-7.2753906e-002,-1.1047363e-002,4.6447754e-002,7.6171875e-002,8.0230713e-002,1.6052246e-002,-4.2938232e-002,-4.2877197e-002,-5.1086426e-002,-1.6998291e-002,9.6130371e-003,-2.4047852e-002,-2.7893066e-002,-3.5827637e-002,-4.2907715e-002,-2.9022217e-002,-4.2755127e-002,-8.3068848e-002,-1.0961914e-001,-1.0507202e-001,-8.7097168e-002,-3.5949707e-002,3.2653809e-003,-3.8452148e-003,4.0893555e-003,1.7700195e-002,3.8513184e-002,9.9578857e-002,1.3400269e-001,1.2603760e-001,1.1926270e-001,9.5397949e-002,8.1542969e-002,1.0485840e-001,1.1074829e-001,9.3688965e-002,8.2183838e-002,5.4504395e-002,4.0618896e-002,5.5450439e-002,5.2429199e-002,3.5552979e-002,2.0660400e-002,5.8898926e-003,8.1481934e-003,4.5227051e-002,6.5155029e-002,5.0109863e-002,2.7221680e-002,-2.1728516e-002,-5.2429199e-002,-2.6062012e-002,-2.7160645e-003,1.7211914e-002,2.9113770e-002,-1.6082764e-002,-5.2185059e-002,-6.4880371e-002,-7.8155518e-002,-4.6752930e-002,-1.8615723e-002,-9.5520020e-003,5.1269531e-003,-3.2348633e-003,-1.4404297e-002,-1.6052246e-002,-2.3803711e-002,-2.1362305e-002,-2.1026611e-002,-3.1005859e-002,-4.0679932e-002,-6.0150146e-002,-6.6436768e-002,-5.1971436e-002,-2.9449463e-002,5.1879883e-004,1.9134521e-002,7.2326660e-003,-8.1787109e-003,-1.8737793e-002,-2.8808594e-002,-6.0729980e-003,9.0332031e-003,1.1749268e-002,2.6000977e-002,2.8625488e-002,4.5837402e-002,7.5164795e-002,8.9843750e-002,8.2214355e-002,6.0699463e-002,2.5085449e-002,-8.6975098e-003,-1.2329102e-002,-1.7211914e-002,-1.5472412e-002,-4.3945313e-003,-9.0332031e-003,-7.3242188e-004,8.5449219e-003,8.2702637e-003,3.6621094e-003,-1.2908936e-002,-3.0059814e-002,-4.6081543e-002,-4.8217773e-002,-4.5196533e-002,-3.7658691e-002,-1.4801025e-002,9.2163086e-003,3.9916992e-002,6.0729980e-002,6.6192627e-002,5.0964355e-002,2.9724121e-002,2.6885986e-002,2.7313232e-002,5.3588867e-002,7.6354980e-002,7.1746826e-002,7.5286865e-002,6.7535400e-002,6.4605713e-002,7.8735352e-002,7.0922852e-002,4.0100098e-002,2.3803711e-003,-3.9215088e-002,-6.3568115e-002,-4.5227051e-002,-2.1759033e-002,-6.5307617e-003,9.8266602e-003,-8.6364746e-003,-2.3834229e-002,-2.4780273e-002,-3.8787842e-002,-3.7231445e-002,-4.2236328e-002,-5.0872803e-002,-4.4921875e-002,-3.2684326e-002,-1.2817383e-002,1.3427734e-003,1.4587402e-002,1.6784668e-002,1.4190674e-002,1.5106201e-002,2.4108887e-003,-1.1718750e-002,-2.5695801e-002,-3.0364990e-002,-1.8310547e-002,1.2115479e-002,4.4311523e-002,5.4931641e-002,6.1401367e-002,5.0140381e-002,4.3609619e-002,6.8206787e-002,8.5754395e-002,1.0482788e-001,1.1032104e-001,7.6354980e-002,4.7760010e-002,2.8198242e-002,1.0681152e-002,1.6937256e-002,1.1383057e-002,-2.2491455e-002,-5.3039551e-002,-9.0393066e-002,-1.0931396e-001,-8.2427979e-002,-5.2551270e-002,-2.1484375e-002,1.8920898e-003,-1.6632080e-002,-3.4088135e-002,-3.7689209e-002,-4.3579102e-002,-1.6052246e-002,3.0517578e-003,-1.4648438e-003,3.1738281e-003,-8.1176758e-003,-6.8969727e-003,1.7639160e-002,3.3233643e-002,3.9916992e-002,3.9276123e-002,2.2003174e-002,1.0009766e-002,2.3040771e-002,3.2501221e-002,4.8187256e-002,6.2469482e-002,5.5999756e-002,5.5328369e-002,5.2368164e-002,3.7506104e-002,1.4495850e-002,-1.8798828e-002,-5.6182861e-002,-7.9315186e-002,-7.0434570e-002,-5.2001953e-002,-3.2440186e-002,-1.6296387e-002,-3.6163330e-002,-5.4748535e-002,-6.0180664e-002,-7.0281982e-002,-4.8278809e-002,-3.1219482e-002,-2.1759033e-002,1.2207031e-004,1.3366699e-002,3.1921387e-002,4.7149658e-002,5.1330566e-002,4.0191650e-002,2.6031494e-002,1.8524170e-002,1.1962891e-002,1.9805908e-002,2.7832031e-002,2.9296875e-002,4.0466309e-002,5.3955078e-002,7.2784424e-002,9.9365234e-002,1.1434937e-001,1.1343384e-001,9.9853516e-002,7.4401855e-002,4.3518066e-002,2.2796631e-002,1.7700195e-003,-1.5258789e-002,-2.2613525e-002,-3.3691406e-002,-3.1738281e-002,-3.0395508e-002,-2.8594971e-002,-2.7099609e-002,-3.4118652e-002,-4.0496826e-002,-5.2490234e-002,-5.3955078e-002,-5.0598145e-002,-3.3111572e-002,-9.4299316e-003,8.3618164e-003,2.6397705e-002,2.0202637e-002,1.0314941e-002,-4.4250488e-003,-2.0935059e-002,-1.6479492e-002,-8.6669922e-003,9.1857910e-003,3.2348633e-002,4.0374756e-002,4.3121338e-002,2.7038574e-002,-1.7700195e-003,-2.6123047e-002,-5.3222656e-002,-5.6335449e-002,-5.5450439e-002,-5.5114746e-002,-5.0109863e-002,-6.9366455e-002,-7.7758789e-002,-7.6599121e-002,-6.7474365e-002,-3.1799316e-002,1.8920898e-003,2.5512695e-002,4.6813965e-002,5.4016113e-002,5.9997559e-002,8.0505371e-002,9.4085693e-002,1.1163330e-001,1.2380981e-001,1.1761475e-001,1.0736084e-001,8.4716797e-002,6.2805176e-002,5.1055908e-002,4.8187256e-002,6.3140869e-002,8.2000732e-002,9.0484619e-002,9.1644287e-002,6.8267822e-002,3.6956787e-002,1.5716553e-002,-1.3580322e-002,-2.6214600e-002,-4.2602539e-002,-7.0343018e-002,-8.6059570e-002,-1.0366821e-001,-1.0812378e-001,-9.9151611e-002,-8.6303711e-002,-7.4462891e-002,-6.1035156e-002,-4.9407959e-002,-4.0893555e-002,-2.6336670e-002,-1.6540527e-002,-1.0681152e-003,1.8615723e-002,4.3823242e-002,6.7291260e-002,7.4859619e-002,7.3699951e-002,4.9835205e-002,2.5756836e-002,1.6876221e-002,6.8664551e-003,9.9792480e-003,1.0253906e-002,-8.1176758e-003,-1.8035889e-002,-2.4291992e-002,-2.9418945e-002,-2.0568848e-002,-2.4322510e-002,-4.3273926e-002,-5.9936523e-002,-7.0922852e-002,-6.9671631e-002,-4.3029785e-002,-1.3610840e-002,2.9602051e-003,2.5451660e-002,3.2470703e-002,3.9947510e-002,5.8441162e-002,6.3598633e-002,6.6101074e-002,6.4270020e-002,5.8624268e-002,5.7128906e-002,6.4544678e-002,6.6528320e-002,5.5389404e-002,4.0496826e-002,1.3702393e-002,-1.0772705e-002,-1.9348145e-002,-2.8442383e-002,-3.2318115e-002,-3.1585693e-002,-3.7567139e-002,-3.1982422e-002,-1.5716553e-002,2.8991699e-003,2.5390625e-002,4.1412354e-002,4.2999268e-002,4.0496826e-002,3.9001465e-002,3.4973145e-002,4.1625977e-002,4.5959473e-002,4.2572021e-002,3.9154053e-002,2.3834229e-002,1.0681152e-002,2.3803711e-003,-7.8430176e-003,-1.4099121e-002,-2.5268555e-002,-4.3151855e-002,-5.9173584e-002,-6.7993164e-002,-6.8084717e-002,-5.2978516e-002,-3.4118652e-002,-2.1972656e-002,-1.2634277e-002,-1.8066406e-002,-2.3925781e-002,-2.1636963e-002,-2.0019531e-002,-4.0893555e-003,1.0559082e-002,1.7211914e-002,2.5177002e-002,2.3651123e-002,2.1392822e-002,2.3010254e-002,2.1331787e-002,2.4475098e-002,2.5054932e-002,2.1148682e-002,1.5258789e-002,3.6010742e-003,-6.5612793e-003,-8.8806152e-003,-4.0588379e-003,1.1871338e-002,3.1005859e-002,4.0557861e-002,4.3426514e-002,2.7648926e-002,6.6223145e-003,-4.8522949e-003,-1.3427734e-002,1.0681152e-003,1.9165039e-002,2.9541016e-002,4.0649414e-002,2.9602051e-002,1.9134521e-002,1.4923096e-002,6.1340332e-003,1.1199951e-002,1.0467529e-002,1.7700195e-003,-1.2512207e-003,-6.2255859e-003,-5.5541992e-003,1.7395020e-003,3.9978027e-003,-3.9367676e-003,-1.2939453e-002,-2.3345947e-002,-2.8625488e-002,-1.5747070e-002,-4.2724609e-003,3.7536621e-003,1.0406494e-002,3.7536621e-003,2.2583008e-003,1.2451172e-002,2.2033691e-002,3.7170410e-002,4.8675537e-002,4.6203613e-002,4.3548584e-002,3.5888672e-002,2.4291992e-002,1.5350342e-002,1.6479492e-003,-1.2207031e-002,-2.2125244e-002,-2.6245117e-002,-2.4444580e-002,-1.8096924e-002,-7.7514648e-003,0.0000000e+000,4.5776367e-003,3.2958984e-003,-5.2795410e-003,-1.3458252e-002,-1.7944336e-002,-3.3569336e-003,1.8005371e-002,4.1595459e-002,5.9783936e-002,4.3792725e-002,2.7099609e-002,9.7351074e-003,-4.5471191e-003,1.5075684e-002,2.5665283e-002,2.0812988e-002,1.4312744e-002,-1.5899658e-002,-3.6743164e-002,-3.0273438e-002,-2.6855469e-002,-1.4739990e-002,-2.6245117e-003,-7.0190430e-003,5.4931641e-004,1.9134521e-002,3.2073975e-002,4.1839600e-002,4.0191650e-002,2.1209717e-002,7.4157715e-003,1.1810303e-002,1.7822266e-002,2.9083252e-002,3.7414551e-002,2.3132324e-002,1.5625000e-002,1.5716553e-002,1.3946533e-002,2.3315430e-002,2.7801514e-002,2.6428223e-002,3.4393311e-002,5.2978516e-002,6.7413330e-002,7.0007324e-002,5.8929443e-002,1.9897461e-002,-1.3793945e-002,-2.0538330e-002,-2.2155762e-002,-6.4697266e-003,9.4604492e-004,-3.6285400e-002,-7.0922852e-002,-1.0855103e-001,-1.4093018e-001,-1.2854004e-001,-1.1932373e-001,-1.0974121e-001,-8.9477539e-002,-8.2244873e-002,-6.1950684e-002,-2.9296875e-002,-5.1574707e-003,1.3458252e-002,2.4932861e-002,3.1280518e-002,4.4586182e-002,7.5531006e-002,1.0659790e-001,1.2930298e-001,1.4535522e-001,1.3226318e-001,1.1706543e-001,1.0662842e-001,9.1003418e-002,9.1583252e-002,8.5327148e-002,7.1350098e-002,5.8715820e-002,3.5827637e-002,1.5014648e-002,-9.1552734e-004,-1.9927979e-002,-3.5064697e-002,-5.0445557e-002,-6.8481445e-002,-8.1451416e-002,-9.3109131e-002,-1.0046387e-001,-1.0226440e-001,-1.0046387e-001,-9.4146729e-002,-8.0535889e-002,-5.9143066e-002,-2.9815674e-002,7.9956055e-003,4.5227051e-002,7.5836182e-002,9.5855713e-002,9.8480225e-002,8.9782715e-002,8.2733154e-002,7.1502686e-002,7.1624756e-002,7.3974609e-002,6.6162109e-002,5.7800293e-002,2.6153564e-002,-9.2468262e-003,-4.4433594e-002,-7.8796387e-002,-8.8165283e-002,-8.8928223e-002,-7.2540283e-002,-4.7790527e-002,-3.2257080e-002,-1.5563965e-002,-1.0070801e-002,-8.6669922e-003,2.2888184e-003,6.5002441e-003,1.6448975e-002,2.1270752e-002,1.1199951e-002,8.7890625e-003,6.8969727e-003,1.6418457e-002,4.0588379e-002,6.2652588e-002,7.0281982e-002,7.3211670e-002,6.5155029e-002,5.2734375e-002,5.7708740e-002,4.8339844e-002,3.5095215e-002,1.7059326e-002,-1.4434814e-002,-3.1280518e-002,-3.1860352e-002,-2.8198242e-002,-2.9632568e-002,-3.6041260e-002,-6.6406250e-002,-8.7921143e-002,-8.2733154e-002,-7.2204590e-002,-3.4362793e-002,2.6245117e-003,2.0385742e-002,4.6142578e-002,7.0465088e-002,9.0209961e-002,1.1618042e-001,1.2240601e-001,1.0440063e-001,8.2153320e-002,6.3934326e-002,4.9987793e-002,4.9957275e-002,4.6508789e-002,1.7120361e-002,-8.9111328e-003,-4.4799805e-002,-7.9162598e-002,-8.8287354e-002,-1.0137939e-001,-1.0729980e-001,-1.0482788e-001,-1.0067749e-001,-8.7554932e-002,-6.6925049e-002,-4.7912598e-002,-3.5034180e-002,-2.1057129e-002,-6.5612793e-003,4.8217773e-003,1.4373779e-002,1.6143799e-002,6.6528320e-003,6.3171387e-003,2.1423340e-002,4.2877197e-002,7.0373535e-002,8.9996338e-002,8.1420898e-002,7.2326660e-002,6.9061279e-002,6.2286377e-002,7.4859619e-002,7.4584961e-002,5.1727295e-002,3.3416748e-002,1.0101318e-002,-5.7373047e-003,-3.0517578e-003,-2.7770996e-003,-1.2298584e-002,-1.2268066e-002,-1.2878418e-002,-9.5520020e-003,6.1035156e-003,1.1230469e-002,7.5073242e-003,5.0048828e-003,8.0566406e-003,1.2512207e-002,2.4536133e-002,2.4658203e-002,-7.6293945e-004,-2.3529053e-002,-4.6142578e-002,-6.1645508e-002,-5.4168701e-002,-4.6966553e-002,-4.8095703e-002,-3.6499023e-002,-2.6458740e-002,-1.3000488e-002,8.6364746e-003,1.6296387e-002,1.4556885e-002,1.3854980e-002,2.5268555e-002,3.8085938e-002,5.5511475e-002,6.0791016e-002,3.3843994e-002,1.4801025e-002,6.8664551e-003,1.0406494e-002,4.0222168e-002,6.1096191e-002,5.0201416e-002,4.2663574e-002,3.2409668e-002,2.8869629e-002,6.2500000e-002,8.0413818e-002,7.7148438e-002,6.6802979e-002,3.1890869e-002,-1.5258789e-004,-1.1260986e-002,-2.9693604e-002,-4.7760010e-002,-5.4321289e-002,-6.1706543e-002,-4.8126221e-002,-1.8218994e-002,8.4228516e-003,1.7486572e-002,1.8585205e-002,1.0650635e-002,-1.9836426e-003,9.1247559e-003,8.3923340e-003,3.7536621e-003,3.2348633e-003,-7.5378418e-003,-6.1035156e-003,-9.4604492e-004,-3.6926270e-003,-2.4566650e-002,-4.5501709e-002,-5.9631348e-002,-6.1065674e-002,-2.6092529e-002,4.7302246e-003,1.7486572e-002,2.7221680e-002,1.8615723e-002,1.8859863e-002,5.2368164e-002,7.6629639e-002,9.5581055e-002,1.0232544e-001,6.8115234e-002,3.7078857e-002,1.5869141e-002,-8.2397461e-003,-1.5563965e-002,-2.3529053e-002,-4.4311523e-002,-5.3649902e-002,-6.2469482e-002,-7.4615479e-002,-8.4930420e-002,-1.0385132e-001,-1.2054443e-001,-1.2561035e-001,-1.0330200e-001,-7.3669434e-002,-4.3365479e-002,-1.8310547e-002,-2.6611328e-002,-3.0578613e-002,-2.5878906e-002,-1.7791748e-002,1.6021729e-002,4.3151855e-002,4.9407959e-002,5.7373047e-002,5.2185059e-002,5.1849365e-002,7.4279785e-002,9.1430664e-002,1.0958862e-001,1.2283325e-001,1.1642456e-001,1.0690308e-001,9.6923828e-002,7.9101563e-002,6.5704346e-002,5.1025391e-002,3.3081055e-002,2.1667480e-002,8.2397461e-003,-3.5095215e-003,-1.8005371e-002,-2.8015137e-002,-2.9968262e-002,-2.5054932e-002,-6.9274902e-003,3.5705566e-003,-5.7983398e-004,-1.3366699e-002,-3.5949707e-002,-5.0384521e-002,-3.3142090e-002,-1.0040283e-002,1.4343262e-002,2.9266357e-002,-5.6152344e-003,-4.1198730e-002,-7.3516846e-002,-9.8205566e-002,-7.1777344e-002,-4.5562744e-002,-3.0273438e-002,-1.2939453e-002,-3.1311035e-002,-4.1442871e-002,-2.5573730e-002,-1.0742188e-002,3.1188965e-002,6.5521240e-002,7.2631836e-002,7.8002930e-002,6.5460205e-002,5.1391602e-002,5.3680420e-002,5.4168701e-002,6.1828613e-002,7.5347900e-002,7.8399658e-002,8.4899902e-002,8.2672119e-002,7.5164795e-002,6.9305420e-002,5.6976318e-002,5.1422119e-002,3.9031982e-002,2.0111084e-002,-3.6926270e-003,-3.5766602e-002,-6.0058594e-002,-6.8298340e-002,-6.7779541e-002,-6.3232422e-002,-6.0241699e-002,-7.9223633e-002,-9.3780518e-002,-9.7717285e-002,-9.6832275e-002,-6.8023682e-002,-4.6813965e-002,-4.2968750e-002,-3.7780762e-002,-3.9825439e-002,-3.0090332e-002,5.6762695e-003,3.5522461e-002,4.8706055e-002,5.4046631e-002,3.4240723e-002,1.7089844e-002,2.1728516e-002,2.0751953e-002,2.5299072e-002,3.0578613e-002,2.2918701e-002,3.0456543e-002,5.1086426e-002,6.1737061e-002,5.6884766e-002,3.6346436e-002,-5.7983398e-004,-2.7526855e-002,-1.4190674e-002,-2.3803711e-003,5.0354004e-003,9.6130371e-003,-2.2857666e-002,-2.9998779e-002,4.2419434e-003,3.8696289e-002,8.3129883e-002,1.0400391e-001,6.6162109e-002,3.6285400e-002,3.4973145e-002,3.0609131e-002,5.9661865e-002,6.7535400e-002,1.8371582e-002,-1.4373779e-002,-4.3334961e-002,-6.1767578e-002,-4.1320801e-002,-3.6102295e-002,-6.0424805e-002,-6.5002441e-002,-5.5114746e-002,-3.6224365e-002,6.0729980e-003,2.0385742e-002,-9.6435547e-003,-2.3620605e-002,-2.9602051e-003,3.2012939e-002,9.9304199e-002,1.2469482e-001,4.6478271e-002,-2.8808594e-002,-9.1033936e-002,-1.1868286e-001,-2.9571533e-002,4.2236328e-002,4.2755127e-002,4.9743652e-002,-7.5988770e-003,-3.5919189e-002,3.6712646e-002,6.9854736e-002,8.7646484e-002,8.3801270e-002,8.2397461e-003,-3.3813477e-002,-7.2937012e-003,1.1962891e-002,3.5125732e-002,4.9407959e-002,-5.3405762e-003,-3.3172607e-002,-2.3193359e-002,-3.0273438e-002,-3.2073975e-002,-4.4219971e-002,-8.1176758e-002,-8.0291748e-002,-2.0721436e-002,3.5705566e-002,7.3822021e-002,8.5052490e-002,2.6336670e-002,-1.1444092e-002,2.1545410e-002,4.8522949e-002,9.5733643e-002,1.1224365e-001,2.7862549e-002,-3.2989502e-002,-5.8441162e-002,-7.0526123e-002,-9.9792480e-003,3.0120850e-002,3.9978027e-003,-7.9650879e-003,-3.4240723e-002,-5.3283691e-002,-1.4709473e-002,-1.0375977e-003,-8.4838867e-003,-3.6926270e-003,-4.7912598e-003,1.3061523e-002,5.4565430e-002,7.4951172e-002,4.8858643e-002,1.4892578e-002,-3.0426025e-002,-6.8817139e-002,-5.7525635e-002,-5.3527832e-002,-6.1035156e-002,-5.7891846e-002,-7.1899414e-002,-6.7413330e-002,-3.4637451e-002,-1.3458252e-002,-1.8310547e-004,5.0354004e-003,-1.2512207e-003,-1.5258789e-004,2.6214600e-002,4.6173096e-002,5.3466797e-002,5.9295654e-002,4.1290283e-002,3.2928467e-002,4.2877197e-002,4.6508789e-002,4.7393799e-002,4.1625977e-002,2.0935059e-002,9.0942383e-003,2.0446777e-002,3.0761719e-002,4.6234131e-002,5.7495117e-002,4.9682617e-002,4.9682617e-002,6.0913086e-002,6.6864014e-002,7.0312500e-002,6.1096191e-002,2.4627686e-002,-4.3945313e-003,-1.3610840e-002,-1.4648438e-002,3.9062500e-003,1.5258789e-002,-9.7045898e-003,-3.3599854e-002,-5.7678223e-002,-7.4462891e-002,-4.4006348e-002,-1.6998291e-002,-2.7465820e-004,1.4923096e-002,-5.5541992e-003,-2.1545410e-002,-1.8798828e-002,-2.0660400e-002,-9.7961426e-003,-6.9885254e-003,-3.3538818e-002,-5.8105469e-002,-8.7615967e-002,-1.1087036e-001,-1.0739136e-001,-9.9029541e-002,-8.7127686e-002,-7.0800781e-002,-6.5246582e-002,-5.5847168e-002,-3.4729004e-002,-1.0131836e-002,3.4790039e-002,7.7514648e-002,1.0940552e-001,1.3543701e-001,1.3650513e-001,1.3610840e-001,1.4337158e-001,1.4669800e-001,1.5573120e-001,1.5594482e-001,1.2863159e-001,1.0006714e-001,6.7535400e-002,4.0832520e-002,4.7363281e-002,5.2917480e-002,5.3649902e-002,4.8858643e-002,1.1352539e-002,-3.2318115e-002,-6.8206787e-002,-1.0803223e-001,-1.2127686e-001,-1.2567139e-001,-1.3034058e-001,-1.2078857e-001,-1.2695313e-001,-1.2805176e-001,-1.3171387e-001,-1.3363647e-001,-1.1492920e-001,-9.3963623e-002,-5.8563232e-002,-2.6245117e-002,-8.3923340e-003,7.8735352e-003,1.7944336e-002,2.8076172e-002,5.0872803e-002,6.4697266e-002,6.5216064e-002,6.1492920e-002,4.0618896e-002,2.8289795e-002,3.4973145e-002,4.6478271e-002,6.5643311e-002,8.2122803e-002,7.4798584e-002,6.6558838e-002,6.0577393e-002,5.1635742e-002,6.9610596e-002,8.3038330e-002,9.0698242e-002,9.7290039e-002,8.0841064e-002,6.1004639e-002,4.0100098e-002,1.7639160e-002,8.9416504e-003,4.6081543e-003,9.1552734e-005,-2.6550293e-003,-2.1087646e-002,-4.1687012e-002,-6.3598633e-002,-8.4320068e-002,-8.2794189e-002,-7.7697754e-002,-6.3049316e-002,-4.7912598e-002,-5.0689697e-002,-5.2215576e-002,-5.9051514e-002,-6.4117432e-002,-5.0048828e-002,-3.8513184e-002,-2.8442383e-002,-2.1545410e-002,-3.6743164e-002,-4.7363281e-002,-4.9560547e-002,-4.6081543e-002,-2.0385742e-002,4.6081543e-003,1.7913818e-002,3.2531738e-002,3.5766602e-002,4.2388916e-002,6.8054199e-002,8.9385986e-002,1.1190796e-001,1.2744141e-001,1.2042236e-001,1.1090088e-001,9.9090576e-002,8.4411621e-002,7.8613281e-002,7.2906494e-002,6.3323975e-002,5.7586670e-002,4.4555664e-002,2.9357910e-002,9.5825195e-003,-1.5350342e-002,-3.6560059e-002,-5.6274414e-002,-6.3171387e-002,-6.7962646e-002,-7.0922852e-002,-6.9000244e-002,-7.0892334e-002,-6.5124512e-002,-5.3070068e-002,-4.3548584e-002,-3.9093018e-002,-3.9550781e-002,-4.6722412e-002,-5.0476074e-002,-3.7597656e-002,-2.2674561e-002,-2.9602051e-003,1.5258789e-002,1.4648438e-002,1.4068604e-002,1.0406494e-002,1.0986328e-003,4.5776367e-004,-5.6762695e-003,-1.2390137e-002,-1.5655518e-002,-1.9561768e-002,-1.7242432e-002,-1.4862061e-002,-9.1247559e-003,-2.3803711e-003,6.5612793e-003,2.0416260e-002,3.1066895e-002,3.8909912e-002,4.2022705e-002,3.9337158e-002,3.5034180e-002,3.5552979e-002,3.4332275e-002,3.3416748e-002,3.2623291e-002,2.4566650e-002,1.8890381e-002,1.1718750e-002,5.1269531e-003,1.4038086e-003,-7.6293945e-004,1.2512207e-003,6.1035156e-004,-2.5634766e-003,-1.1718750e-002,-2.9052734e-002,-4.2358398e-002,-4.2510986e-002,-3.5400391e-002,-1.7333984e-002,-3.4179688e-003,-1.3580322e-002,-2.5726318e-002,-4.1992188e-002,-5.4626465e-002,-4.0771484e-002,-3.1829834e-002,-2.8930664e-002,-2.5482178e-002,-3.9672852e-002,-4.2602539e-002,-2.5177002e-002,-9.1552734e-003,1.1749268e-002,2.4810791e-002,1.4434814e-002,3.8452148e-003,-2.2277832e-003,-9.8571777e-003,-1.5563965e-003,9.3383789e-003,1.7456055e-002,3.5919189e-002,4.9102783e-002,6.0821533e-002,6.3964844e-002,5.5511475e-002,4.1656494e-002,2.3895264e-002,1.8890381e-002,1.3183594e-002,9.6130371e-003,8.2397461e-003,-2.3803711e-003,-1.5563965e-003,9.8571777e-003,2.3986816e-002,3.9642334e-002,4.4494629e-002,2.7984619e-002,7.0190430e-003,-6.3171387e-003,-1.5930176e-002,-6.1035156e-005,1.5228271e-002,1.3549805e-002,1.3092041e-002,-1.2023926e-002,-3.2867432e-002,-3.4179688e-002,-3.8635254e-002,-3.0090332e-002,-2.8320313e-002,-4.8339844e-002,-6.3629150e-002,-7.4188232e-002,-7.5378418e-002,-4.7729492e-002,-2.1148682e-002,-9.3078613e-003,-1.0681152e-003,-1.5655518e-002,-2.9998779e-002,-2.4627686e-002,-2.3864746e-002,-1.2207031e-002,-3.5095215e-003,-1.3702393e-002,-1.2847900e-002,-4.1809082e-003,1.0192871e-002,3.6682129e-002,5.5480957e-002,5.5358887e-002,5.1696777e-002,4.5104980e-002,3.6102295e-002,4.4769287e-002,4.9713135e-002,5.1025391e-002,5.6427002e-002,5.0476074e-002,4.6386719e-002,3.8391113e-002,2.4169922e-002,9.7961426e-003,-1.5869141e-003,1.8920898e-003,9.6130371e-003,1.8829346e-002,2.1301270e-002,9.7656250e-004,-2.1362305e-002,-3.7872314e-002,-5.4382324e-002,-5.2307129e-002,-5.6518555e-002,-7.7697754e-002,-9.1827393e-002,-1.0592651e-001,-1.0446167e-001,-7.6232910e-002,-5.0506592e-002,-3.9062500e-002,-3.3264160e-002,-4.4525146e-002,-5.2032471e-002,-3.1921387e-002,-1.5838623e-002,4.6691895e-003,2.0599365e-002,9.6130371e-003,7.6293945e-003,1.6448975e-002,2.8778076e-002,5.9265137e-002,8.4838867e-002,9.1003418e-002,9.5733643e-002,9.0209961e-002,7.8063965e-002,7.2052002e-002,5.3222656e-002,2.8289795e-002,4.5776367e-003,-1.7608643e-002,-2.8320313e-002,-2.8106689e-002,-2.3803711e-002,-2.8930664e-002,-3.3233643e-002,-4.3823242e-002,-5.2734375e-002,-4.4342041e-002,-3.9733887e-002,-3.0334473e-002,-2.3681641e-002,-2.8503418e-002,-2.8350830e-002,-2.3254395e-002,-1.5625000e-002,-4.5166016e-003,2.1972656e-003,-6.1035156e-003,-1.3427734e-002,-1.7791748e-002,-1.9683838e-002,-6.3781738e-003,3.6010742e-003,3.9062500e-003,3.6621094e-003,-4.1503906e-003,-7.2021484e-003,7.9040527e-003,2.3132324e-002,3.9367676e-002,4.9957275e-002,3.8421631e-002,2.2674561e-002,5.0354004e-003,-1.4221191e-002,-1.6815186e-002,-1.4404297e-002,-5.6457520e-003,1.2207031e-002,2.1850586e-002,3.0914307e-002,2.7374268e-002,1.4404297e-002,1.8615723e-003,-1.4434814e-002,-1.2268066e-002,-7.9345703e-003,-1.2207031e-004,8.1481934e-003,-6.1340332e-003,-2.0141602e-002,-3.9703369e-002,-5.7403564e-002,-5.4412842e-002,-5.0567627e-002,-4.1656494e-002,-3.1311035e-002,-3.3569336e-002,-3.1219482e-002,-2.5085449e-002,-1.8920898e-002,-3.2043457e-003,5.2185059e-003,2.1057129e-003,-5.1269531e-003,-2.0294189e-002,-3.0334473e-002,-2.3071289e-002,-1.1077881e-002,6.0729980e-003,2.4505615e-002,2.3284912e-002,2.1942139e-002,1.7211914e-002,6.4086914e-003,1.0833740e-002,9.2773438e-003,8.0871582e-003,1.0375977e-002,7.2937012e-003,1.2573242e-002,2.3071289e-002,3.2958984e-002,3.6376953e-002,3.1402588e-002,1.0284424e-002,-1.6357422e-002,-3.6285400e-002,-5.3070068e-002,-4.9591064e-002,-4.0588379e-002,-3.7078857e-002,-2.8869629e-002,-3.7384033e-002,-4.1870117e-002,-3.2897949e-002,-2.4841309e-002,-1.5258789e-003,1.4373779e-002,1.3427734e-002,1.0986328e-002,2.2277832e-003,1.5258789e-004,1.8096924e-002,3.2196045e-002,3.5461426e-002,3.4179688e-002,9.8876953e-003,-8.9416504e-003,-9.7656250e-003,-1.1230469e-002,2.3803711e-003,1.3183594e-002,7.8735352e-003,9.7351074e-003,1.6235352e-002,2.1301270e-002,3.2012939e-002,2.8839111e-002,5.8898926e-003,-1.4678955e-002,-2.4688721e-002,-2.4322510e-002,-3.6621094e-003,1.3854980e-002,3.5705566e-003,-3.2958984e-003,-1.7578125e-002,-2.1759033e-002,1.1901855e-002,3.4698486e-002,4.2205811e-002,3.4179688e-002,-1.2939453e-002,-5.8135986e-002,-7.2937012e-002,-7.7728271e-002,-4.4708252e-002,1.2207031e-003,2.1240234e-002,4.1625977e-002,1.9836426e-002,-2.6184082e-002,-7.3455811e-002,-1.2551880e-001,-1.2002563e-001,-8.0596924e-002,2.8381348e-003,9.6588135e-002,1.1791992e-001,1.0998535e-001,2.7221680e-002,-6.6589355e-002,-7.7239990e-002,-7.6477051e-002,5.6457520e-003,9.2742920e-002,9.0881348e-002,8.7036133e-002,7.8430176e-003,-7.5561523e-002,-8.2672119e-002,-9.0179443e-002,-3.0242920e-002,4.3823242e-002,6.9946289e-002,9.8022461e-002,6.4666748e-002,1.1596680e-002,-2.1453857e-002,-5.9265137e-002,-3.4729004e-002,1.2207031e-003,3.1127930e-002,6.1828613e-002,2.2552490e-002,-1.9683838e-002,-6.1737061e-002,-1.0430908e-001,-8.3129883e-002,-6.2408447e-002,-4.0649414e-002,-9.0637207e-003,-1.4801025e-002,-1.4434814e-002,-1.0192871e-002,-1.9683838e-002,-1.8402100e-002,-2.1667480e-002,-1.9683838e-002,-4.8217773e-003,1.8066406e-002,4.0802002e-002,4.0954590e-002,3.4179688e-002,1.0986328e-002,-9.1857910e-003,2.0141602e-003,1.0498047e-002,2.6641846e-002,3.9703369e-002,2.6275635e-002,2.2613525e-002,3.1982422e-002,4.1717529e-002,6.3232422e-002,6.9946289e-002,4.3426514e-002,1.1871338e-002,-2.1606445e-002,-4.8370361e-002,-3.9489746e-002,-2.5543213e-002,-1.8310547e-002,-8.7280273e-003,-3.0670166e-002,-5.0506592e-002,-5.9844971e-002,-7.1502686e-002,-5.0109863e-002,-2.9144287e-002,-1.0131836e-002,1.1291504e-002,6.3476563e-003,8.5449219e-004,-3.5400391e-003,-9.3078613e-003,5.1574707e-003,1.7303467e-002,1.8249512e-002,1.7089844e-002,-7.2021484e-003,-2.8045654e-002,-3.1616211e-002,-2.9693604e-002,-4.6691895e-003,1.9714355e-002,2.6184082e-002,3.0242920e-002,2.1087646e-002,1.3275146e-002,2.8289795e-002,3.8574219e-002,5.0018311e-002,5.2093506e-002,2.4139404e-002,-8.2397461e-004,-2.0874023e-002,-3.1921387e-002,-1.7028809e-002,-4.6691895e-003,-1.0375977e-002,-1.4068604e-002,-3.1860352e-002,-4.1015625e-002,-1.8768311e-002,-5.2795410e-003,7.1716309e-003,8.4533691e-003,-1.8310547e-002,-3.2226563e-002,-1.7730713e-002,3.4179688e-003,3.7384033e-002,5.3955078e-002,1.1596680e-002,-3.3233643e-002,-7.4127197e-002,-1.0122681e-001,-5.9844971e-002,-1.7761230e-002,2.1972656e-003,2.2155762e-002,-8.0566406e-003,-2.8137207e-002,-3.1433105e-003,1.7272949e-002,6.7260742e-002,1.0403442e-001,8.6883545e-002,6.9396973e-002,3.7963867e-002,6.7138672e-003,1.4678955e-002,1.9744873e-002,1.7456055e-002,1.8859863e-002,-1.1505127e-002,-3.9916992e-002,-6.1309814e-002,-8.5601807e-002,-8.2092285e-002,-7.3303223e-002,-5.4351807e-002,-2.8289795e-002,-1.5747070e-002,-3.1127930e-003,2.4108887e-003,8.1176758e-003,3.0761719e-002,5.1483154e-002,7.1746826e-002,8.5540771e-002,7.1777344e-002,5.6732178e-002,4.3609619e-002,3.3386230e-002,4.3914795e-002,5.2673340e-002,4.9499512e-002,4.6112061e-002,3.0548096e-002,1.2695313e-002,5.0048828e-003,-1.2237549e-002,-2.9479980e-002,-4.3426514e-002,-5.1666260e-002,-4.3762207e-002,-2.2094727e-002,-1.7089844e-003,-7.0495605e-003,-2.2491455e-002,-5.5938721e-002,-8.5296631e-002,-7.4523926e-002,-5.9539795e-002,-2.9815674e-002,9.4604492e-004,-1.0070801e-003,8.9416504e-003,2.3712158e-002,3.4942627e-002,6.0363770e-002,6.5185547e-002,4.3792725e-002,2.0629883e-002,2.4414063e-004,-9.9182129e-003,5.6762695e-003,2.1362305e-002,1.6387939e-002,1.5625000e-002,-1.9531250e-003,-1.5594482e-002,-6.7749023e-003,-8.0261230e-003,-5.8288574e-003,-6.5307617e-003,-1.4739990e-002,-1.3763428e-002,-6.7138672e-004,1.1993408e-002,1.8066406e-002,1.8280029e-002,6.1035156e-005,-1.7791748e-002,-2.6184082e-002,-3.3691406e-002,-2.8015137e-002,-1.9958496e-002,-2.1362305e-002,-2.0782471e-002,-2.8259277e-002,-3.5095215e-002,-2.8442383e-002,-1.9622803e-002,1.5869141e-003,1.7028809e-002,1.0681152e-002,-5.1879883e-003,-3.8360596e-002,-6.0577393e-002,-4.3640137e-002,-1.6937256e-002,2.0446777e-002,5.2093506e-002,2.5787354e-002,-4.4860840e-003,-3.3081055e-002,-5.5084229e-002,-1.2054443e-002,2.6733398e-002,5.1513672e-002,7.5134277e-002,4.9224854e-002,3.0029297e-002,3.8208008e-002,3.9428711e-002,6.2377930e-002,7.5225830e-002,5.3192139e-002,3.5949707e-002,1.2145996e-002,-8.8806152e-003,-6.7443848e-003,-6.8054199e-003,-1.3000488e-002,-1.4526367e-002,-2.4322510e-002,-3.2623291e-002,-3.2592773e-002,-3.7872314e-002,-4.1015625e-002,-4.1259766e-002,-3.5583496e-002,-2.1636963e-002,3.9062500e-003,3.1036377e-002,4.5410156e-002,5.4260254e-002,4.3762207e-002,2.8869629e-002,2.6245117e-002,2.2613525e-002,3.3294678e-002,4.4708252e-002,4.0130615e-002,3.8085938e-002,2.5177002e-002,1.3397217e-002,1.5075684e-002,1.1138916e-002,8.4228516e-003,1.7089844e-003,-1.3244629e-002,-2.3406982e-002,-2.4108887e-002,-2.1972656e-002,-1.6601563e-002,-1.1779785e-002,-1.9622803e-002,-2.5512695e-002,-3.0090332e-002,-3.4790039e-002,-3.0426025e-002,-2.7252197e-002,-2.4108887e-002,-1.4862061e-002,-2.4719238e-003,1.2756348e-002,2.7587891e-002,3.5797119e-002,3.6682129e-002,3.2135010e-002,2.8350830e-002,2.2338867e-002,2.1911621e-002,2.2521973e-002,2.0172119e-002,2.3132324e-002,2.3529053e-002,2.4627686e-002,2.2460938e-002,1.5899658e-002,6.7138672e-003,-4.0893555e-003,-7.9040527e-003,-1.1260986e-002,-9.7045898e-003,-6.6528320e-003,-7.2937012e-003,-5.6152344e-003,-8.1481934e-003,-1.3305664e-002,-1.9042969e-002,-2.4505615e-002,-2.2735596e-002,-1.6693115e-002,-6.3476563e-003,1.9836426e-003,-1.4343262e-003,-4.5776367e-003,-5.6152344e-003,-2.1362305e-003,1.5899658e-002,2.8289795e-002,2.7893066e-002,2.3406982e-002,8.0261230e-003,-4.2114258e-003,9.4604492e-004,4.4250488e-003,7.4157715e-003,1.1749268e-002,3.9062500e-003,1.8005371e-003,5.0048828e-003,2.1667480e-003,-1.4038086e-003,-7.5988770e-003,-1.2664795e-002,-1.2084961e-002,-1.0681152e-003,2.8381348e-003,-1.0437012e-002,-2.4902344e-002,-4.2388916e-002,-4.5928955e-002,-1.8524170e-002,6.0424805e-003,1.5808105e-002,1.8493652e-002,-4.4250488e-003,-1.6479492e-002,9.5520020e-003,3.3569336e-002,6.5002441e-002,8.6029053e-002,6.4910889e-002,4.7363281e-002,3.9123535e-002,2.8411865e-002,4.0069580e-002,4.6539307e-002,3.6163330e-002,3.4362793e-002,2.7557373e-002,1.9561768e-002,1.3549805e-002,9.1552734e-005,-1.5380859e-002,-2.4780273e-002,-1.9134521e-002,-1.2878418e-002,-1.0101318e-002,-7.6293945e-003,-1.6113281e-002,-1.7852783e-002,-6.0729980e-003,-4.5166016e-003,-1.4038086e-002,-2.6947021e-002,-4.3090820e-002,-4.0496826e-002,-3.0822754e-003,2.8381348e-002,3.2775879e-002,2.4475098e-002,-1.6326904e-002,-4.1839600e-002,-7.0190430e-003,2.3590088e-002,5.2795410e-002,6.4636230e-002,7.7514648e-003,-3.1738281e-002,-2.3803711e-002,-1.3427734e-002,3.3325195e-002,5.7220459e-002,6.3171387e-003,-3.0212402e-002,-4.9621582e-002,-5.5297852e-002,7.1105957e-003,5.4595947e-002,4.6966553e-002,4.4860840e-002,1.7669678e-002,-2.4414063e-003,3.0334473e-002,4.5257568e-002,4.4158936e-002,4.6478271e-002,2.4993896e-002,1.4801025e-002,2.7557373e-002,2.7374268e-002,1.3732910e-002,2.4719238e-003,-1.1505127e-002,-1.6204834e-002,2.9296875e-003,9.1857910e-003,-7.4768066e-003,-2.1453857e-002,-3.4301758e-002,-3.3721924e-002,1.2817383e-003,2.6245117e-002,2.1057129e-002,1.3549805e-002,-1.3702393e-002,-3.4301758e-002,-1.7791748e-002,-1.2115479e-002,-1.6662598e-002,-1.9927979e-002,-4.3029785e-002,-5.1116943e-002,-3.0426025e-002,-1.2878418e-002,2.6550293e-003,1.6021729e-002,1.1505127e-002,1.0894775e-002,2.5817871e-002,3.2562256e-002,3.8238525e-002,4.3579102e-002,3.9855957e-002,4.3365479e-002,5.4534912e-002,5.8441162e-002,4.8004150e-002,3.5247803e-002,1.7669678e-002,4.5776367e-003,1.2603760e-002,1.3885498e-002,6.6833496e-003,1.9531250e-003,-5.6152344e-003,-3.4179688e-003,1.9195557e-002,3.3966064e-002,3.2562256e-002,2.6519775e-002,5.4016113e-003,-9.8571777e-003,3.3569336e-004,6.5307617e-003,8.1176758e-003,1.0406494e-002,-8.3007813e-003,-2.1118164e-002,-2.1575928e-002,-2.8320313e-002,-2.9724121e-002,-3.2165527e-002,-3.8909912e-002,-3.7048340e-002,-2.3254395e-002,-1.2451172e-002,-7.0800781e-003,-1.6479492e-003,-2.3803711e-003,2.8686523e-003,2.1972656e-002,3.4912109e-002,3.7506104e-002,3.7658691e-002,2.7252197e-002,2.4719238e-002,3.9764404e-002,4.8370361e-002,4.8309326e-002,4.0954590e-002,1.4678955e-002,-6.1340332e-003,-4.9743652e-003,-5.0659180e-003,3.0517578e-003,9.3078613e-003,-3.8146973e-003,-1.0437012e-002,-1.2054443e-002,-1.7089844e-002,-1.5167236e-002,-1.7333984e-002,-2.5054932e-002,-2.3498535e-002,-1.3671875e-002,-2.2277832e-003,6.1035156e-003,9.1857910e-003,-2.7465820e-003,-1.0253906e-002,8.5449219e-004,1.3061523e-002,3.7506104e-002,5.6915283e-002,5.2398682e-002,4.6905518e-002,3.5797119e-002,2.2430420e-002,2.5329590e-002,2.4475098e-002,2.0446777e-002,1.9470215e-002,8.4533691e-003,2.2277832e-003,6.1035156e-005,-2.6550293e-003,-2.6245117e-003,-3.6926270e-003,-7.4768066e-003,-1.2237549e-002,-1.5960693e-002,-1.8157959e-002,-1.0437012e-002,1.2207031e-003,1.5289307e-002,2.7954102e-002,2.7404785e-002,2.2338867e-002,1.3031006e-002,3.0822754e-003,7.2326660e-003,1.1596680e-002,1.4160156e-002,1.6754150e-002,5.1574707e-003,-1.9531250e-003,7.0190430e-004,6.4392090e-003,2.4505615e-002,3.9123535e-002,4.0344238e-002,3.7597656e-002,2.6580811e-002,1.0375977e-002,2.5939941e-003,-9.2468262e-003,-2.1850586e-002,-3.0059814e-002,-4.1625977e-002,-4.2022705e-002,-3.4332275e-002,-2.3162842e-002,-1.4099121e-002,-9.4909668e-003,-1.3488770e-002,-2.0294189e-002,-1.5960693e-002,-1.3458252e-002,2.1362305e-003,1.8463135e-002,2.4017334e-002,3.4606934e-002,3.9764404e-002,4.6691895e-002,5.8471680e-002,6.2194824e-002,5.4992676e-002,4.2022705e-002,2.2583008e-002,6.3171387e-003,8.5144043e-003,1.2176514e-002,1.6540527e-002,1.8768311e-002,-1.9531250e-003,-2.0965576e-002,-3.2287598e-002,-4.1625977e-002,-2.8076172e-002,-1.4892578e-002,-1.1291504e-002,-5.5236816e-003,-1.4495850e-002,-2.2491455e-002,-2.0538330e-002,-2.2033691e-002,-1.7486572e-002,-1.2390137e-002,-1.1718750e-002,-5.2795410e-003,3.2348633e-003,1.3061523e-002,2.3406982e-002,3.1585693e-002,3.6499023e-002,3.8787842e-002,4.1595459e-002,4.0557861e-002,3.6590576e-002,3.1372070e-002,2.4963379e-002,2.2308350e-002,2.6763916e-002,3.3020020e-002,3.4729004e-002,3.4057617e-002,2.2796631e-002,9.8571777e-003,3.9367676e-003,-5.2795410e-003,-7.7514648e-003,-1.3275146e-002,-2.5939941e-002,-3.4729004e-002,-3.8726807e-002,-3.3752441e-002,-1.9592285e-002,-5.4626465e-003,-1.0986328e-003,6.7138672e-004,-6.0729980e-003,-1.3977051e-002,-1.0833740e-002,-1.0162354e-002,-5.8593750e-003,-1.8310547e-004,6.4086914e-004,8.5754395e-003,2.1667480e-002,3.5888672e-002,4.7729492e-002,5.2154541e-002,4.3731689e-002,2.9602051e-002,1.8524170e-002,7.0495605e-003,7.6293945e-003,1.0925293e-002,8.7890625e-003,9.4909668e-003,-1.1291504e-003,-1.0589600e-002,-1.5258789e-002,-2.1301270e-002,-1.8402100e-002,-1.5838623e-002,-1.3244629e-002,-8.0871582e-003,-4.2114258e-003,1.4953613e-003,9.8876953e-003,1.5594482e-002,1.5563965e-002,1.2939453e-002,6.6833496e-003,2.4108887e-003,7.6599121e-003,1.5197754e-002,2.1911621e-002,2.6947021e-002,1.6571045e-002,5.0048828e-003,-2.9907227e-003,-1.1413574e-002,-5.2795410e-003,-1.8615723e-003,-7.1411133e-003,-1.2145996e-002,-2.5878906e-002,-3.6163330e-002,-3.2531738e-002,-2.9663086e-002,-2.2918701e-002,-1.6479492e-002,-2.3315430e-002,-2.8747559e-002,-3.1463623e-002,-3.4545898e-002,-2.8503418e-002,-2.1972656e-002,-1.7730713e-002,-7.8735352e-003,1.9531250e-003,1.3946533e-002,2.7618408e-002,3.5980225e-002,3.6865234e-002,3.4240723e-002,3.2379150e-002,3.2165527e-002,4.2846680e-002,5.3283691e-002,5.5816650e-002,5.4962158e-002,3.7872314e-002,2.0721436e-002,1.3366699e-002,6.7138672e-003,1.2298584e-002,1.4678955e-002,8.5449219e-004,-1.1718750e-002,-2.6611328e-002,-3.4851074e-002,-1.7486572e-002,-9.1552734e-004,9.0026855e-003,1.3458252e-002,-7.5988770e-003,-2.8442383e-002,-3.1677246e-002,-3.6560059e-002,-2.4810791e-002,-1.5014648e-002,-2.6489258e-002,-2.8228760e-002,-2.8564453e-002,-2.3254395e-002,-1.8310547e-004,1.3153076e-002,8.9111328e-003,1.3732910e-003,-1.0955811e-002,-1.7944336e-002,1.4343262e-003,1.9805908e-002,3.0944824e-002,4.4525146e-002,3.4851074e-002,2.6519775e-002,2.5604248e-002,1.5563965e-002,8.1176758e-003,-3.5095215e-003,-1.9927979e-002,-2.8045654e-002,-2.5726318e-002,-1.9439697e-002,-1.4556885e-002,-9.7045898e-003,-1.4373779e-002,-1.6113281e-002,-6.3171387e-003,1.4343262e-003,1.4709473e-002,2.4871826e-002,2.3498535e-002,2.3315430e-002,2.3559570e-002,2.1759033e-002,2.2644043e-002,2.2827148e-002,1.9897461e-002,2.2308350e-002,2.7343750e-002,3.0731201e-002,2.9357910e-002,2.2491455e-002,9.9487305e-003,-2.0751953e-003,-2.7465820e-003,-5.0354004e-003,-7.7209473e-003,-1.2817383e-002,-3.0303955e-002,-4.4128418e-002,-5.1361084e-002,-5.6854248e-002,-5.4809570e-002,-5.2246094e-002,-5.4962158e-002,-5.1574707e-002,-4.2236328e-002,-3.1433105e-002,-1.5747070e-002,-4.1198730e-003,-4.8828125e-004,2.8381348e-003,9.1247559e-003,1.4678955e-002,2.4963379e-002,3.2348633e-002,2.9602051e-002,2.9357910e-002,3.0487061e-002,3.6010742e-002,4.7729492e-002,5.6121826e-002,5.3863525e-002,4.7454834e-002,3.5156250e-002,2.0355225e-002,1.6448975e-002,9.4604492e-003,2.1362305e-003,-5.1574707e-003,-2.1118164e-002,-3.3020020e-002,-4.2053223e-002,-4.9652100e-002,-5.2246094e-002,-5.3466797e-002,-5.5755615e-002,-5.5328369e-002,-5.2734375e-002,-4.8065186e-002,-3.9611816e-002,-3.0548096e-002,-2.0965576e-002,-1.2115479e-002,-4.7607422e-003,1.0070801e-003,4.4250488e-003,6.4697266e-003,1.0345459e-002,1.6143799e-002,2.5756836e-002,3.6224365e-002,4.1168213e-002,4.2144775e-002,3.2318115e-002,1.9042969e-002,1.1169434e-002,3.6926270e-003,6.9885254e-003,1.0986328e-002,5.8898926e-003,6.1035156e-004,-1.4556885e-002,-2.9632568e-002,-3.4729004e-002,-4.0557861e-002,-4.0893555e-002,-4.0954590e-002,-4.8126221e-002,-5.1391602e-002,-5.1055908e-002,-4.6325684e-002,-3.1402588e-002,-1.6784668e-002,-4.7607422e-003,6.0729980e-003,1.1077881e-002,1.3183594e-002,1.8249512e-002,2.0019531e-002,2.1240234e-002,2.2033691e-002,1.8829346e-002,1.7669678e-002,1.7852783e-002,2.0599365e-002,2.5726318e-002,3.0364990e-002,3.0700684e-002,2.6184082e-002,1.6143799e-002,2.4414063e-003,-5.4626465e-003,-1.1322021e-002,-7.5378418e-003,-4.5776367e-004,8.2397461e-004,4.4860840e-003,-8.5449219e-004,-6.1950684e-003,-7.9956055e-003,-1.4129639e-002,-1.7944336e-002,-2.4200439e-002,-3.3538818e-002,-3.9672852e-002,-4.0283203e-002,-3.7353516e-002,-3.0944824e-002,-2.2644043e-002,-1.7639160e-002,-9.4909668e-003,2.1362305e-003,1.2268066e-002,2.4444580e-002,3.1066895e-002,2.8839111e-002,2.3773193e-002,1.7211914e-002,1.0925293e-002,1.1291504e-002,1.3916016e-002,1.4038086e-002,1.6937256e-002,1.2207031e-002,5.2490234e-003,-1.5563965e-003,-1.1169434e-002,-1.2939453e-002,-1.4892578e-002,-1.5533447e-002,-1.6632080e-002,-2.6092529e-002,-3.4637451e-002,-4.0222168e-002,-3.9398193e-002,-2.5543213e-002,-8.5754395e-003,3.5400391e-003,1.4770508e-002,1.4495850e-002,1.2115479e-002,1.5777588e-002,1.2329102e-002,1.0192871e-002,3.1738281e-003,-1.1657715e-002,-2.1636963e-002,-2.4871826e-002,-2.3437500e-002,-1.7639160e-002,-1.1688232e-002,-1.6448975e-002,-1.9958496e-002,-2.1270752e-002,-2.3651123e-002,-1.4434814e-002,-8.7280273e-003,-7.0800781e-003,-4.3334961e-003,-7.3852539e-003,-9.3383789e-003,-8.4838867e-003,-7.6904297e-003,-5.4321289e-003,-1.4953613e-003,-8.2397461e-004,-1.1596680e-003,-5.1574707e-003,-1.2145996e-002,-1.6632080e-002,-1.9866943e-002,-1.6632080e-002,-1.3092041e-002,-1.3488770e-002,-1.5106201e-002,-2.2705078e-002,-2.7069092e-002,-2.2949219e-002,-1.6876221e-002,-8.4533691e-003,-1.5258789e-003,-4.6997070e-003,-6.8054199e-003,-6.3781738e-003,-6.0424805e-003,9.4604492e-004,7.4768066e-003,7.4157715e-003,6.5307617e-003,2.1057129e-003,-1.9836426e-003,-6.7138672e-004,-3.6621094e-004,1.3732910e-003,4.3945313e-003,4.5166016e-003,4.6691895e-003,1.1596680e-003,-5.2490234e-003,-1.3031006e-002,-2.2338867e-002,-2.4963379e-002,-2.9846191e-002,-3.0639648e-002,-2.6489258e-002,-2.5238037e-002,-2.0660400e-002,-1.4373779e-002,-9.3994141e-003,-4.4555664e-003,-3.5705566e-003,-5.6152344e-003,-9.4604492e-003,-9.8876953e-003,-1.1688232e-002,-1.3427734e-002,-1.2664795e-002,-1.4587402e-002,-1.0803223e-002,-3.2958984e-003,3.7841797e-003,7.6904297e-003,7.3852539e-003,-3.3569336e-004,-8.2397461e-003,-6.7443848e-003,-5.0048828e-003,2.8381348e-003,9.7045898e-003,3.2958984e-003,-2.8381348e-003,-1.3580322e-002,-2.5695801e-002,-2.7496338e-002,-2.9388428e-002,-2.9144287e-002,-2.5177002e-002,-2.5024414e-002,-2.2583008e-002,-2.0751953e-002,-1.8768311e-002,-1.2664795e-002,-6.4392090e-003,2.4414063e-003,9.8876953e-003,1.0498047e-002,8.1787109e-003,1.5869141e-003,-4.0283203e-003,-1.2207031e-003,1.6784668e-003,3.0212402e-003,3.3874512e-003,-7.1411133e-003,-1.6174316e-002,-2.0416260e-002,-2.5909424e-002,-2.5115967e-002,-2.6855469e-002,-3.3660889e-002,-3.5400391e-002,-3.0853271e-002,-2.2277832e-002,-9.0637207e-003,2.4414063e-004,-4.7302246e-003,-1.1322021e-002,-1.6906738e-002,-2.0233154e-002,-7.7819824e-003,2.6855469e-003,2.9907227e-003,2.7160645e-003,-8.7890625e-003,-1.7028809e-002,-9.6435547e-003,-3.6621094e-003,4.8522949e-003,1.0589600e-002,2.2583008e-003,-3.9367676e-003,-2.5329590e-003,3.0517578e-005,1.0375977e-002,1.7578125e-002,1.0559082e-002,2.9296875e-003,-6.8664551e-003,-1.5075684e-002,-1.1474609e-002,-8.2092285e-003,-9.5214844e-003,-1.0375977e-002,-1.9287109e-002,-2.7160645e-002,-2.7069092e-002,-2.7496338e-002,-2.1850586e-002,-1.6082764e-002,-1.6815186e-002,-1.5380859e-002,-1.7272949e-002,-2.0874023e-002,-2.1575928e-002,-2.3620605e-002,-2.3712158e-002,-2.2521973e-002,-2.2735596e-002,-2.1942139e-002,-2.2918701e-002,-2.3345947e-002,-2.1636963e-002,-2.0843506e-002,-1.8432617e-002,-1.6204834e-002,-1.3610840e-002,-1.0284424e-002,-5.2185059e-003,-5.7983398e-004,1.1291504e-003,1.4953613e-003,-1.7089844e-003,-3.8452148e-003,-1.7089844e-003,-3.0517578e-004,-9.7656250e-004,-3.7536621e-003,-1.3854980e-002,-2.0782471e-002,-1.8676758e-002,-1.3732910e-002,-3.2958984e-003,2.6855469e-003,-8.1481934e-003,-2.2308350e-002,-3.5705566e-002,-4.6966553e-002,-3.7292480e-002,-2.5268555e-002,-1.8463135e-002,-7.9650879e-003,-1.1199951e-002,-1.1871338e-002,-4.1809082e-003,-1.3732910e-003,3.5095215e-003,2.8076172e-003,-8.2092285e-003,-1.9104004e-002,-2.5390625e-002,-3.0059814e-002,-2.7069092e-002,-2.2338867e-002,-2.2979736e-002,-2.0690918e-002,-2.1881104e-002,-2.5024414e-002,-2.5726318e-002,-2.7374268e-002,-2.5299072e-002,-2.2155762e-002,-1.7059326e-002,-1.0589600e-002,-8.2702637e-003,-5.6762695e-003,-6.8054199e-003,-8.3618164e-003,-8.6059570e-003,-9.7045898e-003,-8.4838867e-003,-4.6386719e-003,2.2888184e-003,1.1352539e-002,1.8676758e-002,2.1026611e-002,1.4007568e-002,2.9907227e-003,-5.5541992e-003,-1.4923096e-002,-1.5869141e-002,-1.7944336e-002,-2.7557373e-002,-3.4149170e-002,-4.4311523e-002,-4.8950195e-002,-4.2755127e-002,-3.6102295e-002,-3.0181885e-002,-2.5573730e-002,-2.6977539e-002,-2.8503418e-002,-2.5543213e-002,-2.4963379e-002,-2.1728516e-002,-1.8463135e-002,-1.8127441e-002,-1.5991211e-002,-1.5930176e-002,-1.7150879e-002,-2.0568848e-002,-2.2460938e-002,-1.9622803e-002,-1.3977051e-002,-4.7912598e-003,1.0986328e-003,-1.7395020e-003,-4.9438477e-003,-5.6762695e-003,-3.5095215e-003,7.7209473e-003,1.5991211e-002,1.2237549e-002,7.7514648e-003,-2.1057129e-003,-1.0772705e-002,-6.8664551e-003,-4.5471191e-003,-4.4555664e-003,-3.2043457e-003,-8.5754395e-003,-1.0467529e-002,-6.0424805e-003,-5.8288574e-003,-8.6059570e-003,-1.3580322e-002,-1.9500732e-002,-2.2216797e-002,-1.6662598e-002,-1.0681152e-002,-1.0375977e-002,-8.7585449e-003,-1.3336182e-002,-1.6448975e-002,-1.4221191e-002,-1.6906738e-002,-2.2521973e-002,-2.6641846e-002,-2.5817871e-002,-1.7028809e-002,2.3193359e-003,1.7333984e-002,1.3854980e-002,2.5329590e-003,-2.0233154e-002,-4.3212891e-002,-4.1564941e-002,-3.8574219e-002,-3.1463623e-002,-1.9775391e-002,-2.7252197e-002,-2.8564453e-002,-2.8106689e-002,-3.0700684e-002,-2.2857666e-002,-1.6357422e-002,-4.9133301e-003,1.0162354e-002,2.2186279e-002,2.6641846e-002,1.3793945e-002,-3.6621094e-003,-1.5563965e-002,-1.9561768e-002,9.4604492e-004,2.1820068e-002,2.0477295e-002,1.4953613e-002,-1.4862061e-002,-4.0344238e-002,-3.3996582e-002,-2.6916504e-002,-7.2326660e-003,8.5144043e-003,-6.1340332e-003,-1.7028809e-002,-2.4047852e-002,-3.2348633e-002,-2.0751953e-002,-1.2207031e-002,-1.2481689e-002,-8.2092285e-003,-1.0314941e-002,-1.2573242e-002,-1.3641357e-002,-2.0050049e-002,-2.7526855e-002,-3.1036377e-002,-2.4810791e-002,-1.6357422e-002,-1.0650635e-002,-8.2092285e-003,-1.9409180e-002,-2.9052734e-002,-2.7740479e-002,-2.4932861e-002,-1.2573242e-002,-2.5329590e-003,-6.5612793e-003,-8.5449219e-003,-1.0986328e-002,-1.2481689e-002,-4.6386719e-003,-2.7465820e-004,-7.0190430e-004,3.6621094e-004,-3.0517578e-005,-4.5776367e-004,1.5258789e-003,9.1552734e-005,-6.2255859e-003,-1.1993408e-002,-1.4648438e-002,-1.5991211e-002,-1.4953613e-002,-1.4923096e-002,-2.1392822e-002,-2.5512695e-002,-2.5939941e-002,-2.4810791e-002,-1.7974854e-002,-1.1108398e-002,-9.0026855e-003,-6.0424805e-003,-2.3498535e-003,9.1552734e-005,4.6691895e-003,7.8125000e-003,6.2866211e-003,5.6762695e-003,6.1035156e-003,6.8359375e-003,6.6833496e-003,3.3264160e-003,-7.1105957e-003,-1.6479492e-002,-2.0477295e-002,-2.1087646e-002,-1.3214111e-002,-5.2795410e-003,-5.4626465e-003,-6.8969727e-003,-1.3732910e-002,-2.1850586e-002,-2.0263672e-002,-1.8707275e-002,-1.2908936e-002,-4.8217773e-003,-4.0893555e-003,-2.4108887e-003,-5.6457520e-003,-9.1552734e-003,-7.6904297e-003,-6.2561035e-003,-1.2207031e-004,4.8522949e-003,2.5939941e-003,-2.5024414e-003,-1.3275146e-002,-2.4322510e-002,-2.6977539e-002,-2.9388428e-002,-2.8411865e-002,-2.7191162e-002,-3.4973145e-002,-4.1381836e-002,-4.7454834e-002,-5.1910400e-002,-4.7058105e-002,-4.0710449e-002,-3.3203125e-002,-2.3803711e-002,-1.9866943e-002,-1.6174316e-002,-1.3580322e-002,-1.3641357e-002,-1.0650635e-002,-7.7514648e-003,-3.2958984e-003,1.9531250e-003,5.3405762e-003,8.5449219e-003,8.6669922e-003,7.3547363e-003,8.4228516e-003,7.6599121e-003,9.0026855e-003,9.8876953e-003,8.8500977e-003,7.5683594e-003,3.6926270e-003,-3.0517578e-005,-1.8615723e-003,-3.6010742e-003,-3.9367676e-003,-4.1503906e-003,-8.0261230e-003,-1.2969971e-002,-1.9866943e-002,-2.7160645e-002,-3.0151367e-002,-3.2684326e-002,-3.3264160e-002,-3.2836914e-002,-3.4790039e-002,-3.5827637e-002,-3.6529541e-002,-3.7292480e-002,-3.4484863e-002,-3.1127930e-002,-2.7099609e-002,-2.2247314e-002,-1.8554688e-002,-1.4038086e-002,-9.4604492e-003,-4.5776367e-003,1.8005371e-003,7.8125000e-003,1.2145996e-002,1.5533447e-002,1.5991211e-002,1.5167236e-002,1.5441895e-002,1.3519287e-002,1.1016846e-002,6.7749023e-003,-1.0070801e-003,-8.1787109e-003,-1.2817383e-002,-1.5869141e-002,-1.5533447e-002,-1.5075684e-002,-1.8554688e-002,-1.9104004e-002,-1.6723633e-002,-1.3031006e-002,-3.8757324e-003,4.5776367e-004,-4.4860840e-003,-1.2207031e-002,-1.7852783e-002,-2.1087646e-002,-1.3153076e-002,-7.3547363e-003,-1.3702393e-002,-2.3162842e-002,-4.4281006e-002,-6.1584473e-002,-5.9753418e-002,-5.5053711e-002,-4.3701172e-002,-3.2226563e-002,-3.7902832e-002,-4.1168213e-002,-4.0435791e-002,-4.0618896e-002,-2.8045654e-002,-1.8371582e-002,-1.7120361e-002,-1.4678955e-002,-1.6601563e-002,-1.7272949e-002,-1.1505127e-002,-5.8288574e-003,0.0000000e+000,7.8735352e-003,1.3153076e-002,1.7700195e-002,2.1026611e-002,2.0263672e-002,1.8066406e-002,1.4984131e-002,1.5045166e-002,1.3916016e-002,1.0162354e-002,5.0354004e-003,-6.5307617e-003,-1.4770508e-002,-1.5716553e-002,-1.3793945e-002,-9.2163086e-003,-6.8054199e-003,-1.5167236e-002,-2.3620605e-002,-2.8686523e-002,-3.4637451e-002,-3.1372070e-002,-3.1555176e-002,-3.9489746e-002,-4.6478271e-002,-5.6701660e-002,-6.2164307e-002,-5.6732178e-002,-4.8339844e-002,-4.0161133e-002,-2.9235840e-002,-2.3101807e-002,-1.6021729e-002,-4.7912598e-003,2.0751953e-003,8.4533691e-003,1.1291504e-002,1.1505127e-002,1.2115479e-002,1.5716553e-002,1.9714355e-002,2.0690918e-002,2.1148682e-002,1.5411377e-002,1.0589600e-002,1.0101318e-002,9.4909668e-003,1.3336182e-002,1.5960693e-002,1.3153076e-002,1.0223389e-002,5.7067871e-003,1.0681152e-003,1.4343262e-003,2.1362305e-004,-2.6855469e-003,-6.2866211e-003,-1.4404297e-002,-2.1850586e-002,-2.6794434e-002,-3.1799316e-002,-3.3874512e-002,-3.4698486e-002,-3.6346436e-002,-3.5858154e-002,-3.4240723e-002,-3.3294678e-002,-3.3111572e-002,-3.5125732e-002,-3.8085938e-002,-3.9916992e-002,-3.6407471e-002,-3.1158447e-002,-2.4871826e-002,-1.8646240e-002,-1.9836426e-002,-1.9775391e-002,-1.8188477e-002,-1.5838623e-002,-6.6833496e-003,8.5449219e-004,3.6621094e-003,5.7983398e-003,4.8828125e-003,4.0588379e-003,8.2092285e-003,1.0314941e-002,1.1230469e-002,1.1199951e-002,9.7656250e-003,9.7045898e-003,1.1260986e-002,1.2115479e-002,1.1444092e-002,1.0772705e-002,8.3618164e-003,7.0800781e-003,9.2163086e-003,1.0192871e-002,9.4909668e-003,7.6599121e-003,3.1433105e-003,-1.3732910e-003,-3.5095215e-003,-7.2021484e-003,-1.2023926e-002,-1.7333984e-002,-2.4414063e-002,-2.9449463e-002,-3.2318115e-002,-3.3935547e-002,-3.6437988e-002,-3.8726807e-002,-4.1259766e-002,-4.1381836e-002,-3.6956787e-002,-3.1494141e-002,-2.6031494e-002,-2.1179199e-002,-1.9287109e-002,-1.7578125e-002,-1.3031006e-002,-8.5144043e-003,-1.9531250e-003,4.6081543e-003,7.8125000e-003,1.0437012e-002,1.0345459e-002,9.1247559e-003,7.9650879e-003,5.4931641e-003,4.6691895e-003,4.6081543e-003,6.0729980e-003,9.0026855e-003,1.0986328e-002,1.3946533e-002,1.5472412e-002,1.5411377e-002,1.3397217e-002,8.1787109e-003,2.9602051e-003,-2.4414063e-003,-4.1503906e-003,-5.1574707e-003,-7.6599121e-003,-1.0498047e-002,-1.7303467e-002,-2.2735596e-002,-2.3132324e-002,-2.1118164e-002,-1.3275146e-002,-5.8898926e-003,-4.4555664e-003,-4.3029785e-003,-6.6223145e-003,-1.0742188e-002,-1.1260986e-002,-1.4404297e-002,-1.8249512e-002,-1.9287109e-002,-1.9958496e-002,-1.7333984e-002,-1.3305664e-002,-1.0253906e-002,-1.3214111e-002,-1.6906738e-002,-1.9012451e-002,-2.0782471e-002,-1.3610840e-002,-8.0261230e-003,-7.0495605e-003,-5.8898926e-003,-1.0375977e-002,-1.3519287e-002,-1.0192871e-002,-6.5002441e-003,-5.7983398e-004,6.7443848e-003,7.9956055e-003,9.3688965e-003,9.4909668e-003,6.8359375e-003,5.7983398e-003,3.9062500e-003,4.7302246e-003,6.6223145e-003,9.1247559e-003,1.1596680e-002,7.4157715e-003,3.4790039e-003,-3.6621094e-004,-3.9978027e-003,-1.7395020e-003,-6.1035156e-004,-2.0751953e-003,-3.1738281e-003,-8.1481934e-003,-1.1108398e-002,-7.9040527e-003,-5.3100586e-003,-3.8757324e-003,-1.3122559e-003,-2.6855469e-003,-3.1433105e-003,2.1362305e-003,5.3710938e-003,8.1176758e-003,7.5378418e-003,-9.7656250e-004,-9.7961426e-003,-1.4099121e-002,-1.6540527e-002,-1.3061523e-002,-8.5754395e-003,-1.0742188e-002,-1.1383057e-002,-1.3702393e-002,-1.5716553e-002,-1.0955811e-002,-7.2021484e-003,-5.0048828e-003,-2.8381348e-003,-2.0751953e-003,-8.8500977e-004,3.9367676e-003,6.5002441e-003,4.1809082e-003,-2.1362305e-004,-9.5214844e-003,-1.7150879e-002,-1.5441895e-002,-1.1627197e-002,-5.3710938e-003,2.4108887e-003,8.2397461e-004,-3.0517578e-004,-1.3732910e-003,-4.0283203e-003,6.1035156e-004,4.4250488e-003,6.7443848e-003,9.9182129e-003,9.3078613e-003,8.3618164e-003,5.3100586e-003,-5.4931641e-004,-7.3242188e-003,-1.4404297e-002,-1.8463135e-002,-2.0233154e-002,-2.0080566e-002,-1.8798828e-002,-2.1148682e-002,-2.1850586e-002,-2.0538330e-002,-1.8707275e-002,-1.3214111e-002,-8.5449219e-003,-8.3923340e-003,-6.0424805e-003,-4.1503906e-003,-1.9226074e-003,2.3803711e-003,3.7841797e-003,-9.1552734e-004,-4.9743652e-003,-8.3312988e-003,-1.0040283e-002,-5.4626465e-003,-2.3498535e-003,-4.8828125e-003,-8.1481934e-003,-1.4190674e-002,-1.8035889e-002,-1.2573242e-002,-7.2631836e-003,-2.4108887e-003,3.1127930e-003,1.2817383e-003,-7.0190430e-004,2.1362305e-004,-1.9226074e-003,-4.2724609e-003,-7.2021484e-003,-1.1383057e-002,-1.1474609e-002,-7.2937012e-003,-3.1433105e-003,-3.0212402e-003,-5.3100586e-003,-1.1688232e-002,-1.6723633e-002,-1.1199951e-002,-6.4697266e-003,-1.1596680e-003,2.9907227e-003,-4.0588379e-003,-9.2163086e-003,-9.8571777e-003,-9.7656250e-003,-4.0588379e-003,1.3427734e-003,-8.5449219e-004,-9.1552734e-004,-8.8500977e-004,-1.3732910e-003,3.2043457e-003,4.8828125e-003,2.7160645e-003,2.4414063e-004,-1.6479492e-003,-2.2277832e-003,8.5449219e-004,4.5471191e-003,6.7138672e-003,8.6975098e-003,8.1787109e-003,6.8969727e-003,5.5541992e-003,3.0822754e-003,1.5258789e-004,-1.6784668e-003,-2.7465820e-004,2.0751953e-003,4.1809082e-003,5.2795410e-003,1.1901855e-003,-2.3193359e-003,-2.3498535e-003,-1.8920898e-003,3.4179688e-003,7.0190430e-003,2.7465820e-003,-3.5095215e-003,-1.3702393e-002,-2.3956299e-002,-2.5085449e-002,-2.3040771e-002,-1.7364502e-002,-8.8806152e-003,-6.5917969e-003,-2.9296875e-003,-2.1362305e-004,3.3569336e-004,5.2185059e-003,7.1105957e-003,9.2163086e-003,1.0437012e-002,9.8571777e-003,1.0711670e-002,1.1352539e-002,1.1962891e-002,9.6740723e-003,5.6762695e-003,-2.1362305e-004,-4.9438477e-003,-4.6997070e-003,-3.3569336e-003,-8.2397461e-004,4.2724609e-004,-4.1198730e-003,-8.0871582e-003,-8.9111328e-003,-8.7890625e-003,-2.6245117e-003,2.4108887e-003,9.4604492e-004,-6.1035156e-004,-5.7678223e-003,-1.0467529e-002,-9.2468262e-003,-9.1247559e-003,-9.0026855e-003,-6.6528320e-003,-6.8359375e-003,-3.1127930e-003,4.3334961e-003,1.0131836e-002,1.3244629e-002,1.3580322e-002,1.0864258e-002,9.1552734e-003,1.3671875e-002,1.7456055e-002,2.0355225e-002,2.1148682e-002,1.2420654e-002,4.3640137e-003,-7.9345703e-004,-3.9978027e-003,8.5449219e-004,6.3171387e-003,8.0871582e-003,1.1260986e-002,1.0162354e-002,7.6293945e-003,9.1552734e-003,8.0871582e-003,1.0314941e-002,1.2695313e-002,1.2878418e-002,1.4587402e-002,1.4099121e-002,1.3671875e-002,1.1138916e-002,7.4768066e-003,2.5024414e-003,-2.1057129e-003,-3.5705566e-003,-3.0822754e-003,2.9602051e-003,9.3688965e-003,1.1627197e-002,1.0162354e-002,2.4414063e-003,-8.1787109e-003,-1.2115479e-002,-1.5380859e-002,-1.3946533e-002,-9.7351074e-003,-1.1535645e-002,-8.6975098e-003,-6.7138672e-003,-4.2114258e-003,1.5258789e-003,3.9062500e-003,2.5634766e-003,2.2277832e-003,4.3029785e-003,7.5378418e-003,1.5075684e-002,2.0050049e-002,1.6754150e-002,1.2969971e-002,8.4228516e-003,5.6152344e-003,1.1657715e-002,1.7547607e-002,1.8676758e-002,2.0507813e-002,1.6052246e-002,1.2695313e-002,1.5655518e-002,1.6571045e-002,1.6845703e-002,1.6021729e-002,9.6130371e-003,4.2724609e-003,2.3193359e-003,2.1362305e-004,7.3242188e-004,2.2583008e-003,2.8381348e-003,5.1269531e-003,7.2937012e-003,7.4768066e-003,5.6762695e-003,2.8686523e-003,2.2888184e-003,3.3569336e-003,9.3383789e-003,1.5167236e-002,1.6265869e-002,2.0141602e-002,2.4902344e-002,3.2165527e-002,4.4036865e-002,4.7119141e-002,3.2928467e-002,7.8125000e-003,-2.6824951e-002,-5.7464600e-002,-5.8227539e-002,-4.6478271e-002,-2.3529053e-002,3.2653809e-003,-3.3569336e-003,-1.4770508e-002,-3.2928467e-002,-5.5450439e-002,-4.1992188e-002,-2.6336670e-002,-2.8381348e-003,2.3956299e-002,1.8463135e-002,1.1627197e-002,-2.8686523e-003,-1.9104004e-002,-6.5002441e-003,1.0467529e-002,3.7261963e-002,6.5582275e-002,6.4666748e-002,5.7464600e-002,4.1351318e-002,2.0355225e-002,2.6824951e-002,3.3355713e-002,4.3762207e-002,5.5572510e-002,4.0679932e-002,2.6672363e-002,1.2237549e-002,-1.7089844e-003,3.6926270e-003,9.3078613e-003,1.0345459e-002,1.4678955e-002,9.8876953e-003,5.6457520e-003,7.5378418e-003,6.6528320e-003,9.5214844e-003,1.0955811e-002,8.6059570e-003,7.5988770e-003,7.4462891e-003,7.2937012e-003,7.0800781e-003,6.9580078e-003,4.5776367e-003,2.3498535e-003,-7.9345703e-004,-6.0119629e-003,-1.2420654e-002,-1.8249512e-002,-1.9866943e-002,-1.8005371e-002,-1.0986328e-002,-3.5705566e-003,-1.9226074e-003,-2.1667480e-003,-6.9274902e-003,-1.3275146e-002,-1.0650635e-002,-7.8125000e-003,-3.0517578e-004,8.5754395e-003,9.8266602e-003,1.1535645e-002,7.5073242e-003,1.2817383e-003,-4.1198730e-003,-1.0864258e-002,-1.2695313e-002,-9.7351074e-003,-3.2653809e-003,6.4392090e-003,1.1779785e-002,1.7395020e-002,2.1575928e-002,2.6275635e-002,4.0100098e-002,5.1879883e-002,6.1492920e-002,6.6741943e-002,5.9265137e-002,4.8004150e-002,3.6132813e-002,2.1362305e-002,1.1688232e-002,4.0283203e-003,-4.0893555e-003,-5.9814453e-003,-7.7209473e-003,-7.6599121e-003,-9.3383789e-003,-1.3763428e-002,-1.6815186e-002,-1.9317627e-002,-1.0406494e-002,1.8005371e-003,1.6296387e-002,3.1524658e-002,3.4698486e-002,3.5644531e-002,3.1585693e-002,2.1636963e-002,1.4678955e-002,6.0119629e-003,-3.0517578e-005,-1.0986328e-003,6.1035156e-004,4.9438477e-003,3.2348633e-003,-3.0517578e-004,-6.8359375e-003,-1.2268066e-002,-3.6010742e-003,3.7841797e-003,1.1688232e-002,1.4404297e-002,-9.1552734e-005,-1.4099121e-002,-2.0141602e-002,-2.2369385e-002,-9.1857910e-003,5.3710938e-003,6.5307617e-003,1.1444092e-002,6.7443848e-003,-1.2207031e-004,3.9367676e-003,1.7700195e-003,1.1596680e-003,1.5563965e-003,7.0190430e-004,3.6926270e-003,9.4604492e-003,1.4038086e-002,1.2725830e-002,1.0406494e-002,4.8217773e-003,-1.8920898e-003,-4.1198730e-003,-7.6904297e-003,-1.0772705e-002,-9.9182129e-003,-6.7443848e-003,-1.5869141e-003,4.7302246e-003,7.5988770e-003,3.3874512e-003,-1.4038086e-003,2.7465820e-004,3.8146973e-003,1.5502930e-002,2.5634766e-002,2.3468018e-002,2.1881104e-002,1.6387939e-002,1.2878418e-002,2.2216797e-002,3.1158447e-002,3.6590576e-002,4.0100098e-002,3.1555176e-002,1.9622803e-002,1.1383057e-002,1.4038086e-003,2.6245117e-003,9.4604492e-003,1.8585205e-002,3.0883789e-002,3.1463623e-002,2.7099609e-002,1.4526367e-002,3.9672852e-004,9.7656250e-004,2.5939941e-003,9.1552734e-003,1.4801025e-002,3.4484863e-003,-4.3945313e-003,-5.4931641e-003,-4.0893555e-003,1.0070801e-002,1.8035889e-002,1.0803223e-002,3.8146973e-003,-1.1901855e-003,4.5776367e-004,2.4017334e-002,4.5196533e-002,4.9804688e-002,4.9560547e-002,2.9205322e-002,8.2397461e-003,7.2021484e-003,4.3945313e-003,8.6364746e-003,1.4923096e-002,4.7607422e-003,4.2724609e-004,-1.1596680e-003,-4.6386719e-003,-1.6784668e-003,-2.5329590e-003,-6.7443848e-003,-1.0986328e-002,-1.2359619e-002,-1.4221191e-002,-1.4190674e-002,-1.2908936e-002,-1.3458252e-002,-8.9111328e-003,-9.4604492e-004,7.9040527e-003,1.4190674e-002,1.8035889e-002,1.7181396e-002,1.5106201e-002,1.6937256e-002,1.6021729e-002,1.7303467e-002,1.8646240e-002,1.8371582e-002,2.1850586e-002,2.7069092e-002,3.1066895e-002,3.1005859e-002,2.7648926e-002,2.2003174e-002,1.6723633e-002,1.9073486e-002,2.1240234e-002,2.1972656e-002,2.2308350e-002,1.4831543e-002,9.0942383e-003,6.7443848e-003,3.9367676e-003,6.7138672e-003,8.2092285e-003,5.1269531e-003,1.3732910e-003,-4.2114258e-003,-1.1016846e-002,-1.4617920e-002,-1.6937256e-002,-1.4221191e-002,-8.6669922e-003,-3.5095215e-003,6.7138672e-004,-2.4108887e-003,-6.8969727e-003,-9.7656250e-003,-1.1566162e-002,-4.2114258e-003,4.0893555e-003,9.1857910e-003,1.5136719e-002,1.4251709e-002,1.3275146e-002,1.5808105e-002,1.6235352e-002,1.9775391e-002,2.2155762e-002,2.0904541e-002,1.9348145e-002,1.5106201e-002,9.7961426e-003,6.5002441e-003,3.9367676e-003,4.6386719e-003,6.1340332e-003,5.0659180e-003,3.4484863e-003,-1.2512207e-003,-3.5400391e-003,1.4953613e-003,8.8195801e-003,1.8951416e-002,2.6641846e-002,2.3345947e-002,1.9104004e-002,1.7211914e-002,1.7303467e-002,2.8106689e-002,3.7261963e-002,3.7506104e-002,3.5461426e-002,2.4017334e-002,1.2512207e-002,1.2268066e-002,1.0620117e-002,1.2878418e-002,1.4617920e-002,3.0822754e-003,-9.0026855e-003,-2.1545410e-002,-3.2043457e-002,-2.8930664e-002,-2.2735596e-002,-1.5869141e-002,-8.6975098e-003,-1.4465332e-002,-2.0477295e-002,-2.1575928e-002,-2.0111084e-002,-2.4414063e-003,1.4587402e-002,2.0935059e-002,2.3834229e-002,1.1535645e-002,1.8615723e-003,1.1535645e-002,2.2125244e-002,3.8940430e-002,4.9591064e-002,3.1127930e-002,1.1383057e-002,-3.2043457e-003,-1.3488770e-002,4.0588379e-003,2.0721436e-002,1.9409180e-002,1.6967773e-002,-5.0964355e-003,-2.5268555e-002,-2.0416260e-002,-1.6113281e-002,-2.7465820e-003,1.0681152e-002,2.8076172e-003,-2.0141602e-003,-4.4555664e-003,-8.8195801e-003,-8.5449219e-004,4.4555664e-003,2.8991699e-003,3.2653809e-003,1.3427734e-003,2.1972656e-003,9.8266602e-003,1.6448975e-002,1.8554688e-002,1.8920898e-002,1.5014648e-002,1.0650635e-002,1.3671875e-002,1.6326904e-002,2.0874023e-002,2.4322510e-002,2.0660400e-002,1.5502930e-002,7.9956055e-003,-3.3569336e-004,-3.4179688e-003,-5.9814453e-003,-6.6833496e-003,-4.5166016e-003,-3.8757324e-003,-7.0190430e-004,1.8310547e-003,3.9978027e-003,6.0119629e-003,6.4086914e-003,8.8806152e-003,1.1260986e-002,1.5136719e-002,1.8463135e-002,1.7303467e-002,1.4617920e-002,9.6435547e-003,5.4321289e-003,5.8593750e-003,7.3547363e-003,8.5449219e-003,9.7045898e-003,5.7983398e-003,2.2583008e-003,1.2512207e-003,-3.0517578e-005,3.7231445e-003,8.0261230e-003,1.0467529e-002,1.3336182e-002,1.2878418e-002,1.0101318e-002,6.2561035e-003,1.1596680e-003,1.5258789e-004,1.8920898e-003,6.3781738e-003,1.2603760e-002,1.4221191e-002,1.5991211e-002,1.7639160e-002,1.9500732e-002,2.6336670e-002,3.0609131e-002,2.9693604e-002,2.6306152e-002,1.9378662e-002,1.4373779e-002,1.6113281e-002,1.5899658e-002,6.5002441e-003,-7.6904297e-003,-3.2043457e-002,-5.7128906e-002,-6.8695068e-002,-7.6721191e-002,-7.4401855e-002,-6.5979004e-002,-6.3385010e-002,-5.0445557e-002,-2.7557373e-002,6.1035156e-005,3.6712646e-002,6.5979004e-002,7.8857422e-002,8.0993652e-002,7.2052002e-002,5.3894043e-002,3.8726807e-002,1.7730713e-002,-9.0942383e-003,-3.0487061e-002,-5.4229736e-002,-6.3079834e-002,-5.7891846e-002,-4.2633057e-002,-2.0385742e-002,1.8615723e-003,2.1057129e-002,3.3599854e-002,4.9957275e-002,5.6762695e-002,6.6223145e-002,6.7504883e-002,5.5633545e-002,4.0588379e-002,1.0894775e-002,-1.5136719e-002,-3.7841797e-002,-4.9987793e-002,-4.9163818e-002,-3.6956787e-002,-2.0080566e-002,2.1667480e-003,2.7130127e-002,4.7271729e-002,7.2662354e-002,8.4808350e-002,9.2285156e-002,8.5601807e-002,6.5155029e-002,3.8360596e-002,5.1574707e-003,-2.1881104e-002,-4.6020508e-002,-5.4687500e-002,-5.9722900e-002,-5.2368164e-002,-4.3914795e-002,-3.3203125e-002,-1.5136719e-002,-2.2277832e-003,2.1270752e-002,3.0944824e-002,3.5552979e-002,2.7374268e-002,6.6223145e-003,-1.2786865e-002,-2.6763916e-002,-3.1799316e-002,-3.7597656e-002,-3.5003662e-002,-4.7607422e-002,-5.0048828e-002,-4.1992188e-002,-3.0944824e-002,-2.5939941e-003,1.4648438e-002,1.8707275e-002,1.4160156e-002,9.9182129e-003,3.7536621e-003,1.5594482e-002,2.4871826e-002,1.7181396e-002,1.4617920e-002,-1.2207031e-003,-7.2937012e-003,2.1667480e-003,9.5825195e-003,8.8500977e-003,2.5024414e-003,-1.4709473e-002,-3.1280518e-002,-2.6062012e-002,-2.5299072e-002,-2.3803711e-002,-2.4200439e-002,-3.9184570e-002,-4.4097900e-002,-2.9449463e-002,-1.0162354e-002,1.3854980e-002,3.3813477e-002,2.7099609e-002,1.8951416e-002,1.6632080e-002,9.6740723e-003,1.5899658e-002,1.6876221e-002,2.5939941e-003,-5.9814453e-003,-1.1505127e-002,-9.2163086e-003,9.7045898e-003,2.6519775e-002,3.3813477e-002,3.6346436e-002,3.0548096e-002,2.1331787e-002,2.6550293e-002,2.9327393e-002,3.4057617e-002,4.0374756e-002,3.1005859e-002,2.1789551e-002,5.4626465e-003,-1.1383057e-002,-1.8829346e-002,-2.3345947e-002,-1.8249512e-002,-1.1505127e-002,-1.3000488e-002,-1.6937256e-002,-2.4841309e-002,-3.2806396e-002,-2.5238037e-002,-1.7028809e-002,-7.1716309e-003,1.8005371e-003,-5.3710938e-003,-1.1077881e-002,-1.3641357e-002,-1.4312744e-002,-4.3945313e-003,6.5612793e-003,1.0253906e-002,1.5045166e-002,1.3305664e-002,8.3618164e-003,7.6599121e-003,1.4343262e-003,-2.5634766e-003,-7.6293945e-003,-1.3824463e-002,-1.9073486e-002,-2.6092529e-002,-3.1066895e-002,-3.4790039e-002,-3.4606934e-002,-3.0639648e-002,-2.5848389e-002,-2.4444580e-002,-2.3773193e-002,-2.4871826e-002,-2.5604248e-002,-1.9195557e-002,-1.3336182e-002,-7.6599121e-003,-3.0212402e-003,-3.6926270e-003,-4.7912598e-003,-3.4484863e-003,-5.3100586e-003,-6.3476563e-003,-5.7067871e-003,-3.9978027e-003,3.8452148e-003,1.6876221e-002,2.9205322e-002,3.1066895e-002,2.7343750e-002,1.7028809e-002,7.4157715e-003,1.4770508e-002,2.3468018e-002,3.2775879e-002,4.0344238e-002,2.8594971e-002,1.6784668e-002,9.2773438e-003,-3.3569336e-004,1.5563965e-003,2.2583008e-003,-3.6010742e-003,-5.1269531e-003,-7.5378418e-003,-7.4462891e-003,-3.4179688e-003,-3.6926270e-003,-9.2163086e-003,-1.5686035e-002,-1.9897461e-002,-2.1881104e-002,-1.7608643e-002,-1.2298584e-002,-1.2359619e-002,-1.0864258e-002,-1.4068604e-002,-1.9622803e-002,-2.3284912e-002,-3.0975342e-002,-3.6224365e-002,-3.7017822e-002,-2.8656006e-002,-1.4770508e-002,-1.6174316e-003,8.8500977e-003,4.6386719e-003,-3.6926270e-003,-7.7209473e-003,-1.2756348e-002,-5.0964355e-003,9.7656250e-004,-3.6315918e-003,-8.2092285e-003,-2.2155762e-002,-3.4851074e-002,-3.8085938e-002,-3.9794922e-002,-3.9428711e-002,-3.7475586e-002,-3.7750244e-002,-3.3569336e-002,-2.3956299e-002,-1.5808105e-002,-8.3312988e-003,-4.0588379e-003,-2.3498535e-003,1.0375977e-003,1.1627197e-002,2.2766113e-002,2.9968262e-002,3.3447266e-002,2.2399902e-002,1.0589600e-002,5.2795410e-003,2.8686523e-003,1.2390137e-002,2.2888184e-002,2.3040771e-002,2.1942139e-002,1.3153076e-002,1.7089844e-003,1.4343262e-003,-1.5563965e-003,-1.1901855e-003,1.1596680e-003,-2.7160645e-003,-1.1901855e-003,3.4484863e-003,8.4533691e-003,1.1413574e-002,1.0772705e-002,3.8452148e-003,-3.6315918e-003,-5.2185059e-003,-6.4392090e-003,-3.0212402e-003,7.9345703e-004,-7.0190430e-004,2.2277832e-003,7.9345703e-003,1.2664795e-002,1.6265869e-002,1.1627197e-002,-4.0588379e-003,-2.1667480e-002,-3.0792236e-002,-3.4027100e-002,-2.3315430e-002,-8.6975098e-003,-7.0800781e-003,-4.3640137e-003,-1.0803223e-002,-1.8737793e-002,-1.3488770e-002,-1.2939453e-002,-1.1169434e-002,-1.0955811e-002,-1.9653320e-002,-2.5177002e-002,-2.6611328e-002,-2.6824951e-002,-2.5695801e-002,-2.4261475e-002,-2.7557373e-002,-3.0181885e-002,-3.0792236e-002,-3.2714844e-002,-3.1707764e-002,-3.2073975e-002,-3.2623291e-002,-2.9510498e-002,-2.2430420e-002,-1.3977051e-002,-6.6833496e-003,-1.3732910e-003,-2.8991699e-003,-6.8969727e-003,-1.0894775e-002,-1.6967773e-002,-1.9897461e-002,-2.1484375e-002,-2.3376465e-002,-2.1362305e-002,-1.9042969e-002,-1.5380859e-002,-1.1962891e-002,-9.9182129e-003,-7.0495605e-003,-4.2419434e-003,2.7770996e-003,9.6130371e-003,1.6754150e-002,2.3651123e-002,2.6092529e-002,2.7465820e-002,2.5421143e-002,1.9927979e-002,1.2969971e-002,5.2490234e-003,3.6621094e-004,-2.3193359e-003,-9.7656250e-004,3.8452148e-003,4.5471191e-003,4.9438477e-003,2.3193359e-003,-2.9602051e-003,-4.9133301e-003,-8.3007813e-003,-8.4838867e-003,-8.3007813e-003,-9.9487305e-003,-7.9040527e-003,-7.3547363e-003,-5.9509277e-003,-5.5541992e-003,-5.3100586e-003,-4.2724609e-003,-2.3498535e-003,2.8381348e-003,7.0495605e-003,9.6130371e-003,9.0942383e-003,5.2185059e-003,2.4414063e-004,-1.2817383e-003,-2.7160645e-003,-2.2277832e-003,-2.1667480e-003,-7.9345703e-003,-1.4373779e-002,-2.4505615e-002,-3.5034180e-002,-4.0893555e-002,-4.5318604e-002,-4.6051025e-002,-4.3304443e-002,-4.1870117e-002,-3.7963867e-002,-3.3172607e-002,-2.8625488e-002,-2.1118164e-002,-1.5533447e-002,-1.0284424e-002,-6.4392090e-003,-3.9672852e-003,-2.9296875e-003,-3.6621094e-003,-5.5541992e-003,-9.7045898e-003,-1.2542725e-002,-1.4801025e-002,-1.4404297e-002,-1.0925293e-002,-6.3781738e-003,-3.3569336e-003,-9.7656250e-004,-1.5258789e-004,0.0000000e+000,4.6997070e-003,8.1176758e-003,1.1566162e-002,1.3122559e-002,7.8125000e-003,1.7700195e-003,-5.9509277e-003,-1.2023926e-002,-1.4953613e-002,-1.7517090e-002,-2.1453857e-002,-2.4139404e-002,-2.6336670e-002,-2.5939941e-002,-1.8920898e-002,-1.0162354e-002,3.3569336e-004,8.9721680e-003,1.1352539e-002,1.0406494e-002,9.5825195e-003,8.7280273e-003,1.5472412e-002,2.3559570e-002,2.7984619e-002,3.2653809e-002,2.6397705e-002,1.9897461e-002,1.5960693e-002,9.9182129e-003,9.2163086e-003,5.3100586e-003,-3.6315918e-003,-1.1383057e-002,-1.8493652e-002,-2.3681641e-002,-2.3834229e-002,-2.4902344e-002,-3.0487061e-002,-3.5278320e-002,-3.9093018e-002,-3.9428711e-002,-3.1311035e-002,-2.1667480e-002,-1.5045166e-002,-8.6059570e-003,-8.6975098e-003,-1.1383057e-002,-1.1810303e-002,-1.6479492e-002,-1.9165039e-002,-2.0324707e-002,-1.9378662e-002,-1.4526367e-002,-9.7961426e-003,-5.9814453e-003,-9.8876953e-003,-1.5075684e-002,-1.7578125e-002,-2.0965576e-002,-1.7211914e-002,-1.7547607e-002,-2.5756836e-002,-3.2226563e-002,-4.0649414e-002,-4.3884277e-002,-3.4301758e-002,-2.2735596e-002,-1.5563965e-002,-8.8195801e-003,-1.0192871e-002,-1.2542725e-002,-6.7749023e-003,-5.0659180e-003,-2.0141602e-003,-6.1035156e-005,-2.8686523e-003,-2.0446777e-003,2.3193359e-003,7.6293945e-003,9.0942383e-003,1.0253906e-002,6.0729980e-003,2.2583008e-003,4.7607422e-003,4.8522949e-003,3.3569336e-003,-2.1362305e-004,-8.6059570e-003,-1.5625000e-002,-1.5502930e-002,-1.4770508e-002,-1.4068604e-002,-1.2512207e-002,-1.5411377e-002,-1.5502930e-002,-1.1108398e-002,-7.5073242e-003,-4.6691895e-003,-2.7465820e-003,-4.1809082e-003,-3.9978027e-003,1.6174316e-003,6.1035156e-003,7.7819824e-003,8.6364746e-003,4.5166016e-003,1.6784668e-003,4.6997070e-003,5.2490234e-003,4.0283203e-003,1.5563965e-003,-3.9978027e-003,-8.0566406e-003,-6.1645508e-003,-6.4392090e-003,-1.1688232e-002,-1.7791748e-002,-2.7191162e-002,-3.1494141e-002,-2.3376465e-002,-1.3336182e-002,-8.2092285e-003,-5.4321289e-003,-1.3793945e-002,-2.1759033e-002,-1.6357422e-002,-1.2237549e-002,-4.5471191e-003,1.6479492e-003,-5.5236816e-003,-1.0375977e-002,-9.7961426e-003,-1.0131836e-002,-5.0964355e-003,-2.8686523e-003,-1.1199951e-002,-1.7303467e-002,-1.9378662e-002,-2.0660400e-002,-1.5350342e-002,-1.1901855e-002,-1.7364502e-002,-2.1575928e-002,-2.4414063e-002,-2.6519775e-002,-2.0812988e-002,-1.6113281e-002,-1.6448975e-002,-1.6174316e-002,-1.7089844e-002,-1.8096924e-002,-1.3427734e-002,-8.2092285e-003,-3.5400391e-003,2.5939941e-003,6.6528320e-003,9.2468262e-003,9.0332031e-003,6.7138672e-003,4.6691895e-003,4.0893555e-003,8.4838867e-003,1.3610840e-002,1.4831543e-002,1.4923096e-002,8.5449219e-003,2.6245117e-003,4.1809082e-003,5.0659180e-003,8.5144043e-003,1.0437012e-002,4.1198730e-003,-2.3193359e-003,-6.0424805e-003,-1.0955811e-002,-9.5825195e-003,-5.6762695e-003,-6.5307617e-003,-5.1269531e-003,-6.1035156e-003,-7.9040527e-003,-7.2937012e-003,-6.3476563e-003,-1.9226074e-003,4.9133301e-003,1.2329102e-002,1.7517090e-002,1.3824463e-002,4.7302246e-003,-7.3242188e-003,-1.9287109e-002,-1.9805908e-002,-1.7181396e-002,-1.2817383e-002,-5.4016113e-003,-8.0261230e-003,-1.0314941e-002,-1.1535645e-002,-1.6906738e-002,-1.6876221e-002,-2.0019531e-002,-2.5512695e-002,-2.8472900e-002,-3.0639648e-002,-2.9144287e-002,-2.5085449e-002,-1.7761230e-002,-1.1718750e-002,-4.3029785e-003,1.3732910e-003,3.6010742e-003,3.9672852e-003,1.8310547e-004,-4.4555664e-003,-1.0559082e-002,-1.4160156e-002,-1.6632080e-002,-1.8798828e-002,-1.6723633e-002,-1.4465332e-002,-8.6059570e-003,-2.1057129e-003,1.3427734e-003,7.0190430e-004,-3.5400391e-003,-6.2561035e-003,-8.5144043e-003,-3.6621094e-003,2.1667480e-003,4.9438477e-003,9.6740723e-003,8.5449219e-003,9.2773438e-003,1.2756348e-002,1.5350342e-002,1.7547607e-002,1.6448975e-002,1.1749268e-002,6.6223145e-003,4.5776367e-003,1.7089844e-003,-1.2512207e-003,-3.9367676e-003,-9.9487305e-003,-1.4495850e-002,-1.7211914e-002,-1.9104004e-002,-1.7364502e-002,-1.3305664e-002,-7.3242188e-003,9.1552734e-004,8.7890625e-003,1.3977051e-002,1.4770508e-002,1.1779785e-002,8.6669922e-003,3.7536621e-003,1.4648438e-003,-1.4343262e-003,-7.6293945e-003,-1.0314941e-002,-1.2115479e-002,-9.7045898e-003,-2.2583008e-003,4.5776367e-003,6.7749023e-003,6.1035156e-003,1.8005371e-003,-5.4626465e-003,-6.8664551e-003,-1.0040283e-002,-1.1260986e-002,-1.0650635e-002,-1.3427734e-002,-1.3122559e-002,-1.3641357e-002,-1.4129639e-002,-1.5106201e-002,-1.6906738e-002,-1.6784668e-002,-1.6845703e-002,-1.4923096e-002,-1.3458252e-002,-1.4007568e-002,-1.3488770e-002,-1.1932373e-002,-8.5449219e-003,-4.1503906e-003,-1.7395020e-003,-2.5634766e-003,-5.0964355e-003,-7.3242188e-003,-8.9111328e-003,-5.7678223e-003,-2.7465820e-003,-2.9907227e-003,-3.0212402e-003,-6.1950684e-003,-8.9416504e-003,-7.6904297e-003,-6.8359375e-003,-4.6081543e-003,-2.0446777e-003,-1.1596680e-003,4.5776367e-004,1.5258789e-003,2.2277832e-003,2.9602051e-003,4.6997070e-003,9.3994141e-003,1.4495850e-002,1.8096924e-002,2.0202637e-002,1.7761230e-002,1.4434814e-002,1.4923096e-002,1.5045166e-002,1.7608643e-002,1.9561768e-002,1.6082764e-002,1.3122559e-002,1.0772705e-002,9.0026855e-003,1.1444092e-002,1.2756348e-002,9.1857910e-003,4.5471191e-003,-2.8991699e-003,-1.0986328e-002,-1.2695313e-002,-1.2390137e-002,-8.8500977e-003,-1.9836426e-003,1.0986328e-003,3.5705566e-003,1.7089844e-003,-3.3264160e-003,-4.6997070e-003,-5.3405762e-003,-8.5449219e-004,4.7607422e-003,4.1198730e-003,3.9367676e-003,-1.2207031e-003,-4.7607422e-003,-1.5258789e-003,7.3242188e-004,3.3264160e-003,2.4414063e-003,-6.2255859e-003,-1.3763428e-002,-1.3031006e-002,-1.0742188e-002,-1.0681152e-003,8.3923340e-003,6.9580078e-003,4.2724609e-003,-1.7700195e-003,-9.7656250e-003,-8.1481934e-003,-7.1716309e-003,-5.2795410e-003,2.7465820e-004,7.6293945e-004,3.7231445e-003,6.3171387e-003,7.3547363e-003,8.6059570e-003,7.1411133e-003,4.2114258e-003,-4.2724609e-004,-3.5705566e-003,-5.3100586e-003,-3.1127930e-003,1.8920898e-003,6.5002441e-003,1.0986328e-002,9.2468262e-003,5.3100586e-003,2.7770996e-003,-3.9672852e-004,3.6621094e-003,8.2397461e-003,1.0925293e-002,1.4587402e-002,1.3000488e-002,1.0101318e-002,5.7373047e-003,-6.1035156e-004,-5.1574707e-003,-7.8430176e-003,-4.8828125e-003,3.6621094e-004,3.3264160e-003,5.1574707e-003,1.5563965e-003,-9.7656250e-004,5.9814453e-003,1.2268066e-002,1.9683838e-002,1.8310547e-002,-5.1879883e-004,-1.8188477e-002,-2.2460938e-002,-1.5594482e-002,1.5045166e-002,4.8034668e-002,5.1544189e-002,4.7241211e-002,2.0202637e-002,-1.2908936e-002,-1.3977051e-002,-1.6845703e-002,-8.9416504e-003,6.2866211e-003,-3.6621094e-004,2.5024414e-003,7.2631836e-003,7.3547363e-003,1.3031006e-002,1.0681152e-002,3.3874512e-003,-3.5705566e-003,-3.9062500e-003,-3.5095215e-003,-4.2114258e-003,-2.4108887e-003,-9.0942383e-003,-1.1993408e-002,-8.0871582e-003,-6.1035156e-003,-4.1809082e-003,-5.4016113e-003,-1.1291504e-002,-1.4617920e-002,-7.1105957e-003,-3.0517578e-005,5.0048828e-003,8.8806152e-003,3.7536621e-003,1.3427734e-003,8.7890625e-003,1.5777588e-002,2.2644043e-002,2.5604248e-002,1.4251709e-002,2.9296875e-003,-1.0986328e-003,-4.4860840e-003,2.7465820e-004,6.1645508e-003,4.8828125e-003,6.9274902e-003,8.3923340e-003,8.1176758e-003,1.0131836e-002,8.8195801e-003,6.3171387e-003,4.4860840e-003,9.0942383e-003,1.4434814e-002,1.7730713e-002,2.0904541e-002,1.6662598e-002,1.3031006e-002,1.3275146e-002,1.2390137e-002,1.3580322e-002,1.4251709e-002,1.2847900e-002,1.3366699e-002,1.4892578e-002,1.3610840e-002,8.5754395e-003,2.7465820e-003,-3.9672852e-004,0.0000000e+000,9.8266602e-003,1.9256592e-002,2.0080566e-002,1.9256592e-002,1.1901855e-002,5.0354004e-003,9.2468262e-003,1.0589600e-002,8.3312988e-003,5.8288574e-003,-2.8076172e-003,-6.9885254e-003,-3.6621094e-004,6.1035156e-003,8.8806152e-003,9.3994141e-003,0.0000000e+000,-9.1857910e-003,-7.5073242e-003,-7.9345703e-003,-6.7138672e-003,-5.1269531e-003,-1.1291504e-002,-1.1932373e-002,-3.3874512e-003,5.2490234e-003,1.2176514e-002,1.5167236e-002,6.1035156e-003,-2.7160645e-003,-1.8005371e-003,-1.4038086e-003,4.5471191e-003,1.0833740e-002,4.8828125e-003,3.0822754e-003,3.3874512e-003,3.7231445e-003,1.0467529e-002,1.2603760e-002,8.1176758e-003,4.1503906e-003,1.9836426e-003,-2.4414063e-004,1.9226074e-003,3.4179688e-003,7.0190430e-004,6.1035156e-005,1.4648438e-003,3.6315918e-003,7.7209473e-003,1.0345459e-002,9.3383789e-003,9.4299316e-003,1.1749268e-002,1.3275146e-002,1.4892578e-002,1.5655518e-002,1.3671875e-002,1.4038086e-002,1.7913818e-002,2.0996094e-002,2.2705078e-002,2.2827148e-002,1.8341064e-002,1.4404297e-002,1.5930176e-002,1.6662598e-002,1.7913818e-002,1.8402100e-002,1.3153076e-002,1.0528564e-002,1.2298584e-002,1.3702393e-002,1.4648438e-002,1.2481689e-002,3.4179688e-003,-5.2185059e-003,-8.3007813e-003,-8.6669922e-003,-2.3193359e-003,5.7983398e-003,7.2326660e-003,9.7961426e-003,9.2163086e-003,5.5541992e-003,5.4931641e-003,2.3803711e-003,6.4086914e-004,9.1552734e-004,3.2958984e-003,8.5754395e-003,1.2420654e-002,1.6113281e-002,1.4801025e-002,1.0955811e-002,7.9650879e-003,2.5939941e-003,4.2724609e-004,-1.9836426e-003,-3.7536621e-003,-3.1433105e-003,-2.8686523e-003,-1.0375977e-003,0.0000000e+000,-3.0517578e-004,-9.7656250e-004,-3.3874512e-003,-4.2419434e-003,-5.0048828e-003,-3.7231445e-003,-1.1291504e-003,1.4343262e-003,5.4931641e-003,7.1105957e-003,8.0261230e-003,6.8969727e-003,4.5471191e-003,4.5471191e-003,4.6081543e-003,6.3476563e-003,8.6975098e-003,8.4533691e-003,8.5144043e-003,8.1787109e-003,7.4462891e-003,8.5144043e-003,8.9111328e-003,1.0040283e-002,1.2268066e-002,1.5838623e-002,2.0172119e-002,2.3162842e-002,2.5421143e-002,2.3803711e-002,2.0874023e-002,1.8920898e-002,1.5045166e-002,1.2084961e-002,8.4533691e-003,2.9602051e-003,1.2207031e-003,4.6386719e-003,1.0711670e-002,1.8280029e-002,2.3590088e-002,2.0690918e-002,1.5380859e-002,1.3397217e-002,1.1047363e-002,1.5686035e-002,2.0660400e-002,1.8646240e-002,1.7242432e-002,1.1566162e-002,7.4157715e-003,1.1169434e-002,1.3641357e-002,1.3366699e-002,1.2359619e-002,6.8969727e-003,2.4108887e-003,5.0964355e-003,7.4157715e-003,1.1169434e-002,1.4892578e-002,1.2756348e-002,1.0864258e-002,1.0131836e-002,7.9345703e-003,6.8359375e-003,5.3100586e-003,1.5869141e-003,-7.6293945e-004,-1.4038086e-003,-1.5563965e-003,-2.0751953e-003,-2.1667480e-003,-3.2958984e-003,-3.4179688e-003,-3.0517578e-004,2.0751953e-003,4.0283203e-003,3.9978027e-003,6.1035156e-004,-2.9907227e-003,-2.8076172e-003,-8.5449219e-004,4.9438477e-003,1.2329102e-002,1.4465332e-002,1.5869141e-002,1.3397217e-002,9.0332031e-003,8.7585449e-003,7.8430176e-003,9.5214844e-003,1.1932373e-002,1.0498047e-002,9.8571777e-003,8.0261230e-003,6.7443848e-003,9.3078613e-003,1.1627197e-002,1.3549805e-002,1.4373779e-002,1.1535645e-002,8.3923340e-003,7.7819824e-003,5.9509277e-003,7.2937012e-003,8.2702637e-003,5.8898926e-003,5.9204102e-003,7.5378418e-003,1.1016846e-002,1.7425537e-002,2.3284912e-002,2.5085449e-002,2.5421143e-002,2.3468018e-002,1.9378662e-002,1.7425537e-002,1.3824463e-002,9.4909668e-003,6.9580078e-003,3.7231445e-003,2.3803711e-003,1.6174316e-003,-1.8310547e-004,-2.0446777e-003,-2.8381348e-003,4.8828125e-004,5.0964355e-003,1.2512207e-002,1.7791748e-002,1.6693115e-002,1.3610840e-002,9.2773438e-003,5.6457520e-003,9.0026855e-003,1.3214111e-002,1.3793945e-002,1.4648438e-002,7.9956055e-003,1.3732910e-003,-2.7465820e-004,-2.2583008e-003,8.5449219e-004,4.2114258e-003,3.4484863e-003,3.2348633e-003,1.4343262e-003,-2.0141602e-003,-2.0141602e-003,-2.0751953e-003,-2.7465820e-004,3.9672852e-003,8.0566406e-003,1.3214111e-002,1.5777588e-002,1.6754150e-002,1.5716553e-002,1.2786865e-002,1.1810303e-002,1.2084961e-002,1.2084961e-002,1.2908936e-002,1.0864258e-002,1.0253906e-002,1.0314941e-002,1.0955811e-002,1.4648438e-002,1.7547607e-002,1.8035889e-002,1.7608643e-002,1.4739990e-002,1.1260986e-002,1.0437012e-002,9.9487305e-003,1.0498047e-002,1.2329102e-002,1.1169434e-002,1.1596680e-002,1.3702393e-002,1.6601563e-002,2.2430420e-002,2.6763916e-002,2.7404785e-002,2.5177002e-002,2.0477295e-002,1.4221191e-002,1.2939453e-002,1.2298584e-002,1.2268066e-002,1.3732910e-002,1.0772705e-002,9.7656250e-003,1.0406494e-002,1.1718750e-002,1.5747070e-002,1.9134521e-002,2.0477295e-002,2.1667480e-002,2.2796631e-002,2.2949219e-002,2.3956299e-002,2.2766113e-002,1.7883301e-002,1.2359619e-002,7.3852539e-003,5.0659180e-003,7.0800781e-003,1.1047363e-002,1.2298584e-002,1.2878418e-002,1.0406494e-002,5.7678223e-003,5.1269531e-003,3.3264160e-003,4.6081543e-003,6.1950684e-003,5.8593750e-003,7.5988770e-003,7.2631836e-003,7.6904297e-003,8.0261230e-003,8.5449219e-003,9.7656250e-003,1.0650635e-002,1.1016846e-002,1.0192871e-002,7.9650879e-003,5.5847168e-003,4.5166016e-003,4.2419434e-003,6.2866211e-003,9.0332031e-003,9.8876953e-003,1.1230469e-002,1.1566162e-002,1.1993408e-002,1.4495850e-002,1.6754150e-002,1.8035889e-002,1.8676758e-002,1.6601563e-002,1.3702393e-002,1.1322021e-002,9.0026855e-003,8.6364746e-003,8.8195801e-003,8.9111328e-003,8.3923340e-003,6.2255859e-003,4.0588379e-003,3.7841797e-003,4.8828125e-003,9.2468262e-003,1.3854980e-002,1.5808105e-002,1.6479492e-002,1.3153076e-002,9.9182129e-003,1.1932373e-002,1.4770508e-002,1.8707275e-002,2.2094727e-002,1.7181396e-002,1.1749268e-002,7.2326660e-003,1.9836426e-003,4.3640137e-003,6.8359375e-003,7.4157715e-003,9.1552734e-003,6.2255859e-003,5.9509277e-003,8.4228516e-003,8.4228516e-003,9.0026855e-003,8.9416504e-003,7.3242188e-003,5.6457520e-003,4.9438477e-003,4.5471191e-003,3.4484863e-003,3.7231445e-003,4.5471191e-003,6.5307617e-003,1.0314941e-002,1.4038086e-002,1.6418457e-002,1.8218994e-002,2.0629883e-002,2.2033691e-002,2.4414063e-002,2.4353027e-002,2.0599365e-002,1.6784668e-002,1.2542725e-002,1.0894775e-002,1.2969971e-002,1.6296387e-002,1.6235352e-002,1.5960693e-002,1.2145996e-002,7.8125000e-003,8.5754395e-003,8.6975098e-003,1.0620117e-002,1.2237549e-002,1.1413574e-002,1.2268066e-002,1.5106201e-002,1.7974854e-002,2.1057129e-002,2.2766113e-002,2.0019531e-002,1.6662598e-002,1.4373779e-002,1.2329102e-002,1.4129639e-002,1.6418457e-002,1.4953613e-002,1.3763428e-002,9.7351074e-003,5.3405762e-003,5.2490234e-003,5.1269531e-003,8.3312988e-003,1.2329102e-002,1.3397217e-002,1.3732910e-002,1.1901855e-002,1.1505127e-002,1.3519287e-002,1.5899658e-002,1.8951416e-002,2.1911621e-002,2.0477295e-002,1.7852783e-002,1.3488770e-002,8.7890625e-003,7.5988770e-003,6.8664551e-003,6.4697266e-003,7.2631836e-003,5.1269531e-003,3.5095215e-003,2.3498535e-003,9.1552734e-004,3.1433105e-003,5.7983398e-003,9.5214844e-003,1.2817383e-002,1.3122559e-002,1.1596680e-002,8.8806152e-003,5.3405762e-003,4.2724609e-003,4.8828125e-003,6.0119629e-003,7.8735352e-003,6.6528320e-003,5.0964355e-003,3.4790039e-003,1.8920898e-003,3.9978027e-003,7.2326660e-003,1.1779785e-002,1.6723633e-002,1.8676758e-002,1.9683838e-002,1.9195557e-002,1.6784668e-002,1.5930176e-002,1.4251709e-002,1.3061523e-002,1.3549805e-002,1.2908936e-002,1.3488770e-002,1.3732910e-002,1.3977051e-002,1.4251709e-002,1.3671875e-002,1.2969971e-002,1.0986328e-002,9.6130371e-003,6.7749023e-003,6.4697266e-003,7.7819824e-003,8.9111328e-003,1.2359619e-002,1.4831543e-002,1.6815186e-002,1.7150879e-002,1.5686035e-002,1.4953613e-002,1.3916016e-002,1.5808105e-002,1.7791748e-002,1.8188477e-002,1.7456055e-002,1.2176514e-002,6.6223145e-003,3.5705566e-003,1.4038086e-003,4.1503906e-003,8.6059570e-003,1.0131836e-002,1.2573242e-002,1.1291504e-002,7.9345703e-003,7.9345703e-003,5.9509277e-003,6.2866211e-003,7.6293945e-003,8.6669922e-003,1.1016846e-002,1.1840820e-002,1.1657715e-002,9.4299316e-003,6.1950684e-003,4.4555664e-003,2.8076172e-003,4.1503906e-003,6.1950684e-003,6.9580078e-003,7.8125000e-003,6.5917969e-003,5.5541992e-003,6.8969727e-003,7.7209473e-003,9.3078613e-003,1.0284424e-002,9.3688965e-003,8.5754395e-003,8.3007813e-003,7.9345703e-003,8.3312988e-003,8.8195801e-003,7.7819824e-003,6.6528320e-003,5.7067871e-003,4.4555664e-003,4.9743652e-003,4.9133301e-003,5.6457520e-003,7.7209473e-003,8.8806152e-003,1.0681152e-002,1.2603760e-002,1.3549805e-002,1.3885498e-002,1.3885498e-002,1.3336182e-002,1.2756348e-002,1.2451172e-002,1.2115479e-002,1.1962891e-002,1.1627197e-002,1.0833740e-002,9.7351074e-003,8.4533691e-003,7.5073242e-003,7.9345703e-003,9.2773438e-003,1.1138916e-002,1.3366699e-002,1.3641357e-002,1.3366699e-002,1.2145996e-002,1.0894775e-002,1.1474609e-002,1.2664795e-002,1.5380859e-002,1.8646240e-002,2.0172119e-002,2.0385742e-002,1.7578125e-002,1.1840820e-002,5.7067871e-003,-2.3193359e-003,-7.5073242e-003,-1.0589600e-002,-1.2084961e-002,-1.0437012e-002,-9.9182129e-003,-7.3242188e-003,-3.8146973e-003,3.9672852e-004,6.5307617e-003,1.0986328e-002,1.3061523e-002,1.2145996e-002,9.7961426e-003,6.8664551e-003,7.8125000e-003,9.5825195e-003,7.8735352e-003,9.1857910e-003,5.9814453e-003,0.0000000e+000,-2.8076172e-003,-6.4392090e-003,-5.8288574e-003,-4.3640137e-003,-3.6926270e-003,-1.4038086e-003,-1.5258789e-004,2.2888184e-003,6.6528320e-003,1.1016846e-002,1.5289307e-002,1.9287109e-002,2.0690918e-002,2.0202637e-002,1.7333984e-002,1.2054443e-002,6.1035156e-003,-2.4414063e-004,-3.6926270e-003,-4.8217773e-003,-4.2724609e-003,-2.0141602e-003,-1.5563965e-003,-7.6293945e-004,3.0517578e-005,5.7983398e-004,3.8146973e-003,6.2255859e-003,8.0871582e-003,9.8571777e-003,9.7351074e-003,1.0406494e-002,1.0925293e-002,1.1230469e-002,1.0681152e-002,1.0131836e-002,8.4228516e-003,6.4086914e-003,5.4016113e-003,3.2958984e-003,1.1291504e-003,-1.4953613e-003,-3.4484863e-003,-4.2114258e-003,-2.5024414e-003,5.7983398e-004,3.7536621e-003,8.7890625e-003,1.1993408e-002,1.5106201e-002,1.7211914e-002,1.7761230e-002,1.8005371e-002,1.7181396e-002,1.5319824e-002,1.2145996e-002,7.5988770e-003,1.3732910e-003,-4.5471191e-003,-1.0009766e-002,-1.2451172e-002,-1.2268066e-002,-1.0192871e-002,-6.1340332e-003,-3.0212402e-003,1.0375977e-003,6.0424805e-003,1.0223389e-002,1.5045166e-002,1.7761230e-002,1.7669678e-002,1.6326904e-002,1.3580322e-002,1.0467529e-002,6.8969727e-003,3.4179688e-003,-2.3803711e-003,-6.6833496e-003,-8.4838867e-003,-7.7819824e-003,-2.3803711e-003,4.0588379e-003,8.9111328e-003,1.2115479e-002,1.3305664e-002,1.1688232e-002,1.1199951e-002,8.3312988e-003,4.1809082e-003,1.0986328e-003,-2.5024414e-003,-2.4414063e-003,-6.4086914e-004,3.8757324e-003,6.6833496e-003,9.0332031e-003,1.0711670e-002,1.0223389e-002,1.2451172e-002,1.0772705e-002,7.8125000e-003,2.5634766e-003,-3.6926270e-003,-8.6975098e-003,-1.0131836e-002,-6.1035156e-003,-3.6621094e-004,9.4909668e-003,1.6082764e-002,2.1514893e-002,2.1484375e-002,1.5045166e-002,6.0729980e-003,-6.6833496e-003,-1.2695313e-002,-1.6174316e-002,-1.3610840e-002,-3.8757324e-003,3.9062500e-003,1.4312744e-002,1.8859863e-002,1.7120361e-002,1.3061523e-002,2.7465820e-004,-9.9487305e-003,-1.8859863e-002,-1.9165039e-002,-1.0253906e-002,1.6174316e-003,1.9409180e-002,2.4749756e-002,2.4841309e-002,1.4709473e-002,-5.9204102e-003,-1.8707275e-002,-3.2379150e-002,-3.1127930e-002,-1.7822266e-002,-2.2583008e-003,1.9500732e-002,2.5146484e-002,2.2338867e-002,7.6904297e-003,-1.7211914e-002,-2.6916504e-002,-3.3813477e-002,-2.3162842e-002,-1.2512207e-003,8.9721680e-003,2.3345947e-002,1.8981934e-002,5.7983398e-003,-4.3640137e-003,-2.2125244e-002,-2.4200439e-002,-2.0294189e-002,-9.7045898e-003,8.7585449e-003,1.5563965e-002,1.9317627e-002,7.9040527e-003,-1.0192871e-002,-1.6937256e-002,-2.2979736e-002,-9.1552734e-003,1.0498047e-002,1.9134521e-002,2.7618408e-002,1.5075684e-002,-3.1738281e-003,-1.3244629e-002,-2.2674561e-002,-1.1260986e-002,5.4321289e-003,1.4984131e-002,2.4597168e-002,1.3793945e-002,-2.3498535e-003,-1.1596680e-002,-1.9714355e-002,-5.2185059e-003,1.3122559e-002,2.2338867e-002,2.8533936e-002,1.0925293e-002,-1.0589600e-002,-1.9012451e-002,-2.4749756e-002,-6.7749023e-003,1.6021729e-002,2.3162842e-002,2.8961182e-002,1.4007568e-002,-6.1035156e-003,-1.0375977e-002,-1.6174316e-002,-7.1411133e-003,5.0354004e-003,2.8076172e-003,1.5258789e-003,-1.0925293e-002,-2.3895264e-002,-2.1392822e-002,-1.4923096e-002,2.8076172e-003,2.1362305e-002,2.0965576e-002,1.4892578e-002,-2.4414063e-003,-2.2827148e-002,-2.1057129e-002,-1.3946533e-002,3.0212402e-003,2.4200439e-002,2.0019531e-002,1.3580322e-002,3.9672852e-004,-1.6815186e-002,-1.2237549e-002,-8.3312988e-003,-2.6855469e-003,5.4016113e-003,-1.1596680e-003,-5.8898926e-003,-6.7749023e-003,-9.0026855e-003,-1.2207031e-003,4.6081543e-003,4.1503906e-003,2.0446777e-003,-4.6081543e-003,-1.1169434e-002,-1.1108398e-002,-9.9182129e-003,-6.1950684e-003,-1.0986328e-003,-2.8076172e-003,-4.2724609e-003,-5.7678223e-003,-7.6293945e-003,-2.4108887e-003,2.2888184e-003,4.9438477e-003,5.0659180e-003,-2.8686523e-003,-1.1993408e-002,-1.6723633e-002,-1.8157959e-002,-1.0925293e-002,-5.4931641e-004,4.9438477e-003,9.8571777e-003,6.5002441e-003,-8.5449219e-004,-3.8146973e-003,-8.2397461e-003,-4.6081543e-003,1.2512207e-003,4.9743652e-003,1.0009766e-002,6.6528320e-003,1.2512207e-003,-3.9978027e-003,-1.0681152e-002,-9.5825195e-003,-7.5683594e-003,-5.6152344e-003,-1.7089844e-003,-3.4790039e-003,-4.5776367e-003,-4.4555664e-003,-5.7373047e-003,-3.5705566e-003,-2.5939941e-003,-2.9907227e-003,-2.8686523e-003,-3.7231445e-003,-3.6621094e-003,-3.1738281e-003,-2.6855469e-003,-3.7231445e-003,-4.6691895e-003,-4.5471191e-003,-2.4719238e-003,4.2724609e-004,2.6245117e-003,2.3193359e-003,9.1552734e-005,-3.2958984e-003,-7.5683594e-003,-8.9721680e-003,-9.1247559e-003,-7.7209473e-003,-4.7912598e-003,-3.2958984e-003,-1.0681152e-003,-1.2207031e-003,-2.3498535e-003,-3.6315918e-003,-5.6762695e-003,-5.9204102e-003,-4.9438477e-003,-3.2348633e-003,-6.4086914e-004,-7.9345703e-004,-2.8381348e-003,-7.4462891e-003,-1.4312744e-002,-1.8157959e-002,-2.0385742e-002,-1.6723633e-002,-9.2773438e-003,-3.3264160e-003,2.2583008e-003,9.4604492e-004,-2.8076172e-003,-5.4016113e-003,-9.3688965e-003,-7.2021484e-003,-4.5776367e-003,-3.7841797e-003,-2.0141602e-003,-4.6997070e-003,-6.8359375e-003,-6.6528320e-003,-7.5683594e-003,-7.0800781e-003,-6.1035156e-003,-7.0190430e-003,-8.0566406e-003,-8.0871582e-003,-8.3007813e-003,-6.9274902e-003,-4.1198730e-003,-1.2512207e-003,1.8615723e-003,2.7160645e-003,2.3498535e-003,-1.8615723e-003,-5.4626465e-003,-7.4157715e-003,-8.9721680e-003,-6.4392090e-003,-2.8686523e-003,-1.7700195e-003,-7.9345703e-004,-3.3569336e-003,-6.5917969e-003,-6.8664551e-003,-8.8500977e-003,-8.5449219e-003,-8.6364746e-003,-1.0559082e-002,-1.0345459e-002,-9.1552734e-003,-6.2561035e-003,-2.8381348e-003,-3.3569336e-004,-1.5563965e-003,-4.6081543e-003,-7.6293945e-003,-1.0681152e-002,-8.2702637e-003,-4.1503906e-003,-3.0517578e-005,4.0283203e-003,1.3122559e-003,-3.3569336e-003,-7.2021484e-003,-1.1688232e-002,-8.6975098e-003,-4.1809082e-003,-1.0681152e-003,3.0822754e-003,1.8310547e-004,-2.7465820e-003,-3.7536621e-003,-5.0659180e-003,-2.5024414e-003,-5.4931641e-004,-2.0141602e-003,-3.6315918e-003,-7.5988770e-003,-1.1657715e-002,-1.2023926e-002,-1.2176514e-002,-1.1169434e-002,-9.5825195e-003,-9.2773438e-003,-7.9956055e-003,-7.6293945e-003,-8.1176758e-003,-7.3852539e-003,-6.8664551e-003,-5.3100586e-003,-3.3874512e-003,-3.7536621e-003,-2.8991699e-003,-4.7912598e-003,-7.4768066e-003,-7.6599121e-003,-7.4768066e-003,-5.7067871e-003,-2.8991699e-003,-3.1738281e-003,-3.7231445e-003,-5.1574707e-003,-6.7749023e-003,-4.8828125e-003,-3.1127930e-003,-7.6293945e-004,1.0375977e-003,0.0000000e+000,-1.8310547e-003,-3.8452148e-003,-6.6833496e-003,-8.0566406e-003,-8.8195801e-003,-9.3688965e-003,-7.7514648e-003,-5.6152344e-003,-2.5024414e-003,1.5258789e-004,1.0986328e-003,7.0190430e-004,-1.2817383e-003,-1.8615723e-003,-2.5024414e-003,-1.1901855e-003,6.4086914e-004,7.0190430e-004,2.4414063e-004,-3.5095215e-003,-6.8054199e-003,-8.1481934e-003,-8.9111328e-003,-6.9580078e-003,-4.6386719e-003,-4.3640137e-003,-4.1809082e-003,-6.4697266e-003,-9.0332031e-003,-8.2702637e-003,-7.9650879e-003,-5.4626465e-003,-2.0751953e-003,-1.1901855e-003,-3.0517578e-004,-2.1362305e-003,-5.1879883e-003,-7.5683594e-003,-1.0101318e-002,-1.1199951e-002,-1.0192871e-002,-8.7280273e-003,-6.5307617e-003,-5.3100586e-003,-4.3334961e-003,-4.6997070e-003,-6.4697266e-003,-7.4157715e-003,-8.8500977e-003,-8.3312988e-003,-6.8969727e-003,-5.8898926e-003,-4.2114258e-003,-5.1574707e-003,-6.1340332e-003,-6.6833496e-003,-7.9956055e-003,-7.9956055e-003,-9.0637207e-003,-1.1718750e-002,-1.4862061e-002,-1.6693115e-002,-1.7608643e-002,-1.5533447e-002,-1.2481689e-002,-1.1016846e-002,-9.2773438e-003,-9.3994141e-003,-9.6435547e-003,-7.8125000e-003,-6.7749023e-003,-6.7749023e-003,-7.7209473e-003,-9.8266602e-003,-1.0986328e-002,-1.0284424e-002,-8.8195801e-003,-7.4768066e-003,-5.7983398e-003,-6.3171387e-003,-7.5073242e-003,-6.5917969e-003,-6.6528320e-003,-5.8288574e-003,-5.0048828e-003,-4.9133301e-003,-4.3029785e-003,-2.4108887e-003,-2.7465820e-004,1.2207031e-004,-4.5776367e-004,-3.9672852e-003,-7.6904297e-003,-9.4909668e-003,-1.0864258e-002,-1.0559082e-002,-9.6130371e-003,-1.1779785e-002,-1.2573242e-002,-1.3061523e-002,-1.3671875e-002,-1.1413574e-002,-9.1247559e-003,-7.4768066e-003,-6.1645508e-003,-6.3171387e-003,-7.0495605e-003,-8.0566406e-003,-9.0026855e-003,-8.5754395e-003,-7.3242188e-003,-5.6152344e-003,-3.4790039e-003,-4.1503906e-003,-5.3405762e-003,-7.1411133e-003,-9.9182129e-003,-9.4604492e-003,-8.5144043e-003,-6.4392090e-003,-3.4484863e-003,-2.6855469e-003,-2.1057129e-003,-2.3498535e-003,-4.1198730e-003,-5.5236816e-003,-7.5988770e-003,-8.3312988e-003,-8.5449219e-003,-8.2702637e-003,-6.6528320e-003,-6.5002441e-003,-5.7678223e-003,-6.1950684e-003,-6.9580078e-003,-6.2866211e-003,-7.2937012e-003,-7.0800781e-003,-6.9274902e-003,-6.4697266e-003,-5.6457520e-003,-5.4321289e-003,-6.4392090e-003,-8.8500977e-003,-1.1291504e-002,-1.2451172e-002,-1.2481689e-002,-1.0192871e-002,-7.4157715e-003,-7.6599121e-003,-7.8735352e-003,-1.1108398e-002,-1.3732910e-002,-1.1535645e-002,-9.4909668e-003,-6.2255859e-003,-4.3640137e-003,-5.7983398e-003,-7.8430176e-003,-1.0711670e-002,-1.5228271e-002,-1.6479492e-002,-1.6357422e-002,-1.5380859e-002,-1.3092041e-002,-1.3671875e-002,-1.4129639e-002,-1.5380859e-002,-1.7211914e-002,-1.5808105e-002,-1.3824463e-002,-1.0223389e-002,-6.1645508e-003,-5.5236816e-003,-4.6997070e-003,-4.6386719e-003,-5.5541992e-003,-4.9743652e-003,-5.2795410e-003,-5.8898926e-003,-6.3171387e-003,-7.6293945e-003,-8.8195801e-003,-9.9182129e-003,-1.1596680e-002,-1.2634277e-002,-1.3671875e-002,-1.3488770e-002,-1.2695313e-002,-1.2145996e-002,-1.1688232e-002,-1.2573242e-002,-1.3214111e-002,-1.2542725e-002,-1.1413574e-002,-9.7961426e-003,-8.5754395e-003,-9.0942383e-003,-1.0253906e-002,-1.0131836e-002,-9.9792480e-003,-1.0437012e-002,-1.0681152e-002,-1.1932373e-002,-1.2603760e-002,-1.0681152e-002,-8.0261230e-003,-5.5847168e-003,-3.4484863e-003,-5.4016113e-003,-6.5002441e-003,-4.9743652e-003,-4.4250488e-003,-2.3193359e-003,-7.0190430e-004,-4.1198730e-003,-7.9040527e-003,-1.0528564e-002,-1.2603760e-002,-1.0437012e-002,-7.3242188e-003,-6.8664551e-003,-5.7678223e-003,-5.8288574e-003,-7.2021484e-003,-5.7067871e-003,-5.7373047e-003,-7.0495605e-003,-8.1481934e-003,-9.3688965e-003,-9.3994141e-003,-7.5073242e-003,-4.5166016e-003,-4.0588379e-003,-3.7536621e-003,-5.3405762e-003,-7.8430176e-003,-8.6364746e-003,-9.9182129e-003,-1.0467529e-002,-1.0192871e-002,-8.3923340e-003,-5.7983398e-003,-3.9367676e-003,-3.1127930e-003,-5.4931641e-003,-8.8195801e-003,-1.0437012e-002,-1.1688232e-002,-9.3994141e-003,-6.7443848e-003,-6.0729980e-003,-4.6386719e-003,-6.2866211e-003,-8.7280273e-003,-8.1481934e-003,-9.0332031e-003,-9.3994141e-003,-8.6669922e-003,-9.1247559e-003,-8.6059570e-003,-8.2397461e-003,-8.0261230e-003,-7.6293945e-003,-8.2092285e-003,-7.8430176e-003,-5.7373047e-003,-3.9062500e-003,-2.6855469e-003,-3.2348633e-003,-4.2114258e-003,-6.2561035e-003,-8.3618164e-003,-8.8500977e-003,-9.1247559e-003,-9.2163086e-003,-7.1105957e-003,-6.0119629e-003,-4.3334961e-003,-3.2958984e-003,-3.8452148e-003,-4.5166016e-003,-6.1035156e-003,-6.4697266e-003,-7.3242188e-003,-6.7749023e-003,-5.3710938e-003,-5.7983398e-003,-5.6457520e-003,-6.3476563e-003,-6.6223145e-003,-6.1645508e-003,-5.7373047e-003,-5.4016113e-003,-5.2795410e-003,-5.0964355e-003,-5.0048828e-003,-4.4555664e-003,-4.6997070e-003,-5.7983398e-003,-6.7749023e-003,-8.3007813e-003,-9.1247559e-003,-8.5449219e-003,-7.5683594e-003,-6.1035156e-003,-4.6691895e-003,-4.9743652e-003,-5.0048828e-003,-5.3710938e-003,-6.3171387e-003,-5.9814453e-003,-5.1269531e-003,-5.2795410e-003,-5.3100586e-003,-5.5847168e-003,-5.5847168e-003,-5.2490234e-003,-4.6997070e-003,-4.8217773e-003,-5.3100586e-003,-5.6762695e-003,-7.0495605e-003,-5.1574707e-003,-4.2419434e-003,-4.5166016e-003,-4.6691895e-003,-6.0424805e-003,-7.3852539e-003,-6.5917969e-003,-5.2490234e-003,-3.9062500e-003,-2.6245117e-003,-3.2348633e-003,-3.5400391e-003,-3.1433105e-003,-3.0517578e-003,-2.7160645e-003,-3.5095215e-003,-6.4086914e-003,-8.4228516e-003,-9.6740723e-003,-9.0942383e-003,-8.5754395e-003,-4.1198730e-003,-4.9438477e-003,-4.8828125e-003,-2.7160645e-003,-4.1809082e-003,-4.3029785e-003,-9.5825195e-003,-6.8359375e-003,-7.2326660e-003,-6.9885254e-003,-5.1574707e-003,-3.9978027e-003,-2.5024414e-003,-1.5563965e-003,-8.5449219e-004,0.0000000e+000,-3.9672852e-004,-2.4108887e-003,-5.5847168e-003,-9.0332031e-003,-1.1444092e-002,-9.6435547e-003,-6.7138672e-003,-4.1809082e-003,-1.8920898e-003,-3.1433105e-003,-6.4697266e-003,-8.5754395e-003,-1.2054443e-002,-1.3214111e-002,-1.2725830e-002,-1.1535645e-002,-7.2326660e-003,-5.2795410e-003,-1.0375977e-003,7.9345703e-004,3.0517578e-004,-4.2724609e-004,-2.6855469e-003,-2.8076172e-003,-3.9672852e-003,-6.3476563e-003,-7.8430176e-003,-1.0253906e-002,-1.0711670e-002,-8.0566406e-003,-5.3405762e-003,-4.1198730e-003,-3.6315918e-003,-3.6010742e-003,-3.3569336e-003,1.8310547e-004,2.2583008e-003,2.1057129e-003,1.0375977e-003,-3.3569336e-003,-7.0800781e-003,-6.5917969e-003,-5.6762695e-003,-4.9438477e-003,-3.6010742e-003,-6.2255859e-003,-7.9345703e-003,-5.6457520e-003,-4.9438477e-003,-3.6010742e-003,-3.4484863e-003,-7.6599121e-003,-1.1291504e-002,-1.1444092e-002,-1.0559082e-002,-7.4157715e-003,-3.6315918e-003,-5.0964355e-003,-5.9509277e-003,-6.1645508e-003,-6.5612793e-003,-4.1198730e-003,-2.7160645e-003,-4.2724609e-003,-5.6762695e-003,-7.3852539e-003,-9.2773438e-003,-8.1481934e-003,-6.9580078e-003,-6.1950684e-003,-4.2724609e-003,-4.2114258e-003,-5.0659180e-003,-6.1645508e-003,-8.4228516e-003,-9.5825195e-003,-9.4299316e-003,-5.1879883e-003,-4.5776367e-004,7.0190430e-004,7.3242188e-004,-3.2348633e-003,-7.9956055e-003,-8.8806152e-003,-9.5214844e-003,-7.6293945e-003,-5.6457520e-003,-7.6904297e-003,-9.0942383e-003,-9.6740723e-003,-9.7351074e-003,-6.8664551e-003,-4.6691895e-003,-5.2490234e-003,-4.7912598e-003,-5.1879883e-003,-6.6528320e-003,-7.4157715e-003,-9.3688965e-003,-1.1779785e-002,-1.3153076e-002,-1.3244629e-002,-1.1077881e-002,-8.3312988e-003,-5.1879883e-003,-4.4555664e-003,-5.2490234e-003,-5.0964355e-003,-6.4086914e-003,-5.9204102e-003,-6.6223145e-003,-8.2092285e-003,-8.7280273e-003,-9.0637207e-003,-7.6904297e-003,-5.7373047e-003,-3.8452148e-003,-4.4555664e-003,-5.7678223e-003,-7.9650879e-003,-9.8266602e-003,-8.5754395e-003,-7.6293945e-003,-6.6223145e-003,-4.8828125e-003,-5.4931641e-003,-5.8898926e-003,-5.9204102e-003,-6.9274902e-003,-6.5002441e-003,-6.3476563e-003,-8.4533691e-003,-8.2702637e-003,-8.5144043e-003,-8.8500977e-003,-7.9650879e-003,-7.6293945e-003,-7.7209473e-003,-7.9040527e-003,-8.0566406e-003,-7.7819824e-003,-6.3781738e-003,-5.0354004e-003,-4.6691895e-003,-3.8757324e-003,-4.1503906e-003,-4.1503906e-003,-2.8686523e-003,-2.4719238e-003,-3.6315918e-003,-5.5847168e-003,-8.0566406e-003,-9.8266602e-003,-7.7819824e-003,-4.7912598e-003,-2.5634766e-003,-1.2207031e-004,-2.2888184e-003,-5.1269531e-003,-6.0424805e-003,-7.0800781e-003,-5.2490234e-003,-3.2348633e-003,-4.0283203e-003,-4.0893555e-003,-4.9438477e-003,-6.0424805e-003,-6.6223145e-003,-7.6599121e-003,-8.4838867e-003,-8.6669922e-003,-7.4157715e-003,-5.9814453e-003,-4.4250488e-003,-4.1809082e-003,-5.4931641e-003,-6.7749023e-003,-5.4626465e-003,-3.4790039e-003,-8.8500977e-004,8.8500977e-004,-2.2277832e-003,-4.7912598e-003,-6.5612793e-003,-8.0566406e-003,-6.7138672e-003,-4.2419434e-003,-3.4179688e-003,-2.3498535e-003,-1.8310547e-003,-2.3193359e-003,2.7465820e-004,7.9345703e-004,4.2724609e-004,-7.9345703e-004,-1.0375977e-003,-1.2817383e-003,-1.0681152e-003,-9.1552734e-004,-3.1127930e-003,-4.3945313e-003,-4.2419434e-003,-3.0822754e-003,-1.2512207e-003,6.1035156e-004,-1.5258789e-003,-4.2114258e-003,-5.8593750e-003,-7.8125000e-003,-5.3710938e-003,-2.8076172e-003,-2.7770996e-003,-2.3803711e-003,-3.4179688e-003,-4.8828125e-003,-2.8381348e-003,-1.1596680e-003,-6.4086914e-004,2.7465820e-004,-1.0070801e-003,-2.2888184e-003,-2.6550293e-003,-3.6926270e-003,-4.7912598e-003,-5.1574707e-003,-5.9509277e-003,-5.6152344e-003,-4.0283203e-003,-2.4719238e-003,-1.8920898e-003,-2.1972656e-003,-3.4484863e-003,-5.5541992e-003,-5.9814453e-003,-6.9885254e-003,-7.1105957e-003,-6.4086914e-003,-7.2937012e-003,-7.4157715e-003,-7.7819824e-003,-8.5754395e-003,-7.3547363e-003,-6.0424805e-003,-3.9367676e-003,-3.0822754e-003,-3.0517578e-003,-3.0212402e-003,-4.3640137e-003,-5.3710938e-003,-4.6386719e-003,-3.3569336e-003,-3.1433105e-003,-2.8991699e-003,-4.3945313e-003,-5.7678223e-003,-5.9204102e-003,-5.7067871e-003,-4.6081543e-003,-3.5705566e-003,-3.5095215e-003,-3.3264160e-003,-3.0517578e-003,-2.6550293e-003,-1.5563965e-003,-5.4931641e-004,4.8828125e-004,2.5024414e-003,4.0283203e-003,4.9133301e-003,3.9367676e-003,1.4953613e-003,-1.0681152e-003,-4.0283203e-003,-4.4860840e-003,-3.9062500e-003,-3.8146973e-003,-2.5939941e-003,-2.3193359e-003,-2.1057129e-003,-3.3569336e-004,1.0986328e-003,2.2583008e-003,2.5634766e-003,1.8005371e-003,6.7138672e-004,9.4604492e-004,2.2583008e-003,3.2958984e-003,5.0659180e-003,4.7607422e-003,3.9672852e-003,3.6315918e-003,2.8991699e-003,3.0517578e-003,3.1127930e-003,2.5634766e-003,1.6784668e-003,3.6621094e-004,-4.8828125e-004,-4.5776367e-004,-9.1552734e-004,-3.6621094e-004,0.0000000e+000,1.4648438e-003,2.8381348e-003,2.3498535e-003,1.9226074e-003,2.4414063e-004,-1.8005371e-003,-3.1738281e-003,-4.3640137e-003,-4.4860840e-003,-3.1738281e-003,-1.6174316e-003,4.8828125e-004,2.2277832e-003,2.6855469e-003,2.5939941e-003,1.0986328e-003,4.8828125e-004,-6.4086914e-004,-5.4931641e-004,-9.1552734e-005,-8.8500977e-004,3.0517578e-005,1.8310547e-004,4.8828125e-004,4.2724609e-004,-3.0517578e-004,-9.4604492e-004,-1.5258789e-003,-2.7465820e-004,3.9672852e-004,1.2512207e-003,1.5869141e-003,-6.1035156e-005,-1.5563965e-003,-1.4648438e-003,-3.9672852e-004,2.3498535e-003,5.1269531e-003,4.5776367e-003,3.4484863e-003,1.7395020e-003,-2.4414063e-004,7.3242188e-004,1.2207031e-003,7.3242188e-004,1.3427734e-003,6.7138672e-004,3.9672852e-004,1.6479492e-003,1.9226074e-003,1.6479492e-003,1.4953613e-003,1.7700195e-003,2.1057129e-003,3.7231445e-003,5.7983398e-003,4.2114258e-003,1.1291504e-003,-2.9602051e-003,-6.0729980e-003,-5.2490234e-003,-3.0822754e-003,-1.6174316e-003,1.1596680e-003,2.4414063e-004,-3.9672852e-004,1.7089844e-003,2.3803711e-003,4.0893555e-003,5.1574707e-003,4.0588379e-003,3.2043457e-003,3.2348633e-003,2.7160645e-003,2.4719238e-003,2.3803711e-003,7.6293945e-004,3.9672852e-004,1.3427734e-003,2.7160645e-003,4.2114258e-003,5.2490234e-003,4.6997070e-003,3.5400391e-003,3.3569336e-003,2.4414063e-003,2.0141602e-003,1.9531250e-003,8.2397461e-004,1.5869141e-003,2.9296875e-003,4.6081543e-003,5.3710938e-003,4.8217773e-003,2.6550293e-003,-6.1035156e-004,-6.4086914e-004,1.2207031e-004,3.6315918e-003,7.8430176e-003,7.8735352e-003,8.0871582e-003,6.8054199e-003,4.2724609e-003,4.6691895e-003,4.1503906e-003,3.2958984e-003,3.0212402e-003,1.5563965e-003,1.3427734e-003,3.3569336e-003,4.9438477e-003,6.0729980e-003,7.4768066e-003,6.2866211e-003,4.4250488e-003,4.2419434e-003,3.6315918e-003,4.6691895e-003,5.9509277e-003,5.3100586e-003,5.5847168e-003,5.2185059e-003,4.8217773e-003,4.5471191e-003,4.5471191e-003,3.6010742e-003,2.7160645e-003,2.7465820e-003,2.7465820e-003,2.4719238e-003,2.5939941e-003,1.8615723e-003,1.0070801e-003,1.3427734e-003,1.2817383e-003,2.1667480e-003,3.2348633e-003,3.3569336e-003,3.5095215e-003,4.3029785e-003,5.0354004e-003,5.8898926e-003,6.6833496e-003,5.8898926e-003,5.0964355e-003,4.4555664e-003,2.9907227e-003,2.2277832e-003,1.7395020e-003,9.7656250e-004,1.2512207e-003,2.0141602e-003,3.0822754e-003,4.4555664e-003,5.2795410e-003,5.1879883e-003,4.8217773e-003,5.1269531e-003,5.1269531e-003,5.1269531e-003,5.0964355e-003,4.6691895e-003,4.8828125e-003,6.1950684e-003,7.3852539e-003,7.5988770e-003,6.5612793e-003,5.7983398e-003,4.4555664e-003,4.3334961e-003,4.7302246e-003,6.1645508e-003,7.7819824e-003,6.7749023e-003,5.6762695e-003,4.9133301e-003,4.4860840e-003,5.7678223e-003,6.0424805e-003,5.2185059e-003,5.0048828e-003,4.7912598e-003,5.5541992e-003,7.9345703e-003,9.8266602e-003,9.3078613e-003,7.2937012e-003,3.2043457e-003,-1.0681152e-003,-5.1879883e-004,2.1057129e-003,6.7749023e-003,1.2634277e-002,1.2725830e-002,1.0986328e-002,6.7443848e-003,3.3569336e-004,-3.3569336e-004,3.0517578e-005,3.1433105e-003,8.5449219e-003,9.0942383e-003,9.2163086e-003,6.4086914e-003,2.5024414e-003,2.2277832e-003,2.1972656e-003,4.9438477e-003,9.1857910e-003,1.0192871e-002,1.0742188e-002,8.0871582e-003,3.9672852e-003,1.1291504e-003,-1.6479492e-003,2.7465820e-004,3.2348633e-003,5.0659180e-003,6.9580078e-003,4.1809082e-003,8.2397461e-004,1.0070801e-003,2.2277832e-003,6.3171387e-003,1.0162354e-002,9.1552734e-003,5.6457520e-003,1.0375977e-003,-2.4719238e-003,2.9602051e-003,1.0162354e-002,1.3275146e-002,1.6021729e-002,1.0925293e-002,3.6315918e-003,2.6245117e-003,1.1596680e-003,3.9367676e-003,6.6528320e-003,3.7841797e-003,2.5939941e-003,3.0517578e-003,3.6010742e-003,6.0729980e-003,6.8359375e-003,2.5329590e-003,-2.2888184e-003,-4.2114258e-003,-4.2114258e-003,-2.1362305e-004,4.4250488e-003,2.1057129e-003,-9.1552734e-004,-4.4860840e-003,-8.3923340e-003,-5.5847168e-003,-2.2277832e-003,-1.1596680e-003,-7.9345703e-004,-2.5939941e-003,-4.8522949e-003,-3.4790039e-003,-2.4414063e-003,-1.0681152e-003,5.1879883e-004,1.5258789e-004,-2.4414063e-004,-1.8310547e-004,-5.4931641e-004,-1.9531250e-003,-3.2348633e-003,-3.5400391e-003,-2.7770996e-003,-5.7983398e-004,1.6174316e-003,6.1035156e-004,-1.4343262e-003,-3.6926270e-003,-6.0729980e-003,-4.4860840e-003,-3.5705566e-003,-1.8310547e-003,-2.1362305e-004,-1.9226074e-003,-3.0517578e-003,-2.6855469e-003,-2.4108887e-003,-1.4953613e-003,-4.8828125e-004,-1.1901855e-003,-1.3732910e-003,-2.7465820e-004,1.0070801e-003,2.2888184e-003,3.9978027e-003,4.1809082e-003,3.9062500e-003,3.6621094e-003,2.5329590e-003,2.5329590e-003,3.1127930e-003,3.7841797e-003,4.4555664e-003,4.8217773e-003,4.9438477e-003,4.6691895e-003,4.3640137e-003,4.4555664e-003,4.5776367e-003,5.0354004e-003,5.2185059e-003,4.5166016e-003,3.9367676e-003,3.2653809e-003,3.0822754e-003,3.7536621e-003,4.4250488e-003,4.6386719e-003,4.3640137e-003,3.8452148e-003,2.8076172e-003,2.6855469e-003,2.9602051e-003,4.2419434e-003,5.7678223e-003,6.3171387e-003,7.0190430e-003,6.2561035e-003,4.8522949e-003,3.8757324e-003,3.2958984e-003,3.8452148e-003,4.7302246e-003,4.5776367e-003,4.3029785e-003,2.5939941e-003,1.0681152e-003,1.1291504e-003,3.6621094e-004,1.1901855e-003,1.5258789e-003,1.0375977e-003,9.7656250e-004,1.5563965e-003,1.7089844e-003,2.2277832e-003,2.6855469e-003,3.6010742e-003,5.4016113e-003,7.6599121e-003,9.7045898e-003,9.6130371e-003,7.5378418e-003,3.6010742e-003,0.0000000e+000,-1.8310547e-004,8.5449219e-004,3.5095215e-003,6.9580078e-003,6.6528320e-003,5.4626465e-003,2.9602051e-003,-1.3122559e-003,-2.1972656e-003,-3.5705566e-003,-4.0283203e-003,-2.7160645e-003,-3.1433105e-003,-2.3498535e-003,-1.9836426e-003,-1.7089844e-003,-1.4343262e-003,-1.8615723e-003,-2.3803711e-003,-3.6621094e-003,-4.3640137e-003,-4.9133301e-003,-5.0354004e-003,-4.2724609e-003,-3.9672852e-003,-2.9907227e-003,-2.4108887e-003,-2.0446777e-003,-4.8828125e-004,8.5449219e-004,1.7089844e-003,1.0375977e-003,-3.6621094e-004,-2.5634766e-003,-2.5024414e-003,-1.6174316e-003,0.0000000e+000,1.3122559e-003,2.4414063e-004,6.1035156e-005,-8.8500977e-004,-1.0375977e-003,1.3122559e-003,3.6010742e-003,3.2043457e-003,2.0446777e-003,-1.8310547e-004,-2.7160645e-003,-1.9531250e-003,-1.2207031e-003,-9.7656250e-004,-4.2724609e-004,-1.2207031e-003,-2.0446777e-003,-1.3732910e-003,-7.9345703e-004,-5.1879883e-004,-1.2207031e-004,-4.5776367e-004,-1.2207031e-004,1.6174316e-003,3.2653809e-003,3.7231445e-003,3.5095215e-003,1.5258789e-003,-9.1552734e-005,7.0190430e-004,1.4038086e-003,2.1667480e-003,2.8686523e-003,1.6479492e-003,-2.1362305e-004,4.2724609e-004,4.8828125e-004,1.1291504e-003,1.8310547e-003,3.0517578e-005,-1.1901855e-003,-1.2207031e-003,-5.7983398e-004,8.2397461e-004,2.5634766e-003,2.4719238e-003,2.8076172e-003,2.6245117e-003,2.4108887e-003,2.8686523e-003,3.2348633e-003,3.4790039e-003,3.4484863e-003,3.2958984e-003,3.8452148e-003,4.9743652e-003,2.3498535e-003,5.3710938e-003,2.3803711e-003,4.3945313e-003,9.1552734e-004,-3.3569336e-004,1.3122559e-003,-4.2724609e-004,3.6621094e-004,-3.0517578e-004,3.3569336e-004,3.9672852e-004,1.0681152e-003,2.7465820e-004,-3.0517578e-004,-3.9672852e-004,-6.1035156e-004,4.2724609e-004,1.6784668e-003,2.3498535e-003,2.5024414e-003,1.7395020e-003,5.7983398e-004,2.4414063e-004,8.2397461e-004,2.4414063e-003,4.3945313e-003,4.1198730e-003,3.5705566e-003,2.0141602e-003,9.4604492e-004,1.8005371e-003,2.9602051e-003,3.8146973e-003,4.5166016e-003,3.4790039e-003,1.8310547e-003,9.4604492e-004,2.4414063e-004,1.1291504e-003,1.6174316e-003,5.7983398e-004,1.5258789e-004,-1.2207031e-003,-2.7770996e-003,-2.1667480e-003,-1.5563965e-003,-1.4038086e-003,-9.7656250e-004,-1.3122559e-003,-1.2512207e-003,-9.1552734e-004,-5.4931641e-004,-3.3569336e-004,3.0517578e-004,1.1596680e-003,1.8920898e-003,1.8920898e-003,9.1552734e-004,1.0375977e-003,4.2724609e-004,1.0681152e-003,2.1362305e-003,3.2958984e-003,4.2419434e-003,2.9907227e-003,1.4648438e-003,3.0517578e-004,-5.1879883e-004,-1.5258789e-004,2.7465820e-004,-3.3569336e-004,-5.1879883e-004,-6.4086914e-004,-2.4414063e-004,1.1596680e-003,2.2888184e-003,2.9602051e-003,2.5634766e-003,1.5258789e-003,-9.1552734e-005,-4.5776367e-004,-5.1879883e-004,-3.0517578e-004,6.7138672e-004,8.8500977e-004,1.5869141e-003,2.1972656e-003,2.2583008e-003,3.1127930e-003,3.3569336e-003,3.6621094e-003,4.2724609e-003,3.9672852e-003,3.4790039e-003,3.3569336e-003,2.8076172e-003,2.5939941e-003,2.0141602e-003,2.0141602e-003,1.8310547e-003,1.7395020e-003,1.5869141e-003,1.3732910e-003,1.6784668e-003,1.8005371e-003,1.6784668e-003,1.8005371e-003,1.8310547e-003,1.2817383e-003,6.4086914e-004,-6.4086914e-004,-1.7700195e-003,-1.9836426e-003,-1.8920898e-003,-6.1035156e-004,2.3193359e-003,3.6621094e-003,4.6691895e-003,4.7302246e-003,3.5705566e-003,3.4179688e-003,2.6550293e-003,2.1972656e-003,2.0141602e-003,1.3122559e-003,1.1901855e-003,5.1879883e-004,6.1035156e-004,9.1552734e-005,1.8310547e-004,9.1552734e-004,9.1552734e-004,5.4931641e-004,-1.8310547e-004,-1.5258789e-003,-2.8381348e-003,-3.0517578e-003,-2.7160645e-003,-1.5869141e-003,3.9672852e-004,7.0190430e-004,6.1035156e-004,5.1879883e-004,-3.0517578e-004,-6.1035156e-005,-6.7138672e-004,-1.0375977e-003,-1.0070801e-003,-1.5563965e-003,-1.6784668e-003,-1.8310547e-003,-1.9226074e-003,-1.9226074e-003,-1.5258789e-003,-8.5449219e-004,-4.8828125e-004,-3.0517578e-004,-1.4343262e-003,-4.1198730e-003,-6.6833496e-003,-7.2937012e-003,-6.3476563e-003,-3.7231445e-003,-1.2207031e-004,3.3569336e-004,0.0000000e+000,-1.7395020e-003,-5.0964355e-003,-4.9133301e-003,-5.2490234e-003,-5.2185059e-003,-1.9836426e-003,-2.5024414e-003,-2.1972656e-003,-2.8076172e-003,-3.8146973e-003,-3.5095215e-003,-2.8076172e-003,-1.2512207e-003,9.4604492e-004,2.9907227e-003,4.3029785e-003,4.3945313e-003,3.3569336e-003,2.1362305e-003,9.4604492e-004,1.2207031e-003,1.9531250e-003,2.9296875e-003,4.5471191e-003,4.2724609e-003,4.4555664e-003,4.3945313e-003,4.5776367e-003,6.2255859e-003,7.6599121e-003,8.1481934e-003,7.7514648e-003,5.5541992e-003,2.6855469e-003,1.7700195e-003,1.3122559e-003,2.7160645e-003,4.1198730e-003,3.9367676e-003,3.6010742e-003,2.7160645e-003,1.3427734e-003,1.4343262e-003,1.4038086e-003,8.8500977e-004,1.2207031e-003,1.5258789e-003,2.8076172e-003,4.9438477e-003,7.1716309e-003,7.8125000e-003,7.3852539e-003,6.6528320e-003,5.4321289e-003,6.3476563e-003,7.2021484e-003,6.9885254e-003,6.2561035e-003,3.9672852e-003,1.4343262e-003,1.0681152e-003,7.9345703e-004,1.5258789e-003,3.1738281e-003,2.0446777e-003,9.1552734e-004,-3.0517578e-004,-1.7700195e-003,-1.8005371e-003,-1.0375977e-003,-9.1552734e-005,1.4953613e-003,1.9531250e-003,1.8920898e-003,4.8828125e-004,-1.2817383e-003,-1.7700195e-003,-1.8920898e-003,3.3569336e-004,2.8991699e-003,4.2724609e-003,4.7912598e-003,3.9978027e-003,2.1362305e-003,2.4108887e-003,2.4108887e-003,2.3803711e-003,3.0517578e-003,1.6174316e-003,8.2397461e-004,1.8310547e-004,-4.5776367e-004,-6.4086914e-004,3.0517578e-005,-9.1552734e-005,1.5258789e-004,1.5869141e-003,2.5634766e-003,3.1433105e-003,2.8076172e-003,1.2207031e-003,-1.5258789e-004,-4.2724609e-004,3.6621094e-004,1.7395020e-003,4.4860840e-003,4.6081543e-003,4.9743652e-003,3.6621094e-003,1.1901855e-003,4.5776367e-004,-3.3569336e-004,9.1552734e-005,1.3427734e-003,1.7089844e-003,1.9836426e-003,1.0681152e-003,-1.7700195e-003,-1.4648438e-003,-2.5939941e-003,-2.1667480e-003,-1.3732910e-003,-1.1901855e-003,-9.1552734e-005,7.9345703e-004,1.8310547e-003,2.2277832e-003,1.9836426e-003,8.8500977e-004,-2.7465820e-004,-1.1596680e-003,-1.3732910e-003,-5.7983398e-004,8.5449219e-004,2.6245117e-003,4.6691895e-003,4.8522949e-003,4.2724609e-003,3.0212402e-003,6.4086914e-004,1.1596680e-003,2.8686523e-003,5.4931641e-003,8.2397461e-003,5.8593750e-003,2.1667480e-003,-2.1667480e-003,-6.1950684e-003,-3.5705566e-003,1.1291504e-003,4.8217773e-003,8.3923340e-003,4.5776367e-003,5.1879883e-004,3.6621094e-004,1.2207031e-004,4.9743652e-003,9.2773438e-003,6.6223145e-003,3.8146973e-003,2.1362305e-004,-3.1738281e-003,-9.1552734e-005,2.9296875e-003,3.1738281e-003,3.3264160e-003,-6.1035156e-005,-3.2043457e-003,-9.4604492e-004,8.8500977e-004,3.2958984e-003,5.5236816e-003,3.9367676e-003,2.4719238e-003,2.5024414e-003,1.6174316e-003,1.8310547e-003,2.9907227e-003,7.3242188e-004,-9.4604492e-004,-2.0141602e-003,-2.7465820e-003,-2.4414063e-003,-2.4719238e-003,-2.7465820e-003,-2.5634766e-003,-1.6174316e-003,-7.0190430e-004,3.3569336e-004,8.2397461e-004,4.5776367e-004,-3.0517578e-005,-1.2207031e-004,-6.1035156e-005,0.0000000e+000,3.3569336e-004,-4.8828125e-004,-9.1552734e-005,1.3122559e-003,2.9602051e-003,4.6386719e-003,5.2185059e-003,4.2724609e-003,2.7160645e-003,2.4108887e-003,1.5563965e-003,2.1057129e-003,3.0212402e-003,2.3193359e-003,2.2277832e-003,1.4038086e-003,1.1901855e-003,2.3193359e-003,3.2043457e-003,3.0212402e-003,2.4414063e-003,1.2207031e-003,-2.7465820e-004,-5.1879883e-004,-7.0190430e-004,-1.5258789e-003,-2.5634766e-003,-5.0354004e-003,-6.8054199e-003,-6.8664551e-003,-6.4086914e-003,-4.3640137e-003,-2.6245117e-003,-3.5705566e-003,-4.3334961e-003,-5.6457520e-003,-5.2490234e-003,-2.1972656e-003,2.1362305e-004,7.9345703e-004,1.0375977e-003,-9.4604492e-004,-3.4179688e-003,-3.0822754e-003,-3.0822754e-003,-2.1972656e-003,-4.2724609e-004,-5.1879883e-004,-6.7138672e-004,-2.1362305e-004,-7.6293945e-004,-5.1879883e-004,3.9672852e-004,1.1901855e-003,2.0751953e-003,3.0212402e-003,3.2043457e-003,2.3803711e-003,1.8310547e-003,8.8500977e-004,1.0375977e-003,1.9531250e-003,2.9907227e-003,2.6855469e-003,1.6784668e-003,1.2207031e-004,-1.4648438e-003,-4.2724609e-004,5.7983398e-004,1.7395020e-003,3.0212402e-003,1.9531250e-003,8.2397461e-004,9.7656250e-004,7.6293945e-004,1.7700195e-003,3.1738281e-003,2.5634766e-003,2.5024414e-003,2.1667480e-003,1.7089844e-003,2.4719238e-003,3.2043457e-003,3.5400391e-003,4.1503906e-003,3.7536621e-003,2.8381348e-003,2.8381348e-003,2.5634766e-003,3.2043457e-003,3.4484863e-003,2.9602051e-003,2.2277832e-003,1.2207031e-004,-8.8500977e-004,-7.3242188e-004,-6.1035156e-005,8.5449219e-004,1.2817383e-003,6.7138672e-004,-1.5258789e-004,9.1552734e-005,7.6293945e-004,2.0751953e-003,3.3569336e-003,2.7465820e-003,1.8310547e-003,7.9345703e-004,2.4414063e-004,1.4343262e-003,2.5329590e-003,2.2583008e-003,1.5869141e-003,7.0190430e-004,-6.1035156e-005,4.2724609e-004,6.7138672e-004,5.1879883e-004,6.1035156e-005,-9.7656250e-004,-9.4604492e-004,-4.5776367e-004,6.1035156e-004,1.3732910e-003,1.8920898e-003,2.2583008e-003,2.4719238e-003,3.2653809e-003,3.2958984e-003,2.0446777e-003,-6.1035156e-005,-1.5869141e-003,-2.3803711e-003,-1.6174316e-003,-3.9672852e-004,-9.4604492e-004,-1.3732910e-003,-2.3498535e-003,-3.0517578e-003,-1.5563965e-003,1.8310547e-004,6.7138672e-004,1.1596680e-003,-1.2207031e-004,-1.4038086e-003,-1.0986328e-003,-9.1552734e-005,5.7983398e-004,1.5258789e-003,2.4414063e-003,1.8920898e-003,1.7089844e-003,4.5776367e-004,2.7465820e-004,-2.4414063e-004,3.6621094e-004,1.2207031e-003,1.8005371e-003,2.7465820e-003,2.0446777e-003,1.4343262e-003,9.7656250e-004,4.5776367e-004,6.4086914e-004,1.0375977e-003,3.6621094e-004,2.1362305e-004,3.6621094e-004,8.8500977e-004,2.8076172e-003,5.0048828e-003,5.9204102e-003,6.1035156e-003,5.7678223e-003,4.6081543e-003,4.4860840e-003,4.1503906e-003,3.2043457e-003,2.5634766e-003,1.3427734e-003,9.1552734e-004,1.4648438e-003,2.8076172e-003,3.9062500e-003,5.0354004e-003,5.0659180e-003,3.8146973e-003,3.0517578e-003,2.2888184e-003,2.2277832e-003,2.6855469e-003,3.1738281e-003,3.6010742e-003,3.3569336e-003,2.8076172e-003,2.0751953e-003,7.6293945e-004,4.5776367e-004,6.1035156e-004,9.4604492e-004,2.1057129e-003,2.4108887e-003,2.9602051e-003,3.5095215e-003,2.8076172e-003,2.5024414e-003,2.8381348e-003,2.9907227e-003,3.5400391e-003,3.7841797e-003,3.7536621e-003,2.5024414e-003,1.3732910e-003,1.6784668e-003,1.6174316e-003,2.6855469e-003,4.2419434e-003,3.8452148e-003,2.6855469e-003,3.6621094e-004,-1.7700195e-003,-7.3242188e-004,1.0986328e-003,3.0517578e-003,5.3100586e-003,4.5471191e-003,3.4484863e-003,3.5705566e-003,2.8381348e-003,4.3029785e-003,5.4321289e-003,4.7912598e-003,3.9978027e-003,2.3498535e-003,5.4931641e-004,5.7983398e-004,1.0375977e-003,1.6784668e-003,2.4414063e-003,1.5869141e-003,4.5776367e-004,-4.2724609e-004,-1.3122559e-003,-1.5258789e-004,2.4108887e-003,4.8217773e-003,7.5988770e-003,8.1176758e-003,7.3852539e-003,6.3476563e-003,4.8522949e-003,4.0893555e-003,3.3569336e-003,2.1972656e-003,1.9531250e-003,5.7983398e-004,1.2207031e-004,9.7656250e-004,1.3122559e-003,2.7770996e-003,3.5095215e-003,3.7536621e-003,5.2490234e-003,5.9204102e-003,5.0659180e-003,2.8381348e-003,4.8828125e-004,-3.2958984e-003,-6.5002441e-003,-7.1716309e-003,-5.7983398e-003,-3.7231445e-003,-5.4931641e-004,5.1879883e-004,8.2397461e-004,1.0986328e-003,-6.7138672e-004,-3.0517578e-004,-7.9345703e-004,-9.4604492e-004,-8.2397461e-004,-1.1596680e-003,-3.3569336e-004,-6.4086914e-004,-7.3242188e-004,-2.0751953e-003,-3.1433105e-003,-2.7465820e-003,-2.2277832e-003,-1.0681152e-003,3.0517578e-004,1.0375977e-003,1.2817383e-003,1.7089844e-003,2.0446777e-003,3.1738281e-003,4.0283203e-003,4.0588379e-003,3.8757324e-003,3.2348633e-003,1.8615723e-003,1.7089844e-003,1.0986328e-003,-6.1035156e-005,-1.0070801e-003,-1.9836426e-003,-2.3498535e-003,-1.4648438e-003,3.0517578e-004,1.6784668e-003,2.3193359e-003,1.6479492e-003,3.0517578e-005,-4.8828125e-004,-1.2512207e-003,-9.1552734e-004,-1.2207031e-004,-1.2207031e-004,-9.1552734e-005,-6.7138672e-004,-3.0517578e-005,3.3569336e-004,4.5776367e-004,6.4086914e-004,5.1879883e-004,7.0190430e-004,1.0986328e-003,1.4648438e-003,1.8005371e-003,8.5449219e-004,-4.2724609e-004,-1.5869141e-003,-2.2888184e-003,-1.6479492e-003,-9.1552734e-004,-3.3569336e-004,5.1879883e-004,9.1552734e-005,-4.8828125e-004,-9.1552734e-005,-6.4086914e-004,-1.0681152e-003,-1.1901855e-003,-3.3874512e-003,-5.3405762e-003,-5.8288574e-003,-5.7983398e-003,-4.2724609e-003,-2.0141602e-003,0.0000000e+000,2.2888184e-003,3.1738281e-003,2.7770996e-003,3.1127930e-003,1.8615723e-003,1.2207031e-003,2.4414063e-004,-7.9345703e-004,-1.4343262e-003,-2.2277832e-003,-2.7160645e-003,-2.7465820e-003,-1.8310547e-003,-4.2724609e-004,4.2724609e-004,2.7465820e-004,-9.7656250e-004,-2.0751953e-003,-3.8757324e-003,-4.6997070e-003,-5.0659180e-003,-5.8898926e-003,-6.4697266e-003,-7.9650879e-003,-8.9416504e-003,-9.7351074e-003,-8.4228516e-003,-6.3171387e-003,-4.9743652e-003,-4.7607422e-003,-4.7912598e-003,-4.0588379e-003,-4.0893555e-003,-2.1972656e-003,-2.4414063e-004,6.4086914e-004,1.3122559e-003,-9.1552734e-005,-1.4038086e-003,-2.8991699e-003,-4.3640137e-003,-5.3405762e-003,-5.5847168e-003,-5.2490234e-003,-4.2724609e-003,-3.7841797e-003,-4.0893555e-003,-4.4250488e-003,-5.2490234e-003,-4.6386719e-003,-4.3640137e-003,-2.1972656e-003,-1.4953613e-003,0.0000000e+000,-2.2888184e-003,-4.5166016e-003,-4.4555664e-003,-4.3029785e-003,-3.8757324e-003,-7.7209473e-003,-4.3640137e-003,-6.1340332e-003,-6.1950684e-003,-6.1645508e-003,-6.1950684e-003,-4.5776367e-003,-3.3569336e-003,-3.2043457e-003,-4.2114258e-003,-5.0659180e-003,-6.0729980e-003,-5.2795410e-003,-4.1198730e-003,-3.5400391e-003,-2.3803711e-003,-3.8452148e-003,-5.2185059e-003,-5.2185059e-003,-5.1269531e-003,-3.3874512e-003,-1.3732910e-003,-1.0681152e-003,-1.9836426e-003,-4.0283203e-003,-5.4321289e-003,-5.0659180e-003,-3.9672852e-003,-1.7700195e-003,1.2512207e-003,2.1057129e-003,2.6855469e-003,2.7465820e-003,2.2277832e-003,3.2348633e-003,3.1433105e-003,3.1738281e-003,3.0517578e-003,1.9531250e-003,1.2512207e-003,2.4414063e-004,-3.3569336e-004,-1.0070801e-003,-1.5869141e-003,-2.0141602e-003,-1.6174316e-003,-1.1596680e-003,-5.7983398e-004,-9.1552734e-005,-4.8828125e-004,-9.1552734e-005,-2.7465820e-004,-2.7465820e-004,-2.7465820e-004,-1.2512207e-003,-2.6550293e-003,-4.4250488e-003,-6.0119629e-003,-6.3476563e-003,-5.5847168e-003,-4.3029785e-003,-2.7160645e-003,-1.9226074e-003,-1.4038086e-003,-1.7089844e-003,-2.6245117e-003,-3.1738281e-003,-3.6010742e-003,-3.6926270e-003,-3.2043457e-003,-2.9907227e-003,-2.5634766e-003,-2.7770996e-003,-3.0212402e-003,-3.5095215e-003,-4.4250488e-003,-4.4250488e-003,-3.7231445e-003,-3.6010742e-003,-2.3193359e-003,-1.8310547e-003,-2.1057129e-003,-2.0141602e-003,-1.4038086e-003,-6.7138672e-004,-3.0517578e-005,3.0517578e-005,-2.7465820e-004,-5.7983398e-004,-1.6479492e-003,-1.7089844e-003,-1.4038086e-003,-1.4343262e-003,-1.6479492e-003,-2.1667480e-003,-2.1667480e-003,-1.6479492e-003,-5.7983398e-004,2.4414063e-004,4.2724609e-004,-5.1879883e-004,-1.7395020e-003,-2.3803711e-003,-2.8686523e-003,-2.3193359e-003,-1.1901855e-003,-8.5449219e-004,-6.7138672e-004,-9.4604492e-004,-1.7395020e-003,-1.4648438e-003,-1.5869141e-003,-9.1552734e-004,-3.6621094e-004,-5.7983398e-004,-8.8500977e-004,-1.4648438e-003,-2.7770996e-003,-2.9602051e-003,-3.0212402e-003,-3.2653809e-003,-2.3803711e-003,-1.7700195e-003,-7.9345703e-004,-5.7983398e-004,-9.1552734e-004,-1.8310547e-003,-3.2043457e-003,-3.4484863e-003,-3.4790039e-003,-2.0446777e-003,6.1035156e-005,2.1362305e-004,5.1879883e-004,-9.1552734e-004,-3.2653809e-003,-4.5471191e-003,-4.1198730e-003,-3.1738281e-003,-1.6784668e-003,-2.0141602e-003,-2.3498535e-003,-3.7231445e-003,-5.2490234e-003,-5.2185059e-003,-4.8522949e-003,-4.0283203e-003,-2.4719238e-003,-1.8920898e-003,-1.3427734e-003,-9.7656250e-004,-1.7089844e-003,-2.2583008e-003,-2.9602051e-003,-3.1738281e-003,-3.7536621e-003,-4.0893555e-003,-4.6997070e-003,-6.1035156e-003,-6.3476563e-003,-5.7373047e-003,-4.2114258e-003,-2.0446777e-003,-5.1879883e-004,-1.7395020e-003,-3.9062500e-003,-5.4931641e-003,-7.2326660e-003,-5.6762695e-003,-3.6621094e-003,-3.4790039e-003,-2.6550293e-003,-4.2724609e-003,-5.5847168e-003,-4.0283203e-003,-3.6621094e-003,-3.0822754e-003,-3.4790039e-003,-5.7678223e-003,-7.7209473e-003,-7.2326660e-003,-5.6152344e-003,-3.2958984e-003,-4.5776367e-004,-1.0681152e-003,-1.7089844e-003,-2.6550293e-003,-4.3945313e-003,-3.8757324e-003,-3.0517578e-003,-4.1809082e-003,-4.8217773e-003,-4.7912598e-003,-6.1340332e-003,-5.4321289e-003,-5.3710938e-003,-5.1879883e-003,-5.1574707e-003,-5.5847168e-003,-6.5307617e-003,-7.0190430e-003,-7.6599121e-003,-8.0566406e-003,-7.5073242e-003,-7.2326660e-003,-5.8898926e-003,-3.9978027e-003,-1.8005371e-003,-7.0190430e-004,-7.9345703e-004,-1.6479492e-003,-3.5400391e-003,-4.5166016e-003,-5.6152344e-003,-5.7373047e-003,-5.0964355e-003,-4.6081543e-003,-3.3874512e-003,-2.3193359e-003,-1.9531250e-003,-1.2817383e-003,-1.8310547e-003,-3.0517578e-003,-4.3334961e-003,-4.9133301e-003,-4.2724609e-003,-3.0822754e-003,-1.4953613e-003,-1.5563965e-003,-1.8920898e-003,-3.4484863e-003,-5.6457520e-003,-5.4321289e-003,-5.0659180e-003,-4.1503906e-003,-3.1433105e-003,-3.5705566e-003,-4.3945313e-003,-4.1503906e-003,-3.5705566e-003,-1.3122559e-003,1.0986328e-003,1.7089844e-003,2.0141602e-003,3.6621094e-004,-1.7395020e-003,-2.7770996e-003,-3.6010742e-003,-4.9438477e-003,-4.9133301e-003,-5.1879883e-003,-5.2185059e-003,-4.3945313e-003,-3.6010742e-003,-2.8076172e-003,-2.2583008e-003,-1.9226074e-003,-2.4719238e-003,-1.6174316e-003,-1.2817383e-003,-5.4931641e-004,7.3242188e-004,5.7983398e-004,8.2397461e-004,-3.0517578e-004,-1.3427734e-003,-2.4414063e-003,-3.1127930e-003,-2.5939941e-003,-1.3732910e-003,-7.0190430e-004,-2.1362305e-004,-5.4931641e-004,-1.4953613e-003,-1.2817383e-003,-1.3427734e-003,-3.0517578e-004,3.0517578e-004,-8.2397461e-004,-2.1362305e-003,-3.0517578e-003,-3.4484863e-003,-1.5258789e-003,3.9672852e-004,-9.1552734e-005,-1.0986328e-003,-3.8146973e-003,-6.5307617e-003,-5.8898926e-003,-3.9672852e-003,-1.7089844e-003,1.0070801e-003,3.6621094e-004,-7.0190430e-004,-4.8828125e-004,-6.4086914e-004,1.3732910e-003,2.5939941e-003,1.7700195e-003,8.5449219e-004,-7.3242188e-004,-2.4414063e-003,-2.1362305e-003,-1.8615723e-003,-2.6855469e-003,-1.3427734e-003,-2.2583008e-003,-2.9602051e-003,-2.5329590e-003,-2.5024414e-003,-2.0751953e-003,-1.6174316e-003,-1.4648438e-003,-1.3122559e-003,-8.5449219e-004,-7.3242188e-004,-5.1879883e-004,-2.1362305e-004,3.6621094e-004,1.1596680e-003,2.1362305e-003,2.1972656e-003,1.1291504e-003,-1.4038086e-003,-4.6386719e-003,-6.9580078e-003,-7.2021484e-003,-5.9509277e-003,-4.5471191e-003,-1.7395020e-003,-1.4953613e-003,-1.7395020e-003,-2.4108887e-003,-4.6386719e-003,-5.3100586e-003,-6.3171387e-003,-7.2326660e-003,-6.8664551e-003,-6.9274902e-003,-6.4697266e-003,-5.7373047e-003,-5.6457520e-003,-6.4697266e-003,-6.8969727e-003,-7.3547363e-003,-8.1481934e-003,-7.4462891e-003,-6.8664551e-003,-6.6833496e-003,-6.2866211e-003,-6.5307617e-003,-6.5612793e-003,-6.0729980e-003,-6.0424805e-003,-5.6457520e-003,-5.1574707e-003,-4.7302246e-003,-4.8522949e-003,-3.8452148e-003,-3.5705566e-003,-3.2958984e-003,-3.6315918e-003,-3.6315918e-003,-2.4414063e-003,-1.1291504e-003,-4.5776367e-004,-4.2724609e-004,-4.8828125e-004,-1.5258789e-003,-2.0446777e-003,-2.2888184e-003,-2.3193359e-003,-2.7465820e-003,-2.7465820e-003,-3.6010742e-003,-4.4250488e-003,-5.1574707e-003,-6.2255859e-003,-6.1645508e-003,-6.3171387e-003,-5.8898926e-003,-4.5471191e-003,-2.9907227e-003,-1.5869141e-003,-1.0681152e-003,-1.1901855e-003,-2.0141602e-003,-3.1738281e-003,-3.6621094e-003,-3.6315918e-003,-3.4790039e-003,-2.8381348e-003,-3.1738281e-003,-3.1127930e-003,-3.4790039e-003,-3.6315918e-003,-2.5939941e-003,-1.4953613e-003,6.1035156e-005,1.8005371e-003,2.0751953e-003,1.4648438e-003,7.9345703e-004,-7.0190430e-004,-1.3427734e-003,-1.6784668e-003,-1.8310547e-003,-1.6479492e-003,-2.5329590e-003,-2.6550293e-003,-2.2583008e-003,-1.8615723e-003,-8.5449219e-004,4.2724609e-004,2.7465820e-004,-6.1035156e-004,-1.2207031e-003,-2.0446777e-003,-1.7089844e-003,7.0190430e-004,1.4038086e-003,1.7700195e-003,1.0070801e-003,-5.4931641e-004,-8.8500977e-004,-1.6784668e-003,-2.3193359e-003,-2.4719238e-003,-3.2958984e-003,-3.8757324e-003,-4.7302246e-003,-5.0354004e-003,-4.7302246e-003,-4.3945313e-003,-3.9978027e-003,-3.4179688e-003,-2.9602051e-003,-1.5563965e-003,-9.4604492e-004,-3.0517578e-005,6.1035156e-004,8.8500977e-004,1.7395020e-003,2.1362305e-003,2.5329590e-003,2.9296875e-003,2.5634766e-003,2.1362305e-003,2.0141602e-003,2.6245117e-003,2.6550293e-003,2.7770996e-003,2.6550293e-003,1.9531250e-003,1.8615723e-003,1.9531250e-003,2.2888184e-003,2.4414063e-003,2.2888184e-003,1.8615723e-003,1.4343262e-003,1.1901855e-003,1.2512207e-003,1.4343262e-003,9.1552734e-004,6.4086914e-004,-6.1035156e-005,-7.0190430e-004,-2.1362305e-004,3.3569336e-004,1.4343262e-003,2.3498535e-003,2.1057129e-003,1.4343262e-003,0.0000000e+000,-1.6784668e-003,-1.4648438e-003,6.1035156e-005,1.0375977e-003,2.3803711e-003,1.7089844e-003,5.4931641e-004,1.2207031e-004,-2.4414063e-004,1.2512207e-003,1.1291504e-003,-7.0190430e-004,-2.5024414e-003,-3.2958984e-003,-2.2583008e-003,3.6621094e-003,1.0192871e-002,1.2664795e-002,1.3702393e-002,1.0131836e-002,4.5166016e-003,5.1269531e-003,5.9509277e-003,7.8430176e-003,1.0589600e-002,6.5612793e-003,2.9296875e-003,2.4414063e-003,2.5634766e-003,7.0190430e-003,1.1535645e-002,1.0925293e-002,9.3078613e-003,7.6293945e-003,5.3100586e-003,7.6293945e-003,1.0101318e-002,9.4604492e-003,9.3994141e-003,7.2326660e-003,5.5236816e-003,6.4697266e-003,6.7138672e-003,5.2490234e-003,3.8452148e-003,2.2277832e-003,1.6174316e-003,4.9743652e-003,7.7514648e-003,8.2702637e-003,7.4768066e-003,4.6691895e-003,1.9531250e-003,3.6621094e-003,6.4392090e-003,6.8969727e-003,9.7961426e-003,8.0566406e-003,4.8217773e-003,4.2114258e-003,3.3264160e-003,5.1879883e-003,7.3852539e-003,6.9580078e-003,6.8969727e-003,6.0424805e-003,4.0588379e-003,3.0517578e-003,1.4343262e-003,4.2724609e-004,-1.1901855e-003,-3.3569336e-004,1.0681152e-003,1.5563965e-003,2.1362305e-003,1.6174316e-003,1.1901855e-003,2.0751953e-003,2.3193359e-003,2.9602051e-003,4.2724609e-003,4.2114258e-003,3.4790039e-003,2.8686523e-003,2.2277832e-003,1.7089844e-003,1.8615723e-003,1.8615723e-003,2.3498535e-003,3.5095215e-003,4.2724609e-003,4.0893555e-003,3.3264160e-003,2.4108887e-003,5.4931641e-004,7.0190430e-004,3.0517578e-005,-3.9672852e-004,2.4414063e-004,-4.2724609e-004,-2.1362305e-004,-4.2724609e-004,-1.5258789e-004,-1.5258789e-004,-8.5449219e-004,1.2207031e-004,8.8500977e-004,2.5329590e-003,2.8991699e-003,1.7395020e-003,0.0000000e+000,-1.3732910e-003,-2.3803711e-003,-1.7700195e-003,2.7465820e-004,1.0375977e-003,2.0751953e-003,1.9836426e-003,1.3427734e-003,2.5024414e-003,2.7770996e-003,2.7770996e-003,2.3193359e-003,7.6293945e-004,-4.5776367e-004,3.0517578e-004,1.5563965e-003,2.3803711e-003,3.3569336e-003,2.5024414e-003,1.9531250e-003,3.3569336e-003,3.6010742e-003,4.7912598e-003,5.5847168e-003,4.6081543e-003,3.6621094e-003,2.6855469e-003,2.0751953e-003,2.4414063e-003,3.3874512e-003,2.7160645e-003,2.3803711e-003,1.9226074e-003,1.5258789e-003,1.8005371e-003,1.9226074e-003,1.9836426e-003,1.9226074e-003,1.7089844e-003,1.2207031e-003,1.8005371e-003,2.2277832e-003,2.6855469e-003,3.1127930e-003,3.1127930e-003,2.9602051e-003,3.1127930e-003,3.1738281e-003,3.2958984e-003,3.9672852e-003,4.1809082e-003,4.1809082e-003,3.8146973e-003,3.2653809e-003,2.7770996e-003,2.4414063e-003,3.1127930e-003,3.5095215e-003,4.7302246e-003,6.5612793e-003,6.1950684e-003,5.7373047e-003,5.2795410e-003,4.6691895e-003,5.0964355e-003,5.6457520e-003,5.6762695e-003,5.9204102e-003,4.7912598e-003,3.5705566e-003,2.3193359e-003,1.4953613e-003,1.6174316e-003,2.4719238e-003,3.0822754e-003,4.4860840e-003,5.6152344e-003,5.8898926e-003,6.5307617e-003,5.4016113e-003,4.8522949e-003,3.9978027e-003,3.7536621e-003,4.1809082e-003,4.0588379e-003,4.8217773e-003,4.4860840e-003,3.5400391e-003,4.4250488e-003,4.6081543e-003,5.4626465e-003,5.7678223e-003,5.0048828e-003,4.0588379e-003,3.2043457e-003,2.5024414e-003,2.6245117e-003,3.9062500e-003,4.9133301e-003,6.2255859e-003,6.5917969e-003,6.1950684e-003,5.4016113e-003,3.4790039e-003,2.9602051e-003,2.7465820e-003,3.5400391e-003,5.2185059e-003,5.2185059e-003,4.5776367e-003,3.4179688e-003,2.5939941e-003,4.0893555e-003,6.2866211e-003,7.2326660e-003,8.4228516e-003,8.2397461e-003,6.8664551e-003,6.5612793e-003,6.0119629e-003,7.0800781e-003,7.5988770e-003,6.5917969e-003,5.9509277e-003,4.7302246e-003,4.1503906e-003,5.7678223e-003,7.1716309e-003,7.7819824e-003,8.2092285e-003,7.6904297e-003,7.1411133e-003,7.6599121e-003,8.2702637e-003,8.7890625e-003,9.8571777e-003,9.5520020e-003,9.2773438e-003,9.1247559e-003,8.6975098e-003,8.5449219e-003,8.3923340e-003,8.3923340e-003,8.5144043e-003,8.5754395e-003,8.8806152e-003,9.3994141e-003,9.4299316e-003,8.6975098e-003,7.5073242e-003,5.3710938e-003,2.9296875e-003,2.6550293e-003,3.1433105e-003,5.4626465e-003,8.8500977e-003,1.0070801e-002,1.0498047e-002,9.1857910e-003,7.2021484e-003,7.7209473e-003,7.9650879e-003,8.3618164e-003,8.8500977e-003,7.0800781e-003,6.1340332e-003,6.7443848e-003,7.3547363e-003,9.1857910e-003,9.4909668e-003,7.0190430e-003,5.0964355e-003,3.8146973e-003,2.5939941e-003,3.9367676e-003,7.0800781e-003,4.6997070e-003,7.9650879e-003,6.9580078e-003,4.8828125e-003,5.9814453e-003,4.3640137e-003,3.2348633e-003,1.5869141e-003,1.0986328e-003,1.6174316e-003,3.3264160e-003,5.0964355e-003,5.2185059e-003,4.4250488e-003,3.0517578e-003,7.3242188e-004,6.1035156e-005,-7.0190430e-004,-1.0070801e-003,-2.4414063e-004,6.7138672e-004,3.3874512e-003,6.2255859e-003,9.0637207e-003,1.0833740e-002,1.1352539e-002,1.0589600e-002,7.9040527e-003,5.5847168e-003,2.8686523e-003,8.2397461e-004,5.4931641e-004,8.8500977e-004,3.0517578e-003,4.3945313e-003,5.4626465e-003,6.8359375e-003,6.7749023e-003,8.2397461e-003,9.1857910e-003,8.9721680e-003,8.3618164e-003,5.7983398e-003,2.4719238e-003,5.1879883e-004,-3.0517578e-005,5.7983398e-004,2.8076172e-003,4.1198730e-003,5.0964355e-003,5.9204102e-003,5.2490234e-003,3.7231445e-003,1.7089844e-003,3.9672852e-004,-9.7656250e-004,-6.7138672e-004,1.1901855e-003,2.9602051e-003,5.8593750e-003,6.1035156e-003,5.4016113e-003,5.0659180e-003,3.3264160e-003,3.1127930e-003,1.8310547e-003,1.5258789e-004,-1.3732910e-003,-2.0446777e-003,-5.7983398e-004,1.7089844e-003,5.0354004e-003,6.0119629e-003,5.3100586e-003,3.8757324e-003,4.5776367e-004,-6.1035156e-005,-1.5258789e-004,7.9345703e-004,2.9907227e-003,2.8991699e-003,3.9062500e-003,4.2724609e-003,3.9367676e-003,3.9367676e-003,3.5095215e-003,3.2348633e-003,3.0212402e-003,4.3029785e-003,6.1035156e-003,7.9040527e-003,1.0406494e-002,1.0681152e-002,1.0284424e-002,1.0284424e-002,9.0026855e-003,8.5754395e-003,7.6293945e-003,6.8054199e-003,7.0495605e-003,7.2021484e-003,8.1481934e-003,8.6364746e-003,8.6364746e-003,7.7514648e-003,6.2561035e-003,6.3171387e-003,6.5307617e-003,7.0495605e-003,1.0162354e-002,1.0437012e-002,1.0223389e-002,9.8876953e-003,8.2702637e-003,7.8735352e-003,7.4157715e-003,7.5378418e-003,8.2092285e-003,9.3994141e-003,1.1322021e-002,1.2542725e-002,1.3336182e-002,1.2786865e-002,1.1260986e-002,1.0345459e-002,9.3688965e-003,9.1552734e-003,9.6130371e-003,8.6059570e-003,8.8500977e-003,9.2468262e-003,9.4909668e-003,1.0162354e-002,9.3078613e-003,7.0190430e-003,4.7607422e-003,4.5471191e-003,5.0659180e-003,6.9580078e-003,9.4909668e-003,8.8806152e-003,8.0261230e-003,7.1105957e-003,5.9204102e-003,7.5988770e-003,9.2773438e-003,8.5144043e-003,7.5683594e-003,5.5847168e-003,3.9062500e-003,3.9978027e-003,3.9062500e-003,3.1127930e-003,3.0517578e-003,2.5939941e-003,2.4414063e-003,4.1198730e-003,5.7373047e-003,6.7443848e-003,7.3242188e-003,7.7819824e-003,7.8735352e-003,9.1247559e-003,9.5214844e-003,7.5683594e-003,5.5847168e-003,3.6621094e-003,3.7841797e-003,5.7678223e-003,8.7890625e-003,1.0070801e-002,1.0925293e-002,9.6740723e-003,6.6223145e-003,5.9814453e-003,4.7302246e-003,4.6997070e-003,5.8898926e-003,6.2866211e-003,7.8735352e-003,8.3618164e-003,7.6599121e-003,5.5847168e-003,2.8381348e-003,2.1667480e-003,2.4719238e-003,4.6691895e-003,7.5988770e-003,7.5378418e-003,7.9345703e-003,7.2937012e-003,5.7067871e-003,7.1105957e-003,7.6904297e-003,6.8664551e-003,5.7678223e-003,3.6621094e-003,2.2277832e-003,3.1738281e-003,4.3029785e-003,5.6762695e-003,7.3242188e-003,7.2631836e-003,6.2561035e-003,5.2795410e-003,2.9907227e-003,1.4648438e-003,3.9672852e-004,7.3242188e-004,2.6855469e-003,3.7536621e-003,5.3405762e-003,4.4860840e-003,2.6855469e-003,1.8005371e-003,2.1362305e-004,1.2207031e-004,9.1552734e-005,-5.7983398e-004,1.2207031e-004,1.2207031e-004,2.1667480e-003,4.6386719e-003,5.9509277e-003,6.2255859e-003,5.7678223e-003,5.3405762e-003,4.3640137e-003,3.9062500e-003,3.2043457e-003,1.3427734e-003,2.4414063e-004,2.4414063e-004,1.2207031e-003,1.8310547e-003,1.8920898e-003,9.4604492e-004,-3.6621094e-004,3.9672852e-004,7.6293945e-004,1.6479492e-003,1.6174316e-003,-1.9836426e-003,-5.3405762e-003,-6.7138672e-003,-7.0190430e-003,-4.4250488e-003,-7.6293945e-004,-3.0517578e-005,3.6621094e-004,1.8310547e-004,-1.4038086e-003,-1.3732910e-003,-2.2583008e-003,-3.0517578e-003,-3.1738281e-003,-2.2583008e-003,-3.6621094e-004,1.4038086e-003,3.2958984e-003,2.9602051e-003,1.8005371e-003,2.7465820e-004,-1.6784668e-003,-2.1057129e-003,-2.3803711e-003,-2.5329590e-003,-1.6784668e-003,-1.2512207e-003,-8.5449219e-004,-1.2512207e-003,-2.1057129e-003,-2.8686523e-003,-3.6010742e-003,-3.2653809e-003,-2.4719238e-003,-2.0751953e-003,-1.1901855e-003,-2.1667480e-003,-2.2277832e-003,-2.1057129e-003,-2.3498535e-003,-2.8076172e-003,-3.5095215e-003,-4.4555664e-003,-4.7302246e-003,-3.5705566e-003,-2.0446777e-003,-1.4953613e-003,-4.5776367e-004,-3.9672852e-004,-8.5449219e-004,-6.1035156e-005,-6.1035156e-005,-4.5776367e-004,-1.0681152e-003,-2.2888184e-003,-3.3874512e-003,-3.4179688e-003,-3.6010742e-003,-4.1809082e-003,-4.1503906e-003,-4.1809082e-003,-3.2348633e-003,-1.2817383e-003,5.7983398e-004,6.4086914e-004,-2.1362305e-004,-1.0375977e-003,-2.1057129e-003,-1.7700195e-003,-6.7138672e-004,-1.0681152e-003,-6.1035156e-004,-9.7656250e-004,-1.3732910e-003,1.2207031e-004,6.7138672e-004,4.5776367e-004,4.2724609e-004,1.2207031e-004,9.1552734e-005,2.0751953e-003,3.5095215e-003,3.1127930e-003,2.2888184e-003,7.3242188e-004,-1.1596680e-003,-7.6293945e-004,-3.0517578e-005,2.1362305e-004,1.0375977e-003,1.7395020e-003,1.7089844e-003,3.2348633e-003,4.6997070e-003,3.9062500e-003,2.7160645e-003,1.4038086e-003,3.3569336e-004,1.3122559e-003,1.9836426e-003,1.1596680e-003,1.2512207e-003,1.0986328e-003,1.3732910e-003,3.4179688e-003,4.9133301e-003,4.4555664e-003,3.6621094e-003,2.4719238e-003,1.5869141e-003,2.3498535e-003,2.9602051e-003,1.4648438e-003,1.2207031e-004,-2.0446777e-003,-3.2043457e-003,-1.7089844e-003,-1.5258789e-004,1.0375977e-003,2.1972656e-003,2.0751953e-003,1.2512207e-003,1.7700195e-003,7.3242188e-004,-3.9672852e-004,-9.4604492e-004,-1.4648438e-003,-9.1552734e-004,-9.1552734e-005,6.7138672e-004,-8.2397461e-004,-2.4414063e-003,-3.4179688e-003,-4.3640137e-003,-3.2653809e-003,-2.1667480e-003,-1.7700195e-003,-1.0070801e-003,9.1552734e-005,9.4604492e-004,2.1362305e-003,1.9531250e-003,1.5258789e-004,-2.1667480e-003,-3.1433105e-003,-3.2348633e-003,-2.1972656e-003,-2.7465820e-004,-1.2512207e-003,-1.8920898e-003,-1.5563965e-003,-2.5939941e-003,-2.4719238e-003,-2.9907227e-003,-4.0893555e-003,-4.9438477e-003,-4.9133301e-003,-4.3945313e-003,-4.0588379e-003,-3.8452148e-003,-4.8217773e-003,-6.1645508e-003,-6.4392090e-003,-6.8969727e-003,-7.1105957e-003,-7.1716309e-003,-8.2092285e-003,-8.6669922e-003,-8.3007813e-003,-7.6599121e-003,-7.5378418e-003,-7.4462891e-003,-7.7819824e-003,-7.9650879e-003,-6.4697266e-003,-4.9743652e-003,-4.5776367e-003,-4.6081543e-003,-6.5917969e-003,-8.7890625e-003,-8.4838867e-003,-7.7209473e-003,-6.8054199e-003,-5.5847168e-003,-6.3476563e-003,-7.3547363e-003,-6.5917969e-003,-7.0495605e-003,-7.8430176e-003,-8.2702637e-003,-9.7961426e-003,-1.0437012e-002,-9.4299316e-003,-8.1481934e-003,-8.6059570e-003,-8.9416504e-003,-9.8571777e-003,-1.1138916e-002,-9.4299316e-003,-8.2092285e-003,-8.6364746e-003,-9.2773438e-003,-1.0864258e-002,-1.1566162e-002,-9.7045898e-003,-7.6599121e-003,-6.1340332e-003,-5.7678223e-003,-6.8054199e-003,-8.5144043e-003,-7.9650879e-003,-8.7280273e-003,-1.0253906e-002,-1.1291504e-002,-1.2390137e-002,-1.2268066e-002,-1.0009766e-002,-7.5378418e-003,-7.8125000e-003,-8.2092285e-003,-8.4228516e-003,-8.8806152e-003,-7.0800781e-003,-6.6528320e-003,-9.8876953e-003,-1.2878418e-002,-1.4526367e-002,-1.4556885e-002,-1.1871338e-002,-9.2773438e-003,-1.1596680e-002,-1.3519287e-002,-1.3031006e-002,-1.1779785e-002,-5.5236816e-003,-1.1596680e-003,-4.6386719e-003,-8.1787109e-003,-9.6435547e-003,-9.6130371e-003,-3.5705566e-003,3.6621094e-004,-6.2866211e-003,-1.3977051e-002,-1.9531250e-002,-2.1759033e-002,-1.1810303e-002,-1.8920898e-003,-4.3029785e-003,-7.5073242e-003,-1.3702393e-002,-1.8951416e-002,-7.4462891e-003,2.5634766e-003,3.3569336e-004,-3.2653809e-003,-1.5869141e-002,-2.6367188e-002,-1.7669678e-002,-7.2021484e-003,-3.6621094e-003,-8.2397461e-004,-1.2756348e-002,-2.4108887e-002,-1.6510010e-002,-1.0253906e-002,-3.4484863e-003,6.7138672e-004,-1.1413574e-002,-2.2277832e-002,-1.9012451e-002,-1.4160156e-002,-4.9743652e-003,3.0212402e-003,-6.8359375e-003,-1.6906738e-002,-1.8005371e-002,-1.8707275e-002,-9.3994141e-003,-4.8828125e-004,-7.1105957e-003,-1.3519287e-002,-1.7333984e-002,-2.0812988e-002,-1.2359619e-002,-4.1809082e-003,-5.4321289e-003,-6.2561035e-003,-1.0070801e-002,-1.4953613e-002,-1.1444092e-002,-8.3923340e-003,-8.6059570e-003,-8.0871582e-003,-1.1169434e-002,-1.3824463e-002,-1.2054443e-002,-1.0498047e-002,-9.6130371e-003,-8.2397461e-003,-8.3312988e-003,-8.6364746e-003,-8.2092285e-003,-8.4838867e-003,-7.6293945e-003,-6.2866211e-003,-5.1879883e-003,-3.9367676e-003,-5.2490234e-003,-7.7819824e-003,-9.7656250e-003,-1.0925293e-002,-8.0566406e-003,-3.8452148e-003,-1.6784668e-003,-6.7138672e-004,-3.0212402e-003,-6.6528320e-003,-7.0190430e-003,-5.5847168e-003,-4.8828125e-003,-4.2419434e-003,-7.0495605e-003,-9.2468262e-003,-8.4228516e-003,-6.8359375e-003,-4.0283203e-003,-2.3803711e-003,-4.2114258e-003,-7.6293945e-003,-9.3383789e-003,-1.1230469e-002,-9.9182129e-003,-7.0190430e-003,-5.9204102e-003,-4.0588379e-003,-4.1809082e-003,-5.6457520e-003,-6.8969727e-003,-9.4299316e-003,-9.6740723e-003,-9.0026855e-003,-8.6364746e-003,-7.9040527e-003,-9.7045898e-003,-1.1932373e-002,-1.1749268e-002,-1.2207031e-002,-1.0284424e-002,-8.8806152e-003,-1.0559082e-002,-1.2207031e-002,-1.2969971e-002,-1.2481689e-002,-8.9721680e-003,-5.8593750e-003,-7.8735352e-003,-1.0314941e-002,-1.3092041e-002,-1.5899658e-002,-1.3336182e-002,-1.0345459e-002,-1.0589600e-002,-1.0314941e-002,-1.2664795e-002,-1.5228271e-002,-1.2268066e-002,-1.0284424e-002,-1.0070801e-002,-1.0650635e-002,-1.4617920e-002,-1.8768311e-002,-1.7761230e-002,-1.5716553e-002,-1.2542725e-002,-8.4838867e-003,-9.7351074e-003,-1.0345459e-002,-1.1108398e-002,-1.3427734e-002,-1.3336182e-002,-1.2451172e-002,-1.2756348e-002,-1.2603760e-002,-1.3580322e-002,-1.4678955e-002,-1.5136719e-002,-1.5594482e-002,-1.3671875e-002,-1.0681152e-002,-8.1787109e-003,-6.3171387e-003,-8.1176758e-003,-1.0742188e-002,-1.2756348e-002,-1.4923096e-002,-1.5136719e-002,-1.5502930e-002,-1.7303467e-002,-1.7486572e-002,-1.6296387e-002,-1.3641357e-002,-9.2773438e-003,-6.1950684e-003,-7.9345703e-003,-1.2176514e-002,-1.5808105e-002,-2.0172119e-002,-1.9256592e-002,-1.7150879e-002,-1.8310547e-002,-1.7517090e-002,-1.9287109e-002,-2.0263672e-002,-1.6632080e-002,-1.3977051e-002,-1.1566162e-002,-1.0192871e-002,-1.1962891e-002,-1.3854980e-002,-1.3366699e-002,-1.2542725e-002,-1.2115479e-002,-1.0894775e-002,-1.2268066e-002,-1.3366699e-002,-1.2908936e-002,-1.2207031e-002,-1.0040283e-002,-8.3007813e-003,-7.7514648e-003,-9.0942383e-003,-8.7280273e-003,-9.8571777e-003,-1.1230469e-002,-1.2542725e-002,-1.4404297e-002,-1.5319824e-002,-1.6143799e-002,-1.5869141e-002,-1.5869141e-002,-1.4862061e-002,-1.4617920e-002,-1.4373779e-002,-1.4099121e-002,-1.5258789e-002,-1.6357422e-002,-1.8280029e-002,-1.9226074e-002,-1.9287109e-002,-1.7883301e-002,-1.5258789e-002,-1.3763428e-002,-1.2756348e-002,-1.2725830e-002,-1.3610840e-002,-1.4404297e-002,-1.6357422e-002,-1.8463135e-002,-2.0233154e-002,-2.1423340e-002,-2.0263672e-002,-1.8585205e-002,-1.5625000e-002,-1.4495850e-002,-1.4556885e-002,-1.5167236e-002,-1.6967773e-002,-1.5533447e-002,-1.4312744e-002,-1.3366699e-002,-1.2176514e-002,-1.4099121e-002,-1.5411377e-002,-1.5411377e-002,-1.5319824e-002,-1.3763428e-002,-1.2115479e-002,-1.2634277e-002,-1.2969971e-002,-1.3580322e-002,-1.3854980e-002,-1.2817383e-002,-1.1993408e-002,-1.2084961e-002,-1.2207031e-002,-1.3183594e-002,-1.3977051e-002,-1.3275146e-002,-1.3671875e-002,-1.2451172e-002,-1.1718750e-002,-1.1657715e-002,-1.1291504e-002,-1.0009766e-002,-9.4909668e-003,-9.5825195e-003,-1.0467529e-002,-1.2664795e-002,-1.4953613e-002,-1.6113281e-002,-1.6296387e-002,-1.5594482e-002,-1.3488770e-002,-1.3031006e-002,-1.1993408e-002,-1.1932373e-002,-1.3244629e-002,-1.3397217e-002,-1.4495850e-002,-1.4495850e-002,-1.4099121e-002,-1.4068604e-002,-1.3153076e-002,-1.2420654e-002,-1.1810303e-002,-1.1779785e-002,-1.1260986e-002,-1.1016846e-002,-1.0894775e-002,-1.0650635e-002,-1.0467529e-002,-1.0284424e-002,-9.5520020e-003,-9.0026855e-003,-8.7585449e-003,-9.1247559e-003,-1.0620117e-002,-1.2756348e-002,-1.5197754e-002,-1.6113281e-002,-1.6052246e-002,-1.4221191e-002,-1.1383057e-002,-9.4299316e-003,-7.8430176e-003,-7.7209473e-003,-9.3994141e-003,-1.0162354e-002,-1.2359619e-002,-1.2695313e-002,-1.2603760e-002,-1.3122559e-002,-1.3732910e-002,-1.5136719e-002,-1.5350342e-002,-1.5899658e-002,-1.6235352e-002,-1.5228271e-002,-1.3793945e-002,-1.2603760e-002,-1.1535645e-002,-1.1138916e-002,-1.1230469e-002,-1.2115479e-002,-1.3916016e-002,-1.6265869e-002,-1.8371582e-002,-1.9531250e-002,-1.9042969e-002,-1.7181396e-002,-1.3671875e-002,-1.1413574e-002,-9.6740723e-003,-9.0637207e-003,-1.0589600e-002,-1.1322021e-002,-1.3214111e-002,-1.3702393e-002,-1.3610840e-002,-1.3000488e-002,-1.0986328e-002,-1.0528564e-002,-1.0681152e-002,-1.2176514e-002,-1.5014648e-002,-1.6540527e-002,-1.8646240e-002,-1.9744873e-002,-1.9744873e-002,-1.9989014e-002,-1.9042969e-002,-1.7944336e-002,-1.5899658e-002,-1.3702393e-002,-1.2176514e-002,-1.2023926e-002,-1.2908936e-002,-1.3214111e-002,-1.4099121e-002,-1.3610840e-002,-1.1657715e-002,-1.1505127e-002,-1.0375977e-002,-1.0406494e-002,-1.1413574e-002,-1.2054443e-002,-1.2573242e-002,-1.2481689e-002,-1.2084961e-002,-1.2634277e-002,-1.2115479e-002,-1.1810303e-002,-1.2359619e-002,-1.3458252e-002,-1.4648438e-002,-1.4678955e-002,-1.5197754e-002,-1.4587402e-002,-1.3854980e-002,-1.3397217e-002,-1.2268066e-002,-1.1657715e-002,-1.1413574e-002,-1.1535645e-002,-1.2359619e-002,-1.3214111e-002,-1.4831543e-002,-1.5960693e-002,-1.6448975e-002,-1.6296387e-002,-1.5014648e-002,-1.4282227e-002,-1.2512207e-002,-1.0772705e-002,-9.8876953e-003,-9.5214844e-003,-1.0284424e-002,-1.1077881e-002,-1.2298584e-002,-1.3519287e-002,-1.4007568e-002,-1.4343262e-002,-1.3641357e-002,-1.2786865e-002,-1.1413574e-002,-1.0040283e-002,-9.6740723e-003,-1.0162354e-002,-1.1810303e-002,-1.2359619e-002,-1.2664795e-002,-1.1383057e-002,-9.9792480e-003,-1.0375977e-002,-1.0589600e-002,-1.1901855e-002,-1.3183594e-002,-1.3763428e-002,-1.4495850e-002,-1.5747070e-002,-1.6937256e-002,-1.7883301e-002,-1.6784668e-002,-1.3397217e-002,-9.8571777e-003,-8.7280273e-003,-1.0040283e-002,-1.2542725e-002,-1.6632080e-002,-1.6113281e-002,-1.4068604e-002,-1.0162354e-002,-4.9438477e-003,-5.4016113e-003,-7.1716309e-003,-1.0498047e-002,-1.5502930e-002,-1.5594482e-002,-1.4373779e-002,-1.1810303e-002,-7.2631836e-003,-5.7983398e-003,-4.5776367e-003,-5.0048828e-003,-8.3007813e-003,-1.0040283e-002,-1.2603760e-002,-1.2939453e-002,-1.1840820e-002,-1.1535645e-002,-9.9487305e-003,-1.0101318e-002,-1.0131836e-002,-1.0955811e-002,-1.2725830e-002,-1.3275146e-002,-1.4648438e-002,-1.5319824e-002,-1.5014648e-002,-1.4617920e-002,-1.2878418e-002,-1.2084961e-002,-1.0803223e-002,-9.7961426e-003,-9.7656250e-003,-9.6435547e-003,-1.0437012e-002,-1.0803223e-002,-1.0620117e-002,-9.3078613e-003,-7.2326660e-003,-6.8969727e-003,-6.9274902e-003,-9.7961426e-003,-1.3916016e-002,-1.5808105e-002,-1.6693115e-002,-1.4221191e-002,-9.5520020e-003,-7.2937012e-003,-5.0659180e-003,-5.4016113e-003,-8.3312988e-003,-1.0589600e-002,-1.3916016e-002,-1.5228271e-002,-1.6143799e-002,-1.6601563e-002,-1.4739990e-002,-1.2664795e-002,-9.4604492e-003,-7.6293945e-003,-7.5683594e-003,-8.6364746e-003,-1.2115479e-002,-1.3702393e-002,-1.5655518e-002,-1.6662598e-002,-1.6387939e-002,-1.7120361e-002,-1.5899658e-002,-1.4862061e-002,-1.3092041e-002,-1.0681152e-002,-9.1247559e-003,-8.0566406e-003,-8.6364746e-003,-7.9040527e-003,-7.0495605e-003,-5.9509277e-003,-4.8828125e-003,-6.4086914e-003,-8.3007813e-003,-1.1077881e-002,-1.3214111e-002,-1.2939453e-002,-1.1047363e-002,-9.3078613e-003,-6.6528320e-003,-5.7373047e-003,-4.8522949e-003,-2.8076172e-003,-2.4414063e-003,-2.3193359e-003,-4.2114258e-003,-7.2937012e-003,-1.0375977e-002,-1.1444092e-002,-1.0833740e-002,-9.6130371e-003,-7.2937012e-003,-7.2021484e-003,-7.5988770e-003,-7.3547363e-003,-7.4768066e-003,-5.7983398e-003,-5.1269531e-003,-5.9814453e-003,-6.9885254e-003,-8.5449219e-003,-7.2326660e-003,-5.8898926e-003,-4.1503906e-003,-4.3640137e-003,-5.1879883e-003,-6.7443848e-003,-8.8195801e-003,-8.5449219e-003,-8.7280273e-003,-8.8195801e-003,-8.0871582e-003,-7.9040527e-003,-6.8969727e-003,-5.7373047e-003,-5.0964355e-003,-5.5236816e-003,-6.6223145e-003,-7.3852539e-003,-8.5144043e-003,-7.9345703e-003,-6.9885254e-003,-7.1105957e-003,-6.2255859e-003,-6.1645508e-003,-5.9204102e-003,-5.3405762e-003,-5.8288574e-003,-6.7443848e-003,-8.2702637e-003,-8.2397461e-003,-7.7819824e-003,-6.8359375e-003,-6.0729980e-003,-7.7514648e-003,-9.7351074e-003,-1.1077881e-002,-1.1657715e-002,-9.2468262e-003,-5.3710938e-003,-4.0893555e-003,-2.7770996e-003,-4.0588379e-003,-6.6833496e-003,-8.0871582e-003,-1.0345459e-002,-1.1627197e-002,-1.2268066e-002,-1.2542725e-002,-1.0742188e-002,-8.0566406e-003,-5.2185059e-003,-3.4484863e-003,-2.7160645e-003,-2.6855469e-003,-3.9978027e-003,-4.4860840e-003,-5.0048828e-003,-6.6833496e-003,-7.1716309e-003,-7.5073242e-003,-8.2397461e-003,-8.9111328e-003,-9.1857910e-003,-9.8571777e-003,-1.0528564e-002,-1.0253906e-002,-9.5825195e-003,-7.4768066e-003,-5.2490234e-003,-3.8757324e-003,-2.7160645e-003,-1.7089844e-003,-2.1667480e-003,-2.1972656e-003,-2.7160645e-003,-4.1198730e-003,-5.5847168e-003,-7.1105957e-003,-8.3618164e-003,-9.7656250e-003,-9.9792480e-003,-1.0559082e-002,-1.0772705e-002,-9.0026855e-003,-7.5378418e-003,-5.8288574e-003,-5.0354004e-003,-5.5236816e-003,-7.2631836e-003,-7.0495605e-003,-6.9274902e-003,-5.6152344e-003,-3.1433105e-003,-3.7231445e-003,-3.6926270e-003,-3.6315918e-003,-4.1503906e-003,-2.1972656e-003,-8.2397461e-004,-9.7656250e-004,-1.1291504e-003,-1.7395020e-003,-2.6855469e-003,-2.0141602e-003,-1.2207031e-003,-1.0070801e-003,-3.9672852e-004,-7.9345703e-004,-1.6174316e-003,-1.4343262e-003,-1.7089844e-003,-2.0446777e-003,-3.4179688e-003,-4.2114258e-003,-5.2185059e-003,-5.8288574e-003,-5.8593750e-003,-4.9743652e-003,-3.1738281e-003,-1.7395020e-003,-4.2724609e-004,-9.4604492e-004,-2.8381348e-003,-5.0964355e-003,-7.4157715e-003,-8.4838867e-003,-8.5144043e-003,-8.4228516e-003,-7.3547363e-003,-7.6904297e-003,-7.9956055e-003,-7.4157715e-003,-7.8735352e-003,-7.0495605e-003,-6.6528320e-003,-7.5988770e-003,-8.0261230e-003,-8.6364746e-003,-8.2092285e-003,-5.8288574e-003,-2.5329590e-003,-1.2207031e-004,2.1667480e-003,1.4953613e-003,-1.2207031e-003,-2.5939941e-003,-3.9978027e-003,-3.1127930e-003,-1.0986328e-003,-1.3732910e-003,-1.1291504e-003,-2.9296875e-003,-6.1950684e-003,-6.8664551e-003,-7.2937012e-003,-6.9885254e-003,-6.4392090e-003,-7.2631836e-003,-7.6293945e-003,-7.3242188e-003,-6.6833496e-003,-5.8898926e-003,-5.1269531e-003,-5.8898926e-003,-6.3476563e-003,-5.6762695e-003,-4.4555664e-003,-2.9907227e-003,-1.5258789e-003,-2.4108887e-003,-4.2114258e-003,-2.7465820e-003,-1.8310547e-003,-2.4414063e-004,8.2397461e-004,-1.2207031e-003,-3.8146973e-003,-4.8522949e-003,-5.4931641e-003,-4.4250488e-003,-2.1972656e-003,-2.5329590e-003,-1.8615723e-003,-8.2397461e-004,-3.3569336e-004,2.4108887e-003,3.9062500e-003,2.6550293e-003,7.3242188e-004,-8.8500977e-004,-2.0446777e-003,-7.6293945e-004,9.4604492e-004,9.4604492e-004,1.7700195e-003,2.8686523e-003,3.2653809e-003,4.3334961e-003,3.3874512e-003,-2.1362305e-004,-4.0893555e-003,-6.2866211e-003,-6.5612793e-003,-4.3029785e-003,-3.6621094e-004,-7.0190430e-004,-1.6174316e-003,-3.0517578e-003,-5.2490234e-003,-2.6245117e-003,2.7465820e-004,1.5869141e-003,3.1433105e-003,1.8005371e-003,-5.1879883e-004,6.1035156e-005,1.8310547e-004,1.8310547e-004,7.9345703e-004,-4.2724609e-004,-1.5869141e-003,-1.1596680e-003,-3.9672852e-004,1.3427734e-003,2.8686523e-003,4.6691895e-003,7.0495605e-003,7.5683594e-003,6.7443848e-003,5.0354004e-003,3.0212402e-003,2.5634766e-003,3.2653809e-003,5.0354004e-003,8.0566406e-003,9.3994141e-003,1.0498047e-002,1.0681152e-002,8.6364746e-003,6.4697266e-003,2.5024414e-003,-4.8828125e-004,-2.1667480e-003,-1.3122559e-003,1.6174316e-003,2.7770996e-003,4.3945313e-003,3.9978027e-003,3.9062500e-003,6.1645508e-003,5.8593750e-003,1.3122559e-003,-7.6904297e-003,-2.1820068e-002,-3.4088135e-002,-3.3355713e-002,-2.2338867e-002,-2.8381348e-003,2.2735596e-002,3.4393311e-002,3.9764404e-002,3.9245605e-002,2.6245117e-002,1.9561768e-002,6.1340332e-003,-1.1108398e-002,-2.4200439e-002,-3.9001465e-002,-4.1412354e-002,-3.2470703e-002,-1.3031006e-002,7.2631836e-003,2.6824951e-002,3.9245605e-002,3.9337158e-002,4.1076660e-002,3.0090332e-002,1.9622803e-002,7.9650879e-003,-8.0871582e-003,-1.5625000e-002,-2.4383545e-002,-2.2460938e-002,-1.8432617e-002,-1.0498047e-002,-1.2207031e-003,6.0119629e-003,1.7547607e-002,2.1545410e-002,2.6458740e-002,2.4353027e-002,1.9042969e-002,1.1749268e-002,2.8381348e-003,-3.9062500e-003,-1.2786865e-002,-1.6052246e-002,-2.1209717e-002,-2.1484375e-002,-1.6906738e-002,-9.3688965e-003,2.8381348e-003,1.3610840e-002,2.4353027e-002,2.9693604e-002,3.2958984e-002,2.9602051e-002,2.3468018e-002,1.4282227e-002,1.7395020e-003,-7.1411133e-003,-1.5808105e-002,-1.6571045e-002,-1.4556885e-002,-7.1105957e-003,5.7983398e-004,7.9040527e-003,1.7333984e-002,2.0568848e-002,2.6580811e-002,2.5756836e-002,2.2308350e-002,1.6326904e-002,7.1411133e-003,3.6621094e-004,-5.9509277e-003,-6.4086914e-003,-8.4533691e-003,-5.9204102e-003,-4.6691895e-003,-2.6550293e-003,4.2724609e-003,9.0637207e-003,1.6662598e-002,2.0050049e-002,1.9775391e-002,1.5899658e-002,9.2163086e-003,1.0375977e-003,-3.9062500e-003,-6.5307617e-003,-1.0375977e-002,-9.7045898e-003,-9.6740723e-003,-6.9274902e-003,-1.0681152e-003,4.3334961e-003,1.1474609e-002,1.6296387e-002,2.0782471e-002,2.1606445e-002,2.0538330e-002,1.6998291e-002,1.1505127e-002,6.8359375e-003,3.1127930e-003,1.7089844e-003,-4.8828125e-004,3.3569336e-004,-9.1552734e-005,2.4414063e-004,3.8146973e-003,6.5917969e-003,1.2786865e-002,1.7181396e-002,1.9195557e-002,1.9042969e-002,1.6876221e-002,1.3122559e-002,9.3994141e-003,6.1035156e-003,2.7465820e-004,-2.8686523e-003,-5.8288574e-003,-6.1950684e-003,-3.5400391e-003,3.0517578e-004,4.7302246e-003,8.7280273e-003,1.3793945e-002,1.6296387e-002,1.9592285e-002,1.9439697e-002,1.6326904e-002,1.2664795e-002,8.5754395e-003,6.4392090e-003,5.0354004e-003,5.6762695e-003,2.7160645e-003,1.3122559e-003,6.1035156e-004,1.1901855e-003,7.6904297e-003,1.4862061e-002,1.9958496e-002,2.3254395e-002,2.3681641e-002,2.0111084e-002,1.8218994e-002,1.4770508e-002,1.0742188e-002,8.4838867e-003,3.9672852e-003,2.8686523e-003,3.1127930e-003,5.5541992e-003,9.0637207e-003,1.2725830e-002,1.5777588e-002,1.6906738e-002,1.9653320e-002,1.9012451e-002,1.8035889e-002,1.5930176e-002,1.1962891e-002,9.5520020e-003,7.9956055e-003,7.9040527e-003,6.8969727e-003,7.4768066e-003,7.1105957e-003,7.0495605e-003,1.0498047e-002,1.3153076e-002,1.7578125e-002,2.1026611e-002,2.2521973e-002,2.2705078e-002,2.2308350e-002,2.0629883e-002,1.7486572e-002,1.3977051e-002,8.5754395e-003,4.3334961e-003,5.4931641e-004,-1.1596680e-003,-4.2724609e-004,2.1057129e-003,6.6833496e-003,1.1932373e-002,1.7761230e-002,2.1331787e-002,2.3406982e-002,2.1606445e-002,1.8157959e-002,1.3305664e-002,8.2092285e-003,6.0119629e-003,3.8452148e-003,6.1035156e-003,7.5683594e-003,1.1138916e-002,1.5228271e-002,1.6571045e-002,1.8798828e-002,1.8157959e-002,2.0782471e-002,2.2399902e-002,2.4291992e-002,2.5421143e-002,2.3254395e-002,2.0599365e-002,1.6510010e-002,1.2939453e-002,1.2084961e-002,1.2756348e-002,1.2176514e-002,1.2756348e-002,1.2664795e-002,1.2512207e-002,1.5411377e-002,1.8005371e-002,2.1331787e-002,2.4536133e-002,2.5299072e-002,2.4566650e-002,2.3132324e-002,2.1240234e-002,1.8676758e-002,1.5899658e-002,1.2145996e-002,9.4909668e-003,7.4462891e-003,6.4392090e-003,6.8054199e-003,8.1176758e-003,1.1169434e-002,1.4404297e-002,1.7852783e-002,2.0294189e-002,2.1270752e-002,2.0721436e-002,1.9989014e-002,1.8768311e-002,1.7822266e-002,1.7883301e-002,1.6326904e-002,1.5197754e-002,1.3275146e-002,1.1138916e-002,1.0467529e-002,1.0131836e-002,1.1962891e-002,1.4801025e-002,1.8615723e-002,2.2338867e-002,2.4200439e-002,2.4505615e-002,2.3071289e-002,2.0477295e-002,1.8981934e-002,1.6845703e-002,1.3885498e-002,1.2390137e-002,9.5825195e-003,8.6059570e-003,9.8571777e-003,1.2298584e-002,1.5625000e-002,1.8066406e-002,1.9012451e-002,1.8280029e-002,2.0263672e-002,2.0965576e-002,2.2064209e-002,2.2460938e-002,1.7791748e-002,1.3397217e-002,9.1552734e-003,6.9580078e-003,8.4228516e-003,1.2268066e-002,1.3427734e-002,1.5533447e-002,1.7730713e-002,1.8341064e-002,2.2674561e-002,2.4871826e-002,2.4871826e-002,2.3986816e-002,2.1667480e-002,2.0050049e-002,2.0874023e-002,2.2613525e-002,2.1179199e-002,1.9409180e-002,1.5838623e-002,1.2451172e-002,1.4678955e-002,1.7883301e-002,2.0904541e-002,2.3712158e-002,2.2369385e-002,1.9348145e-002,1.9073486e-002,1.7364502e-002,1.7242432e-002,1.8280029e-002,1.5808105e-002,1.4831543e-002,1.4587402e-002,1.4739990e-002,1.6571045e-002,1.6754150e-002,1.7669678e-002,1.8218994e-002,1.9195557e-002,1.9653320e-002,2.1118164e-002,2.2888184e-002,2.3651123e-002,2.4505615e-002,2.4627686e-002,2.4444580e-002,2.3315430e-002,2.1484375e-002,1.8371582e-002,1.5472412e-002,1.4709473e-002,1.5625000e-002,1.7700195e-002,2.0690918e-002,2.2338867e-002,2.3132324e-002,2.4383545e-002,2.4108887e-002,2.5848389e-002,2.7099609e-002,2.6855469e-002,2.6153564e-002,2.3345947e-002,2.0385742e-002,1.8249512e-002,1.7089844e-002,1.6082764e-002,1.6540527e-002,1.6723633e-002,1.7272949e-002,1.8218994e-002,1.8707275e-002,1.9927979e-002,2.0446777e-002,2.0324707e-002,1.9927979e-002,2.0141602e-002,2.0904541e-002,2.1881104e-002,2.3315430e-002,2.2796631e-002,2.1606445e-002,1.9836426e-002,1.7456055e-002,1.6387939e-002,1.5991211e-002,1.5808105e-002,1.6632080e-002,1.6754150e-002,1.7303467e-002,1.8280029e-002,1.8493652e-002,1.8341064e-002,1.6784668e-002,1.7059326e-002,1.6937256e-002,1.7761230e-002,1.9287109e-002,1.9866943e-002,2.0233154e-002,1.9775391e-002,1.9317627e-002,2.0751953e-002,2.2674561e-002,2.4597168e-002,2.6062012e-002,2.5390625e-002,2.4139404e-002,2.3651123e-002,2.3162842e-002,2.3071289e-002,2.3132324e-002,2.1240234e-002,1.9226074e-002,1.8005371e-002,1.6937256e-002,1.8035889e-002,1.9622803e-002,2.0568848e-002,2.0996094e-002,2.0660400e-002,1.9836426e-002,2.0172119e-002,2.0568848e-002,2.1575928e-002,2.3010254e-002,2.2613525e-002,2.2094727e-002,2.0538330e-002,1.8310547e-002,1.7425537e-002,1.6876221e-002,1.6998291e-002,1.7913818e-002,1.8035889e-002,1.8341064e-002,1.8768311e-002,1.8188477e-002,1.8768311e-002,1.8554688e-002,1.7913818e-002,1.7059326e-002,1.6662598e-002,1.6662598e-002,1.7608643e-002,1.8676758e-002,1.9165039e-002,1.9042969e-002,1.9317627e-002,2.0996094e-002,2.2155762e-002,2.3101807e-002,2.2186279e-002,2.0019531e-002,1.7242432e-002,1.4709473e-002,1.4739990e-002,1.4892578e-002,1.4221191e-002,1.4068604e-002,1.2878418e-002,1.2207031e-002,1.4709473e-002,1.7395020e-002,1.9989014e-002,2.2247314e-002,2.2155762e-002,2.1057129e-002,2.1759033e-002,2.2735596e-002,2.3620605e-002,2.5329590e-002,2.3681641e-002,2.2155762e-002,2.1423340e-002,1.9470215e-002,1.9287109e-002,1.8554688e-002,1.6571045e-002,1.5228271e-002,1.4892578e-002,1.4953613e-002,1.6693115e-002,1.8981934e-002,1.9775391e-002,2.0935059e-002,2.2583008e-002,2.3925781e-002,2.6092529e-002,2.7709961e-002,2.6763916e-002,2.4902344e-002,2.1881104e-002,1.8829346e-002,1.7364502e-002,1.6876221e-002,1.6906738e-002,1.8280029e-002,1.9439697e-002,2.0050049e-002,2.0904541e-002,2.0294189e-002,1.9653320e-002,1.9042969e-002,1.9042969e-002,1.9866943e-002,2.1331787e-002,2.2491455e-002,2.1484375e-002,2.0721436e-002,2.0294189e-002,1.9897461e-002,2.0904541e-002,2.2125244e-002,2.1911621e-002,2.1209717e-002,2.0812988e-002,1.9958496e-002,2.1270752e-002,2.2918701e-002,2.4536133e-002,2.5695801e-002,2.5360107e-002,2.3315430e-002,2.0660400e-002,1.7456055e-002,1.5258789e-002,1.4282227e-002,1.4404297e-002,1.6448975e-002,1.7547607e-002,1.9256592e-002,2.0599365e-002,2.1362305e-002,2.3345947e-002,2.4017334e-002,2.4688721e-002,2.4566650e-002,2.2583008e-002,2.0660400e-002,1.8951416e-002,1.8188477e-002,1.8096924e-002,1.8585205e-002,1.7395020e-002,1.6113281e-002,1.4617920e-002,1.2512207e-002,1.2145996e-002,1.1993408e-002,1.2512207e-002,1.4495850e-002,1.5808105e-002,1.7608643e-002,1.8859863e-002,1.9714355e-002,1.9775391e-002,1.9104004e-002,1.8859863e-002,1.8585205e-002,1.7791748e-002,1.6357422e-002,1.6235352e-002,1.5563965e-002,1.5747070e-002,1.6174316e-002,1.6784668e-002,1.7333984e-002,1.7150879e-002,1.6326904e-002,1.6265869e-002,1.6967773e-002,1.7547607e-002,1.8371582e-002,1.7669678e-002,1.5899658e-002,1.4556885e-002,1.3031006e-002,1.3916016e-002,1.5045166e-002,1.5808105e-002,1.7761230e-002,1.7883301e-002,1.7730713e-002,1.8920898e-002,1.8341064e-002,1.8554688e-002,1.8371582e-002,1.8188477e-002,1.8341064e-002,1.8463135e-002,1.8829346e-002,1.8371582e-002,1.8737793e-002,1.9195557e-002,2.0751953e-002,2.2521973e-002,2.3681641e-002,2.3895264e-002,2.3406982e-002,2.2644043e-002,2.0721436e-002,2.0355225e-002,1.9805908e-002,1.8585205e-002,1.7333984e-002,1.5502930e-002,1.3824463e-002,1.3397217e-002,1.4160156e-002,1.5594482e-002,1.7913818e-002,1.9683838e-002,2.1545410e-002,2.2460938e-002,2.2460938e-002,2.1942139e-002,2.0935059e-002,1.9134521e-002,1.7578125e-002,1.6479492e-002,1.5594482e-002,1.5228271e-002,1.4892578e-002,1.6265869e-002,1.7791748e-002,1.9683838e-002,2.0568848e-002,2.0080566e-002,1.7883301e-002,1.5625000e-002,1.3061523e-002,1.1260986e-002,1.1413574e-002,1.1413574e-002,1.3397217e-002,1.4282227e-002,1.5411377e-002,1.6326904e-002,1.5838623e-002,1.5625000e-002,1.4495850e-002,1.4678955e-002,1.5747070e-002,1.6510010e-002,1.7547607e-002,1.7791748e-002,1.7456055e-002,1.7883301e-002,1.7669678e-002,1.7395020e-002,1.6937256e-002,1.5014648e-002,1.2329102e-002,1.0009766e-002,8.3312988e-003,9.0942383e-003,1.1444092e-002,1.3153076e-002,1.5136719e-002,1.5014648e-002,1.4068604e-002,1.4465332e-002,1.4007568e-002,1.4648438e-002,1.5136719e-002,1.4160156e-002,1.2603760e-002,1.1566162e-002,1.2145996e-002,1.4068604e-002,1.7303467e-002,1.9500732e-002,2.1545410e-002,2.1240234e-002,1.8890381e-002,1.8432617e-002,1.5869141e-002,1.4495850e-002,1.3458252e-002,1.2207031e-002,1.1871338e-002,1.1230469e-002,1.1840820e-002,1.3000488e-002,1.3916016e-002,1.6296387e-002,1.8188477e-002,2.0355225e-002,2.1759033e-002,2.1820068e-002,2.0843506e-002,1.9866943e-002,1.9104004e-002,1.9165039e-002,2.0446777e-002,2.0080566e-002,1.9348145e-002,1.6510010e-002,1.2664795e-002,1.1474609e-002,1.1230469e-002,1.3610840e-002,1.7028809e-002,1.8402100e-002,1.9348145e-002,1.9378662e-002,1.7944336e-002,1.9073486e-002,1.9561768e-002,1.9287109e-002,1.8798828e-002,1.5594482e-002,1.2847900e-002,1.1169434e-002,1.0650635e-002,1.2084961e-002,1.5075684e-002,1.7730713e-002,2.0599365e-002,2.1820068e-002,2.1301270e-002,2.0965576e-002,1.9226074e-002,1.8646240e-002,1.8615723e-002,1.7608643e-002,1.7150879e-002,1.4038086e-002,1.1260986e-002,9.6435547e-003,9.2468262e-003,1.1596680e-002,1.4526367e-002,1.5960693e-002,1.5747070e-002,1.5045166e-002,1.3366699e-002,1.4984131e-002,1.6754150e-002,1.6662598e-002,1.7120361e-002,1.4984131e-002,1.3305664e-002,1.4495850e-002,1.6143799e-002,1.7517090e-002,1.8402100e-002,1.6510010e-002,1.3702393e-002,1.3519287e-002,1.2939453e-002,1.3183594e-002,1.4068604e-002,1.2329102e-002,1.0986328e-002,1.1047363e-002,1.1657715e-002,1.2756348e-002,1.2969971e-002,1.0742188e-002,8.3312988e-003,7.8735352e-003,8.0566406e-003,9.9792480e-003,1.2451172e-002,1.2603760e-002,1.2573242e-002,1.2420654e-002,1.1566162e-002,1.1779785e-002,1.1108398e-002,9.2468262e-003,6.8969727e-003,5.1269531e-003,4.4555664e-003,5.3710938e-003,7.8735352e-003,9.1552734e-003,1.1138916e-002,1.1657715e-002,1.0925293e-002,9.5520020e-003,6.5917969e-003,4.1503906e-003,2.8686523e-003,4.8217773e-003,8.2397461e-003,1.2908936e-002,1.7456055e-002,1.6723633e-002,1.4465332e-002,1.3336182e-002,1.0131836e-002,9.6435547e-003,9.7045898e-003,9.1552734e-003,1.0864258e-002,1.1779785e-002,1.3580322e-002,1.3732910e-002,1.2847900e-002,1.1199951e-002,8.6364746e-003,8.5144043e-003,9.0332031e-003,1.0192871e-002,1.2207031e-002,1.2908936e-002,1.3427734e-002,1.4892578e-002,1.5014648e-002,1.3916016e-002,1.1230469e-002,7.3547363e-003,4.6386719e-003,6.1340332e-003,9.9792480e-003,1.4099121e-002,1.9653320e-002,2.0355225e-002,1.9470215e-002,1.9622803e-002,1.6693115e-002,1.3427734e-002,7.9040527e-003,-1.3732910e-003,-9.5214844e-003,-1.2054443e-002,-8.7890625e-003,3.0517578e-004,1.3397217e-002,2.1118164e-002,2.5970459e-002,2.8045654e-002,2.4047852e-002,2.5177002e-002,2.3956299e-002,2.2644043e-002,2.3376465e-002,1.9958496e-002,1.9134521e-002,1.7028809e-002,1.5319824e-002,1.2756348e-002,8.1176758e-003,5.4016113e-003,6.1035156e-004,-2.8076172e-003,-6.1645508e-003,-8.1481934e-003,-7.9650879e-003,-5.3710938e-003,3.0517578e-005,5.2490234e-003,1.0711670e-002,1.1627197e-002,1.0009766e-002,8.9721680e-003,7.1411133e-003,8.9416504e-003,1.2847900e-002,1.5014648e-002,1.9073486e-002,2.0019531e-002,1.9378662e-002,1.7944336e-002,1.3671875e-002,9.1857910e-003,3.7536621e-003,5.4931641e-004,-7.0190430e-004,-7.0190430e-004,1.9226074e-003,1.9226074e-003,2.4414063e-003,2.9907227e-003,1.8310547e-003,3.0212402e-003,2.8991699e-003,2.5329590e-003,3.4484863e-003,5.2185059e-003,9.2773438e-003,1.4373779e-002,1.9805908e-002,2.2094727e-002,2.2308350e-002,2.0782471e-002,1.6815186e-002,1.5716553e-002,1.4038086e-002,1.0833740e-002,8.4228516e-003,3.9672852e-003,3.6621094e-004,-1.5258789e-004,9.1552734e-005,1.8310547e-003,2.9907227e-003,2.4108887e-003,1.4343262e-003,6.1035156e-005,-1.6784668e-003,-5.7983398e-004,2.8381348e-003,6.1950684e-003,1.2115479e-002,1.6082764e-002,1.9134521e-002,2.0690918e-002,1.9989014e-002,1.9744873e-002,1.8005371e-002,1.6784668e-002,1.4404297e-002,1.1596680e-002,1.0437012e-002,9.0637207e-003,8.5144043e-003,7.5683594e-003,6.5002441e-003,4.3945313e-003,1.5258789e-003,-7.3242188e-004,-3.1127930e-003,-3.8757324e-003,-4.1503906e-003,-4.6997070e-003,-3.5400391e-003,-1.3122559e-003,2.3803711e-003,8.3007813e-003,1.3763428e-002,1.7486572e-002,1.8859863e-002,1.8524170e-002,1.5930176e-002,1.4648438e-002,1.3305664e-002,1.2145996e-002,1.1962891e-002,8.9416504e-003,6.6223145e-003,4.3640137e-003,2.6245117e-003,3.2043457e-003,3.3874512e-003,3.9062500e-003,3.7841797e-003,2.4414063e-003,5.7983398e-004,5.7983398e-004,7.6293945e-004,2.3803711e-003,4.9743652e-003,5.8288574e-003,6.3476563e-003,7.6904297e-003,9.2773438e-003,1.2237549e-002,1.5655518e-002,1.7883301e-002,1.9805908e-002,1.9500732e-002,1.7303467e-002,1.5045166e-002,1.2054443e-002,9.0026855e-003,6.8664551e-003,4.4860840e-003,3.4790039e-003,2.7770996e-003,2.4414063e-003,2.9296875e-003,3.1433105e-003,3.8757324e-003,3.2653809e-003,2.7160645e-003,9.1552734e-004,-7.6293945e-004,-1.8615723e-003,-9.4604492e-004,2.5939941e-003,7.2326660e-003,1.3580322e-002,1.7120361e-002,1.9256592e-002,1.9531250e-002,1.6876221e-002,1.5686035e-002,1.3275146e-002,1.0620117e-002,8.7585449e-003,5.4016113e-003,2.7160645e-003,7.3242188e-004,-2.1362305e-004,4.2724609e-004,1.4953613e-003,2.4719238e-003,2.8381348e-003,2.9296875e-003,2.4108887e-003,2.5024414e-003,3.5095215e-003,5.3405762e-003,8.4228516e-003,9.9182129e-003,1.1749268e-002,1.2359619e-002,1.3427734e-002,1.5869141e-002,1.7364502e-002,2.0477295e-002,2.0782471e-002,1.8585205e-002,1.4312744e-002,1.1779785e-002,9.4909668e-003,8.7890625e-003,9.4299316e-003,6.8359375e-003,4.6997070e-003,2.6550293e-003,1.0375977e-003,2.3803711e-003,4.2114258e-003,4.9133301e-003,5.4931641e-003,4.6691895e-003,3.8757324e-003,6.1035156e-003,9.0942383e-003,1.1962891e-002,1.5075684e-002,1.6418457e-002,1.6937256e-002,1.8096924e-002,1.7486572e-002,1.6510010e-002,1.4495850e-002,1.1230469e-002,8.1481934e-003,6.9885254e-003,7.2326660e-003,7.5378418e-003,8.6059570e-003,7.5683594e-003,6.3781738e-003,6.5307617e-003,5.7983398e-003,6.5002441e-003,7.2021484e-003,6.1950684e-003,5.7067871e-003,5.9204102e-003,6.4392090e-003,8.6975098e-003,1.1688232e-002,1.3427734e-002,1.4587402e-002,1.4221191e-002,1.2847900e-002,1.2603760e-002,1.1962891e-002,1.1199951e-002,1.1322021e-002,9.9182129e-003,8.5449219e-003,6.0424805e-003,3.8757324e-003,3.8146973e-003,3.4179688e-003,3.7231445e-003,3.6315918e-003,3.2348633e-003,2.6245117e-003,2.9907227e-003,3.6621094e-003,5.9814453e-003,8.3618164e-003,9.6130371e-003,1.0101318e-002,9.3994141e-003,8.6364746e-003,9.2773438e-003,1.0192871e-002,1.1077881e-002,1.1962891e-002,1.0498047e-002,8.6669922e-003,7.1411133e-003,5.2490234e-003,4.2114258e-003,3.8757324e-003,2.8076172e-003,2.2583008e-003,1.6784668e-003,1.3122559e-003,2.0446777e-003,2.7465820e-003,3.9672852e-003,6.0424805e-003,7.9956055e-003,9.7045898e-003,1.1566162e-002,1.1993408e-002,1.1779785e-002,1.1199951e-002,1.0345459e-002,1.0040283e-002,1.0345459e-002,1.1352539e-002,1.0955811e-002,1.0101318e-002,8.7585449e-003,6.9274902e-003,6.6528320e-003,5.9814453e-003,5.7067871e-003,5.3710938e-003,3.5705566e-003,2.5634766e-003,1.8615723e-003,1.9531250e-003,3.0517578e-003,4.4555664e-003,6.4392090e-003,7.9040527e-003,9.1552734e-003,9.5520020e-003,1.0833740e-002,1.1627197e-002,1.1566162e-002,1.1718750e-002,1.1322021e-002,1.1047363e-002,1.2390137e-002,1.3519287e-002,1.3580322e-002,1.3061523e-002,1.1444092e-002,8.7890625e-003,7.8125000e-003,7.0190430e-003,6.2866211e-003,7.1716309e-003,5.7983398e-003,4.5776367e-003,4.3029785e-003,4.3029785e-003,6.1950684e-003,8.6364746e-003,1.0192871e-002,1.1718750e-002,1.2237549e-002,1.1413574e-002,1.1413574e-002,1.1016846e-002,1.0559082e-002,1.0375977e-002,9.0942383e-003,7.5988770e-003,6.3781738e-003,5.0964355e-003,4.5166016e-003,3.9062500e-003,3.4484863e-003,3.1738281e-003,2.5024414e-003,1.6479492e-003,6.7138672e-004,2.4414063e-004,-2.4414063e-004,9.1552734e-005,7.0190430e-004,2.2583008e-003,3.9367676e-003,6.0119629e-003,7.1716309e-003,8.3618164e-003,9.0026855e-003,8.9416504e-003,8.7585449e-003,8.2702637e-003,8.2702637e-003,6.9580078e-003,5.2795410e-003,3.2958984e-003,2.1972656e-003,1.5869141e-003,1.4953613e-003,1.6479492e-003,9.1552734e-004,-1.2207031e-004,-8.8500977e-004,-1.6479492e-003,-3.9672852e-004,7.9345703e-004,2.5634766e-003,3.9672852e-003,4.2419434e-003,4.1503906e-003,4.9133301e-003,5.2490234e-003,6.2866211e-003,7.2937012e-003,7.2937012e-003,7.4768066e-003,7.5073242e-003,7.2937012e-003,7.1716309e-003,6.5612793e-003,5.4321289e-003,4.6997070e-003,3.9367676e-003,3.0212402e-003,2.7465820e-003,2.3498535e-003,1.3122559e-003,-3.0517578e-005,-1.0681152e-003,-1.7700195e-003,-1.6784668e-003,-1.1291504e-003,-1.3427734e-003,-1.5563965e-003,-2.0446777e-003,-1.7395020e-003,3.0517578e-005,2.7160645e-003,5.0048828e-003,7.4768066e-003,7.9040527e-003,7.7209473e-003,8.0566406e-003,7.4462891e-003,7.6599121e-003,7.6904297e-003,8.2702637e-003,8.8195801e-003,8.5144043e-003,7.9650879e-003,7.5683594e-003,6.5612793e-003,5.7373047e-003,4.7607422e-003,4.0283203e-003,3.3874512e-003,2.9602051e-003,2.9907227e-003,2.2277832e-003,2.3193359e-003,2.6245117e-003,3.8146973e-003,5.0354004e-003,5.8593750e-003,5.5236816e-003,4.4860840e-003,3.7536621e-003,2.5024414e-003,2.8686523e-003,3.7231445e-003,3.5400391e-003,3.4484863e-003,2.1362305e-003,1.5258789e-004,-8.5449219e-004,-2.0446777e-003,-2.4108887e-003,-1.8615723e-003,-2.2583008e-003,-2.8381348e-003,-3.6010742e-003,-4.6997070e-003,-4.6997070e-003,-4.8522949e-003,-4.3334961e-003,-3.2348633e-003,-3.1127930e-003,-2.9296875e-003,-2.6855469e-003,-2.5634766e-003,-7.9345703e-004,1.0375977e-003,2.3803711e-003,3.2653809e-003,2.1667480e-003,9.7656250e-004,-2.1362305e-004,-1.2817383e-003,-1.8005371e-003,-1.3427734e-003,-2.1362305e-003,-1.7089844e-003,-1.8920898e-003,-3.4484863e-003,-2.8076172e-003,-3.6315918e-003,-4.3029785e-003,-4.5471191e-003,-3.8146973e-003,-2.5634766e-003,-2.0141602e-003,-1.7700195e-003,-2.5024414e-003,-3.2043457e-003,-2.4414063e-003,-1.6479492e-003,-7.3242188e-004,-2.4414063e-004,-2.4108887e-003,-4.5166016e-003,-6.3171387e-003,-7.6904297e-003,-7.4768066e-003,-6.6223145e-003,-7.5683594e-003,-8.7890625e-003,-1.0009766e-002,-1.1108398e-002,-9.6435547e-003,-8.3312988e-003,-7.3242188e-003,-6.0729980e-003,-5.9814453e-003,-6.2255859e-003,-5.3710938e-003,-4.8217773e-003,-4.1503906e-003,-3.4179688e-003,-3.9367676e-003,-4.8217773e-003,-5.1574707e-003,-5.5236816e-003,-5.4626465e-003,-5.3100586e-003,-5.7678223e-003,-6.4697266e-003,-7.8125000e-003,-1.0131836e-002,-1.1840820e-002,-1.3214111e-002,-1.3397217e-002,-1.2512207e-002,-1.2023926e-002,-1.1413574e-002,-1.1260986e-002,-1.1535645e-002,-1.0803223e-002,-9.1857910e-003,-8.3007813e-003,-6.5002441e-003,-5.7983398e-003,-6.7138672e-003,-7.0190430e-003,-7.7209473e-003,-7.8125000e-003,-7.4462891e-003,-8.4228516e-003,-9.4909668e-003,-1.0742188e-002,-1.2176514e-002,-1.2359619e-002,-1.2023926e-002,-1.1901855e-002,-1.2084961e-002,-1.1810303e-002,-1.1627197e-002,-1.1383057e-002,-1.1749268e-002,-1.1871338e-002,-1.2023926e-002,-1.1901855e-002,-1.1016846e-002,-1.0650635e-002,-9.4604492e-003,-9.4299316e-003,-9.3688965e-003,-9.4604492e-003,-1.0040283e-002,-1.0498047e-002,-1.1016846e-002,-1.1474609e-002,-1.2298584e-002,-1.2786865e-002,-1.3397217e-002,-1.5289307e-002,-1.7517090e-002,-1.9195557e-002,-2.0874023e-002,-1.9714355e-002,-1.8005371e-002,-1.6998291e-002,-1.5716553e-002,-1.6235352e-002,-1.7333984e-002,-1.6845703e-002,-1.6510010e-002,-1.5350342e-002,-1.3763428e-002,-1.4678955e-002,-1.5777588e-002,-1.6998291e-002,-1.8096924e-002,-1.7547607e-002,-1.6632080e-002,-1.5411377e-002,-1.5167236e-002,-1.5045166e-002,-1.5411377e-002,-1.6113281e-002,-1.7211914e-002,-1.8646240e-002,-1.9409180e-002,-2.0355225e-002,-2.0385742e-002,-1.9317627e-002,-1.7974854e-002,-1.7944336e-002,-1.7883301e-002,-1.7791748e-002,-1.8035889e-002,-1.7120361e-002,-1.6357422e-002,-1.4862061e-002,-1.3366699e-002,-1.2176514e-002,-1.1901855e-002,-1.2390137e-002,-1.3977051e-002,-1.5686035e-002,-1.6998291e-002,-1.8096924e-002,-1.8402100e-002,-1.9348145e-002,-1.9378662e-002,-2.0477295e-002,-2.1118164e-002,-2.1209717e-002,-2.1881104e-002,-2.1881104e-002,-2.2003174e-002,-2.1759033e-002,-2.1087646e-002,-1.9897461e-002,-1.9073486e-002,-1.8493652e-002,-1.8249512e-002,-1.8096924e-002,-1.8066406e-002,-1.6998291e-002,-1.5747070e-002,-1.6021729e-002,-1.6571045e-002,-1.8768311e-002,-2.0721436e-002,-2.0721436e-002,-2.0446777e-002,-2.0629883e-002,-2.0172119e-002,-2.1362305e-002,-2.3193359e-002,-2.3925781e-002,-2.5024414e-002,-2.3071289e-002,-2.1484375e-002,-2.1301270e-002,-2.1209717e-002,-2.1240234e-002,-2.1575928e-002,-2.1484375e-002,-2.1697998e-002,-2.2430420e-002,-2.2735596e-002,-2.3223877e-002,-2.3315430e-002,-2.3345947e-002,-2.3468018e-002,-2.2674561e-002,-2.1972656e-002,-2.0965576e-002,-2.0507813e-002,-2.0812988e-002,-2.1728516e-002,-2.3101807e-002,-2.4261475e-002,-2.4139404e-002,-2.3620605e-002,-2.4169922e-002,-2.4871826e-002,-2.6245117e-002,-2.7313232e-002,-2.6794434e-002,-2.5939941e-002,-2.5482178e-002,-2.5146484e-002,-2.6062012e-002,-2.7313232e-002,-2.6397705e-002,-2.5360107e-002,-2.3742676e-002,-2.1667480e-002,-2.1636963e-002,-2.2216797e-002,-2.3071289e-002,-2.4017334e-002,-2.3254395e-002,-2.1850586e-002,-2.0324707e-002,-1.8188477e-002,-1.8371582e-002,-1.9989014e-002,-2.2003174e-002,-2.4932861e-002,-2.4993896e-002,-2.3773193e-002,-2.2613525e-002,-2.0996094e-002,-2.3406982e-002,-2.6733398e-002,-2.7832031e-002,-2.7618408e-002,-2.2430420e-002,-1.5167236e-002,-1.4099121e-002,-1.5106201e-002,-2.0111084e-002,-2.7801514e-002,-2.7191162e-002,-2.4505615e-002,-2.0629883e-002,-1.5594482e-002,-1.9744873e-002,-2.6763916e-002,-3.1250000e-002,-3.5888672e-002,-3.1036377e-002,-2.3010254e-002,-1.9958496e-002,-1.7456055e-002,-2.2552490e-002,-2.9968262e-002,-3.1127930e-002,-3.1188965e-002,-2.6611328e-002,-1.9500732e-002,-2.0965576e-002,-2.4017334e-002,-2.9052734e-002,-3.5858154e-002,-3.4271240e-002,-3.0853271e-002,-2.7404785e-002,-2.3132324e-002,-2.6611328e-002,-3.1860352e-002,-3.3050537e-002,-3.4454346e-002,-3.0029297e-002,-2.3986816e-002,-2.4414063e-002,-2.5177002e-002,-2.8259277e-002,-3.2012939e-002,-2.9724121e-002,-2.6611328e-002,-2.5512695e-002,-2.4414063e-002,-2.8015137e-002,-3.2989502e-002,-3.3233643e-002,-3.3203125e-002,-3.1646729e-002,-2.9357910e-002,-3.1768799e-002,-3.4606934e-002,-3.5705566e-002,-3.7567139e-002,-3.5491943e-002,-3.3050537e-002,-3.3569336e-002,-3.3966064e-002,-3.4423828e-002,-3.4759521e-002,-3.2714844e-002,-3.1005859e-002,-3.0639648e-002,-3.1066895e-002,-3.2501221e-002,-3.4790039e-002,-3.5766602e-002,-3.6407471e-002,-3.7200928e-002,-3.7536621e-002,-3.8024902e-002,-3.8452148e-002,-3.7841797e-002,-3.6651611e-002,-3.5644531e-002,-3.4454346e-002,-3.4545898e-002,-3.4729004e-002,-3.4912109e-002,-3.5217285e-002,-3.5064697e-002,-3.4057617e-002,-3.3752441e-002,-3.3874512e-002,-3.4423828e-002,-3.5827637e-002,-3.6071777e-002,-3.6041260e-002,-3.4606934e-002,-3.2958984e-002,-3.2897949e-002,-3.3233643e-002,-3.4301758e-002,-3.5797119e-002,-3.5705566e-002,-3.5095215e-002,-3.4637451e-002,-3.3813477e-002,-3.5156250e-002,-3.6865234e-002,-3.8574219e-002,-4.0130615e-002,-3.9550781e-002,-3.8604736e-002,-3.8055420e-002,-3.7261963e-002,-3.8024902e-002,-3.9825439e-002,-4.0283203e-002,-4.0802002e-002,-4.0252686e-002,-3.8513184e-002,-3.6895752e-002,-3.6193848e-002,-3.6499023e-002,-3.7078857e-002,-3.6163330e-002,-3.5186768e-002,-3.3752441e-002,-3.2379150e-002,-3.3142090e-002,-3.4271240e-002,-3.5491943e-002,-3.6712646e-002,-3.6254883e-002,-3.4729004e-002,-3.3538818e-002,-3.2836914e-002,-3.2867432e-002,-3.3782959e-002,-3.3630371e-002,-3.3935547e-002,-3.3294678e-002,-3.2531738e-002,-3.2562256e-002,-3.2257080e-002,-3.2897949e-002,-3.3325195e-002,-3.3843994e-002,-3.3996582e-002,-3.3782959e-002,-3.2592773e-002,-3.2073975e-002,-3.1433105e-002,-3.0792236e-002,-3.0944824e-002,-3.0120850e-002,-2.9602051e-002,-2.8930664e-002,-2.8320313e-002,-2.8381348e-002,-2.9174805e-002,-3.0029297e-002,-3.1158447e-002,-3.2257080e-002,-3.2531738e-002,-3.2623291e-002,-3.2226563e-002,-3.2165527e-002,-3.2196045e-002,-3.3477783e-002,-3.5034180e-002,-3.5369873e-002,-3.5369873e-002,-3.3935547e-002,-3.1860352e-002,-3.2348633e-002,-3.1127930e-002,-3.1494141e-002,-3.3294678e-002,-3.2897949e-002,-3.2012939e-002,-3.0822754e-002,-2.9205322e-002,-2.9083252e-002,-2.9998779e-002,-3.0914307e-002,-3.2623291e-002,-3.3081055e-002,-3.2653809e-002,-3.2257080e-002,-3.1188965e-002,-3.1250000e-002,-3.1860352e-002,-3.2562256e-002,-3.3813477e-002,-3.3691406e-002,-3.3111572e-002,-3.1890869e-002,-2.9968262e-002,-2.9968262e-002,-3.0578613e-002,-3.0853271e-002,-3.2135010e-002,-3.2043457e-002,-3.1982422e-002,-3.2897949e-002,-3.3508301e-002,-3.4851074e-002,-3.5858154e-002,-3.5430908e-002,-3.4179688e-002,-3.2897949e-002,-3.1127930e-002,-3.0731201e-002,-3.1066895e-002,-3.1066895e-002,-3.1555176e-002,-3.1829834e-002,-3.1921387e-002,-3.1707764e-002,-3.1127930e-002,-3.0578613e-002,-3.0456543e-002,-3.0609131e-002,-3.0975342e-002,-3.0670166e-002,-3.0700684e-002,-3.0334473e-002,-2.9754639e-002,-3.0364990e-002,-3.0273438e-002,-3.1280518e-002,-3.2196045e-002,-3.1158447e-002,-3.0426025e-002,-3.1066895e-002,-3.1890869e-002,-3.3050537e-002,-3.4912109e-002,-3.5064697e-002,-3.6163330e-002,-3.5827637e-002,-3.5491943e-002,-3.4729004e-002,-3.3355713e-002,-3.1433105e-002,-2.9968262e-002,-2.9876709e-002,-3.0242920e-002,-3.0975342e-002,-3.1799316e-002,-3.0822754e-002,-2.9235840e-002,-2.9266357e-002,-2.9235840e-002,-3.0883789e-002,-3.2867432e-002,-3.4149170e-002,-3.5400391e-002,-3.6163330e-002,-3.6132813e-002,-3.6895752e-002,-3.6987305e-002,-3.6743164e-002,-3.6865234e-002,-3.6346436e-002,-3.6590576e-002,-3.6834717e-002,-3.7506104e-002,-3.7384033e-002,-3.6651611e-002,-3.5614014e-002,-3.3966064e-002,-3.2897949e-002,-3.1463623e-002,-3.0242920e-002,-2.9327393e-002,-2.8625488e-002,-2.8808594e-002,-2.8930664e-002,-3.0120850e-002,-3.1311035e-002,-3.1524658e-002,-3.1188965e-002,-2.9357910e-002,-2.8411865e-002,-2.6031494e-002,-2.6458740e-002,-2.7343750e-002,-2.7008057e-002,-2.8747559e-002,-2.7648926e-002,-2.6489258e-002,-2.5451660e-002,-2.3986816e-002,-2.4597168e-002,-2.5848389e-002,-2.6062012e-002,-2.7343750e-002,-2.7862549e-002,-2.8167725e-002,-2.9174805e-002,-2.9724121e-002,-2.9876709e-002,-2.9510498e-002,-2.9113770e-002,-2.8808594e-002,-2.9205322e-002,-3.0059814e-002,-2.9815674e-002,-3.0029297e-002,-2.9693604e-002,-2.9174805e-002,-2.9876709e-002,-3.0761719e-002,-3.0242920e-002,-2.9663086e-002,-2.8137207e-002,-2.5360107e-002,-2.5360107e-002,-2.6000977e-002,-2.7069092e-002,-3.0059814e-002,-3.1066895e-002,-3.1707764e-002,-3.1585693e-002,-3.0426025e-002,-3.0059814e-002,-2.9846191e-002,-3.0334473e-002,-3.1250000e-002,-3.1219482e-002,-3.1433105e-002,-3.1005859e-002,-2.9815674e-002,-2.9785156e-002,-2.9052734e-002,-2.8869629e-002,-2.8472900e-002,-2.7984619e-002,-2.8259277e-002,-2.7801514e-002,-2.8167725e-002,-2.7648926e-002,-2.7709961e-002,-2.6275635e-002,-2.4810791e-002,-2.4597168e-002,-2.3895264e-002,-2.4139404e-002,-2.3895264e-002,-2.3559570e-002,-2.3406982e-002,-2.3803711e-002,-2.3742676e-002,-2.3773193e-002,-2.3498535e-002,-2.2308350e-002,-2.1087646e-002,-2.0751953e-002,-2.0721436e-002,-2.0996094e-002,-2.1667480e-002,-2.0935059e-002,-2.0721436e-002,-2.0874023e-002,-2.0782471e-002,-2.1179199e-002,-2.1301270e-002,-2.0111084e-002,-1.8676758e-002,-1.7944336e-002,-1.7791748e-002,-1.8157959e-002,-1.9012451e-002,-1.7791748e-002,-1.6754150e-002,-1.5747070e-002,-1.4221191e-002,-1.5258789e-002,-1.6143799e-002,-1.6693115e-002,-1.7242432e-002,-1.6113281e-002,-1.4556885e-002,-1.4007568e-002,-1.3244629e-002,-1.3214111e-002,-1.3793945e-002,-1.3641357e-002,-1.4099121e-002,-1.3458252e-002,-1.2298584e-002,-1.1627197e-002,-1.1199951e-002,-1.2054443e-002,-1.4190674e-002,-1.5777588e-002,-1.6662598e-002,-1.5838623e-002,-1.3946533e-002,-1.3183594e-002,-1.0772705e-002,-1.1291504e-002,-1.2603760e-002,-1.2420654e-002,-1.2847900e-002,-1.1688232e-002,-1.0406494e-002,-1.0894775e-002,-1.1444092e-002,-1.2725830e-002,-1.4526367e-002,-1.5533447e-002,-1.5747070e-002,-1.5716553e-002,-1.3732910e-002,-1.2695313e-002,-1.1077881e-002,-1.0589600e-002,-1.1383057e-002,-1.0925293e-002,-1.1169434e-002,-9.9792480e-003,-8.6975098e-003,-8.0261230e-003,-7.8125000e-003,-8.7890625e-003,-9.0637207e-003,-7.9345703e-003,-6.6833496e-003,-5.3405762e-003,-3.8757324e-003,-4.1198730e-003,-4.9743652e-003,-5.6152344e-003,-6.1340332e-003,-6.5612793e-003,-7.3547363e-003,-9.0332031e-003,-1.0406494e-002,-1.1535645e-002,-1.2054443e-002,-1.0589600e-002,-9.7045898e-003,-9.3688965e-003,-8.6669922e-003,-9.4604492e-003,-1.1260986e-002,-1.1108398e-002,-1.1077881e-002,-1.0772705e-002,-1.0101318e-002,-1.1383057e-002,-1.2207031e-002,-1.2512207e-002,-1.2481689e-002,-1.0314941e-002,-8.7280273e-003,-8.1176758e-003,-7.5683594e-003,-7.9345703e-003,-9.4909668e-003,-9.4604492e-003,-8.5754395e-003,-8.5754395e-003,-8.1176758e-003,-9.3383789e-003,-1.0375977e-002,-1.0070801e-002,-9.6130371e-003,-9.0332031e-003,-7.9956055e-003,-7.8430176e-003,-7.7209473e-003,-6.8664551e-003,-6.3171387e-003,-6.2866211e-003,-6.1950684e-003,-7.3242188e-003,-8.1481934e-003,-7.6293945e-003,-6.7749023e-003,-6.0119629e-003,-5.4931641e-003,-6.3476563e-003,-7.6599121e-003,-7.0190430e-003,-6.2561035e-003,-4.3029785e-003,-2.4108887e-003,-2.2277832e-003,-3.2043457e-003,-3.7536621e-003,-4.4555664e-003,-3.3264160e-003,-9.4604492e-004,-9.1552734e-005,2.1362305e-003,2.1667480e-003,1.3732910e-003,8.8500977e-004,-4.2724609e-004,-7.9345703e-004,-2.7465820e-004,1.5258789e-004,2.7465820e-004,-3.6621094e-004,-1.2207031e-003,-1.8615723e-003,-1.7700195e-003,-2.4414063e-004,1.7089844e-003,2.7770996e-003,2.5634766e-003,2.8381348e-003,1.7700195e-003,1.8920898e-003,2.1362305e-003,2.1362305e-003,2.6245117e-003,1.6174316e-003,1.3427734e-003,7.0190430e-004,4.8828125e-004,7.0190430e-004,7.9345703e-004,1.0681152e-003,8.5449219e-004,1.5258789e-003,1.8920898e-003,1.9836426e-003,1.9531250e-003,1.5563965e-003,1.6479492e-003,3.3569336e-003,5.3100586e-003,6.5307617e-003,6.9885254e-003,6.5002441e-003,5.6457520e-003,6.1035156e-003,6.8054199e-003,7.3852539e-003,8.1176758e-003,6.9580078e-003,5.6152344e-003,6.0729980e-003,7.1411133e-003,8.6059570e-003,9.9182129e-003,9.2163086e-003,8.3312988e-003,7.9650879e-003,7.5683594e-003,9.0637207e-003,1.0742188e-002,1.0986328e-002,1.1016846e-002,1.0375977e-002,9.7656250e-003,1.0284424e-002,1.0803223e-002,1.0772705e-002,1.0345459e-002,8.9721680e-003,8.0566406e-003,7.9345703e-003,8.2702637e-003,9.1552734e-003,1.0009766e-002,1.0345459e-002,9.6435547e-003,9.3994141e-003,9.3078613e-003,9.1857910e-003,9.7656250e-003,9.4604492e-003,9.8266602e-003,9.1552734e-003,8.5449219e-003,8.3312988e-003,8.2397461e-003,9.0637207e-003,9.8571777e-003,1.0650635e-002,1.0711670e-002,1.1047363e-002,1.0437012e-002,1.0772705e-002,1.0894775e-002,1.0345459e-002,9.4909668e-003,8.6975098e-003,7.9956055e-003,7.3852539e-003,7.5683594e-003,7.7514648e-003,8.0566406e-003,9.2773438e-003,1.0772705e-002,1.1535645e-002,1.1413574e-002,9.7351074e-003,7.1411133e-003,6.9274902e-003,7.3547363e-003,9.0026855e-003,1.2786865e-002,1.4556885e-002,1.5686035e-002,1.5716553e-002,1.3671875e-002,1.3580322e-002,1.3397217e-002,1.4221191e-002,1.5747070e-002,1.5686035e-002,1.5930176e-002,1.5594482e-002,1.4862061e-002,1.4892578e-002,1.5014648e-002,1.5136719e-002,1.5625000e-002,1.6082764e-002,1.6235352e-002,1.5502930e-002,1.6235352e-002,1.6815186e-002,1.6845703e-002,1.6479492e-002,1.5350342e-002,1.4221191e-002,1.2603760e-002,1.1566162e-002,1.1322021e-002,1.1352539e-002,1.2176514e-002,1.2115479e-002,1.2298584e-002,1.2573242e-002,1.2634277e-002,1.3153076e-002,1.3183594e-002,1.2420654e-002,1.1688232e-002,1.0833740e-002,1.0406494e-002,1.1657715e-002,1.3488770e-002,1.4556885e-002,1.5319824e-002,1.5411377e-002,1.4801025e-002,1.5533447e-002,1.6204834e-002,1.7852783e-002,1.9897461e-002,1.9561768e-002,1.8524170e-002,1.6845703e-002,1.5106201e-002,1.5869141e-002,1.7547607e-002,1.8066406e-002,1.9012451e-002,1.7333984e-002,1.4739990e-002,1.4099121e-002,1.3153076e-002,1.4648438e-002,1.5808105e-002,1.5350342e-002,1.4923096e-002,1.4343262e-002,1.3763428e-002,1.4801025e-002,1.5106201e-002,1.4221191e-002,1.4251709e-002,1.4953613e-002,1.6723633e-002,1.8768311e-002,2.0660400e-002,1.9226074e-002,1.7425537e-002,1.5228271e-002,1.2969971e-002,1.3793945e-002,1.6204834e-002,1.6510010e-002,1.6967773e-002,1.5686035e-002,1.3427734e-002,1.3488770e-002,1.3549805e-002,1.4282227e-002,1.5594482e-002,1.5502930e-002,1.6143799e-002,1.6815186e-002,1.7242432e-002,1.7211914e-002,1.6632080e-002,1.5472412e-002,1.4862061e-002,1.5197754e-002,1.6387939e-002,1.7517090e-002,1.8676758e-002,1.8554688e-002,1.8035889e-002,1.7791748e-002,1.7089844e-002,1.7333984e-002,1.7669678e-002,1.8554688e-002,1.9775391e-002,2.0202637e-002,2.0599365e-002,2.0263672e-002,1.9409180e-002,1.9836426e-002,2.0629883e-002,2.1575928e-002,2.2796631e-002,2.1789551e-002,2.0660400e-002,2.0324707e-002,1.9866943e-002,2.0599365e-002,2.1850586e-002,2.1484375e-002,2.0874023e-002,2.0812988e-002,2.0568848e-002,2.1514893e-002,2.2338867e-002,2.0324707e-002,1.9409180e-002,1.9042969e-002,1.7120361e-002,1.8066406e-002,1.8829346e-002,1.8066406e-002,1.7883301e-002,1.7761230e-002,1.8066406e-002,2.0690918e-002,2.3590088e-002,2.4444580e-002,2.4291992e-002,2.2796631e-002,2.0233154e-002,2.0721436e-002,2.1209717e-002,2.1423340e-002,2.3010254e-002,2.2766113e-002,2.2399902e-002,2.2979736e-002,2.2918701e-002,2.2705078e-002,2.2399902e-002,2.1850586e-002,2.2125244e-002,2.2827148e-002,2.3803711e-002,2.3101807e-002,2.2491455e-002,2.1820068e-002,2.1301270e-002,2.3132324e-002,2.4780273e-002,2.4627686e-002,2.4261475e-002,2.3010254e-002,2.1575928e-002,2.2583008e-002,2.3284912e-002,2.2430420e-002,2.1575928e-002,2.0141602e-002,1.9256592e-002,2.1057129e-002,2.3284912e-002,2.3864746e-002,2.4169922e-002,2.3071289e-002,2.1514893e-002,2.3010254e-002,2.4688721e-002,2.5787354e-002,2.6763916e-002,2.5573730e-002,2.3498535e-002,2.4322510e-002,2.5268555e-002,2.6092529e-002,2.7160645e-002,2.6062012e-002,2.4597168e-002,2.4414063e-002,2.3864746e-002,2.3529053e-002,2.3529053e-002,2.1759033e-002,2.0874023e-002,2.0996094e-002,2.1331787e-002,2.1636963e-002,2.1514893e-002,2.0416260e-002,1.9226074e-002,1.9805908e-002,2.0721436e-002,2.2521973e-002,2.4230957e-002,2.3925781e-002,2.3101807e-002,2.2552490e-002,2.1575928e-002,2.2460938e-002,2.3315430e-002,2.2583008e-002,2.1942139e-002,2.0202637e-002,1.8371582e-002,1.7791748e-002,1.7913818e-002,1.8646240e-002,2.0660400e-002,2.1453857e-002,2.1942139e-002,2.2521973e-002,2.2308350e-002,2.3345947e-002,2.4230957e-002,2.5543213e-002,2.6824951e-002,2.7252197e-002,2.7221680e-002,2.7252197e-002,2.7099609e-002,2.7069092e-002,2.7038574e-002,2.6397705e-002,2.5848389e-002,2.5573730e-002,2.5115967e-002,2.4719238e-002,2.3529053e-002,2.2338867e-002,2.2705078e-002,2.3498535e-002,2.5543213e-002,2.7587891e-002,2.9937744e-002,3.0700684e-002,3.0334473e-002,3.0639648e-002,3.0487061e-002,3.1311035e-002,3.1799316e-002,3.0761719e-002,2.9663086e-002,2.8472900e-002,2.7526855e-002,2.7923584e-002,2.9052734e-002,2.8656006e-002,2.7587891e-002,2.6611328e-002,2.5451660e-002,2.6458740e-002,2.7923584e-002,2.8442383e-002,2.8961182e-002,2.8259277e-002,2.7465820e-002,2.8869629e-002,3.0761719e-002,3.1799316e-002,3.2867432e-002,3.2287598e-002,3.0975342e-002,3.1372070e-002,3.1829834e-002,3.2714844e-002,3.3508301e-002,3.1616211e-002,3.0059814e-002,2.9602051e-002,2.9907227e-002,3.0944824e-002,3.1799316e-002,3.0731201e-002,2.8839111e-002,2.7160645e-002,2.5268555e-002,2.5970459e-002,2.7130127e-002,2.6824951e-002,2.6458740e-002,2.4780273e-002,2.3040771e-002,2.3193359e-002,2.3254395e-002,2.3071289e-002,2.2399902e-002,2.1301270e-002,2.1667480e-002,2.2674561e-002,2.4108887e-002,2.4688721e-002,2.5177002e-002,2.3620605e-002,2.1789551e-002,2.2033691e-002,2.2338867e-002,2.3406982e-002,2.4200439e-002,2.3132324e-002,2.2186279e-002,2.2460938e-002,2.2338867e-002,2.3803711e-002,2.5177002e-002,2.5085449e-002,2.4871826e-002,2.4383545e-002,2.3620605e-002,2.3468018e-002,2.3315430e-002,2.2430420e-002,2.1728516e-002,2.0843506e-002,2.0385742e-002,2.0355225e-002,1.9927979e-002,1.9409180e-002,1.9042969e-002,1.9012451e-002,1.8371582e-002,1.8005371e-002,1.7639160e-002,1.7333984e-002,1.7181396e-002,1.7150879e-002,1.8005371e-002,1.8646240e-002,1.9409180e-002,1.9470215e-002,1.9409180e-002,1.9805908e-002,2.0141602e-002,2.0385742e-002,2.0507813e-002,2.0416260e-002,2.0050049e-002,2.0477295e-002,2.0935059e-002,2.1911621e-002,2.2430420e-002,2.3010254e-002,2.2003174e-002,2.1026611e-002,2.1453857e-002,2.1209717e-002,2.1667480e-002,2.2705078e-002,2.4353027e-002,2.5115967e-002,2.5726318e-002,2.4719238e-002,2.2918701e-002,2.3376465e-002,2.3620605e-002,2.5146484e-002,2.7313232e-002,2.7130127e-002,2.6336670e-002,2.5024414e-002,2.2857666e-002,2.3376465e-002,2.4414063e-002,2.3529053e-002,2.3834229e-002,2.2827148e-002,2.1392822e-002,2.2003174e-002,2.2735596e-002,2.3162842e-002,2.3834229e-002,2.3468018e-002,2.2888184e-002,2.3529053e-002,2.4139404e-002,2.4627686e-002,2.5451660e-002,2.4963379e-002,2.4444580e-002,2.4993896e-002,2.4993896e-002,2.5024414e-002,2.4566650e-002,2.3406982e-002,2.1728516e-002,2.1667480e-002,2.1850586e-002,2.2186279e-002,2.3498535e-002,2.3925781e-002,2.4383545e-002,2.4902344e-002,2.5146484e-002,2.5512695e-002,2.6062012e-002,2.5756836e-002,2.5238037e-002,2.6000977e-002,2.5268555e-002,2.5177002e-002,2.5451660e-002,2.5268555e-002,2.5878906e-002,2.5268555e-002,2.4322510e-002,2.3223877e-002,2.2369385e-002,2.2216797e-002,2.2644043e-002,2.3010254e-002,2.3956299e-002,2.3345947e-002,2.2735596e-002,2.2186279e-002,2.1179199e-002,2.2308350e-002,2.2949219e-002,2.3101807e-002,2.3010254e-002,2.3010254e-002,2.2979736e-002,2.3406982e-002,2.3132324e-002,2.1575928e-002,1.9866943e-002,1.9042969e-002,1.8585205e-002,1.9134521e-002,2.0111084e-002,1.9927979e-002,2.0111084e-002,2.0507813e-002,2.1240234e-002,2.1942139e-002,2.2247314e-002,2.1423340e-002,2.0233154e-002,1.9836426e-002,1.9866943e-002,2.0599365e-002,2.1697998e-002,2.1148682e-002,1.9592285e-002,1.9134521e-002,1.8493652e-002,1.9348145e-002,2.0111084e-002,1.9622803e-002,1.9042969e-002,1.8615723e-002,1.8554688e-002,1.9439697e-002,2.0050049e-002,1.9287109e-002,1.8585205e-002,1.7181396e-002,1.7791748e-002,1.9042969e-002,1.9866943e-002,2.0019531e-002,1.9500732e-002,1.8859863e-002,1.7608643e-002,1.6967773e-002,1.6235352e-002,1.5014648e-002,1.4709473e-002,1.5502930e-002,1.6540527e-002,1.6723633e-002,1.6540527e-002,1.5380859e-002,1.4251709e-002,1.4434814e-002,1.4953613e-002,1.3824463e-002,1.2390137e-002,1.0528564e-002,8.5754395e-003,1.0437012e-002,1.2847900e-002,1.4129639e-002,1.4770508e-002,1.3061523e-002,1.0681152e-002,1.1566162e-002,1.2603760e-002,1.3183594e-002,1.3671875e-002,1.1566162e-002,1.0101318e-002,1.3946533e-002,1.8615723e-002,2.0751953e-002,2.0538330e-002,1.3031006e-002,4.2419434e-003,2.8991699e-003,4.6691895e-003,9.2163086e-003,1.6906738e-002,1.4953613e-002,1.1901855e-002,1.2023926e-002,1.0864258e-002,1.5899658e-002,2.0202637e-002,1.7181396e-002,1.2939453e-002,9.0332031e-003,4.9133301e-003,6.5612793e-003,9.5825195e-003,7.5378418e-003,7.9650879e-003,8.0261230e-003,7.8735352e-003,1.3183594e-002,1.6876221e-002,1.4923096e-002,1.0925293e-002,7.0190430e-003,3.5705566e-003,5.2185059e-003,9.4909668e-003,8.3923340e-003,8.8806152e-003,8.0871582e-003,7.2937012e-003,1.1993408e-002,1.5716553e-002,1.5960693e-002,1.4129639e-002,1.1199951e-002,6.9274902e-003,7.1716309e-003,8.3312988e-003,7.0800781e-003,6.9580078e-003,5.7678223e-003,5.5847168e-003,8.6059570e-003,1.1505127e-002,1.2084961e-002,1.1932373e-002,1.0833740e-002,9.3688965e-003,1.1199951e-002,1.3092041e-002,1.1322021e-002,9.5825195e-003,7.3242188e-003,5.2185059e-003,7.7209473e-003,1.0986328e-002,1.1657715e-002,1.2542725e-002,1.2237549e-002,1.1444092e-002,1.3946533e-002,1.5777588e-002,1.5167236e-002,1.4251709e-002,1.2573242e-002,1.0955811e-002,1.3031006e-002,1.5899658e-002,1.5472412e-002,1.4739990e-002,1.3549805e-002,1.0711670e-002,1.1016846e-002,1.2115479e-002,1.1535645e-002,1.1505127e-002,8.3618164e-003,5.6762695e-003,5.8288574e-003,7.3242188e-003,9.2468262e-003,1.1688232e-002,1.2023926e-002,1.1169434e-002,1.2359619e-002,1.1840820e-002,1.1779785e-002,1.1291504e-002,8.9416504e-003,7.2937012e-003,6.8054199e-003,6.3781738e-003,6.6528320e-003,7.9956055e-003,9.0942383e-003,9.8876953e-003,1.0925293e-002,1.1077881e-002,1.0589600e-002,9.3078613e-003,8.2397461e-003,7.2937012e-003,7.0190430e-003,7.5683594e-003,7.3547363e-003,7.5683594e-003,7.7514648e-003,8.0566406e-003,9.3994141e-003,1.0131836e-002,1.0498047e-002,1.0864258e-002,1.1016846e-002,1.0559082e-002,1.0437012e-002,8.9111328e-003,7.7514648e-003,8.4838867e-003,9.6740723e-003,1.2176514e-002,1.3732910e-002,1.4404297e-002,1.3000488e-002,1.0528564e-002,1.0009766e-002,1.0070801e-002,9.9182129e-003,1.1383057e-002,1.0955811e-002,9.6435547e-003,9.5520020e-003,8.8500977e-003,1.0131836e-002,1.1169434e-002,1.0681152e-002,9.7656250e-003,9.0332031e-003,8.0261230e-003,7.3852539e-003,6.9885254e-003,5.8898926e-003,5.8593750e-003,6.2561035e-003,7.4462891e-003,8.3312988e-003,8.8806152e-003,9.0026855e-003,8.3618164e-003,9.3688965e-003,9.9792480e-003,1.0559082e-002,1.0314941e-002,9.0026855e-003,7.0800781e-003,6.3171387e-003,7.5683594e-003,8.6364746e-003,1.0009766e-002,8.3312988e-003,6.8969727e-003,7.1716309e-003,7.1411133e-003,8.2092285e-003,9.4299316e-003,8.4228516e-003,7.0190430e-003,6.3781738e-003,5.4626465e-003,6.0119629e-003,6.8054199e-003,5.8288574e-003,4.8828125e-003,4.4860840e-003,4.2114258e-003,5.4321289e-003,6.5612793e-003,6.1645508e-003,5.3710938e-003,4.7912598e-003,4.1198730e-003,4.6386719e-003,5.0048828e-003,4.0588379e-003,4.1198730e-003,2.8686523e-003,1.7395020e-003,1.9531250e-003,2.6855469e-003,2.9296875e-003,2.7770996e-003,2.4414063e-003,1.3122559e-003,7.9345703e-004,4.8828125e-004,5.7983398e-004,9.1552734e-004,3.0517578e-004,6.1035156e-005,-6.1035156e-005,1.2207031e-004,1.5258789e-003,3.0517578e-003,3.8452148e-003,4.7607422e-003,5.0659180e-003,5.1574707e-003,5.6762695e-003,5.7373047e-003,4.9743652e-003,4.0283203e-003,1.9226074e-003,-1.2207031e-004,1.2207031e-004,1.1901855e-003,1.8615723e-003,2.1362305e-003,3.3569336e-004,-2.0446777e-003,-2.5329590e-003,-2.9296875e-003,-1.4648438e-003,4.8828125e-004,-9.1552734e-004,-2.2277832e-003,-3.2043457e-003,-3.9062500e-003,-1.8310547e-003,7.6293945e-004,5.1879883e-004,-3.0517578e-004,-1.6174316e-003,-2.9296875e-003,-7.6293945e-004,1.4038086e-003,1.5563965e-003,1.3427734e-003,-5.4931641e-004,-2.9907227e-003,-2.0446777e-003,-8.5449219e-004,-4.5776367e-004,8.8500977e-004,-1.4038086e-003,-3.7536621e-003,-3.7231445e-003,-3.5705566e-003,-3.1433105e-003,-2.1972656e-003,-3.1433105e-003,-4.5776367e-003,-4.1809082e-003,-4.5166016e-003,-3.7841797e-003,-2.9296875e-003,-2.8991699e-003,-2.7465820e-003,-1.7089844e-003,-5.4931641e-004,-3.6621094e-004,-6.1035156e-004,-2.4719238e-003,-4.1503906e-003,-4.1809082e-003,-4.1198730e-003,-3.8757324e-003,-2.9296875e-003,-3.8452148e-003,-4.6691895e-003,-4.5166016e-003,-4.4250488e-003,-2.9907227e-003,-1.7700195e-003,-1.8920898e-003,-1.8310547e-003,-1.6479492e-003,-1.7700195e-003,-1.0986328e-003,-6.1035156e-004,-1.8615723e-003,-2.8991699e-003,-3.7841797e-003,-4.2114258e-003,-3.6010742e-003,-2.4719238e-003,-2.5634766e-003,-2.6550293e-003,-3.2043457e-003,-3.9978027e-003,-2.9296875e-003,-1.9226074e-003,-1.0681152e-003,-4.2724609e-004,-8.8500977e-004,-2.2277832e-003,-1.7700195e-003,-2.1057129e-003,-1.2512207e-003,1.9226074e-003,1.2207031e-003,-3.0517578e-005,-3.1738281e-003,-7.1105957e-003,-9.6740723e-003,-1.1199951e-002,-1.2054443e-002,-1.1077881e-002,-1.0437012e-002,-9.1247559e-003,-6.8664551e-003,-5.2185059e-003,-3.3874512e-003,-2.3498535e-003,-1.5563965e-003,-1.2207031e-003,-4.5776367e-004,5.4931641e-004,5.1879883e-004,6.7138672e-004,-4.2724609e-004,-2.1362305e-003,-2.6550293e-003,-2.9907227e-003,-3.2043457e-003,-3.4484863e-003,-4.7302246e-003,-6.3476563e-003,-7.3547363e-003,-8.3007813e-003,-8.2397461e-003,-7.5073242e-003,-7.0495605e-003,-5.4626465e-003,-4.0588379e-003,-2.8381348e-003,-1.4953613e-003,-2.1362305e-004,1.0375977e-003,2.0446777e-003,2.8991699e-003,3.2653809e-003,1.6784668e-003,-1.0986328e-003,-3.8757324e-003,-7.4462891e-003,-8.8195801e-003,-8.7890625e-003,-1.0101318e-002,-1.0009766e-002,-1.0589600e-002,-1.1993408e-002,-1.1108398e-002,-1.1413574e-002,-1.0009766e-002,-8.9111328e-003,-8.0566406e-003,-5.6457520e-003,-3.5705566e-003,-1.6174316e-003,-1.2817383e-003,-1.9226074e-003,-4.2724609e-003,-6.8054199e-003,-6.2561035e-003,-4.8522949e-003,-3.1127930e-003,-9.4604492e-004,-3.2043457e-003,-6.8969727e-003,-1.0162354e-002,-1.4587402e-002,-1.5411377e-002,-1.4556885e-002,-1.4312744e-002,-1.2176514e-002,-1.1077881e-002,-9.5825195e-003,-6.5917969e-003,-4.1198730e-003,-1.7700195e-003,-1.8310547e-004,-4.8828125e-004,-1.7700195e-003,-3.3264160e-003,-4.5166016e-003,-5.2490234e-003,-4.0283203e-003,-3.7536621e-003,-2.8686523e-003,-2.8686523e-003,-3.9672852e-003,-3.9672852e-003,-5.2795410e-003,-6.2866211e-003,-7.7819824e-003,-9.1552734e-003,-9.3688965e-003,-8.7585449e-003,-7.0495605e-003,-5.4626465e-003,-3.5400391e-003,-2.2583008e-003,-1.8615723e-003,-1.1596680e-003,-1.1901855e-003,-1.8310547e-003,-3.2653809e-003,-6.5307617e-003,-9.6435547e-003,-1.1596680e-002,-1.0253906e-002,-8.5449219e-003,-6.6223145e-003,-7.1716309e-003,-9.3688965e-003,-1.0711670e-002,-1.2786865e-002,-1.1688232e-002,-9.3688965e-003,-8.8500977e-003,-7.9956055e-003,-8.5449219e-003,-8.7585449e-003,-6.8969727e-003,-4.7302246e-003,-2.7770996e-003,-7.3242188e-004,-5.4931641e-004,-1.2512207e-003,-2.9907227e-003,-5.5541992e-003,-8.3312988e-003,-1.0986328e-002,-1.3092041e-002,-1.3916016e-002,-1.4343262e-002,-1.4007568e-002,-1.4465332e-002,-1.5502930e-002,-1.4739990e-002,-1.3977051e-002,-1.2268066e-002,-1.0528564e-002,-1.0620117e-002,-1.0864258e-002,-1.0528564e-002,-9.5214844e-003,-7.6293945e-003,-4.6997070e-003,-5.0659180e-003,-5.9509277e-003,-7.8125000e-003,-1.0681152e-002,-1.1108398e-002,-1.1474609e-002,-1.3000488e-002,-1.4312744e-002,-1.5472412e-002,-1.6326904e-002,-1.4892578e-002,-1.3763428e-002,-1.3336182e-002,-1.3427734e-002,-1.3702393e-002,-1.4434814e-002,-1.2908936e-002,-1.0528564e-002,-9.4909668e-003,-6.1950684e-003,-5.3710938e-003,-5.1269531e-003,-4.4250488e-003,-4.5776367e-003,-6.0119629e-003,-8.3007813e-003,-1.0498047e-002,-1.2481689e-002,-1.3702393e-002,-1.4495850e-002,-1.5594482e-002,-1.6296387e-002,-1.6418457e-002,-1.6845703e-002,-1.5563965e-002,-1.3916016e-002,-1.2756348e-002,-1.1291504e-002,-9.8266602e-003,-8.9721680e-003,-8.5144043e-003,-8.9111328e-003,-1.0620117e-002,-1.1993408e-002,-1.1657715e-002,-1.0467529e-002,-1.0101318e-002,-9.8876953e-003,-1.2023926e-002,-1.5441895e-002,-1.5136719e-002,-1.4251709e-002,-1.1840820e-002,-9.4604492e-003,-1.1474609e-002,-1.4129639e-002,-1.4923096e-002,-1.5136719e-002,-1.1932373e-002,-8.2092285e-003,-1.0101318e-002,-1.1840820e-002,-1.2847900e-002,-1.3977051e-002,-1.1138916e-002,-7.6904297e-003,-9.7656250e-003,-1.2908936e-002,-1.5594482e-002,-1.8371582e-002,-1.5380859e-002,-1.0772705e-002,-1.2725830e-002,-1.3977051e-002,-1.6418457e-002,-1.9866943e-002,-1.5930176e-002,-1.1627197e-002,-1.1810303e-002,-1.2145996e-002,-1.4770508e-002,-1.7547607e-002,-1.2268066e-002,-6.0119629e-003,-3.9367676e-003,-2.9907227e-003,-8.8500977e-003,-1.6632080e-002,-1.5747070e-002,-1.3702393e-002,-1.1535645e-002,-8.5754395e-003,-1.3305664e-002,-1.8737793e-002,-1.7517090e-002,-1.5563965e-002,-1.1016846e-002,-6.2255859e-003,-1.0009766e-002,-1.5319824e-002,-1.6387939e-002,-1.7272949e-002,-1.3366699e-002,-7.7514648e-003,-1.0894775e-002,-1.4648438e-002,-1.6601563e-002,-1.8402100e-002,-1.3031006e-002,-6.4086914e-003,-7.3242188e-003,-9.4604492e-003,-1.2847900e-002,-1.7761230e-002,-1.3885498e-002,-8.5754395e-003,-7.6904297e-003,-6.7138672e-003,-1.0223389e-002,-1.4465332e-002,-1.1901855e-002,-9.1247559e-003,-7.8125000e-003,-5.7983398e-003,-9.5520020e-003,-1.3244629e-002,-1.1932373e-002,-1.0345459e-002,-8.5449219e-003,-6.6223145e-003,-1.0406494e-002,-1.4099121e-002,-1.3397217e-002,-1.2847900e-002,-1.0650635e-002,-8.3007813e-003,-1.0833740e-002,-1.3977051e-002,-1.3580322e-002,-1.3244629e-002,-1.0620117e-002,-7.5378418e-003,-1.0894775e-002,-1.4831543e-002,-1.7028809e-002,-1.9012451e-002,-1.6418457e-002,-1.2756348e-002,-1.3641357e-002,-1.4373779e-002,-1.5686035e-002,-1.7425537e-002,-1.4373779e-002,-1.1444092e-002,-1.2115479e-002,-1.3214111e-002,-1.4984131e-002,-1.7395020e-002,-1.4892578e-002,-1.1444092e-002,-1.1352539e-002,-1.1291504e-002,-1.2695313e-002,-1.4160156e-002,-1.0833740e-002,-7.2937012e-003,-6.6833496e-003,-7.1411133e-003,-1.1108398e-002,-1.6387939e-002,-1.6204834e-002,-1.4739990e-002,-1.3153076e-002,-9.7351074e-003,-1.0620117e-002,-1.2329102e-002,-1.1260986e-002,-1.1505127e-002,-1.0467529e-002,-1.0589600e-002,-1.3061523e-002,-1.5991211e-002,-1.6235352e-002,-1.5563965e-002,-1.3549805e-002,-1.0894775e-002,-1.1779785e-002,-1.1688232e-002,-1.1810303e-002,-1.2847900e-002,-1.2969971e-002,-1.3214111e-002,-1.4984131e-002,-1.6235352e-002,-1.6265869e-002,-1.5289307e-002,-1.3885498e-002,-1.2359619e-002,-1.2512207e-002,-1.3824463e-002,-1.3763428e-002,-1.4434814e-002,-1.4984131e-002,-1.5136719e-002,-1.8005371e-002,-2.0172119e-002,-2.1240234e-002,-2.1179199e-002,-1.9897461e-002,-1.7395020e-002,-1.6937256e-002,-1.6723633e-002,-1.6235352e-002,-1.6876221e-002,-1.5838623e-002,-1.5197754e-002,-1.4923096e-002,-1.4984131e-002,-1.5563965e-002,-1.6143799e-002,-1.6265869e-002,-1.6113281e-002,-1.5838623e-002,-1.4099121e-002,-1.2878418e-002,-1.2145996e-002,-1.2542725e-002,-1.4282227e-002,-1.6235352e-002,-1.7852783e-002,-1.7486572e-002,-1.6174316e-002,-1.5319824e-002,-1.3763428e-002,-1.3946533e-002,-1.5167236e-002,-1.5045166e-002,-1.6357422e-002,-1.7089844e-002,-1.7730713e-002,-1.8402100e-002,-1.8310547e-002,-1.8188477e-002,-1.7425537e-002,-1.7822266e-002,-1.7333984e-002,-1.6754150e-002,-1.6632080e-002,-1.5289307e-002,-1.4495850e-002,-1.4343262e-002,-1.4801025e-002,-1.5228271e-002,-1.5350342e-002,-1.4312744e-002,-1.3275146e-002,-1.3122559e-002,-1.2390137e-002,-1.2115479e-002,-1.1352539e-002,-9.3994141e-003,-8.5754395e-003,-9.5825195e-003,-1.2054443e-002,-1.4892578e-002,-1.7547607e-002,-1.7120361e-002,-1.5106201e-002,-1.4862061e-002,-1.4007568e-002,-1.5197754e-002,-1.6815186e-002,-1.5899658e-002,-1.5350342e-002,-1.5045166e-002,-1.5228271e-002,-1.6998291e-002,-1.9042969e-002,-1.8493652e-002,-1.7700195e-002,-1.6693115e-002,-1.5563965e-002,-1.6632080e-002,-1.7791748e-002,-1.7517090e-002,-1.7272949e-002,-1.6967773e-002,-1.6906738e-002,-1.9226074e-002,-2.1057129e-002,-2.1209717e-002,-2.0782471e-002,-1.9714355e-002,-1.8188477e-002,-1.9287109e-002,-2.1453857e-002,-2.1484375e-002,-2.2521973e-002,-2.0843506e-002,-1.9378662e-002,-2.0172119e-002,-1.9134521e-002,-1.9775391e-002,-2.0416260e-002,-1.9409180e-002,-1.7913818e-002,-1.7517090e-002,-1.7028809e-002,-1.7944336e-002,-1.8585205e-002,-1.8157959e-002,-1.7730713e-002,-1.6723633e-002,-1.4984131e-002,-1.3946533e-002,-1.2725830e-002,-1.2512207e-002,-1.3793945e-002,-1.5167236e-002,-1.7791748e-002,-1.9561768e-002,-2.0263672e-002,-2.0050049e-002,-1.8127441e-002,-1.6113281e-002,-1.3824463e-002,-1.4465332e-002,-1.6418457e-002,-1.9287109e-002,-2.3986816e-002,-2.5085449e-002,-2.4505615e-002,-2.2613525e-002,-1.8371582e-002,-1.7608643e-002,-1.8035889e-002,-1.8493652e-002,-2.1575928e-002,-2.2155762e-002,-2.2155762e-002,-2.1484375e-002,-1.9195557e-002,-1.8341064e-002,-1.8341064e-002,-1.8035889e-002,-1.8585205e-002,-1.8249512e-002,-1.7486572e-002,-1.6448975e-002,-1.4190674e-002,-1.3000488e-002,-1.2390137e-002,-1.4434814e-002,-1.7730713e-002,-1.9012451e-002,-1.9134521e-002,-1.6815186e-002,-1.3793945e-002,-1.3122559e-002,-1.2329102e-002,-1.3214111e-002,-1.6204834e-002,-1.5838623e-002,-1.5106201e-002,-1.4770508e-002,-1.3397217e-002,-1.4526367e-002,-1.6021729e-002,-1.6998291e-002,-1.8341064e-002,-1.8768311e-002,-1.8768311e-002,-1.8768311e-002,-1.7852783e-002,-1.6967773e-002,-1.5991211e-002,-1.5716553e-002,-1.6662598e-002,-1.8005371e-002,-1.9927979e-002,-2.0843506e-002,-2.0660400e-002,-2.0568848e-002,-1.9683838e-002,-1.9714355e-002,-1.9653320e-002,-1.8890381e-002,-1.9042969e-002,-1.9104004e-002,-1.8859863e-002,-1.8859863e-002,-1.8585205e-002,-1.8737793e-002,-1.8859863e-002,-1.8493652e-002,-1.7883301e-002,-1.7547607e-002,-1.6845703e-002,-1.6113281e-002,-1.5869141e-002,-1.6296387e-002,-1.7242432e-002,-1.8096924e-002,-1.8249512e-002,-1.7944336e-002,-1.6784668e-002,-1.5991211e-002,-1.5136719e-002,-1.4587402e-002,-1.4984131e-002,-1.4739990e-002,-1.5319824e-002,-1.6967773e-002,-1.6082764e-002,-1.5380859e-002,-1.4373779e-002,-1.2725830e-002,-1.1383057e-002,-1.1627197e-002,-1.2603760e-002,-1.3549805e-002,-1.5319824e-002,-1.4556885e-002,-1.4068604e-002,-1.3610840e-002,-1.3061523e-002,-1.3519287e-002,-1.4129639e-002,-1.3763428e-002,-1.2969971e-002,-1.2390137e-002,-1.0742188e-002,-1.1230469e-002,-1.1596680e-002,-1.1932373e-002,-1.2451172e-002,-1.2847900e-002,-1.3031006e-002,-1.2756348e-002,-1.2725830e-002,-1.2481689e-002,-1.2756348e-002,-1.3092041e-002,-1.4343262e-002,-1.5563965e-002,-1.6906738e-002,-1.6632080e-002,-1.6326904e-002,-1.6113281e-002,-1.5808105e-002,-1.7028809e-002,-1.8920898e-002,-2.0111084e-002,-2.0874023e-002,-2.0721436e-002,-1.9134521e-002,-1.8554688e-002,-1.7486572e-002,-1.8035889e-002,-1.9042969e-002,-1.9134521e-002,-1.9317627e-002,-1.8463135e-002,-1.7272949e-002,-1.6357422e-002,-1.6235352e-002,-1.6265869e-002,-1.7425537e-002,-1.7089844e-002,-1.6632080e-002,-1.6693115e-002,-1.5655518e-002,-1.6357422e-002,-1.7364502e-002,-1.8035889e-002,-1.7883301e-002,-1.8005371e-002,-1.7089844e-002,-1.7669678e-002,-1.8157959e-002,-1.7974854e-002,-1.7272949e-002,-1.4801025e-002,-1.2725830e-002,-1.1566162e-002,-1.2390137e-002,-1.3763428e-002,-1.6632080e-002,-1.7120361e-002,-1.6693115e-002,-1.6418457e-002,-1.4953613e-002,-1.5472412e-002,-1.6265869e-002,-1.7211914e-002,-1.7913818e-002,-1.8035889e-002,-1.7883301e-002,-1.7883301e-002,-1.7333984e-002,-1.6662598e-002,-1.5960693e-002,-1.5136719e-002,-1.5655518e-002,-1.6876221e-002,-1.8096924e-002,-1.8798828e-002,-1.8493652e-002,-1.7669678e-002,-1.5563965e-002,-1.5075684e-002,-1.4465332e-002,-1.4495850e-002,-1.5075684e-002,-1.4617920e-002,-1.4984131e-002,-1.5411377e-002,-1.6479492e-002,-1.7089844e-002,-1.6326904e-002,-1.5289307e-002,-1.4099121e-002,-1.4068604e-002,-1.5075684e-002,-1.5777588e-002,-1.8524170e-002,-1.7486572e-002,-1.5930176e-002,-1.5716553e-002,-1.5716553e-002,-1.7669678e-002,-1.9470215e-002,-1.9500732e-002,-1.8951416e-002,-1.7517090e-002,-1.5380859e-002,-1.5441895e-002,-1.5808105e-002,-1.7028809e-002,-1.9104004e-002,-1.9317627e-002,-1.9500732e-002,-1.9653320e-002,-1.8127441e-002,-1.6906738e-002,-1.5197754e-002,-1.3488770e-002,-1.3458252e-002,-1.3305664e-002,-1.4129639e-002,-1.4404297e-002,-1.4526367e-002,-1.4160156e-002,-1.3275146e-002,-1.3275146e-002,-1.2756348e-002,-1.2786865e-002,-1.2237549e-002,-1.1322021e-002,-1.0498047e-002,-1.0284424e-002,-1.0650635e-002,-1.1810303e-002,-1.3000488e-002,-1.3458252e-002,-1.3549805e-002,-1.3366699e-002,-1.2573242e-002,-1.2573242e-002,-1.2725830e-002,-1.2329102e-002,-1.2817383e-002,-1.1871338e-002,-1.1688232e-002,-1.1657715e-002,-1.1169434e-002,-1.1352539e-002,-1.1474609e-002,-1.1260986e-002,-1.0742188e-002,-1.0925293e-002,-1.0437012e-002,-1.1474609e-002,-1.2084961e-002,-1.1230469e-002,-1.1535645e-002,-1.1077881e-002,-1.0925293e-002,-1.0864258e-002,-1.0833740e-002,-1.0864258e-002,-1.1077881e-002,-1.1291504e-002,-1.1871338e-002,-1.3153076e-002,-1.3946533e-002,-1.4190674e-002,-1.4068604e-002,-1.3916016e-002,-1.3122559e-002,-1.2908936e-002,-1.2817383e-002,-1.1840820e-002,-1.2176514e-002,-1.2634277e-002,-1.3336182e-002,-1.4343262e-002,-1.4923096e-002,-1.3977051e-002,-1.2512207e-002,-1.1474609e-002,-1.0711670e-002,-1.1474609e-002,-1.3061523e-002,-1.2969971e-002,-1.3000488e-002,-1.1871338e-002,-1.0284424e-002,-1.1108398e-002,-1.2054443e-002,-1.2725830e-002,-1.3366699e-002,-1.1993408e-002,-1.0284424e-002,-1.0101318e-002,-1.0223389e-002,-1.1260986e-002,-1.2847900e-002,-1.2023926e-002,-1.0437012e-002,-9.6435547e-003,-8.1481934e-003,-8.1176758e-003,-8.7585449e-003,-8.2397461e-003,-8.8500977e-003,-8.8500977e-003,-8.8500977e-003,-9.8876953e-003,-8.8195801e-003,-8.6364746e-003,-8.0261230e-003,-8.1176758e-003,-8.5144043e-003,-9.8571777e-003,-1.1718750e-002,-1.2329102e-002,-1.2847900e-002,-1.2268066e-002,-1.1077881e-002,-1.0864258e-002,-1.0986328e-002,-1.0925293e-002,-1.2084961e-002,-1.2756348e-002,-1.3610840e-002,-1.3946533e-002,-1.3427734e-002,-1.3092041e-002,-1.1840820e-002,-1.1627197e-002,-1.2084961e-002,-1.3000488e-002,-1.4617920e-002,-1.5228271e-002,-1.5533447e-002,-1.5777588e-002,-1.4709473e-002,-1.4617920e-002,-1.4343262e-002,-1.3519287e-002,-1.3366699e-002,-1.2298584e-002,-1.1108398e-002,-1.0620117e-002,-1.0437012e-002,-1.0742188e-002,-1.1413574e-002,-1.1749268e-002,-1.1444092e-002,-1.1230469e-002,-1.0009766e-002,-9.3994141e-003,-8.9111328e-003,-8.9111328e-003,-9.4604492e-003,-9.2468262e-003,-9.5825195e-003,-9.7351074e-003,-9.8876953e-003,-1.0040283e-002,-1.0192871e-002,-1.0467529e-002,-1.0681152e-002,-1.0620117e-002,-1.0345459e-002,-1.0559082e-002,-9.9487305e-003,-9.1552734e-003,-8.6669922e-003,-8.6059570e-003,-9.0942383e-003,-9.3078613e-003,-9.3994141e-003,-8.4533691e-003,-6.5612793e-003,-5.9204102e-003,-5.2490234e-003,-6.3476563e-003,-7.9650879e-003,-8.1787109e-003,-8.8500977e-003,-8.4838867e-003,-7.7819824e-003,-8.1481934e-003,-8.8195801e-003,-9.1247559e-003,-9.2468262e-003,-8.6059570e-003,-7.6599121e-003,-6.8359375e-003,-5.7067871e-003,-5.3100586e-003,-4.5776367e-003,-4.9133301e-003,-5.5541992e-003,-6.5307617e-003,-7.5073242e-003,-7.0190430e-003,-5.5541992e-003,-4.4250488e-003,-3.1738281e-003,-3.3874512e-003,-4.4860840e-003,-4.2114258e-003,-3.8757324e-003,-3.2653809e-003,-2.4719238e-003,-3.5400391e-003,-5.0048828e-003,-5.5847168e-003,-5.7678223e-003,-5.1269531e-003,-3.3264160e-003,-2.5329590e-003,-2.4108887e-003,-2.5329590e-003,-3.0822754e-003,-1.8310547e-003,-6.1035156e-004,-1.8310547e-004,-4.2724609e-004,-8.8500977e-004,-6.1035156e-005,4.5776367e-004,6.1035156e-004,3.0517578e-005,-7.9345703e-004,-1.2512207e-003,-1.3427734e-003,-1.2207031e-004,1.7395020e-003,1.5563965e-003,3.3569336e-004,-1.9226074e-003,-4.9743652e-003,-5.8288574e-003,-5.3405762e-003,-4.7912598e-003,-3.5400391e-003,-3.7536621e-003,-5.0048828e-003,-5.7067871e-003,-7.2326660e-003,-7.5683594e-003,-6.9885254e-003,-7.1716309e-003,-6.8054199e-003,-7.0190430e-003,-6.6528320e-003,-6.5307617e-003,-6.6223145e-003,-6.7443848e-003,-6.7138672e-003,-6.5002441e-003,-6.0424805e-003,-5.5236816e-003,-5.0048828e-003,-4.8522949e-003,-4.7302246e-003,-4.7302246e-003,-4.6997070e-003,-4.3029785e-003,-4.0283203e-003,-3.4179688e-003,-3.1127930e-003,-2.8076172e-003,-2.4719238e-003,-1.7700195e-003,-9.7656250e-004,-2.7465820e-004,-2.7465820e-004,-1.0070801e-003,-2.5634766e-003,-3.6621094e-003,-4.3029785e-003,-3.9367676e-003,-2.8381348e-003,-2.1057129e-003,-1.6479492e-003,-1.0681152e-003,-2.7465820e-004,6.1035156e-005,-6.1035156e-004,-1.2817383e-003,-2.9907227e-003,-4.3945313e-003,-5.0354004e-003,-4.4860840e-003,-2.3498535e-003,-1.2207031e-003,-4.2724609e-004,-3.9672852e-004,-7.6293945e-004,1.8310547e-004,6.4086914e-004,8.5449219e-004,1.0070801e-003,-6.4086914e-004,-2.1972656e-003,-2.9296875e-003,-2.6245117e-003,-1.9531250e-003,-5.7983398e-004,-7.6293945e-004,-1.3427734e-003,-1.0681152e-003,-1.3427734e-003,2.1362305e-004,1.2817383e-003,6.4086914e-004,-5.1879883e-004,-2.3498535e-003,-4.0893555e-003,-4.1198730e-003,-2.9602051e-003,-2.4414063e-003,-1.5869141e-003,-2.5939941e-003,-3.6010742e-003,-3.8757324e-003,-4.3334961e-003,-3.2043457e-003,-1.5869141e-003,-8.5449219e-004,-1.5258789e-004,4.2724609e-004,3.0517578e-005,1.5258789e-004,1.8310547e-004,3.6621094e-004,1.0070801e-003,1.3732910e-003,2.9296875e-003,3.8146973e-003,5.4321289e-003,4.9743652e-003,3.8146973e-003,2.6550293e-003,1.7395020e-003,2.5329590e-003,4.1503906e-003,5.3405762e-003,5.8288574e-003,4.8217773e-003,3.9672852e-003,4.4250488e-003,4.9743652e-003,6.1035156e-003,7.2021484e-003,6.9885254e-003,6.2255859e-003,5.8593750e-003,5.0048828e-003,4.9133301e-003,5.2490234e-003,4.2419434e-003,3.6315918e-003,3.3264160e-003,3.3569336e-003,3.9062500e-003,4.7912598e-003,4.1809082e-003,2.9296875e-003,2.4719238e-003,1.3427734e-003,1.5563965e-003,1.7700195e-003,6.4086914e-004,-7.0190430e-004,-1.7395020e-003,-2.5329590e-003,-1.0070801e-003,1.0681152e-003,2.1667480e-003,3.1433105e-003,2.9602051e-003,1.8920898e-003,2.2888184e-003,3.1433105e-003,3.2653809e-003,4.0893555e-003,3.5400391e-003,3.1127930e-003,3.1433105e-003,3.9367676e-003,3.6926270e-003,3.5705566e-003,3.9062500e-003,3.5400391e-003,4.7302246e-003,5.4931641e-003,5.6457520e-003,6.8664551e-003,7.0190430e-003,6.4392090e-003,6.1340332e-003,6.1950684e-003,5.3710938e-003,5.2795410e-003,5.1879883e-003,5.7067871e-003,6.3781738e-003,7.0190430e-003,6.4697266e-003,5.5541992e-003,5.1269531e-003,3.9367676e-003,4.8522949e-003,5.7373047e-003,5.6152344e-003,5.4321289e-003,4.8217773e-003,4.2419434e-003,5.4321289e-003,7.4157715e-003,8.6059570e-003,9.9182129e-003,9.8876953e-003,8.9416504e-003,8.9111328e-003,8.0566406e-003,7.2937012e-003,6.8969727e-003,6.0729980e-003,5.6457520e-003,5.7983398e-003,6.1950684e-003,6.2561035e-003,5.3710938e-003,4.5776367e-003,3.8452148e-003,4.9133301e-003,6.1340332e-003,5.7983398e-003,5.5236816e-003,3.4484863e-003,1.2817383e-003,1.6174316e-003,3.0212402e-003,4.4250488e-003,6.4392090e-003,5.8288574e-003,3.8757324e-003,3.6621094e-003,2.4414063e-003,3.3874512e-003,3.6010742e-003,2.9602051e-003,3.0212402e-003,1.9836426e-003,1.5563965e-003,3.7841797e-003,6.0424805e-003,7.7209473e-003,8.6364746e-003,8.3312988e-003,6.5917969e-003,5.4321289e-003,4.6386719e-003,3.8452148e-003,4.1503906e-003,4.2114258e-003,5.3405762e-003,6.1645508e-003,6.9885254e-003,8.0871582e-003,8.3312988e-003,8.2702637e-003,8.0566406e-003,7.5378418e-003,7.8430176e-003,8.2702637e-003,8.2397461e-003,8.4228516e-003,7.7819824e-003,7.5378418e-003,7.1411133e-003,7.3242188e-003,8.0871582e-003,8.4838867e-003,8.3618164e-003,7.5073242e-003,6.1645508e-003,5.7983398e-003,6.1035156e-003,6.2561035e-003,6.1035156e-003,5.1574707e-003,3.8146973e-003,3.7231445e-003,4.1503906e-003,5.7067871e-003,7.5683594e-003,7.9345703e-003,7.4157715e-003,7.2631836e-003,6.2255859e-003,6.2255859e-003,6.7443848e-003,6.0729980e-003,6.0119629e-003,5.9204102e-003,6.8054199e-003,7.1105957e-003,8.4533691e-003,9.6740723e-003,9.4299316e-003,1.0498047e-002,1.0681152e-002,1.0742188e-002,1.0833740e-002,9.6130371e-003,8.2397461e-003,9.0332031e-003,1.0162354e-002,1.1474609e-002,1.2939453e-002,1.2542725e-002,1.1596680e-002,1.1932373e-002,1.2268066e-002,1.2512207e-002,1.2481689e-002,1.0009766e-002,8.0566406e-003,7.8735352e-003,8.5144043e-003,1.0437012e-002,1.2542725e-002,1.0772705e-002,7.1411133e-003,6.2255859e-003,5.6762695e-003,7.6293945e-003,1.0864258e-002,9.6435547e-003,7.9650879e-003,6.7443848e-003,5.4321289e-003,7.2326660e-003,1.0253906e-002,9.3994141e-003,8.0871582e-003,5.8593750e-003,3.6621094e-003,5.1269531e-003,7.3547363e-003,7.9956055e-003,8.5144043e-003,8.0261230e-003,6.9274902e-003,9.3383789e-003,1.1138916e-002,1.0894775e-002,1.0498047e-002,9.5214844e-003,8.9111328e-003,1.1474609e-002,1.3916016e-002,1.3336182e-002,1.2969971e-002,1.0070801e-002,6.7749023e-003,8.7890625e-003,1.2207031e-002,1.2664795e-002,1.2664795e-002,9.3078613e-003,4.8217773e-003,5.8288574e-003,8.7585449e-003,1.1657715e-002,1.5014648e-002,1.3092041e-002,8.7890625e-003,8.3618164e-003,8.1481934e-003,1.0467529e-002,1.4221191e-002,1.3122559e-002,1.1505127e-002,1.0375977e-002,8.6975098e-003,1.0009766e-002,1.1871338e-002,1.1230469e-002,1.0711670e-002,9.5825195e-003,8.2702637e-003,9.8266602e-003,1.1810303e-002,1.1932373e-002,1.1932373e-002,1.1047363e-002,9.4299316e-003,1.1108398e-002,1.3153076e-002,1.4129639e-002,1.4984131e-002,1.3397217e-002,1.1230469e-002,1.0681152e-002,1.1077881e-002,1.2939453e-002,1.5625000e-002,1.5716553e-002,1.5075684e-002,1.3061523e-002,1.0314941e-002,1.0040283e-002,1.0894775e-002,1.2420654e-002,1.4801025e-002,1.3824463e-002,1.2176514e-002,1.0803223e-002,8.1787109e-003,7.2631836e-003,8.0871582e-003,8.3618164e-003,8.9721680e-003,8.5144043e-003,8.1481934e-003,8.9721680e-003,9.7351074e-003,1.0498047e-002,1.0894775e-002,9.6740723e-003,8.4533691e-003,7.6599121e-003,6.9580078e-003,7.0190430e-003,7.5378418e-003,7.6599121e-003,7.7514648e-003,8.6059570e-003,8.8195801e-003,9.9792480e-003,1.1047363e-002,1.1413574e-002,1.2176514e-002,1.3122559e-002,1.3946533e-002,1.4099121e-002,1.4282227e-002,1.3000488e-002,1.2084961e-002,1.2054443e-002,1.2512207e-002,1.3702393e-002,1.4831543e-002,1.4648438e-002,1.4160156e-002,1.4831543e-002,1.5136719e-002,1.6662598e-002,1.7944336e-002,1.6967773e-002,1.4709473e-002,1.2023926e-002,9.1857910e-003,9.4299316e-003,1.1993408e-002,1.3824463e-002,1.6815186e-002,1.7700195e-002,1.6693115e-002,1.7028809e-002,1.5838623e-002,1.5594482e-002,1.6174316e-002,1.5869141e-002,1.6174316e-002,1.5930176e-002,1.7669678e-002,1.8249512e-002,1.8463135e-002,1.8493652e-002,1.7822266e-002,1.8280029e-002,1.8585205e-002,1.8310547e-002,1.8066406e-002,1.6235352e-002,1.3885498e-002,1.3031006e-002,1.2695313e-002,1.2969971e-002,1.4770508e-002,1.3977051e-002,1.3061523e-002,1.2481689e-002,1.0650635e-002,1.0925293e-002,1.1535645e-002,1.2603760e-002,1.3458252e-002,1.3397217e-002,1.2603760e-002,1.1108398e-002,9.5520020e-003,8.0566406e-003,7.4157715e-003,8.2702637e-003,9.7961426e-003,1.0986328e-002,1.1993408e-002,1.1413574e-002,9.7656250e-003,9.7656250e-003,9.2163086e-003,9.3078613e-003,1.0528564e-002,9.7656250e-003,9.4909668e-003,9.5825195e-003,8.9721680e-003,9.4909668e-003,9.6740723e-003,9.3688965e-003,8.7890625e-003,9.1857910e-003,9.8266602e-003,1.0986328e-002,1.1657715e-002,1.1291504e-002,1.0650635e-002,1.0681152e-002,1.0894775e-002,1.1688232e-002,1.2084961e-002,1.0833740e-002,1.0498047e-002,9.8571777e-003,9.6740723e-003,1.1077881e-002,1.3153076e-002,1.3671875e-002,1.4068604e-002,1.3885498e-002,1.2695313e-002,1.3061523e-002,1.3153076e-002,1.2908936e-002,1.3214111e-002,1.2939453e-002,1.2847900e-002,1.2664795e-002,1.2054443e-002,1.1016846e-002,1.0375977e-002,1.0223389e-002,1.1199951e-002,1.2237549e-002,1.3214111e-002,1.2512207e-002,1.0955811e-002,1.1199951e-002,1.0650635e-002,1.2084961e-002,1.3702393e-002,1.3641357e-002,1.2695313e-002,1.1993408e-002,1.1383057e-002,1.2451172e-002,1.4434814e-002,1.5319824e-002,1.6296387e-002,1.6113281e-002,1.5472412e-002,1.6174316e-002,1.6265869e-002,1.6723633e-002,1.6754150e-002,1.6296387e-002,1.6540527e-002,1.7120361e-002,1.7974854e-002,1.8310547e-002,1.8646240e-002,1.8737793e-002,1.8646240e-002,1.9195557e-002,1.9592285e-002,1.7517090e-002,1.6357422e-002,1.6235352e-002,1.6113281e-002,1.8280029e-002,2.0874023e-002,2.1026611e-002,2.0477295e-002,1.8981934e-002,1.6876221e-002,1.7211914e-002,1.7730713e-002,1.7456055e-002,1.7608643e-002,1.5991211e-002,1.4282227e-002,1.5441895e-002,1.6479492e-002,1.7608643e-002,1.8524170e-002,1.7211914e-002,1.5502930e-002,1.4953613e-002,1.5594482e-002,1.6754150e-002,1.8463135e-002,1.8127441e-002,1.7486572e-002,1.7242432e-002,1.6387939e-002,1.7608643e-002,1.8280029e-002,1.7425537e-002,1.6265869e-002,1.4831543e-002,1.3336182e-002,1.3305664e-002,1.4526367e-002,1.4984131e-002,1.6174316e-002,1.6174316e-002,1.5289307e-002,1.4678955e-002,1.4190674e-002,1.4068604e-002,1.4526367e-002,1.3946533e-002,1.2969971e-002,1.2054443e-002,1.0559082e-002,1.0711670e-002,1.1230469e-002,1.2359619e-002,1.3916016e-002,1.4312744e-002,1.3732910e-002,1.3275146e-002,1.2512207e-002,1.2542725e-002,1.4617920e-002,1.4923096e-002,1.5960693e-002,1.5655518e-002,1.4770508e-002,1.4709473e-002,1.4526367e-002,1.4556885e-002,1.4526367e-002,1.3702393e-002,1.2847900e-002,1.2420654e-002,1.1993408e-002,1.3122559e-002,1.4038086e-002,1.5014648e-002,1.5625000e-002,1.5716553e-002,1.4831543e-002,1.4709473e-002,1.4099121e-002,1.4556885e-002,1.4953613e-002,1.4678955e-002,1.5106201e-002,1.4404297e-002,1.3488770e-002,1.2664795e-002,1.2268066e-002,1.2115479e-002,1.2268066e-002,1.2268066e-002,1.1718750e-002,1.1932373e-002,1.1840820e-002,1.2451172e-002,1.3458252e-002,1.4770508e-002,1.5563965e-002,1.5197754e-002,1.5014648e-002,1.5441895e-002,1.5655518e-002,1.5869141e-002,1.6235352e-002,1.5563965e-002,1.4465332e-002,1.3793945e-002,1.3061523e-002,1.3031006e-002,1.3153076e-002,1.2908936e-002,1.2329102e-002,1.2145996e-002,1.0589600e-002,1.0833740e-002,1.2145996e-002,1.2237549e-002,1.2634277e-002,1.2359619e-002,1.2054443e-002,1.1688232e-002,1.1444092e-002,1.1322021e-002,1.1596680e-002,1.1596680e-002,1.1718750e-002,1.1383057e-002,1.1199951e-002,1.1413574e-002,1.1596680e-002,1.1932373e-002,1.2573242e-002,1.2725830e-002,1.3031006e-002,1.2664795e-002,1.2084961e-002,1.2023926e-002,1.1474609e-002,1.1352539e-002,1.1291504e-002,1.1322021e-002,1.1688232e-002,1.2237549e-002,1.2481689e-002,1.2237549e-002,1.1688232e-002,1.0925293e-002,1.0040283e-002,9.9487305e-003,1.0131836e-002,1.0253906e-002,1.0925293e-002,1.0681152e-002,1.0162354e-002,1.0406494e-002,1.0040283e-002,1.0223389e-002,1.0009766e-002,9.6435547e-003,9.3688965e-003,9.7656250e-003,1.0223389e-002,1.0101318e-002,1.0253906e-002,9.6130371e-003,8.6975098e-003,8.3923340e-003,8.2702637e-003,8.3007813e-003,9.1857910e-003,8.1787109e-003,8.5144043e-003,9.3688965e-003,9.4299316e-003,1.0253906e-002,1.0528564e-002,1.0009766e-002,9.0942383e-003,8.5449219e-003,7.7209473e-003,8.0261230e-003,9.0026855e-003,9.0942383e-003,9.6435547e-003,9.9487305e-003,9.7351074e-003,9.9182129e-003,9.9487305e-003,1.0009766e-002,1.0559082e-002,1.0803223e-002,1.1108398e-002,1.1413574e-002,1.1718750e-002,1.1749268e-002,1.1871338e-002,1.2207031e-002,1.1627197e-002,1.1230469e-002,9.7351074e-003,8.3923340e-003,7.2021484e-003,6.7138672e-003,6.7443848e-003,6.8969727e-003,7.2937012e-003,6.8054199e-003,6.4697266e-003,6.2866211e-003,6.1340332e-003,6.7749023e-003,7.9040527e-003,8.3923340e-003,8.7585449e-003,8.3312988e-003,7.0495605e-003,6.2866211e-003,6.0729980e-003,6.8054199e-003,8.5144043e-003,9.8266602e-003,1.0620117e-002,1.0742188e-002,8.5754395e-003,7.5683594e-003,5.8898926e-003,5.0964355e-003,7.0190430e-003,6.5917969e-003,7.0495605e-003,6.5307617e-003,6.0729980e-003,5.9204102e-003,6.1035156e-003,6.6223145e-003,6.7138672e-003,6.4392090e-003,6.5002441e-003,6.5307617e-003,6.5307617e-003,6.0729980e-003,5.1269531e-003,4.1809082e-003,3.2958984e-003,3.0212402e-003,3.4790039e-003,3.6010742e-003,3.6010742e-003,3.0822754e-003,2.5024414e-003,2.6245117e-003,2.7770996e-003,2.4414063e-003,2.2888184e-003,1.4648438e-003,8.2397461e-004,1.2512207e-003,2.4414063e-003,3.4484863e-003,4.0893555e-003,4.2114258e-003,3.5400391e-003,3.8146973e-003,3.8452148e-003,4.3640137e-003,5.2795410e-003,5.1269531e-003,4.8217773e-003,4.3334961e-003,3.3569336e-003,2.1362305e-003,6.7138672e-004,-9.1552734e-004,-2.1667480e-003,-2.4719238e-003,-1.7089844e-003,-2.4414063e-004,1.1291504e-003,2.1667480e-003,1.9531250e-003,2.2277832e-003,1.7395020e-003,2.2888184e-003,2.1362305e-003,1.2817383e-003,1.4953613e-003,6.7138672e-004,1.0375977e-003,2.1362305e-003,4.0588379e-003,4.1809082e-003,3.4484863e-003,1.9531250e-003,-4.5776367e-004,-1.0986328e-003,-4.5776367e-004,6.4086914e-004,2.4719238e-003,2.1057129e-003,7.6293945e-004,-2.7465820e-004,-2.3803711e-003,-2.5634766e-003,-1.9226074e-003,-9.4604492e-004,1.6784668e-003,3.8146973e-003,5.4931641e-003,5.3100586e-003,3.0517578e-003,3.0517578e-005,-4.0283203e-003,-5.2185059e-003,-3.2653809e-003,-3.9672852e-004,4.3945313e-003,4.2724609e-003,1.9226074e-003,-4.8828125e-004,-5.0354004e-003,-3.6010742e-003,-8.2397461e-004,4.8828125e-004,2.8076172e-003,3.9672852e-004,-3.3264160e-003,-3.5095215e-003,-3.7536621e-003,-2.1362305e-003,7.6293945e-004,-8.5449219e-004,-1.9836426e-003,-1.5869141e-003,-1.1596680e-003,2.1667480e-003,5.8593750e-003,5.6152344e-003,3.8452148e-003,1.9531250e-003,-2.0751953e-003,-2.1667480e-003,1.0681152e-003,1.8310547e-003,3.7536621e-003,3.5400391e-003,1.8310547e-003,2.3498535e-003,1.8005371e-003,1.7700195e-003,2.4414063e-003,2.6245117e-003,3.3264160e-003,3.6926270e-003,4.0893555e-003,3.4790039e-003,2.5634766e-003,1.4953613e-003,1.7089844e-003,3.2653809e-003,4.9743652e-003,5.3405762e-003,5.2795410e-003,3.6621094e-003,8.5449219e-004,9.1552734e-004,1.7395020e-003,3.1127930e-003,5.8593750e-003,5.9814453e-003,4.8522949e-003,4.5471191e-003,2.8991699e-003,3.2653809e-003,4.8522949e-003,4.9133301e-003,5.6152344e-003,5.3100586e-003,4.5166016e-003,4.0893555e-003,3.3874512e-003,2.7770996e-003,2.4719238e-003,1.7700195e-003,6.1035156e-004,-7.0190430e-004,-1.4648438e-003,-1.7395020e-003,-1.7700195e-003,-1.7395020e-003,-1.2207031e-003,-4.8828125e-004,-1.5258789e-004,3.9672852e-004,4.8828125e-004,9.1552734e-004,1.3122559e-003,1.7700195e-003,1.3122559e-003,1.0070801e-003,2.1057129e-003,2.3193359e-003,2.6550293e-003,3.7231445e-003,5.0354004e-003,5.1879883e-003,4.8522949e-003,4.0283203e-003,2.5939941e-003,3.2043457e-003,3.6315918e-003,3.8452148e-003,4.6386719e-003,3.8757324e-003,3.0517578e-003,2.3498535e-003,1.9836426e-003,2.1362305e-003,3.1127930e-003,2.9907227e-003,2.8076172e-003,2.7465820e-003,2.2583008e-003,2.4414063e-003,2.1972656e-003,1.6784668e-003,1.1291504e-003,1.2207031e-003,1.6479492e-003,2.2583008e-003,3.2958984e-003,2.8381348e-003,2.1362305e-003,1.2207031e-003,-6.1035156e-005,-1.2207031e-004,2.1362305e-004,-1.8310547e-004,1.5258789e-004,1.5258789e-004,-4.2724609e-004,-3.0517578e-005,7.3242188e-004,1.1596680e-003,1.4038086e-003,1.6174316e-003,1.1596680e-003,1.2512207e-003,1.4648438e-003,1.8615723e-003,2.3193359e-003,2.1362305e-003,2.5024414e-003,1.3122559e-003,1.7700195e-003,2.0751953e-003,2.1362305e-003,3.1127930e-003,3.7841797e-003,4.2419434e-003,4.3029785e-003,3.7231445e-003,2.2888184e-003,1.5258789e-003,1.4648438e-003,1.8005371e-003,2.8381348e-003,3.1127930e-003,2.7770996e-003,2.9602051e-003,3.0212402e-003,3.9978027e-003,5.1574707e-003,5.3710938e-003,5.4931641e-003,5.0659180e-003,4.6081543e-003,4.4555664e-003,4.8217773e-003,5.2185059e-003,5.8288574e-003,5.8593750e-003,5.5236816e-003,5.2185059e-003,4.5471191e-003,4.2419434e-003,3.8452148e-003,4.3029785e-003,4.8828125e-003,5.2795410e-003,4.8522949e-003,3.6315918e-003,2.1057129e-003,1.7395020e-003,1.7395020e-003,2.3193359e-003,3.2958984e-003,2.8686523e-003,2.4414063e-003,1.8310547e-003,1.2512207e-003,1.8005371e-003,2.1972656e-003,2.5024414e-003,2.8686523e-003,3.1127930e-003,2.8991699e-003,2.7465820e-003,1.8920898e-003,1.2512207e-003,7.9345703e-004,2.7465820e-004,1.8005371e-003,2.8991699e-003,3.6926270e-003,3.6315918e-003,3.2043457e-003,3.0822754e-003,3.0517578e-003,2.4108887e-003,1.5563965e-003,-3.0517578e-005,-1.0986328e-003,-1.0375977e-003,-4.5776367e-004,6.4086914e-004,1.7089844e-003,1.7089844e-003,1.0986328e-003,1.4953613e-003,1.1596680e-003,2.1362305e-003,3.0517578e-003,3.0212402e-003,2.5024414e-003,2.4108887e-003,2.6855469e-003,3.5095215e-003,4.2114258e-003,4.3945313e-003,4.6081543e-003,4.9438477e-003,5.5236816e-003,6.2255859e-003,6.9274902e-003,6.1645508e-003,5.0354004e-003,4.3334961e-003,3.9062500e-003,4.7607422e-003,5.9509277e-003,5.9814453e-003,5.3405762e-003,4.0893555e-003,2.1972656e-003,1.7700195e-003,1.6479492e-003,1.6784668e-003,2.5024414e-003,2.2277832e-003,2.0446777e-003,1.0375977e-003,-6.1035156e-005,-1.2512207e-003,-2.3498535e-003,-3.9367676e-003,-3.9978027e-003,-3.2348633e-003,-3.0212402e-003,-2.2277832e-003,-2.4414063e-003,-2.2277832e-003,-2.5024414e-003,-2.3193359e-003,-2.8076172e-003,-2.8076172e-003,-2.7770996e-003,-2.3193359e-003,-8.8500977e-004,-3.0517578e-004,6.4086914e-004,-1.5258789e-004,-1.9836426e-003,-2.8076172e-003,-3.3874512e-003,-2.1057129e-003,4.8828125e-004,2.4414063e-003,3.9978027e-003,4.4250488e-003,3.2348633e-003,3.4179688e-003,3.2043457e-003,3.2958984e-003,3.6621094e-003,3.3264160e-003,2.8076172e-003,2.8076172e-003,3.1127930e-003,3.7841797e-003,4.6997070e-003,5.3100586e-003,5.5847168e-003,6.0424805e-003,6.7138672e-003,6.5002441e-003,6.3476563e-003,5.2490234e-003,3.6010742e-003,2.9907227e-003,2.8686523e-003,3.3874512e-003,5.0354004e-003,5.9509277e-003,6.3171387e-003,6.3781738e-003,5.6152344e-003,5.4931641e-003,4.8522949e-003,3.8146973e-003,3.0517578e-003,2.3803711e-003,2.6245117e-003,2.5024414e-003,3.9367676e-003,4.5471191e-003,4.2419434e-003,3.9062500e-003,2.8991699e-003,2.8076172e-003,3.4790039e-003,3.8146973e-003,3.9978027e-003,3.2653809e-003,2.1667480e-003,1.4038086e-003,6.1035156e-004,5.4931641e-004,8.8500977e-004,1.1291504e-003,1.4953613e-003,1.0070801e-003,1.2207031e-004,-8.8500977e-004,-2.3193359e-003,-2.7770996e-003,-2.0751953e-003,-1.3122559e-003,6.1035156e-005,-5.1879883e-004,-2.1667480e-003,-2.6855469e-003,-3.9978027e-003,-3.6621094e-003,-1.8005371e-003,-1.1596680e-003,-2.7465820e-004,1.2207031e-004,1.8310547e-004,1.0681152e-003,1.7700195e-003,2.0141602e-003,2.7160645e-003,2.7465820e-003,2.7160645e-003,2.6855469e-003,3.1738281e-003,2.4719238e-003,1.4648438e-003,2.1667480e-003,2.7770996e-003,3.6621094e-003,3.8757324e-003,2.4108887e-003,-1.2207031e-004,-3.3569336e-004,-6.1035156e-004,8.5449219e-004,2.9602051e-003,7.0190430e-004,-9.4604492e-004,-3.9978027e-003,-6.1340332e-003,-3.7841797e-003,2.4414063e-004,1.2512207e-003,2.0141602e-003,-5.4931641e-004,-5.3710938e-003,-5.3405762e-003,-4.6386719e-003,-2.6245117e-003,7.9345703e-004,0.0000000e+000,-2.0141602e-003,-2.6855469e-003,-3.9367676e-003,-2.6550293e-003,-3.9672852e-004,-8.2397461e-004,-1.3732910e-003,-3.0212402e-003,-5.2490234e-003,-5.6762695e-003,-4.9133301e-003,-3.6621094e-003,-1.7700195e-003,-1.6174316e-003,-2.2583008e-003,-3.4484863e-003,-5.3405762e-003,-5.3710938e-003,-5.4016113e-003,-5.0354004e-003,-4.4860840e-003,-5.9204102e-003,-7.8430176e-003,-8.6669922e-003,-9.3994141e-003,-7.6599121e-003,-5.4016113e-003,-4.7912598e-003,-4.2724609e-003,-5.0048828e-003,-6.3171387e-003,-6.1645508e-003,-5.7983398e-003,-6.1950684e-003,-5.5541992e-003,-6.2866211e-003,-6.5307617e-003,-5.0048828e-003,-3.0212402e-003,-1.0070801e-003,1.8310547e-004,3.9672852e-004,-1.3427734e-003,-1.9836426e-003,-2.6855469e-003,-3.7841797e-003,-3.8452148e-003,-4.6386719e-003,-4.6081543e-003,-4.3945313e-003,-3.6010742e-003,-2.8686523e-003,-2.4719238e-003,-2.2583008e-003,-2.5024414e-003,-2.1362305e-003,-2.0446777e-003,-2.6855469e-003,-2.8686523e-003,-3.5095215e-003,-3.2653809e-003,-2.3498535e-003,-1.3732910e-003,-7.9345703e-004,-7.9345703e-004,-1.0070801e-003,-2.2583008e-003,-2.3803711e-003,-1.7395020e-003,-1.2512207e-003,-1.5258789e-004,1.8310547e-004,-3.0517578e-005,3.0517578e-005,-7.9345703e-004,-2.1667480e-003,-3.5705566e-003,-4.1809082e-003,-3.8757324e-003,-3.1738281e-003,-2.2277832e-003,-2.1057129e-003,-2.5329590e-003,-2.7160645e-003,-3.5705566e-003,-2.8686523e-003,-2.3498535e-003,-3.3569336e-003,-4.7302246e-003,-6.1035156e-003,-6.5307617e-003,-4.7607422e-003,-1.4953613e-003,6.4086914e-004,1.7089844e-003,1.1901855e-003,-1.6174316e-003,-2.2888184e-003,-2.7160645e-003,-2.4719238e-003,7.6293945e-004,3.9672852e-004,2.1362305e-004,-6.1035156e-004,-2.3803711e-003,-1.9836426e-003,-2.2277832e-003,-1.6479492e-003,-1.2207031e-004,6.7138672e-004,1.1901855e-003,1.4953613e-003,1.0681152e-003,5.7983398e-004,2.4414063e-004,6.1035156e-005,3.0517578e-004,6.7138672e-004,6.1035156e-004,-6.1035156e-005,-7.0190430e-004,-9.4604492e-004,-9.1552734e-004,-2.4414063e-004,1.5258789e-004,-3.0517578e-004,-1.0986328e-003,-1.8615723e-003,-2.5024414e-003,-2.0751953e-003,-1.0681152e-003,-1.0681152e-003,-1.1291504e-003,-2.6245117e-003,-4.5166016e-003,-4.5166016e-003,-3.8452148e-003,-3.0822754e-003,-1.9226074e-003,-2.6855469e-003,-3.7536621e-003,-3.8757324e-003,-4.4860840e-003,-3.2348633e-003,-1.7089844e-003,-1.8310547e-003,-2.4108887e-003,-3.1433105e-003,-4.2114258e-003,-3.2348633e-003,-1.1901855e-003,-5.7983398e-004,-3.0517578e-005,-1.4648438e-003,-4.0283203e-003,-4.2419434e-003,-5.0964355e-003,-4.9438477e-003,-2.3498535e-003,-2.8076172e-003,-3.2348633e-003,-3.2348633e-003,-4.3029785e-003,-4.4555664e-003,-4.7607422e-003,-5.7067871e-003,-6.2561035e-003,-6.1340332e-003,-6.1645508e-003,-6.2561035e-003,-6.2561035e-003,-7.4462891e-003,-8.5754395e-003,-8.9416504e-003,-8.9416504e-003,-8.2397461e-003,-7.3242188e-003,-7.7209473e-003,-8.3618164e-003,-8.6059570e-003,-8.7585449e-003,-7.5073242e-003,-5.8593750e-003,-5.1269531e-003,-4.3334961e-003,-4.6081543e-003,-6.4086914e-003,-6.5917969e-003,-6.7138672e-003,-6.7138672e-003,-5.8288574e-003,-6.0729980e-003,-6.0424805e-003,-6.3781738e-003,-7.2021484e-003,-7.0495605e-003,-6.5612793e-003,-6.3781738e-003,-5.9509277e-003,-6.8359375e-003,-7.8735352e-003,-7.7209473e-003,-6.9274902e-003,-6.2561035e-003,-5.0659180e-003,-5.2795410e-003,-6.4697266e-003,-7.3547363e-003,-8.3618164e-003,-7.7209473e-003,-6.3476563e-003,-6.6223145e-003,-5.6457520e-003,-6.0424805e-003,-7.1411133e-003,-6.8359375e-003,-6.7443848e-003,-5.9204102e-003,-4.8828125e-003,-5.0354004e-003,-5.3710938e-003,-6.1340332e-003,-7.0800781e-003,-7.1716309e-003,-6.7443848e-003,-5.7678223e-003,-3.9978027e-003,-2.0446777e-003,-5.7983398e-004,1.5258789e-004,-8.8500977e-004,-2.7465820e-003,-5.7067871e-003,-8.2092285e-003,-9.5520020e-003,-9.1247559e-003,-6.4392090e-003,-4.5776367e-003,-2.6245117e-003,-3.3264160e-003,-6.2561035e-003,-8.0261230e-003,-1.0894775e-002,-1.1199951e-002,-9.6740723e-003,-1.0070801e-002,-9.3078613e-003,-9.7045898e-003,-1.0833740e-002,-9.0026855e-003,-7.1411133e-003,-5.2185059e-003,-3.9978027e-003,-4.9133301e-003,-7.1105957e-003,-8.3923340e-003,-9.2163086e-003,-9.4909668e-003,-8.4228516e-003,-8.7585449e-003,-8.4838867e-003,-7.3242188e-003,-5.9204102e-003,-4.3640137e-003,-3.3264160e-003,-3.8452148e-003,-6.1950684e-003,-7.7209473e-003,-9.2468262e-003,-1.0101318e-002,-7.9956055e-003,-7.7209473e-003,-6.5612793e-003,-5.7067871e-003,-5.4016113e-003,-4.2419434e-003,-4.2419434e-003,-4.6386719e-003,-6.0119629e-003,-6.9885254e-003,-7.4157715e-003,-7.0495605e-003,-5.5847168e-003,-5.6152344e-003,-5.4626465e-003,-5.0048828e-003,-5.4016113e-003,-4.9743652e-003,-5.4321289e-003,-6.4697266e-003,-7.5683594e-003,-8.3618164e-003,-8.9721680e-003,-9.0026855e-003,-7.7209473e-003,-7.3852539e-003,-7.1105957e-003,-7.1411133e-003,-8.0566406e-003,-7.9650879e-003,-8.0871582e-003,-8.4228516e-003,-8.5144043e-003,-9.4604492e-003,-1.0284424e-002,-1.1138916e-002,-1.1688232e-002,-1.1596680e-002,-1.1413574e-002,-1.0986328e-002,-1.0253906e-002,-9.6130371e-003,-9.2163086e-003,-8.4228516e-003,-7.9650879e-003,-7.5073242e-003,-7.5073242e-003,-8.9416504e-003,-1.0253906e-002,-1.1474609e-002,-1.1260986e-002,-1.0375977e-002,-7.9040527e-003,-8.2702637e-003,-9.2163086e-003,-9.3078613e-003,-1.1413574e-002,-1.0742188e-002,-1.0192871e-002,-9.4299316e-003,-8.5449219e-003,-9.1857910e-003,-1.0467529e-002,-1.0437012e-002,-1.0345459e-002,-9.4604492e-003,-8.5754395e-003,-8.7280273e-003,-9.3078613e-003,-9.4299316e-003,-1.0070801e-002,-1.0437012e-002,-1.0070801e-002,-1.0559082e-002,-1.0559082e-002,-1.0406494e-002,-9.9182129e-003,-9.3688965e-003,-8.8195801e-003,-8.7585449e-003,-8.9111328e-003,-8.4228516e-003,-8.1176758e-003,-7.5378418e-003,-6.9274902e-003,-7.0800781e-003,-7.2937012e-003,-7.1411133e-003,-5.9814453e-003,-5.1879883e-003,-4.5471191e-003,-5.0354004e-003,-6.6223145e-003,-7.9040527e-003,-8.8500977e-003,-8.9416504e-003,-8.6669922e-003,-8.6975098e-003,-7.5378418e-003,-6.7749023e-003,-6.4086914e-003,-5.8593750e-003,-6.5307617e-003,-6.9580078e-003,-8.8195801e-003,-1.0711670e-002,-1.2542725e-002,-1.3519287e-002,-1.3458252e-002,-1.2634277e-002,-1.0894775e-002,-1.0253906e-002,-8.3312988e-003,-7.5378418e-003,-6.9274902e-003,-6.8969727e-003,-7.1105957e-003,-7.8430176e-003,-8.7280273e-003,-8.7890625e-003,-9.1552734e-003,-9.3688965e-003,-9.0637207e-003,-9.3688965e-003,-1.0742188e-002,-1.0650635e-002,-9.9792480e-003,-7.5683594e-003,-4.5776367e-003,-2.7160645e-003,-1.2817383e-003,-2.4414063e-003,-5.0354004e-003,-7.0495605e-003,-8.6059570e-003,-9.3688965e-003,-7.2631836e-003,-6.7138672e-003,-4.9133301e-003,-3.1127930e-003,-2.5329590e-003,-1.2512207e-003,-2.1667480e-003,-3.6315918e-003,-5.7983398e-003,-7.2937012e-003,-7.5073242e-003,-7.1716309e-003,-5.3100586e-003,-5.5236816e-003,-6.8664551e-003,-8.7280273e-003,-1.1260986e-002,-1.0620117e-002,-8.4838867e-003,-6.1340332e-003,-2.7160645e-003,-1.4038086e-003,-1.8615723e-003,-2.7465820e-003,-5.4016113e-003,-6.8359375e-003,-7.3242188e-003,-7.1411133e-003,-5.6762695e-003,-4.1503906e-003,-2.4108887e-003,-2.0141602e-003,-1.3427734e-003,-1.1291504e-003,-2.4108887e-003,-3.5095215e-003,-4.5776367e-003,-6.1645508e-003,-5.9204102e-003,-6.1950684e-003,-5.6762695e-003,-5.8898926e-003,-7.4157715e-003,-8.4228516e-003,-1.0284424e-002,-1.0192871e-002,-9.1247559e-003,-7.3242188e-003,-5.3405762e-003,-5.5847168e-003,-6.8664551e-003,-7.2937012e-003,-9.0026855e-003,-9.5825195e-003,-9.8876953e-003,-1.1779785e-002,-1.2268066e-002,-1.2817383e-002,-1.2512207e-002,-1.1230469e-002,-9.0332031e-003,-7.8735352e-003,-8.0566406e-003,-8.5144043e-003,-9.8876953e-003,-9.8571777e-003,-9.7351074e-003,-1.0101318e-002,-1.0040283e-002,-1.1199951e-002,-1.2786865e-002,-1.2878418e-002,-1.2725830e-002,-1.1962891e-002,-1.0284424e-002,-9.1857910e-003,-8.3312988e-003,-7.7819824e-003,-7.7819824e-003,-6.7749023e-003,-6.0119629e-003,-6.3171387e-003,-6.4086914e-003,-7.7514648e-003,-8.9721680e-003,-9.1857910e-003,-9.1552734e-003,-8.4533691e-003,-7.9956055e-003,-7.4462891e-003,-6.3476563e-003,-5.9204102e-003,-5.5541992e-003,-5.2185059e-003,-4.8217773e-003,-5.6762695e-003,-6.5612793e-003,-7.1105957e-003,-7.3852539e-003,-7.7209473e-003,-6.3781738e-003,-6.5002441e-003,-6.8054199e-003,-6.8359375e-003,-6.9580078e-003,-5.3710938e-003,-3.9062500e-003,-3.4179688e-003,-3.7536621e-003,-5.5541992e-003,-7.7209473e-003,-7.5988770e-003,-6.9580078e-003,-5.7983398e-003,-3.9978027e-003,-4.4250488e-003,-5.6762695e-003,-5.6762695e-003,-5.6152344e-003,-3.7536621e-003,-1.1291504e-003,-9.7656250e-004,-1.4953613e-003,-2.8381348e-003,-4.7302246e-003,-5.1879883e-003,-5.5847168e-003,-5.4016113e-003,-5.2795410e-003,-6.2561035e-003,-7.2021484e-003,-6.5002441e-003,-5.1269531e-003,-3.3569336e-003,-1.6174316e-003,-2.4414063e-003,-4.1809082e-003,-5.3100586e-003,-6.1950684e-003,-5.9509277e-003,-4.4860840e-003,-4.2114258e-003,-3.8452148e-003,-4.3640137e-003,-5.9204102e-003,-6.3781738e-003,-5.3405762e-003,-4.2419434e-003,-2.7770996e-003,-1.8005371e-003,-1.6784668e-003,-1.6479492e-003,-3.5095215e-003,-4.5471191e-003,-5.7067871e-003,-6.5612793e-003,-6.6528320e-003,-6.5307617e-003,-5.8288574e-003,-6.0424805e-003,-6.9885254e-003,-7.4462891e-003,-7.8125000e-003,-7.2326660e-003,-6.3781738e-003,-6.8359375e-003,-6.6528320e-003,-7.1411133e-003,-8.3923340e-003,-8.9111328e-003,-9.7351074e-003,-1.0925293e-002,-1.1993408e-002,-1.3427734e-002,-1.4373779e-002,-1.3549805e-002,-1.2481689e-002,-1.1932373e-002,-1.1566162e-002,-1.2451172e-002,-1.3641357e-002,-1.3824463e-002,-1.4129639e-002,-1.4617920e-002,-1.4343262e-002,-1.4617920e-002,-1.4007568e-002,-1.2756348e-002,-1.0864258e-002,-1.0040283e-002,-1.0284424e-002,-1.0467529e-002,-1.1199951e-002,-9.5825195e-003,-7.0495605e-003,-5.8593750e-003,-5.7067871e-003,-8.0261230e-003,-1.1505127e-002,-1.1962891e-002,-1.1688232e-002,-1.0833740e-002,-9.1552734e-003,-9.9487305e-003,-9.7961426e-003,-9.0942383e-003,-8.8195801e-003,-7.7514648e-003,-7.2326660e-003,-8.4228516e-003,-1.0040283e-002,-1.1169434e-002,-1.1596680e-002,-1.1413574e-002,-1.0833740e-002,-1.1474609e-002,-1.2207031e-002,-1.1474609e-002,-1.0650635e-002,-9.5520020e-003,-8.8195801e-003,-9.4909668e-003,-1.0589600e-002,-1.0803223e-002,-1.0833740e-002,-1.1322021e-002,-1.1840820e-002,-1.3183594e-002,-1.3031006e-002,-9.7045898e-003,-5.4931641e-003,-3.6315918e-003,-4.3029785e-003,-7.8430176e-003,-1.3580322e-002,-1.2817383e-002,-9.5520020e-003,-6.0119629e-003,-1.1901855e-003,-3.9672852e-003,-9.7961426e-003,-1.1322021e-002,-1.2878418e-002,-9.3078613e-003,-3.6926270e-003,-5.0354004e-003,-7.3852539e-003,-9.8876953e-003,-1.2695313e-002,-9.4299316e-003,-4.9133301e-003,-5.0048828e-003,-5.7067871e-003,-8.0261230e-003,-1.1810303e-002,-1.0650635e-002,-7.5988770e-003,-8.3923340e-003,-8.0566406e-003,-1.0192871e-002,-1.3641357e-002,-1.2390137e-002,-1.0498047e-002,-9.6435547e-003,-8.6059570e-003,-9.7961426e-003,-1.1596680e-002,-1.0131836e-002,-8.7585449e-003,-8.3618164e-003,-8.5449219e-003,-1.1047363e-002,-1.4129639e-002,-1.3580322e-002,-1.1749268e-002,-1.0070801e-002,-7.7209473e-003,-8.3923340e-003,-1.0406494e-002,-1.0162354e-002,-1.0253906e-002,-9.5520020e-003,-8.2092285e-003,-9.1552734e-003,-1.0101318e-002,-1.0681152e-002,-1.0833740e-002,-1.0589600e-002,-9.9792480e-003,-1.0437012e-002,-1.1474609e-002,-1.1474609e-002,-1.1871338e-002,-1.1718750e-002,-1.1688232e-002,-1.2115479e-002,-1.3061523e-002,-1.3244629e-002,-1.2847900e-002,-1.2542725e-002,-1.1871338e-002,-1.1505127e-002,-1.1138916e-002,-1.0711670e-002,-1.0040283e-002,-9.4604492e-003,-9.0026855e-003,-8.0566406e-003,-7.3242188e-003,-6.1645508e-003,-5.1269531e-003,-5.3100586e-003,-6.3476563e-003,-7.2631836e-003,-8.0261230e-003,-8.2702637e-003,-6.1340332e-003,-5.5236816e-003,-5.0354004e-003,-5.5541992e-003,-7.1411133e-003,-6.9274902e-003,-6.6833496e-003,-5.8898926e-003,-5.0659180e-003,-6.1950684e-003,-7.3547363e-003,-8.3618164e-003,-9.3078613e-003,-9.5214844e-003,-8.8500977e-003,-8.0261230e-003,-6.8969727e-003,-6.5002441e-003,-7.1411133e-003,-7.5073242e-003,-8.6364746e-003,-8.8806152e-003,-9.0332031e-003,-8.6669922e-003,-7.1105957e-003,-6.7138672e-003,-6.9885254e-003,-7.2021484e-003,-8.5449219e-003,-8.9416504e-003,-8.8195801e-003,-8.6059570e-003,-7.4462891e-003,-7.0800781e-003,-6.6833496e-003,-6.7138672e-003,-7.9040527e-003,-8.4228516e-003,-9.2163086e-003,-9.6130371e-003,-9.3994141e-003,-9.0637207e-003,-8.5754395e-003,-8.6059570e-003,-9.0942383e-003,-9.0637207e-003,-9.0637207e-003,-8.2397461e-003,-7.2326660e-003,-7.2021484e-003,-6.7443848e-003,-7.1105957e-003,-6.9885254e-003,-7.2937012e-003,-7.3547363e-003,-6.6833496e-003,-7.1105957e-003,-7.0495605e-003,-7.2937012e-003,-6.3171387e-003,-5.1879883e-003,-4.7607422e-003,-4.7607422e-003,-5.4016113e-003,-7.2326660e-003,-8.0871582e-003,-8.9721680e-003,-9.6435547e-003,-9.5825195e-003,-9.9792480e-003,-9.6740723e-003,-9.4909668e-003,-9.8571777e-003,-1.0559082e-002,-1.1993408e-002,-1.3275146e-002,-1.4434814e-002,-1.3946533e-002,-1.2298584e-002,-1.1016846e-002,-9.4909668e-003,-9.8876953e-003,-1.1047363e-002,-1.1169434e-002,-1.1322021e-002,-1.0406494e-002,-9.0026855e-003,-9.0332031e-003,-9.2163086e-003,-9.0332031e-003,-9.5520020e-003,-9.4604492e-003,-8.0871582e-003,-8.7280273e-003,-9.3078613e-003,-1.0498047e-002,-1.2298584e-002,-1.2725830e-002,-1.2634277e-002,-1.2115479e-002,-1.1260986e-002,-1.0833740e-002,-1.0498047e-002,-9.2468262e-003,-8.5754395e-003,-8.3007813e-003,-8.4533691e-003,-8.8500977e-003,-9.4299316e-003,-8.7280273e-003,-8.3007813e-003,-8.7585449e-003,-7.5988770e-003,-7.9956055e-003,-8.3007813e-003,-7.5683594e-003,-6.8969727e-003,-6.1645508e-003,-5.8898926e-003,-6.5002441e-003,-8.1176758e-003,-8.7585449e-003,-9.4299316e-003,-9.5520020e-003,-8.8806152e-003,-8.6669922e-003,-8.0871582e-003,-6.8054199e-003,-6.6833496e-003,-6.6223145e-003,-6.6528320e-003,-7.1105957e-003,-7.1105957e-003,-7.0800781e-003,-7.3547363e-003,-7.2326660e-003,-6.3476563e-003,-5.8898926e-003,-5.2795410e-003,-4.5776367e-003,-4.5471191e-003,-5.8288574e-003,-6.6223145e-003,-6.7443848e-003,-6.2866211e-003,-5.2490234e-003,-4.4860840e-003,-4.3029785e-003,-4.4250488e-003,-4.0588379e-003,-3.8146973e-003,-2.6550293e-003,-1.8005371e-003,-3.1127930e-003,-4.3945313e-003,-5.5541992e-003,-6.2255859e-003,-5.6762695e-003,-4.8522949e-003,-5.2795410e-003,-6.3476563e-003,-6.8054199e-003,-6.7749023e-003,-5.0048828e-003,-3.8452148e-003,-3.6621094e-003,-5.4626465e-003,-8.7585449e-003,-9.8876953e-003,-8.1481934e-003,-4.5776367e-003,-3.3264160e-003,-1.9836426e-003,-3.6926270e-003,-6.8359375e-003,-6.4392090e-003,-5.1879883e-003,-3.3874512e-003,-1.6784668e-003,-3.1738281e-003,-5.5236816e-003,-6.8664551e-003,-8.2397461e-003,-7.1411133e-003,-4.8828125e-003,-4.5166016e-003,-4.1198730e-003,-3.4179688e-003,-4.2724609e-003,-3.8146973e-003,-3.8757324e-003,-4.6997070e-003,-4.7607422e-003,-4.7302246e-003,-3.9672852e-003,-2.7465820e-003,-1.9226074e-003,-2.0141602e-003,-2.3498535e-003,-2.1362305e-003,-1.8615723e-003,-1.1291504e-003,-3.9672852e-004,-1.0681152e-003,-1.6174316e-003,-1.8310547e-003,-1.9836426e-003,-9.7656250e-004,-3.0517578e-005,3.6621094e-004,-4.2724609e-004,-2.4414063e-004,-5.4931641e-004,-2.7465820e-004,-2.1362305e-004,-7.3242188e-004,-5.1879883e-004,2.7465820e-004,1.7700195e-003,1.8005371e-003,2.0751953e-003,1.7395020e-003,3.3569336e-004,1.2207031e-004,-8.2397461e-004,-1.2207031e-003,-7.0190430e-004,-1.8005371e-003,-2.8076172e-003,-2.6855469e-003,-2.2888184e-003,-1.0681152e-003,3.9672852e-004,0.0000000e+000,-8.2397461e-004,-1.4038086e-003,-1.7700195e-003,-9.1552734e-004,1.0375977e-003,1.4038086e-003,1.6479492e-003,8.5449219e-004,-5.4931641e-004,-6.7138672e-004,-9.1552734e-004,-7.0190430e-004,9.1552734e-005,1.8310547e-004,-1.2207031e-004,-3.9672852e-004,-5.7983398e-004,-6.7138672e-004,-8.8500977e-004,-1.1901855e-003,-8.8500977e-004,-9.4604492e-004,-7.3242188e-004,-7.3242188e-004,-8.5449219e-004,-6.7138672e-004,-7.3242188e-004,-8.5449219e-004,-1.4343262e-003,-1.8920898e-003,-2.7160645e-003,-2.7160645e-003,-2.5024414e-003,-2.5329590e-003,-2.8076172e-003,-3.1738281e-003,-4.1809082e-003,-4.9438477e-003,-5.0354004e-003,-4.9743652e-003,-4.7912598e-003,-5.1574707e-003,-6.0424805e-003,-6.2866211e-003,-6.1950684e-003,-5.7373047e-003,-4.8828125e-003,-5.7678223e-003,-5.3100586e-003,-6.0729980e-003,-6.8664551e-003,-6.5002441e-003,-5.3710938e-003,-4.4555664e-003,-3.8146973e-003,-3.5095215e-003,-3.3874512e-003,-2.4108887e-003,-1.8920898e-003,-1.6479492e-003,-1.7700195e-003,-2.2888184e-003,-2.9602051e-003,-2.6855469e-003,-1.8005371e-003,-1.6479492e-003,-8.2397461e-004,-9.7656250e-004,-1.3732910e-003,-1.1291504e-003,-1.2817383e-003,-1.5258789e-003,-2.3803711e-003,-2.8381348e-003,-2.8686523e-003,-1.8920898e-003,-1.0375977e-003,-7.3242188e-004,-1.1291504e-003,-1.8005371e-003,-2.8076172e-003,-2.1972656e-003,-2.1362305e-004,8.5449219e-004,1.9226074e-003,8.8500977e-004,-3.0517578e-004,3.0517578e-005,9.7656250e-004,2.1362305e-003,3.7536621e-003,4.2724609e-003,3.7536621e-003,3.6010742e-003,3.0212402e-003,2.9296875e-003,3.2348633e-003,2.8686523e-003,2.4108887e-003,2.9602051e-003,3.5095215e-003,5.1269531e-003,6.4697266e-003,6.6223145e-003,5.1269531e-003,4.0893555e-003,4.0588379e-003,3.1127930e-003,3.5095215e-003,3.0822754e-003,2.6245117e-003,2.6855469e-003,2.5024414e-003,2.8076172e-003,2.8381348e-003,2.4414063e-003,1.4648438e-003,8.8500977e-004,5.1879883e-004,6.4086914e-004,1.7395020e-003,2.1972656e-003,2.5329590e-003,2.5329590e-003,2.6855469e-003,2.5329590e-003,2.3498535e-003,2.0446777e-003,1.7395020e-003,1.8615723e-003,2.0446777e-003,2.4719238e-003,3.2958984e-003,3.3264160e-003,2.8381348e-003,2.6245117e-003,2.3193359e-003,2.1362305e-003,2.1972656e-003,1.8310547e-003,2.2583008e-003,2.5024414e-003,2.4719238e-003,2.4108887e-003,2.3498535e-003,2.6550293e-003,2.8381348e-003,3.8757324e-003,4.4250488e-003,4.0588379e-003,3.3874512e-003,2.2277832e-003,1.3732910e-003,2.4719238e-003,4.3334961e-003,5.3710938e-003,5.6152344e-003,4.3945313e-003,1.6479492e-003,6.1035156e-005,-4.8828125e-004,-2.4414063e-004,9.7656250e-004,6.7138672e-004,1.8310547e-004,1.8310547e-004,-9.1552734e-005,-2.1362305e-004,-3.0517578e-004,-1.5563965e-003,-2.7160645e-003,-2.1362305e-003,-8.8500977e-004,7.3242188e-004,2.2583008e-003,2.2888184e-003,9.4604492e-004,9.4604492e-004,1.2207031e-004,6.1035156e-004,1.9531250e-003,1.3732910e-003,5.7983398e-004,4.2724609e-004,-1.8310547e-004,6.1035156e-004,1.8615723e-003,1.7089844e-003,2.0141602e-003,2.0751953e-003,2.6550293e-003,2.8686523e-003,3.2653809e-003,2.5634766e-003,1.9226074e-003,1.2512207e-003,5.7983398e-004,1.0070801e-003,1.4038086e-003,1.7089844e-003,1.3122559e-003,1.3732910e-003,3.3569336e-004,1.8310547e-004,0.0000000e+000,-1.5258789e-004,9.1552734e-005,0.0000000e+000,6.7138672e-004,5.1879883e-004,1.1291504e-003,1.0070801e-003,1.3427734e-003,1.6784668e-003,1.5563965e-003,1.8615723e-003,2.0751953e-003,2.3193359e-003,3.8146973e-003,5.0659180e-003,4.9133301e-003,4.5166016e-003,2.5634766e-003,1.6174316e-003,2.0141602e-003,3.0822754e-003,5.0354004e-003,4.3334961e-003,3.3569336e-003,1.6784668e-003,-7.6293945e-004,-9.1552734e-004,0.0000000e+000,1.2207031e-003,3.2348633e-003,4.0588379e-003,4.0893555e-003,4.9438477e-003,5.0659180e-003,5.0048828e-003,4.7912598e-003,4.7302246e-003,5.3100586e-003,5.4931641e-003,6.2255859e-003,5.7067871e-003,4.6386719e-003,4.8217773e-003,5.0048828e-003,6.4392090e-003,8.2092285e-003,7.8735352e-003,6.2866211e-003,4.3640137e-003,1.9531250e-003,1.5869141e-003,2.8381348e-003,3.0517578e-003,3.9062500e-003,5.0354004e-003,6.0119629e-003,8.4533691e-003,9.0637207e-003,8.1176758e-003,5.0048828e-003,2.2277832e-003,7.6293945e-004,2.6855469e-003,7.0190430e-003,7.8735352e-003,9.3383789e-003,7.1105957e-003,2.8381348e-003,4.2724609e-003,5.6762695e-003,6.7443848e-003,9.1552734e-003,7.8735352e-003,5.0048828e-003,4.6386719e-003,4.5776367e-003,5.9814453e-003,8.8195801e-003,9.2773438e-003,9.0942383e-003,8.7890625e-003,7.2937012e-003,6.7443848e-003,6.3171387e-003,6.4086914e-003,7.3547363e-003,8.8806152e-003,1.0925293e-002,1.1047363e-002,9.9487305e-003,8.0261230e-003,5.8593750e-003,5.4931641e-003,6.2255859e-003,6.1950684e-003,6.7443848e-003,6.4697266e-003,5.6762695e-003,6.8664551e-003,7.9650879e-003,8.4533691e-003,7.6293945e-003,5.5847168e-003,3.8757324e-003,4.6081543e-003,6.6528320e-003,7.9040527e-003,9.6130371e-003,8.7890625e-003,6.6528320e-003,6.3476563e-003,6.1645508e-003,6.5002441e-003,7.7819824e-003,7.4768066e-003,7.1411133e-003,7.8430176e-003,8.4838867e-003,9.3078613e-003,9.1552734e-003,7.8430176e-003,5.0659180e-003,4.4555664e-003,3.8452148e-003,3.6926270e-003,5.6762695e-003,5.1879883e-003,4.5776367e-003,4.7912598e-003,4.3945313e-003,4.7607422e-003,4.8217773e-003,4.5166016e-003,3.6926270e-003,4.4555664e-003,5.6152344e-003,5.8898926e-003,5.8898926e-003,4.2419434e-003,2.2583008e-003,2.4414063e-003,4.3640137e-003,6.0729980e-003,8.2397461e-003,6.1645508e-003,2.7770996e-003,1.5563965e-003,6.1035156e-004,3.6621094e-003,8.2702637e-003,8.3618164e-003,7.0190430e-003,4.3945313e-003,6.1035156e-005,7.3242188e-004,3.7841797e-003,5.8288574e-003,9.2773438e-003,8.7890625e-003,6.1950684e-003,6.7138672e-003,6.6528320e-003,8.6059570e-003,1.1474609e-002,1.0864258e-002,9.8266602e-003,8.3312988e-003,6.8664551e-003,6.8054199e-003,8.3618164e-003,8.1481934e-003,8.7585449e-003,8.6669922e-003,7.8125000e-003,8.2397461e-003,8.0261230e-003,7.5683594e-003,5.9509277e-003,5.7373047e-003,5.1879883e-003,5.4321289e-003,7.6599121e-003,7.8125000e-003,7.5988770e-003,7.0190430e-003,6.2866211e-003,6.0119629e-003,6.5917969e-003,5.5847168e-003,4.7302246e-003,3.4179688e-003,2.6855469e-003,3.5400391e-003,5.5236816e-003,6.5612793e-003,6.2561035e-003,5.4016113e-003,3.1127930e-003,3.6926270e-003,4.7607422e-003,6.0729980e-003,8.5449219e-003,8.1176758e-003,7.0495605e-003,7.3547363e-003,7.8125000e-003,9.2468262e-003,1.0681152e-002,1.0437012e-002,8.7890625e-003,7.4157715e-003,5.8288574e-003,5.9814453e-003,7.4768066e-003,8.0871582e-003,9.0332031e-003,9.2468262e-003,8.8500977e-003,9.3994141e-003,1.0223389e-002,1.0284424e-002,1.0437012e-002,9.9792480e-003,9.7045898e-003,1.0131836e-002,1.1199951e-002,1.1749268e-002,1.1627197e-002,1.1108398e-002,1.0070801e-002,9.9487305e-003,1.0406494e-002,1.0620117e-002,1.0650635e-002,9.0637207e-003,6.4392090e-003,5.0354004e-003,4.1503906e-003,4.9438477e-003,8.0871582e-003,8.9416504e-003,9.5520020e-003,9.2163086e-003,7.2326660e-003,6.9580078e-003,7.0800781e-003,7.5378418e-003,8.5449219e-003,7.8430176e-003,7.5683594e-003,7.5073242e-003,7.3547363e-003,8.5144043e-003,9.9792480e-003,1.0589600e-002,1.0589600e-002,9.2468262e-003,6.8054199e-003,5.8898926e-003,5.9204102e-003,7.2021484e-003,9.9792480e-003,1.0986328e-002,1.0894775e-002,9.7656250e-003,6.4697266e-003,5.6152344e-003,5.7067871e-003,6.6223145e-003,8.9111328e-003,8.3007813e-003,7.1716309e-003,6.4392090e-003,5.8593750e-003,7.2937012e-003,9.5825195e-003,1.0559082e-002,1.1108398e-002,1.0040283e-002,7.7819824e-003,7.4462891e-003,7.3242188e-003,7.0800781e-003,7.4462891e-003,7.0190430e-003,7.1716309e-003,8.4228516e-003,9.7045898e-003,1.0742188e-002,1.0803223e-002,9.5825195e-003,7.1716309e-003,6.1035156e-003,5.0659180e-003,6.4392090e-003,8.6364746e-003,8.7585449e-003,8.6669922e-003,7.9345703e-003,6.3781738e-003,6.0424805e-003,5.7678223e-003,6.1645508e-003,7.3852539e-003,7.8430176e-003,8.1176758e-003,7.6904297e-003,6.7749023e-003,6.7749023e-003,6.6833496e-003,7.1716309e-003,8.2092285e-003,7.5988770e-003,6.5002441e-003,5.1574707e-003,3.6926270e-003,3.7841797e-003,4.8828125e-003,5.2795410e-003,5.6762695e-003,5.5236816e-003,4.0893555e-003,3.6926270e-003,3.5705566e-003,3.2043457e-003,3.1433105e-003,2.7770996e-003,2.3803711e-003,2.6245117e-003,3.5705566e-003,4.4555664e-003,5.1574707e-003,5.4016113e-003,5.0659180e-003,4.7912598e-003,4.4555664e-003,4.0588379e-003,4.2724609e-003,4.8522949e-003,5.3405762e-003,5.4016113e-003,5.3405762e-003,5.3100586e-003,4.9743652e-003,5.2795410e-003,5.5541992e-003,5.8898926e-003,6.1340332e-003,5.7373047e-003,5.5847168e-003,6.2866211e-003,7.2326660e-003,9.3688965e-003,1.0345459e-002,8.7890625e-003,6.5917969e-003,6.2866211e-003,6.6833496e-003,8.6975098e-003,1.1871338e-002,1.1077881e-002,9.3688965e-003,7.2937012e-003,4.1198730e-003,5.1269531e-003,7.5683594e-003,8.0871582e-003,8.6669922e-003,7.5378418e-003,5.3710938e-003,6.0729980e-003,6.5917969e-003,7.2021484e-003,9.0026855e-003,8.3312988e-003,7.1105957e-003,6.9885254e-003,6.8054199e-003,6.8969727e-003,7.6599121e-003,7.7514648e-003,8.1176758e-003,8.3312988e-003,7.6599121e-003,6.8969727e-003,5.7983398e-003,5.8898926e-003,6.6528320e-003,8.4228516e-003,1.0803223e-002,1.1016846e-002,1.0070801e-002,9.0942383e-003,7.6599121e-003,7.9345703e-003,8.9416504e-003,8.3007813e-003,7.8125000e-003,6.5307617e-003,5.0659180e-003,6.1645508e-003,7.6599121e-003,8.4228516e-003,9.2773438e-003,8.6669922e-003,7.2021484e-003,6.1035156e-003,6.1340332e-003,7.0495605e-003,7.8125000e-003,8.1787109e-003,8.3312988e-003,8.5144043e-003,7.7514648e-003,6.6833496e-003,5.2490234e-003,4.6386719e-003,5.2185059e-003,6.5002441e-003,8.5754395e-003,8.4838867e-003,7.4462891e-003,6.8359375e-003,5.9204102e-003,6.9885254e-003,8.8806152e-003,9.1857910e-003,8.7890625e-003,7.5073242e-003,5.2185059e-003,4.7607422e-003,4.8217773e-003,5.0354004e-003,5.2795410e-003,4.9438477e-003,4.3029785e-003,4.4250488e-003,4.8217773e-003,5.0354004e-003,5.2795410e-003,4.6386719e-003,4.2419434e-003,3.7231445e-003,3.9367676e-003,4.8217773e-003,5.4016113e-003,5.9204102e-003,5.7678223e-003,5.5847168e-003,4.5776367e-003,3.3874512e-003,2.2277832e-003,2.1057129e-003,2.9296875e-003,4.1809082e-003,6.1340332e-003,6.5002441e-003,5.7678223e-003,5.7373047e-003,4.9438477e-003,4.8522949e-003,5.3405762e-003,4.4860840e-003,2.8686523e-003,2.5329590e-003,2.6550293e-003,3.1433105e-003,3.7841797e-003,3.2348633e-003,2.4108887e-003,2.1667480e-003,1.7700195e-003,2.6245117e-003,3.8452148e-003,3.8452148e-003,3.8757324e-003,4.2724609e-003,4.8217773e-003,6.0424805e-003,7.2631836e-003,7.2021484e-003,7.0800781e-003,6.7138672e-003,5.9509277e-003,5.7678223e-003,5.5236816e-003,4.8828125e-003,4.6386719e-003,5.7067871e-003,7.3547363e-003,8.7280273e-003,9.7045898e-003,8.8500977e-003,7.1411133e-003,7.6904297e-003,9.3994141e-003,1.0925293e-002,1.3092041e-002,1.1108398e-002,7.4462891e-003,5.1879883e-003,3.5095215e-003,5.8288574e-003,1.0009766e-002,1.0528564e-002,1.0253906e-002,9.6435547e-003,7.2326660e-003,8.5449219e-003,1.0101318e-002,9.5214844e-003,9.5825195e-003,8.2092285e-003,6.5002441e-003,6.6528320e-003,7.5378418e-003,6.7138672e-003,5.9204102e-003,3.6926270e-003,9.7656250e-004,2.7160645e-003,4.6386719e-003,5.4321289e-003,6.0424805e-003,4.7302246e-003,2.0141602e-003,2.4108887e-003,2.8076172e-003,3.6926270e-003,5.2490234e-003,4.6081543e-003,2.4108887e-003,1.0070801e-003,9.7656250e-004,1.4953613e-003,2.9602051e-003,2.9296875e-003,2.3498535e-003,2.6550293e-003,2.9602051e-003,3.9672852e-003,5.2490234e-003,5.8898926e-003,6.1645508e-003,5.7373047e-003,5.6152344e-003,4.9743652e-003,4.3945313e-003,3.6621094e-003,2.3193359e-003,1.9836426e-003,1.9836426e-003,2.1057129e-003,1.8310547e-003,2.0446777e-003,1.5563965e-003,1.4343262e-003,1.1291504e-003,5.4931641e-004,2.7465820e-004,-6.4086914e-004,-1.2207031e-003,-2.1362305e-003,-2.1972656e-003,-2.6245117e-003,-2.0751953e-003,-2.2277832e-003,-2.8686523e-003,-2.0141602e-003,-2.0446777e-003,-1.4953613e-003,-1.4953613e-003,-1.4953613e-003,-2.0446777e-003,-2.1362305e-003,-2.8686523e-003,-3.1433105e-003,-1.5869141e-003,-1.6479492e-003,-1.3427734e-003,-1.5563965e-003,-1.8920898e-003,-1.7700195e-003,-1.4953613e-003,-1.2207031e-003,-1.4038086e-003,-1.5258789e-003,-1.8920898e-003,-1.4343262e-003,-8.5449219e-004,-1.2817383e-003,-1.6174316e-003,-2.3803711e-003,-3.2958984e-003,-3.5705566e-003,-3.3264160e-003,-2.7160645e-003,-2.2277832e-003,-2.3193359e-003,-3.0212402e-003,-3.4179688e-003,-3.0212402e-003,-2.5024414e-003,-1.9226074e-003,-2.4108887e-003,-3.0822754e-003,-2.9907227e-003,-2.7160645e-003,-1.3427734e-003,3.3569336e-004,7.6293945e-004,6.4086914e-004,4.5776367e-004,-5.1879883e-004,-5.4931641e-004,-2.4414063e-004,-8.2397461e-004,-1.3732910e-003,-1.4953613e-003,-1.5258789e-003,-4.8828125e-004,1.5869141e-003,2.3193359e-003,2.4414063e-003,2.2583008e-003,8.8500977e-004,1.1596680e-003,2.0446777e-003,2.0446777e-003,2.1667480e-003,1.6784668e-003,9.1552734e-005,1.4038086e-003,2.7160645e-003,4.1198730e-003,5.1574707e-003,3.7536621e-003,1.4953613e-003,9.7656250e-004,1.2207031e-003,2.5024414e-003,4.8522949e-003,5.5847168e-003,5.2490234e-003,5.2185059e-003,4.8522949e-003,4.9133301e-003,5.0659180e-003,4.6386719e-003,4.5776367e-003,4.5471191e-003,4.8828125e-003,5.2185059e-003,5.5847168e-003,5.1879883e-003,3.5705566e-003,2.9296875e-003,2.5634766e-003,2.4108887e-003,2.9602051e-003,2.3193359e-003,1.2817383e-003,6.1035156e-004,2.1362305e-004,9.4604492e-004,2.0446777e-003,2.2888184e-003,2.3498535e-003,1.7395020e-003,5.1879883e-004,9.4604492e-004,9.7656250e-004,3.6621094e-004,-5.4931641e-004,-5.4931641e-004,-7.0190430e-004,4.2724609e-004,2.4414063e-003,2.9602051e-003,3.2043457e-003,2.2888184e-003,3.0517578e-005,-7.9345703e-004,-3.6621094e-004,0.0000000e+000,1.5869141e-003,1.7395020e-003,9.4604492e-004,1.5258789e-003,7.6293945e-004,8.5449219e-004,1.8920898e-003,1.6784668e-003,1.1596680e-003,9.1552734e-004,1.4038086e-003,2.2583008e-003,3.3569336e-003,3.9672852e-003,4.2419434e-003,4.4860840e-003,4.2419434e-003,3.9672852e-003,3.0517578e-003,2.0446777e-003,1.3427734e-003,6.4086914e-004,1.0070801e-003,9.1552734e-004,1.4343262e-003,1.6174316e-003,9.1552734e-004,7.0190430e-004,2.7465820e-004,5.7983398e-004,1.0375977e-003,1.2512207e-003,1.2512207e-003,1.0375977e-003,1.1291504e-003,1.3427734e-003,1.3732910e-003,9.1552734e-004,3.0517578e-004,-3.0517578e-004,-5.4931641e-004,-5.7983398e-004,2.1362305e-004,4.5776367e-004,8.2397461e-004,9.7656250e-004,1.4648438e-003,2.1667480e-003,2.5329590e-003,2.7770996e-003,2.5024414e-003,2.7465820e-003,3.2653809e-003,3.7231445e-003,3.6621094e-003,3.2653809e-003,2.2888184e-003,2.5939941e-003,3.4179688e-003,4.2419434e-003,4.6081543e-003,5.0964355e-003,4.2114258e-003,2.9907227e-003,2.3193359e-003,2.9907227e-003,5.4626465e-003,6.7138672e-003,6.9885254e-003,6.4086914e-003,4.0893555e-003,3.3569336e-003,2.7770996e-003,2.5024414e-003,2.7770996e-003,2.0751953e-003,1.4648438e-003,1.3122559e-003,1.6479492e-003,2.0751953e-003,3.2958984e-003,3.2958984e-003,3.3874512e-003,3.6010742e-003,3.9062500e-003,3.6621094e-003,3.3874512e-003,3.4484863e-003,1.8615723e-003,1.5563965e-003,1.5258789e-003,1.6784668e-003,2.7160645e-003,3.4790039e-003,3.3569336e-003,3.9978027e-003,3.5095215e-003,3.9672852e-003,3.5095215e-003,3.0822754e-003,3.0517578e-003,2.7770996e-003,3.6926270e-003,3.7231445e-003,4.6691895e-003,4.5166016e-003,3.9367676e-003,3.0212402e-003,1.9226074e-003,1.4953613e-003,1.7700195e-003,1.3122559e-003,3.0517578e-004,1.5258789e-004,-3.9672852e-004,1.8310547e-004,7.0190430e-004,7.9345703e-004,-1.2207031e-004,-1.2207031e-004,-7.0190430e-004,-5.7983398e-004,6.7138672e-004,1.1291504e-003,2.1362305e-003,2.4414063e-003,1.4648438e-003,1.2817383e-003,6.4086914e-004,2.7465820e-004,5.4931641e-004,5.7983398e-004,1.5563965e-003,2.4719238e-003,3.5400391e-003,3.2043457e-003,2.1362305e-003,1.4648438e-003,6.7138672e-004,1.0070801e-003,2.5024414e-003,3.3264160e-003,3.3569336e-003,2.9907227e-003,1.6479492e-003,1.9531250e-003,2.2277832e-003,2.3498535e-003,3.3874512e-003,2.7465820e-003,2.3498535e-003,2.5939941e-003,2.7465820e-003,3.1738281e-003,3.3569336e-003,2.7160645e-003,1.4953613e-003,1.2817383e-003,1.2817383e-003,2.1057129e-003,2.6855469e-003,2.5329590e-003,1.1901855e-003,8.8500977e-004,3.0517578e-004,2.7465820e-004,5.1879883e-004,4.2724609e-004,8.8500977e-004,2.1667480e-003,2.6245117e-003,2.4414063e-003,4.8828125e-004,-9.4604492e-004,-2.1667480e-003,-1.3732910e-003,1.6784668e-003,3.0517578e-003,4.3334961e-003,2.2888184e-003,-1.9226074e-003,-2.7160645e-003,-2.6245117e-003,-2.0751953e-003,7.9345703e-004,-8.5449219e-004,-2.8991699e-003,-3.5400391e-003,-4.1809082e-003,-2.2277832e-003,4.5776367e-004,2.1362305e-004,-1.8920898e-003,-3.2958984e-003,-5.3405762e-003,-4.4250488e-003,-2.0446777e-003,-1.3732910e-003,-1.5258789e-004,-3.0517578e-005,-1.2817383e-003,-8.5449219e-004,-6.7138672e-004,-1.4038086e-003,-1.7700195e-003,-1.9226074e-003,-1.3122559e-003,3.3569336e-004,2.2583008e-003,2.0751953e-003,1.3122559e-003,3.9672852e-004,-1.2207031e-003,-1.8310547e-004,1.5258789e-003,1.6174316e-003,1.4038086e-003,1.5258789e-004,-2.4414063e-003,-2.1972656e-003,-1.7089844e-003,-1.2207031e-003,-2.7465820e-004,-7.3242188e-004,-1.8920898e-003,-2.0751953e-003,-2.3803711e-003,-2.2583008e-003,-1.2207031e-003,-9.7656250e-004,-1.2817383e-003,-3.6621094e-004,5.4931641e-004,3.9672852e-004,8.8500977e-004,1.0986328e-003,1.1291504e-003,1.5563965e-003,1.8005371e-003,1.6784668e-003,1.3122559e-003,1.5258789e-003,1.6479492e-003,2.0446777e-003,2.2583008e-003,1.1291504e-003,1.8310547e-004,-6.4086914e-004,-9.1552734e-004,-9.4604492e-004,-3.6621094e-004,-5.4931641e-004,-1.3732910e-003,-2.5939941e-003,-4.2114258e-003,-4.4555664e-003,-4.4250488e-003,-4.7607422e-003,-5.0354004e-003,-5.3710938e-003,-5.7678223e-003,-5.2795410e-003,-4.8828125e-003,-4.4250488e-003,-4.1198730e-003,-4.1198730e-003,-4.5776367e-003,-5.1879883e-003,-5.3100586e-003,-5.6457520e-003,-5.0659180e-003,-4.9438477e-003,-4.6081543e-003,-4.4250488e-003,-4.6997070e-003,-5.0659180e-003,-6.3171387e-003,-6.6833496e-003,-7.0495605e-003,-7.1411133e-003,-7.0190430e-003,-7.1411133e-003,-6.8054199e-003,-6.1035156e-003,-5.0354004e-003,-5.0354004e-003,-5.1879883e-003,-4.4860840e-003,-5.4931641e-003,-5.7373047e-003,-5.1879883e-003,-4.4860840e-003,-3.3569336e-003,-3.1738281e-003,-3.4179688e-003,-3.4179688e-003,-3.8757324e-003,-2.9296875e-003,-2.4414063e-003,-2.5939941e-003,-3.3874512e-003,-4.6997070e-003,-6.2561035e-003,-6.8359375e-003,-6.4697266e-003,-6.1340332e-003,-4.8217773e-003,-4.7302246e-003,-4.9743652e-003,-5.8898926e-003,-7.4157715e-003,-9.0332031e-003,-1.0314941e-002,-1.0589600e-002,-9.0942383e-003,-7.7209473e-003,-6.0119629e-003,-5.1879883e-003,-5.5541992e-003,-5.9509277e-003,-7.0190430e-003,-6.4697266e-003,-5.9204102e-003,-5.8288574e-003,-5.9509277e-003,-6.8969727e-003,-7.5378418e-003,-6.9885254e-003,-6.4392090e-003,-5.9814453e-003,-5.4626465e-003,-5.6762695e-003,-6.1340332e-003,-6.1950684e-003,-6.0424805e-003,-5.3100586e-003,-4.6386719e-003,-4.7302246e-003,-4.7912598e-003,-4.3945313e-003,-4.1198730e-003,-3.1127930e-003,-2.7160645e-003,-2.9907227e-003,-2.5939941e-003,-3.1127930e-003,-2.9907227e-003,-2.0141602e-003,-2.7465820e-004,3.0517578e-005,0.0000000e+000,-1.1596680e-003,-3.1433105e-003,-3.1738281e-003,-2.9907227e-003,-2.4719238e-003,-1.5258789e-003,-2.1972656e-003,-3.5400391e-003,-4.0893555e-003,-5.2185059e-003,-5.0048828e-003,-4.0588379e-003,-3.7536621e-003,-3.6926270e-003,-4.1809082e-003,-5.3710938e-003,-5.7983398e-003,-5.9814453e-003,-6.0424805e-003,-4.9133301e-003,-4.3945313e-003,-3.6926270e-003,-3.3264160e-003,-3.1738281e-003,-3.6010742e-003,-4.3945313e-003,-4.4860840e-003,-4.5166016e-003,-3.7841797e-003,-2.7465820e-003,-2.8381348e-003,-3.2958984e-003,-3.1738281e-003,-3.9367676e-003,-3.6010742e-003,-2.8076172e-003,-2.8686523e-003,-3.1127930e-003,-4.1198730e-003,-5.4931641e-003,-5.8898926e-003,-5.6762695e-003,-4.8522949e-003,-3.0212402e-003,-2.2277832e-003,-1.6479492e-003,-1.0070801e-003,-2.1362305e-003,-1.5563965e-003,-1.5258789e-003,-1.7700195e-003,-1.1901855e-003,-7.0190430e-004,-5.7983398e-004,-5.1879883e-004,-5.4931641e-004,-1.0375977e-003,-1.1596680e-003,-1.0681152e-003,-1.4343262e-003,-1.9836426e-003,-2.5329590e-003,-2.6550293e-003,-2.0751953e-003,-1.3122559e-003,-3.3569336e-004,-3.0517578e-005,6.1035156e-005,-2.7465820e-004,-4.5776367e-004,-3.6621094e-004,-8.2397461e-004,-9.1552734e-004,-1.2817383e-003,-1.1291504e-003,-4.2724609e-004,1.0986328e-003,2.4108887e-003,2.8991699e-003,2.3803711e-003,2.0751953e-003,1.8005371e-003,1.7395020e-003,2.5329590e-003,1.8005371e-003,1.3427734e-003,4.5776367e-004,-9.1552734e-004,-7.9345703e-004,-7.6293945e-004,-7.3242188e-004,-1.4343262e-003,-2.2583008e-003,-3.5095215e-003,-3.0517578e-003,-1.9226074e-003,-7.3242188e-004,4.5776367e-004,0.0000000e+000,-9.1552734e-004,-1.0070801e-003,-1.5258789e-003,-1.2817383e-003,-6.1035156e-005,-7.3242188e-004,-1.8920898e-003,-2.6855469e-003,-2.3193359e-003,-1.7089844e-003,-9.4604492e-004,-2.7465820e-004,6.1035156e-005,4.5776367e-004,5.7983398e-004,1.2817383e-003,1.0070801e-003,1.5258789e-004,-5.4931641e-004,-1.4038086e-003,-9.7656250e-004,2.7465820e-004,2.2583008e-003,3.1433105e-003,3.6010742e-003,3.2348633e-003,2.0751953e-003,2.2583008e-003,3.0212402e-003,3.2348633e-003,4.0283203e-003,3.9062500e-003,3.4484863e-003,3.9062500e-003,3.7231445e-003,4.0283203e-003,4.2114258e-003,3.2958984e-003,1.5258789e-003,6.4086914e-004,2.1362305e-004,-3.6621094e-004,-1.5258789e-004,-7.3242188e-004,-1.3427734e-003,-1.7089844e-003,-2.2583008e-003,-2.6855469e-003,-3.2043457e-003,-4.2724609e-003,-4.8828125e-003,-4.8828125e-003,-4.5776367e-003,-4.3334961e-003,-3.7536621e-003,-4.3334961e-003,-5.6152344e-003,-5.7373047e-003,-6.3476563e-003,-5.7678223e-003,-4.7302246e-003,-4.7912598e-003,-5.7983398e-003,-5.0659180e-003,-4.8522949e-003,-4.5166016e-003,-3.7231445e-003,-4.1809082e-003,-4.3334961e-003,-5.0964355e-003,-5.8898926e-003,-5.2185059e-003,-3.9978027e-003,-3.5705566e-003,-2.9907227e-003,-2.9296875e-003,-3.7231445e-003,-3.1433105e-003,-2.4108887e-003,-2.6855469e-003,-2.4719238e-003,-2.9907227e-003,-4.0283203e-003,-3.8757324e-003,-3.3264160e-003,-2.1972656e-003,-7.3242188e-004,-1.0986328e-003,-1.4953613e-003,-1.8615723e-003,-2.5024414e-003,-1.7395020e-003,2.7465820e-004,7.0190430e-004,7.6293945e-004,-2.7465820e-004,-2.5634766e-003,-2.4108887e-003,-1.8310547e-003,-9.1552734e-004,4.2724609e-004,1.8310547e-004,-1.0070801e-003,-1.5869141e-003,-2.4719238e-003,-2.3193359e-003,-8.2397461e-004,-3.6621094e-004,7.9345703e-004};
const int tailsamplelen = 33642;

SplashSampleObj::SplashSampleObj()
{
m_headstate = 0;
m_tailstate = 0;
m_fs=samplesFS;
m_elapsed_time=0.0;
m_headtrigger_time=0.0;
m_tailtrigger_time=0.0;

m_headsize=headsamplelen;
m_tailsize=tailsamplelen;

m_headwavbuffer=(double *)&headsample[0]; // ATT: da normalizzare per 36000?

m_tailwavbuffer=(double *)&tailsample[0]; // ATT: da normalizzare per 36000?

m_headfileind=0;
m_tailfileind=0;

}

SplashSampleObj::~SplashSampleObj()
{
;
}

void SplashSampleObj::headStart()
{
m_headstate=1;
m_headfileind=0;
}

void SplashSampleObj::tailStart()
{
m_tailstate=1;
m_tailfileind=0;
}

void SplashSampleObj::headStop()
{
m_headstate=0;
m_headfileind=0;
}

void SplashSampleObj::tailStop()
{
m_tailstate=0;
m_tailfileind=0;
}


void SplashSampleObj::buffertick(int n, float amplhead, float ampltail, float* outbuffer)
{
double out;
while(n--)
{   
	m_elapsed_time+=1.0/m_fs;       
	if((m_elapsed_time<=m_headtrigger_time)&&(m_elapsed_time>m_headtrigger_time-1.0/m_fs))
		m_headstate=1;
	if((m_elapsed_time<=m_tailtrigger_time)&&(m_elapsed_time>m_tailtrigger_time-1.0/m_fs))
		m_tailstate=1;
	
	*outbuffer++=m_headstate*amplhead*m_headwavbuffer[m_headfileind]+m_tailstate*ampltail*m_tailwavbuffer[m_tailfileind];
	
	m_headfileind+=m_headstate;
	m_tailfileind+=m_tailstate;
	
	if(m_headfileind>=(m_headsize-1)){
  m_headstate=0;
  m_headfileind=0;
}

	if(m_tailfileind>=(m_tailsize-1)){
  m_tailstate=0;
  m_tailfileind=0;
}

}//while
}
    
void SplashSampleObj::set_headreltriggerInstant(double timeinsec){
m_headtrigger_time = m_elapsed_time+timeinsec;
}

void SplashSampleObj::set_tailreltriggerInstant(double timeinsec){
m_tailtrigger_time = m_elapsed_time+timeinsec;
}


int SplashSampleObj::getheadSize()
{
return m_headsize;
}

int SplashSampleObj::gettailSize()
{
return m_tailsize;
}
