#!/usr/bin/perl -w
# vi:set nowrap ts=4:
#
# $Id: table_maker.pl,v 0.7 2002/09/18 14:14:18 nicb Exp $
#
# This perl script has been designed to construct the roller_tables.c files
# It was written in blind-mode by Nicola Bernardini (nicb@centrotemporeale.it)
# under directions given by Davide Rocchesso (rocchesso@sci.univr.it)
#
use strict;
use Math::Trig;

use Roller;
#
# main function is at the bottom
#
sub head($$$)
{
	my ($name, $rev, $table_size) = @_;

	printf("/*\n * DO NOT EDIT this file!\n * It has been created automatically\n * by %s, (%s)\n */\n\n#include <m_pd.h>\n", $name, $rev);
	printf("\n\nconst double roller_rate_default = %.1f;\n", 1000/$Roller::Fs);
	printf("const t_int roller_default_table_size = %d;\n\n", $table_size);
	printf("const t_float roller_default_inc_x = %08.6f; /* x increment in shape table */ \n", $Roller::inct);
	printf("const t_float roller_default_pmax = %08.6f;\n", $Roller::tmax); 
	printf("const t_float roller_gravity = %08.6f;\n\n", $Roller::gravity); 
}
sub tail()
{
}
sub table_head($$)
{
	my ($name, $type) = @_;

	printf("%s %s[] =\n{\n", $type, $name);
}
sub table_tail()
{
	printf("};\n\n");
}
sub output_table($$)
{
	my ($r_table, $name) = @_;
	my $cols = 5;
	my $end = scalar(@{$r_table});

	table_head($name, "const t_float");

	for (my $i = 0; $i < $end; $i += $cols)
	{
		print "\t";
		for (my $j = 0; $j < $cols && ($i+$j) < $end; ++$j)
		{
			printf("%+08.5f, ", $r_table->[$i+$j]);
		}
		print "\n";
	}

	table_tail();
}
#
# main
#

	my $index      = Roller::build_index($Roller::tmax, $Roller::inct);
	my $parametric = Roller::build_parametric($index, $Roller::tdipmax);
	my $pincs      = Roller::build_pinc($index, $parametric);
	my $p          = Roller::build_p($pincs);
	my $pslopes    = Roller::build_pslope($index, $parametric);
	my $sigma      = Roller::build_sigma($pslopes, $Roller::gravity);
	my $ptilde     = Roller::build_ptilde($p, $sigma, $Roller::h, $Roller::damping);

	head('$RCSfile: table_maker.pl,v $', '$Revision: 0.7 $', scalar(@{$sigma}));

	output_table($sigma, "roller_default_sigma");
	output_table($ptilde, "roller_default_ptilde");

	tail();
#
# end of main
#
