/*
 * vi:set ts=4 nowrap:
 * PD is Copyright (c) 1997-2002 Miller Puckette.
 *
 * $Id: roller.h,v 0.5 2002/09/24 06:24:26 roc Exp $
 *
 * Copyright 2002 Nicola Bernardini (nicb@centrotemporeale.it)
 *
 * The  pd  modules  contained herein are the result of a joint effort from
 * several authors in the context of the IST-FET Disappearing Computer pro-
 * active    project    called    SOb   (Sound   Object)   (IST-2000-25287,
 * http://www.soundobject.org)  at  the   University   of   Verona,   Italy
 * (http://www.univr.it).
 *
 * The main author of the modules is Matthias Rath (rath@sci.univr.it).
 *
 * Other authors (either writers or designers) are:
 *
 * Davide Rocchesso (rocchesso@sci.univr.it)
 * Federico Fontana (fontana@sci.univr.it)
 * Laura Ottaviani (ottavian@sci.univr.it)
 * Gianpaolo Borin (gianpaolo.borin@tin.it)
 * Federico Avanzini (avanzini@dei.unipd.it)
 * Nicola Bernardini (nicb@centrotemporeale.it)
 *
 * This file is part of the SOb PD modules.
 *
 * The  SOb  PD modules are free software; you can redistribute them and/or
 * modify them under the  terms  of  the  GNU  General  Public  License  as
 * published   by   the  Free Software  Foundation;  either  version  2  of
 * the  License, or (at your option) any later version.
 *
 * The SOb PD modules are distributed in the hope that it will be   useful,
 * but   WITHOUT  ANY   WARRANTY;   without   even  the implied warranty of
 * MERCHANTABILITY or FITNESS  FOR  A  PARTICULAR  PURPOSE.   See  the  GNU
 * General  Public  License for more details.
 *
 * You  should have received a copy of the GNU General Public License along
 * with the SOb PD modules; if not, write to the Free  Software  Foundation,
 * Inc.,  59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 */

#if !defined(_sob_roller_h_)
#	define _sob_roller_h_

#include "m_pd.h"

typedef struct
{
	t_int	size;
	size_t	allocated_bytes;
	t_float *sigma;
	t_float *ptilde;
} roller_tables;

typedef struct
{
	t_float p;
        t_float v_rad;         /* radial component of velocity */
        t_float v_tan;         /* tangential component of velocity */
	t_float sigma;
	t_float ptilde;
	t_float x_push;        /* x and y push coordinates */
	t_float y_push;
        t_float z_push;        /* z depth of pushing */
	t_float x_pos;         /* x and y position coordinates */
	t_float y_pos;
	t_float x_vel;         /* x and y velocity coordinates */
	t_float y_vel;
        t_float u_x;
        t_float u_y;           /* unit vector along direction pos->push */

} roller_state;

typedef struct _roller
{
  t_object		x_obj;
  t_clock		*x_clock;
  t_outlet		*pos_outlet;
  t_outlet		*vel_outlet;
  t_outlet		*x_pos_outlet;
  t_outlet		*y_pos_outlet;
  t_outlet		*tan_vel_outlet;
  t_int			on_off;		/* on_off == 0 = off, on_off != 0 = on */
  t_float		damping;
  double		rate;		/* rate and h are related but we want to */
  t_float		h;			/* have both variables for efficiency    */
  t_float               flag;           /* left or right of median point (pushing point) */
  roller_state	state;
  roller_tables	tables;
} t_roller;

void roller_free_table_memory(t_roller *x);
void roller_tables_reset(t_roller *x);
void roller_tables_set(t_roller *x, t_symbol *s);
void roller_plot(t_roller *x);

#endif /* !defined(_sob_roller_h_) */
